<?php

namespace App\Http\Controllers\Api\Verify\DistributorsManages;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyDispatchingBillsController extends Controller
{
    // 详情验证器
    public function detailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'debw_id.required' => '参数错误',
            'debw_id.integer' => '参数类型错误',
            'debw_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'debw_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 备注验证器
    public function remarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'debw_id.required' => '参数错误',
            'debw_id.integer' => '参数类型错误',
            'debw_id.min' => '参数错误',
            'remark.required' => '参数错误',
            'remark.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'debw_id' => 'required|integer|min:1',
            'remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
    // 配送账单列表详情配送状态修改
    public function shipmentStateShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'debw_id.required' => '参数错误',
            'debw_id.integer' => '参数类型错误',
            'debw_id.min' => '参数类型错误',
            'type.required'=>'参数类型错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'debw_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 配送账单列表详情配送状态修改
    public function shipmentStateValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'degw_id.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'degw_id' => 'array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 配送账单送货单列表
    public function deliveryListValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dewd_id.required' => '参数错误',
            'dewd_id.integer' => '参数类型错误',
            'dewd_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dewd_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 配送账单送货单列表
    public function deliveryDetailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'derw_id.required' => '参数错误',
            'derw_id.integer' => '参数类型错误',
            'derw_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'derw_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 送货单备注验证器
    public function deliveryRemarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'derw_id.required' => '参数错误',
            'derw_id.integer' => '参数类型错误',
            'derw_id.min' => '参数错误',
            'remark.required' => '参数错误',
            'remark.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'derw_id' => 'required|integer|min:1',
            'remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 配送账单送货单列表新增送货单获取信息
    public function deliveryAddShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'debw_id.required' => '参数错误',
            'debw_id.integer' => '参数类型错误',
            'debw_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'debw_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 配送账单送货单列表新增送货单
    public function deliveryAddValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'degw_id.required' => '参数错误',
            'degw_id.array' => '参数类型错误',
            'quantity.required' => '参数错误',
            'quantity.array' => '参数类型错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'degw_id' => 'required|array',
            'quantity' => 'required|array',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 账单确认
    public function affirmValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'debw_id.required' => '参数错误',
            'debw_id.integer' => '参数类型错误',
            'debw_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'debw_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 账单撤回确认
    public function recallValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'debw_id.required' => '参数错误',
            'debw_id.integer' => '参数类型错误',
            'debw_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'debw_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 账单撤回确认
    public function detailsRevocationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'derw_id.required' => '参数错误',
            'derw_id.integer' => '参数类型错误',
            'derw_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'derw_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 账单撤回确认
    public function deliveryEditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'drgw_id.required' => '参数错误',
            'drgw_id.array' => '参数类型错误',
            'amount.required' => '参数错误',
            'amount.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'drgw_id' => 'required|array',
            'amount' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
