<?php
namespace App\Http\Controllers\Api\Verify\ChannelManage;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyVisitListsController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vis_name.required' => '请输入:名称',
            'vis_name.max' => '名称超过最大限制',
            'vis_executor_adm_id.required' => '请输入:业务员',
            'vis_executor_adm_id.integer' => '参数类型错误',
            'vis_executor_adm_id.min' => '参数错误',
            'vis_visvity_nature.required' => '参数错误',
            'vis_visvity_nature.in' => '参数错误',

            'info_name.required' => '参数错误',
            'info_name.array' => '参数类型错误',
            'info_required.required' => '参数错误',
            'info_required.array' => '参数类型错误',
            'info_type.required' => '参数错误',
            'info_type.array' => '参数类型错误',
            'info_show.required' => '参数错误',
            'info_show.array' => '参数类型错误',
            'info_tips.required' => '参数错误',
            'info_tips.array' => '参数类型错误',

            'vicl_chun_id.required' => '参数错误',
            'vicl_chun_id.array' => '参数类型错误',
            'vicl_plan_quantity.required' => '参数错误',
            'vicl_plan_quantity.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vis_name' => 'required|max:50',
            'vis_executor_adm_id' => 'required|integer|min:1',
            'vis_visvity_nature' => [
                'required',
                Rule::in(['1', '2']),
            ], //性质1一次性2周期性

            'info_name' => 'required|array',
            'info_required' => 'required|array',
            'info_type' => 'required|array',
            'info_show' => 'required|array',
            'info_tips' => 'required|array',

            'vicl_chun_id' => 'required|array',
            'vicl_plan_quantity' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑页面查看验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'vis_id.required' => '参数错误',
            'vis_id.integer' => '参数错误',
            'vis_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ], //1页面展示数据2提交
            'vis_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 删除验证器
    public function deleteValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vis_id.required' => '参数错误',
            'vis_id.integer' => '参数类型错误',
            'vis_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vis_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 行驶路线验证器
    public function runningRouteValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vire_id.required' => '参数错误',
            'vire_id.integer' => '参数错误',
            'vire_id.min' => '参数错误',
            'vire_executor_adm_id.required' => '参数错误',
            'vire_executor_adm_id.integer' => '参数错误',
            'vire_executor_adm_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vire_id' => 'required|integer|min:1',
            'vire_executor_adm_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
