<?php
namespace App\Http\Controllers\Api\Verify\ChannelManage;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyDistirbutionListsController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
            'pri_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 处理验证器
    public function disposeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dist_id.required' => '参数错误',
            'dist_id.integer' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dist_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
