<?php

namespace App\Http\Controllers\Api\Verify\ChannelManage;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyChannelUnitController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chun_unit_name.required' => '请输入:客户单位名称',
            'chun_unit_name.max' => '客户单位名称长度超过最大限制',
            // 'chun_search_letter.required' => '请输入:检索字母',
            // 'chun_search_letter.max' => '检索字母长度超过最大限制',
            // 'chun_search_letter.alpha' => '请输入字母',
            // 'info_name.required' => '请输入:联系人姓名',
            'info_name.max' => '联系人姓名长度超过最大限制',
            // 'info_content.required' => '请输入:联系电话',
            // 'info_content.regex' => '手机号格式不正确',
            'chun_chty_id.required' => '请选择单位类型',
            'chun_chty_id.integer' => '参数类型错误',
            'chun_chty_id.min' => '参数错误',
            // 'chun_payment_way.required' => '请选择结算方式',
            // 'chun_payment_way.in' => '参数错误',
            // 'chun_province.required' => '请输入:省',
            'chun_province.max' => '省长度超过最大限制',
            // 'chun_city.required' => '请输入:市',
            'chun_city.max' => '市长度超过最大限制',
            // 'chun_county.required' => '请输入:区县',
            'chun_county.max' => '区县长度超过最大限制',
            // 'chun_address.required' => '请输入:详细地址',
            'chun_address.max' => '详细地址长度超过最大限制',
            // 'chin_level.required' => '请输入:客户等级',
            // 'chin_level.max' => '客户等级长度超过最大限制',
            // 'chin_main_brand.required' => '请输入:主营品牌',
            // 'chin_main_brand.max' => '主营品牌长度超过最大限制',
            // 'chin_second_brand.required' => '请输入:次营品牌',
            // 'chin_second_brand.max' => '次营品牌长度超过最大限制',
            // 'chin_owe_day.required' => '请输入:可欠天数',
            // 'chin_owe_day.integer' => '参数类型错误',
            // 'chin_owe_day.min' => '参数错误',
            // 'chin_caution_day.required' => '请输入:警示天数',
            // 'chin_caution_day.integer' => '参数类型错误',
            // 'chin_caution_day.min' => '参数错误',
            // 'chin_owe_money.required' => '请输入:可欠金额',
            // 'chin_owe_money.min' => '参数错误',
            // 'chun_adm_id.required' => '请选择业务员',
            'chun_adm_id.integer' => '参数类型错误',
            'chun_adm_id.min' => '参数错误',
            // 'chin_longitude.required' => '参数错误',
            // 'chin_latitude.required' => '参数错误',
            // 'chin_prec_id.required' => '请选择业务划区',
            // 'chin_prec_id.integer' => '参数类型错误',
            // 'chin_prec_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chun_unit_name' => 'required|max:50',
            // 'chun_search_letter' => 'required|alpha|max:30',
            // 'chun_search_letter' => 'required|max:30',
            // 'info_name' => 'required|max:10',
            // 'info_content' => ['required','regex:/^1[3456789]\d{9}$/'],
            // 'chun_chty_id' => 'required|integer|min:1',
            // 'chun_payment_way' => [
            //     'required',
            //     Rule::in(['1', '2']),
            // ], //结算方式为1或者2
            // 'chun_province' => 'required|max:50',
            // 'chun_city' => 'required|max:50',
            // 'chun_county' => 'required|max:50',
            // 'chun_address' => 'required|max:200',
            // 'chin_level' => 'required|max:1',
            // 'chin_main_brand' => 'sometimes|max:100',
            // 'chin_second_brand' => 'sometimes|max:100',
            // 'chin_owe_day' => 'sometimes|integer|min:0',
            // 'chin_caution_day' => 'required|integer|min:0',
            // 'chin_owe_money' => 'sometimes|min:0',
            // 'chun_adm_id' => 'required|integer|min:1',
            // 'chin_longitude' => 'required',
            // 'chin_latitude' => 'required',
            // 'chin_prec_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑页面查看验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chun_id.required' => '参数错误',
            'chun_id.integer' => '参数错误',
            'chun_id.min' => '参数错误',
            'chun_unit_name.required' => '请输入:客户单位名称',
            'chun_unit_name.max' => '客户单位名称长度超过最大限制',
            'chun_search_letter.required' => '请输入:检索字母',
            'chun_search_letter.max' => '检索字母长度超过最大限制',
            // 'chun_search_letter.alpha' => '请输入字母',
            'info_name.required' => '请输入:联系人姓名',
            'info_name.max' => '联系人姓名长度超过最大限制',
            // 'info_content.required' => '请输入:联系电话',
            // 'info_content.regex' => '手机号格式不正确',
            // 'chun_chty_id.required' => '请选择单位类型',
            // 'chun_chty_id.integer' => '参数类型错误',
            // 'chun_chty_id.min' => '参数错误',
            // 'chun_payment_way.required' => '请选择结算方式',
            // 'chun_payment_way.in' => '参数错误',
            'chun_province.required' => '请输入:省',
            'chun_province.max' => '省长度超过最大限制',
            'chun_city.required' => '请输入:市',
            'chun_city.max' => '市长度超过最大限制',
            'chun_county.required' => '请输入:区县',
            'chun_county.max' => '区县长度超过最大限制',
            'chun_address.required' => '请输入:详细地址',
            'chun_address.max' => '详细地址长度超过最大限制',
            // 'chin_level.required' => '请输入:客户等级',
            // 'chin_level.max' => '客户等级长度超过最大限制',
            // 'chin_main_brand.required' => '请输入:主营品牌',
            // 'chin_main_brand.max' => '主营品牌长度超过最大限制',
            // 'chin_second_brand.required' => '请输入:次营品牌',
            // 'chin_second_brand.max' => '次营品牌长度超过最大限制',
            // 'chin_owe_day.required' => '请输入:可欠天数',
            // 'chin_owe_day.integer' => '参数类型错误',
            // 'chin_owe_day.min' => '参数错误',
            // 'chin_caution_day.required' => '请输入:警示天数',
            // 'chin_caution_day.integer' => '参数类型错误',
            // 'chin_caution_day.min' => '参数错误',
            // 'chin_owe_money.required' => '请输入:可欠金额',
            // 'chin_owe_money.min' => '参数错误',
            'chun_adm_id.required' => '请选择业务员',
            'chun_adm_id.integer' => '参数类型错误',
            'chun_adm_id.min' => '参数错误',
            'chin_longitude.required' => '参数错误',
            'chin_latitude.required' => '参数错误',
            // 'chin_prec_id.required' => '请选择业务划区',
            // 'chin_prec_id.integer' => '参数类型错误',
            // 'chin_prec_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chun_id' => 'required|integer|min:1',
            'chun_unit_name' => 'required|max:50',
            // 'chun_search_letter' => 'required|alpha|max:30',
            // 'chun_search_letter' => 'required|max:30',
            // 'info_name' => 'required|max:10',
            // 'info_content' => ['required','regex:/^1[3456789]\d{9}$/'],
            // 'chun_chty_id' => 'required|integer|min:1',
            // 'chun_payment_way' => [
            //     'required',
            //     Rule::in(['1', '2']),
            // ], //结算方式为1或者2
            // 'chun_province' => 'required|max:50',
            // 'chun_city' => 'required|max:50',
            // 'chun_county' => 'required|max:50',
            // 'chun_address' => 'required|max:200',
            // 'chin_level' => 'required|max:1',
            // 'chin_main_brand' => 'sometimes|max:100',
            // 'chin_second_brand' => 'sometimes|max:100',
            // 'chin_owe_day' => 'sometimes|integer|min:0',
            // 'chin_caution_day' => 'required|integer|min:0',
            // 'chin_owe_money' => 'sometimes|min:0',
            // 'chun_adm_id' => 'sometimes|integer|min:1',
            // 'chin_longitude' => 'required',
            // 'chin_latitude' => 'required',
            // 'chin_prec_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chun_id.required' => '参数错误',
            'chun_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chun_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 导入验证器
    public function leadValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'file.required' => '请上传文件',
            'file.file' => '请上传文件',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'file' => 'required|file',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 合并验证器
    public function mergeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chun_id.required' => '参数错误',
            'chun_id.int' => '参数错误',
            'chun_more_id.required' => '参数错误',
            'chun_more_id.int' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chun_id' => 'required|int',
            'chun_more_id' => 'required|int',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 查看验证器
    public function detailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chun_id.required' => '参数错误',
            'chun_id.int' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chun_id' => 'required|int',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
    //搜索商品验证器
    public function searchGoodsListValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chun_id.required' => '参数错误',
            'chun_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chun_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //查询商品列表验证器
    public function searchAddChannelGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.integer' => '数据类型不正确',
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '数据类型不正确',
            'chun_id.required' => '参数错误',
            'chun_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => 'required|integer',
            'chun_id' => 'sometimes|required|integer|min:0',
            'goo_id' => 'sometimes|required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
