<?php
namespace App\Http\Controllers\Api\Verify\AfterSaleManage;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;

class VerifyAfterLabelController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'afla_name.required' => '请输入:售后标签名称',
            'afla_name.max' => '售后标签名称长度超过最大限制',
            'afla_parent_id.required' => '请选择隶属上级',
            'afla_parent_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'afla_name' => 'required|max:10',
            'afla_parent_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'afla_id.required' => '参数错误',
            'afla_id.integer' => '参数错误',
            'afla_name.required' => '请输入:售后标签名称',
            'afla_name.max' => '售后标签名称长度超过最大限制',
            'afla_parent_id.required' => '请选择隶属上级',
            'afla_parent_id.integer' => '参数类型错误',
            'afla_parent_id.different' => '请选择其他售后标签名称',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'afla_id' => 'required|integer',
            'afla_name' => 'required|max:10',
            'afla_parent_id' => 'required|integer|different:afla_id',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'afla_id.required' => '参数错误',
            'afla_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'afla_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
