<?php
namespace App\Http\Controllers\Api\Verify\ActivityManagements;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyActivityListsController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
            'pri_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 发布验证器
    public function deliveryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acti_id.required' => '参数错误',
            'acti_id.integer' => '数据类型不正确',
            'acti_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acti_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 删除验证器
    public function deleteValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acti_id.required' => '参数错误',
            'acti_id.integer' => '数据类型不正确',
            'acti_id.integer' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acti_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acti_name.required' => '请输入活动名称',
            'acti_name.max' => '活动名称长度超过最大限制',
            'acti_activity_nature.required' => '请选择活动性质',
            'acti_activity_nature.in' => '参数类型错误',
            'acti_activity_type.required' => '请选择活动类型',
            'acti_activity_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acti_name' => 'required|max:50',
            'acti_activity_nature' => [
                'required',
                Rule::in(['1', '2']),
            ],// 活动性质：1一次性2周期性
            'acti_activity_type' => [
                'required',
                Rule::in(['1', '2', '3', '4', '5', '6', '7', '8']),
            ],// 活动类型：1折扣2买送3买赠4满减5现结折扣6累计返点7高价回收8大批量采购
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acdo_row.required' => '参数错误',
            'acdo_row.array' => '参数类型错误',
            'acdi_discount.required' => '参数错误',
            'acdi_discount.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acdo_row' => 'required|array',
            'acdi_discount' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑查看验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acti_id.required' => '参数错误',
            'acti_id.integer' => '参数类型错误',
            'acti_id.min' => '参数错误',
            'type.required' => '请选择活动性质',
            'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acti_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],// 活动性质：1一次性2周期性
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acti_name.required' => '请输入活动名称',
            'acti_name.max' => '活动名称长度超过最大限制',
            'acti_activity_nature.required' => '请选择活动性质',
            'acti_activity_nature.in' => '参数类型错误',
            'acti_activity_type.required' => '请选择活动类型',
            'acti_activity_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acti_name' => 'required|max:50',
            'acti_activity_nature' => [
                'required',
                Rule::in(['1', '2']),
            ],// 活动性质：1一次性2周期性
            'acti_activity_type' => [
                'required',
                Rule::in(['1', '2', '3', '4', '5', '6', '7', '8']),
            ],// 活动类型：1折扣2买送3买赠4满减5现结折扣6累计返点7高价回收8大批量采购
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 商品搜索验证器
    public function searchGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_type.required' => '请输入商品类型',
            'goo_type.in' => '商品类型参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_type' => [
                'required',
                Rule::in(['1', '2']),
            ], //商品类型 1正常商品2赠品商品
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 工作总台--查看活动详情验证器
    public function searchActivityDetailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acti_id.required' => '参数错误',
            'acti_id.integer' => '参数类型错误',
            'acti_id.min' => '参数错误',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acti_id' => 'required|integer|min:1',
            'goo_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
