<?php
namespace App\Http\Controllers\Api\Verify\AccountControl;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

// 凭证列表
class VerifyVoucherReceiptsController extends Controller
{
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '数据类型不正确',
            'pri_id.min' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vore_id.required' => '请输入权限id',
            'vore_id.integer' => '数据类型不正确',
            'vore_id.min' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vore_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    public function syncValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vore_id.required' => '请输入权限id',
            'vore_id.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vore_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
