<?php
namespace App\Http\Controllers\Api\Verify\AccountControl;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyNoteMessageController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 添加模板验证器
    public function addTemplateValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sete_name.required' => '参数错误',
            'sete_sign.required' => '参数错误',
            'sete_content.required' => '参数错误',
            'sete_number.required' => '参数错误',
            'sete_number.integer' => '参数错误',
            'sete_number.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sete_name' => 'required',
            'sete_sign' => 'required',
            'sete_content' => 'required',
            'sete_number' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 模板列表验证器
    public function listTemplateValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sete_name.required' => '参数错误',
            'sete_sign.required' => '参数错误',
            'sete_content.required' => '参数错误',
            'sete_number.required' => '参数错误',
            'sete_number.integer' => '参数错误',
            'sete_number.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sete_name' => 'required',
            'sete_sign' => 'required',
            'sete_content' => 'required',
            'sete_number' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑模板验证器
    public function editTemplateValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sete_name.required' => '参数错误',
            'sete_sign.required' => '参数错误',
            'sete_content.required' => '参数错误',
            'sete_number.required' => '参数错误',
            'sete_number.integer' => '参数错误',
            'sete_number.min' => '参数错误',
            'sete_id.required' => '参数错误',
            'sete_id.integer' => '参数错误',
            'sete_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sete_name' => 'required',
            'sete_sign' => 'required',
            'sete_content' => 'required',
            'sete_number' => 'required|integer|min:1',
            'sete_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 绑定
    public function bindingValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sete_id.required' => '参数错误',
            'sete_id.integer' => '参数错误',
            'sete_id.min' => '参数错误',
            'mode_id.required' => '参数错误',
            'mode_id.integer' => '参数错误',
            'mode_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sete_id' => 'required|integer|min:1',
            'mode_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 删除模板验证器
    public function deleteTemplateValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sete_id.required' => '参数错误',
            'sete_id.integer' => '参数错误',
            'sete_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sete_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用
    public function stopModuleValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mode_id.required' => '参数错误',
            'mode_id.integer' => '参数错误',
            'mode_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mode_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用
    public function startModuleValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mode_id.required' => '参数错误',
            'mode_id.integer' => '参数错误',
            'mode_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mode_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
