<?php

namespace App\Http\Controllers\Api\Verify\AccountControl;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyInitialBalanceController extends Controller
{
	 // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            // 'acib_id.required' => '参数错误',
            'acsu_id.required' => '参数错误',
            'acsu_id.integer' => '参数类型错误',
            // 'debtor_original_currency.required' => '参数错误',
            // 'creditor_original_currency.required' => '参数错误',
            // 'initial_original_currency.required' => '参数错误',
            'currtypecode.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            // 'acib_id' => 'required',
            'acsu_id' => 'required|integer',
            // 'debtor_original_currency' => 'required',
            // 'creditor_original_currency' => 'required',
            // 'initial_original_currency' => 'required',
            'currtypecode' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
