<?php

namespace App\Http\Controllers\Api\Verify\AccountControl;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyAccountingSettlementController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情查看验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acset_id.required' => '请输入结款明细id',
            'acset_id.integer' => '结款明细id数据类型不正确',
            'acset_id.min' => '结款明细id数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acset_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 核销验证器
    public function checkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acset_id.required' => '参数错误',
            'acset_id.integer' => '数据类型不正确',
            'acset_id.min' => '参数错误',
            'acset_with_time.required' => '请选择汇款时间',
            'acset_with_time.date' => '数据类型不正确',
            'acset_remark.sometimes' => '请输入备注',
            'acset_remark.max' => '备注字数超过长度限制',
            
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acset_id' => 'required|integer|min:1',
            'acset_with_time' => 'required|date',
            'acset_remark' => 'sometimes|max:255',

        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 取消核销验证器
    public function cancelCheckValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acset_id.required' => '参数错误',
            'acset_id.integer' => '数据类型不正确',
            'acset_id.min' => '参数错误',
            'acset_remark.sometimes' => '请输入备注',
            'acset_remark.max' => '备注字数超过长度限制',
            
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acset_id' => 'required|integer|min:1',
            'acset_remark' => 'sometimes|max:255',

        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 驳回验证器
    public function rejectValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acset_id.required' => '参数错误',
            'acset_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acset_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 同步U8验证器
    public function syncValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acset_id.required' => '参数错误',
            'acset_id.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acset_id' => 'required|array'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
