<?php

namespace App\Http\Controllers\Api\Verify\AccountControl;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyAccountTitleController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acti_subject_code.required' => '参数错误',
            'acti_subject_code.integer' => '参数类型错误',
            'acti_course_title.required' => '参数错误',
            'acti_course_title.max' => '科目名称超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acti_subject_code' => 'required|integer',
            'acti_course_title' => 'required|max:50',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acti_id.required' => '参数错误',
            'acti_id.integer' => '参数类型错误',
            'acti_id.min' => '参数错误',
            'acti_subject_code.required' => '参数错误',
            'acti_subject_code.integer' => '参数类型错误',
            'acti_course_title.required' => '参数错误',
            'acti_course_title.max' => '科目名称超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acti_id' => 'required|integer|min:1',
            'acti_subject_code' => 'required|integer',
            'acti_course_title' => 'required|max:50',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 停、启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acti_id.required' => '参数错误',
            'acti_id.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acti_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
