<?php
namespace App\Http\Controllers\Api\SystemsManage;

use App\Models\BasicManagement\Admin;
use App\Services\BasicManagement\RoleSetService;
use App\Services\CommonService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\SystemsManage\VerifyRoleSetController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

use function Complex\tan;

// 基础管理 -- 角色设置
class RoleSetController extends Controller
{


    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRoleSetController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $list_data = RoleSetService::getList($user_info, $request,$list_button);
        $buttonData_top[] = 'add';
        $buttonData_top[] = 'start';
        $buttonData_top[] = 'stop';
        $top_button = [];
        foreach ($list_button as $key => $value) {
            if (in_array($value['pri_operate_method'],$buttonData_top)) {
                $top_button[] = $value;
            }
        }
        if ($list_data['data']) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data, 'list_button'=>$list_button,'top_button'=>$top_button]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据', 'list_button'=>$list_button,'top_button'=>$top_button]);
        }
    }

    // 新增
    public function add(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRoleSetController;
        $error_message = $verify_data->addShowValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        if ($request['type'] == 1) {
            // 获取角色权限
            $role_info = DB::table('login_temporary')
                ->where('api_token', $request['api_token'])
                ->select('adm_id', 'role_auth')
                ->first();
            $role_auth = json_decode($role_info->role_auth, true);

            // 角色权限数据分类
            $privileges_info = $this->roleCategory($role_auth);
            $pri_id = DB::table('privileges')
                ->select('pri_id', 'pri_method_name')
                ->get()->toArray();
            if (!$privileges_info) {
                return response()->json(['code'=>500, 'msg'=>'角色权限数据获取失败', 'data'=>'']);
            } else {
                return response()->json(['code'=>200, 'msg'=>'角色权限数据获取成功', 'data'=>'角色权限数据获取成功', 'privileges_info'=>$privileges_info, 'pri_id'=>$pri_id]);
            }
        } else {
            // 提交
            $error_message = $verify_data->addSubmitValidator($request->all());
            if ($error_message) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
            }
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);

            // 判断当前门店下角色名称是否存在
            $find_role = DB::table('role')
                ->where('rol_cid', $user_info->adm_cid)
                ->where('rol_shop_id', $user_info->adm_shop_id)
                ->where('rol_name', $request['rol_name'])
                ->select('rol_id')
                ->first();
            if ($find_role) {
                return response()->json(['code'=>500, 'msg'=>'角色名称已存在', 'data'=>'角色名称已存在']);
            }

            $role_data = [
                'rol_cid'=>$user_info->adm_cid,
                'rol_shop_id'=>$user_info->adm_shop_id,
                'rol_creator_id'=>$user_info->adm_id,
                'rol_name'=>$request['rol_name'],
                'rol_privilege'=>$request['rol_privilege'],
                'rol_category'=>1
            ];
            if ($request['rol_description']) {
                $role_data['rol_description'] = $request['rol_description'];
            }
            $res = DB::table('role')->insert($role_data);
            if ($res) {
                Common::addLog($user_info, getRealIp($request), '角色设置', '新增', $request['rol_name'] . '角色新增成功');
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'新增角色成功']);
            } else {
                return response()->json(['code'=>500, 'msg'=>'新增角色失败', 'data'=>'新增角色失败']);
            }
        }
    }

    // 角色权限数据分类
    public function roleCategory($arr)
    {
        $one_list = [];//一级栏目
        $two_list = [];//二级列表
        $fid_list = [];//二级列表的父级id
        foreach ($arr as $key => $value) {
            if ($value['pri_fid'] == 0) {
                $one_list[$value['pri_sord']] = $value;
                $fid_list[$value['pri_sord']] = $value['pri_id'];
            }
            if ($value['pri_type'] == 3) {
                // 二级列表下的按钮
                $two_list[$value['pri_fid']][] = $value;
            }
            // 工作总台的权限，在列表页面显示
            if ($value['pri_id'] == 102) {
                $arr[$key]['pri_show'] = 1;
            }
        }

        // 对一级栏目按照 pri_sord 字段数据排序
        ksort($fid_list);
        ksort($one_list);
        // 对数组的键值重新排序
        $new_fid_list = array_values($fid_list);
        $new_one_list = array_values($one_list);
        foreach ($arr as $key => $value) {
            // 把二级列表数据放到一级栏目下
            if (in_array($value['pri_fid'], $new_fid_list)) {
                $one_key = array_search($value['pri_fid'], $new_fid_list);
                // 判断是否有二级列表
                $list_button = $value;
                if (!empty($two_list[$value['pri_id']])) {
                    $list_button['subcat'] = $two_list[$value['pri_id']];
                }
                $new_one_list[$one_key]['subcat'][] = $list_button;
                unset($button);
                unset($list_button);
            }
        }
        return $new_one_list;
    }

    // 编辑
    public function edit(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRoleSetController;
        $error_message = $verify_data->editShowValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        if ($request['type'] == 1) {
            // 获取角色权限
            $find_role = DB::table('role')
                ->where('rol_id', $request['rol_id'])
                ->select('rol_type', 'rol_privilege', 'rol_name', 'rol_description', 'rol_category')
                ->first();
            if ($find_role->rol_type == 1) {//店主
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'店主角色不能进行编辑']);
            }

            // pc端角色
            if ($find_role->rol_category == 1) {
                $role_info = DB::table('login_temporary')
                    ->where('api_token', '=', $request['api_token'])
                    ->select('adm_id', 'role_auth')
                    ->first();
                $role_auth = json_decode($role_info->role_auth, true);
                // 分类
                $privileges_info = $this->roleCategory($role_auth);
                foreach ($role_auth as $key => $value) {
                    if ($value['pri_type'] == 3) {
                        $rol_subordinate[] = $value['pri_id'];
                    }
                }
                $data['rol_subordinate'] = $rol_subordinate;
            }

            // 所有权限id
            $rol_privilege = explode(',', $find_role->rol_privilege);
            $data['rol_name'] = $find_role->rol_name;
            $data['rol_description'] = $find_role->rol_description;
            $data['rol_privilege'] = array_values($rol_privilege);
            
            // app端角色
            if ($find_role->rol_category == 2) {
                // 获取角色权限
                $privileges_info = DB::table('privileges_app')->get();
                $data['rol_subordinate'] = array_diff($data['rol_privilege'], explode(',', $find_role->rol_privilege));
            }

            // 微信小程序角色
            if ($find_role->rol_category == 3) {
                // 获取角色权限
                $privileges_info = DB::table('privileges_technician_applet')->where('pri_show', 1)->get();
                $data['rol_subordinate'] = array_diff($data['rol_privilege'], explode(',', $find_role->rol_privilege));
            }

            if (!$privileges_info) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'编辑角色页获取失败']);
            } else {
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data, 'privileges_info'=>$privileges_info]);
            }
        } else {
            // 提交
            $error_message = $verify_data->addSubmitValidator($request->all());
            if ($error_message) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
            }
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);

            // 判断当前门店下角色名称是否存在
            $find_role = DB::table('role')
                ->where('rol_cid', $user_info->adm_cid)
                ->where('rol_shop_id', $user_info->adm_shop_id)
                ->where('rol_id', '<>', $request['rol_id'])
                ->where('rol_name', $request['rol_name'])
                ->select('rol_id')
                ->first();
            if ($find_role) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'角色名称已存在']);
            }

            $rol_category = DB::table('role')
                ->where('rol_id', $request['rol_id'])
                ->value('rol_category');
            $rol_privilege = explode(',', $request['rol_privilege']);

            $role_data = [
                'rol_name'=>$request['rol_name'],
                'rol_privilege'=>implode(',', $rol_privilege),
                'rol_description'=>$request['rol_description'],
                'rol_update_time'=>date('Y-m-d H:i:s'),
            ];

            $res = DB::table('role')
                ->where('rol_id', $request['rol_id'])
                ->update($role_data);
            if ($res) {
                Common::addLog($user_info, getRealIp($request), '角色设置', '编辑', $request['rol_name'] . '角色编辑成功');
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'编辑角色成功']);
            } else {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'编辑角色失败']);
            }
        }
    }

    // 新增角色，后端、小程序角色合并为一个字段
    public function addition(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRoleSetController;
        $error_message = $verify_data->addShowValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        if ($request['type'] == 1) {
            // 获取角色权限
            $role_info = DB::table('login_temporary as l')
                ->leftjoin('admin_shop_role as a', function ($join){
                    $join->on('a.adm_id', '=', 'l.adm_id')
                       ->on('a.shop_id', '=', 'l.adm_shop_id');
                })
                // ->leftJoin('admin_shop_role as a', 'a.adm_id', '=', 'l.adm_id')
                ->leftJoin('role as r', 'r.rol_id', '=', 'a.role_id')
                ->where('api_token', $request['api_token'])
                ->select('l.adm_id', 'l.role_auth', 'rol_privilege_multiple')
                ->first();
            $role_auth = json_decode($role_info->role_auth, true);
            // 角色权限数据分类
            $privileges_info = $this->roleCategory($role_auth);
            $pri_id = DB::table('privileges')
                ->where('pri_show', 1)
                ->select('pri_id', 'pri_method_name', 'pri_fid')
                ->get()->toArray();
            $return_data['pc']['privileges_info'] = $privileges_info ? $privileges_info : '';
            $return_data['pc']['pri_id'] = $pri_id;

            $data = json_decode($role_info->rol_privilege_multiple, true);
            $applet = $data['applet'];
            $applet_pri_id = explode(',',$applet);
            $applet_role_auth = DB::table('privileges_technician_applet')
                ->whereIn('pri_id', $applet_pri_id)
                ->get()->toArray();
            $applet_role_auth = json_decode(json_encode($applet_role_auth, true), true);
            $applet_privileges_info = $this->roleCategory($applet_role_auth);
            
            $all_pri_id = DB::table('privileges_technician_applet')
                ->where('pri_show', 1)
                ->select('pri_id', 'pri_method_name')
                ->get()->toArray();
            // $privileges_info  = json_decode($role_auth, true);
            $return_data['applet']['privileges_info'] = $applet_privileges_info ?? [];
            $return_data['applet']['pri_id'] = $all_pri_id;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        } else {
            // 提交
            $error_message = $verify_data->additionSubmitValidator($request->all());
            if ($error_message) {
                return response()->json(['code'=>500, 'msg'=>$error_message->first(), 'data'=>'参数错误', 'error_message'=>$error_message]);
            }
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);

            // 判断当前门店下角色名称是否存在
            $find_role = DB::table('role')
                ->where('rol_cid', $user_info->adm_cid)
                ->where('rol_shop_id', $user_info->adm_shop_id)
                ->where('rol_name', $request['rol_name'])
                ->select('rol_id')
                ->first();
            if ($find_role) {
                return response()->json(['code'=>500, 'msg'=>'角色名称已存在', 'data'=>'']);
            }
            // pc端权限
            $rol_privilege_multiple['pc'] = $request->input('pc_privilege', '');
            // 小程序权限
            $rol_privilege_multiple['applet'] = $request->input('applet_privilege', '');
            $rol_privilege_multiple = json_encode($rol_privilege_multiple);
            
            $role_data = [
                'rol_cid'=>$user_info->adm_cid,
                'rol_shop_id'=>$user_info->adm_shop_id,
                'rol_creator_id'=>$user_info->adm_id,
                'rol_name'=>$request['rol_name'],
                'rol_privilege_multiple'=>$rol_privilege_multiple,
                'rol_category'=>1
            ];
            if ($request['rol_description']) {
                $role_data['rol_description'] = $request['rol_description'];
            }
            $res = DB::table('role')->insert($role_data);
            if ($res) {
                Common::addLog($user_info, getRealIp($request), '角色设置', '新增', $request['rol_name'] . '角色新增成功');
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'新增角色成功']);
            } else {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'新增角色失败']);
            }
        }
    }

    // 编辑
    public function modify(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRoleSetController;
        $error_message = $verify_data->editShowValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'参数错误', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        if ($request['type'] == 1) {
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);
            $adm_role = Admin::where("adm_id",$user_info->adm_id)->value('adm_role');
            // 获取角色权限
            $find_role = DB::table('role')
                ->where('rol_id', $request['rol_id'])
                ->select('rol_type', 'rol_privilege', 'rol_name', 'rol_description', 'rol_category', 'rol_privilege_multiple')
                ->first();
            if ($find_role->rol_type == 1 && $user_info->adm_shop_id !=2 ) {//店主
                return response()->json(['code'=>500, 'msg'=>'店主角色不能进行编辑', 'data'=>'店主角色不能进行编辑']);
            }
            $rol_privilege_multiples = DB::table('role')
                ->where('rol_id', $adm_role)
                ->value( 'rol_privilege_multiple');
            $rol_privilege_multiples = json_decode($rol_privilege_multiples, true);
            $rol_privileges = explode(',', $rol_privilege_multiples['applet']);

            $rol_privilege_multiple = json_decode($find_role->rol_privilege_multiple, true);
            $show = 1;
            if($user_info->adm_shop_id == 2 ){
                $adm_role = DB::table('admin')->where("adm_id",$user_info->adm_id)->value('adm_role');
                if($adm_role == 5){
                    $show = 2;
                }
            }
            // pc端角色
            if($show == 1) {
                $role_info = DB::table('login_temporary')
                    ->where('api_token', '=', $request['api_token'])
                    ->select('adm_id', 'role_auth')
                    ->first();
                $role_auth = json_decode($role_info->role_auth, true);
            }else{
                $role_auth = DB::table('privileges')->where("pri_show",1)->get();
                $role_auth = CommonService::dataToArray($role_auth);
            }
            // 分类
            $privileges_info = $this->roleCategory($role_auth);
            foreach ($role_auth as $key => $value) {
                if ($value['pri_type'] == 3) {
                    $rol_subordinate[] = $value['pri_id'];
                }
            }
            $data['pc']['rol_subordinate'] = $rol_subordinate;
            $data['pc']['privileges_info'] = $privileges_info;
            // pc端所有权限id
            $rol_privilege = explode(',', $rol_privilege_multiple['pc']);
            $data['rol_name'] = $find_role->rol_name;
            $data['rol_description'] = $find_role->rol_description;
            $data['pc']['rol_privilege'] = array_values($rol_privilege);

            // 微信小程序角色
            $rol_privilege = explode(',', $rol_privilege_multiple['applet']);
            $data['applet']['rol_privilege'] = array_values($rol_privilege);
            if($show == 1) {
                $privileges_info = DB::table('privileges_technician_applet')->where('pri_show', 1)->whereIn('pri_id',$rol_privileges)->get();
            }else {
                $privileges_info = DB::table('privileges_technician_applet')->where('pri_show', 1)->get();
            }
            $rol_subordinate = [];
            foreach ($privileges_info as $key => $value) {
                $find_son = DB::table('privileges_technician_applet')->where('pri_fid', $value->pri_id)->get()->toArray();
                if ($value->pri_type == 3 || empty($find_son)) {
                    $rol_subordinate[] = $value->pri_id;
                }
            }
            $role_auth = json_decode(json_encode($privileges_info, true), true);
            // 分类
            $privileges_info = $this->roleCategory($role_auth);
            $data['applet']['rol_subordinate'] = $rol_subordinate;
            // $data['applet']['rol_subordinate'] = array_diff($data['applet']['rol_privilege'], explode(',', $rol_privilege_multiple['applet']));
            $data['applet']['privileges_info'] = $privileges_info;

            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data,'rol_privileges'=>$rol_privileges,'rol_privilege'=>$rol_privilege]);
        } else {
            // 提交
            $error_message = $verify_data->additionSubmitValidator($request->all());
            if ($error_message) {
                return response()->json(['code'=>500, 'msg'=>$error_message->first(), 'data'=>'参数错误', 'error_message'=>$error_message]);
            }
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);

            // 判断当前门店下角色名称是否存在
            $find_role = DB::table('role')
                ->where('rol_cid', $user_info->adm_cid)
                ->where('rol_shop_id', $user_info->adm_shop_id)
                ->where('rol_id', '<>', $request['rol_id'])
                ->where('rol_name', $request['rol_name'])
                ->select('rol_id')
                ->first();
            if ($find_role) {
                return response()->json(['code'=>500, 'msg'=>'角色名称已存在', 'data'=>'']);
            }
            // pc端权限
            $rol_privilege_multiple['pc'] = $request->input('pc_privilege', '');
            // 小程序权限
            $rol_privilege_multiple['applet'] = $request->input('applet_privilege', '');
            $rol_privilege_multiple = json_encode($rol_privilege_multiple);

            $role_data = [
                'rol_name'=>$request['rol_name'],
                // 'rol_privilege'=>implode(',', $rol_privilege),
                'rol_privilege_multiple'=>$rol_privilege_multiple,
                'rol_description'=>$request['rol_description'],
                'rol_update_time'=>date('Y-m-d H:i:s'),
            ];

            $res = DB::table('role')
                ->where('rol_id', $request['rol_id'])
                ->update($role_data);
            if ($res) {
                Common::addLog($user_info, getRealIp($request), '角色设置', '编辑', $request['rol_name'] . '角色编辑成功');
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'编辑角色成功']);
            } else {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'编辑角色失败']);
            }
        }
    }

    // 启用
    public function start(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRoleSetController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 查询角色信息
        $find_data = DB::table('role')
            ->whereIn('rol_id', $request['rol_id'])
            ->select('rol_name')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            $rol_name[] = $value->rol_name;
        }

        // 启用
        $update_data['rol_state'] = 1;//状态1正常2停用
        $update_data['rol_update_time'] = date('Y-m-d H:i:s');
        $rol_res = DB::table('role')->whereIn('rol_id', $request['rol_id'])->update($update_data);

        if ($rol_res) {
            Common::addLog($user_info, getRealIp($request), '角色设置', '启用', '角色：（'.implode(',', $rol_name).'）启用成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'启用成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'启用失败']);
        }
    }

    // 停用
    public function stop(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRoleSetController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 查询角色信息
        $find_data = DB::table('role')
            ->whereIn('rol_id', $request['rol_id'])
            ->select('rol_name', 'rol_type')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            $rol_name[] = $value->rol_name;
            if ($value->rol_type == 1) {
                return response()->json(['code'=>500, 'msg'=>'总权限不允许停用', 'data'=>'店长权限不允许停用']);
            }
        }

        // 停用
        $update_data['rol_state'] = 2;//状态1正常2停用
        $update_data['rol_update_time'] = date('Y-m-d H:i:s');
        $rol_res = DB::table('role')->whereIn('rol_id', $request['rol_id'])->update($update_data);

        if ($rol_res) {
            Common::addLog($user_info, getRealIp($request), '角色设置', '停用', '角色：（'.implode(',', $rol_name).'）停用成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'停用成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'停用失败']);
        }
    }

    // 获取角色数据
    public function getRole(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $search_data = $request->all();
        
        $role_data = DB::table('role')
            ->where('rol_cid', $user_info->adm_cid)
            ->where('rol_shop_id', $user_info->adm_shop_id)
            ->where('rol_state', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['search_data'])) {
                    $query->where('rol_name', 'like', '%'.$search_data['search_data'].'%');
                }
            })
            // ->where(function ($query) use ($search_data) {
            //     if (!empty($search_data['app_role'])) {
            //         $query->where('rol_category', $search_data['app_role']);
            //     }
            // })
            ->select('rol_id', 'rol_name')
            ->get()->toArray();
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$role_data]);
    }

    // app新增
    public function appAdd(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRoleSetController;
        $error_message = $verify_data->addShowValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        if ($request['type'] == 1) {
            // 获取角色权限
            $role_auth = DB::table('privileges_app')->get();
            $privileges_info  = json_decode($role_auth, true);
            // 角色权限数据分类
            // $privileges_info = $this->roleCategory($role_auth);
            if (!$privileges_info) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'角色权限数据获取失败']);
            }
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'角色权限数据获取成功', 'privileges_info'=>$privileges_info]);
        } else {
            // 提交
            $error_message = $verify_data->addSubmitValidator($request->all());
            if ($error_message) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
            }
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);

            // 判断当前门店下角色名称是否存在
            $find_role = DB::table('role')
                ->where('rol_cid', $user_info->adm_cid)
                ->where('rol_shop_id', $user_info->adm_shop_id)
                ->where('rol_name', $request['rol_name'])
                ->select('rol_id')
                ->first();
            if ($find_role) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'角色名称已存在']);
            }

            $role_data = [
                'rol_cid'=>$user_info->adm_cid,
                'rol_shop_id'=>$user_info->adm_shop_id,
                'rol_creator_id'=>$user_info->adm_id,
                'rol_name'=>$request['rol_name'],
                'rol_privilege'=>$request['rol_privilege'],
                'rol_category'=>2
            ];
            if ($request['rol_description']) {
                $role_data['rol_description'] = $request['rol_description'];
            }
            $res = DB::table('role')->insert($role_data);
            if ($res) {
                Common::addLog($user_info, getRealIp($request), '角色设置', '新增', $request['rol_name'] . '角色新增成功');
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'新增角色成功']);
            } else {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'新增角色失败']);
            }
        }
    }

    // 微信小程序新增
    public function appletAdd(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRoleSetController;
        $error_message = $verify_data->addShowValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        if ($request['type'] == 1) {
            // 获取角色权限
            $role_auth = DB::table('privileges_technician_applet')->where('pri_show', 1)->get();
            $privileges_info  = json_decode($role_auth, true);
            // 角色权限数据分类
            // $privileges_info = $this->roleCategory($role_auth);
            if (!$privileges_info) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'微信小程序角色权限数据获取失败']);
            }
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'微信小程序角色权限数据获取成功', 'privileges_info'=>$privileges_info]);
        } else {
            // 提交
            $error_message = $verify_data->addSubmitValidator($request->all());
            if ($error_message) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
            }
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);

            // 判断当前门店下角色名称是否存在
            $find_role = DB::table('role')
                ->where('rol_cid', $user_info->adm_cid)
                ->where('rol_shop_id', $user_info->adm_shop_id)
                ->where('rol_name', $request['rol_name'])
                ->select('rol_id')
                ->first();
            if ($find_role) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'角色名称已存在']);
            }

            $role_data = [
                'rol_cid'=>$user_info->adm_cid,
                'rol_shop_id'=>$user_info->adm_shop_id,
                'rol_creator_id'=>$user_info->adm_id,
                'rol_name'=>$request['rol_name'],
                'rol_privilege'=>$request['rol_privilege'],
                'rol_category'=>3
            ];
            if ($request['rol_description']) {
                $role_data['rol_description'] = $request['rol_description'];
            }
            $res = DB::table('role')->insert($role_data);
            if ($res) {
                Common::addLog($user_info, getRealIp($request), '角色设置', '新增', $request['rol_name'] . '角色新增成功');
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'新增角色成功']);
            } else {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'新增角色失败']);
            }
        }
    }
}
