<?php
namespace App\Http\Controllers\Api\SystemsManage;

use App\Http\Controllers\Api\Verify\VerifyLoginController;
use App\Services\CommonService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\SystemsManage\VerifyPersonalController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Services\Software\QrCodeService;
use App\Services\SystemsManage\PersonalService;
use App\Services\Shop\ShopService;

// 个人中心
class PersonalController extends Controller
{
	// 获取页面信息
	public function personal(Request $request)
	{
		// 获取当前操作账号信息
		$user_info = Common::getUserInfo($request['api_token']);
		$info = DB::table('admin as a')
			->leftjoin('admin_shop_role as asr', 'asr.adm_id', '=', 'a.adm_id')
			->leftjoin('shop as s', 'asr.shop_id', '=', 's.shop_id')
			->leftjoin('admin_set as adms', 'adms.adms_adm_id', '=', 'a.adm_id')
			->where('a.adm_id', $user_info->adm_id)
            ->where('adms_shop_id', $user_info->adm_shop_id)
			->where('asr.login_shop', 1)
			->first(['s.shop_superior_id', 's.shop_on_trial_start_time', 's.shop_on_trial_end_time', 's.shop_opening_start_time', 's.shop_opening_end_time',
                'a.adm_account', 'a.adm_name', 'a.adm_phone', 's.shop_image', 's.shop_store_name', 's.shop_name', 's.shop_phone', 's.shop_province',
                's.shop_city', 's.shop_county', 's.shop_address', 's.shop_token', 's.shop_img_source', 'asr.adm_shop_leave as adm_leave', 's.shop_longitude',
                's.shop_latitude', 'adms_province', 'adms_city', 'adms_county', 'adms_address', 'adms_longitude', 'adms_latitude', 'shop_code', 'shop_service_scope', 'shop_opening_time', 'shop_service_scope_name']);

		if (empty($info)) {
			$info = DB::table('admin as a')
				->leftjoin('admin_shop_role as asr', 'asr.adm_id', '=', 'a.adm_id')
				->leftjoin('shop as s', 'asr.shop_id', '=', 's.shop_id')
				->leftjoin('admin_set as adms', 'adms.adms_adm_id', '=', 'a.adm_id')
				->where('a.adm_id', $user_info->adm_id)
				->where('asr.login_shop', 1)
				->first(['s.shop_superior_id', 's.shop_on_trial_start_time', 's.shop_on_trial_end_time', 's.shop_opening_start_time', 's.shop_opening_end_time',
	                'a.adm_account', 'a.adm_name', 'a.adm_phone', 's.shop_image', 's.shop_store_name', 's.shop_name', 's.shop_phone', 's.shop_province',
	                's.shop_city', 's.shop_county', 's.shop_address', 's.shop_token', 's.shop_img_source', 'asr.adm_shop_leave as adm_leave', 's.shop_longitude',
	                's.shop_latitude', 'adms_province', 'adms_city', 'adms_county', 'adms_address', 'adms_longitude', 'adms_latitude', 'shop_code', 'shop_service_scope', 'shop_opening_time', 'shop_service_scope_name']);
		}
		if ($info) {
			$find_admin_dz = DB::table('admin_shop_role')
				->where('shop_id', $user_info->adm_shop_id)
				->where('adm_shop_leave', 1)
				->value('adm_id');
			if ($find_admin_dz == $user_info->adm_id) {
				$info->can_edit = 1;
			} else {
				$info->can_edit = 2;
			}
			// 图片路径处理
			if (!empty($info->shop_image)) {
				if ($info->shop_img_source == 1) {
					// 门店系统的图片路径
					$info->shop_image = $info->shop_image;
				} else {
					// 供应链的图片路径
					$info->shop_image = config('apisystem.g_server_name') . '/' . $info->shop_image;
				}
			}
			// $shau_res = DB::table('shop_audit')
			// 	->where('shau_shop_id', $user_info->adm_shop_id)
			// 	->select('shau_state', 'shau_audit_time', 'shau_refuse_reason')
			// 	->orderBy('shau_id', 'desc')
			// 	->first();
			// if ($shau_res) {
			// 	if ($shau_res->shau_state == 3) {
			// 		$info->shau_refuse_reason = $shau_res->shau_refuse_reason;
			// 	}
			// 	$info->shau_state = $shau_res->shau_state;
			// 	$info->shau_audit_time = $shau_res->shau_audit_time;
			// } else {
			// }
			$info->shau_state = 0;
			$info->shau_audit_time = '';
			$QrCodeService = new QrCodeService();
			// $type = 1;//类型：1创建二维码不保存图片2创建二维码并保存图片
			$text = config('apisystem.server_name_https'). '/xmradius?shop_id='.$user_info->adm_shop_id;
			$qrCode = $QrCodeService->qrCode(1, $text);
			if (empty($info->shop_code)) {
				$update_shop_data['shop_code'] = 'S' . substr(time(),5,5)  . rand(10000, 99999); //门店编号
				$update_res = DB::table('shop')
					->where('shop_id', $user_info->adm_shop_id)
					->update($update_shop_data);
				$info->shop_code = $update_shop_data['shop_code'];
			}

			// 获取当前列表下的按钮
			$list_button = getListButton($request['api_token'], $request['pri_id']);
			return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$info, 'qrCode'=>$qrCode, 'list_button'=>$list_button]);
		} else {
			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
		}
	}

	// 获取小程序二维码
	public function getQrimg(Request $request) {
		// 获取当前操作账号信息
		$user_info = Common::getUserInfo($request['api_token']);
		$QrCodeService = new QrCodeService();
		// $type = 1;//类型：1创建二维码不保存图片2创建二维码并保存图片
		$text = config('apisystem.server_name_https'). '/xmradius?shop_id='.$user_info->adm_shop_id;
		$qrCode = $QrCodeService->qrCode(1, $text);
		return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$qrCode]);
	}

	// 修改密码
	public function editPwd(Request $request)
	{
		// 验证type是否正确
		$verify_data = new VerifyPersonalController;
		$error_message = $verify_data->typeValidator($request->all());
		if ($error_message) {
			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
		}

		if ($request['type'] == 1) {
			// 原密码确认 验证数据
			$verify_data = new VerifyPersonalController;
			$error_message = $verify_data->oldpwdValidator($request->all());
			if ($error_message) {
				return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
			}

			// 获取当前操作账号信息
			$user_info = Common::getUserInfo($request['api_token']);

			$adm_pas = DB::table('admin')
				->where('adm_id', '=', $user_info->adm_id)
				->value('adm_password');
			$old_pwd = md5($request['old_pwd'] . 'faster123456'); //加密传过来的密码

			if ($old_pwd !== $adm_pas) {
				return response()->json(["code"=>500, 'msg'=>'error', 'data'=>'原密码错误']);
			} else {
				return response()->json(["code"=>200, 'msg'=>'success', 'data'=>'原密码正确']);
			}
		} else {
			// 原密码确认 验证数据
			$verify_data = new VerifyPersonalController;
			$error_message = $verify_data->newpwdValidator($request->all());
			if ($error_message) {
				return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
			}

			// 获取当前操作账号信息
			$user_info = Common::getUserInfo($request['api_token']);

			$new_pwd = md5($request['new_pwd'] . 'faster123456'); //加密密码
			$update_data['adm_password'] = $new_pwd;
			$update_data['adm_update_time'] = date('Y-m-d H:i:s');
			$res = DB::table('admin')
				->where('adm_id', '=', $user_info->adm_id)
				->update($update_data);
			if ($res) {
				Common::addLog($user_info, getRealIp($request), '个人中心', '修改密码', $user_info->adm_name . '修改密码成功');
				return response()->json(["code"=>200, 'msg'=>'success', 'data'=>'密码修改成功']);
			} else {
				return response()->json(["code"=>500, 'msg'=>'error', 'data'=>'密码修改失败']);
			}
		}
	}

	// // 更换电话
	// public function editTel(Request $request)
	// {
	// 	// 验证type是否正确
	// 	$verify_data = new VerifyPersonalController;
	// 	$error_message = $verify_data->telValidator($request->all());
	// 	if ($error_message) {
	// 		return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
	// 	}

	// 	// 获取当前操作账号信息
	// 	$user_info = Common::getUserInfo($request['api_token']);
	// 	if ($request['type'] == 1) {
	// 		// 原有手机号发送验证码
	// 		$tel = DB::table('admin')
	// 			->where('adm_id', $user_info->adm_id)
	// 			->value('adm_phone');
	// 		if ($request['tel'] != $tel) {
	// 			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请输入正确的原有电话']);
	// 		}

	// 		$code = mt_rand(100000, 999999); //生成六位验证码
	// 		$message = "您所使用的\"门店助手系统\"账号的验证码为{$code}，十分钟内有效。"; //短信信息
	// 		$now_time = date('Y-m-d H:i:s');
	// 		$phc_data['phc_phone'] = $request['tel'];
	// 		$phc_data['phc_code'] = $code;
	// 		$phc_data['phc_type'] = 1;
	// 		$phc_data['phc_creacttime'] = $now_time;
	// 		$phc_data['phc_expirationtime'] = date('Y-m-d H:i:s', strtotime($now_time) + 600); //过期时间

	// 		// 查看是否发送验证码
	// 		$find_phone_code = DB::table('phone_code')
	// 			->where('phc_phone', $request['phone'])
	// 			->first(['phc_id', 'phc_code', 'phc_type', 'phc_expirationtime']);
	// 		if ($find_phone_code) {
	// 			if ($find_phone_code['phc_type'] == 1 && $find_phone_code['phc_expirationtime'] > date('Y-m-d H:i:s')) {
	// 				return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'短信验证码已发送，十分钟内到期。']);
	// 			} else {
	// 				$send_res = sendSmsCode($request['phone'], $message);
	// 				$phc_data['phc_send_code'] = $send_res; //短信发送返回值
	// 				$phc_res = DB::table('phone_code')
	// 					->where('phc_id', $find_phone_code['phc_id'])
	// 					->update($phc_data);
	// 			}
	// 		} else {
	// 			$send_res = sendSmsCode($request['tel'], $message);
	// 			$phc_data['phc_send_code'] = $send_res; //短信发送返回值
	// 			$phc_res = DB::table('phone_code')->insert($phc_data);
	// 		}

	// 		if ($phc_res && $send_res != -5) {
	// 			Common::addLog($user_info, getRealIp($request), '个人中心', '更换手机号', $request['tel'] . '发送验证码成功');
	// 			return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'验证码发送成功']);
	// 		} else {
	// 			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'验证码发送失败']);
	// 		}
	// 	} elseif ($request['type'] == 2) {
	// 		// 原有手机号判断验证码是否正确
	// 		$find_phone_code = DB::table('phone_code')
	// 			->where('phc_phone', $request['tel'])
	// 			->where('phc_code', $request['code'])
	// 			->first(['phc_id', 'phc_type', 'phc_expirationtime']);
	// 		if (empty($find_phone_code)) {
	// 			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'验证码错误']);
	// 		}
	// 		if ($find_phone_code->phc_type != 1) {
	// 			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前验证码已使用，请重新获取验证码']);
	// 		}
	// 		if ($find_phone_code->phc_expirationtime < date('Y-m-d H:i:s')) {
	// 			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前验证码已过期失效，请重新获取验证码']);
	// 		}
	// 		// 更改验证码状态
	// 		$phc_res = DB::table('phone_code')
	// 			->where('phc_id', $find_phone_code->phc_id)
	// 			->update(['phc_type' => 2]);
	// 		if ($phc_res) {
	// 			return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'验证成功']);
	// 		} else {
	// 			return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'验证失败']);
	// 		}
	// 	} elseif ($request['type'] == 3) {
	// 		// 新手机号获取验证码
	// 		$is_tel = DB::table('admin')
	// 			->where('adm_phone', $request['tel'])
	// 			->select('adm_id')
	// 			->first();
	// 		if ($is_tel) {
	// 			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'该手机号已存在,请更换手机号']);
	// 		}

	// 		$code = mt_rand(100000, 999999); //生成六位验证码
	// 		$message = "您所使用的\"门店助手系统\"账号的验证码为{$code}，十分钟内有效。"; //短信信息
	// 		$now_time = date('Y-m-d H:i:s');
	// 		$phc_data['phc_phone'] = $request['tel'];
	// 		$phc_data['phc_code'] = $code;
	// 		$phc_data['phc_type'] = 1;
	// 		$phc_data['phc_creacttime'] = $now_time;
	// 		$phc_data['phc_expirationtime'] = date('Y-m-d H:i:s', strtotime($now_time) + 600); //过期时间

	// 		// 查看是否发送验证码
	// 		$find_phone_code = DB::table('phone_code')
	// 			->where('phc_phone', $request['phone'])
	// 			->first(['phc_id', 'phc_code', 'phc_type', 'phc_expirationtime']);
	// 		if ($find_phone_code) {
	// 			if ($find_phone_code['phc_type'] == 1 && $find_phone_code['phc_expirationtime'] > date('Y-m-d H:i:s')) {
	// 				return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'短信验证码已发送，十分钟内到期。']);
	// 			} else {
	// 				$send_res = sendSmsCode($request['tel'], $message);
	// 				$phc_data['phc_send_code'] = $send_res; //短信发送返回值
	// 				$phc_res = DB::table('phone_code')->where('phc_id', $find_phone_code['phc_id'])->update($phc_data);
	// 			}
	// 		} else {
	// 			$send_res = sendSmsCode($request['tel'], $message);
	// 			$phc_data['phc_send_code'] = $send_res; //短信发送返回值
	// 			$phc_res = DB::table('phone_code')->insert($phc_data);
	// 		}

	// 		if ($phc_res && $send_res != -5) {
	// 			Common::addLog($user_info, getRealIp($request), '个人中心', '更换手机号', $user_info->adm_name . '发送验证码成功');
	// 			return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'验证码发送成功']);
	// 		} else {
	// 			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'验证码发送失败']);
	// 		}
	// 	} elseif ($request['type'] == 4) {
	// 		// 新手机号 判断验证码是否正确
	// 		$find_phone_code = DB::table('phone_code')
	// 			->where('phc_phone', $request['tel'])
	// 			->where('phc_code', $request['code'])
	// 			->first(['phc_id', 'phc_type', 'phc_expirationtime']);
	// 		if (empty($find_phone_code)) {
	// 			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'验证码错误']);
	// 		}
	// 		if ($find_phone_code->phc_type != 1) {
	// 			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前验证码已使用，请重新获取验证码']);
	// 		}
	// 		if ($find_phone_code->phc_expirationtime < date('Y-m-d H:i:s')) {
	// 			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前验证码已过期失效，请重新获取验证码']);
	// 		}

	// 		DB::beginTransaction();
	// 		// 更改验证码状态
	// 		$phc_res = DB::table('phone_code')
	// 			->where('phc_id', $find_phone_code->phc_id)
	// 			->update(['phc_type' => 2]);

	// 		// 查询出是否是店长 店长改:admin表/shop表 员工改：admin表
	// 		$find_adm = DB::table('admin')
	// 			->where('adm_id', $user_info->adm_id)
	// 			->first(['adm_leave', 'adm_phone']);

	// 		if ($find_adm->adm_leave == 1) {
	// 			$admin = DB::table('admin')
	// 				->where('adm_id', $user_info->adm_id)
	// 				->update(['adm_phone' => $request['tel']]);
	// 			$shop = DB::table('shop')
	// 				->where('shop_id', $user_info->adm_shop_id)
	// 				->update(['shop_phone' => $request['tel']]);
	// 		} else {
	// 			$admin = DB::table('admin')
	// 				->where('adm_id', $user_info->adm_id)
	// 				->update(['adm_phone' => $request['tel']]);
	// 			$shop = true;
	// 		}

	// 		if ($admin && $shop && $phc_res) {
	// 			Common::addLog($user_info, getRealIp($request), '个人中心', '更换手机号', $find_adm->adm_phone . '更换手机号为' . $request['tel']);
	// 			DB::commit();
	// 			return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'手机号更换成功']);
	// 		} else {
	// 			DB::rollBack();
	// 			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'手机号更换失败']);
	// 		}
	// 	}
	// }

	// 上传图片
	public function img(Request $request)
	{
		// 验证数据
		$verify_data = new VerifyPersonalController;
		$error_message = $verify_data->imgValidator($request->all());
		if ($error_message) {
			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
		}

		// 获取当前操作账号信息
		$user_info = Common::getUserInfo($request['api_token']);

		// 调用全局函数 上传图片
		$goo_picurl = uploadBase64Img($request['img']);
		$shop_res = DB::table('shop')->where('shop_id', $user_info->adm_shop_id)->update(['shop_image' => $goo_picurl]);

		if ($shop_res) {
			Common::addLog($user_info, getRealIp($request), '个人中心', '上传图片', '图片上传成功');
			return response()->json(["code"=>200, 'msg'=>'success', 'data'=>'上传成功']);
		} else {
			return response()->json(["code"=>500, 'msg'=>'error', 'data'=>'上传失败']);
		}
	}

	// 编辑
	public function edit(Request $request)
	{
		// 验证数据
		$verify_data = new VerifyPersonalController;
		$error_message = $verify_data->editValidator($request->all());
		if ($error_message) {
			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
		}

		// 获取当前操作账号信息
		$user_info = Common::getUserInfo($request['api_token']);
		// 获取店长的账号id
		$shop_adm_id = DB::table('admin_shop_role')
			->where('shop_id', $user_info->adm_shop_id)
			->where('adm_shop_leave', 1)
			->value('adm_id');
		// 判断当前登录账号是否是店长的账号
		if ($shop_adm_id != $user_info->adm_id) {
			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'不是店长账号，不允许修改']);
		}

		// // 判断手机号是否存在
		// $find_adm = DB::table('admin')
		// 	->where('adm_id', '<>', $shop_adm_id)
		// 	->where('adm_phone', $request['shop_phone'])
		// 	->value('adm_id');
		// if ($find_adm) {
		// 	return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'手机号已存在']);
		// }

		DB::beginTransaction();

		// // 1. 更改账号表信息
		// $adm_edit_data['adm_name'] = $request['shop_name'];
		// $adm_edit_data['adm_phone'] = $request['shop_phone'];
		// $adm_edit_data['adm_update_time'] = date('Y-m-d H:i:s');
		// $admin_res = DB::table('admin')
		// 	->where('adm_id', $shop_adm_id)
		// 	->update($adm_edit_data);
		//更新账号门店权限关系表
        // $admin_shop_role_res = DB::table('admin_shop_role')
        //     ->where('adm_id', $shop_adm_id)
        //     ->where('shop_id', $user_info->adm_shop_id)
        //     ->update(['phone'=>$request['shop_phone']]);

		// 2. 更改门店表信息
		$edit_data['shop_store_name'] = $request['shop_store_name'];
		$edit_data['shop_name'] = $request['shop_name'];
		$edit_data['shop_phone'] = $request['shop_phone'];
		$edit_data['shop_province'] = $request['shop_province'];
		$edit_data['shop_city'] = $request['shop_city'];
		$edit_data['shop_county'] = $request['shop_county'];
		$edit_data['shop_address'] = $request['shop_address'];
		$edit_data['shop_image'] = $request['shop_image'];
		$edit_data['shop_service_scope'] = $request['shop_service_scope'];
		$edit_data['shop_service_scope_name'] = $request['shop_service_scope_name'];
		if (!empty($request['shop_opening_time'])) {
			$open_time = implode(',', $request['shop_opening_time']);
		} else {
			$open_time = '';
		}
		$edit_data['shop_opening_time'] = $open_time;

		$find_shop_latitude = CommonService::jingwei($request['shop_province'],$request['shop_city'].$request['shop_county'].$request['shop_address']);
        if (!empty($find_shop_latitude)) {
            $latitude_data = explode(',',$find_shop_latitude);
            $edit_data['shop_longitude'] = $latitude_data[0]; //经度
            $edit_data['shop_latitude'] = $latitude_data[1]; //纬度
        }
        // dump($latitude_data);die;
		$edit_data['shop_update_time'] = date('Y-m-d H:i:s');
		$shop_res = DB::table('shop')
			->where('shop_id', $user_info->adm_shop_id)
			->update($edit_data);
		if ($shop_res) {
			DB::commit();
			Common::addLog($user_info, getRealIp($request), '个人中心', '编辑', $user_info->adm_name . '编辑公司信息成功');
			return response()->json(["code"=>200, 'msg'=>'success', 'data'=>'编辑成功']);
		} else {
			DB::rollBack();
			return response()->json(["code"=>500, 'msg'=>'error', 'data'=>'编辑失败']);
		}
	}

	// 公司信息提交审核
	public function submitAudit(Request $request)
	{
		// 验证数据
		$verify_data = new VerifyPersonalController;
		$error_message = $verify_data->submitAuditValidator($request->all());
		if ($error_message) {
			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
		}

		// 获取当前操作账号信息
		$user_info = Common::getUserInfo($request['api_token']);

		// 判断是否有待审核
		$find_audit = DB::table('shop_audit')
			->where('shau_shop_id', $user_info->adm_shop_id)
			->where('shau_state', 1)
			->value('shau_id');
		if ($find_audit) {
			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'已经提交审核，请等待审核结果']);
		}
		// 判断手机号是否存在
		$find_adm = DB::table('admin')
			->where('adm_id', '<>', $user_info->adm_id)
			->where('adm_phone', $request['shop_phone'])
			->value('adm_id');
		if ($find_adm) {
			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'手机号已存在']);
		}
		// 判断门店名称是否存在
		$find_shop = DB::table('shop')
			->where('shop_id', '<>', $user_info->adm_shop_id)
			->where('shop_store_name', $request['shop_store_name'])
			->value('shop_id');
		if ($find_shop) {
			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'门店名称已存在']);
		}

		// 判断是否有新图片上传
		if (strpos($request['shop_image'], 'data:image') === 0) {
			// 调用全局函数 上传图片
			$image_path = uploadBase64ImgFolder($user_info->adm_shop_id, $request['shop_image']);
			// 新上传图片图片来源1.门店 2.供应链
			$add_data['chau_img_source'] = 1;
		} elseif (strpos($request['shop_image'], config('apisystem.g_server_name')) === 0) {
			// 截取图片路径 图片路径2供应链
			$image_path = substr($request['shop_image'], strlen(config('apisystem.g_server_name')) + 1);
			$add_shop_data['shau_img_source'] = 2;
		} elseif (strpos($request['shop_image'], config('apisystem.mk_server_name')) === 0) {
			// 图片路径门店
			$image_path = substr($request['shop_image'], strlen(config('apisystem.mk_server_name')) + 1);
			$add_data['chau_img_source'] = 1;
		} else {
			$image_path = '';
		}

		$add_shop_data['shau_shop_id'] = $user_info->adm_shop_id; //渠道单位id
		$add_shop_data['shau_shop_store_name'] = $request['shop_store_name'];
		$add_shop_data['shau_shop_name'] = $request['shop_name'];
		$add_shop_data['shau_shop_phone'] = $request['shop_phone'];
		$add_shop_data['shau_shop_province'] = $request['shop_province'];
		$add_shop_data['shau_shop_city'] = $request['shop_city'];
		$add_shop_data['shau_shop_county'] = $request['shop_county'];
		$add_shop_data['shau_shop_address'] = $request['shop_address'];
		$add_shop_data['shau_shop_longitude'] = $request['shop_longitude'];
		$add_shop_data['shau_shop_latitude'] = $request['shop_latitude'];
		$add_shop_data['shau_shop_reason'] = $request['shop_reason'];
		$add_shop_data['shau_state'] = 1; //待审核
		$add_shop_data['shau_shop_adm_id'] = $user_info->adm_id; //申请人
		if ($image_path) {
			$add_shop_data['shau_shop_image'] = $image_path;
		}
		DB::beginTransaction();
		$add_shop_chau_res = DB::table('shop_audit')->insertGetId($add_shop_data);
		// $chau_chan_id = DB::connection('mysql_scm')
		// 	->table('channel')
		// 	->where('chan_shop_id', $user_info->adm_shop_id)
		// 	->value('chan_id');
		// $add_data['chau_chan_id'] = $chau_chan_id; //渠道单位id
		// $add_data['chau_shop_audit_id'] = $add_shop_chau_res; //门店渠道单位审核id
		// $add_data['chau_chan_unit_name'] = $request['shop_store_name']; //门店名称
		// $add_data['chau_chan_name'] = $request['shop_name']; //联系人
		// $add_data['chau_chan_phone'] = $request['shop_phone']; //电话
		// $add_data['chau_chan_province'] = $request['shop_province']; //省
		// $add_data['chau_chan_city'] = $request['shop_city']; //市
		// $add_data['chau_chan_county'] = $request['shop_county']; //区县
		// $add_data['chau_chan_address'] = $request['shop_address']; //详细地址
		// $add_data['chau_chan_longitude'] = $request['shop_longitude']; //经度
		// $add_data['chau_chan_latitude'] = $request['shop_latitude']; //纬度
		// $add_data['chau_chan_reason'] = $request['shop_reason']; //修改原因
		// $add_data['chau_state'] = 1; //待审核
		// $add_data['chau_shop_adm_id'] = $user_info->adm_id; //申请人
		// $add_data['chau_chan_image'] = $image_path;
		// DB::connection('mysql_scm')->beginTransaction();
		// $add_chau_res = DB::connection('mysql_scm')->table('channel_audit')->insertGetId($add_data);

		if (/*$add_chau_res && */$add_shop_chau_res) {
			// DB::connection('mysql_scm')->commit();
			DB::commit();
			Common::addLog($user_info, getRealIp($request), '个人中心', '提交审核', $user_info->adm_name . '提交变更公司信息成功');
			return response()->json(["code"=>200, 'msg'=>'success', 'data'=>'提交成功', 'shau_state'=>1]);
		} else {
			// DB::connection('mysql_scm')->rollBack();
			DB::rollBack();
			return response()->json(["code"=>500, 'msg'=>'error', 'data'=>'提交失败']);
		}
	}

	// 个人信息编辑
	public function editPerson(Request $request)
	{
		if (empty($request['adm_name'])) {
			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请输入姓名']);
		}

		// 获取当前操作账号信息
		$user_info = Common::getUserInfo($request['api_token']);
		$find_admin = DB::table('admin')
            ->where('adm_id', '!=', $user_info->adm_id)
            ->where('adm_phone', $request['adm_phone'])
            ->first();
        if ($find_admin) {
        	return response()->json(['code'=>500, 'msg'=>'手机号已存在', 'data'=>'手机号已存在']);
        }
		DB::beginTransaction();
		// 1. 更改账号表信息
		$adm_edit_data['adm_name'] = $request['adm_name'];
		$adm_edit_data['adm_phone'] = $request['adm_phone'];
		$adm_edit_data['adm_update_time'] = date('Y-m-d H:i:s');
		$admin_res = DB::table('admin')
			->where('adm_id', $user_info->adm_id)
			->update($adm_edit_data);

		// 查看当前账号是否有设置
		$find_adms_id = DB::table('admin_set')
			->where('adms_adm_id', $user_info->adm_id)
            ->where('adms_shop_id', $user_info->adm_shop_id)
			->value('adms_id');
		// 2. 更改账号设置表信息
		$adms_data['adms_province'] = $request['adms_province'] ? $request['adms_province'] : '';
		$adms_data['adms_city'] = $request['adms_city'] ? $request['adms_city'] : '';
		$adms_data['adms_county'] = $request['adms_county'] ? $request['adms_county'] : '';
		$adms_data['adms_address'] = $request['adms_address'] ? $request['adms_address'] : '';
		$adms_data['adms_longitude'] = $request['adms_longitude'] ? $request['adms_longitude'] : '';
		$adms_data['adms_latitude'] = $request['adms_latitude'] ? $request['adms_latitude'] : '';
		$adms_data['adms_update_time'] = date('Y-m-d H:i:s');
		if ($find_adms_id) {
			$shop_res = DB::table('admin_set')
				->where('adms_adm_id', $user_info->adm_id)
                ->where('adms_shop_id', $user_info->adm_shop_id)
				->update($adms_data);
		} else {
			$adms_data['adms_adm_id'] = $user_info->adm_id;
            $adms_data['adms_shop_id'] = $user_info->adm_shop_id;
			$shop_res = DB::table('admin_set')->insert($adms_data);
		}

		$update_data['phone'] = $request['adm_phone'];
        $update_data['update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('admin_shop_role')
            ->where('adm_id', $user_info->adm_id)
            ->update($update_data);

		if ($admin_res && $shop_res) {
			DB::commit();
			Common::addLog($user_info, getRealIp($request), '个人中心', '编辑', $user_info->adm_name . '编辑个人信息成功');
			return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'编辑成功']);
		} else {
			DB::rollBack();
			return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'编辑失败']);
		}
	}

	// 公司简介信息查看
	public function companyProfile(Request $request)
	{
		// 获取当前操作账号信息
		$user_info = Common::getUserInfo($request['api_token']);
		
		$find_shop_info = DB::table('shop_info')
			->where('shin_shop_id', $user_info->adm_shop_id)
			->value('shin_company_profile');
		$shop_info = [];
		if ($find_shop_info) {
			$shop_info = json_decode($find_shop_info, true);
		} else {
			$data = '{"information":[{"text":"公司简介"}]}';
			$shop_info = json_decode($data, true);
		}
		return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$shop_info]);
	}

	public function companyProfileEdit(Request $request)
	{
		if (empty($request['shin_company_profile'])) {
			return response()->json(['code'=>500, 'msg'=>'请输入公司信息', 'data'=>'请输入公司信息']);
		}

		// 获取当前操作账号信息
		$user_info = Common::getUserInfo($request['api_token']);
		$shin_id = DB::table('shop_info')
			->where('shin_shop_id', $user_info->adm_shop_id)
			->value('shin_id');
		$shop_data['shin_company_profile'] = $request['shin_company_profile'];
		$shop_data['shin_update_time'] = date('Y-m-d H:i:s');
		if ($shin_id) {
			$shin_res = DB::table('shop_info')
				->where('shin_id', $shin_id)
				->update($shop_data);
		} else {
			$shop_data['shin_shop_id'] = $user_info->adm_shop_id;
			$shop_data['shin_create_time'] = date('Y-m-d H:i:s');
			$shin_res = DB::table('shop_info')->insert($shop_data);
		}
		if ($shin_res) {
			Common::addLog($user_info, getRealIp($request), '公司简介', '编辑', $user_info->adm_name . '编辑公司简介成功');
			return response()->json(['code'=>200, 'msg'=>'编辑成功', 'data'=>'编辑成功']);
		} else {
			return response()->json(['code'=>500, 'msg'=>'编辑失败', 'data'=>'编辑失败']);
		}
	}

	/**
	 * 店铺信息
	 * @authors ldj
	 * @email  909490343@qq.com
	 * @date   2023-10-11
	 * @param  Request          $request [description]
	 * @return [type]                    [description]
	 */
	public function shopInfo(Request $request) {
		// 获取当前操作账号信息
		$user_info = Common::getUserInfo($request['api_token']);
        $adm_id = $user_info->adm_id;
        $adm_shop_id = $user_info->adm_shop_id;
        $shop_superior_id = DB::table('shop') ->where('shop_id',$adm_shop_id)->value('shop_superior_id');
        if($shop_superior_id<1){
            $shop_superior_id = $adm_shop_id;
        }
        //判定但钱用户是否有登录分店权限
        $shop_role = DB::table('admin_shop_role')
            ->where('shop_id',$shop_superior_id)
            ->where('adm_id',$adm_id)
            ->where('adm_state',1)
            ->where("login_bind_shop",1)
            ->value('id');
        //获取有登录权限门店
		$list_datas = DB::table('admin')
            ->leftJoin('admin_shop_role as asr', 'asr.adm_id', '=', 'admin.adm_id')
			->leftJoin('shop', 'shop.shop_id', '=', 'asr.shop_id')
			->leftJoin('msg_config', 'msco_shop_id', '=', 'asr.shop_id')
            ->leftjoin('role', 'role.rol_id', '=', 'asr.role_id')
			->where('admin.adm_id', $adm_id);
        if(!$shop_role){
            $list_datas = $list_datas->where('asr.create_source', 1);
        }
        $list_datas = $list_datas->where('asr.adm_state', 1)
			->where('role.rol_state', 1)
			->where('shop.shop_state', 1)
			->select('admin.adm_name', 'admin.adm_account', 'admin.adm_id', 'admin.adm_phone', 'shop_store_name', 'shop_message_num', 'msco_send_detail','asr.shop_id', 'asr.login_shop', 'shop_free_space', 'shop_toll_space', 'shop.shop_superior_id', 'shop_free_shop', 'shop_toll_shop')
			->orderBy('asr.login_shop', 'asc')
            ->get();
        $list_datas = CommonService::dataToArray($list_datas);
		$shop_id = array_column($list_datas, 'shop_id');
        $list_data = [];
		foreach($list_datas as $k => $v){
            if($v['shop_id'] == $adm_shop_id ){
                if (!empty($v['msco_send_detail'])) {
                    $msco_send_detail = explode(',',$v['msco_send_detail']);
                    if (in_array(1,$msco_send_detail)) {
                        $v['msco_add_ord'] = 1;
                    } else {
                        $v['msco_add_ord'] = 2;
                    }
                } else {
                    $v['msco_add_ord'] = 2;
                }
                if (empty($v['adm_phone'])) {
                	$list_datas[$k]['adm_phone'] = '';
                }
                $list_datas[$k]['shop_space'] = $v['shop_free_space'] + $v['shop_toll_space'];
                $list_datas[$k]['shop_use_space'] = shopFoldSize($v['shop_id']);
                if($v['shop_superior_id']<1){
                    $list_datas[$k]['superior'] = 1;
                }else{
                    $list_datas[$k]['superior'] = 2;
                }
                $shop_data = $list_datas[$k];
            }
		    if(!in_array($v['shop_superior_id'],$shop_id) || !$shop_role){
                $list_data[] = $list_datas[$k];
            }
		}
        $list_data = CommonService::resetListKey($list_data);


        if($shop_role) {
            $bind_shop = DB::table('bind_shop')
                ->leftJoin('shop', 'shop_id', '=', 'bish_lshop_id')
                ->leftJoin('msg_config', 'msco_shop_id', '=', 'bish_lshop_id')
                ->where('bish_state', 1)
                ->where('bish_fshop_id', $shop_superior_id)
                ->select('shop_store_name', 'shop_message_num', 'msco_send_detail', 'shop_id', 'shop_free_space', 'shop_toll_space')
                ->get();
        }else{
            $bind_shop = false;
        }
        if($bind_shop){
            $bind_shop = CommonService::dataToArray($bind_shop);
        }
		foreach($list_data as $key => $val) {
            if (!empty($val['msco_send_detail'])) {
                $msco_send_detail = explode(',',$val['msco_send_detail']);
                if (in_array(1,$msco_send_detail)) {
                    $val['msco_add_ord'] = 1;
                } else {
                    $val['msco_add_ord'] = 2;
                }
            } else {
                $val['msco_add_ord'] = 2;
            }
            $list_data[$key]['shop_space'] = $val['shop_free_space'] + $val['shop_toll_space'];
			$list_data[$key]['shop_use_space'] = shopFoldSize($val['shop_id']);
			if($val['shop_superior_id']<1){
                $list_data[$key]['superior'] = 1;
            }else{
                $list_data[$key]['superior'] = 2;
            }
			if($bind_shop && $val['shop_id'] == $shop_superior_id){
                $shopList = [];
                $num = 0;
                foreach($bind_shop as $k => $v){
                    if (!empty($v['shop_id'])) {
                        $shopList[$num] = $v;
                        $shopList[$num]['adm_name'] = $val['adm_name'];
                        $shopList[$num]['adm_account'] = $val['adm_account'];
                        $shopList[$num]['adm_id'] = $val['adm_id'];
                        $shopList[$num]['adm_phone'] = $val['adm_phone'];
                        $num++;
                    }
                }
                $list_data[$key]['shopList'] = $shopList;
            }else{
                $list_data[$key]['shopList'] = [];
            }
        }

//        if ($bind_shop) {
//	        foreach ($bind_shop as $key => $value) {//总店
//	        	$bind_shop[$key]['adm_name'] = $list_data[0]['adm_name'];
//	        	$bind_shop[$key]['adm_account'] = $list_data[0]['adm_account'];
//	        	$bind_shop[$key]['adm_id'] = $list_data[0]['adm_id'];
//	        	$bind_shop[$key]['adm_phone'] = $list_data[0]['adm_phone'];
//	        	$bind_shop[$key]['superior'] = 2;
//	        	if (empty($value['shop_id'])) {
//	        		unset($bind_shop[$key]);
//	        	}
//	        }
//	        $list_data = json_decode(json_encode($list_data,true),true);
//	        $bind_shop = json_decode(json_encode($bind_shop,true),true);
//	        $list_data = array_merge($list_data, $bind_shop);
//        }


		// 订单类型对应数量
        $data['unpay'] = DB::table('shop_order')
            ->where('shor_shop_id', $adm_shop_id)
            ->wherein('shor_type', [2,3])
            ->where('shor_pay_state', 1)
            ->count();
        // 待续费
        $data['renew'] = DB::table('shop_order')
            ->where('shor_shop_id', $adm_shop_id)
            ->where('shor_type', 1)
            ->where('type', 1)
            ->where('shor_pay_state', 1)
            ->count();

        $data['payed'] = DB::table('shop_order')
            ->where('shor_shop_id', $adm_shop_id)
            ->where('shor_pay_state', 2)
            ->count();
        $return_data['list_data'] = $list_data;
        $return_data['data'] = $data;
        $return_data['shop_data'] = $shop_data;
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
	}

	/**
	 * 邀请记录
	 * @authors ldj
	 * @email  909490343@qq.com
	 * @date   2024-07-23
	 * @param  Request          $request [description]
	 * @return [type]                    [description]
	 */
	public function invitation(Request $request) {
		// 获取当前操作账号信息
		$user_info = Common::getUserInfo($request['api_token']);
		$res = ShopService::invitation($user_info,$request);
		return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$res]);
	}

	/**
	 * 获取邀请二维码
	 * @authors ldj
	 * @email  909490343@qq.com
	 * @date   2024-07-26
	 * @param  Request          $request [description]
	 * @return [type]                    [description]
	 */
	public function getInvQrimg(Request $request) {
		// 获取当前操作账号信息
		$user_info = Common::getUserInfo($request['api_token']);
		$res = ShopService::getInvQrimg($user_info, $request);
		return response()->json($res);
	}
}
