<?php
namespace App\Http\Controllers\Api\SystemsManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\SystemsManage\VerifyFeaturesController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Services\ImageUpload;

class FeaturesController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 功能设置-编辑
    public function settings(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyFeaturesController;
        $error_message = $verify_data->addShowValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        if ($request['type'] == 1) {
            $shse_res = DB::table('shop_set')
                ->where('shse_shop_id', $user_info->adm_shop_id)
                ->select('shse_login', 'shse_assign', 'shse_procurement_audit', 'shse_order_price', 'shse_procurement_price', 'shse_sell_price', 'shse_junk_recycle_price', 'shse_ampere_hour_price', 'shse_stock_sell_storage', 'shse_reception_phone', 'shse_rescue_phone', 'shse_inform', 'shse_customer_evaluation', 'shse_financial_audit', 'shse_days', 'shse_brand', 'shse_duplicate_type', 'shse_order_data', 'shse_recycle_type', 'shse_payment_way', 'shse_type')
                ->first();
            // 获取当前列表下的按钮
            if ($request['pri_id']) {
                $list_button = getListButton($request['api_token'], $request['pri_id']);
            } else {
                $list_button = '';
            }
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$shse_res, 'list_button'=>$list_button]);
        }

        // 提交验证数据
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        $shse_id = DB::table('shop_set')
            ->where('shse_shop_id', $user_info->adm_shop_id)
            ->value('shse_id');
        // 1 账号设置数据
        $shse_data = [
            'shse_recycle_type' => isset($request['shse_recycle_type']) ? $request['shse_recycle_type'] : 1,
            'shse_payment_way' => isset($request['shse_payment_way']) ? $request['shse_payment_way'] : '', //打印的结算方式显示文字
            'shse_ampere_hour_price' => $request['shse_ampere_hour_price'] * 100,
            'shse_reception_phone' => $request['shse_reception_phone'], //业务受理电话
            'shse_rescue_phone' => $request['shse_rescue_phone'], //24小时救援电话
            'shse_inform' => $request['shse_inform'], //通知
            'shse_customer_evaluation' => $request['shse_customer_evaluation'], //客户评价
            'shse_financial_audit' => $request['shse_financial_audit'], //采购财审状态1不需要财务审核2需要财务审核
            'shse_days' => $request['shse_days'], //天数
            'shse_brand' => $request['shse_brand'] ? implode(",", $request['shse_brand']) : '', //品牌设置1瓦尔塔2风帆3博世4汤浅5统一6理士7德尔福
            'shse_duplicate_type' => $request['shse_duplicate_type'], //联单类型
            'shop_update_time' => date('Y-m-d H:i:s'),
            'shse_type' => isset($request['shse_type']) ? $request['shse_type'] : 2, //是否使用打印模板：1是2否
        ];
        // 根据订单类型设置打印项目
        $shse_data['shse_order_data'] = json_encode($request['info_content']);
        if ($shse_id) {
            // 编辑账号
            $shse_res =  DB::table('shop_set')
                ->where('shse_id', $shse_id)
                ->update($shse_data);
        } else {
            // 新增账号
            $shse_res =  DB::table('shop_set')->insert($shse_data);
        }
        if ($shse_res) {
            Common::addLog($user_info, getRealIp($request), '功能设置', '编辑', '编辑功能设置：成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'保存成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'保存失败']);
        }
    }

    // 图片模板设置
    public function imageUploadTemplateSet(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyFeaturesController;
        $error_message = $verify_data->imageUploadTemplateSetValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 创建model对象
        $image_manager = new ImageUpload();
        if ($request['type'] == 1) {
            // 获取图片模板信息
            $find_data = $image_manager->findShopImageTemplate($user_info->adm_shop_id);
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_data]);
        }
        // 判断图片显示文字是否重复
        $shit_template_set = json_decode($request['shit_template_set'], true);
        $template_show_word = array_unique(array_column($shit_template_set, 'show_word'));
        if (count($template_show_word) != count($shit_template_set)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'图片显示文字不允许重复']);
        }

        // 提交图片模板
        DB::beginTransaction();
        // 查询门店自定义的图片类型模板是否已经存在，如果存在将模板改为删除状态
        $update_res = $image_manager->findUpdateImageTemplateState($user_info->adm_shop_id, $request['shit_image_type']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        // 新增图片模板
        $shit_data['shit_shop_id'] = $user_info->adm_shop_id;
        $shit_data['shit_superior_shop_id'] = $shop_id;
        $shit_data['shit_template_type'] = 2;
        $shit_data['shit_image_type'] = $request['shit_image_type'];
        $shit_data['shit_template_set'] = $request['shit_template_set'];
        $shit_data['shit_template_name'] = $request['shit_template_name'];
        $add_res = ImageUpload::insert($shit_data);

        if ($update_res && $add_res) {
            Common::addLog($user_info, getRealIp($request), '功能设置', '图片上传模板', '图片上传模板设置成功');
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'图片上传模板设置成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'图片上传模板设置失败']);
        }
    }
}
