<?php

namespace App\Http\Controllers\Api\SystemsManage;

use App\Http\Models\Api\Common;
use App\Services\Business\MemberLevelService;
use App\Services\LoginUserService;
use App\Services\SystemsManage\PrivilegesService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\SystemsManage\AppletPrivilegesService;

class AppletPrivilegesController extends Controller
{

    /**
     * @name  列表页
     * @param action_name  控制器名
     * @param Request $request
     * @return mixed
     */
    public function index (Request $request)
    {
        $input = $request->all();
        $data = AppletPrivilegesService::list($input);
        return response()->json($data);
    }

    /**
     * @name  添加模块
     * @param admin_id
     * @param action_name
     * @param action_value
     * @param adg_data
     * @param Request $request
     */
    public function addModel (Request $request)
    {
        $request = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        $data = AppletPrivilegesService::addModel($user_info,$request);
        return response()->json($data);

    }

    /**
     * @name  添加栏目
     * @param admin_id
     * @param action_name
     * @param action_value
     * @param adg_data
     * @param Request $request
     */
    public function add (Request $request)
    {
        $request = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        $data = AppletPrivilegesService::add($user_info,$request);
        return response()->json($data);

    }

    /**
     * @name  添加列表
     * @param admin_id
     * @param action_name
     * @param action_value
     * @param adg_data
     * @param Request $request
     */
    public function addList (Request $request)
    {
        $request = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        $data = AppletPrivilegesService::addList($user_info,$request);
        return response()->json($data);

    }

    /**
     * @name  添加动作
     * @param admin_id
     * @param action_name
     * @param action_value
     * @param adg_data
     * @param Request $request
     */
    public function addFunction (Request $request)
    {
        $request = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        $data = AppletPrivilegesService::addFunction($user_info,$request);
        return response()->json($data);

    }

    /**
     * @name  编辑
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function edit (Request $request)
    {
        $request = $request->all();
        $data = AppletPrivilegesService::edit($request);
        return response()->json($data);
    }

    /**
     * @name  删除
     * @param adg_id  数据id
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function del (Request $request)
    {
        $request = $request->all();
        $data = AppletPrivilegesService::del($request);
        return response()->json($data);

    }

    /**
     * @name  栏目列表
     * @param admin_id
     * @param action_name
     * @param action_value
     * @param adg_data
     * @param Request $request
     */
    public function columnList (Request $request)
    {
        $data = AppletPrivilegesService::columnList();
        return response()->json($data);

    }

    /**
     * @name  左侧列表
     * @param admin_id
     * @param action_name
     * @param action_value
     * @param adg_data
     * @param Request $request
     */
    public function modelList (Request $request)
    {
        $data = AppletPrivilegesService::modelList();
        return response()->json($data);

    }

    /**
     * @name  角色对应展示的权限
     * @param admin_id
     * @param action_name
     * @param action_value
     * @param adg_data
     * @param Request $request
     */
    public function rolePrivileges (Request $request)
    {
        $data = AppletPrivilegesService::rolePrivileges(1);
        return response()->json(['code' => 200, 'msg' => '成功', 'data' =>$data]);

    }

    /**
     * @name  获取单条记录
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function getInfo (Request $request)
    {
        $request = $request->all();
        $data = AppletPrivilegesService::getInfo($request);
        return response()->json($data);
    }
}
