<?php
namespace App\Http\Controllers\Api\SystemsManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Models\Api\Common;
use App\Services\SystemsManage\PersonalService;

// 账号审核
class AccountReviewController extends Controller
{

    // 审核列表
    public function index(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $data = PersonalService::index($user_info,$request->all());
        return response()->json($data);
    }

    // 添加账号申请
    public function add(Request $request)
    {
        $data = PersonalService::Add($request->all(),2);
        return response()->json($data);
    }

    // 账号申请审核
    public function edit(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $data = PersonalService::Edit($user_info,$request->all());
        return response()->json($data);
    }

    // 账号申请详情
    public function info(Request $request)
    {
        $user_info = Common::getUserInfo($request['api_token']);
        $data = PersonalService::Info($request->all(),$user_info);
        return response()->json($data);
    }

    // 账号申请地址
    public function address(Request $request)
    {
        $role_id = $request['role_id'];
        $url = config('apisystem.server_name_https') .'/addAccNum?rol_id='.$role_id;
        //$url = 'https://xmtest.bluearp.com/addAccNum?rol_id=465';
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $url]);
    }
}
