<?php

namespace App\Http\Controllers\Api\SupplyChains;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\SupplyChains\VerifySupplyOrdersController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

class SupplyOrdersController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        $list_data = DB::table('replenishment_orders_bs as rob')
                        ->where('reob_cid', $user_info->adm_cid)
                        ->where('reob_shop_superior_id', $shop_id)
                        ->leftjoin('shop as s','rob.reob_shop_id','=','s.shop_id')
                        ->where(function($query) use($search_data) {
                        //如果选择开始时间并且选择结束时间
                        if (!empty($search_data['start_time']) && !empty($search_data['end_time'])){
                            $query->whereBetween('reob_finish_time',[$search_data['start_time'],$search_data['end_time'].' 23:59:59']);
                            }else{
                                // 如果选择开始时间
                                if (!empty($search_data['start_time'])){
                                    $query->where('reob_finish_time','>=',$search_data['start_time']);
                                }else{
                                    // 如果选择结束时间
                                    if (!empty($search_data['end_time'])) {
                                        $query->where('reob_finish_time','<=',$search_data['end_time'].' 23:59:59');
                                    }
                                }
                            }
                        }) //结款时间
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['reob_sd_order_number'])) {
                                $query->where('reob_sd_order_number', $search_data['reob_sd_order_number']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['reob_sd_order_number'])) {
                                $query->where('reob_sd_order_number', $search_data['reob_sd_order_number']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['shop_store_name'])) {
                                $query->where('shop_store_name', $search_data['shop_store_name']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['reob_state'])) {
                                $query->where('reob_state', $search_data['reob_state']);
                            }
                        })
                        ->select('reob_sd_order_number', 'reob_goo_name', 'reob_goo_quantity', 'reob_warranty_fee', 'reob_install_fee','reob_state','reob_finish_time','shop_store_name')
                        ->orderBy('reob_id', 'desc')
                        ->paginate($this->show_count);
        $state_count = DB::table('replenishment_orders_bs')
            ->where('reob_cid', $user_info->adm_cid)
            ->where('reob_shop_superior_id', $shop_id)
            ->select(DB::raw('count(*) as count, reob_state'))
            ->groupBy('reob_state')
            ->get();
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据
        $data_info['state_count'] = $state_count;

        if($list_data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }
}
