<?php

namespace App\Http\Controllers\Api\SupplyChains;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\SupplyChains\VerifySupplementedsGoodsController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

class SupplementedsGoodsController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        $list_data = DB::table('replenishment_goods_bs')
                        ->where('regb_cid', $user_info->adm_cid)
                        ->where('regb_shop_superior_id', $shop_id)
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['regb_goo_name'])) {
                                $query->where('regb_goo_name', $search_data['regb_goo_name']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['regb_goo_encode'])) {
                                $query->where('regb_goo_encode', $search_data['regb_goo_encode']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['regb_cate_name'])) {
                                $query->where('regb_cate_name', $search_data['regb_cate_name']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['regb_bra_name'])) {
                                $query->where('regb_bra_name', $search_data['regb_bra_name']);
                            }
                        })
                        ->select('regb_goo_name', 'regb_goo_encode', 'regb_cate_name', 'regb_bra_name', 'regb_stock_quantity','regb_enroute_amount','regb_stock_type')
                        ->orderBy('regb_id', 'desc')
                        ->paginate($this->show_count);
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据
        if($list_data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }

    //待补商品数据更改
    public function goodsSurplus(Request $request)
    {
        // 接收数据流
        $request= file_get_contents("php://input");
        // 解析
        Common::write_log($request);
        // 验证数据
        $request = json_decode($request, true);
        if (empty($request['regb_shop_id']) || empty($request['regb_sd_goo_id']) || empty($request['goo_quantity']) || empty($request['type']) || empty($request['time']) || empty($request['token'])) {
            return response()->json(['code'=>202, 'msg'=>'参数错误']);
        }
        $token = md5(md5($request['time'].'c883e5e641818d993a2d8d966ca450bf'));
        if($request['token'] !== $token){
            return response()->json(['code'=>203,'msg'=>'token校验失败']);
        }
        $shop_id = DB::connection('mysql_scm')
                ->table('channel')
                ->where('chan_bound_id',$request['regb_shop_id'])
                ->value('chan_shop_id');
        $user_info = DB::table('shop')
                ->where('shop_id',$shop_id)
                ->first(['shop_superior_id','shop_cid']);
        $shop_superior_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $shop_id;
        if(empty($shop_id)){
            return response()->json(['code'=> 204, 'msg'=>'门店编号不存在']);
        }
        //获取待补商品数据
        $regw_data = DB::table('replenishment_goods_bs')
            ->where('regb_sd_goo_id',$request['regb_sd_goo_id'])
            ->where('regb_shop_id',$shop_id)
            ->first(['regb_stock_type','regb_stock_quantity','regb_id']);
        if(!empty($regw_data)){
            $num = 1;
            $data['regb_update_time'] = date('Y-m-d H:i:s');
            //1加  2减
            if($request['type'] == 1){
                $regb_res = DB::table('replenishment_goods_bs')
                    ->where('regb_shop_id',$shop_id)
                    ->where('regb_sd_goo_id',$request['regb_sd_goo_id'])
                    ->increment('regb_stock_quantity',$request['goo_quantity']);
                if ($regw_data->regb_stock_type == 2) {
                    $data['regb_stock_quantity'] = $num + $regw_data->regb_stock_quantity;
                    $data['regb_stock_type'] = 2;
                } else if($regw_data->regb_stock_type == 3){
                    if ($regw_data->regb_stock_quantity > $num) {
                        $data['regb_stock_quantity'] = $regw_data->regb_stock_quantity - $num;
                        $data['regb_stock_type'] = 3;
                    } else if ($regw_data->regb_stock_quantity < $num){
                        $data['regb_stock_type'] = 2;//库存类型1平2正3负
                        $data['regb_stock_quantity'] = $num - $regw_data->regb_stock_quantity;
                    } else {
                        $data['regb_stock_type'] = 1;//库存类型1平2正3负
                        $data['regb_stock_quantity'] = $num - $regw_data->regb_stock_quantity;
                    }
                } else if($regw_data->regb_stock_type == 1){
                    $data['regb_stock_type'] = 2;
                    $data['regb_stock_quantity'] = $regw_data->regb_stock_quantity + 1;
                }
                $regb_res = DB::table('replenishment_goods_bs')
                    ->where('regb_id',$regw_data->regb_id)
                    ->update($data);
            }else if($request['type'] == 2){
                $regb_res = DB::table('replenishment_goods_bs')
                    ->where('regb_shop_id',$shop_id)
                    ->where('regb_sd_goo_id',$request['regb_sd_goo_id'])
                    ->increment('regb_stock_quantity',$request['goo_quantity']);
                if ($regw_data->regb_stock_type == 2) {
                    if ($regw_data->regb_stock_quantity > $num) {
                        $data['regb_stock_type'] = 2;//库存类型1平2正3负
                        $data['regb_stock_quantity'] =$regw_data->regb_stock_quantity - $num;
                    } else if ($regw_data->regb_stock_quantity < $num){
                        $data['regb_stock_quantity'] = $num - $regw_data->regb_stock_quantity;
                        $data['regb_stock_type'] = 3;//库存类型1平2正3负
                    } else {
                        $data['regb_stock_type'] = 1;//库存类型1平2正3负
                        $data['regb_stock_quantity'] = $num - $regw_data->regb_stock_quantity;
                    }
                } else if($regw_data->regb_stock_type == 3){
                    $data['regb_stock_quantity'] = $num + $regw_data->regb_stock_quantity;
                    $data['regb_stock_type'] = 3;
                } else if($regw_data->regb_stock_type == 1){
                    $data['regb_stock_type'] = 3;
                    $data['regb_stock_quantity'] = $regw_data->regb_stock_quantity + 1;
                }
                $regb_res = DB::table('replenishment_goods_bs')
                    ->where('regb_id',$regw_data->regb_id)
                    ->update($data);
            }
        }else{
            $rego_data = DB::connection('mysql_scm')
                ->table('relationship_goods')
                ->where('rego_sd_goo_id',$request['regb_sd_goo_id'])
                ->first(['rego_id','rego_goo_name','rego_goo_encode','rego_cate_name','rego_bra_name']);
            if(empty($rego_data)){
                return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'商品未绑定']);
            }
            if($request['type'] == 1){
                $stock_type = 2;
            }else{
                $stock_type = 3;
            }
            $regb_data['regb_cid'] = $user_info->shop_cid;
            $regb_data['regb_shop_id'] = $shop_id;
            $regb_data['regb_shop_superior_id'] = $shop_superior_id;
            $regb_data['regb_sd_goo_id'] = $request['regb_sd_goo_id'];
            $regb_data['regb_goo_id'] = $rego_data->rego_id;
            $regb_data['regb_goo_name'] = $rego_data->rego_goo_name;
            $regb_data['regb_goo_encode'] = $rego_data->rego_goo_encode;
            $regb_data['regb_cate_name'] = $rego_data->rego_cate_name;
            $regb_data['regb_bra_name'] = $rego_data->rego_bra_name;
            $regb_data['regb_stock_type'] = $stock_type;
            $regb_data['regb_stock_quantity'] = 1;
            $regb_res = DB::table('replenishment_goods_bs')->insert($regb_data);
        }
        if ($regb_res) {
            return response()->json(["code"=>200,'msg'=>'回传成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'回传失败']);
        }
    }
}
