<?php

namespace App\Http\Controllers\Api\SalesManagement;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\SalesManagement\VerifySalesStatisticsController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

class SalesStatisticsController extends Controller
{
	// 列表每页显示数据个数
    protected $show_count = 10;

    //销售统计列表查询
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifySalesStatisticsController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        // 去除首尾空格
        $request['year'] = trim($request['year']);
        $request['month'] = trim($request['month']);
        $request['day'] = trim($request['day']);

        if(!empty($request['year']) && !empty($request['month']) && !empty($request['day'])){
            $request['start_time'] = $request['year'].'-'.$request['month'].'-'.$request['day'].' '.'00:00:00';
            $request['end_time'] = $request['year'].'-'.$request['month'].'-'.$request['day'].' '.'23:59:59';
        }else if(!empty($request['year']) && !empty($request['month'])){
            $request['start_time'] = $request['year'].'-'.$request['month'].'-01 00:00:00';
            //当前月份有几天
            $days = date('t', strtotime($request['year'].'-'.$request['month']));
            $request['end_time'] = $request['year'].'-'.$request['month'].'-'.$days.' 23:59:59';
        }else if(!empty($request['year'])){
            $request['start_time'] = $request['year'].'-01-01 00:00:00';
            $request['end_time'] = $request['year'].'-12-31 23:59:59';
        }else{
            return response()->json(['code'=>200,'msg'=>'error','data'=>[[]]]);
        }
        switch ($request['type']) {
            //商品销量
            case '1':
                $list_data = $this->goodsSales($user_info,$shop_id,$request);
                break;
            //品牌销量
            case '2':
                $list_data = $this->brandSales($user_info,$shop_id,$request);
                break;
            //客户销量
            case '3':
                $list_data = $this->clientSales($user_info,$shop_id,$request);
                break;
            //区域销量
            case '4':
                $list_data = $this->regionSales($user_info,$shop_id,$request);
                return response()->json(['code'=>200,'msg'=>'success','data'=>$list_data]);
                break;
            //销售回款
            case '5':
                $list_data = $this->incomeSales($user_info,$shop_id,$request);
                return response()->json(['code'=>200,'msg'=>'success','data'=>$list_data]);
            //区域回款
            case '6':
                $list_data = $this->regionRepay($user_info,$shop_id,$request);
                return response()->json(['code'=>200,'msg'=>'success','data'=>$list_data]);
                break;
            //客户回款
            case '7':
                $list_data = $this->clientRepay($user_info,$shop_id,$request);
                return response()->json(['code'=>200,'msg'=>'success','data'=>$list_data]);
            //锁单统计
            case '8':
                $list_data = $this->lockOrder($user_info,$shop_id,$request);
                return response()->json(['code'=>200,'msg'=>'success','data'=>$list_data]);
            //退单统计
            case '9':
                $list_data = $this->withdrawOrder($user_info,$shop_id,$request);
                return response()->json(['code'=>200,'msg'=>'success','data'=>$list_data]);
            default:
                return response()->json(['code'=>200,'msg'=>'success','data'=>[[]]]);
                break;
        }
        $data_info['current_page'] = $list_data->currentPage(); //当前页面页码
        $data_info['last_page'] = $list_data->lastPage(); //表示最后一页的页码
        $data_info['total'] = $list_data->total(); //总数据个数
        $data_info['current_number'] = $this->show_count; //一页显示多少个
        $data_info['data'] = $list_data->items(); //返回数据
        $amount = 0;
        foreach ($data_info['data'] as $key => $value) {
            $amount += $value->amount;
        }
        $data_info['amount'] = $amount;
        if($list_data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>[[]]]);
        }
    }

    /**
     * 商品销量统计
     * @param $user_info  用户信息
     * @param $shop_id    总店id
     * @param $request    提交参数
     * @return data       数据
     */
    protected function goodsSales($user_info,$shop_id,$request)
    {
        $order_id_one = DB::table('order')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_superior_shop_id',$shop_id)
            ->where('ord_wor_state',4)
            ->whereNotIn('ord_service_type',[5,6])//不包括发货单,结清单
            ->whereBetween('ord_create_time',[$request['start_time'],$request['end_time']])
            ->pluck('ord_id')->toArray();
        $order_id_two = DB::table('order as o')
            ->Join('dispatch_bill as db','o.ord_id','=','db.dego_wor_id')
            ->where('o.ord_cid', $user_info->adm_cid)
            ->where('o.ord_superior_shop_id',$shop_id)
            ->where('o.ord_wor_state',5)
            ->where('db.dego_type',2)
            ->where('db.dego_order_type',1)
            ->whereIn('o.ord_service_type',[5,6])//包括发货单,结清单
            ->whereBetween('o.ord_create_time',[$request['start_time'],$request['end_time']])
            ->pluck('ord_id')->toArray();
        $order_id = array_merge($order_id_one,$order_id_two);

        $list_data = DB::table('order_goods')
            ->whereIn('orgo_ord_id',$order_id)
            ->whereIn('orgo_goo_type',[1,2])
            ->where('orgo_state',1)
            ->select(DB::raw('orgo_goo_name as name,sum(orgo_goo_quantity) as amount'))
            ->groupBy('orgo_goo_id')
            ->orderBy('amount', 'desc')
            ->paginate($this->show_count);
        return $list_data;
    }

    /**
     * 品牌销量统计
     * @param $user_info  用户信息
     * @param $shop_id    总店id
     * @param $request    提交参数
     * @return data       数据
     */
    protected function brandSales($user_info,$shop_id,$request)
    {
        $order_id_one = DB::table('order')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_superior_shop_id',$shop_id)
            ->where('ord_wor_state',4)
            ->whereNotIn('ord_service_type',[5,6])//不包括发货单,结清单
            ->whereBetween('ord_create_time',[$request['start_time'],$request['end_time']])
            ->pluck('ord_id')->toArray();
        $order_id_two = DB::table('order as o')
            ->Join('dispatch_bill as db','o.ord_id','=','db.dego_wor_id')
            ->where('o.ord_cid', $user_info->adm_cid)
            ->where('o.ord_superior_shop_id',$shop_id)
            ->where('o.ord_wor_state',5)
            ->where('db.dego_type',2)
            ->where('db.dego_order_type',1)
            ->whereIn('o.ord_service_type',[5,6])//包括发货单,结清单
            ->whereBetween('o.ord_create_time',[$request['start_time'],$request['end_time']])
            ->pluck('ord_id')->toArray();
        $order_id = array_merge($order_id_one,$order_id_two);

        $list_data = DB::table('order_goods as or')
            ->leftjoin('goods as g','g.goo_id','=','or.orgo_goo_id')
            ->leftjoin('brand as b','b.bra_id','=','g.goo_bra_id')
            ->whereIn('or.orgo_ord_id',$order_id)
            ->whereIn('or.orgo_goo_type',[1,2])
            ->where('or.orgo_state',1)
            ->where('b.bra_delete',1)
            ->select(DB::raw('bra_name as name,sum(orgo_goo_quantity) as amount'))
            ->groupBy('bra_id')
            ->orderBy('amount', 'desc')
            ->paginate($this->show_count);
        return $list_data;
    }
    
    /**
     * 客户销量
     * @param $user_info  用户信息
     * @param $shop_id    总店id
     * @param $request    提交参数
     * @return data       数据
     */
    protected function clientSales($user_info,$shop_id,$request)
    {
        $order_id_one = DB::table('order')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_superior_shop_id',$shop_id)
            ->where('ord_wor_state',4)
            ->where('ord_type',2)//1门店零售2渠道单位
            ->whereNotIn('ord_service_type',[5,6])//不包括发货单,结清单
            ->whereBetween('ord_create_time',[$request['start_time'],$request['end_time']])
            ->pluck('ord_id')->toArray();
        $order_id_two = DB::table('order as o')
            ->Join('dispatch_bill as db','o.ord_id','=','db.dego_wor_id')
            ->where('o.ord_cid', $user_info->adm_cid)
            ->where('o.ord_superior_shop_id',$shop_id)
            ->where('o.ord_wor_state',5)//订单的工单状态4已完成5无工单
            ->where('ord_type',2)//1门店零售2渠道单位
            ->where('db.dego_type',2)//类型：1未出库2已出库3作废4锁定
            ->where('db.dego_order_type',1)//1.订单发货 2.工单发货
            ->whereIn('o.ord_service_type',[5,6])//包括发货单,结清单
            ->whereBetween('o.ord_create_time',[$request['start_time'],$request['end_time']])
            ->pluck('ord_id')->toArray();
        $order_id = array_merge($order_id_one,$order_id_two);

        $list_data = DB::table('order_goods as or')
            ->join('order as o','o.ord_id','=','or.orgo_ord_id')
            ->join('channel_unit as cu','cu.chun_id','=','o.ord_client_id')
            ->whereIn('or.orgo_ord_id',$order_id)
            ->whereIn('or.orgo_goo_type',[1,2])
            ->where('or.orgo_state',1)
            ->select(DB::raw('chun_unit_name as name,sum(orgo_goo_quantity) as amount'))
            ->groupBy('ord_client_id')
            ->orderBy('amount', 'desc')
            ->paginate($this->show_count);
        return $list_data;
    }

    /**
     * 区域销量
     * @param $user_info  用户信息
     * @param $shop_id    总店id
     * @param $request    提交参数
     * @return data       数据
     */
    protected function regionSales($user_info,$shop_id,$request)
    {
        $order_id_one = DB::table('order')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_superior_shop_id',$shop_id)
            ->where('ord_wor_state',4)
            ->where('ord_type',2)//1门店零售2渠道单位
            ->whereNotIn('ord_service_type',[5,6])//不包括发货单,结清单
            ->whereBetween('ord_create_time',[$request['start_time'],$request['end_time']])
            ->pluck('ord_id')->toArray();
        $order_id_two = DB::table('order as o')
            ->Join('dispatch_bill as db','o.ord_id','=','db.dego_wor_id')
            ->where('o.ord_cid', $user_info->adm_cid)
            ->where('o.ord_superior_shop_id',$shop_id)
            ->where('o.ord_wor_state',5)//订单的工单状态4已完成5无工单
            ->where('ord_type',2)//1门店零售2渠道单位
            ->where('db.dego_type',2)//类型：1未出库2已出库3作废4锁定
            ->where('db.dego_order_type',1)//1.订单发货 2.工单发货
            ->whereIn('o.ord_service_type',[5,6])//包括发货单,结清单
            ->whereBetween('o.ord_create_time',[$request['start_time'],$request['end_time']])
            ->pluck('ord_id')->toArray();
        $order_id = array_merge($order_id_one,$order_id_two);
        $list_data = DB::table('order_goods as or')
            ->join('order as o','o.ord_id','=','or.orgo_ord_id')
            ->join('channel_info as ci','ci.chin_chun_id','=','o.ord_client_id')
            ->whereIn('or.orgo_ord_id',$order_id)
            ->whereIn('or.orgo_goo_type',[1,2])
            ->where('or.orgo_state',1)
            ->select(DB::raw('chin_prec_id,sum(orgo_goo_quantity) as amount'))
            ->groupBy('chin_prec_id')
            ->orderBy('amount', 'desc')
            ->paginate($this->show_count);
        $data = $list_data->items();
        $prec_id = [];
        foreach ($data as $key => $value) {
            $prec_id[] = $value->chin_prec_id;
        }
        //业务划区表去除业务划区名称
        $prec_data = DB::table('precincts')
            ->whereIn('prec_id',$prec_id)
            ->pluck('prec_name','prec_id');
        foreach ($data as $key => $value) {
            $data[$key]->name = isset($prec_data[$value->chin_prec_id]) ? $prec_data[$value->chin_prec_id] : '';
            unset($data[$key]->chin_prec_id);
        }
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();//表示最后一页的页码
        $data_info['total'] = $list_data->total();//总数据个数
        $data_info['current_number'] = $this->show_count;//一页显示多少个
        $data_info['data'] = $data;//返回数据
        $amount = 0;//计算总金额
        foreach ($data_info['data'] as $key => $value) {
            $amount += $value->amount;
        }
        $data_info['amount'] = $amount;
        return $list_data;
    }

    /**
     * 销售回款
     * @param $user_info  用户信息
     * @param $shop_id    总店id
     * @param $request    提交参数
     * @return data       数据
     */
    protected function incomeSales($user_info,$shop_id,$request)
    {
        //支出
        $list_one = DB::table('accounting_settlement')
            ->where('acset_inex_type',1)//类型1收入2支出
            ->where('acset_state',2)//状态：1未核对2已核对
            ->whereBetween('acset_remit_time',[$request['start_time'],$request['end_time']])
            ->select(DB::raw('acset_acti_id as id,sum(acset_actual_price) as amount'))
            ->groupBy('acset_acti_id')
            ->get();
        
        //收入
        $list_two = DB::table('accounting_settlement')
            ->where('acset_inex_type',2)//类型1收入2支出
            ->where('acset_state',2)//状态：1未核对2已核对
            ->whereBetween('acset_remit_time',[$request['start_time'],$request['end_time']])
            ->select(DB::raw('acset_acti_id as id,sum(acset_actual_price) as amount'))
            ->groupBy('acset_acti_id')
            ->get()
            ->keyBy('id')->toArray();

        $acti_id = [];
        //既有正值又有负值
        foreach ($list_one as $key => $value) {
            if(isset($list_two[$value->id])){
                $list_one[$key]->amount = $value->amount - $list_two[$value->id]->amount;
                unset($list_two[$value->id]);
            }
            $acti_id[] = $value->id;
        }
        //只有负值
        foreach ($list_two as $key => $value) {
            $value->amount =  -$value->amount;
            $list_one[] = $value;
            $acti_id[] = $value->id;
        }

        //结款明细表数据
        $list_data = DB::table('account_title')
            ->where('acti_adm_id',$user_info->adm_cid)
            ->whereIn('acti_id',$acti_id)
            ->where('acti_shop_superior_id',$shop_id)
            ->select('acti_id','acti_course_title as name')
            ->paginate($this->show_count);
        $data = $list_data->items();
        $data = json_decode(json_encode($data),true);

        foreach ($data as $key => $value) {
            foreach ($list_one as $k => $v) {
                if($value['acti_id'] == $v->id){
                    $data[$key]['amount'] = $v->amount;
                }
            }
        }
        //去除多余字段
        foreach ($data as $key => $value) {
            unset($data[$key]['acti_id']);
            if(!isset($data[$key]['amount'])){
                // $data[$key]['amount'] = 0;
                unset($data[$key]);
            }else{
                $data[$key]['amount'] = $value['amount'] / 100;//换算成元
            }
        }
        //倒序金额排序
        $data = $this->arraySort($data, 'amount', SORT_DESC);

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();//表示最后一页的页码
        $data_info['total'] = $list_data->total();//总数据个数
        $data_info['current_number'] = $this->show_count;//一页显示多少个
        $data_info['data'] = $data;//返回数据
        $amount = 0;//计算总金额
        foreach ($data_info['data'] as $key => $value) {
            $amount += $value['amount'];
        }
        $data_info['amount'] = $amount;
        return $data_info;
    }

    /**
     * 区域回款
     * @param $user_info  用户信息
     * @param $shop_id    总店id
     * @param $request    提交参数
     * @return data       数据
     */
    protected function regionRepay($user_info,$shop_id,$request)
    {
        //收入
        $list_one = DB::table('accounting_settlement')
            ->where('acset_inex_type',1)//类型1收入2支出
            ->where('acset_state',2)//状态：1未核对2已核对
            ->where('acset_client_type',2)//买家类型1门店零售2来往单位
            ->whereBetween('acset_remit_time',[$request['start_time'],$request['end_time']])
            ->select(DB::raw('acset_client_id as id,sum(acset_actual_price) as amount'))
            ->groupBy('acset_client_id')
            ->get();

        //支出
        $list_two = DB::table('accounting_settlement')
            ->where('acset_inex_type',2)//类型1收入2支出
            ->where('acset_state',2)//状态：1未核对2已核对
            ->where('acset_client_type',2)//买家类型1门店零售2来往单位
            ->whereBetween('acset_remit_time',[$request['start_time'],$request['end_time']])
            ->select(DB::raw('acset_client_id as id,sum(acset_actual_price) as amount'))
            ->groupBy('acset_client_id')
            ->get()
            ->keyBy('id')->toArray();
                $chun_id = [];
        //既有正值又有负值
        foreach ($list_one as $key => $value) {
            if(isset($list_two[$value->id])){
                $list_one[$key]->amount = $value->amount - $list_two[$value->id]->amount;
                unset($list_two[$value->id]);
            }
            $chun_id[] = $value->id;
        }
        //只有负值
        foreach ($list_two as $key => $value) {
            $value->amount =  -$value->amount;
            $list_one[] = $value;
            $chun_id[] = $value->id;
        }
        //客户单位数据
        $chin_data = DB::table('channel_unit as cu')
            ->join('channel_info as ci','ci.chin_chun_id','=','cu.chun_id')
            ->where('chun_cid',$user_info->adm_cid)
            ->where('chun_superior_shop_id',$shop_id)
            ->whereIn('chun_state',[1,2])//1.启用 2.停用
            ->whereIn('chun_id',$chun_id)
            ->select('chin_chun_id','chin_prec_id')
            ->get();
        $chin_data = json_decode(json_encode($chin_data),true);
        $prec_id = [];
        foreach ($chin_data as $key => $value) {
            $prec_id[] = $value['chin_prec_id'];
            foreach ($list_one as $k => $v) {
                if($value['chin_chun_id'] == $v->id){
                    $chin_data[$key]['amount'] = $v->amount;
                }
            }
        }
        //去除多余字段
        foreach ($chin_data as $key => $value) {
            if(!isset($chin_data[$key]['amount'])){
                $chin_data[$key]['amount'] = 0;
            }else{
                $chin_data[$key]['amount'] = $value['amount'] / 100;//换算成元
            }
        }
        $list_data = DB::table('precincts')
            ->whereIn('prec_id',$prec_id)
            ->select('prec_id','prec_name as name')
            ->paginate($this->show_count);
        $data = $list_data->items();
        $data = json_decode(json_encode($data),true);
        //将相同区域的数值相加
        foreach ($chin_data as $k => $v) {
            if(isset($calculate[$v['chin_prec_id']])){
                $calculate[$v['chin_prec_id']]['amount'] += $v['amount'];
            }else{
                $calculate[$v['chin_prec_id']] = $v;
            }
        }
        //将计算出的金额放入列表数组中
        foreach ($data as $key => $value) {
            foreach ($calculate as $k => $v) {
                if($value['prec_id'] == $v['chin_prec_id']){
                    $data[$key]['amount'] = $v['amount'];
                }
            }
            unset($data[$key]['prec_id']);
        }
        //倒序金额排序
        $data = $this->arraySort($data, 'amount', SORT_DESC);

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();//表示最后一页的页码
        $data_info['total'] = $list_data->total();//总数据个数
        $data_info['current_number'] = $this->show_count;//一页显示多少个
        $data_info['data'] = $data;//返回数据
        $amount = 0;//计算总金额
        foreach ($data_info['data'] as $key => $value) {
            $amount += $value['amount'];
        }
        $data_info['amount'] = $amount;
        return $data_info;
    }

    /**
     * 客户回款
     * @param $user_info  用户信息
     * @param $shop_id    总店id
     * @param $request    提交参数
     * @return data       数据
     */
    protected function clientRepay($user_info,$shop_id,$request)
    {
        //收入
        $list_one = DB::table('accounting_settlement')
            ->where('acset_inex_type',1)//类型1收入2支出
            ->where('acset_state',2)//状态：1未核对2已核对
            ->where('acset_client_type',2)//买家类型1门店零售2来往单位
            ->whereBetween('acset_remit_time',[$request['start_time'],$request['end_time']])
            ->select(DB::raw('acset_client_id as id,sum(acset_actual_price) as amount'))
            ->groupBy('acset_client_id')
            ->get();

        //支出
        $list_two = DB::table('accounting_settlement')
            ->where('acset_inex_type',2)//类型1收入2支出
            ->where('acset_state',2)//状态：1未核对2已核对
            ->where('acset_client_type',2)//买家类型1门店零售2来往单位
            ->whereBetween('acset_remit_time',[$request['start_time'],$request['end_time']])
            ->select(DB::raw('acset_client_id as id,sum(acset_actual_price) as amount'))
            ->groupBy('acset_client_id')
            ->get()
            ->keyBy('id')->toArray();

        $chun_id = [];
        //既有正值又有负值
        foreach ($list_one as $key => $value) {
            if(isset($list_two[$value->id])){
                $list_one[$key]->amount = $value->amount - $list_two[$value->id]->amount;
                unset($list_two[$value->id]);
            }
            $chun_id[] = $value->id;
        }
        //只有负值
        foreach ($list_two as $key => $value) {
            $value->amount =  -$value->amount;
            $list_one[] = $value;
            $chun_id[] = $value->id;
        }
        //客户单位数据
        $list_data = DB::table('channel_unit')
            ->where('chun_cid',$user_info->adm_cid)
            ->where('chun_superior_shop_id',$shop_id)
            ->whereIn('chun_state',[1,2])//1.启用 2.停用
            ->whereIn('chun_id',$chun_id)
            ->select('chun_id','chun_unit_name as name')
            ->paginate($this->show_count);

        $data = $list_data->items();
        $data = json_decode(json_encode($data),true);

        foreach ($data as $key => $value) {
            foreach ($list_one as $k => $v) {
                if($value['chun_id'] == $v->id){
                    $data[$key]['amount'] = $v->amount;
                }
            }
        }
        $chun_id = [];
        //去除多余字段
        foreach ($data as $key => $value) {
            $chun_id[] = $data[$key]['chun_id'];
            unset($data[$key]['chun_id']);
            if(!isset($data[$key]['amount'])){
                $data[$key]['amount'] = 0;
            }else{
                $data[$key]['amount'] = $value['amount'] / 100;//换算成元
            }
        }
        //倒序金额排序
        $data = $this->arraySort($data, 'amount', SORT_DESC);
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();//表示最后一页的页码
        $data_info['total'] = $list_data->total();//总数据个数
        $data_info['current_number'] = $this->show_count;//一页显示多少个
        $data_info['data'] = $data;//返回数据
        $amount = 0;//计算总金额
        foreach ($data_info['data'] as $key => $value) {
            $amount += $value['amount'];
        }
        $data_info['amount'] = $amount;
        return $data_info;
    }

    /**
     * 锁单统计
     * @param $user_info  用户信息
     * @param $shop_id    总店id
     * @param $request    提交参数
     * @return data       数据
     */
    protected function lockOrder($user_info,$shop_id,$request)
    {

        $list_data = DB::table('work_order')
            ->where('wor_cid', $user_info->adm_cid)
            ->where('wor_superior_shop_id',$shop_id)
            ->where('wor_pass',4)//审核：1.待审核 2.合格 3.不合格 4锁定
            ->whereBetween('wor_create_time',[$request['start_time'],$request['end_time']])
            ->select(DB::raw('wor_service_type,count(*) as amount'))
            ->groupBy('wor_service_type')
            ->orderBy('amount', 'desc')
            ->paginate($this->show_count);
        $data = $list_data->items();

        foreach ($data as $key => $value) {
            if($value->wor_service_type == 1){
                $name = '服务单';
            }else if($value->wor_service_type == 2){
                $name = '销售单';
            }else if($value->wor_service_type == 3){
                $name = '换货单';
            }else if($value->wor_service_type == 4){
                $name = '退货单';
            }else if($value->wor_service_type == 5){
                $name = '发货单';
            }else if($value->wor_service_type == 6){
                $name = '结清单';
            }else if($value->wor_service_type == 7){
                $name = '救援单';
            }
            $data[$key]->name = $name;
            unset($data[$key]->wor_service_type);
        }
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();//表示最后一页的页码
        $data_info['total'] = $list_data->total();//总数据个数
        $data_info['current_number'] = $this->show_count;//一页显示多少个
        $data_info['data'] = $data;//返回数据
        $amount = 0;//计算总金额
        foreach ($data_info['data'] as $key => $value) {
            $amount += $value->amount;
        }
        $data_info['amount'] = $amount;
        return $data_info;
    }

    /**
     * 退单统计
     * @param $user_info  用户信息
     * @param $shop_id    总店id
     * @param $request    提交参数
     * @return data       数据
     */
    protected function withdrawOrder($user_info,$shop_id,$request)
    {

        $list_data = DB::table('order')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_superior_shop_id',$shop_id)
            ->where('ord_delete',2)//1正常订单2取消订单
            ->whereBetween('ord_create_time',[$request['start_time'],$request['end_time']])
            ->select(DB::raw('ord_service_type,count(*) as amount'))
            ->groupBy('ord_service_type')
            ->orderBy('amount', 'desc')
            ->paginate($this->show_count);
        $data = $list_data->items();

        foreach ($data as $key => $value) {
            if($value->ord_service_type == 1){
                $name = '服务单';
            }else if($value->ord_service_type == 2){
                $name = '销售单';
            }else if($value->ord_service_type == 3){
                $name = '换货单';
            }else if($value->ord_service_type == 4){
                $name = '退货单';
            }else if($value->ord_service_type == 5){
                $name = '发货单';
            }else if($value->ord_service_type == 6){
                $name = '结清单';
            }else if($value->ord_service_type == 7){
                $name = '救援单';
            }
            $data[$key]->name = $name;
            unset($data[$key]->ord_service_type);
        }
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();//表示最后一页的页码
        $data_info['total'] = $list_data->total();//总数据个数
        $data_info['current_number'] = $this->show_count;//一页显示多少个
        $data_info['data'] = $data;//返回数据
        $amount = 0;//计算总金额
        foreach ($data_info['data'] as $key => $value) {
            $amount += $value->amount;
        }
        $data_info['amount'] = $amount;
        return $data_info;
    }

    /**
     * 二维数组根据某个字段排序
     * @param array $array 要排序的数组
     * @param string $keys   要排序的键字段
     * @param string $sort  排序类型  SORT_ASC     SORT_DESC 
     * @return array 排序后的数组
     */
    public function arraySort($array, $keys, $sort = SORT_DESC) {
        $keysValue = [];
        foreach ($array as $k => $v) {
            $keysValue[$k] = $v['amount'];
        }
        array_multisort($keysValue, $sort, $array);
        return $array;
    }
}
