<?php
namespace App\Http\Controllers\Api\ProductManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\ProductManage\VerifyWearingPartController;
use App\Http\Controllers\Api\DataSearch\VehicleInquireController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Services\ProductManage\WearingPart;

// 基础管理 -- 易损件列表
class WearingPartController extends Controller
{
	// 列表每页显示数据个数
    protected $show_count = 10;

	// 易损件商品列表
    public function wearingPartindex(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyWearingPartController;
        $error_message = $verify_data->wearingPartindexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        $list_data = DB::table('goods as a')
            ->leftJoin('goods_affiliate as b', 'a.goo_id', '=', 'b.goaf_goo_id')
            ->where('a.goo_type', 5)
            ->where('a.goo_delete', 1)
            ->where(function ($query) use ($shop_id) {
                $query->where('a.goo_superior_shop_id', 0) //门店id为0的是系统数据
                    ->Orwhere('a.goo_superior_shop_id', $shop_id); //账号所属门店id
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_state'])) {
                    $query->where('a.goo_state', $search_data['goo_state']);
                }
            }) //状态
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_bra_id'])) {
                    $query->where('a.goo_bra_id', $search_data['goo_bra_id']);
                }
            }) //品牌id
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_cate_id'])) {
                    $query->where('a.goo_cate_id', $search_data['goo_cate_id']);
                }
            }) //品类id
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_class'])) {
                    $query->where('goo_class', $search_data['goo_class']);
                }
            }) //类型1自营商品2系统商品
            ->select('a.goo_id', 'a.goo_name', 'a.goo_bra_name', 'a.goo_state', 'a.goo_goods_encode', 'a.goo_cate_name', 'a.goo_price', 'a.goo_wholesale_price', 'a.goo_purchase_price', 'a.goo_channel_price', 'a.goo_shop_price', 'a.goo_vip_price', 'a.goo_brse_id', 'a.goo_goods_code', 'a.goo_class', 'b.goaf_goods_bar_code', 'b.goaf_min_order_quantity', 'b.goaf_arrival_period', 'goaf_weight')
            ->orderBy('a.goo_id', 'desc')
            ->paginate($this->show_count);
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $list_items = $list_data->items();

        $brse_data = []; //品牌系列数据

        if ($list_items) {
            foreach ($list_items as $key => $value) {
                $ware_id = DB::table('warehouse')
                    ->where('ware_shop_id', $shop_id)
                    ->select('ware_id')
                    ->get()->toArray();
                $ware_ids = array_column($ware_id, 'ware_id');
                $kucun = DB::table('warehouse_goods')
                    ->whereIn('wago_ware_id', $ware_ids)
                    ->where('wago_goo_id', $value->goo_id)
                    ->select('wago_stock_number', 'wago_lock_amount')
                    ->get()->toArray();
                $kucun_number = array_sum(array_column($kucun, 'wago_stock_number'));
                $list_data[$key]->kucun = $kucun_number;
            }

            // 查询品牌系列数据
            $goo_brse_id = array_filter(array_unique(array_column($list_items, 'goo_brse_id')));
            if ($goo_brse_id) {
                $brse_data = DB::table('brand_serie')
                    ->whereIn('brse_id', $goo_brse_id)
                    ->select('brse_id', 'brse_name')
                    ->get();
            }
        }
        $bra_data = DB::table('goods_bra_cate')
            ->where('gobc_shop_id', $user_info->adm_shop_id)
            ->where('gobc_attribute', 2)
            ->select('gobc_bra_id', 'gobc_bra_name')
            ->get()->toArray();
        foreach ($bra_data as $key => $value) {
            $bra_data[$key]->cate_data = DB::table('goods_bra_cate')
                ->where('gobc_shop_id', $user_info->adm_shop_id)
                ->where('gobc_attribute', 2)
                ->where('gobc_bra_id', $value->gobc_bra_id)
                ->select('gobc_cate_id', 'gobc_cate_name', 'gobc_number')
                ->get()->toArray();
        }
        $data_info['data'] = $list_items; //返回数据
        $data_info['bra_data'] = $bra_data;
        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'list_button'=>$list_button]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // 新增易损件
    public function addwearingPart(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyWearingPartController;
        $error_message = $verify_data->addwearingPartValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        DB::beginTransaction();

        $WearingPart = new WearingPart;
        $add_res = $WearingPart->addwearingPart($request,$user_info);

        if ($add_res['code'] == 200) {
            DB::commit();
            Common::addLog($user_info, getRealIp($request), '商品列表', '新增', '新增商品：' . $request['goo_name'] . '成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'新增商品：成功']);
        } else {
            DB::rollBack();
            return response()->json($add_res);
        }
    }

    //编辑易损件
    public function editwearingPart(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyWearingPartController;
        $error_message = $verify_data->editwearingPartValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        if ($request['type'] == 1) {
            // 获取编辑页面数据
            $find_data = DB::table('goods as a')
                ->leftJoin('goods_affiliate as b', 'a.goo_id', '=', 'b.goaf_goo_id')
                ->where('a.goo_id', $request['goo_id'])
                ->select('goo_id', 'goo_name', 'goo_goods_code', 'goaf_goods_bar_code', 'goaf_goods_material_code', 'goo_bra_name', 'goo_cate_name', 'goo_price', 'goo_wholesale_price', 'goo_purchase_price', 'goo_channel_price', 'goo_shop_price', 'goo_vip_price', 'goaf_arrival_period', 'goaf_case_number', 'goaf_min_order_quantity', 'goaf_length', 'goaf_width', 'goaf_height', 'goaf_weight', 'goaf_description', 'goaf_clause')
                ->first();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_data]);
        }

        // 验证数据
        $error_message = $verify_data->editValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        DB::beginTransaction();

        $WearingPart = new WearingPart;
        $edit_res = $WearingPart->edit($request,$user_info);

        if ($edit_res['code'] == 200) {
            DB::commit();
            Common::addLog($user_info, getRealIp($request), '商品列表', '编辑', '编辑商品：' . $request['goo_name'] . '成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'编辑商品：成功']);
        } else {
            DB::rollBack();
            return response()->json($edit_res);
        }
    }

    // 价格维护
    public function editPrice(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyWearingPartController;
        $error_message = $verify_data->editwearingPartValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        if ($request['type'] == 1) {
            // 获取编辑页面数据
            $find_data = DB::table('goods as a')
                ->leftJoin('goods_affiliate as b', 'a.goo_id', '=', 'b.goaf_goo_id')
                ->where('a.goo_id', $request['goo_id'])
                ->select('goo_id', 'goo_name', 'goo_goods_code', 'goo_price', 'goo_wholesale_price', 'goo_purchase_price', 'goo_channel_price', 'goo_shop_price', 'goo_vip_price')
                ->first();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_data]);
        }

        $WearingPart = new WearingPart;
        $editPrice_res = $WearingPart->editPrice($request);

        if ($editPrice_res['code'] == 200) {
            Common::addLog($user_info, getRealIp($request), '商品列表', '价格维护', '修改商品：' . $request['goo_name'] . '成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'价格维护：成功']);
        } else {
            return response()->json($editPrice_res);
        }
    }

    // 车型匹配
    public function matchModel(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyWearingPartController;
        $error_message = $verify_data->matchModelValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $WearingPart = new WearingPart;
        $matchmodel_res = $WearingPart->matchModel($request, $user_info);

        if ($matchmodel_res['code'] == 200) {
            Common::addLog($user_info, getRealIp($request), '商品列表', '车型匹配', '匹配商品：' . $request['goo_name'] . '成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'车型匹配：成功']);
        } else {
            return response()->json($matchmodel_res);
        }
    }
}