<?php
namespace App\Http\Controllers\Api\PrintManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Services\PublicSearch;
use App\Http\Controllers\Api\Verify\PrintManage\VerifyPublicPrintController;
use App\Http\Models\Services\Prints;

class PublicPrintController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 设计模板
    public function set(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyPublicPrintController;
        $error_message = $verify_data->setValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        if ($request['type'] == 1) { //查询模板
            $shpt_data = DB::table('shop_print_template')
                ->where('shpt_id', $request['shpt_id'])
                ->select('shpt_id', 'shpt_template_name', 'shpt_print_type', 'shpt_paper_height', 'shpt_paper_width', 'shpt_template_set')
                ->first();
            if ($shpt_data) {
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$shpt_data]);
            } else {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
            }
        } else { //设计模板
            $shpt_data = DB::table('shop_print_template')
                ->where('shpt_id', $request['shpt_id'])
                ->select('shpt_id', 'shpt_print_state', 'shpt_template_set')
                ->first();
            if ($shpt_data->shpt_print_state == 1 && $user_info->adm_id != 258) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'系统模板不能编辑']);
            }
            if (empty($request['shpt_template_set'])) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请设置打印模板']);
            }
            // 编辑模板
            $update_data['shpt_template_set'] = $request['shpt_template_set'];
            $update_data['shpt_paper_width'] = $request['shpt_paper_width'];
            $update_data['shpt_paper_height'] = $request['shpt_paper_height'];
            $update_data['shpt_update_time'] = date('Y-m-d H:i:s');
            $update_shpt_res = DB::table('shop_print_template')
                ->where('shpt_id', $request['shpt_id'])
                ->update($update_data);
            if ($update_shpt_res) {
                Common::addLog($user_info, getRealIp($request), '打印模板', '设置', '设置模板' . $request['shpt_template_name'] . '成功');
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'设置打印模板成功']);
            } else {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'设置打印模板失败']);
            }
        }
    }

    // 获取打印组件
    public function getshptComponent(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyPublicPrintController;
        $error_message = $verify_data->getshptComponentValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        if ($request['shpt_print_type'] == 1) { //发货单
            /*
                打印自定义组件数据设置
                type：类型 braid-txt:文本类型, braid-table:表格类型
                isEdit:是否可以编辑 0不可编辑1可以编辑
                title：组件按钮名称
                value：组件数据
                defaultValue：组件默认显示数据
                name：数据表字段名
            */

            $shpt_set_options = [
                ["tid"=>"shpt_print_type_name", "title"=>"打印单类型", "field"=>"shpt_print_type_name", "data"=>"打印单类型", "type"=>"text"],
                ["tid"=>"shop_store_name", "title"=>"服务提供商", "field"=>"shop_store_name", "data"=>"服务提供商", "type"=>"text"],
                ["tid"=>"dego_number", "title"=>"发货单号", "field"=>"dego_number", "data"=>"发货单号", "type"=>"text"],
                ["tid"=>"chun_unit_name", "title"=>"客户名称", "field"=>"chun_unit_name", "data"=>"客户名称", "type"=>"text"],
                ["tid"=>"chun_phone", "title"=>"联系方式", "field"=>"chun_phone", "data"=>"联系方式", "type"=>"text"],
                ["tid"=>"chun_address", "title"=>"客户地址", "field"=>"chun_address", "data"=>"客户地址", "type"=>"text"],
                ["tid"=>"adm_name", "title"=>"派单员", "field"=>"adm_name", "data"=>"派单员", "type"=>"text"],
                ["tid"=>"dego_count", "title"=>"发货总数量", "field"=>"dego_count", "data"=>"发货总数量", "type"=>"text"]
            ];

            $shop_goods = [[
                ["title"=>"NO", "align"=>"center", "field"=>"NO", "width"=>"100"],
                ["title"=>"编号", "align"=>"center", "field"=>"digo_goo_goods_encode", "width"=>"100"],
                ["title"=>"商品名称", "align"=>"center", "field"=>"digo_goo_name", "width"=>"100"],
                ["title"=>"数量", "align"=>"center", "field"=>"digo_goo_quantity", "width"=>"100"],
                ["title"=>"单位", "align"=>"center", "field"=>"goo_unit", "width"=>"100"],
                ["title"=>"出库类型", "align"=>"center", "field"=>"digo_goo_inventory", "width"=>"100"],
                ["title"=>"仓位", "align"=>"center", "field"=>"digo_wafr_id", "width"=>"100"],
                ["title"=>"仓库编码", "align"=>"center", "field"=>"ware_freight_space", "width"=>"100"]
            ]];

            $shpt_set_options[] = ["tid"=>"details", "field"=>"details", "title"=>"发货商品明细", "type"=>"table", "editable"=>"true", "columnDisplayEditable"=>"true", "columnDisplayIndexEditable"=>"true", "columnTitleEditable"=>"true", "columnResizable"=>"true", "columnAlignEditable"=>"true", "columns"=>$shop_goods];
        } elseif ($request['shpt_print_type'] == 2) { //2旧货回收
            $shpt_set_options = [
                ["tid"=>"jur_cname", "title"=>"公司名称", "field"=>"jur_cname", "data"=>"公司名称", "type"=>"text"],
                ["tid"=>"shop_store_name", "title"=>"服务提供商", "field"=>"shop_store_name", "data"=>"服务提供商", "type"=>"text"],
                ["tid"=>"shpt_print_type_name", "title"=>"打印单类型", "field"=>"shpt_print_type_name", "data"=>"打印单类型", "type"=>"text"],
                ["tid"=>"jur_number", "title"=>"旧货回收单号", "field"=>"jur_number", "data"=>"旧货回收单号", "type"=>"text"],
                ["tid"=>"jucl_channel_unit", "title"=>"客户单位", "field"=>"jucl_channel_unit", "data"=>"客户单位", "type"=>"text"],
                ["tid"=>"chun_unit_name", "title"=>"客户姓名", "field"=>"chun_unit_name", "data"=>"客户姓名", "type"=>"text"],
                ["tid"=>"jucl_phone", "title"=>"客户电话", "field"=>"jucl_phone", "data"=>"客户电话", "type"=>"text"],
                ["tid"=>"adm_name", "title"=>"派单员", "field"=>"adm_name", "data"=>"派单员", "type"=>"text"],
                ["tid"=>"jur_date", "title"=>"录单时间", "field"=>"jur_date", "data"=>"录单时间", "type"=>"text"],
                ["tid"=>"jur_source", "title"=>"旧货来源", "field"=>"jur_source", "data"=>"旧货来源", "type"=>"text"],
                ["tid"=>"jur_amount", "title"=>"数量", "field"=>"jur_amount", "data"=>"数量", "type"=>"text"],
                ["tid"=>"jur_price", "title"=>"金额", "field"=>"jur_price", "data"=>"金额", "type"=>"text"],
                ["tid"=>"jur_amount", "title"=>"合计数量", "field"=>"jur_amount", "data"=>"合计数量", "type"=>"text"],
                ["tid"=>"jur_price", "title"=>"合计金额", "field"=>"jur_price", "data"=>"合计金额", "type"=>"text"],
                ["tid"=>"chun_adm_phone", "title"=>"业务受理电话", "field"=>"chun_adm_phone", "data"=>"业务受理电话", "type"=>"text"],
                ["tid"=>"jur_remark", "title"=>"备注", "field"=>"jur_remark", "data"=>"备注", "type"=>"text"],
                ["tid"=>"prnu_print_num", "title"=>"打印次数", "field"=>"prnu_print_num", "data"=>"打印次数", "type"=>"text"],
            ];
            $shop_goods = [[
                ["title"=>"NO", "align"=>"center", "field"=>"NO", "width"=>"100"],
                ["title"=>"检索编码", "align"=>"center", "field"=>"goo_goods_encode", "width"=>"100"],
                ["title"=>"商品名称", "align"=>"center", "field"=>"goo_name", "width"=>"100"],
                ["title"=>"回收数量", "align"=>"center", "field"=>"goo_recycle_amount", "width"=>"100"],
                ["title"=>"售价", "align"=>"center", "field"=>"goo_price", "width"=>"100"],
                ["title"=>"备注", "align"=>"center", "field"=>"jugo_remark", "width"=>"100"],
            ]];
            $shpt_set_options[] = ["tid"=>"details", "field"=>"details", "title"=>"回收商品明细", "type"=>"table", "editable"=>"true", "columnDisplayEditable"=>"true", "columnDisplayIndexEditable"=>"true", "columnTitleEditable"=>"true", "columnResizable"=>"true", "columnAlignEditable"=>"true", "columns"=>$shop_goods];
        } elseif ($request['shpt_print_type'] == 3) { //3旧货回收标签
            $shpt_set_options = [
                ["tid"=>"jugo_print_state", "title"=>"打印状态", "field"=>"jugo_print_state", "data"=>"打印单类型", "type"=>"text"],
                ["tid"=>"adm_name", "title"=>"名称", "field"=>"adm_name", "data"=>"名称", "type"=>"text"],
                ["tid"=>"jur_wor_number", "title"=>"工单编号", "field"=>"jur_wor_number", "data"=>"工单编号", "type"=>"text"],
                ["tid"=>"goo_goods_encode", "title"=>"检索编码", "field"=>"goo_goods_encode", "data"=>"检索编码", "type"=>"text"],
                ["tid"=>"jugo_recycle_number", "title"=>"数量", "field"=>"jugo_recycle_number", "data"=>"数量", "type"=>"text"],
                ["tid"=>"ware_freight_space", "title"=>"仓库编码", "field"=>"ware_freight_space", "data"=>"仓库编码", "type"=>"text"],
                ["tid"=>"wogo_goo_goods_encode", "title"=>"检索编码", "field"=>"wogo_goo_goods_encode", "data"=>"检索编码", "type"=>"text"],
                ["tid"=>"goo_name", "title"=>"商品名称", "field"=>"goo_name", "data"=>"商品名称", "type"=>"text"],
                ["tid"=>"wogo_goo_name", "title"=>"工单商品名称", "field"=>"wogo_goo_name", "data"=>"工单商品名称", "type"=>"text"],
            ];
            $shop_goods = [[
                ["title"=>"NO", "align"=>"center", "field"=>"NO", "width"=>"100"],
                ["title"=>"检索编码", "align"=>"center", "field"=>"goo_goods_encode", "width"=>"100"],
                ["title"=>"商品名称", "align"=>"center", "field"=>"goo_name", "width"=>"100"],
                ["title"=>"回收数量", "align"=>"center", "field"=>"goo_recycle_amount", "width"=>"100"],
                ["title"=>"售价", "align"=>"center", "field"=>"goo_price", "width"=>"100"],
                ["title"=>"备注", "align"=>"center", "field"=>"jugo_remark", "width"=>"100"],
            ]];
            $shpt_set_options[] = ["tid"=>"details", "field"=>"details", "title"=>"回收商品明细", "type"=>"table", "editable"=>"true", "columnDisplayEditable"=>"true", "columnDisplayIndexEditable"=>"true", "columnTitleEditable"=>"true", "columnResizable"=>"true", "columnAlignEditable"=>"true", "columns"=>$shop_goods];
        } elseif ($request['shpt_print_type'] == 4) { //4订单-销售单
            $shpt_set_options = [
                ["tid"=>"prca_com_name", "title"=>"公司名称", "field"=>"prca_com_name", "data"=>"公司名称", "type"=>"text"],
                ["tid"=>"prca_serve_order", "title"=>"订单类型", "field"=>"prca_serve_order", "data"=>"订单类型", "type"=>"text"],
                ["tid"=>"prca_serve_provider", "title"=>"服务提供商", "field"=>"prca_serve_provider", "data"=>"服务提供商", "type"=>"text"],
                ["tid"=>"orcl_channel_unit", "title"=>"客户名称", "field"=>"orcl_channel_unit", "data"=>"客户名称", "type"=>"text"],
                ["tid"=>"ord_order_number", "title"=>"订单单号", "field"=>"ord_order_number", "data"=>"订单单号", "type"=>"text"],
                ["tid"=>"orcl_name", "title"=>"联系人", "field"=>"orcl_name", "data"=>"联系人", "type"=>"text"],
                ["tid"=>"orcl_phone", "title"=>"联系电话", "field"=>"orcl_phone", "data"=>"联系电话", "type"=>"text"],
                ["tid"=>"ord_create_time", "title"=>"录单时间", "field"=>"ord_create_time", "data"=>"录单时间", "type"=>"text"],
                ["tid"=>"orcl_address", "title"=>"客户地址", "field"=>"orcl_address", "data"=>"客户地址", "type"=>"text"],
                ["tid"=>"ord_payment_way", "title"=>"客户类别", "field"=>"ord_payment_way", "data"=>"客户类别", "type"=>"text"],
                ["tid"=>"orcl_car_num", "title"=>"车牌号", "field"=>"orcl_car_num", "data"=>"车牌号", "type"=>"text"],
                ["tid"=>"orcl_car_vehicle_type", "title"=>"车型", "field"=>"orcl_car_vehicle_type", "data"=>"车型", "type"=>"text"],
                ["tid"=>"ord_remark", "title"=>"备注(A)", "field"=>"ord_remark", "data"=>"备注(A)", "type"=>"text"],
                ["tid"=>"create_name", "title"=>"派单员", "field"=>"create_name", "data"=>"派单员", "type"=>"text"],
                ["tid"=>"ord_service_adm_name", "title"=>"送货/安装人员", "field"=>"ord_service_adm_name", "data"=>"送货/安装人员", "type"=>"text"],
                ["tid"=>"ord_goods_quantity", "title"=>"总数量", "field"=>"ord_goods_quantity", "data"=>"总数量", "type"=>"text"],
                ["tid"=>"ord_order_price", "title"=>"总金额", "field"=>"ord_order_price", "data"=>"总金额", "type"=>"text"],
                ["tid"=>"phone", "title"=>"业务受理电话", "field"=>"phone", "data"=>"业务受理电话", "type"=>"text"],
                ["tid"=>"phone_all_day", "title"=>"24小时救援电话", "field"=>"phone_all_day", "data"=>"24小时救援电话", "type"=>"text"],
                ["tid"=>"total_client_price", "title"=>"客户前欠货款总额", "field"=>"total_client_price", "data"=>"客户前欠货款总额", "type"=>"text"],
            ];
            $shop_goods = [[
                ["title"=>"NO", "align"=>"center", "field"=>"NO", "width"=>"100"],
                ["title"=>"检索编码", "align"=>"center", "field"=>"orgo_goo_goods_encode", "width"=>"100"],
                ["title"=>"商品名称", "align"=>"center", "field"=>"orgo_goo_name", "width"=>"100"],
                ["title"=>"商品数量", "align"=>"center", "field"=>"orgo_goo_quantity", "width"=>"100"],
                ["title"=>"单位", "align"=>"center", "field"=>"goo_unit", "width"=>"100"],
                ["title"=>"单价", "align"=>"center", "field"=>"orgo_goo_price", "width"=>"100"],
                ["title"=>"金额", "align"=>"center", "field"=>"orgo_goo_price", "width"=>"100"],
                ["title"=>"代收金额", "align"=>"center", "field"=>"orgo_collection_price", "width"=>"100"],
                ["title"=>"仓位", "align"=>"center", "field"=>"orgo_wafr_name", "width"=>"100"],
                ["title"=>"仓库编码", "align"=>"center", "field"=>"ware_freight_space", "width"=>"100"],
                ["title"=>"回收金额", "align"=>"center", "field"=>"orgo_recycle_price", "width"=>"100"],
                ["title"=>"旧货回收", "align"=>"center", "field"=>"orgo_is_recycle", "width"=>"100"],
            ]];
            $shpt_set_options[] = ["tid"=>"details", "field"=>"details", "title"=>"订单商品明细", "type"=>"table", "editable"=>"true", "columnDisplayEditable"=>"true", "columnDisplayIndexEditable"=>"true", "columnTitleEditable"=>"true", "columnResizable"=>"true", "columnAlignEditable"=>"true", "columns"=>$shop_goods];
        } elseif ($request['shpt_print_type'] == 5) { //5订单-救援服务单
            $shpt_set_options = [
                ["tid"=>"prca_com_name", "title"=>"公司名称", "field"=>"prca_com_name", "data"=>"公司名称", "type"=>"text"],
                ["tid"=>"prca_serve_order", "title"=>"订单类型", "field"=>"prca_serve_order", "data"=>"订单类型", "type"=>"text"],
                ["tid"=>"prca_serve_provider", "title"=>"服务提供商", "field"=>"prca_serve_provider", "data"=>"服务提供商", "type"=>"text"],
                ["tid"=>"orcl_channel_unit", "title"=>"客户名称", "field"=>"orcl_channel_unit", "data"=>"客户名称", "type"=>"text"],
                ["tid"=>"ord_order_number", "title"=>"订单单号", "field"=>"ord_order_number", "data"=>"订单单号", "type"=>"text"],
                ["tid"=>"orcl_name", "title"=>"联系人", "field"=>"orcl_name", "data"=>"联系人", "type"=>"text"],
                ["tid"=>"orcl_phone", "title"=>"联系电话", "field"=>"orcl_phone", "data"=>"联系电话", "type"=>"text"],
                ["tid"=>"ord_create_time", "title"=>"录单时间", "field"=>"ord_create_time", "data"=>"录单时间", "type"=>"text"],
                ["tid"=>"orcl_address", "title"=>"客户地址", "field"=>"orcl_address", "data"=>"客户地址", "type"=>"text"],
                ["tid"=>"ord_payment_way", "title"=>"客户类别", "field"=>"ord_payment_way", "data"=>"客户类别", "type"=>"text"],
                ["tid"=>"orcl_info", "title"=>"车主信息", "field"=>"orcl_info", "data"=>"车主信息", "type"=>"text"],
                ["tid"=>"chun_address", "title"=>"服务地址", "field"=>"chun_address", "data"=>"服务地址", "type"=>"text"],
                ["tid"=>"orcl_car_num", "title"=>"车牌号", "field"=>"orcl_car_num", "data"=>"车牌号", "type"=>"text"],
                ["tid"=>"orcl_car_vehicle_type", "title"=>"车型", "field"=>"orcl_car_vehicle_type", "data"=>"车型", "type"=>"text"],
                ["tid"=>"ord_remark", "title"=>"备注(A)", "field"=>"ord_remark", "data"=>"备注(A)", "type"=>"text"],
                ["tid"=>"create_name", "title"=>"派单员", "field"=>"create_name", "data"=>"派单员", "type"=>"text"],
                ["tid"=>"ord_service_adm_name", "title"=>"送货/安装人员", "field"=>"ord_service_adm_name", "data"=>"送货/安装人员", "type"=>"text"],
                ["tid"=>"prnu_print_time", "title"=>"打印时间", "field"=>"prnu_print_time", "data"=>"打印时间", "type"=>"text"],
            ];
            $shop_goods = [[
                ["title"=>"NO", "align"=>"center", "field"=>"NO", "width"=>"100"],
                ["title"=>"检索编码", "align"=>"center", "field"=>"orgo_goo_goods_encode", "width"=>"100"],
                ["title"=>"商品名称", "align"=>"center", "field"=>"orgo_goo_name", "width"=>"100"],
                ["title"=>"商品数量", "align"=>"center", "field"=>"orgo_goo_quantity", "width"=>"100"],
                ["title"=>"单位", "align"=>"center", "field"=>"goo_unit", "width"=>"100"],
                ["title"=>"单价", "align"=>"center", "field"=>"orgo_goo_price", "width"=>"100"],
                ["title"=>"金额", "align"=>"center", "field"=>"orgo_goo_price", "width"=>"100"],
                ["title"=>"代收金额", "align"=>"center", "field"=>"orgo_collection_price", "width"=>"100"],
                ["title"=>"仓位", "align"=>"center", "field"=>"orgo_wafr_name", "width"=>"100"],
                ["title"=>"仓库编码", "align"=>"center", "field"=>"ware_freight_space", "width"=>"100"],
                ["title"=>"回收金额", "align"=>"center", "field"=>"orgo_recycle_price", "width"=>"100"],
                ["title"=>"旧货回收", "align"=>"center", "field"=>"orgo_is_recycle", "width"=>"100"],
            ]];
            $shpt_set_options[] = ["tid"=>"details", "field"=>"details", "title"=>"救援服务单商品明细", "type"=>"table", "editable"=>"true", "columnDisplayEditable"=>"true", "columnDisplayIndexEditable"=>"true", "columnTitleEditable"=>"true", "columnResizable"=>"true", "columnAlignEditable"=>"true", "columns"=>$shop_goods];
        } elseif ($request['shpt_print_type'] == 6) { //6订单-救援结算单
            $shpt_set_options = [
                ["tid"=>"prca_com_name", "title"=>"公司名称", "field"=>"prca_com_name", "data"=>"公司名称", "type"=>"text"],
                ["tid"=>"prca_serve_order", "title"=>"订单类型", "field"=>"prca_serve_order", "data"=>"订单类型", "type"=>"text"],
                ["tid"=>"prca_serve_provider", "title"=>"服务提供商", "field"=>"prca_serve_provider", "data"=>"服务提供商", "type"=>"text"],
                ["tid"=>"orcl_channel_unit", "title"=>"客户名称", "field"=>"orcl_channel_unit", "data"=>"客户名称", "type"=>"text"],
                ["tid"=>"ord_order_number", "title"=>"订单单号", "field"=>"ord_order_number", "data"=>"订单单号", "type"=>"text"],
                ["tid"=>"orcl_name", "title"=>"联系人", "field"=>"orcl_name", "data"=>"联系人", "type"=>"text"],
                ["tid"=>"orcl_phone", "title"=>"联系电话", "field"=>"orcl_phone", "data"=>"联系电话", "type"=>"text"],
                ["tid"=>"ord_create_time", "title"=>"录单时间", "field"=>"ord_create_time", "data"=>"录单时间", "type"=>"text"],
                ["tid"=>"orcl_address", "title"=>"客户地址", "field"=>"orcl_address", "data"=>"客户地址", "type"=>"text"],
                ["tid"=>"ord_payment_way", "title"=>"客户类别", "field"=>"ord_payment_way", "data"=>"客户类别", "type"=>"text"],
                ["tid"=>"orcl_info", "title"=>"车主信息", "field"=>"orcl_info", "data"=>"车主信息", "type"=>"text"],
                ["tid"=>"chun_address", "title"=>"服务地址", "field"=>"chun_address", "data"=>"服务地址", "type"=>"text"],
                ["tid"=>"orcl_car_num", "title"=>"车牌号", "field"=>"orcl_car_num", "data"=>"车牌号", "type"=>"text"],
                ["tid"=>"orcl_car_vehicle_type", "title"=>"车型", "field"=>"orcl_car_vehicle_type", "data"=>"车型", "type"=>"text"],
                ["tid"=>"ord_remark", "title"=>"备注(A)", "field"=>"ord_remark", "data"=>"备注(A)", "type"=>"text"],
                ["tid"=>"create_name", "title"=>"派单员", "field"=>"create_name", "data"=>"派单员", "type"=>"text"],
                ["tid"=>"ord_service_adm_name", "title"=>"送货/安装人员", "field"=>"ord_service_adm_name", "data"=>"送货/安装人员", "type"=>"text"],
                ["tid"=>"prnu_print_time", "title"=>"打印时间", "field"=>"prnu_print_time", "data"=>"打印时间", "type"=>"text"],
            ];
            $shop_goods = [[
                ["title"=>"NO", "align"=>"center", "field"=>"NO", "width"=>"100"],
                ["title"=>"检索编码", "align"=>"center", "field"=>"orgo_goo_goods_encode", "width"=>"100"],
                ["title"=>"商品名称", "align"=>"center", "field"=>"orgo_goo_name", "width"=>"100"],
                ["title"=>"商品数量", "align"=>"center", "field"=>"orgo_goo_quantity", "width"=>"100"],
                ["title"=>"单位", "align"=>"center", "field"=>"goo_unit", "width"=>"100"],
                ["title"=>"单价", "align"=>"center", "field"=>"orgo_goo_price", "width"=>"100"],
                ["title"=>"金额", "align"=>"center", "field"=>"orgo_goo_price", "width"=>"100"],
                ["title"=>"代收金额", "align"=>"center", "field"=>"orgo_collection_price", "width"=>"100"],
                ["title"=>"仓位", "align"=>"center", "field"=>"orgo_wafr_name", "width"=>"100"],
                ["title"=>"仓库编码", "align"=>"center", "field"=>"ware_freight_space", "width"=>"100"],
                ["title"=>"回收金额", "align"=>"center", "field"=>"orgo_recycle_price", "width"=>"100"],
                ["title"=>"旧货回收", "align"=>"center", "field"=>"orgo_is_recycle", "width"=>"100"],
            ]];
            $shpt_set_options[] = ["tid"=>"details", "field"=>"details", "title"=>"救援结算单商品明细", "type"=>"table", "editable"=>"true", "columnDisplayEditable"=>"true", "columnDisplayIndexEditable"=>"true", "columnTitleEditable"=>"true", "columnResizable"=>"true", "columnAlignEditable"=>"true", "columns"=>$shop_goods];
        } elseif ($request['shpt_print_type'] == 7) { //7订单-对单
            $shop_goods = [[
                ["title"=>"NO", "align"=>"center", "field"=>"NO", "width"=>"100"],
                ["title"=>"订单编号", "align"=>"center", "field"=>"ord_order_number", "width"=>"100"],
                ["title"=>"录单人", "align"=>"center", "field"=>"adm_name", "width"=>"100"],
                ["title"=>"客户单位", "align"=>"center", "field"=>"chun_unit_name", "width"=>"100"],
                ["title"=>"结算金额", "align"=>"center", "field"=>"ord_actual_price", "width"=>"100"],
                ["title"=>"仓库名称", "align"=>"center", "field"=>"ware_name", "width"=>"100"],
                ["title"=>"开单时间", "align"=>"center", "field"=>"ord_create_time", "width"=>"100"],
                ["title"=>"订单类型", "align"=>"center", "field"=>"ord_service_type", "width"=>"100"],
            ]];
            $shpt_set_options[] = ["tid"=>"details", "field"=>"details", "title"=>"对单数据", "type"=>"table", "editable"=>"true", "columnDisplayEditable"=>"true", "columnDisplayIndexEditable"=>"true", "columnTitleEditable"=>"true", "columnResizable"=>"true", "columnAlignEditable"=>"true", "columns"=>$shop_goods];
        } elseif ($request['shpt_print_type'] == 8) { //8工单-销售单
            $shpt_set_options = [
                ["tid"=>"prca_com_name", "title"=>"公司名称", "field"=>"prca_com_name", "data"=>"公司名称", "type"=>"text"],
                ["tid"=>"prca_serve_provider", "title"=>"服务提供商", "field"=>"prca_serve_provider", "data"=>"服务提供商", "type"=>"text"],
                ["tid"=>"prca_serve_order", "title"=>"订单类型", "field"=>"prca_serve_order", "data"=>"订单类型", "type"=>"text"],
                ["tid"=>"wocl_channel_unit", "title"=>"客户名称", "field"=>"wocl_channel_unit", "data"=>"客户名称", "type"=>"text"],
                ["tid"=>"wor_number", "title"=>"工单单号", "field"=>"wor_number", "data"=>"工单单号", "type"=>"text"],
                ["tid"=>"wocl_name", "title"=>"联系人", "field"=>"wocl_name", "data"=>"联系人", "type"=>"text"],
                ["tid"=>"wocl_phone", "title"=>"联系电话", "field"=>"wocl_phone", "data"=>"联系电话", "type"=>"text"],
                ["tid"=>"wor_create_time", "title"=>"录单时间", "field"=>"wor_create_time", "data"=>"录单时间", "type"=>"text"],
                ["tid"=>"wocl_address", "title"=>"客户地址", "field"=>"wocl_address", "data"=>"客户地址", "type"=>"text"],
                ["tid"=>"ord_payment_way", "title"=>"客户类别", "field"=>"ord_payment_way", "data"=>"客户类别", "type"=>"text"],
                ["tid"=>"wocl_car_num", "title"=>"车牌号", "field"=>"wocl_car_num", "data"=>"车牌号", "type"=>"text"],
                ["tid"=>"wocl_car_vehicle_type", "title"=>"车型", "field"=>"wocl_car_vehicle_type", "data"=>"车型", "type"=>"text"],
                ["tid"=>"wor_remark", "title"=>"备注(A)", "field"=>"wor_remark", "data"=>"备注(A)", "type"=>"text"],
                ["tid"=>"create_name", "title"=>"派单员", "field"=>"create_name", "data"=>"派单员", "type"=>"text"],
                ["tid"=>"wor_service_adm_name", "title"=>"送货/安装人员", "field"=>"wor_service_adm_name", "data"=>"送货/安装人员", "type"=>"text"],
                ["tid"=>"wor_goo_amount", "title"=>"总数量", "field"=>"wor_goo_amount", "data"=>"总数量", "type"=>"text"],
                ["tid"=>"wor_actual_price", "title"=>"总金额", "field"=>"wor_actual_price", "data"=>"总金额", "type"=>"text"],
                ["tid"=>"phone", "title"=>"业务受理电话", "field"=>"phone", "data"=>"业务受理电话", "type"=>"text"],
                ["tid"=>"phone_all_day", "title"=>"24小时救援电话", "field"=>"phone_all_day", "data"=>"24小时救援电话", "type"=>"text"],
                ["tid"=>"total_client_price", "title"=>"客户前欠货款总额", "field"=>"total_client_price", "data"=>"客户前欠货款总额", "type"=>"text"],
            ];
            $shop_goods = [[
                ["title"=>"NO", "align"=>"center", "field"=>"NO", "width"=>"100"],
                ["title"=>"检索编码", "align"=>"center", "field"=>"wogo_goo_goods_encode", "width"=>"100"],
                ["title"=>"商品名称", "align"=>"center", "field"=>"wogo_goo_name", "width"=>"100"],
                ["title"=>"商品数量", "align"=>"center", "field"=>"wogo_goo_amount", "width"=>"100"],
                ["title"=>"单位", "align"=>"center", "field"=>"goo_unit", "width"=>"100"],
                ["title"=>"单价", "align"=>"center", "field"=>"wogo_goo_price", "width"=>"100"],
                ["title"=>"金额", "align"=>"center", "field"=>"wogo_goo_price", "width"=>"100"],
                ["title"=>"代收金额", "align"=>"center", "field"=>"wogo_collection_price", "width"=>"100"],
                ["title"=>"仓位", "align"=>"center", "field"=>"wogo_wafr_name", "width"=>"100"],
                ["title"=>"仓库编码", "align"=>"center", "field"=>"ware_freight_space", "width"=>"100"],
                ["title"=>"回收金额", "align"=>"center", "field"=>"wogo_recycle_price", "width"=>"100"],
                ["title"=>"旧货回收", "align"=>"center", "field"=>"wogo_is_recycle", "width"=>"100"],
            ]];
            $shpt_set_options[] = ["tid"=>"details", "field"=>"details", "title"=>"工单商品明细", "type"=>"table", "editable"=>"true", "columnDisplayEditable"=>"true", "columnDisplayIndexEditable"=>"true", "columnTitleEditable"=>"true", "columnResizable"=>"true", "columnAlignEditable"=>"true", "columns"=>$shop_goods];
        } elseif ($request['shpt_print_type'] == 9) { //9工单-救援服务单
            $shpt_set_options = [
                ["tid"=>"prca_com_name", "title"=>"公司名称", "field"=>"prca_com_name", "data"=>"公司名称", "type"=>"text"],
                ["tid"=>"prca_serve_order", "title"=>"订单类型", "field"=>"prca_serve_order", "data"=>"订单类型", "type"=>"text"],
                ["tid"=>"prca_serve_provider", "title"=>"服务提供商", "field"=>"prca_serve_provider", "data"=>"服务提供商", "type"=>"text"],
                ["tid"=>"wocl_channel_unit", "title"=>"客户名称", "field"=>"wocl_channel_unit", "data"=>"客户名称", "type"=>"text"],
                ["tid"=>"wor_number", "title"=>"工单单号", "field"=>"wor_number", "data"=>"工单单号", "type"=>"text"],
                ["tid"=>"wocl_name", "title"=>"联系人", "field"=>"wocl_name", "data"=>"联系人", "type"=>"text"],
                ["tid"=>"wocl_phone", "title"=>"联系电话", "field"=>"wocl_phone", "data"=>"联系电话", "type"=>"text"],
                ["tid"=>"wor_create_time", "title"=>"录单时间", "field"=>"wor_create_time", "data"=>"录单时间", "type"=>"text"],
                ["tid"=>"wocl_address", "title"=>"客户地址", "field"=>"wocl_address", "data"=>"客户地址", "type"=>"text"],
                ["tid"=>"ord_payment_way", "title"=>"客户类别", "field"=>"ord_payment_way", "data"=>"客户类别", "type"=>"text"],
                ["tid"=>"orcl_info", "title"=>"车主信息", "field"=>"orcl_info", "data"=>"车主信息", "type"=>"text"],
                ["tid"=>"chun_address", "title"=>"服务地址", "field"=>"chun_address", "data"=>"服务地址", "type"=>"text"],
                ["tid"=>"wocl_car_num", "title"=>"车牌号", "field"=>"wocl_car_num", "data"=>"车牌号", "type"=>"text"],
                ["tid"=>"wocl_car_vehicle_type", "title"=>"车型", "field"=>"wocl_car_vehicle_type", "data"=>"车型", "type"=>"text"],
                ["tid"=>"wor_remark", "title"=>"备注(A)", "field"=>"wor_remark", "data"=>"备注(A)", "type"=>"text"],
                ["tid"=>"create_name", "title"=>"派单员", "field"=>"create_name", "data"=>"派单员", "type"=>"text"],
                ["tid"=>"wor_service_adm_name", "title"=>"送货/安装人员", "field"=>"wor_service_adm_name", "data"=>"送货/安装人员", "type"=>"text"],
                ["tid"=>"prnu_print_time", "title"=>"打印时间", "field"=>"prnu_print_time", "data"=>"打印时间", "type"=>"text"],
            ];
            $shop_goods = [[
                ["title"=>"NO", "align"=>"center", "field"=>"NO", "width"=>"100"],
                ["title"=>"检索编码", "align"=>"center", "field"=>"wogo_goo_goods_encode", "width"=>"100"],
                ["title"=>"商品名称", "align"=>"center", "field"=>"wogo_goo_name", "width"=>"100"],
                ["title"=>"商品数量", "align"=>"center", "field"=>"wogo_goo_amount", "width"=>"100"],
                ["title"=>"单位", "align"=>"center", "field"=>"goo_unit", "width"=>"100"],
                ["title"=>"代收金额", "align"=>"center", "field"=>"wogo_collection_price", "width"=>"100"],
            ]];
            $shpt_set_options[] = ["tid"=>"details", "field"=>"details", "title"=>"救援服务单商品明细", "type"=>"table", "editable"=>"true", "columnDisplayEditable"=>"true", "columnDisplayIndexEditable"=>"true", "columnTitleEditable"=>"true", "columnResizable"=>"true", "columnAlignEditable"=>"true", "columns"=>$shop_goods];
        } elseif ($request['shpt_print_type'] == 10) { //10工单-救援结算单
            $shpt_set_options = [
                ["tid"=>"prca_com_name", "title"=>"公司名称", "field"=>"prca_com_name", "data"=>"公司名称", "type"=>"text"],
                ["tid"=>"prca_serve_provider", "title"=>"服务提供商", "field"=>"prca_serve_provider", "data"=>"服务提供商", "type"=>"text"],
                ["tid"=>"prca_serve_order", "title"=>"订单类型", "field"=>"prca_serve_order", "data"=>"订单类型", "type"=>"text"],
                ["tid"=>"wocl_channel_unit", "title"=>"客户名称", "field"=>"wocl_channel_unit", "data"=>"客户名称", "type"=>"text"],
                ["tid"=>"wor_number", "title"=>"工单单号", "field"=>"wor_number", "data"=>"工单单号", "type"=>"text"],
                ["tid"=>"wocl_name", "title"=>"联系人", "field"=>"wocl_name", "data"=>"联系人", "type"=>"text"],
                ["tid"=>"wocl_phone", "title"=>"联系电话", "field"=>"wocl_phone", "data"=>"联系电话", "type"=>"text"],
                ["tid"=>"wor_create_time", "title"=>"录单时间", "field"=>"wor_create_time", "data"=>"录单时间", "type"=>"text"],
                ["tid"=>"wocl_address", "title"=>"客户地址", "field"=>"wocl_address", "data"=>"客户地址", "type"=>"text"],
                ["tid"=>"ord_payment_way", "title"=>"客户类别", "field"=>"ord_payment_way", "data"=>"客户类别", "type"=>"text"],
                ["tid"=>"orcl_info", "title"=>"车主信息", "field"=>"orcl_info", "data"=>"车主信息", "type"=>"text"],
                ["tid"=>"chun_address", "title"=>"服务地址", "field"=>"chun_address", "data"=>"服务地址", "type"=>"text"],
                ["tid"=>"wocl_car_num", "title"=>"车牌号", "field"=>"wocl_car_num", "data"=>"车牌号", "type"=>"text"],
                ["tid"=>"wocl_car_vehicle_type", "title"=>"车型", "field"=>"wocl_car_vehicle_type", "data"=>"车型", "type"=>"text"],
                ["tid"=>"wor_remark", "title"=>"备注(A)", "field"=>"wor_remark", "data"=>"备注(A)", "type"=>"text"],
                ["tid"=>"create_name", "title"=>"派单员", "field"=>"create_name", "data"=>"派单员", "type"=>"text"],
                ["tid"=>"wor_service_adm_name", "title"=>"送货/安装人员", "field"=>"wor_service_adm_name", "data"=>"送货/安装人员", "type"=>"text"],
                ["tid"=>"wor_goo_amount", "title"=>"总数量", "field"=>"wor_goo_amount", "data"=>"总数量", "type"=>"text"],
                ["tid"=>"wor_actual_price", "title"=>"总金额", "field"=>"wor_actual_price", "data"=>"总金额", "type"=>"text"],
                ["tid"=>"phone", "title"=>"业务受理电话", "field"=>"phone", "data"=>"业务受理电话", "type"=>"text"],
                ["tid"=>"phone_all_day", "title"=>"24小时救援电话", "field"=>"phone_all_day", "data"=>"24小时救援电话", "type"=>"text"],
                ["tid"=>"chun_adm_name", "title"=>"业务负责人", "field"=>"chun_adm_name", "data"=>"业务负责人", "type"=>"text"],
                ["tid"=>"prnu_print_time", "title"=>"打印时间", "field"=>"prnu_print_time", "data"=>"打印时间", "type"=>"text"],
                ["tid"=>"total_client_price", "title"=>"客户前欠货款总额", "field"=>"total_client_price", "data"=>"客户前欠货款总额", "type"=>"text"],
            ];
            $shop_goods = [[
                ["title"=>"NO", "align"=>"center", "field"=>"NO", "width"=>"100"],
                ["title"=>"检索编码", "align"=>"center", "field"=>"wogo_goo_goods_encode", "width"=>"100"],
                ["title"=>"商品名称", "align"=>"center", "field"=>"wogo_goo_name", "width"=>"100"],
                ["title"=>"商品数量", "align"=>"center", "field"=>"wogo_goo_amount", "width"=>"100"],
                ["title"=>"单位", "align"=>"center", "field"=>"goo_unit", "width"=>"100"],
                ["title"=>"单价", "align"=>"center", "field"=>"wogo_goo_price", "width"=>"100"],
                ["title"=>"金额", "align"=>"center", "field"=>"wogo_goo_price", "width"=>"100"],
                ["title"=>"代收金额", "align"=>"center", "field"=>"wogo_collection_price", "width"=>"100"],
                ["title"=>"仓位", "align"=>"center", "field"=>"wogo_wafr_name", "width"=>"100"],
                ["title"=>"仓库编码", "align"=>"center", "field"=>"ware_freight_space", "width"=>"100"],
                ["title"=>"回收金额", "align"=>"center", "field"=>"wogo_recycle_price", "width"=>"100"],
                ["title"=>"旧货回收", "align"=>"center", "field"=>"wogo_is_recycle", "width"=>"100"],
                ["title"=>"备注", "align"=>"center", "field"=>"wogo_remark", "width"=>"100"],
            ]];
            $shpt_set_options[] = ["tid"=>"details", "field"=>"details", "title"=>"救援结算单商品明细", "type"=>"table", "editable"=>"true", "columnDisplayEditable"=>"true", "columnDisplayIndexEditable"=>"true", "columnTitleEditable"=>"true", "columnResizable"=>"true", "columnAlignEditable"=>"true", "columns"=>$shop_goods];
        } elseif ($request['shpt_print_type'] == 11) { //11调拨单
            $shpt_set_options = [
                ["tid"=>"tror_number", "title"=>"调拨单号", "field"=>"tror_number", "data"=>"调拨单号", "type"=>"text"],
                ["tid"=>"out_ware_name", "title"=>"调出仓库", "field"=>"out_ware_name", "data"=>"调出仓库", "type"=>"text"],
                ["tid"=>"in_ware_name", "title"=>"调入仓库", "field"=>"in_ware_name", "data"=>"调入仓库", "type"=>"text"],
            ];
            $shop_goods = [[
                ["title"=>"NO", "align"=>"center", "field"=>"NO", "width"=>"100"],
                ["title"=>"检索编码", "align"=>"center", "field"=>"goo_goods_encode", "width"=>"100"],
                ["title"=>"商品名称", "align"=>"center", "field"=>"goo_name", "width"=>"100"],
                ["title"=>"良品库存", "align"=>"center", "field"=>"trog_stock_number", "width"=>"100"],
                ["title"=>"优先库存", "align"=>"center", "field"=>"trog_priority_stock_number", "width"=>"100"],
                ["title"=>"调入仓位", "align"=>"center", "field"=>"wafr_name", "width"=>"100"],
            ]];
            $shpt_set_options[] = ["tid"=>"details", "field"=>"details", "title"=>"调拨商品明细", "type"=>"table", "editable"=>"true", "columnDisplayEditable"=>"true", "columnDisplayIndexEditable"=>"true", "columnTitleEditable"=>"true", "columnResizable"=>"true", "columnAlignEditable"=>"true", "columns"=>$shop_goods];
        } elseif ($request['shpt_print_type'] == 12) { //12 盘库单
            $shpt_set_options = [
                ["tid"=>"stoc_storage_number", "title"=>"盘库单号", "field"=>"stoc_storage_number", "data"=>"盘库单号", "type"=>"text"],
                ["tid"=>"adm_name", "title"=>"盘库人员", "field"=>"adm_name", "data"=>"盘库人员", "type"=>"text"],
                ["tid"=>"stoc_make_time", "title"=>"盘库时间", "field"=>"stoc_make_time", "data"=>"盘库时间", "type"=>"text"],
                ["tid"=>"ware_name", "title"=>"盘点仓库", "field"=>"ware_name", "data"=>"盘点仓库", "type"=>"text"],
                ["tid"=>"stoc_waon_class", "title"=>"仓库类别", "field"=>"stoc_waon_class", "data"=>"仓库类别", "type"=>"text"],
                ["tid"=>"stoc_differ_number", "title"=>"损益数量", "field"=>"stoc_differ_number", "data"=>"损益数量", "type"=>"text"],
                ["tid"=>"stoc_wafr_name", "title"=>"盘点仓位", "field"=>"stoc_wafr_name", "data"=>"盘点仓位", "type"=>"text"],
                ["tid"=>"stoc_type", "title"=>"类型", "field"=>"stoc_type", "data"=>"类型", "type"=>"text"],
            ];
            $shop_goods = [[
                ["title"=>"NO", "align"=>"center", "field"=>"NO", "width"=>"100"],
                ["title"=>"检索编码", "align"=>"center", "field"=>"goo_goods_encode", "width"=>"100"],
                ["title"=>"商品名称", "align"=>"center", "field"=>"goo_name", "width"=>"100"],
                // ["title"=>"良品(盘前)","align"=>"center","field"=>"stgo_stock_number","width"=>"100"],
                // ["title"=>"良品(盘后)","align"=>"center","field"=>"stgo_stocktake_number","width"=>"100"],
                ["title"=>"良品(盘前/盘后)", "align"=>"center", "field"=>"stgo_stocktake_number_all", "width"=>"100"],
                ["title"=>"优先(盘前/盘后)", "align"=>"center", "field"=>"stgo_priority_stock_number_all", "width"=>"100"],
            ]];
            $shpt_set_options[] = ["tid"=>"details", "field"=>"details", "title"=>"盘库商品明细", "type"=>"table", "editable"=>"true", "columnDisplayEditable"=>"true", "columnDisplayIndexEditable"=>"true", "columnTitleEditable"=>"true", "columnResizable"=>"true", "columnAlignEditable"=>"true", "columns"=>$shop_goods];
        } elseif ($request['shpt_print_type'] == 13) { //13 结款明细
            $shop_goods = [[
                ["title"=>"NO", "align"=>"center", "field"=>"NO", "width"=>"100"],
                ["title"=>"单号", "align"=>"center", "field"=>"acset_original_number", "width"=>"100"],
                ["title"=>"单位名称", "align"=>"center", "field"=>"acset_client_name", "width"=>"100"],
                ["title"=>"结款人", "align"=>"center", "field"=>"adm_name", "width"=>"100"],
                ["title"=>"结款时间", "align"=>"center", "field"=>"acset_with_time", "width"=>"100"],
                ["title"=>"合计金额", "align"=>"center", "field"=>"acset_price", "width"=>"100"],
                ["title"=>"银行账号", "align"=>"center", "field"=>"acti_course_title", "width"=>"100"],
                ["title"=>"实际金额", "align"=>"center", "field"=>"acset_actual_price", "width"=>"100"],
                ["title"=>"抹零金额", "align"=>"center", "field"=>"acset_zero_price", "width"=>"100"],
                ["title"=>"备注", "align"=>"center", "field"=>"acset_remark", "width"=>"100"],
            ]];
            $shpt_set_options[] = ["tid"=>"details", "field"=>"details", "title"=>"结款明细", "type"=>"table", "editable"=>"true", "columnDisplayEditable"=>"true", "columnDisplayIndexEditable"=>"true", "columnTitleEditable"=>"true", "columnResizable"=>"true", "columnAlignEditable"=>"true", "columns"=>$shop_goods];
        } elseif ($request['shpt_print_type'] == 14) { //14 对单-对单
            $shop_goods = [[
                ["title"=>"NO", "align"=>"center", "field"=>"NO", "width"=>"100"],
                ["title"=>"订单编号", "align"=>"center", "field"=>"ord_order_number", "width"=>"100"],
                ["title"=>"录单人", "align"=>"center", "field"=>"adm_name", "width"=>"100"],
                ["title"=>"客户单位", "align"=>"center", "field"=>"chun_unit_name", "width"=>"100"],
                ["title"=>"结算金额", "align"=>"center", "field"=>"ord_actual_price", "width"=>"100"],
                ["title"=>"仓库名称", "align"=>"center", "field"=>"ware_name", "width"=>"100"],
                ["title"=>"开单时间", "align"=>"center", "field"=>"ord_create_time", "width"=>"100"],
                ["title"=>"订单类型", "align"=>"center", "field"=>"ord_service_type", "width"=>"100"],
            ]];
            $shpt_set_options[] = ["tid"=>"details", "field"=>"details", "title"=>"对单数据", "type"=>"table", "editable"=>"true", "columnDisplayEditable"=>"true", "columnDisplayIndexEditable"=>"true", "columnTitleEditable"=>"true", "columnResizable"=>"true", "columnAlignEditable"=>"true", "columns"=>$shop_goods];
        }
        if ($shpt_set_options) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$shpt_set_options]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误']);
        }
    }

    // 打印
    public function print(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyPublicPrintController;
        $error_message = $verify_data->printValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $print = Prints::print($user_info, $request);
        if ($print['code'] == 200) {
            if ($request['shpt_print_type'] == 1) { //发货单
                $module_name = '发货单';
                $content = '发货单：' . $print['data_info'][0]['dego_number'];
            } elseif ($request['shpt_print_type'] == 2) { //旧货回收
                $module_name = '旧货回收';
                $content = '旧货回收：' . $print['data_info'][0]['jur_number'];
                $number = $print['data_info'][0]['jur_number'];
            } elseif ($request['shpt_print_type'] == 3) { //旧货回收标签
                $module_name = '旧货回收';
                $content = '打印标签' . $print['data_info'][0]['jur_number'];
            } elseif ($request['shpt_print_type'] == 4 || $request['shpt_print_type'] == 5 || $request['shpt_print_type'] == 6) { //订单
                $module_name = '订单列表';
                $content = '打印订单：' . $print['data_info'][0]['ord_order_number'];
            } elseif ($request['shpt_print_type'] == 8 || $request['shpt_print_type'] == 9 || $request['shpt_print_type'] == 10) { //工单
                $module_name = '工单列表';
                $content = '打印工单：' . $print['data_info'][0]['wor_number'];
            } elseif ($request['shpt_print_type'] == 11) { //调拨单
                $module_name = '调拨单';
                $content = '调拨单：' . $print['data_info'][0]['tror_number'];
            } elseif ($request['shpt_print_type'] == 12) { //盘库单
                $module_name = '盘库单';
                $content = '盘库单：' . $print['data_info'][0]['stoc_storage_number'];
            } elseif ($request['shpt_print_type'] == 13) { //结款明细
                $module_name = '结款明细';
                $content = '结款明细：';
            } elseif ($request['shpt_print_type'] == 14) { //对单
                $module_name = '对单';
                $content = '对单：';
            }
            Common::addLog($user_info, getRealIp($request), $module_name, '打印', $content, '打印成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$print['data'], 'data_info'=>$print['data_info']]);
        } else {
            return response()->json($print);
        }
    }
}
