<?php
namespace App\Http\Controllers\Api\OtherSystemInterfaces\zptz;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\OtherSystemInterfaces\VerifyOtherSystemOrdersController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use BlueCity\Core\Inc\ErrorInc;

class zptzSystemShopController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 搜索未绑定的门店
    public function searchShop(Request $request)
    {
        // 接收数据流
        $request = file_get_contents("php://input");

        // 解析
        // Common::write_log($request, 1, 'importOrders');
        $request = json_decode($request, true);
        // $request = $request->all();
        // 搜索未绑定的门店
        $list_data = DB::table('shop')
            ->whereRaw('`shop_id` not in (select `shre_shop_id` from `faster_shop_relevance` as `faster_sr` where `faster_sr`.`shre_relevance_type` = 1 and `faster_sr`.`shre_state` = 2 and `faster_sr`.`shre_delete` = 1)')
            ->select('shop_id', 'shop_store_name')
            ->where(function ($query) use ($request) { //门店名称搜索
                if (!empty($request['shop_store_name'])) {
                    $query->where('shop_store_name', 'like', '%'.$request['shop_store_name'].'%');
                }
            })
            ->get()->toArray();
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data]);
    }

    // 门店绑定，与贴装系统的绑定
    public function correlation(Request $request)
    {
        $get_ip = getRealIp($request); //获取ip
        // 接收数据流
        $request = file_get_contents("php://input");

        // 解析
        Common::write_log($request, 1, 'correlation');
        $request = json_decode($request, true);
        // $request = $request->all();
        // 查询门店是否绑定
        $find_shre_data = DB::table('shop_relevance')
            ->where('shre_shop_id', $request['shop_id'])
            ->where('shre_relevance_type', 1)
            ->where('shre_delete', 1)
            ->select('shre_id', 'shre_state')
            ->first();
        if (!empty($find_shre_data) && $find_shre_data->shre_state == 2) {
            return response()->json(['code'=>500, 'msg'=>'当前门店已绑定!', 'data'=>'']);
        }
        $find_shre_data = DB::table('shop')
            ->where('shop_id', $request['shop_id'])
            ->select('shop_id')
            ->first();
        if (empty($find_shre_data)) {
            return response()->json(['code'=>500, 'msg'=>'请传入正确的门店!', 'data'=>'']);
        }
        $shre_data['shre_relevance_shop_id'] = $request['ser_id'];
        $shre_data['shre_shop_id'] = $request['shop_id'];
        $shre_data['shre_relevance_type'] = 1;
        $shre_data['shre_state'] = 2;
        $shre_data['shre_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('shop_relevance')->insert($shre_data);
        if ($res) {
            return response()->json(['code'=>200, 'msg'=>'绑定成功', 'data'=>'']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'绑定失败', 'data'=>'']);
        }
    }
}
