<?php
namespace App\Http\Controllers\Api\OtherSystemInterfaces;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\OtherSystemInterfaces\VerifyOtherSystemAfterOrdersController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

class OtherSystemAfterOrdersController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 接单
    public function orderReceiving(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyOtherSystemAfterOrdersController;
        $error_message = $verify_data->orderReceivingValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>$error_message]);
        }

        $after_order_data = DB::table('order_after')
            ->where('oraf_id', $request['oraf_id'])
            ->select('oraf_other_system_number', 'oraf_wor_state', 'oraf_order_number', 'oraf_type')
            ->first();
        if ($after_order_data->oraf_wor_state != '2') {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'不是待接单状态,不能接单']);
        }

        $update_data['oraf_wor_state'] = 1;
        $update_data['oraf_after_state'] = 0;
        $update_data['oraf_update_time'] = date('Y-m-d H:i:s');
        DB::beginTransaction();

        $oraf_res = DB::table('order_after')
            ->where('oraf_id', $request['oraf_id'])
            ->update($update_data);

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $log_res = orderAfterLog($user_info, $request['oraf_id'], '3', '接收售后单');

        if ($oraf_res && $log_res) {
            Common::addLog($user_info, getRealIp($request), '售后单列表','接单','订单:'.$after_order_data->oraf_order_number.' 接单成功');
            DB::commit();
            return response()->json(["code"=>200,'msg'=>'success','data'=>'接单成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'接单失败']);
        }
    }
}
