<?php

namespace App\Http\Controllers\Api\MemberManage;

use App\Http\Models\Api\Common;
use App\Services\LoginUserService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Business\MemberLevelService;

//会员等级
class MemberLevelController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    //列表
    public function index(Request $request){

        $request = $request->all();
        $data = MemberLevelService::index($request);
        $user_info = Common::getUserInfo($request['api_token']);
        /*$log_data = [
            'oplo_module'=>'会员等级列表',
            'oplo_action'=>'会员等级列表',
            'oplo_content'=>'会员等级列表',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);*/
        return response()->json($data);

    }

    //添加
    public function add(Request $request){

        $request = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        /*$log_data = [
            'oplo_module'=>'添加会员等级',
            'oplo_action'=>'添加会员等级',
            'oplo_content'=>'添加会员等级',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);*/
        $data = MemberLevelService::add($request);
        return response()->json($data);

    }

    //修改
    public function edit(Request $request){

        $request = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        /*$log_data = [
            'oplo_module'=>'修改会员等级',
            'oplo_action'=>'修改会员等级',
            'oplo_content'=>'修改会员等级',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);*/
        $data = MemberLevelService::edit($request);
        return response()->json($data);
    }

    //商品列表
    public function getGoods(Request $request){

        $request = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        /*$log_data = [
            'oplo_module'=>'会员商品列表',
            'oplo_action'=>'会员商品列表',
            'oplo_content'=>'会员商品列表',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);*/
        $data = MemberLevelService::getGoods($request);
        return response()->json($data);

    }

    //新增赠礼
    public function editGoods(Request $request){
        $request = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        /*$log_data = [
            'oplo_module'=>'会员赠礼',
            'oplo_action'=>'会员赠礼',
            'oplo_content'=>'会员赠礼',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);*/
        $data = MemberLevelService::editGoods($request);
        return response()->json($data);
    }

    //黑钻升级
    public function upgrade(Request $request){
        $request = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        /*$log_data = [
            'oplo_module'=>'黑钻升级',
            'oplo_action'=>'黑钻升级',
            'oplo_content'=>'黑钻升级',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);*/
        $data = MemberLevelService::upgrade($request);
        return response()->json($data);
    }

}
