<?php

namespace App\Http\Controllers\Api\MemberManage;

use App\Http\Controllers\Common\CommonController;
use App\Services\CommonService;
use Illuminate\Http\Request;
// use Illuminate\Support\Facades\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\MemberManage\VerifyMemberListController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Api\CashierDesk;
use App\Services\Business\WashOrderService;
use App\Services\ReceivablePay\ReceivablePayService;
use App\Services\WeChatApplet\Technician\MemberService;
use \PhpOffice\PhpSpreadsheet\IOFactory;
use App\Services\Business\MemberLabelService;


class MemberLabelController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    /**
     * @name  列表页
     * @param action_name  控制器名
     * @param Request $request
     * @return mixed
     */
    public function index (Request $request)
    {
        $input = $request->all();
        $data = MemberLabelService::list($input);
        return response()->json($data);
    }

    /**
     * @name  列表页
     * @param action_name  控制器名
     * @param Request $request
     * @return mixed
     */
    public function allIndex (Request $request)
    {
        $input = $request->all();
        $data = MemberLabelService::allIndex($input);
        return response()->json($data);
    }
    /**
     * @name  添加
     * @param admin_id
     * @param action_name
     * @param action_value
     * @param adg_data
     * @param Request $request
     */
    public function add (Request $request)
    {
        $request = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        $data = MemberLabelService::add($user_info,$request);
        return response()->json($data);

    }

    /**
     * @name  编辑
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function edit (Request $request)
    {
        $request = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        $data = MemberLabelService::edit($user_info,$request);
        return response()->json($data);
    }


    /**
     * @name  删除
     * @param adg_id  数据id
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function editStatus (Request $request)
    {
        $request = $request->all();
        $data = MemberLabelService::editStatus($request);
        return response()->json($data);

    }
}
