<?php

namespace App\Http\Controllers\Api\FinanceManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\FinanceManage\VerifyGatheringManageController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;


class GatheringManageController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyGatheringManageController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $search_data = $request->all();

        $list_data = DB::table('order as o')
                    ->leftJoin('order_client as c', 'o.ord_orcl_id', '=', 'c.orcl_id')
                    ->where('o.ord_cid', $user_info->adm_cid)
                    ->where('o.ord_shop_id', $user_info->adm_shop_id)
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                            $query->whereBetween('o.ord_create_time',[$search_data['start_time'],$search_data['end_time']]);
                        }
                    })  //创建时间
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['ord_state'])) {
                            $query->where('o.ord_state', $search_data['ord_state'] );
                        }
                    }) //结算状态
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['ord_service_state'])) {
                            $query->where('o.ord_service_state', $search_data['ord_service_state'] );
                        }
                    }) //状态(订单服务状态)
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['ord_order_number'])) {
                            $query->where('o.ord_order_number', 'like', $search_data['ord_order_number'].'%' );
                        }
                    }) //订单编号
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['ord_service_shop_id'])) {
                            $query->where('o.ord_service_shop_id', 'like', $search_data['ord_service_shop_id'].'%' );
                        }
                    }) //服务门店
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['orcl_channel_unit'])) {
                            $query->where('c.orcl_channel_unit', 'like', '%'.$search_data['orcl_channel_unit'].'%' );
                        }
                    }) //购买方(渠道单位)
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['orcl_name'])) {
                            $query->where('c.orcl_name', 'like', $search_data['orcl_name'].'%' );
                        }
                    }) //客户姓名
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['orcl_phone'])) {
                            $query->where('c.orcl_phone', 'like', $search_data['orcl_phone'].'%' );
                        }
                    }) //客户电话
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['orcl_address'])) {
                            $query->where('c.orcl_address', 'like', $search_data['orcl_address'].'%' );
                        }
                    }) //地址
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['orcl_car_num'])) {
                            $query->where('c.orcl_car_num', 'like', $search_data['orcl_car_num'].'%' );
                        }
                    }) //车牌号
                    ->select('o.ord_id', 'o.ord_orcl_id', 'o.ord_order_number', 'o.ord_service_state', 'o.ord_payment_way','o.ord_actual_price', 'o.ord_quantity', 'o.ord_type', 'o.ord_state','o.ord_remark','o.ord_create_time','c.orcl_name','c.orcl_phone','c.orcl_car_num','c.orcl_address','c.orcl_channel_unit','o.ord_shop_id','o.ord_service_shop_id','o.ord_ware_id')
                    ->orderBy('o.ord_id', 'desc')
                    ->paginate($this->show_count);
        $data = $list_data->items();
        // 查询出当前公司下所有门店名称
        $shop = DB::table('shop')->where('shop_cid', $user_info->adm_cid)->get(['shop_id','shop_store_name']);
        foreach ($data as $key => $value) {
            foreach ($shop as $k => $v) {
                // 销售方
                if($value->ord_shop_id == $v->shop_id){
                    $data[$key]->ord_shop_name = $v->shop_store_name;
                }
                // 服务方
                if($value->ord_service_shop_id == $v->shop_id){
                    $data[$key]->service_shop_name = $v->shop_store_name;
                }
            }
        }

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $data;                //返回数据

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if($list_data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info, 'list_button'=>$list_button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }
    
    // 搜索服务门店
    public function searchShop(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $info = DB::table('shop')
                ->where('shop_cid', $user_info->adm_cid)
                ->get(['shop_id','shop_store_name']);

        return response()->json(['code'=> 200,'msg'=>'success','data'=>$info]);
    }

    // 订单详情
    public function orderDetails(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyGatheringManageController;
        $error_message = $verify_data->orderDetailsValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $info = DB::table('order as o')
                ->leftJoin('warehouse as w', 'o.ord_ware_id', '=', 'w.ware_id')
                ->where('o.ord_cid', $user_info->adm_cid)
                ->where('o.ord_shop_id', $user_info->adm_shop_id)
                ->where('o.ord_id', $request['ord_id'])
                ->first(['o.ord_order_number','o.ord_create_time','o.ord_order_price','o.ord_service_shop_id',
                         'o.ord_actual_price','o.ord_payment_way','o.ord_quantity','o.ord_type','o.ord_service_state',
                         'o.ord_state','o.ord_orcl_id','o.ord_remark','o.ord_service_adm_id','o.ord_appoint_id',
                         'o.ord_create_id','o.ord_service_type','w.ware_name','w.ware_leader_id']);
                
        // 获取采购商(仓库负责人)/创建人
        $adm_id = [
                    $info->ord_create_id,
                    $info->ord_service_adm_id,
                    $info->ord_appoint_id,
                    $info->ware_leader_id
                ];
        $adm_name = DB::table('admin')->whereIn('adm_id', $adm_id)->get(['adm_id','adm_name']);
        foreach ($adm_name as $key => $value) {
            if($value->adm_id == $info->ord_create_id){
                $info->create_name = $value->adm_name; //创建人
            }
            if($value->adm_id == $info->ware_leader_id){
                $info->procurer = $value->adm_name; //采购商
            }
            if($value->adm_id == $info->ord_service_adm_id){
                $info->service_adm_name = $value->adm_name; //技师
            }
            if($value->adm_id == $info->ord_appoint_id){
                $info->appoint_adm_name = $value->adm_name; //派单人
            }
        }

        // 查询门店信息
        $shop_id = [
                    $user_info->adm_shop_id,
                    $info->ord_service_shop_id
                ];
        $shop_store_name = DB::table('shop')->whereIn('shop_id', $shop_id)->get(['shop_id','shop_store_name']);
        foreach ($shop_store_name as $key => $value) {
            if($value->shop_id == $user_info->adm_shop_id){
                $info->adm_shop_store_name = $value->shop_store_name; //销售门店
            }
            if($value->shop_id == $info->ord_service_shop_id){
                $info->service_shop_store_name = $value->shop_store_name; //服务方门店
            }
        }

        // 获取下单人的信息  首先判断客户id是否为0 客户id=0：匿名购买 联系姓名/联系电话/地址
        if($info->ord_orcl_id != 0){
            $relation = DB::table('order_client')
                        ->where('orcl_id', $info->ord_orcl_id)
                        ->first(['orcl_name','orcl_phone','orcl_address','orcl_channel_unit','orcl_car_num']);
            $info->address = $relation->orcl_address; //地址
            $info->orcl_name = $relation->orcl_name; //联系人姓名
            $info->orcl_phone = $relation->orcl_phone; //联系人电话
            $info->orcl_car_num = $relation->orcl_car_num; //联系人车牌号
            $info->orcl_channel_unit = $relation->orcl_channel_unit; //渠道单位
        }

        // 获取该订单下的商品信息
        $goods = DB::table('order_goods as a')
                ->leftJoin('goods as b', 'b.goo_id', '=', 'a.orgo_goo_id')
                ->where('orgo_ord_id', $request['ord_id'])
                ->get(['orgo_goo_name','orgo_goo_goods_encode','orgo_amount','orgo_goo_price','goo_attribute']);
        $info->goods_info = $goods;

       return response()->json(['code'=> 200,'msg'=>'success','data'=>$info]);
    }

    // 供货仓库信息
    public function warehouseInfo(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyGatheringManageController;
        $error_message = $verify_data->warehouseInfoValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $info = DB::table('warehouse as w')
                ->leftJoin('admin as a', 'w.ware_leader_id', '=', 'a.adm_id')
                ->leftJoin('shop as s', 'w.ware_shop_id', '=', 's.shop_id')
                ->where('w.ware_id', $request['ord_ware_id'])
                ->first(['w.ware_name','w.ware_address','a.adm_name',
                         'a.adm_phone','s.shop_name']);

        return response()->json(['code'=> 200,'msg'=>'success','data'=>$info]);
    }
}
