<?php

namespace App\Http\Controllers\Api\ExcelInfo;

use App\Http\Models\Api\Common;
use App\Services\Business\MemberLevelService;
use App\Services\CommonService;
use App\Services\LoginUserService;
use Illuminate\Http\Request;
use DB;
use App\Http\Controllers\Controller;
use App\Services\Business\ExcelInfoService;

class ExcelpermissController extends Controller
{

    use \App\ExcelTemp\ExcelTemp;
    /**
     * @name  列表页
     * @param action_name  控制器名
     * @param Request $request
     * @return mixed
     */
    public function index (Request $request)
    {
        $input = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        $data = ExcelInfoService::list($input,$user_info,$request['show_count']);
        return response()->json($data);
    }

    /**
     * @name  添加
     * @param admin_id
     * @param action_name
     * @param action_value
     * @param adg_data
     * @param Request $request
     */
    public function excelAdd (Request $request)
    {
        $request = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        $data = ExcelInfoService::add($user_info,$request);
        return response()->json($data);

    }

    /**
     * @name  编辑
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function excelEdit (Request $request)
    {
        $request = $request->all();
        $data = ExcelInfoService::excelEdit($request);
        return response()->json($data);
    }


    /**
     * @name  删除
     * @param adg_id  数据id
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function excelDel (Request $request)
    {
        $request = $request->all();
        $data = ExcelInfoService::excelDel($request);
        return response()->json($data);

    }

    /**
     * @name  获取 控制器名称
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function excelActions (Request $request)
    {
        $data = $this->getActions();
        $user_info = Common::getUserInfo($request['api_token']);
        // 获取当前列表下的按钮
        $find_role = DB::table('role')
            ->leftjoin('admin_shop_role', 'role_id', '=', 'rol_id')
            ->where('adm_id', $user_info->adm_id)
            ->where('shop_id', $user_info->adm_shop_id)
            ->first();
        $rol_privilege_multiple = json_decode($find_role->rol_privilege_multiple, true);
        $pc_pri = explode(',', $rol_privilege_multiple['pc']);
        foreach ($data as $key => $value) {
            if (!in_array(398,$pc_pri) && $value['action_name'] == '采购管理') {
                unset($data[$key]);
            }
            if (!in_array(346,$pc_pri)  && $value['action_name'] == '调拨单') {
                unset($data[$key]);
            }
            if (!in_array(729,$pc_pri)  && $value['action_name'] == '应收应付') {
                unset($data[$key]);
            }
            if (!in_array(654,$pc_pri) && in_array($value['action_name'], ['绩效明细-工单','绩效明细-技师','绩效明细-详情']) ) {
                unset($data[$key]);
            }
        }
        foreach ($data as $key => $value) {
            $new_data[] = $value;
        }
        $data = $new_data;
        $adm_role = DB::table("admin")
            ->leftjoin('admin_shop_role as asr', 'asr.adm_id', '=', 'admin.adm_id')
            ->where('admin.adm_id',$user_info->adm_id)
            ->where('asr.shop_id',$user_info->adm_shop_id)
            ->value('asr.role_id as adm_role');
        $rol_type = DB::table("role")
            ->where('rol_id',$adm_role)
            ->value('rol_type');
        if($rol_type != 1){//1管理
            $my_excel = DB::table("admin_excel")
                ->where('adex_shop_id',$user_info->adm_shop_id)
                ->where('adex_role_id',$adm_role)
                ->pluck('adex_action');
            if(empty($my_excel)){
                return response()->json(['code' => 202, 'msg' => '您无相关控制器权限，请联系管理员', 'data' => '']);
            }else{
                $action_arr = [];
                foreach ($data as $key => $value){
                    $my_excel = CommonService::dataToArray($my_excel);
                    if(in_array($value['action_value'],$my_excel)){
                        $action_arr[] = $value;
                    }
                }
                if(empty($action_arr)){
                    return response()->json(['code' => 203, 'msg' => '您无相关控制器权限，请联系管理员', 'data' => '']);
                }else{
                    $data =  $action_arr;
                }
            }
        }
        return response()->json(['code' => 200, 'msg' => '获取成功', 'data' => $data]);
    }

    /**
     * @name  获取字段
     * @param action_value  控制器
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function excelFields (Request $request)
    {
        $request = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        if(isset($request['action_value'])){
            $data = $this->getField($request['action_value']);
            $adm_role = DB::table("admin")
                ->leftjoin('admin_shop_role as asr', 'asr.adm_id', '=', 'admin.adm_id')
                ->where('admin.adm_id',$user_info->adm_id)
                ->where('asr.shop_id',$user_info->adm_shop_id)
                ->value('asr.role_id as adm_role');
            $rol_type = DB::table("role")
                ->where('rol_id',$adm_role)
                ->value('rol_type');
            if($rol_type != 1){//1管理
                $my_excel = DB::table("admin_excel")
                    ->where('adex_shop_id',$user_info->adm_shop_id)
                    ->where('adex_action',$request['action_value'])
                    ->where('adex_role_id',$adm_role)
                    ->value('adex_data');
                if(empty($my_excel)){
                    return response()->json(['code' => 202, 'msg' => '您无该控制器权限，请联系管理员', 'data' => '']);
                }else{
                    $data = json_decode($my_excel,true);

                }
            }
            return response()->json(['code' => 200, 'msg' => '获取成功', 'data' => $data]);
        }else{
            return response()->json(['code' => 201, 'msg' => '请选择需要查询的控制器', 'data' => '']);
        }
    }

    //角色列表
    public function roleList (Request $request)
    {
        $request = $request->all();
        $data = ExcelInfoService::roleList($request);
        return response()->json($data);

    }

    //门店列表
    public function shopList (Request $request)
    {
        $request = $request->all();
        $data = ExcelInfoService::shopList($request);
        return response()->json($data);

    }
}
