<?php

namespace App\Http\Controllers\Api\DataSearch;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Controllers\Api\Verify\DataSearch\VerifyVehicleInquireController;
use App\Http\Controllers\Api\AESController;
use Ramsey\Uuid\Uuid;

class VehicleInquireController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    // aes密钥
    protected $aes_token = '397e2eb61307109f6e68006ebcb62f98';
    // appId
    protected $appid = 'store6e384e3df1480d7c';
    // 秘钥secret_key
    protected $secret_key = 'mVQ3VtEMiwyisdo0IuVsafbjSCkSSnjUSiANSBVd7l4Pct3rRFXKCvUAykxjAo20';

    // 列表
    public function index(Request $request)
    {
        // 数据加密
        $aes = new AESController($this->aes_token);
        $data['conditions'] = $request->input('conditions', '');
        $raw_token = $aes->encrypt(json_encode($data));

        // 调用速电的车型查询接口
        $url = config('apisystem.sd_server_name').'/index.php/search_battery';
        $post_data['token'] = $raw_token;
        // 模拟post提交请求数据,把返回的数据转成数组
        $return_data = json_decode(simulationPost($url, $post_data), true);

        // 返回的数据解密
        $de_data = json_decode($aes->decrypt($return_data['Data']), true);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$de_data]);
    }

    // 根据关键词查询车型数据
    public function getCarInfor(Request $request) 
    {   
        // 构建请求参数体
        $url = config('apisystem.third_api_server').'/api/third/search/by-keyword';
        // $url = 'http://data.bluedata.org.cn/api/third/search/by-keyword';
        $poss['appId'] = $this->appid;
        $poss['keyword'] = $request['keyword']; //关键词
        $poss['limit'] = $this->show_count; //条数
        $uuid = Uuid::uuid1();
        $poss['uuid'] = $uuid->toString();
        $poss['timeTamp'] = time();
        $poss = json_encode($poss,JSON_UNESCAPED_UNICODE);
        // 计算签名
        $header[] = "signature:".md5($poss.$this->secret_key);         
        $header[] = 'Content-Type:application/json';
        // 执行http请求
        $res = $this->request_post_webs($url,$poss,$header);
        $res_data = json_decode($res, true);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$res_data['data']]);
    }

    public function getCarInfobyid(Request $request) 
    {   
        // 构建请求参数体
        $url = config('apisystem.third_api_server').'/api/third/search/car-info/by-id';
        $poss['appId'] = $this->appid;
        $poss['id'] = $request['id']; //关键词
        $poss['limit'] = $this->show_count; //条数
        $uuid = Uuid::uuid1();
        $poss['uuid'] = $uuid->toString();
        $poss['timeTamp'] = time();
        $poss = json_encode($poss,JSON_UNESCAPED_UNICODE);
        // 计算签名
        $header[] = "signature:".md5($poss.$this->secret_key);         
        $header[] = 'Content-Type:application/json';
        // 执行http请求
        $res = $this->request_post_webs($url,$poss,$header);
        $res_data = json_decode($res, true);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$res_data['data']]);
    }

    private function request_post_webs(
        $url,
        $data,
        $headerArray
    ){
        // $headerArray =array("Content-type:application/json;charset='utf-8'","Accept:application/json");
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,FALSE);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        curl_setopt($curl,CURLOPT_HTTPHEADER,$headerArray);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($curl);
        curl_close($curl);
        return $output;
    }

    // 纠错
    public function correction(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyVehicleInquireController;
        $error_message = $verify_data->correctionValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 数据加密
        $aes = new AESController($this->aes_token);
        $data['good_id'] = $request['good_id'];//商品id
        $data['psj_pjid'] = $request['psj_pjid'];//车辆数据id
        $data['good_name'] = $request['good_name'];//旧商品型号
        $data['good_namenew'] = $request['good_namenew'];//纠错型号
        $data['details'] = $request['details'];//详情
        $data['admin_acc'] = $user_info->adm_name;//操作人
        $raw_token = $aes->encrypt(json_encode($data));

        // 调用速电的车型纠错接口
        $url = config('apisystem.sd_server_name').'/index.php/good_correct';
        $post_data['token'] = $raw_token;
        // 模拟post提交请求数据,把返回的数据转成数组
        $return_data = json_decode(simulationPost($url, $post_data), true);

        // 返回的数据解密
        $de_data = json_decode($aes->decrypt($return_data['Data']), true);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$de_data['ErrorMessage']]);
    }
}
