<?php
namespace App\Http\Controllers\Api\DataSearch;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Controllers\Api\Verify\DataSearch\VerifyLockGoodsOrderController;

class LockGoodsOrderController extends Controller
{
	// 列表每页显示数据个数
    protected $show_count = 10;

	// 查询锁定库存商品对应的订单
    public function queryList(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyLockGoodsOrderController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();

        if (empty($request['wafg_id'])) {
            $list_data = DB::table('warehouse_goods_lock as wgl')
                ->leftJoin('warehouse_goods as w','w.wago_id','=','wgl.wagl_wago_id')
                ->where('wagl_ware_id',$request['ware_id'])
                ->where('wagl_shop_id',$user_info->adm_shop_id)
                ->where('wagl_wago_id',$request['wago_id'])
                ->where('wagl_state',1)
                ->get(['wagl_type','wagl_lock_quantity','wagl_create_time','wagl_original_number']);
        } else {
            //仓位锁定商品
            $list_data = DB::table('warehouse_freight_goods_lock as wfgl')
                ->leftJoin('warehouse_goods as w','w.wago_id','=','wfgl.wfgl_wago_id')
                ->where('wfgl_ware_id',$request['ware_id'])
                ->where('wfgl_shop_id',$user_info->adm_shop_id)
                ->where('wfgl_wago_id',$request['wago_id'])
                ->where('wfgl_wafg_id',$request['wafg_id'])
                ->where('wfgl_state',1)
                ->get(['wfgl_type as wagl_type','wfgl_lock_quantity as wagl_lock_quantity','wfgl_create_time as wagl_create_time','wfgl_original_number as wagl_original_number']);
        }

        
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }
}
