<?php

namespace App\Http\Controllers\Api\DataSearch;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Services\DataSearch\GoodsInventory;

// 快速查询-商品查询-库存查询
class GoodsInventoryController extends Controller
{
	// 列表每页显示数据个数
    protected $show_count = 10;

	// 商品查询
    public function goodsIndex(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $select_field = "goo_id, goo_name, goo_goods_encode, goo_cate_name, goo_bra_name, goo_brse_id, goo_price, goo_wholesale_price, goo_class";
        $goods_inventory = new GoodsInventory();
        $return_data = $goods_inventory->goodsIndex($user_info, $request->all(), $this->show_count, $select_field);
        return response()->json($return_data);
    }

    // 查询商品库存数据
    public function goodsStockIndex(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $select_field = "ware_id, ware_name, wago_goo_id, wago_stock_number, wago_priority_stock_number, wago_class, goo_name, goo_goods_encode, goo_cate_name, goo_bra_name, goo_price, goo_wholesale_price, goo_brse_id, goo_class, goo_id, wago_freight_stock_number, wago_freight_priority_stock_number, wago_id, goo_purchase_price, goo_direct_accounting_price";
        $goods_inventory = new GoodsInventory();
        $return_data = $goods_inventory->stockIndex($user_info, $request->all(), $this->show_count, $select_field);
        return response()->json($return_data);
    }
}
