<?php
namespace App\Http\Controllers\Api\ChannelManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\ChannelManage\VerifyDistirbutionListsController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

// 运营系统 -- 铺货更换
class DistirbutionListsController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyDistirbutionListsController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        $list_data = DB::table('distirbution as dist')
            ->leftjoin('channel_unit as chun', 'chun.chun_id', '=', 'dist.dist_chun_id')
            ->leftjoin('visit as vis', 'vis.vis_id', '=', 'dist.dist_vis_id')
            ->where('dist.dist_cid', $user_info->adm_cid)
            ->where('dist.dist_superior_shop_id', $shop_id)
            ->where('dist_type', 1)
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                    $query->whereBetween('dist_create_time', [$search_data['start_time'],$search_data['end_time'].' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['start_time'])) {
                        $query->where('dist_create_time', '>=', $search_data['start_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['end_time'])) {
                            $query->where('dist_create_time', '<=', $search_data['end_time'].' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['chun_unit_name'])) {
                    $query->where('chun_unit_name', 'like', '%'.$search_data['chun_unit_name'].'%');
                }
            })//客户单位名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['dist_state'])) {
                    $query->where('dist_state', $search_data['dist_state']);
                }
            }) //状态1待处理2已处理
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['vis_name'])) {
                    $query->where('vis_name', 'like', '%'.$search_data['vis_name'].'%');
                }
            })//拜访名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['vis_executor_adm_id'])) {
                    $query->where('vis_executor_adm_id', $search_data['vis_executor_adm_id']);
                }
            })//业务员
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['dist_chun_id'])) {
                    $query->where('dist_chun_id', $search_data['dist_chun_id']);
                }
            })//客户单位id
            ->select('dist_id', 'vis_id', 'vis_name', 'vis_executor_adm_id', 'dist_chun_id', 'chun_unit_name', 'dist_type', 'dist_state', 'dist_create_id', 'dist_create_time')
            ->orderBy('dist_id', 'desc')
            ->paginate($this->show_count);
        $data = $list_data->items();
        if ($data) {
            // 获取创建人id
            $executor_adm_id = array_column($data, 'vis_executor_adm_id');//获取业务员id
            $create_id = array_column($data, 'vis_create_id');//获取创建人id
            $adm_id = array_unique(array_merge($executor_adm_id, $create_id));
            // 查询账号信息
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->select('adm_id', 'adm_name')
                ->get();
            $data_info['admin'] = $find_admin;
            $data_info['executor_adm_id'] = $find_admin;
        }
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $data;                //返回数据
        
        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'list_button'=>$list_button]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // 处理
    public function dispose(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyDistirbutionListsController;
        $error_message = $verify_data->disposeValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 处理
        $update_data['dist_state'] = 2;//状态1待处理2已处理
        $update_data['dist_update_time'] = date('Y-m-d H:i:s');
        $dist_res = DB::table('distirbution')
            ->where('dist_id', $request['dist_id'])
            ->update($update_data);

        if ($dist_res) {
            // 查询信息
            $find_dist = DB::table('distirbution as dist')
                ->leftjoin('channel_unit as chun', 'chun.chun_id', '=', 'dist.dist_chun_id')
                ->where('dist_id', $request['dist_id'])
                ->value('chun_unit_name');
            Common::addLog($user_info, getRealIp($request), '铺货更换', '处理', '铺货更换：（'.$find_dist.'）处理成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'处理成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'处理失败']);
        }
    }
}
