<?php

namespace App\Http\Controllers\Api\BackEnd;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use App\Http\Models\Api\Export;
use App\Http\Models\Api\StockingSelling;
use App\Http\Models\Api\StockSellStorageGoods;
use App\Http\Models\Api\Common;
use App\Http\Controllers\Api\YongYou\YongYouController;
use Illuminate\Support\Facades\Crypt;
use App\Services\Business\WashPayservice;
use App\Http\Models\Api\CashierDesk;

class DataAdjustController extends Controller
{
    /*
        洗美的门店
        门店id 
        32  Mallbay汽车贴膜工厂 18611722254
     */
    protected $shop_id = [2]; //已经使用系统的门店
    // ini_set('max_execution_time', '0');  //运行时间无限制
    protected $now_time = '2021-12-20 20:30:16'; //当前时间，新增盘库单使用
    protected $show_count = 10;

    // 入口方法
    public function entrance(Request $request)
    {
        // 将数据中的数据表及字段查询出来，并导出markdown语法格式
        // $this->databaseFieldComment();

        // ===============================
        // 每天运行统计查看程序
        // $this->diffwarehouseFreight();//统计仓库总量与仓库+仓位数量不一致--01
        // $this->freightGoodsKucun();//仓位商品表数量统计并保存--02
        // $this->kucunTongji($request);//统计库存数量--03
        // ==============================

        // ==============
        // 导入门店期初商品库存
        // $this->importExcelData($request);//导入Excel数据
        // $this->other($request);//将读取到的Excel表格数据，添加到数据库
        // $this->freightGoodsDiff($request);//仓库商品表中有的商品，在仓位商品表中没有的，查询出
        // ==============
        // 先调用addOldStock这个方法，在goods_hangzhou表添加数据，然后addgoods，最后 addOldStock
        // $this->importExcelVipData($request);//会员及会员卡导入
        // $this->editEndtime($request);//会员及会员卡导入
        // $this->subAccount($request);//支付分账解冻测试
        // $this->returnorders($request);//请求分账回退
        // $this->weixinPush($request);//微信消息发送
        // $this->editimg($request);//调整图片路径
        // $this->validator($request);//调整验车数据
        // $this->getQuantity($request);//施工数据
        // $this->receiveSubmit($request);//接单
        // $this->editRole($request);//接单
        // $this->editlead($request);//接单
        // $this->editAdminSet($request);//修改admin_set
        // $this->editCom($request);//修改admin_set
        // $this->edit();//修改权限
        // $this->editPicPath();
        // $this->editSaleman();
        // $this->editweshopid();
        // $this->usershop();
        // $this->ordType();
        // $this->addordType();
        // $this->updateWopl();
    }

    public function updateWopl(){
        $find_wopl_data = DB::table('work_plan')
            ->where('wopl_ord_id', '>', 0)
            ->where('wopl_id', '>', 9644)
            // ->where('wopl_id', '<', 10000)
            ->select('wopl_ord_id', 'wopl_id')
            ->get();
        foreach ($find_wopl_data as $key => $value) {
            if (!empty($value->wopl_ord_id)) {
                $ord_new_type = DB::table('order')
                    ->where('ord_id', $value->wopl_ord_id)
                    ->value('ord_new_type');
                $updata_res = DB::table('work_plan')
                    ->where('wopl_id', $value->wopl_id)
                    ->update(['wopl_ord_new_type'=>$ord_new_type]);
            }
        }
        echo 'success';
    }

    public function addordType() {
        $find_shop = DB::table('shop')
            ->select('shop_id')
            ->get();
        foreach ($find_shop as $key => $value) {
            $find_order_type = DB::table('order_type')
                ->where('orty_shop_id', $value->shop_id)
                ->value('orty_id');
            if ($value->shop_id != 2) {
                $updata_data['ord_new_type'] = $find_order_type;
                $updata_res = DB::table('order')
                    ->where('ord_shop_id', $value->shop_id)
                    ->update($updata_data);
            }
        }
    }

    public function ordType(){
        $find_shop = DB::table('shop')
            ->select('shop_id')
            ->get();
        foreach ($find_shop as $key => $value) {
            $find_order_type = DB::table('order_type')
                ->where('orty_shop_id', $value->shop_id)
                ->first();
            if (empty($find_order_type)) {
                $add_datas['orty_shop_id'] = $value->shop_id;
                $add_datas['orty_name'] = '服务单';
                $add_datas['orty_create_time'] = date('Y-m-d H:i:s');
                $add_datas['orty_state'] = 1;
                $add_datas['orty_default'] = 1;
                $add_res = DB::table('order_type')->insert($add_datas);
            }
        }
    }

    public function usershop() {
        $find_ussh = DB::table('user_shop')
            ->get()->toArray();
        foreach ($find_ussh as $key => $value) {
            $find_mem = DB::table('member')
                ->where('mem_id', $value->ussh_user_id)
                ->value('mem_id');
            if (empty($find_mem)) {
                $del = DB::table('user_shop')->where('ussh_id', $value->ussh_id)->delete();
            }
        }
    }

    public function editweshopid() {
        $find_weus = DB::table('weixin_user')
            ->where('weus_shop_id', '=', null)
            ->get()->toArray();
        foreach ($find_weus as $key => $value) {
            $updata_data['weus_shop_id'] = DB::table('user_shop')
                ->where('ussh_weus_id', $value->weus_id)
                ->where('ussh_now_login', 1)
                ->value('ussh_shop_id');
            $update_res = DB::table('weixin_user')->where('weus_id', $value->weus_id)->update($updata_data);
        }
        echo '999';
    }

    public function editSaleman() {
        $find_order_client = DB::table('order_client')
            ->where('orcl_sales_adm_id', '!=', '')
            // ->where('orcl_ord_id', 156)
            ->select('orcl_sales_adm_id', 'orcl_id', 'orcl_ord_id')
            ->get()->toArray();
        foreach ($find_order_client as $key => $value) {
            $updata_data['orcl_sales_adm_name'] = DB::table('admin')
                ->where('adm_id', $value->orcl_sales_adm_id)
                ->value('adm_name');
            $updata_res = DB::table('order_client')
                ->where('orcl_id', $value->orcl_id)
                ->update($updata_data);
            $find_work = DB::table('work_client')
                ->leftJoin('work_order', 'wor_id', '=', 'wocl_wor_id')
                ->where('wor_order_id', $value->orcl_ord_id)
                ->exists();
            if ($find_work) {
                $work_data['wocl_sales_adm_name'] = $updata_data['orcl_sales_adm_name'];
                $work_data['wocl_adm_id'] = $value->orcl_sales_adm_id;
                $wocl_res = DB::table('work_client')
                    ->leftJoin('work_order', 'wor_id', '=', 'wocl_wor_id')
                    ->where('wor_order_id', $value->orcl_ord_id)
                    ->update($work_data);
            }
            echo $value->orcl_ord_id;
        }
    }

    public function editPicPath() {
        //订单签字图片
        // $find_work_order = DB::table('work_order')
        //     ->leftJoin('order', 'ord_id', '=', 'wor_order_id')
        //     ->leftJoin('order_client', 'ord_id', '=', 'orcl_ord_id')
        //     ->where('ord_source', 5)
        //     ->where('ord_create_time', '<', '2024-04-06 23:59:59')
        //     ->where('orcl_signature_img', '!=', '')
        //     ->select('ord_order_number','orcl_signature_img', 'orcl_id')
        //     ->get()->toArray();

        // foreach ($find_work_order as $key => $value) {
        //     $find_pic_data = DB::table('pic_data')
        //         ->where('old_id_name', 'orcl_id')
        //         ->where('old_id', $value->orcl_id)
        //         ->first();
        //     if (empty($find_pic_data)) {
        //         $pic_url = substr($value->orcl_signature_img, 0,5);
        //         if ($pic_url == 'https') {
        //             $url_len = strlen(config('apisystem.server_name_https').'/');
        //             $pic_url_sto = substr($value->orcl_signature_img,$url_len);
        //             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //         }
        //         if ($pic_url == 'http:') {
        //             $url_len = strlen(config('apisystem.server_name_https'));
        //             $pic_url_sto = substr($value->orcl_signature_img,$url_len);
        //             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //         }
        //         if ($pic_url == 'stora') {
        //             $pic_url_sto = $value->orcl_signature_img;
        //             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //         }
        //         $destinationFilejia = substr($destinationFile,0,-20);
        //         // 判断文件夹是否存在，不存在创建文件夹
        //         if (!file_exists($destinationFilejia)) {
        //             mkdir($destinationFilejia, 0775, true);
        //             chmod($destinationFilejia, 0775);
        //         }
        //         if (file_exists($pic_url_sto)) {
        //             copy($pic_url_sto, $destinationFile);
        //         }
        //         if (file_exists($destinationFile)) {
        //             deleteImage([$pic_url_sto]);
        //         }
        //         $updata_data['orcl_signature_img'] = config('apisystem.server_name_https').'/'.$destinationFile;
        //         $updata_data['orcl_update_time'] = date('Y-m-d H:i:s');
        //         dump($updata_data['orcl_signature_img']);
        //         dump($value->orcl_id);
        //         dump($value->ord_order_number);
        //         $update_res = DB::table('order_client')
        //             ->where('orcl_id', $value->orcl_id)
        //             ->update($updata_data);
        //         $add_data['old_id'] = $value->orcl_id;
        //         $add_data['old_id_name'] = 'orcl_id';
        //         $add_data['old_pic_url'] = $value->orcl_signature_img;
        //         $add_data['new_pic_url'] = $updata_data['orcl_signature_img'];
        //         $add_data['ord_order_number'] = $value->ord_order_number;
        //         $add_res = DB::table('pic_data')->insertGetId($add_data);
        //         unset($updata_data);
        //     }
        // }
        // 验车图片
        // $wash_validate_car = DB::table('wash_validate_car')
        //     ->leftJoin('order', 'ord_id', '=', 'vaca_ord_id')
        //     ->where('ord_source', 5)
        //     ->where('vaca_data', '!=', '')
        //     ->where('ord_create_time', '<', '2024-04-06 23:59:59')
        //     ->whereIn('vaca_type',[1,3,6])//1检验商品图片2快捷部位3快捷图片4验车里程5是否合格6签字图片
        //     ->select('vaca_id', 'vaca_data', 'ord_order_number')
        //     ->get()->toArray();
        // foreach ($wash_validate_car as $key => $value) {
        //     $find_pic_data = DB::table('pic_data')
        //         ->where('old_id_name', 'vaca_id')
        //         ->where('old_id', $value->vaca_id)
        //         ->first();
        //     if (empty($find_pic_data)) {
        //         $pic_url = substr($value->vaca_data, 0,5);
        //         if ($pic_url == 'https') {
        //             $url_len = strlen(config('apisystem.server_name_https').'/');
        //             $pic_url_sto = substr($value->vaca_data,$url_len);
        //             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //         }
        //         if ($pic_url == 'http:') {
        //             $url_len = strlen(config('apisystem.server_name_https'));
        //             $pic_url_sto = substr($value->vaca_data,$url_len);
        //             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //         }
        //         if ($pic_url == 'stora') {
        //             $pic_url_sto = $value->vaca_data;
        //             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //         }
        //         $destinationFilejia = substr($destinationFile,0,-20);
        //         // 判断文件夹是否存在，不存在创建文件夹
        //         if (!file_exists($destinationFilejia)) {
        //             mkdir($destinationFilejia, 0775, true);
        //             chmod($destinationFilejia, 0775);
        //         }
        //         if (file_exists($pic_url_sto)) {
        //             copy($pic_url_sto, $destinationFile);
        //         }
        //         if (file_exists($destinationFile)) {
        //             deleteImage([$pic_url_sto]);
        //         }
        //         $updata_data['vaca_data'] = config('apisystem.server_name_https').'/'.$destinationFile;
        //         $updata_data['vaca_update_time'] = date('Y-m-d H:i:s');
        //         dump($updata_data['vaca_data']);
        //         dump($value->vaca_id);
        //         $update_res = DB::table('wash_validate_car')
        //             ->where('vaca_id', $value->vaca_id)
        //             ->update($updata_data);
        //         $add_data['old_id'] = $value->vaca_id;
        //         $add_data['old_id_name'] = 'vaca_id';
        //         $add_data['old_pic_url'] = $value->vaca_data;
        //         $add_data['new_pic_url'] = $updata_data['vaca_data'];
        //         $add_data['ord_order_number'] = $value->ord_order_number;
        //         $add_res = DB::table('pic_data')->insertGetId($add_data);
        //         unset($updata_data);
        //     }
        // }

        // $checkcar_supplement_res = DB::table('checkcar_supplement')
        //     ->leftJoin('order', 'ord_id', '=', 'chsu_ord_id')
        //     ->where('ord_source', 5)
        //     ->where('chsu_img', '!=', '')
        //     ->where('ord_create_time', '<', '2024-04-06 23:59:59')
        //     ->select('chsu_id', 'chsu_img', 'ord_order_number', 'chsu_sign')
        //     ->get()->toArray();
        // foreach ($checkcar_supplement_res as $key => $value) {
        //     $find_pic_data = DB::table('pic_data')
        //         ->where('old_id_name', 'chsu_id')
        //         ->where('old_id', $value->chsu_id)
        //         ->first();
        //     if (empty($find_pic_data)) {
        //         $chsu_img = json_decode($value->chsu_img, true);
        //         if (!empty($chsu_img)) {
        //             foreach ($chsu_img as $k=>$v) {
        //                 $pic_url = substr($v, 0,5);
        //                 if ($pic_url == 'https') {
        //                     $url_len = strlen(config('apisystem.server_name_https').'/');
        //                     $url_len += 4;
        //                     $pic_url_sto = substr($v,$url_len);
        //                     $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                 }
        //                 if ($pic_url == 'http:') {
        //                     $url_len = strlen(config('apisystem.server_name_https'));
        //                     $pic_url_sto = substr($v,$url_len);
        //                     $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                 }
        //                 if ($pic_url == 'stora') {
        //                     $pic_url_sto = $v;
        //                     $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                 }
        //                 $destinationFilejia = substr($destinationFile,0,-20);
                        
        //                 // 判断文件夹是否存在，不存在创建文件夹
        //                 if (!file_exists($destinationFilejia)) {
        //                     mkdir($destinationFilejia, 0775, true);
        //                     chmod($destinationFilejia, 0775);
        //                 }
        //                 if (file_exists($pic_url_sto)) {
        //                     copy($pic_url_sto, $destinationFile);
        //                 }
        //                 if (file_exists($destinationFile)) {
        //                     deleteImage([$pic_url_sto]);
        //                 }
        //                 $new_data[] = config('apisystem.server_name_https').'/'.$destinationFile;
        //             }
        //             $updata_data['chsu_img'] = json_encode($new_data, true);
                    
                    
        //             $add_data['old_id'] = $value->chsu_id;
        //             $add_data['old_id_name'] = 'chsu_id chsu_img';
        //             $add_data['old_pic_url'] = $v;
        //             $add_data['new_pic_url'] = $updata_data['chsu_img'];
        //             $add_data['ord_order_number'] = $value->ord_order_number;
        //             $add_res = DB::table('pic_data')->insertGetId($add_data);
        //         }
        //         if (!empty($value->chsu_sign)) {
        //             $pic_url = substr($value->chsu_sign, 0,5);
        //             if ($pic_url == 'https') {
        //                 $url_len = strlen(config('apisystem.server_name_https').'/');
        //                 $url_len += 4;
        //                 $pic_url_sto = substr($value->chsu_sign,$url_len);
        //                 $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //             }
        //             if ($pic_url == 'http:') {
        //                 $url_len = strlen(config('apisystem.server_name_https'));
        //                 $pic_url_sto = substr($value->chsu_sign,$url_len);
        //                 $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //             }
        //             if ($pic_url == 'stora') {
        //                 $pic_url_sto = $value->chsu_sign;
        //                 $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //             }
        //             $destinationFilejia = substr($destinationFile,0,-20);
        //             // 判断文件夹是否存在，不存在创建文件夹
        //             if (!file_exists($destinationFilejia)) {
        //                 mkdir($destinationFilejia, 0775, true);
        //                 chmod($destinationFilejia, 0775);
        //             }
        //             if (file_exists($pic_url_sto)) {
        //                 copy($pic_url_sto, $destinationFile);
        //             }
        //             if (file_exists($destinationFile)) {
        //                 deleteImage([$pic_url_sto]);
        //             }
        //             $updata_data['chsu_sign'] = config('apisystem.server_name_https').'/'.$destinationFile;
        //             $add_data['old_id'] = $value->chsu_id;
        //             $add_data['old_id_name'] = 'chsu_id chsu_sign';
        //             $add_data['old_pic_url'] = $v;
        //             $add_data['new_pic_url'] = $updata_data['chsu_sign'];
        //             $add_data['ord_order_number'] = $value->ord_order_number;
        //             $add_res = DB::table('pic_data')->insertGetId($add_data);
        //         }
        //         $updata_data['chsu_update_time'] = date('Y-m-d H:i:s');
        //         $update_res = DB::table('checkcar_supplement')
        //             ->where('chsu_id', $value->chsu_id)
        //             ->update($updata_data);
        //         unset($updata_data);
        //     }
        // }
        // 施工图片
        // $completion_info = DB::table('completion_info')
        //     ->leftJoin('order', 'ord_id', '=', 'coin_ord_id')
        //     ->where('coin_data', '!=', '')
        //     ->where('ord_source', 5)
        //     ->where('ord_create_time', '<', '2024-04-06 23:59:59')
        //     ->whereIn('coin_type', [2,3])
        //     ->select('coin_id', 'coin_data', 'ord_order_number')
        //     ->get()->toArray();
        // foreach ($completion_info as $key => $value) {
        //     $find_pic_data = DB::table('pic_data')
        //         ->where('old_id_name', 'coin_id')
        //         ->where('old_id', $value->coin_id)
        //         ->first();
        //     if (empty($find_pic_data)) {
        //         $pic_url = substr($value->coin_data, 0,5);
        //         if ($pic_url == 'https') {
        //             $url_len = strlen(config('apisystem.server_name_https').'/');
        //             $pic_url_sto = substr($value->coin_data,$url_len);
        //             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //         }
        //         if ($pic_url == 'http:') {
        //             $url_len = strlen(config('apisystem.server_name_https'));
        //             $pic_url_sto = substr($value->coin_data,$url_len);
        //             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //         }
        //         if ($pic_url == 'stora') {
        //             $pic_url_sto = $value->coin_data;
        //             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //         }
        //         $destinationFilejia = substr($destinationFile,0,-20);
        //         // 判断文件夹是否存在，不存在创建文件夹
        //         if (!file_exists($destinationFilejia)) {
        //             mkdir($destinationFilejia, 0775, true);
        //             chmod($destinationFilejia, 0775);
        //         }
        //         if (file_exists($pic_url_sto)) {
        //             copy($pic_url_sto, $destinationFile);
        //         }
        //         if (file_exists($destinationFile)) {
        //             deleteImage([$pic_url_sto]);
        //         }
        //         $updata_data['coin_data'] = config('apisystem.server_name_https').'/'.$destinationFile;
        //         $updata_data['coin_update_time'] = date('Y-m-d H:i:s');
        //         dump($updata_data['coin_data']);
        //         dump($value->coin_id);
        //         $update_res = DB::table('completion_info')
        //             ->where('coin_id', $value->coin_id)
        //             ->update($updata_data);
        //         $add_data['old_id'] = $value->coin_id;
        //         $add_data['old_id_name'] = 'coin_id';
        //         $add_data['old_pic_url'] = $value->coin_data;
        //         $add_data['new_pic_url'] = $updata_data['coin_data'];
        //         $add_data['ord_order_number'] = $value->ord_order_number;
        //         $add_res = DB::table('pic_data')->insertGetId($add_data);
        //         unset($updata_data);
        //     }
        // }
        // $wash_work_check_history = DB::table('wash_work_check_history')
        //     ->leftJoin('work_order', 'wor_id', '=', 'woch_wor_id')
        //     ->leftJoin('order', 'ord_id', '=', 'wor_order_id')
        //     ->where('ord_source', 5)
        //     ->where('ord_create_time', '<', '2024-04-06 23:59:59')
        //     ->select('woch_part_data', 'woch_id', 'woch_shop_id', 'ord_order_number')
        //     ->get()->toArray();
        // foreach ($wash_work_check_history as $key => $value) {
        //     $find_pic_data = DB::table('pic_data')
        //         ->where('old_id_name', 'woch_id')
        //         ->where('old_id', $value->woch_id)
        //         ->first();
        //     if (empty($find_pic_data)) {
        //         if (!empty($value->woch_part_data)) {
        //             $woch_part_data = json_decode($value->woch_part_data, true);
        //             foreach ($woch_part_data as $k => $v) {
        //                 $new_data[$k]['wotp_service_part'] = $v['wotp_service_part'];
        //                 $new_data[$k]['wotp_id'] = $v['wotp_id'];
        //                 if (!empty($v['pic'])) {
        //                     foreach ($v['pic'] as $key1 => $value1) {
        //                         $pic_url = substr($value1, 0,5);
        //                         if ($pic_url == 'https') {
        //                             $url_len = strlen(config('apisystem.server_name_https').'/');
        //                             $pic_url_sto = substr($value1,$url_len);
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         if ($pic_url == 'http:') {
        //                             $url_len = strlen(config('apisystem.server_name_https'));
        //                             $pic_url_sto = substr($value1,$url_len);
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         if ($pic_url == 'stora') {
        //                             $pic_url_sto = $value1;
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         $destinationFilejia = substr($destinationFile,0,-20);
        //                         // 判断文件夹是否存在，不存在创建文件夹
        //                         if (!file_exists($destinationFilejia)) {
        //                             mkdir($destinationFilejia, 0775, true);
        //                             chmod($destinationFilejia, 0775);
        //                         }
        //                         if (file_exists($pic_url_sto)) {
        //                             copy($pic_url_sto, $destinationFile);
        //                         }
        //                         if (file_exists($destinationFile)) {
        //                             deleteImage([$pic_url_sto]);
        //                         }
        //                         $new_pic[] = config('apisystem.server_name_https').'/'.$destinationFile;
        //                     }
        //                 } else {
        //                     $new_pic = [];
        //                 }
        //                 $new_data[$k]['pic'] = $new_pic;
        //                 unset($new_pic);
        //             }
        //             $updata_data['woch_part_data'] = json_encode($new_data, true);
        //             $updata_data['woch_update_time'] = date('Y-m-d H:i:s');
        //             $updata_res = DB::table('wash_work_check_history')
        //                 ->where('woch_id', $value->woch_id)
        //                 ->update($updata_data);
        //             $add_data['old_id'] = $value->woch_id;
        //             $add_data['old_id_name'] = 'woch_id';
        //             $add_data['old_pic_url'] = $value->woch_part_data;
        //             $add_data['new_pic_url'] = $updata_data['woch_part_data'];
        //             $add_data['ord_order_number'] = $value->ord_order_number;
        //             $add_res = DB::table('pic_data')->insertGetId($add_data);
        //             unset($updata_data);
        //             unset($new_data);
        //             unset($new_pic);
        //             dump($value->ord_order_number);
        //             dump($value->woch_id);
        //         }
        //     }
        // }
        // $find_data = DB::table('data_purl')
        //     ->leftJoin('order', 'ord_other_system_number', '=', 'p_number')
        //     // ->leftJoin('work_order', 'wor_id', '=', 'wor_order_id')
        //     // ->leftJoin('wash_work_check_history', 'woch_wor_id', '=', 'wor_id')
        //     // ->leftJoin('auto_parts', 'title', '=', 'name')
        //     // ->where('p_number', 'P20221209095556380')
        //     ->select('ord_id', 'url', 'name')
        //     ->get()->toArray();
        // $num = 0;
        // $data = [];
        // foreach ($find_data as $key => $value) {
        //     $data['wotp_service_part'] = $value->name;
        //     $data['wotp_id'] = DB::table('auto_parts')
        //         ->where('title', $value->name)
        //         ->value('id');
        //     // $pic_url = $value->url;
        //     $pic_url = substr($value->url, 0,5);
        //     if ($pic_url == 'https') {
        //         $url_len = strlen(config('apisystem.server_name_https').'/');
        //         $pic_url_sto = substr($value->url,$url_len);
        //         $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //     }
        //     if ($pic_url == 'http:') {
        //         $url_len = strlen(config('apisystem.server_name_https'));
        //         $pic_url_sto = substr($value->url,$url_len);
        //         $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //     }
        //     if ($pic_url == 'stora') {
        //         $pic_url_sto = $value->url;
        //         $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //     }
        //     $data['pic'][] = config('apisystem.server_name_https').'/'.$destinationFile;
        //     $new_data[$value->ord_id]['woch_part_data'][] = $data;
        //     unset($data);
        // }
        // foreach ($new_data as $key => $value) {
        //     $updata_data[$key]['ord_id'] = $key;
        //     $updata_data[$key]['woch_part_data'] = json_encode($value['woch_part_data'], true);
        //     $new_update['woch_part_data'] = json_encode($value['woch_part_data'], true);
        //     $new_update['woch_update_time'] = date('Y-m-d H:i:s');
        //     $find_woch = DB::table('wash_work_check_history')
        //         ->leftJoin('work_order', 'wor_id', '=', 'woch_wor_id')
        //         ->leftJoin('order', 'ord_id', '=', 'wor_order_id')
        //         ->where('ord_id', $key)
        //         ->first();
        //     $new_res = DB::table('wash_work_check_history')
        //         ->where('woch_id', $find_woch->woch_id)
        //         ->update($new_update);
        //     dump($new_update);
        //     unset($new_update);
        // }
        // $wash_order_validate_car = DB::table('wash_order_validate_car')
        //     ->leftJoin('order', 'ord_id', '=', 'orvc_ord_id')
        //     ->where('ord_source', 5)
        //     ->where('ord_create_time', '<', '2024-04-06 23:59:59')
        //     ->select('orvc_car_interior', 'orvc_car_exterior', 'ord_order_number', 'orvc_id')
        //     ->get()->toArray();
     
        // foreach ($wash_order_validate_car as $key => $value) {
        //     $find_pic_data = DB::table('pic_data')
        //         ->where('old_id', $value->orvc_id)
        //         ->where('old_id_name', 'orvc_id')
        //         ->first();
        //     if (empty($find_pic_data)) {
        //         $orvc_car_interior = json_decode($value->orvc_car_interior, true);
        //         $new_data = [];
        //         foreach ($orvc_car_interior as $key1 => $value1) {
        //             if (!empty($value1['car_video'])) {
        //                 foreach ($value1['car_video'] as $k => $v) {
        //                     $new_data[$key1]['car_video'][$k]['vodie_titile'] = $v['vodie_titile'];
        //                     if (isset($v['vodie_path'])) {
        //                         $pic_url = substr($v['vodie_path'], 0,5);
        //                         if ($pic_url == 'https') {
        //                             $url_len = strlen(config('apisystem.server_name_https').'/');
        //                             $pic_url_sto = substr($v['vodie_path'],$url_len);
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         if ($pic_url == 'http:') {
        //                             $url_len = strlen(config('apisystem.server_name_https'));
        //                             $pic_url_sto = substr($v['vodie_path'],$url_len);
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         if ($pic_url == 'stora') {
        //                             $pic_url_sto = $v['vodie_path'];
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         $destinationFilejia = substr($destinationFile,0,-20);
        //                         // 判断文件夹是否存在，不存在创建文件夹
        //                         if (!file_exists($destinationFilejia)) {
        //                             mkdir($destinationFilejia, 0775, true);
        //                             chmod($destinationFilejia, 0775);
        //                         }
        //                         if (file_exists($pic_url_sto)) {
        //                             copy($pic_url_sto, $destinationFile);
        //                         }
        //                         if (file_exists($destinationFile)) {
        //                             deleteImage([$pic_url_sto]);
        //                         }
                                
        //                         $new_data[$key1]['car_video'][$k]['vodie_path'] = config('apisystem.server_name_https').'/'.$destinationFile;
        //                     } else {
        //                         $new_data[$key1]['car_video'][$k]['vodie_path'] = '';
        //                     }
        //                 }
        //             } else {
        //                 $new_data[$key1]['car_video'] = [];
        //             }
        //             if (!empty($value1['in_car'])) {
        //                 foreach ($value1['in_car'] as $k3 => $v3) {
        //                     $new_data[$key1]['in_car'][$k3]['vacm_id'] = $v3['vacm_id'];
        //                     $new_data[$key1]['in_car'][$k3]['vacm_unusual_name'] = $v3['vacm_unusual_name'];
        //                     $new_image = [];
        //                     foreach ($v3['image'] as $kk3 => $vv3) {
        //                         $pic_url = substr($vv3, 0,5);
        //                         if ($pic_url == 'https') {
        //                             $url_len = strlen(config('apisystem.server_name_https').'/');
        //                             $pic_url_sto = substr($vv3,$url_len);
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         if ($pic_url == 'http:') {
        //                             $url_len = strlen(config('apisystem.server_name_https'));
        //                             $pic_url_sto = substr($vv3,$url_len);
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         if ($pic_url == 'stora') {
        //                             $pic_url_sto = $vv3;
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         $destinationFilejia = substr($destinationFile,0,-20);
        //                         // 判断文件夹是否存在，不存在创建文件夹
        //                         if (!file_exists($destinationFilejia)) {
        //                             mkdir($destinationFilejia, 0775, true);
        //                             chmod($destinationFilejia, 0775);
        //                         }
        //                         if (file_exists($pic_url_sto)) {
        //                             copy($pic_url_sto, $destinationFile);
        //                         }
        //                         if (file_exists($destinationFile)) {
        //                             deleteImage([$pic_url_sto]);
        //                         }
        //                         $new_image[] = config('apisystem.server_name_https').'/'.$destinationFile;
        //                     }
        //                     $new_data[$key1]['in_car'][$k3]['image'] = $new_image;
        //                     $new_data[$key1]['in_car'][$k3]['remark'] = $v3['remark'];
                            
        //                 }
        //             } else {
        //                 $new_data[$key1]['in_car'] = [];
        //             }
        //         }
                
        //         $orvc_car_exterior = json_decode($value->orvc_car_exterior, true);
        //         $new_orvc_car_exterior = [];
        //         foreach ($orvc_car_exterior as $key11 => $value11) {
        //             if (!empty($value11['car_exterior'])) {
        //                 foreach ($value11['car_exterior'] as $k => $v) {
        //                     $new_orvc_car_exterior[$key11]['car_exterior'][$k]['vacm_id'] = $v['vacm_id'];
        //                     $new_orvc_car_exterior[$key11]['car_exterior'][$k]['vacm_unusual_name'] = $v['vacm_unusual_name'];
        //                     $new_image = [];
        //                     foreach ($v['image'] as $kk => $vv) {
        //                         $pic_url = substr($vv, 0,5);
        //                         if ($pic_url == 'https') {
        //                             $url_len = strlen(config('apisystem.server_name_https').'/');
        //                             $pic_url_sto = substr($vv,$url_len);
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         if ($pic_url == 'http:') {
        //                             $url_len = strlen(config('apisystem.server_name_https'));
        //                             $pic_url_sto = substr($vv,$url_len);
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         if ($pic_url == 'stora') {
        //                             $pic_url_sto = $vv;
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         $destinationFilejia = substr($destinationFile,0,-20);
        //                         // 判断文件夹是否存在，不存在创建文件夹
        //                         if (!file_exists($destinationFilejia)) {
        //                             mkdir($destinationFilejia, 0775, true);
        //                             chmod($destinationFilejia, 0775);
        //                         }
        //                         if (file_exists($pic_url_sto)) {
        //                             copy($pic_url_sto, $destinationFile);
        //                         }
        //                         if (file_exists($destinationFile)) {
        //                             deleteImage([$pic_url_sto]);
        //                         }
        //                         $new_image[] = config('apisystem.server_name_https').'/'.$destinationFile;
        //                     }
        //                     $new_orvc_car_exterior[$key11]['car_exterior'][$k]['image'] = $new_image;
        //                     $new_orvc_car_exterior[$key11]['car_exterior'][$k]['remark'] = $v['remark'];
        //                 }
        //             } else {
        //                 $new_orvc_car_exterior[$key11]['car_exterior'] = [];
        //             }
        //             if (!empty($value11['car_lacquer'])) {
        //                 foreach ($value11['car_lacquer'] as $k1 => $v1) {
        //                     $new_orvc_car_exterior[$key11]['car_lacquer'][$k1]['vacm_id'] = $v1['vacm_id'];
        //                     $new_orvc_car_exterior[$key11]['car_lacquer'][$k1]['vacm_unusual_name'] = $v1['vacm_unusual_name'];
        //                     $new_image = [];
        //                     foreach ($v1['image'] as $kk1 => $vv1) {
        //                         $pic_url = substr($vv1, 0,5);
        //                         if ($pic_url == 'https') {
        //                             $url_len = strlen(config('apisystem.server_name_https').'/');
        //                             $pic_url_sto = substr($vv1,$url_len);
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         if ($pic_url == 'http:') {
        //                             $url_len = strlen(config('apisystem.server_name_https'));
        //                             $pic_url_sto = substr($vv1,$url_len);
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         if ($pic_url == 'stora') {
        //                             $pic_url_sto = $vv1;
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         $destinationFilejia = substr($destinationFile,0,-20);
        //                         // 判断文件夹是否存在，不存在创建文件夹
        //                         if (!file_exists($destinationFilejia)) {
        //                             mkdir($destinationFilejia, 0775, true);
        //                             chmod($destinationFilejia, 0775);
        //                         }
        //                         if (file_exists($pic_url_sto)) {
        //                             copy($pic_url_sto, $destinationFile);
        //                         }
        //                         if (file_exists($destinationFile)) {
        //                             deleteImage([$pic_url_sto]);
        //                         }
        //                         $new_image[] = config('apisystem.server_name_https').'/'.$destinationFile;
        //                     }
        //                     $new_orvc_car_exterior[$key11]['car_lacquer'][$k1]['image'] = $new_image;
        //                     $new_orvc_car_exterior[$key11]['car_lacquer'][$k1]['remark'] = $v1['remark'];

        //                 }
        //             } else {
        //                 $new_orvc_car_exterior[$key11]['car_lacquer'] = [];
        //             }
        //             if (!empty($value11['car_dismounting'])) {
        //                 foreach ($value11['car_dismounting'] as $k2 => $v2) {
        //                     $new_orvc_car_exterior[$key11]['car_dismounting'][$k2]['vacm_id'] = $v2['vacm_id'];
        //                     $new_orvc_car_exterior[$key11]['car_dismounting'][$k2]['vacm_unusual_name'] = $v2['vacm_unusual_name'];
        //                     $new_image = [];
        //                     foreach ($v2['image'] as $kk2 => $vv2) {
        //                         $pic_url = substr($vv2, 0,5);
        //                         if ($pic_url == 'https') {
        //                             $url_len = strlen(config('apisystem.server_name_https').'/');
        //                             $pic_url_sto = substr($vv2,$url_len);
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         if ($pic_url == 'http:') {
        //                             $url_len = strlen(config('apisystem.server_name_https'));
        //                             $pic_url_sto = substr($vv2,$url_len);
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         if ($pic_url == 'stora') {
        //                             $pic_url_sto = $vv2;
        //                             $destinationFile = substr($pic_url_sto,0,8).'free'.substr($pic_url_sto,8);
        //                         }
        //                         $destinationFilejia = substr($destinationFile,0,-20);
        //                         // 判断文件夹是否存在，不存在创建文件夹
        //                         if (!file_exists($destinationFilejia)) {
        //                             mkdir($destinationFilejia, 0775, true);
        //                             chmod($destinationFilejia, 0775);
        //                         }
        //                         if (file_exists($pic_url_sto)) {
        //                             copy($pic_url_sto, $destinationFile);
        //                         }
        //                         if (file_exists($destinationFile)) {
        //                             deleteImage([$pic_url_sto]);
        //                         }
        //                         $new_image[] = config('apisystem.server_name_https').'/'.$destinationFile;
        //                     }
        //                     $new_orvc_car_exterior[$key11]['car_dismounting'][$k2]['image'] = $new_image;
        //                     $new_orvc_car_exterior[$key11]['car_dismounting'][$k2]['remark'] = $v2['remark'];
        //                 }
        //             } else {
        //                 $new_orvc_car_exterior[$key11]['car_dismounting'] = [];
        //             }
        //         }
                
        //         $updata_data['orvc_car_interior'] = json_encode($new_data, true);
        //         $updata_data['orvc_car_exterior'] = json_encode($new_orvc_car_exterior, true);
        //         $updata_data['orvc_update_time'] = date('Y-m-d H:i:s');
        //         $updata_data_res =  DB::table('wash_order_validate_car')
        //             ->where('orvc_id', $value->orvc_id)
        //             ->update($updata_data);
        //         $add_data['old_id'] = $value->orvc_id;
        //         $add_data['old_id_name'] = 'orvc_id';
        //         $add_data['old_pic_url'] = $value->orvc_car_interior.$value->orvc_car_exterior;
        //         $add_data['new_pic_url'] = $updata_data['orvc_car_interior'].$updata_data['orvc_car_exterior'];
        //         $add_data['ord_order_number'] = $value->ord_order_number;
        //         $add_res = DB::table('pic_data')->insertGetId($add_data);
        //         unset($updata_data);
        //         unset($new_data);
        //         unset($new_orvc_car_exterior);
        //         dump($value->orvc_id);
        //         dump($updata_data_res);
        //     }
        // }
    }

    public function edit() {
        $pri = '{"pc":"2,3,4,5,7,8,23,24,25,26,27,28,29,30,31,32,33,34,35,36,38,39,40,41,42,43,44,45,46,53,55,56,57,58,59,60,61,62,63,64,66,67,68,69,70,71,72,73,74,75,76,78,79,80,81,82,83,84,85,86,87,105,106,107,108,109,110,111,118,119,120,121,122,123,124,125,128,129,130,131,134,136,137,138,139,140,153,155,156,159,160,162,163,164,165,166,167,168,169,172,173,174,175,176,177,178,179,180,181,183,184,185,186,188,189,190,191,192,194,195,196,198,202,203,204,205,222,224,225,226,227,228,229,231,232,237,238,239,241,242,243,244,246,247,248,249,250,251,252,253,254,256,257,258,259,260,261,262,263,264,266,267,268,269,270,271,272,273,274,275,317,318,319,320,321,322,334,335,336,337,338,342,345,346,348,349,351,354,355,357,358,359,360,361,362,363,364,365,369,370,371,372,373,382,383,384,385,388,391,392,393,394,395,396,397,398,399,400,403,404,407,408,409,410,411,414,415,419,420,421,447,448,449,452,453,458,459,460,462,463,465,466,470,471,483,484,485,486,488,489,490,491,492,494,495,496,497,498,499,500,512,514,515,517,518,519,520,521,527,528,529,530,531,532,533,534,535,537,540,541,542,546,548,551,552,553,554,555,556,557,558,564,565,566,567,572,573,574,575,576,579,585,587,588,589,590,591,592,593,594,595,597,598,599,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,616,617,618,619,620,621,622,623,624,625,626,627,628,629,634,635,636,637,638,639,654,655,657,658,659,660,661,662,663,665,666,668,670,672,674,675,676,677,678,679,680,681,682,683,684,685,686,687,688,689,690,691,692,693,694,695,697,698,699,700,701,702,703,704,705,706,707,709,712,713,715,718,720,721,722,723,724,725,726,727,728,729,730,731,732,733,734,736,737,738,739,740,742,743,744,746,747,748,749,750,751,752,754,755,756,757,758,759,760,761,762,764,765,766,767,768,769,771,772,773,774,775,776,777,778,779,780,783,784,785,786,787,788,789,790,791,793,795,796,797,798,800,801,802,803,813,814,815,818,819,820,822,823,824,825,826,827,828,830,831,832,833,834,835,836,837,838,839","applet":"9,10,11,17,20,21,22,23,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,53,54,55,56,57,59,60,61,62,63,64,65,66,67,68,69,70,71,77,78,79,80,81"}';
        $pri = json_decode($pri, true);
        // dump($pri['pc']);
        $pc = explode(',', $pri['pc']);
        foreach ($pc as $key => $value) {
            $updata_data['pri_shop_version'] = '1,2,3,4';
            $res = DB::table('privileges')
                ->where('pri_id', $value)
                ->update($updata_data);
            die;
        }
    }


    public function editCom($request) {
        $find_bucl = DB::table('business_client')
            ->where('bucl_shop_id', 32)
            ->where('bucl_arrears', '!=', '')
            ->get()->toArray();
        // // dump($find_bucl);
        // // die;
        foreach ($find_bucl as $key => $value) {
            $buac_id = DB::table('business_account')
                ->where('buac_bucl_id', $value->bucl_id)
                ->value('buac_id');
            // if (empty($buac_id)) {
            //     $add_data['buac_shop_id'] = $value->bucl_shop_id;
            //     $add_data['buac_cid'] = 1;
            //     $add_data['buac_name'] = $value->bucl_user_name;
            //     $add_data['buac_phone'] = $value->bucl_user_phone;
            //     $add_data['buac_create_time'] = $value->bucl_create_time;
            //     $add_data['buac_create_adm_id'] = $value->bucl_create_id;
            //     $add_data['buac_del'] = 1;
            //     $add_data['buac_bucl_id'] = $value->bucl_id;
            //     $buac_id = DB::table('business_account')->insertGetId($add_data);
            // }
            $updata_data = DB::table('business_account')
                ->where('buac_id', $buac_id)
                ->update(['buac_arrears'=>$value->bucl_arrears]);
        }
        // $find_order = DB::table('order')
        //     ->leftJoin('order_client', 'orcl_ord_id', '=', 'ord_id')
        //     ->where('ord_shop_id', 32)
        //     ->where('ord_type', 2)
        //     ->select('orcl_client_id', 'orcl_name', 'orcl_phone', 'orcl_business_id')
        //     ->groupBy('orcl_client_id')
        //     ->get()->toArray();
        // foreach ($find_order as $key => $value) {
        //     $updata_data['buac_id'] = $value->orcl_client_id;
        //     $updata_res = DB::table('business_account')
        //         ->where('buac_phone',$value->orcl_phone)
        //         ->where('buac_name',$value->orcl_name)
        //         ->where('buac_bucl_id',$value->orcl_business_id)
        //         ->update($updata_data);
        // }


    }

    public function editAdminSet($request) {
        $find_admin_set = DB::table('admin_set')
            ->leftJoin('admin', 'adms_adm_id', '=', 'adm_id')
            ->where('adms_shop_id', '')
            ->select('adms_adm_id', 'adms_shop_id', 'adm_shop_id', 'adms_id')
            ->get()->toArray();
        dump($find_admin_set);
        die;
        foreach ($find_admin_set as $key => $value) {
            if ($value->adms_shop_id != $value->adm_shop_id) {
                $updata_data = DB::table('admin_set')->where('adms_id', $value->adms_id)->update(['adms_shop_id'=>$value->adm_shop_id]);
            }
        }
    }

    public function editlead($request) {
        $find_cominfo = DB::table('completion_info')
            ->leftJoin('work_order', 'coin_wor_id', '=', 'wor_id')
            ->where('coin_type', 3)
            ->where('coin_create_time', '>', '2022-08-30 00:00:00')
            ->select('wor_id', 'wor_service_adm_id', 'coin_adm_id')
            ->get()->toArray();
        $new_data = [];
        foreach ($find_cominfo as $key => $value) {
            if ($value->wor_service_adm_id != $value->coin_adm_id) {
                $new_data[] = $value;
            }
        }
        dump($new_data);die;
    }

    public function editRole() {
        $find_role = DB::table('role')
            ->leftJoin('shop', 'rol_shop_id', '=', 'shop_id')
            ->get()->toArray();
        $role['pc'] = '2,587,589,590,591,592,593,594,595,663,668,691,692,695,707,588,634,635,636,637,638,639,666,693,696,640,641,642,643,644,645,646,647,683,69,70,71,72,73,74,75,76,344,577,578,579,581,156,159,160,194,196,237,398,399,400,403,404,459,460,465,470,409,410,411,498,499,355,654,655,672,53,60,61,62,63,64,66,67,68,687,688,107,108,109,110,111,684,685,686,689,690,697,698,699,701,702,703,704,705,706,29,3,4,5,7,8,198,484,557,23,24,25,26,27,28,30,31,32,33,34,181,665,694,35,36,38,39,40,41,512,42,43,44,45,46,213,610,611,612,613,614,620,621,622,623,624,625,626,627,628,629,709,710,615,616,617,618,619,604,605,606,607,608,609,78,79,80,81,82,83,84,85,86,87,346,347,348,349,350,351,354,364,365,391,527,708,345,718,495,719,720,726,727,721,722,723,724,725,715,729,730,731,732,733,734,739,162,163,238,239,241,251,518,521,737,738,736';
        $applet_role = DB::table('privileges_technician_applet')
            ->whereRaw("FIND_IN_SET('2', pri_default)")
            ->get()->toArray();

        $app_role = '';
        if($applet_role){
            foreach ($applet_role as $app_r_key => $app_r_value){
                $app_role_arr[] = $app_r_value->pri_id;
            }
            $app_role = implode(',',$app_role_arr);
        }

        $zptz_applet_role = DB::table('privileges_technician_applet')
            ->whereRaw("FIND_IN_SET('4', pri_default)")
            ->get()->toArray();
        $zptz_app_role = '';
        if($zptz_applet_role){
            foreach ($zptz_applet_role as $app_r_key => $app_r_value){
                $zptz_app_role_arr[] = $app_r_value->pri_id;
            }
            $zptz_app_role = implode(',',$zptz_app_role_arr);
        }
        
        foreach ($find_role as $key => $value) {
            if ($value->rol_name == '总管理' && $value->shop_source_identify != '5') {
                $updata_data['rol_privilege_multiple'] = '{"pc":"'.$role['pc'].'","applet":"'.$app_role.'"}';
                $updata_data['rol_update_time'] = date('Y-m-d H:i:s');
                $updata_res = DB::table('role')->where('rol_id', $value->rol_id)->update($updata_data);
            } elseif ($value->rol_name == '总管理' && $value->shop_source_identify == '5') {
                $updata_data['rol_privilege_multiple'] = '{"pc":"","applet":"'.$zptz_app_role.'"}';
                $updata_data['rol_update_time'] = date('Y-m-d H:i:s');
                $updata_res = DB::table('role')->where('rol_id', $value->rol_id)->update($updata_data);
            }
        }
    }

    public function receiveSubmit($request){
        $find_work_data = DB::table('work_order')
            ->where('wor_shop_id', '!=', 2)
            ->where('wor_service_state', 1)
            ->where('wor_delete', 1)
            ->where(function ($query) use ($request) { //备注
                if (!empty($request['id'])) {
                    $query->where('wor_id', $request['id']);
                }
            })
            ->select('wor_id')
            ->get()->toArray();
        $find_work_data = json_decode(json_encode($find_work_data,true),true);
        foreach ($find_work_data as $key => $value) {
            $find_work = DB::table('work_order as wor')
                ->leftJoin('order as o', 'wor.wor_order_id', '=', 'o.ord_id')
                ->leftJoin('admin as a', 'a.adm_id', '=', 'wor.wor_service_adm_id')
                ->leftJoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->where('wor_id', $value['wor_id'])
                ->select('wor_number', 'wor_state', 'wor_delete', 'wor_pass', 'wor_appoint_time', 'wor_order_number', 'wor_remark', 'ord_create_time', 'wor_service_adm_id', 'adm_name', 'adm_phone', 'wocl_province', 'wocl_city', 'wocl_county', 'wocl_address', 'wor_order_id', 'wor_province', 'wor_city', 'wor_county', 'wor_address', 'wor_service_state', 'wor_work_type')
                ->first();
            if (empty($find_work)) {
                echo '当前工单已经锁定，无法提交！';
            }
            if ($find_work->wor_delete != 1) {
                echo '当前工单已经锁定，无法提交！';
            }
            if ($find_work->wor_pass == 4) {
                echo '当前工单已经锁定，无法提交！';
            }
            if ($find_work->wor_service_state != 1) {
                echo '当前工单不是待接单状态，无法接单！';
            }
            $find_wogo_data = DB::table('work_good as wogo')
                ->leftJoin('service_project as sp', 'sp.sepr_id', '=', 'wogo.wogo_goo_id')
                ->where('wogo_wor_id', $value['wor_id'])
                ->where('wogo_goo_type', 2)
                ->select('wogo_goo_id', 'sepr_name', 'sepr_check_car', 'sepr_id', 'wogo_goo_type')
                ->get()->toArray();
            $find_sepr = 2;//服务项目不需要验车
            $sepr_name = '';
            if ($find_wogo_data) {
                foreach ($find_wogo_data as $key => $value1) {
                    $sepr_name = $sepr_name.','.$value1->sepr_name;
                }
                foreach ($find_wogo_data as $key => $value2) {
                    if ($value2->sepr_check_car == 1) {
                        $find_sepr = 1;
                        break;
                    }
                }
            }
            if ($find_work->wor_work_type == 2) {//智配的工单都需要验车
                $find_sepr = 1;
                $wocl_edit_data['wocl_check_car_state'] = 2;
                $wocl_edit_data['wocl_update_time'] = date('Y-m-d H:i:s');
                $wocl_edit_res = DB::table('work_client')
                    ->where('wocl_wor_id', $value['wor_id'])
                    ->update($wocl_edit_data);
            }
            // 判断是否有预约时间，有预约时间状态改为预约状态
            if ($find_work->wor_appoint_time != '0000-00-00 00:00:00') {
                if ($find_sepr == 1) {//服务项目需要验车
                    $wor_edit_data['wor_service_state'] = 3; //服务状态：1待接单2已接单3预约4出发5抵达6完成待审核
                    $wor_edit_data['wor_state'] = 5; //3待接单/已派单 5.已接单/待验车 6.出发/已出发  7.抵达/抵达 8.待审核/完成待审核
                } else {
                    $wor_edit_data['wor_service_state'] = 5; //服务状态：1待接单2已接单3预约4施工中5抵达6完成待审核
                    $wor_edit_data['wor_state'] = 7; //3待接单/已派单 4.未出发/已接单 5.预约/已预约 6.施工中 7.抵达/抵达 8.待审核/完成待审核
                    $wocl_edit_data['wocl_check_car_state'] = 5;//验车状态
                    $wocl_edit_data['wocl_update_time'] = date('Y-m-d H:i:s');
                    $wocl_edit_res = DB::table('work_client')
                        ->where('wocl_wor_id', $value['wor_id'])
                        ->update($wocl_edit_data);
                }
            } else {
                echo '当前工单没有预约时间，请联系管理人员！';
                // 更改工单表的工单状态
                $wor_edit_data['wor_service_state'] = 2; //服务状态：1待接单2已接单/待验车3预约4已验车/待施工 （出发）5抵达6完成待审核
                $wor_edit_data['wor_state'] = 4; //3待接单/已派单 4.待验车/已接单 5.预约/已预约 6.出发/已出发  7.抵达/抵达 8.待审核/完成待审核
            }
            $wor_edit_data['wor_update_time'] = date('Y-m-d H:i:s');
            $wor_edit_res = DB::table('work_order')->where('wor_id', $value['wor_id'])->update($wor_edit_data);
        }
        echo '成功';
    }

    public function editimg() {
        $find_shop_data = DB::table('shop')
            ->select('shop_image', 'shop_id', 'shop_banner_img')
            ->get()->toArray();
        foreach ($find_shop_data as $key => $value) {
            $shop_image = substr($value->shop_image, 0, 4);
            $shop_banner_img = substr($value->shop_banner_img, 0, 4);

            if ($shop_image != 'http' && !empty($value->shop_image)) {
                $updata_data['shop_image'] = config('apisystem.server_name_https').'/' . $value->shop_image;
            }
            if ($shop_banner_img != 'http' && !empty($value->shop_banner_img)) {
                $updata_data['shop_banner_img'] = config('apisystem.server_name_https').'/' . $value->shop_banner_img;
            }
            $updata_data['shop_update_time'] = date('Y-m-d H:i:s');

            $update_res = DB::table('shop')->where('shop_id', $value->shop_id)->update($updata_data);
        }

        $find_sepr = DB::table('service_project')
            ->select('sepr_img', 'sepr_id')
            ->get()->toArray();
        foreach ($find_sepr as $key => $value) {
            $sepr_img = substr($value->sepr_img, 0, 4);
            if ($sepr_img != 'http' && !empty($value->sepr_img)) {
                $sepr_data['sepr_img'] = config('apisystem.server_name_https').'/' . $value->sepr_img;
            }
            $sepr_data['sepr_update_time'] = date('Y-m-d H:i:s');

            $update_res = DB::table('service_project')->where('sepr_id', $value->sepr_id)->update($sepr_data);
        }
        // $find_ord_work = DB::table('order_works')
        //     ->select('orwo_data', 'orwo_cover', 'orwo_id')
        //     ->get()->toArray();
        // foreach ($find_ord_work as $key => $value) {
        //     $orwo_data = json_decode($value->orwo_data, true);
        //     $new_orwo_data = [];
        //     foreach ($orwo_data as $key1 => $value1) {
        //         $img = substr($value1, 0, 4);
        //         if ($img != 'http' && !empty($value1)) {
        //             $new_orwo_data[] = config('apisystem.server_name_https').'/' . $value1;
        //         }
        //     }
        //     $update_orwo['orwo_data'] = json_encode($new_orwo_data, true);
        //     $update_res = DB::table('order_works')->where('orwo_id', $value->orwo_id)->update($update_orwo);
        // }

        // $find_pro = DB::table('wash_production_manage')
        //     ->select('prma_image', 'prma_id')
        //     ->get()->toArray();
        // foreach ($find_pro as $key => $value) {
        //     $prma_image = substr($value->prma_image, 0, 4);
        //     if ($prma_image != 'http' && !empty($value->prma_image)) {
        //         $prma_data['prma_image'] = config('apisystem.server_name_https').'/' . $value->prma_image;
        //     }
        //     $prma_data['prma_update_time'] = date('Y-m-d H:i:s');
        //     $update_res = DB::table('wash_production_manage')->where('prma_id', $value->prma_id)->update($prma_data);
        // }


        // $wash_production_content = DB::table('wash_production_content')
        //     ->select('prco_content', 'prco_id', 'prco_path')
        //     ->get()->toArray();
        // foreach ($wash_production_content as $key => $value) {
        //     $prco_content = json_decode($value->prco_content, true);
        //     if (!empty($prco_content)) {
        //         foreach ($prco_content as $key1 => $value1) {
        //             if (!empty($value1['image'])) {
        //                 $new_orwo_data['content'] = $value1['content'];
        //                 foreach ($value1['image'] as $key2 => $value2) {
        //                     $img = substr($value2, 0, 4);
        //                     if ($img != 'http' && !empty($value2)) {
        //                         $new_orwo_data['image'][] = config('apisystem.server_name_https').'/' . $value2;
        //                     }
        //                 }
        //                 $new_orwo_data['nothing1'] = isset($value1['nothing1']) ? $value1['nothing1']:'';
        //                 $new_prco_content['prco_content'] = json_encode($new_orwo_data, true);
        //             }
        //         }
        //     }
        //     $prco_path = substr($value->prco_path, 0, 4);
        //     if ($prco_path != 'http' && !empty($value->prco_path)) {
        //         $new_prco_content['prco_path'] = config('apisystem.server_name_https').'/' . $value->prco_path;
        //     }
        //     if (!empty($new_prco_content)) {
        //         $update_res = DB::table('wash_production_content')->where('prco_id', $value->prco_id)->update($new_prco_content);
        //     }
        // }
        echo 'success';
    }

    // 微信消息发送
    private function weixinPush()
    {
        // 半径门店appid=wx7c45128ab7710f54 AppSecret： a92d64dd5fcf2d72cd12df9aeb9c7a5a
        $url = 'https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=wx7c45128ab7710f54&secret=a92d64dd5fcf2d72cd12df9aeb9c7a5a'; //生产环境
        $output = file_get_contents($url);; //运行curl
        $obj = json_decode($output, true);
        if (!empty($obj['access_token'])) {
            $url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" . $obj['access_token'];
            $poss['template_id'] = "7fWiVa1jng6mXhHJyc_2pJxM4jl373AbsJUkQYsp9Rg";//微信消息模板ID
            $first['value'] = '客户跟进模板消息';
            $keyword1['value'] = '客户昵称';//客户昵称
            $keyword2['value'] = '客户手机';//客户手机
            $keyword3['value'] = date('Y-m-d H:i:s');//操作时间
            $remark['value'] = '详细内容';
            $data['first'] = $first;
            $data['keyword1'] = $keyword1;
            $data['keyword2'] = $keyword2;
            $data['keyword3'] = $keyword3;
            $data['remark'] = $remark;
            $poss['data'] = $data;
            $poss['touser'] = 'o309D6NcOlA2DGtzKgmPPIw4WdpE';//OPENID
            // $poss['url'] = 'https://xm.bluearp.com/';//查看详情链接
            $poss = json_encode($poss);
            $res = $this->https_post($url, $poss);
            dump($res);die;
        }
    }

    function https_post($url, $data)
    {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($curl);
        curl_close($curl);
        return $output;
    }

    // 将数据中的数据表及字段查询出来，并导出markdown语法格式
    private function databaseFieldComment()
    {
        // echo 333;die;
        /*$find_table = DB::select("SELECT t.TABLE_NAME as '表名',t.TABLE_COMMENT as '表注释',c.COLUMN_NAME as '字段名',c.COLUMN_TYPE as '数据类型',
        CASE c.IS_NULLABLE WHEN 'YES' THEN 'YES' ELSE 'NO' END AS 'NULL',
        c.column_key as 索引,
        CASE IFNULL(COLUMN_DEFAULT,'Null')
                WHEN '' THEN '空字符串'
                WHEN 'Null' THEN 'NULL'
                ELSE COLUMN_DEFAULT END  AS 默认值,
        c.COLUMN_COMMENT as 字段说明
        FROM information_schema.TABLES t,INFORMATION_SCHEMA.Columns c
        WHERE c.TABLE_NAME=t.TABLE_NAME AND t.`TABLE_SCHEMA`='wash_store'");*/
        // $find_table = DB::select("SELECT t.TABLE_NAME as '表名',t.TABLE_COMMENT as '表注释',c.COLUMN_NAME as '字段名',c.COLUMN_TYPE as '数据类型',
        // CASE c.IS_NULLABLE WHEN 'YES' THEN 'YES' ELSE 'NO' END AS 'NULL',
        // c.column_key as 索引,
        // c.COLUMN_DEFAULT as '默认值',
        // c.COLUMN_COMMENT as 字段说明
        // FROM information_schema.TABLES t,INFORMATION_SCHEMA.Columns c 
        // WHERE c.TABLE_NAME=t.TABLE_NAME AND t.`TABLE_SCHEMA`='mktest_bluearp_c'");
        // /*
        //         $find_table = DB::select("SELECT t.TABLE_NAME,t.TABLE_COMMENT,c.COLUMN_NAME,c.COLUMN_TYPE,
        // CASE c.IS_NULLABLE WHEN 'YES' THEN 'YES' ELSE 'NO' END as 'IS_NULLABLE',
        // c.column_key,
        // CASE IFNULL(COLUMN_DEFAULT,'Null')
        //         WHEN '' THEN '空字符串'
        //         WHEN 'Null' THEN 'NULL'
        //         ELSE COLUMN_DEFAULT END as 'COLUMN_DEFAULT',
        // c.COLUMN_COMMENT
        // FROM information_schema.TABLES t,INFORMATION_SCHEMA.Columns c
        // WHERE c.TABLE_NAME=t.TABLE_NAME AND t.`TABLE_SCHEMA`='gt_bluearp_com'");

        //     */
        // $contents = '';
        // $field_string = '|字段 | 类型 | NULL | 索引 | 默认 | 注释 |'."\r\n".
        // '|---|---|---|---|---|---| '."\r\n";
        // $table_name = '';
        // foreach ($find_table as $key => $value) {
        //     if ($value->表名 == $table_name) {
        //         $contents .= '| '.$value->字段名.' | '.$value->数据类型.' | '.$value->NULL.' | '.$value->索引.' | '.$value->默认值.' | '.$value->字段说明.' |'."\r\n";
        //     } else {
        //         $table_name = $value->表名;
        //         $table_mark = "\r\n\r\n".'### '.$value->表注释.' '.$value->表名."\r\n\r\n";
        //         $contents .= $table_mark.$field_string.'| '.$value->字段名.' | '.$value->数据类型.' | '.$value->NULL.' | '.$value->索引.' | '.$value->默认值.' | '.$value->字段说明.' |'."\r\n";
        //     }
        // }
        // // 将字符串写入到文件中
        // $list = file_put_contents("test.txt", $contents);
        // dump($contents);
        // die;
    }

    // 请求分账回退
    private function returnorders($request)
    {
        $url = 'https://api.mch.weixin.qq.com/v3/ecommerce/profitsharing/returnorders';
        $post = [
            'sub_mchid' => '1627713870',//分账出资的电商平台二级商户
            // 'order_id' => $transaction_id,//微信分账单号，微信支付系统返回的唯一标识
            'out_order_no' => 'YY202211096945200007CMK',//原发起分账请求时使用的商户系统内部的分账单号。微信分账单号与商户分账单号二选一填写。
            'out_return_no' => 'TH202211096945200007CMK',//此回退单号是商户在自己后台生成的一个新的回退单号，在商户后台唯一。
            'return_mchid' => '1619735999', //回退商户号只能填写原分账请求中接收分账的商户号。
            'amount' => 300,//回退金额
            'description' => '分账回退'
        ];
        $return_data = WashPayservice::_Postresponse($url, $post);
        $data = json_decode($return_data, true);
        dump($return_data);
        dump($data);
    }

    // 支付分账解冻测试
    private function subAccount($request)
    {
        // 查询商户余额
        // $url = 'https://api.mch.weixin.qq.com/v3/merchant/fund/balance/account_type';
        // 查询二级商户账户实时余额API
        // $mchid = '1627713870';//蓝城天津商户号
        $mchid = '1629529198';//厦门商户号
        $url = 'https://api.mch.weixin.qq.com/v3/ecommerce/fund/balance/'.$mchid.'?account_type=BASIC';
        $body = '';
        $return_data = WashPayservice::_Getresponse($url, $body);
        $data = json_decode($return_data, true);
        dump($return_data);
        dump($data);

        /*
            查询分账结果API
            {"order_id":"30000406482022110938680027933","out_order_no":"YY202211095907200004CMK","sub_mchid":"1627713870","transaction_id":"4200001617202211095212061380"}
        */
        // $url = 'https://api.mch.weixin.qq.com/v3/ecommerce/profitsharing/orders?sub_mchid=1627713870&transaction_id=4200001605202211097290135843&out_order_no=YY202211096945200007CMK';
        // $return_data = WashPayservice::_Getresponse($url, '');
        // $data = json_decode($return_data, true);
        // dump($return_data);
        // dump($data);
        // die;
    }
    
    public function editEndtime(Request $request)
    {
        $shop_id = $request['shop_id'];
        $wotp_data = DB::table('wash_work_technician_part')
            ->where('wotp_shop_id', $shop_id)
            ->select('wotp_wor_id','wotp_service_end_time')
            ->orderBy('wotp_id', 'desc')
            ->get()->toArray();
        if ($wotp_data) {
            foreach ($wotp_data as $key => $value) {
                if (!empty($value->wotp_service_end_time)) {
                    $wotp_data1 = DB::table('wash_work_technician_part')
                        ->where('wotp_wor_id', $value->wotp_wor_id)
                        ->where('wotp_service_end_time', '!=', '')
                        ->select('wotp_id')
                        ->get()->toArray();
                    if ($wotp_data1) {
                        $wotp_data2 = DB::table('wash_work_technician_part')
                            ->where('wotp_wor_id', $value->wotp_wor_id)
                            ->select('wotp_id')
                            ->get()->toArray();
                        foreach ($wotp_data2 as $key1 => $value1) {
                            $updata_data['wotp_service_end_time'] = $value->wotp_service_end_time;
                            $wotp_data_res = DB::table('wash_work_technician_part')
                                ->where('wotp_id', $value1->wotp_id)
                                ->update($updata_data);
                            unset($updata_data);
                        }
                    }
                }
            }
        }
        echo '更新成功';
    }


    // 仓位商品跟仓库商品对不上的
    // 仓库商品表中有的商品，在仓位商品表中没有的，查询出
    public function freightGoodsDiff(Request $request)
    {
        $ware_id = [282];
        $shop_id = 2;
        ignore_user_abort(true);
        set_time_limit(0);
        // 查询仓库商品数据
        $ware_id = DB::table('warehouse_goods')
            ->where('wago_class', 1)
            ->where('wago_id', 81)
            ->whereIn('wago_ware_id', $ware_id)
            ->get()->toArray();
        $diff_data = [];
        foreach ($ware_id as $kk => $vv) {
            // 查询仓库对应的仓位商品数据
            $wafr_data = DB::table('warehouse_freight_goods')
                ->where('wafg_ware_id', $vv->wago_ware_id)
                ->where('wafg_wago_id', $vv->wago_id)
                ->where('wafg_class', 1)
                ->get()->toArray();
                
            if (empty($wafr_data)) {
                // 仓位商品表中没有仓库对应的商品
                $diff_data[] = $vv->wago_id;
                $find_wafr_id = DB::table('warehouse_freight')
                    ->where('wafr_ware_id', $vv->wago_ware_id)
                    ->where('wafr_shop_id', $shop_id)
                    ->first();
                $updata_data['wafg_wafr_id'] = $find_wafr_id->wafr_id; //
                $updata_data['wafg_wago_id'] = $vv->wago_id; //
                $updata_data['wafg_ware_id'] = $vv->wago_ware_id; //
                $updata_data['wafg_class'] = $vv->wago_class; //
                $updata_data['wafg_goo_id'] = $vv->wago_goo_id; //
                $updata_data['wafg_stock_number'] = $vv->wago_stock_number; //
                // 仓位商品表中新增商品数据
                $res = DB::table('warehouse_freight_goods')->insert($updata_data);
                unset($updata_data);
            }
            unset($wafr_data);
        }
        echo 'success';
        dump($diff_data);
    }

    // 将读取到的Excel表格数据，添加到数据库
    public function other(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        // 导入商品数据
        $data = DB::table('excel_data_cache')->where('exdc_type', 1)->get();
        $data = json_decode($data, true);
        // dump($data);die;
        $data_info = [];
        $num = 0;
        $i = 0;
        foreach ($data as $key => $value) {
            // if ($key <= 400) {
            //     continue;
            // }
            $exdc_data = json_decode($value['exdc_data'], true);
            $data_info[] = $exdc_data;
        }
        // dump($data_info);die;
        // $this->excelGoods($request->all(), $data_info); //导入系统商品
        // $this->systemImportGoods($request->all(), $data_info); //库存商品成本单价和系统编码导入
        // $this->addStock($request->all(), $data_info); //库存商品成本单价和系统编码导入
        // 查询要导入的库存商品数据在当前门店商品列表中没有添加的商品
        $find_goo_data = DB::table('goods_hangzhou')
            ->get()->toArray();
        // 传入门店账号登录的token，后面生成盘库单使用
        try {
            $api_token = Crypt::decrypt($request['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);
        // dump($user_info);
        // die;
        // dump($find_goo_data);die;
        // 将没有添加的商品添加到门店,如果没有数据可以不用运行
        // foreach ($find_goo_data as $key => $value) { //导入第一步
        //     // echo 111;
        //     $add_datas_res1 = $this->addgoods((array)$value, $user_info);
        //     dump($add_datas_res1);
        // }
        $this->addOldStock($request->all(), $data_info); //新增盘库单，导入第二步
    }

    // 新增盘库单，将要导入的商品库存新增盘库单，通过盘库单把期初商品库存数据添加到门店
    public function addOldStock($submit_data, $data)
    {
        DB::beginTransaction();
        $shop_id = 2; //门店id
        $ware_id = 282; //总仓
        $waon_class = 1; //货物仓

        $dates = $this->now_time;

        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);

        $stocktake_number = 0;  //良品盘点数量
        $goo_data = [];
        $num = 0;
        foreach ($data as $key => $value) {
            // dump($value);
            // exit;
            $num += intval($value['wago_stock_number']);
            if (empty($value['goo_goods_encode']) && empty($value['goo_name'])) {
                continue;
            }
            // $add_datas['goo_cate_id'] = 1499; //？？？品类id是否是蓄电池，默认都是蓄电池商品，待定
            // 查询品类id
            $add_datas['goo_cate_id'] = DB::table('category')
                ->where(function ($query) use ($shop_id) {
                    $query->where('cate_shop_id', 0)
                        ->orwhere('cate_shop_id', $shop_id);
                })
                ->where('cate_delete', 1)
                ->where('cate_name', $value['goo_cate_name'])
                ->value('cate_id');

            // 判断是否有商品id，没有商品id的需要新增商品
            if (empty($value['wago_goo_id'])) {
                if (!empty($value['goo_goods_encode'])) {
                    // 查询商品检索编码是否有对应的系统编码
                    $goo_id = DB::table('goods')
                        ->where(function ($query) use ($shop_id) {
                            $query->where('goo_shop_id', 0)
                                ->orwhere('goo_shop_id', $shop_id);
                        })
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->where(function ($query) use ($value) {
                            if ($value['goo_goods_encode']) {
                                $query->where('goo_goods_encode', $value['goo_goods_encode']);
                            }
                        })
                        // ->where(function ($query) use ($add_datas) {
                        //     if (isset($add_datas['goo_bra_id'])) {
                        //         $query->where('goo_bra_id', $add_datas['goo_bra_id']);
                        //     }
                        //     if (isset($add_datas['goo_brse_id'])) {
                        //         $query->where('goo_brse_id', $add_datas['goo_brse_id']);
                        //     }
                        // })
                        ->where('goo_cate_id', $add_datas['goo_cate_id'])
                        ->value('goo_id');
                } else {
                    // 查询品牌、系列对应的id
                    $bra_data = DB::table('brand')
                        ->where(function ($query) use ($shop_id) {
                            $query->where('bra_shop_id', 0)
                                ->orwhere('bra_shop_id', $shop_id);
                        })
                        ->where('bra_name', $value['goo_bra_name'])
                        ->where('bra_delete', 1)
                        ->select('bra_id', 'bra_name')
                        ->first();
                    if ($bra_data) {
                        $add_datas['goo_bra_id'] = $bra_data->bra_id;
                        $brse_data = DB::table('brand_serie')
                            ->where(function ($query) use ($shop_id) {
                                $query->where('brse_shop_id', 0)
                                    ->orwhere('brse_shop_id', $shop_id);
                            })
                            ->where('brse_name', $value['goo_cate_name'])
                            ->where('brse_cate_id', $add_datas['goo_cate_id'])
                            ->where('brse_delete', 1)
                            ->where('brse_bra_id', $bra_data->bra_id)
                            ->select('brse_id', 'brse_name')
                            ->first();
                        if ($brse_data) {
                            $add_datas['goo_brse_id'] = $brse_data->brse_id;
                        }
                    }
                    // dump($add_datas);
                    // die;
                    // 查询商品检索编码是否有对应的系统编码
                    $goo_id = DB::table('goods')
                        ->where(function ($query) use ($shop_id) {
                            $query->where('goo_shop_id', 0)
                                ->orwhere('goo_shop_id', $shop_id);
                        })
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->where(function ($query) use ($value) {
                            if ($value['goo_goods_encode']) {
                                $query->where('goo_goods_encode', $value['goo_goods_encode']);
                            } else {
                                $query->where('goo_name', $value['goo_name']);
                            }
                        })
                        ->where(function ($query) use ($add_datas) {
                            if (isset($add_datas['goo_bra_id'])) {
                                $query->where('goo_bra_id', $add_datas['goo_bra_id']);
                            }
                            if (isset($add_datas['goo_brse_id'])) {
                                $query->where('goo_brse_id', $add_datas['goo_brse_id']);
                            }
                        })
                        ->where('goo_cate_id', $add_datas['goo_cate_id'])
                        ->value('goo_id');
                }
                if (empty($goo_id)) {
                    $goo_data[] = $value;

                    $add_datas['goo_bra_name'] = $value['goo_bra_name'];//品牌名称
                    $add_datas['goo_goods_code'] = $value['goo_brse_name'];//系列名称
                    $add_datas['goo_cate_name'] = $value['goo_cate_name'];//品类名称
                    $add_datas['goo_name'] = $value['goo_name'];
                    $add_datas['goo_goods_encode'] = $value['goo_goods_encode'];
                    $add_datas['goo_price'] = $value['goo_price'];
                    $add_datas_res = DB::table('goods_hangzhou')->insert($add_datas);
                    continue;
                }
                unset($add_datas);
            } else {
                $goo_id = $value['wago_goo_id'];
            }
            

            $add['ense_goo_id'] = $goo_id;
            $add['ense_new_amount'] = $value['goo_goods_encode'];
            $add['ense_new_price'] = $value['goo_price'];
            $add_data_res = DB::table('enters_sells_saves_price_total')->insert($add);
            unset($add);
            // 查询仓库商品数量
            $find_wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $ware_id)
                ->where('wago_class', 1)
                ->where('wago_goo_id', $goo_id)
                ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
                ->first();

            if (empty($find_wago_data)) {
                $add_data['wago_ware_id'] = $ware_id;
                $add_data['wago_class'] = $waon_class;
                $add_data['wago_goo_id'] = $goo_id;
                $wago_id = DB::table('warehouse_goods')->insert($add_data);
                unset($add_data);
                $find_wago_data = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_class', 1)
                    ->where('wago_goo_id', $goo_id)
                    ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
                    ->first();
            }

            // 新增盘库商品表
            $stgo_data[$key]['stgo_goo_id'] = $goo_id; //商品id
            $stgo_data[$key]['stgo_stock_number'] = $find_wago_data->wago_stock_number;
            $stgo_data[$key]['stgo_lock_number'] = $find_wago_data->wago_lock_quantity;
            $stgo_data[$key]['stgo_priority_stock_number'] = $find_wago_data->wago_priority_stock_number;
            $stgo_data[$key]['stgo_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity;
            $stgo_data[$key]['stgo_unchecked_stock_number'] = $find_wago_data->wago_unchecked_stock_number;
            $stgo_data[$key]['stgo_stocktake_number'] = intval($value['wago_stock_number']); //良品库存数量
            $stgo_data[$key]['stgo_update_time'] = $dates; //更新时间
            // if (empty($value['wago_stock_number'])) {
            //     dump($value);
            // }
            if (!empty($value['wago_stock_number'])) {
                $stocktake_number = $stocktake_number + intval($value['wago_stock_number']);
            }
        }
        // dump($num);
        // dump($stocktake_number);
        // exit;
        // 新增盘库单数据
        $stoc_data['stoc_cid'] = $user_info->adm_cid;
        $stoc_data['stoc_shop_id'] = $user_info->adm_shop_id;
        $stoc_data['stoc_superior_shop_id'] = $user_info->adm_shop_id;
        $stoc_data['stoc_adm_id'] = $user_info->adm_id;
        $stoc_data['stoc_storage_number'] = 'P' . truncateFill($user_info->adm_shop_id, 2) . date('mdHis') . truncateFill($user_info->adm_id, 2) . rand(10000, 99999); //盘库单号
        $stoc_data['stoc_type'] = 1; //类型：1盘盈2盘亏3盘平
        $stoc_data['stoc_differ_number'] = $stocktake_number; //损益数量
        $stoc_data['stoc_state'] = 2; //状态1保存/待提交2提交/待审核3通过4驳回
        $stoc_data['stoc_ware_id'] = $ware_id; //仓库id
        $stoc_data['stoc_make_time'] = $dates;
        $stoc_data['stoc_waon_class'] = $waon_class; //仓库类别
        $stoc_data['stoc_manner'] = 2; //盘库方式：1部分盘2通盘
        $stoc_data['stoc_create_time'] = $dates; //创建时间
        // 新增盘库单
        $stoc_res =  DB::table('stocktake')->insertGetId($stoc_data);
        foreach ($stgo_data as $key => $value) {
            $stgo_data[$key]['stgo_stoc_id'] = $stoc_res;
        }
        $stgo_res =  DB::table('stocktake_goods')->insert($stgo_data);
        unset($stgo_data);
        unset($stoc_data);
        echo $num;
        dump($goo_data);
        DB::commit();
    }

    // 新增商品
    public function addgoods($request, $user_info)
    {
        // 判断品类是否存在，不存在新增品类
        if (empty($request['goo_cate_id'])) {
            // 1. 判断品类名称是否存在
            $request['goo_cate_id'] = DB::table('category')
                ->where('cate_delete', 1)
                ->where(function ($query) use ($user_info) {
                    $query->where('cate_shop_id', 0)
                        ->orwhere('cate_shop_id', $user_info->adm_shop_id);
                })
                ->where('cate_name', $request['goo_cate_name'])
                ->value('cate_id');
            if (empty($request['goo_cate_id'])) {
                $request['cate_parent_id'] = 0;
                // 2 新增一个品类数据
                $cate_add_data = [
                    'cate_cid' => $user_info->adm_cid,
                    'cate_shop_id' => $user_info->adm_shop_id,
                    'cate_superior_shop_id' => $shop_id,
                    'cate_name' => $request['goo_cate_name'],
                    'cate_parent_id' => $request['cate_parent_id'],
                ];

                // 判断隶属上级
                if ($request['cate_parent_id']) {
                    // 查找隶属品类是第几级
                    $cate_rank = DB::table('category')
                        ->where('cate_id', $request['cate_parent_id'])
                        ->select('cate_rank')
                        ->first();

                    if ($cate_rank->cate_rank >= 3) {
                        return response()->json(["code"=>500, 'msg'=>'error', 'data'=>'所属品类已超过三级']);
                    }
                    $cate_add_data['cate_rank'] = $cate_rank->cate_rank + 1;
                } else {
                    $cate_add_data['cate_rank'] = 1;
                }

                // 新增品类
                $cate_res =  DB::table('category')->insertGetid($cate_add_data);

                $caco['caco_shop_id'] = $user_info->adm_shop_id;
                $caco['caco_cate_id'] = $cate_res;
                $caco_res = DB::table('category_correlation')->insert($caco);
            }
        }
        // 判断品牌是否存在，不存在新增品牌
        if (empty($request['goo_bra_id'])) {
            // 查询是否已经新增，已经新增的查询出id
            $request['goo_bra_id'] = DB::table('brand')
                ->where(function ($query) use ($user_info) {
                    $query->where('bra_shop_id', 0)
                        ->orwhere('bra_shop_id', $user_info->adm_shop_id);
                })
                ->where('bra_name', $request['goo_bra_name'])
                ->where('bra_delete', 1)
                ->value('bra_id');
            if (empty($request['goo_bra_id'])) {
                $bra_data['bra_cid'] = $user_info->adm_cid;
                $bra_data['bra_superior_shop_id'] = $user_info->adm_shop_id;
                $bra_data['bra_shop_id'] = $user_info->adm_shop_id;
                $bra_data['bra_name'] = $request['goo_bra_name'];
                $request['goo_bra_id'] =  DB::table('brand')->insertGetId($bra_data);

                $brco['brco_shop_id'] = $user_info->adm_shop_id;
                $brco['brco_bra_id'] = $request['goo_bra_id'];
                $brco['brco_sequence'] = 0;
                $brco_res = DB::table('brand_correlation')->insert($brco);
                unset($bra_data);
                unset($brco);
            }
        }
        // 判断系列是否存在，不存在新增系列
        if (empty($request['goo_brse_id'])) {
            $request['goo_brse_id'] = DB::table('brand_serie')
                ->where(function ($query) use ($user_info) {
                    $query->where('brse_shop_id', 0)
                        ->orwhere('brse_shop_id', $user_info->adm_shop_id);
                })
                ->where('brse_name', $request['goo_goods_code'])
                ->where('brse_cate_id', $request['goo_cate_id'])
                ->where('brse_delete', 1)
                ->where('brse_bra_id', $request['goo_bra_id'])
                ->value('brse_id');
            if (empty($request['goo_brse_id'])) {
                // 2 新增一个品牌系列数据
                $brse_add_data = [
                    'brse_cid' => $user_info->adm_cid,
                    'brse_shop_id' => $user_info->adm_shop_id,
                    'brse_superior_shop_id' => $user_info->adm_shop_id,
                    'brse_bra_id' => $request['goo_bra_id'],
                    'brse_name' => $request['goo_goods_code'],
                    'brse_cate_id' => $request['goo_cate_id'], //一级品类id
                    'brse_second_cate_id' => '0', //二级品类id
                ];

                // 新增品牌系列
                $request['goo_brse_id'] =  DB::table('brand_serie')->insertGetid($brse_add_data);

                // $brsc['brsc_sequence'] = $request['brsc_sequence'] ?? '';
                $brsc['brsc_update_time'] = date('Y-m-d H:i:s');
                $brsc['brsc_shop_id'] = $user_info->adm_shop_id;
                $brsc['brsc_brse_id'] = $request['goo_brse_id'];
                $brsc_res = DB::table('brand_serie_correlation')->insert($brsc);
                unset($brse_add_data);
                unset($brsc);
            }
        }

        // 判断检索编码是否存在
        if (!empty($request['goo_goods_encode'])) {
            $find_goo = DB::table('goods')
                ->where('goo_delete', 1)
                ->where(function ($query) use ($user_info) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                })
                ->where('goo_goods_encode', $request['goo_goods_encode'])
                ->select('goo_id')
                ->first();
            if ($find_goo) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'检索编码已存在'];
            }
        } else {
            // 1. 判断商品名称是否存在
            $find_goo = DB::table('goods')
                ->where('goo_delete', 1)
                ->where(function ($query) use ($user_info) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                })
                ->where('goo_cate_id', $request['goo_cate_id'])
                ->where('goo_bra_id', $request['goo_bra_id'])
                ->where('goo_brse_id', $request['goo_brse_id'])
                ->where('goo_name', $request['goo_name'])
                ->select('goo_id')
                ->first();
            if ($find_goo) {
                dump($request);
                return ['code'=>500, 'msg'=>'error', 'data'=>'商品名称已存在'];
            }
        }

        // 判断商品编号是否存在
        if (!empty($request['goo_goods_code'])) {
            $find_goo = DB::table('goods')
                ->where('goo_delete', 1)
                ->where(function ($query) use ($user_info) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                })
                ->where('goo_goods_code', $request['goo_goods_code'])
                ->select('goo_id')
                ->first();
            if ($find_goo) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'商品编号已存在'];
            }
        }

        // 2 新增一个商品数据
        $goo_add_data['goo_cid'] = $user_info->adm_cid;
        // 有检索编码，并且第一个字母是X开头的
        // if (!empty($request['goo_goods_encode']) && ($request['goo_goods_encode'][0] == 'X' || $request['goo_goods_encode'][0] == 'x')) {
        //     $goo_add_data['goo_shop_id'] = 0;
        // } else {
        //     $goo_add_data['goo_shop_id'] = $user_info->adm_shop_id;
        // }
        $goo_add_data['goo_superior_shop_id'] = $user_info->adm_shop_id;
        $goo_add_data['goo_shop_id'] = $user_info->adm_shop_id;
        $goo_add_data['goo_name'] = $request['goo_name'];   //商品名称
        $goo_add_data['goo_type'] = 1;   //1正常商品2赠品商品3活动商品4旧货商品
        $goo_add_data['goo_goods_encode'] = $request['goo_goods_encode'] ? $request['goo_goods_encode'] : '';   //检索编码
        $goo_add_data['goo_cate_id'] = $request['goo_cate_id']; //所属品类id
        $goo_add_data['goo_cate_name'] = $request['goo_cate_name']; //品类名称
        $goo_add_data['goo_price'] = $request['goo_price'] * 100;   //商品零售价格
        $goo_add_data['goo_system_code'] = str_pad($user_info->adm_cid, '4', '0', STR_PAD_RIGHT) . str_pad($user_info->adm_shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
        // 判断是否选择商品品牌
        if ($request['goo_bra_id']) {
            $goo_add_data['goo_bra_id'] = $request['goo_bra_id'];
            $goo_add_data['goo_bra_name'] = $request['goo_bra_name'];
        }
        // 判断是否选择品牌系列
        if ($request['goo_brse_id']) {
            if (empty($request['goo_bra_id'])) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'请选择所属品牌'];
            }
            $goo_add_data['goo_brse_id'] = $request['goo_brse_id'];
        }
        // 新增商品
        $goo_id =  DB::table('goods')->insertGetId($goo_add_data);


        // 添加旧货商品
        $goo_add_data['goo_fid'] = $goo_id;
        $goo_add_data['goo_type'] = 4; //1正常商品2赠品商品3活动商品4旧货商品
        $goo_add_data['goo_system_code'] = str_pad($user_info->adm_cid, '4', '0', STR_PAD_RIGHT) . str_pad($user_info->adm_shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
        // 新增商品
        $goo_id_three =  DB::table('goods')->insertGetId($goo_add_data);

        // 4.商品所属品类数量更改
        $find_caco_id = DB::table('category_correlation')
            ->where('caco_cate_id', $request['goo_cate_id'])
            ->where('caco_shop_id', $user_info->adm_shop_id)
            ->value('caco_id');
        if ($find_caco_id) {
            $res_cate = DB::table('category_correlation')
                ->where('caco_cate_id', $request['goo_cate_id'])
                ->where('caco_shop_id', $user_info->adm_shop_id)
                ->increment('caco_goods_number', 2);
        } else {
            // 没有数据，新增数据
            $add_caco_data['caco_shop_id'] = $user_info->adm_shop_id;
            $add_caco_data['caco_cate_id'] = $request['goo_cate_id'];
            $add_caco_data['caco_goods_number'] = 2;
            $add_caco_data['caco_update_time'] = date('Y-m-d H:i:s');
            $res_cate = DB::table('category_correlation')->insert($add_caco_data);
        }

        // 5.商品所属品牌数量更改
        if ($request['goo_bra_id']) {
            // 查询关联表是否有数据
            $find_brco_id = DB::table('brand_correlation')
                ->where('brco_bra_id', $request['goo_bra_id'])
                ->where('brco_shop_id', $user_info->adm_shop_id)
                ->value('brco_id');
            if ($find_brco_id) {
                // 有数据增加数量
                $res_brand = DB::table('brand_correlation')
                    ->where('brco_bra_id', $request['goo_bra_id'])
                    ->where('brco_shop_id', $user_info->adm_shop_id)
                    ->increment('brco_goods_number', 2);
            } else {
                // 没有数据，新增数据
                $add_brco_data['brco_shop_id'] = $user_info->adm_shop_id;
                $add_brco_data['brco_bra_id'] = $request['goo_bra_id'];
                $add_brco_data['brco_goods_number'] = 2;
                $add_brco_data['brco_update_time'] = date('Y-m-d H:i:s');
                $res_brand = DB::table('brand_correlation')->insert($add_brco_data);
            }
        } else {
            $res_brand = true;
        }

        // 商品所属品牌系列数量更改
        if ($request['goo_brse_id']) {
            // 查询系列关联表是否有数据
            $find_brsc_id = DB::table('brand_serie_correlation')
                ->where('brsc_brse_id', $request['goo_brse_id'])
                ->where('brsc_shop_id', $user_info->adm_shop_id)
                ->value('brsc_id');
            if ($find_brsc_id) {
                // 有数据增加数量
                $res_brand_serie = DB::table('brand_serie_correlation')
                    ->where('brsc_brse_id', $request['goo_brse_id'])
                    ->where('brsc_shop_id', $user_info->adm_shop_id)
                    ->increment('brsc_goods_number', 2);
            } else {
                // 没有数据，新增数据
                $add_brsc_data['brsc_shop_id'] = $user_info->adm_shop_id;
                $add_brsc_data['brsc_brse_id'] = $request['goo_brse_id'];
                $add_brsc_data['brsc_goods_number'] = 2;
                $add_brsc_data['brsc_update_time'] = date('Y-m-d H:i:s');
                $res_brand_serie = DB::table('brand_serie_correlation')->insert($add_brsc_data);
            }
        } else {
            $res_brand_serie = true;
        }
        echo '商品添加成功';
    }

    // 查询品类重复名称
    public function selectCategory()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;
        // $shop_id = ['1','2','26','30','31','32','33','42','43','45','46','47','48','59','60','115','138'];
        // 1,2,26,30,31,42,43,45,47,48,59,115,138

        $find_category = DB::table('category')
            ->where(function ($query) use ($adm_cid) {
                $query->where('cate_cid', 0)
                    ->orwhere('cate_cid', $adm_cid);
            })
            ->where(function ($query) use ($shop_id) {
                $query->where('cate_shop_id', 0)
                    ->orwhere('cate_shop_id', $shop_id);
            })
            ->where('cate_class', 2)
            ->where('cate_delete', 1)
            ->groupBy('cate_name')
            ->having(DB::raw('count(cate_name)'), '>', 1)
            ->select('cate_id', 'cate_cid', 'cate_shop_id', 'cate_name')
            ->get()->toArray();
        dump($find_category);
        exit;
        foreach ($find_category as $key => $value) {
            // 查询商品表里是否有该品类,没有直接删除品类数据
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $value->cate_cid)
                ->where('goo_shop_id', $value->cate_shop_id)
                ->where('goo_delete', 1)
                ->where('goo_cate_id', $value->cate_id)
                ->select('goo_id', 'goo_cate_id', 'goo_cate_name', 'goo_name', 'goo_goods_encode')
                ->first();
            if (empty($find_goo_id)) {
                $del_edit_data['cate_delete'] = 2;
                // $del_edit_res = DB::table('category')
                //     ->where('cate_id', $value->cate_id)
                //     ->update($del_edit_data);
            } else {
                $find_cate_id = DB::table('category')
                    ->where('cate_cid', 0)
                    ->where('cate_shop_id', 0)
                    ->where('cate_name', $value->cate_name)
                    ->value('cate_id');
                // 修改商品表的品类id
                $edit_goo_data['goo_cate_id'] = $find_cate_id;
                $edit_goo_res = DB::table('goods')
                    ->where('goo_cid', $value->cate_cid)
                    ->where('goo_shop_id', $value->cate_shop_id)
                    ->where('goo_delete', 1)
                    ->where('goo_cate_id', $value->cate_id)
                    ->update($edit_goo_data);
                unset($edit_goo_data);
                unset($edit_goo_res);
                // 修改品牌系列的品类id
                $edit_brse_data['brse_cate_id'] = $find_cate_id;
                $edit_brse_res = DB::table('brand_serie')
                    ->where('brse_cid', $value->cate_cid)
                    ->where('brse_shop_id', $value->cate_shop_id)
                    ->where('brse_cate_id', $value->cate_id)
                    ->update($edit_brse_data);
                unset($edit_brse_data);
                unset($edit_brse_res);
            }
        }
        echo 'string1';
    }

    // 查询品牌重复名称
    public function selectBrand()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;
        // $shop_id = ['1','2','26','30','31','32','33','35','36','37','38','39','40','41','42','43','45','46','47','48','52','53','56','59','60','115','138'];
        // $shop_id = ['1','2','26','30','31','32','33','42','43','45','46','47','48','59','60','115','138'];

        $find_brand = DB::table('brand')
            ->where(function ($query) use ($adm_cid) {
                $query->where('bra_cid', 0)
                    ->orwhere('bra_cid', $adm_cid);
            })
            ->where(function ($query) use ($shop_id) {
                $query->where('bra_shop_id', 0)
                    ->orwhere('bra_shop_id', $shop_id);
            })
            ->where('bra_class', 2)
            ->where('bra_delete', 1)
            ->groupBy('bra_name')
            ->having(DB::raw('count(bra_name)'), '>', 1)
            ->select('bra_id', 'bra_cid', 'bra_shop_id', 'bra_name', 'bra_sequence', 'bra_goods_number')
            ->get()->toArray();
        dump($find_brand);
        exit;
        foreach ($find_brand as $key => $value) {
            // 查询商品表里是否有该品牌,没有直接删除品牌数据
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $value->bra_cid)
                ->where('goo_shop_id', $value->bra_shop_id)
                ->where('goo_delete', 1)
                ->where('goo_bra_id', $value->bra_id)
                ->select('goo_id', 'goo_bra_id', 'goo_bra_name', 'goo_name', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (empty($find_goo_id)) {
                $del_edit_data['bra_delete'] = 2;
                // $del_edit_res = DB::table('brand')
                //     ->where('bra_id', $value->bra_id)
                //     ->update($del_edit_data);
            } else {
                $find_bra_id = DB::table('brand')
                    ->where('bra_cid', 0)
                    ->where('bra_shop_id', 0)
                    ->where('bra_name', $value->bra_name)
                    ->value('bra_id');
                $edit_goo_data['goo_bra_id'] = $find_bra_id;
                $edit_goo_res = DB::table('goods')
                    ->where('goo_cid', $value->bra_cid)
                    ->where('goo_shop_id', $value->bra_shop_id)
                    ->where('goo_delete', 1)
                    ->where('goo_bra_id', $value->bra_id)
                    ->update($edit_goo_data);
                unset($edit_goo_data);
                unset($edit_goo_res);
                // 修改品牌系列的品牌id
                $edit_brse_data['brse_bra_id'] = $find_bra_id;
                $edit_brse_res = DB::table('brand_serie')
                    ->where('brse_cid', $value->bra_cid)
                    ->where('brse_shop_id', $value->bra_shop_id)
                    ->where('brse_bra_id', $value->bra_id)
                    ->update($edit_brse_data);
                unset($edit_brse_data);
                unset($edit_brse_res);
            }
        }
        echo 'string2';
    }

    // 查询品牌系列重复名称
    public function selectBrandSerie()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;
        // $shop_id = ['1','2','26','30','31','32','33','42','43','45','46','47','48','59','60','115','138'];

        $find_brand_serie = DB::table('brand_serie')
            ->where(function ($query) use ($adm_cid) {
                $query->where('brse_cid', 0)
                    ->orwhere('brse_cid', $adm_cid);
            })
            ->where(function ($query) use ($shop_id) {
                $query->where('brse_shop_id', 0)
                    ->orwhere('brse_shop_id', $shop_id);
            })
            ->where('brse_class', 2)
            ->where('brse_delete', 1)
            ->groupBy('brse_name')
            ->having(DB::raw('count(brse_name)'), '>', 1)
            ->select('brse_id', 'brse_cid', 'brse_shop_id', 'brse_name')
            ->get()->toArray();
        dump($find_brand_serie);
        exit;
        foreach ($find_brand_serie as $key => $value) {
            // echo "string";
            // exit;
            // 查询商品表里是否有该品牌,没有直接删除品牌数据
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $value->brse_cid)
                ->where('goo_shop_id', $value->brse_shop_id)
                ->where('goo_delete', 1)
                ->where('goo_brse_id', $value->brse_id)
                ->select('goo_id', 'goo_brse_id', 'goo_name', 'goo_goods_encode')
                ->first();
            if (empty($find_goo_id)) {
                $del_edit_data['brse_delete'] = 2;
                // $del_edit_res = DB::table('brand_serie')
                //     ->where('brse_id', $value->brse_id)
                //     ->update($del_edit_data);
            } else {
                $find_brse_id = DB::table('brand_serie')
                    ->where('brse_cid', 0)
                    ->where('brse_shop_id', 0)
                    ->where('brse_name', $value->brse_name)
                    ->value('brse_id');
                $edit_goo_data['goo_brse_id'] = $find_brse_id;
                $edit_goo_res = DB::table('goods')
                    ->where('goo_cid', $value->brse_cid)
                    ->where('goo_shop_id', $value->brse_shop_id)
                    ->where('goo_delete', 1)
                    ->where('goo_brse_id', $value->brse_id)
                    ->update($edit_goo_data);
                unset($edit_goo_data);
                unset($edit_goo_res);
            }
        }
        echo 'string3';
    }

    // 查询仓库商品有重复商品id的数据
    public function repetitionWarehouseGoods()
    {
        $find_ware_data = DB::table('warehouse')
            // ->whereIn('ware_shop_id', [1,26])
            // ->where('ware_type', 1)
            ->select('ware_id', 'ware_name')
            ->get()->toArray();
        $wago_goo_data = [];
        $repetition_data = [];
        foreach ($find_ware_data as $key => $value) {
            $find_wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $value->ware_id)
                ->where('wago_class', 1)
                ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id')
                ->get()->toArray();
            foreach ($find_wago_data as $wago_key => $wago_value) {
                if (isset($wago_goo_data[$wago_value->wago_goo_id])) {
                    $wago_goo_data[$wago_value->wago_goo_id]++;
                    $temp_data['wago_class'] = 1;
                    $temp_data['wago_goo_id'] = $wago_value->wago_goo_id;
                    $temp_data['wago_goo_count'] = $wago_goo_data[$wago_value->wago_goo_id];
                    $temp_data['ware_id'] = $value->ware_id;
                    $temp_data['ware_name'] = $value->ware_name;
                    $repetition_data[] = $temp_data;
                    unset($temp_data);
                } else {
                    $wago_goo_data[$wago_value->wago_goo_id] = 1;
                }
            }
            unset($wago_goo_data);

            $find_wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $value->ware_id)
                ->where('wago_class', 3)
                ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id')
                ->get()->toArray();
            foreach ($find_wago_data as $wago_key => $wago_value) {
                if (isset($wago_goo_data[$wago_value->wago_goo_id])) {
                    $wago_goo_data[$wago_value->wago_goo_id]++;
                    $temp_data['wago_class'] = 3;
                    $temp_data['wago_goo_id'] = $wago_value->wago_goo_id;
                    $temp_data['wago_goo_count'] = $wago_goo_data[$wago_value->wago_goo_id];
                    $temp_data['ware_id'] = $value->ware_id;
                    $temp_data['ware_name'] = $value->ware_name;
                    $repetition_data[] = $temp_data;
                    unset($temp_data);
                } else {
                    $wago_goo_data[$wago_value->wago_goo_id] = 1;
                }
            }
            unset($wago_goo_data);
        }
        dump($repetition_data);
        die;
    }

    // 仓位商品表数量统计05
    // 仓位商品表的库存数据跟仓位表总库存数量统计比较
    public function freightGoodsKucun()
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = DB::table('warehouse')
            ->where('ware_type', 1)
            // ->where('ware_id', 276)
            ->select('ware_id', 'ware_type')
            // ->offset(0)
            // ->limit(1)
            ->get()->toArray();
        $ware_id = array_column($ware_id, null, 'ware_id');

        foreach ($ware_id as $kk => $vv) {
            $wafr_data = DB::table('warehouse_freight')
                ->where('wafr_ware_id', $vv->ware_id)
                ->where('wafr_delete', 1)
                ->select('wafr_id', 'wafr_name')
                ->get()->toArray();
            foreach ($wafr_data as $key => $value) {
                $find_wafg_data = DB::table('warehouse_freight_goods')
                    ->where('wafg_wafr_id', $value->wafr_id)
                    ->where('wafg_stock_number', '>', 0)
                    ->select('wafg_wafr_id', 'wafg_class', 'wafg_stock_number', 'wafg_lock_quantity', 'wafg_priority_stock_number', 'wafg_priority_lock_quantity', 'wafg_unchecked_stock_number')
                    ->get()->toArray();
                $wafg_stock_number = 0; //良品库存数量
                $wafg_lock_quantity = 0; //良品锁定数量
                $wafg_priority_stock_number = 0; //优先库存数量
                $wafg_priority_lock_quantity = 0; //优先锁定数量
                $wafg_unchecked_stock_number = 0; //待检测数量
                foreach ($find_wafg_data as $kkk => $vvv) {
                    $wafg_stock_number += $vvv->wafg_stock_number;
                    // $wafg_lock_quantity += $vvv->wafg_lock_quantity;
                    // $wafg_priority_stock_number += $vvv->wafg_priority_stock_number;
                    // $wafg_priority_lock_quantity += $vvv->wafg_priority_lock_quantity;
                    // $wafg_unchecked_stock_number += $vvv->wafg_unchecked_stock_number;
                }
                unset($find_wafg_data);
                dump($value->wafr_id . '-总量良品库存：' . $wafg_stock_number);
                // dump($value->wafr_id . '-总量良品锁定：' . $wafg_lock_quantity);
                // dump($value->wafr_id . '-总量优先库存：' . $wafg_priority_stock_number);
                // dump($value->wafr_id . '-总量优先锁定：' . $wafg_priority_lock_quantity);
                // dump($value->wafr_id . '-待检测：' . $wafg_unchecked_stock_number);
                $updata_data['wafr_all_stock'] = $wafg_stock_number; //良品总库存数量
                // $updata_data['wafr_lock_quantity'] = $wafg_lock_quantity; //良品锁定总数量
                // $updata_data['wafr_priority_all_stock'] = $wafg_priority_stock_number; //优先总库存
                // $updata_data['wafr_priority_lock_quantity'] = $wafg_priority_lock_quantity; //优先锁定数量
                // $updata_data['wafr_unchecked_all_stock'] = $wafg_unchecked_stock_number; //待检测总库存
                $updata_data['wafr_update_time'] = date('Y-m-d H:i:s');

                $res = DB::table('warehouse_freight')
                    ->where('wafr_id', $value->wafr_id)
                    ->update($updata_data);
                unset($updata_data);
            }
            unset($wafr_data);
        }
        echo 'success';
    }


    // 统计仓库总量与仓库+仓位数量不一致
    public function diffwarehouseFreight()
    {
        $shop_id = $this->shop_id;
        $find_ware = DB::table('warehouse')
            ->whereIn('ware_shop_id', $shop_id)
            ->where('ware_type', 1)
            // ->whereIn('ware_id', ['150', '151', '152', '153', '154', '155', '156'])
            ->select('ware_id', 'ware_name', 'ware_shop_id', 'ware_state')
            ->get()->toArray();
        $find_ware = array_column($find_ware, null, 'ware_id');
        $diff_data = [];
        $diff_lock_data = [];
        foreach ($find_ware as $key => $value) {
            $find_wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $value->ware_id)
                ->select('wago_id', 'wago_ware_id', 'wago_goo_id', 'wago_class', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number', 'wago_freight_stock_number', 'wago_freight_lock_quantity', 'wago_freight_priority_stock_number', 'wago_freight_priority_lock_quantity', 'wago_freight_unchecked_stock_number', 'wago_stock_amount', 'wago_lock_amount', 'wago_priority_stock_amount', 'wago_priority_lock_amount', 'wago_unchecked_stock_amount')
                ->get()->toArray();
            foreach ($find_wago_data as $wago_key => $wago_value) {
                // 良品库存
                $stock_amount = $wago_value->wago_freight_stock_number +  $wago_value->wago_stock_amount; //仓位+仓库的库存
                $stock_lock_amount = $wago_value->wago_freight_lock_quantity +  $wago_value->wago_lock_amount; //仓位+仓库的锁定
                // 优先库存
                $priority_amount = $wago_value->wago_freight_priority_stock_number +  $wago_value->wago_priority_stock_amount; //仓位+仓库的库存
                $priority_lock_amount = $wago_value->wago_freight_priority_lock_quantity +  $wago_value->wago_priority_lock_amount; //仓位+仓库的库存
                if ($wago_value->wago_stock_number != $stock_amount || $wago_value->wago_priority_stock_number != $priority_amount) {
                    // $temp_data = (array)$wago_value;
                    $temp_data['wago_id'] = $wago_value->wago_id;
                    $temp_data['wago_stock_number'] = $wago_value->wago_stock_number;
                    $temp_data['stock_amount'] = $stock_amount;
                    // $temp_data['wago_lock_quantity'] = $wago_value->wago_lock_quantity;
                    // $temp_data['stock_lock_amount'] = $stock_lock_amount;

                    $temp_data['wago_priority_stock_number'] = $wago_value->wago_priority_stock_number;
                    $temp_data['priority_amount'] = $priority_amount;
                    // $temp_data['wago_priority_lock_quantity'] = $wago_value->wago_priority_lock_quantity;
                    // $temp_data['priority_lock_amount'] = $priority_lock_amount;

                    $temp_data['goo_goods_encode'] = DB::table('goods')
                        ->where('goo_id', $wago_value->wago_goo_id)->value('goo_goods_encode');

                    $temp_data['ware_name'] = $find_ware[$wago_value->wago_ware_id]->ware_name;
                    $temp_data['ware_shop_id'] = $find_ware[$wago_value->wago_ware_id]->ware_shop_id;
                    $temp_data['ware_state'] = $find_ware[$wago_value->wago_ware_id]->ware_state;
                    $diff_data[] = $temp_data;
                    unset($temp_data);
                }

                if ($wago_value->wago_lock_quantity != $stock_lock_amount || $wago_value->wago_priority_lock_quantity != $priority_lock_amount) {
                    $temp_data['wago_id'] = $wago_value->wago_id;
                    // $temp_data['wago_stock_number'] = $wago_value->wago_stock_number;
                    // $temp_data['stock_amount'] = $stock_amount;
                    $temp_data['wago_lock_quantity'] = $wago_value->wago_lock_quantity;
                    $temp_data['stock_lock_amount'] = $stock_lock_amount;

                    // $temp_data['wago_priority_stock_number'] = $wago_value->wago_priority_stock_number;
                    // $temp_data['priority_amount'] = $priority_amount;
                    $temp_data['wago_priority_lock_quantity'] = $wago_value->wago_priority_lock_quantity;
                    $temp_data['priority_lock_amount'] = $priority_lock_amount;

                    $temp_data['goo_goods_encode'] = DB::table('goods')
                        ->where('goo_id', $wago_value->wago_goo_id)->value('goo_goods_encode');

                    $temp_data['ware_name'] = $find_ware[$wago_value->wago_ware_id]->ware_name;
                    $temp_data['ware_shop_id'] = $find_ware[$wago_value->wago_ware_id]->ware_shop_id;
                    $temp_data['ware_state'] = $find_ware[$wago_value->wago_ware_id]->ware_state;
                    $diff_lock_data[] = $temp_data;
                    unset($temp_data);
                }
            }
        }
        dump($diff_data);
        dump($diff_lock_data);
    }

    // 统计仓库库存数量和进销存库存数量不一致的数据
    public function selectWarehouseGoods(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;
        $search_data = $request->all();
        $list_data = DB::table('enters_sells_saves')
            ->where('ense_shop_id', $shop_id)
            ->where('ense_goo_warehouse', $request['sssg_ware_id'])
            ->where('ense_goo_waretype', $request['sssg_waon_class'])
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_name'])) {
                    $query->where('ense_goo_name', 'like', '%' . $search_data['goo_name'] . '%');
                }
            }) //商品名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_goods_encode'])) {
                    $query->where('ense_goo_number', 'like', '%' . $search_data['goo_goods_encode'] . '%');
                }
            }) //商品编码
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ense_time_start'])) {
                    $query->where('ense_time', '>=', $search_data['ense_time_start'] . " 00:00:00");
                }
            }) //起始时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ense_time_end'])) {
                    $query->where('ense_time', '<=', $search_data['ense_time_end'] . " 23:59:59");
                }
            }) //结束时间
            ->select('ense_goo_id')
            ->orderBy('ense_id', 'asc')
            ->groupBy('ense_goo_id')
            ->get()->toArray();
        $list_items = $list_data;
        $ids = array();

        foreach ($list_items as $k => $v) {
            foreach ($v as $kk => $vv) {
                $ids[] = $vv;
            }
        }
        $list = DB::table('enters_sells_saves')
            ->where('ense_shop_id', $shop_id)
            ->where('ense_goo_warehouse', $request['sssg_ware_id'])
            ->where('ense_goo_waretype', $request['sssg_waon_class'])
            ->whereIn('ense_goo_id', $ids)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_name'])) {
                    $query->where('ense_goo_name', 'like', '%' . $search_data['goo_name'] . '%');
                }
            }) //商品名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_goods_encode'])) {
                    $query->where('ense_goo_number', 'like', '%' . $search_data['goo_goods_encode'] . '%');
                }
            }) //商品编码
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ense_time_start'])) {
                    $query->where('ense_time', '>=', $search_data['ense_time_start'] . " 00:00:00");
                }
            }) //起始时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ense_time_end'])) {
                    $query->where('ense_time', '<=', $search_data['ense_time_end'] . " 23:59:59");
                }
            }) //结束时间
            ->select('ense_id', 'ense_goo_id', 'ense_goo_name', 'ense_goo_number', 'ense_goo_waretype', 'ense_goo_warehouse', 'ense_new_inventory', 'ense_end_inventory')
            ->orderBy('ense_id', 'asc')
            ->get()
            ->toArray();
        $dataayyar = array();
        if ($list) {
            // 查询仓库数据
            $warehouse_data = DB::table('warehouse')
                ->where('ware_id', $request['sssg_ware_id'])
                ->select('ware_id', 'ware_name')
                ->first();
            // 查询仓库类别数据
            $warehouse_class = DB::table('warehouse_class')
                ->where('wacl_cid', $adm_cid)
                ->where('wacl_superior_shop_id', $shop_id)
                ->where('wacl_class_numerical', $request['sssg_waon_class'])
                ->select('wacl_class_numerical', 'wacl_class_name')
                ->first();
            $warehouse_data = $warehouse_data->ware_id;
            $warehouse_class = $warehouse_class->wacl_class_numerical;
            $listarray = array();
            $list = json_decode(json_encode($list), true);
            foreach ($list as $k => $v) {
                if (isset($listarray[$v['ense_goo_id']])) {
                    $listarray[$v['ense_goo_id']]['ense_goo_waretype'] = $warehouse_class;
                    $listarray[$v['ense_goo_id']]['ense_goo_warehouse'] = $warehouse_data;
                    $listarray[$v['ense_goo_id']]['ense_end_inventory'] = $v['ense_end_inventory'];
                } else {
                    $v['ense_goo_waretype'] = $warehouse_class;
                    $v['ense_goo_warehouse'] = $warehouse_data;
                    $listarray[$v['ense_goo_id']] = $v;
                }
            }
            $i = "0";
            foreach ($listarray as $k => $v) {
                $dataayyar[$i] = $v;
                $i = $i + 1;
            }
        }

        $stocks_numbers = [];
        foreach ($dataayyar as $k1 => $v1) {
            // 根据仓库id,仓库类别,查询仓库商品表的数量
            $find_wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $v1['ense_goo_warehouse'])
                ->where('wago_class', $v1['ense_goo_waretype'])
                ->where('wago_goo_id', $v1['ense_goo_id'])
                ->select('wago_id', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
                ->first();
            if ($find_wago_data) {
                // 货物仓
                // $stock_amount = $find_wago_data->wago_stock_number + $find_wago_data->wago_lock_quantity;
                // 旧货仓
                $stock_amount = $find_wago_data->wago_stock_number + $find_wago_data->wago_lock_quantity + $find_wago_data->wago_priority_stock_number + $find_wago_data->wago_priority_lock_quantity + $find_wago_data->wago_unchecked_stock_number;
                // dump($v1['ense_end_inventory']);
                // dump($stock_amount);
                // if ($v1['ense_end_inventory'] != $stock_amount && $v1['ense_end_inventory'] >= 0) {
                if ($v1['ense_end_inventory'] != $stock_amount) {
                    // dump($find_wago_data->wago_id);
                    $stocks_numbers[$k1]['wago_id'] = $find_wago_data->wago_id;
                    $stocks_numbers[$k1]['ense_goo_number'] = $v1['ense_goo_number'];
                    $stocks_numbers[$k1]['ense_end_inventory'] = $v1['ense_end_inventory'];
                    $stocks_numbers[$k1]['stock_amount'] = $stock_amount;
                    // if ($find_wago_data->wago_lock_quantity == 0) {
                    if ($find_wago_data->wago_lock_quantity == 0 && $find_wago_data->wago_priority_lock_quantity == 0) {
                        // 货物仓
                        $edit_wago_data['wago_stock_number'] = $v1['ense_end_inventory']; //良品库存数量
                        // 旧货仓
                        // $edit_wago_data['wago_unchecked_stock_number'] = $v1['ense_end_inventory'] - $find_wago_data->wago_stock_number - $find_wago_data->wago_priority_stock_number; //待检测库存数量
                    } else {
                        // 货物仓
                        $edit_wago_data['wago_stock_number'] = $v1['ense_end_inventory'] - $find_wago_data->wago_lock_quantity; //良品库存数量
                        // 旧货仓
                        // $edit_wago_data['wago_unchecked_stock_number'] = $v1['ense_end_inventory'] - $find_wago_data->wago_stock_number - $find_wago_data->wago_lock_quantity - $find_wago_data->wago_priority_stock_number - $find_wago_data->wago_priority_lock_quantity; //待检测库存数量
                    }
                    // $edit_wago_res = DB::table('warehouse_goods')
                    //     ->where('wago_id', $find_wago_data->wago_id)
                    //     ->update($edit_wago_data);
                    // unset($edit_wago_data);
                    // unset($edit_wago_res);
                }
            }
        }
        dump($stocks_numbers);
        echo 'string';
        // foreach ($stocks_numbers as $key => $value) {
        //     $temp['wago_stock_number'] = $value['ense_end_inventory'];
        //     $temp['wago_id'] = $value['wago_id'];
        //     DB::table('warehouse_goods_kucun_test')->insert($temp);
        //     unset($temp);
        // }
    }

    // 统计库存数量
    public function kucunTongji(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $ware_id = DB::table('warehouse')
            ->select('ware_id', 'ware_type')
            ->get()->toArray();
        $ware_id = array_column($ware_id, null, 'ware_id');

        $wago_class = 1;
        foreach ($ware_id as $kk => $vv) {
            $wago_res = DB::table('warehouse_goods')
                ->where('wago_ware_id', $vv->ware_id)
                ->where('wago_class', $wago_class)
                ->select('wago_ware_id', 'wago_class', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number', 'wago_freight_stock_number', 'wago_freight_lock_quantity', 'wago_freight_priority_stock_number', 'wago_freight_priority_lock_quantity')
                ->get()->toArray();
            $wago_stock_number = 0; //良品库存数量
            $wago_lock_quantity = 0; //良品锁定数量
            $wago_priority_stock_number = 0; //优先库存数量
            $wago_priority_lock_quantity = 0; //优先锁定数量
            $wago_unchecked_stock_number = 0; //待检测数量
            $wago_freight_stock_number = 0; //仓位良品库存数量
            $wago_freight_lock_quantity = 0; //仓位良品锁定数量
            $wago_freight_priority_stock_number = 0; //仓位优先库存
            $wago_freight_priority_lock_quantity = 0; //仓位优先锁定数量
            foreach ($wago_res as $kkk => $vvv) {
                $wago_stock_number += $vvv->wago_stock_number;
                $wago_lock_quantity += $vvv->wago_lock_quantity;
                $wago_priority_stock_number += $vvv->wago_priority_stock_number;
                $wago_priority_lock_quantity += $vvv->wago_priority_lock_quantity;
                $wago_unchecked_stock_number += $vvv->wago_unchecked_stock_number;
                $wago_freight_stock_number += $vvv->wago_freight_stock_number;
                $wago_freight_lock_quantity += $vvv->wago_freight_lock_quantity;
                $wago_freight_priority_stock_number += $vvv->wago_freight_priority_stock_number;
                $wago_freight_priority_lock_quantity += $vvv->wago_freight_priority_lock_quantity;
            }
            dump($vv->ware_id . '-总量良品库存：' . $wago_stock_number);
            dump($vv->ware_id . '-总量良品锁定：' . $wago_lock_quantity);
            dump($vv->ware_id . '-总量优先库存：' . $wago_priority_stock_number);
            dump($vv->ware_id . '-总量优先锁定：' . $wago_priority_lock_quantity);
            dump($vv->ware_id . '-待检测：' . $wago_unchecked_stock_number);
            // dump($vv . '-仓位良品库存：' . $wago_freight_stock_number);
            // dump($vv . '-仓位良品锁定：' . $wago_freight_lock_quantity);
            // dump($vv . '-仓位优先库存：' . $wago_freight_priority_stock_number);
            // dump($vv . '-仓位优先锁定：' . $wago_freight_priority_lock_quantity);
            $updata_data['waon_stock_fine_amount'] = $wago_stock_number; //良品总库存数量
            $updata_data['waon_lock_fine_amount'] = $wago_lock_quantity; //良品锁定总数量
            $updata_data['waon_stock_priority_amount'] = $wago_priority_stock_number; //优先总库存
            $updata_data['waon_lock_priority_amount'] = $wago_priority_lock_quantity; //优先锁定数量
            $updata_data['waon_stock_unchecked_amount'] = $wago_unchecked_stock_number; //待检测总库存
            $waon_all_amount = $updata_data['waon_stock_fine_amount'] + $updata_data['waon_stock_priority_amount'] + $updata_data['waon_stock_unchecked_amount'];
            $updata_data['waon_all_amount'] = $waon_all_amount; //待检测总库存
            $updata_data['waon_update_time'] = date('Y-m-d H:i:s');
            $res = DB::table('warehouse_onhand')
                ->where('waon_ware_id', $vv->ware_id)
                ->where('waon_class', $wago_class)
                ->update($updata_data);
            unset($updata_data);
        }
    }

    // 导入Excel数据
    public function importExcelData(Request $request)
    {
        $path = public_path('img/库存商品数据.xls');
        if (is_file($path)) {
            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($path); //如果文件存在则直接载入
            $sheet = $spreadsheet->getActiveSheet(); //获取活动的工作sheet
            $highest_row = $sheet->getHighestRow(); // 取得总行数
            $n = 0;
            $exdc_data = [];
            $exdc_update_time = date('Y-m-d H:i:s');
            for ($row = 2; $row <= $highest_row; $row++) {
                $excel_data['ware_name'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue()); //仓库名称
                $excel_data['waon_class'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue()); //仓库类别
                $excel_data['goo_cate_name'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue()); //品类名称
                $excel_data['goo_bra_name'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue()); //品牌名称
                $excel_data['goo_brse_name'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue()); //系列
                $excel_data['goo_name'] = trim($sheet->getCellByColumnAndRow(6, $row)->getValue()); //商品名称
                $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(7, $row)->getValue()); //检索编码
                $excel_data['goo_price'] = trim($sheet->getCellByColumnAndRow(8, $row)->getValue()); //期初价格
                $excel_data['wago_stock_number'] = trim($sheet->getCellByColumnAndRow(9, $row)->getValue()); //良品库存
                $excel_data['wago_priority_stock_number'] = trim($sheet->getCellByColumnAndRow(10, $row)->getValue()); //优先库存
                $excel_data['wago_goo_id'] = trim($sheet->getCellByColumnAndRow(11, $row)->getValue()); //序列码
                // dump($excel_data);
                // die;

                $exdc_data[$n]['exdc_type'] = 1;
                $exdc_data[$n]['exdc_update_time'] = $exdc_update_time;
                $exdc_data[$n]['exdc_data'] = json_encode($excel_data);
                $n++;
                unset($excel_data);
            }
            // dump($exdc_data);
            // die;
            $res = DB::table('excel_data_cache')->insert($exdc_data);
        }
        echo 999;
        die;
    }

    // 导入Excel数据-会员及会员卡
    public function importExcelVipData(Request $request)
    {
        $shop_id = 156;
        $adm_shop_id = 156;
        $adm_cid = 1;
        $path = public_path('img/会员信息表发给蓝成云.xls');
        DB::beginTransaction();
        if (is_file($path)) {
            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($path); //如果文件存在则直接载入
            $sheet = $spreadsheet->getActiveSheet(); //获取活动的工作sheet
            $highest_row = $sheet->getHighestRow(); // 取得总行数
            $n = 0;
            $exdc_data = [];
            $exdc_update_time = date('Y-m-d H:i:s');
            for ($row = 4; $row <= $highest_row; $row++) {
                $excel_data[$n]['mem_car_num'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue()); //会员车牌号
                $excel_data[$n]['mem_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue()); //会员名称
                $excel_data[$n]['mem_phone'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue()); //会员手机号
                $excel_data[$n]['mem_vip_level'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue()); //会员等级
                $excel_data[$n]['vip_code'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue()); //卡面卡号
                $excel_data[$n]['mem_sex'] = trim($sheet->getCellByColumnAndRow(6, $row)->getValue()); //性别
                $excel_data[$n]['mem_birthday'] = trim($sheet->getCellByColumnAndRow(14, $row)->getValue()); //会员生日
                $excel_data[$n]['vip_card_time'] = trim($sheet->getCellByColumnAndRow(21, $row)->getValue()); //开卡时间
                
                // 1. 判断手机号是否存在
                $find_mem = DB::table('member')
                    ->where('mem_cid', $adm_cid)
                    ->where('mem_superior_shop_id', $shop_id)
                    ->where('mem_phone', $excel_data[$n]['mem_phone'])
                    ->first(['mem_id']);
                if ($find_mem) {
                    echo $excel_data[$n]['mem_phone'].'手机号已存在';
                    die;
                    // return response()->json(["code"=>500, 'msg'=>$excel_data[$n]['mem_phone'].'手机号已存在', 'data'=>$excel_data[$n]['mem_phone'].'手机号已存在']);
                }
                if ($excel_data[$n]['mem_car_num']) {
                    // 判断车牌号是否存在
                    $find_meca = DB::table('member_car')
                        ->where('meca_cid', $adm_cid)
                        ->where('meca_superior_shop_id', $shop_id)
                        ->where('meca_car_num', $excel_data[$n]['mem_car_num'])
                        ->first(['meca_id']);
                    if ($find_meca) {
                        DB::rollBack();
                        echo $excel_data[$n]['mem_car_num'].'车牌号已存在1';
                        die;
                    }
                }

                // 2 新增一个会员信息
                $mem_add_data['mem_cid'] = $adm_cid;
                $mem_add_data['mem_shop_id'] = $adm_shop_id;
                $mem_add_data['mem_superior_shop_id'] = $shop_id;
                $mem_add_data['mem_name'] = $excel_data[$n]['mem_name'];
                $mem_add_data['mem_create_name'] = '';
                $mem_add_data['mem_create_id'] = 0;
                if ($excel_data[$n]['mem_sex'] == '男') {
                    $mem_add_data['mem_sex'] = 1;
                } elseif ($excel_data[$n]['mem_sex'] == '女') {
                    $mem_add_data['mem_sex'] = 2;
                } else {
                    $mem_add_data['mem_sex'] = 3;
                }
                $mem_add_data['mem_phone'] = $excel_data[$n]['mem_phone'];
                $mem_add_data['mem_birthday'] = $excel_data[$n]['mem_birthday'] ? $excel_data[$n]['mem_birthday'] : '';
                $mem_add_data['mem_car_num'] = str_replace(' ', '', $excel_data[$n]['mem_car_num']);
                // $mem_add_data['mem_car_series'] = $request['mem_car_series'] ? $request['mem_car_series'] : '';
                // $mem_add_data['mem_car_model'] = $request['mem_car_model'] ? $request['mem_car_model'] : '';
                // $mem_add_data['mem_province'] = $request['mem_province'];
                // $mem_add_data['mem_city'] = $request['mem_city'];
                // $mem_add_data['mem_county'] = $request['mem_county'];
                // $mem_add_data['mem_address'] = $request['mem_address'];
                // $mem_add_data['mem_bership'] = $request['mem_bership'];
                // $mem_add_data['mem_source'] = $request['mem_source'] ? $request['mem_source'] : '';
                $mem_id =  DB::table('member')->insertGetId($mem_add_data);
                if (!$mem_id) {
                    DB::rollBack();
                    echo '失败';
                    die;
                }
                // // 3.新增一个车辆信息
                // if ($excel_data[$n]['mem_car_num']) {
                //     $meca_add_data['meca_cid'] = $adm_cid;
                //     $meca_add_data['meca_shop_id'] = $adm_shop_id;
                //     $meca_add_data['meca_superior_shop_id'] = $shop_id;
                //     $meca_add_data['meca_create_adm_id'] = 0;
                //     $meca_add_data['meca_mem_id'] = $mem_id;
                //     $meca_add_data['meca_car_num'] = $excel_data[$n]['mem_car_num'];
                //     $meca_add_data['meca_car_series'] = $request['mem_car_series'] ? $request['mem_car_series'] : '';
                //     $meca_add_data['meca_car_model'] = $request['mem_car_model'] ? $request['mem_car_model'] : '';
                //     $meca_res =  DB::table('member_car')->insert($meca_add_data);
                // } else {
                //     $meca_res = true;
                // }

                // 查询手机号是否存在
                $find_weixin_data = DB::table('weixin_user')
                    ->where('weus_phone', $excel_data[$n]['mem_phone'])
                    ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
                    ->first();
                if (empty($find_weixin_data)) {
                    // 不存在就新增用户
                    $data['weus_phone'] = $excel_data[$n]['mem_phone'];
                    $data['weus_openid'] = $mem_id;
                    $data['weus_nickmame'] = $excel_data[$n]['mem_name'];
                    $data['weus_follow'] = 1;
                    $data['weus_sex'] = 0;
                    // $data['weus_province'] = $request['mem_province'];
                    // $data['weus_city'] = $request['mem_city'];
                    $data['weus_headimgurl'] = '';
                    $data['weus_update_time'] = date('Y-m-d H:i:s');
                    $weus_id = DB::table('weixin_user')->insertGetId($data);
                    if (!$weus_id) {
                        DB::rollBack();
                        echo '失败';
                        die;
                    }
                    unset($data['weus_update_time']);
                } else {
                    // 更新微信用户信息
                    $edit_weus['weus_phone'] = $excel_data[$n]['mem_phone'];
                    $edit_weus['weus_nickmame'] = $excel_data[$n]['mem_name'];
                    if (!empty($request['weus_headimgurl'])) {
                        $edit_weus['weus_headimgurl'] = $request['weus_headimgurl'];
                    }
                    $edit_weus['weus_update_time'] = date('Y-m-d H:i:s');
                    $edit_weus_res = DB::table('weixin_user')
                        ->where('weus_id', $find_weixin_data->weus_id)
                        ->update($edit_weus);
                    unset($edit_weus);
                    $weus_id = $find_weixin_data->weus_id;
                }

                // 查询微信用户与门店的关系是否存在绑定关系
                $find_user_shop_data = DB::table('user_shop')
                    ->where('ussh_weus_id', $weus_id)
                    ->where('ussh_shop_id', $adm_shop_id)
                    ->select('ussh_id', 'ussh_user_id', 'ussh_user_type', 'ussh_phone')
                    ->first();

                if (empty($find_user_shop_data)) {
                    // 用户没有与当前门店绑定，把用户与当前门店绑定
                    $ussh_data['ussh_user_id'] = $mem_id;
                    $ussh_data['ussh_weus_id'] = $weus_id;
                    $ussh_data['ussh_shop_id'] = $adm_shop_id;
                    $ussh_data['ussh_user_type'] = 1;
                    $ussh_data['ussh_phone'] = $excel_data[$n]['mem_phone'];
                    $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
                    $ussh_id = DB::table('user_shop')->insertGetId($ussh_data);
                    if (!$ussh_id) {
                        DB::rollBack();
                        echo '失败';
                        die;
                    }
                } else {
                    if (empty($find_user_shop_data->ussh_user_id)) {
                        $ussh_data['ussh_user_type'] = 1;
                        $ussh_data['ussh_phone'] = $excel_data[$n]['mem_phone'];
                        $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
                        $ussh_id = DB::table('user_shop')
                            ->where('ussh_id', $find_user_shop_data->ussh_id)
                            ->update($ussh_data);
                    }
                }
                $excel_data[$n]['vip_create_time'] = trim($sheet->getCellByColumnAndRow(21, $row)->getValue()); //开卡时间
                $excel_data[$n]['vip_card_name1'] = trim($sheet->getCellByColumnAndRow(27, $row)->getValue()); //五座精洗
                if (!empty($excel_data[$n]['vip_card_name1']) && $excel_data[$n]['vip_card_name1'] > 0) {
                    $find_vica_data = DB::table('vip_card')
                        ->where('vica_id', 42)
                        ->where('vica_state', 1)
                        ->select('vica_price', 'vica_state', 'vica_id', 'vica_name', 'vica_num', 'vica_long_term', 'vica_sepr_id', 'vica_sepr_name', 'vica_instructions', 'vica_effective_date')
                        ->first();
                    $myvi_num = 'HYK'.time().rand(10000,99999);
                    $vip_data['myvi_num'] = $myvi_num;//会员卡编号
                    $vip_data['myvi_shop_id'] = $adm_shop_id;
                    $vip_data['myvi_adm_id'] = $mem_id;
                    $vip_data['myvi_surplus_times'] = $excel_data[$n]['vip_card_name1']; //剩余次数
                    $vip_data['myvi_all_times'] = $find_vica_data->vica_num; //总次数
                    $vip_data['myvi_long_term'] = $find_vica_data->vica_long_term; //是否长期1是2否
                    $vip_data['myvi_carnum'] = !empty($excel_data[$n]['mem_car_num']) ? $excel_data[$n]['mem_car_num']:''; //绑定车牌
                    $vip_data['myvi_sepr_id'] = $find_vica_data->vica_sepr_id; //服务项目id
                    $vip_data['myvi_sepr_name'] = $find_vica_data->vica_sepr_name; //服务项目名称
                    $vip_data['myvi_name'] = $find_vica_data->vica_name; //会员卡名称
                    $vip_data['myvi_explain'] = $find_vica_data->vica_instructions; //会员卡使用说明
                    $vip_data['myvi_vica_id'] = 42; //会员卡id
                    $vip_data['myvi_create_time'] = $excel_data[$n]['vip_create_time'].' '.'00:00:00';
                    if ($find_vica_data->vica_long_term == 2) {//是否长期1是2否
                        $vip_data['myvi_effective_date'] = $find_vica_data->vica_effective_date; //有效天数
                        $vip_data['myvi_end_time'] = date('Y-m-d', strtotime(date('Y-m-d').'23:59:59') + ($find_vica_data->vica_effective_date)*60*60*24).' 23:59:59';
                    } else {
                        $vip_data['myvi_end_time'] = date('Y-m-d', time() + 99999*60*60*24);
                    }
                    $myvi_id = DB::table('myvip')->insertGetId($vip_data);
                    unset($vip_data);
                }
                $excel_data[$n]['vip_card_name2'] = trim($sheet->getCellByColumnAndRow(28, $row)->getValue()); //商务普洗
                if (!empty($excel_data[$n]['vip_card_name2']) && $excel_data[$n]['vip_card_name2'] > 0) {
                    $find_vica_data = DB::table('vip_card')
                        ->where('vica_id', 43)
                        ->where('vica_state', 1)
                        ->select('vica_price', 'vica_state', 'vica_id', 'vica_name', 'vica_num', 'vica_long_term', 'vica_sepr_id', 'vica_sepr_name', 'vica_instructions', 'vica_effective_date')
                        ->first();
                    $myvi_num = 'HYK'.time().rand(10000,99999);
                    $vip_data['myvi_num'] = $myvi_num;//会员卡编号
                    $vip_data['myvi_shop_id'] = $adm_shop_id;
                    $vip_data['myvi_adm_id'] = $mem_id;
                    $vip_data['myvi_surplus_times'] = $excel_data[$n]['vip_card_name2']; //剩余次数
                    $vip_data['myvi_all_times'] = $find_vica_data->vica_num; //总次数
                    $vip_data['myvi_long_term'] = $find_vica_data->vica_long_term; //是否长期1是2否
                    $vip_data['myvi_carnum'] = !empty($excel_data[$n]['mem_car_num']) ? $excel_data[$n]['mem_car_num']:''; //绑定车牌
                    $vip_data['myvi_sepr_id'] = $find_vica_data->vica_sepr_id; //服务项目id
                    $vip_data['myvi_sepr_name'] = $find_vica_data->vica_sepr_name; //服务项目名称
                    $vip_data['myvi_name'] = $find_vica_data->vica_name; //会员卡名称
                    $vip_data['myvi_explain'] = $find_vica_data->vica_instructions; //会员卡使用说明
                    $vip_data['myvi_vica_id'] = 43; //会员卡id
                    $vip_data['myvi_create_time'] = $excel_data[$n]['vip_create_time'].' '.'00:00:00';
                    if ($find_vica_data->vica_long_term == 2) {//是否长期1是2否
                        $vip_data['myvi_effective_date'] = $find_vica_data->vica_effective_date; //有效天数
                        $vip_data['myvi_end_time'] = date('Y-m-d', strtotime(date('Y-m-d').'23:59:59') + ($find_vica_data->vica_effective_date)*60*60*24).' 23:59:59';
                    } else {
                        $vip_data['myvi_end_time'] = date('Y-m-d', time() + 99999*60*60*24);
                    }
                    $myvi_id = DB::table('myvip')->insertGetId($vip_data);
                    unset($vip_data);
                }
                $excel_data[$n]['vip_card_name3'] = trim($sheet->getCellByColumnAndRow(29, $row)->getValue()); //五座普洗
                if (!empty($excel_data[$n]['vip_card_name3']) && $excel_data[$n]['vip_card_name3'] > 0) {
                    $find_vica_data = DB::table('vip_card')
                        ->where('vica_id', 44)
                        ->where('vica_state', 1)
                        ->select('vica_price', 'vica_state', 'vica_id', 'vica_name', 'vica_num', 'vica_long_term', 'vica_sepr_id', 'vica_sepr_name', 'vica_instructions', 'vica_effective_date')
                        ->first();
                    $myvi_num = 'HYK'.time().rand(10000,99999);
                    $vip_data['myvi_num'] = $myvi_num;//会员卡编号
                    $vip_data['myvi_shop_id'] = $adm_shop_id;
                    $vip_data['myvi_adm_id'] = $mem_id;
                    $vip_data['myvi_surplus_times'] = $excel_data[$n]['vip_card_name3']; //剩余次数
                    $vip_data['myvi_all_times'] = $find_vica_data->vica_num; //总次数
                    $vip_data['myvi_long_term'] = $find_vica_data->vica_long_term; //是否长期1是2否
                    $vip_data['myvi_carnum'] = !empty($excel_data[$n]['mem_car_num']) ? $excel_data[$n]['mem_car_num']:''; //绑定车牌
                    $vip_data['myvi_sepr_id'] = $find_vica_data->vica_sepr_id; //服务项目id
                    $vip_data['myvi_sepr_name'] = $find_vica_data->vica_sepr_name; //服务项目名称
                    $vip_data['myvi_name'] = $find_vica_data->vica_name; //会员卡名称
                    $vip_data['myvi_explain'] = $find_vica_data->vica_instructions; //会员卡使用说明
                    $vip_data['myvi_vica_id'] = 44; //会员卡id
                    $vip_data['myvi_create_time'] = $excel_data[$n]['vip_create_time'].' '.'00:00:00';
                    if ($find_vica_data->vica_long_term == 2) {//是否长期1是2否
                        $vip_data['myvi_effective_date'] = $find_vica_data->vica_effective_date; //有效天数
                        $vip_data['myvi_end_time'] = date('Y-m-d', strtotime(date('Y-m-d').'23:59:59') + ($find_vica_data->vica_effective_date)*60*60*24).' '.'23:59:59';
                    } else {
                        $vip_data['myvi_end_time'] = date('Y-m-d', time() + 99999*60*60*24);
                    }
                    $myvi_id = DB::table('myvip')->insertGetId($vip_data);
                    unset($vip_data);
                }
                // dump($excel_data);
                // die;
                $n++;
                unset($excel_data);
            }
        }
        DB::commit();
        echo 999;
        die;
    }

    // 同步验车数据
    public function validator(Request $request) {
        $find_validator = DB::table('wash_order_validate_car')
            ->where('orvc_id', '>=', $request['id1'])
            ->where('orvc_id', '<=', $request['id2'])
            ->get();
        foreach ($find_validator as $key => $value) {
            $updata_data['orcl_mileage'] = $value->orvc_mileage;
            $updata_data['orcl_update_time'] = date('Y-m-d H:i:s');
            $updata_res = DB::table('order_client')
                ->where('orcl_ord_id', $value->orvc_ord_id)
                ->update($updata_data);
            // $orvc_car_interior = json_decode($value->orvc_car_interior, true);
            // if (isset($orvc_car_interior[0]['car_video'][0]['vodie_path'])) {
            //     $add_datas['vaca_shop_id'] = $value->orvc_shop_id;
            //     $add_datas['vaca_ord_id'] = $value->orvc_ord_id;
            //     $add_datas['vaca_type'] = 3;
            //     $add_datas['vaca_data'] = isset($orvc_car_interior[0]['car_video'][0]['vodie_path']) ? addHttpurl($orvc_car_interior[0]['car_video'][0]['vodie_path']) : '';
            //     $add_datas['vaca_name'] = $orvc_car_interior[0]['car_video'][0]['vodie_titile'];
            //     $add_datas['vaca_first_data'] = '';
            //     $add_datas['vaca_create_time'] = $value->orvc_update_time;
            //     $add_datas['vaca_create_id'] = $value->orvc_adm_id;
            //     $add_datas['vaca_data_id'] = 0;
            //     $add_datas['vaca_first_data_id'] = 0;
            //     $add_datas['vaca_must'] = 1;
            //     $add_datas['vaca_part'] = '';
            //     $add_datas['vaca_part_type'] = 0;
            //     $add_datas_res = DB::table('wash_validate_car')->insertGetId($add_datas);
            // }

            // $in_car = $orvc_car_interior[0]['in_car'];
            // foreach ($in_car as $key1 => $value1) {//车内部分
            //     $add_datas1['vaca_shop_id'] = $value->orvc_shop_id;
            //     $add_datas1['vaca_ord_id'] = $value->orvc_ord_id;
            //     $add_datas1['vaca_type'] = 2;
            //     $add_datas1['vaca_data'] = $value1['vacm_unusual_name'];
            //     $add_datas1['vaca_name'] = $value1['vacm_unusual_name'];
            //     $add_datas1['vaca_first_data'] = '';
            //     $add_datas1['vaca_create_time'] = $value->orvc_update_time;
            //     $add_datas1['vaca_create_id'] = $value->orvc_adm_id;
            //     $add_datas1['vaca_data_id'] = $value1['vacm_id'];
            //     $add_datas1['vaca_first_data_id'] = 0;
            //     $add_datas1['vaca_must'] = 1;
            //     $add_datas1['vaca_part'] = '车内部分';
            //     $add_datas1['vaca_part_type'] = 1;
            //     $add_datas_res = DB::table('wash_validate_car')->insertGetId($add_datas1);
            //     $img = $value1['image'];
            //     foreach ($img as $key2 => $value2) {
            //         $add_datas2['vaca_shop_id'] = $value->orvc_shop_id;
            //         $add_datas2['vaca_ord_id'] = $value->orvc_ord_id;
            //         $add_datas2['vaca_type'] = 3;
            //         $add_datas2['vaca_data'] = addHttpurl($value2);
            //         $add_datas2['vaca_name'] = '';
            //         $add_datas2['vaca_first_data'] = '';
            //         $add_datas2['vaca_create_time'] = $value->orvc_update_time;
            //         $add_datas2['vaca_create_id'] = $value->orvc_adm_id;
            //         $add_datas2['vaca_data_id'] = 0;
            //         $add_datas2['vaca_first_data_id'] = 0;
            //         $add_datas2['vaca_must'] = 1;
            //         $add_datas2['vaca_part'] = '';
            //         $add_datas2['vaca_part_type'] = 0;
            //         $add_datas_res = DB::table('wash_validate_car')->insertGetId($add_datas2);
            //     }
            // }
            // $orvc_car_exterior = json_decode($value->orvc_car_exterior, true);
            // $car_exterior = $orvc_car_exterior[0]['car_exterior'];
            // foreach ($car_exterior as $key1 => $value1) {//外观部分
            //     $add_datas3['vaca_shop_id'] = $value->orvc_shop_id;
            //     $add_datas3['vaca_ord_id'] = $value->orvc_ord_id;
            //     $add_datas3['vaca_type'] = 2;
            //     $add_datas3['vaca_data'] = $value1['vacm_unusual_name'];
            //     $add_datas3['vaca_name'] = $value1['vacm_unusual_name'];
            //     $add_datas3['vaca_first_data'] = '';
            //     $add_datas3['vaca_create_time'] = $value->orvc_update_time;
            //     $add_datas3['vaca_create_id'] = $value->orvc_adm_id;
            //     $add_datas3['vaca_data_id'] = $value1['vacm_id'];
            //     $add_datas3['vaca_first_data_id'] = 0;
            //     $add_datas3['vaca_must'] = 1;
            //     $add_datas3['vaca_part'] = '外观部分';
            //     $add_datas3['vaca_part_type'] = 2;
            //     $add_datas_res = DB::table('wash_validate_car')->insertGetId($add_datas3);
            //     $img = $value1['image'];
            //     foreach ($img as $key2 => $value2) {
            //         $add_datas4['vaca_shop_id'] = $value->orvc_shop_id;
            //         $add_datas4['vaca_ord_id'] = $value->orvc_ord_id;
            //         $add_datas4['vaca_type'] = 3;
            //         $add_datas4['vaca_data'] = addHttpurl($value2);
            //         $add_datas4['vaca_name'] = '';
            //         $add_datas4['vaca_first_data'] = '';
            //         $add_datas4['vaca_create_time'] = $value->orvc_update_time;
            //         $add_datas4['vaca_create_id'] = $value->orvc_adm_id;
            //         $add_datas4['vaca_data_id'] = 0;
            //         $add_datas4['vaca_first_data_id'] = 0;
            //         $add_datas4['vaca_must'] = 1;
            //         $add_datas4['vaca_part'] = '';
            //         $add_datas4['vaca_part_type'] = 0;
            //         $add_datas_res = DB::table('wash_validate_car')->insertGetId($add_datas4);
            //     }
            // }
            // if (isset($orvc_car_exterior[0]['car_lacquer'])) {
            //     $car_lacquer = $orvc_car_exterior[0]['car_lacquer'];
            //     foreach ($car_lacquer as $key1 => $value1) {//外观部分
            //         $add_datas5['vaca_shop_id'] = $value->orvc_shop_id;
            //         $add_datas5['vaca_ord_id'] = $value->orvc_ord_id;
            //         $add_datas5['vaca_type'] = 2;
            //         $add_datas5['vaca_data'] = $value1['vacm_unusual_name'];
            //         $add_datas5['vaca_name'] = $value1['vacm_unusual_name'];
            //         $add_datas5['vaca_first_data'] = '';
            //         $add_datas5['vaca_create_time'] = $value->orvc_update_time;
            //         $add_datas5['vaca_create_id'] = $value->orvc_adm_id;
            //         $add_datas5['vaca_data_id'] = $value1['vacm_id'];
            //         $add_datas5['vaca_first_data_id'] = 0;
            //         $add_datas5['vaca_must'] = 1;
            //         $add_datas5['vaca_part'] = '漆面部分';
            //         $add_datas5['vaca_part_type'] = 3;
            //         $add_datas_res = DB::table('wash_validate_car')->insertGetId($add_datas5);
            //         $img = $value1['image'];
            //         foreach ($img as $key2 => $value2) {
            //             $add_datas6['vaca_shop_id'] = $value->orvc_shop_id;
            //             $add_datas6['vaca_ord_id'] = $value->orvc_ord_id;
            //             $add_datas6['vaca_type'] = 3;
            //             $add_datas6['vaca_data'] = addHttpurl($value2);
            //             $add_datas6['vaca_name'] = '';
            //             $add_datas6['vaca_first_data'] = '';
            //             $add_datas6['vaca_create_time'] = $value->orvc_update_time;
            //             $add_datas6['vaca_create_id'] = $value->orvc_adm_id;
            //             $add_datas6['vaca_data_id'] = 0;
            //             $add_datas6['vaca_first_data_id'] = 0;
            //             $add_datas6['vaca_must'] = 1;
            //             $add_datas6['vaca_part'] = '';
            //             $add_datas6['vaca_part_type'] = 0;
            //             $add_datas_res = DB::table('wash_validate_car')->insertGetId($add_datas6);
            //         }
            //     }
            // }
            // if (isset($orvc_car_exterior[0]['car_dismounting'])) {
            //     $car_dismounting = $orvc_car_exterior[0]['car_dismounting'];
            //     foreach ($car_dismounting as $key1 => $value1) {//外观部分
            //         $add_datas7['vaca_shop_id'] = $value->orvc_shop_id;
            //         $add_datas7['vaca_ord_id'] = $value->orvc_ord_id;
            //         $add_datas7['vaca_type'] = 2;
            //         $add_datas7['vaca_data'] = $value1['vacm_unusual_name'];
            //         $add_datas7['vaca_name'] = $value1['vacm_unusual_name'];
            //         $add_datas7['vaca_first_data'] = '';
            //         $add_datas7['vaca_create_time'] = $value->orvc_update_time;
            //         $add_datas7['vaca_create_id'] = $value->orvc_adm_id;
            //         $add_datas7['vaca_data_id'] = $value1['vacm_id'];
            //         $add_datas7['vaca_first_data_id'] = 0;
            //         $add_datas7['vaca_must'] = 1;
            //         $add_datas7['vaca_part'] = '拆卸部分';
            //         $add_datas7['vaca_part_type'] = 4;
            //         $add_datas_res = DB::table('wash_validate_car')->insertGetId($add_datas7);
            //         $img = $value1['image'];
            //         foreach ($img as $key2 => $value2) {
            //             $add_datas8['vaca_shop_id'] = $value->orvc_shop_id;
            //             $add_datas8['vaca_ord_id'] = $value->orvc_ord_id;
            //             $add_datas8['vaca_type'] = 3;
            //             $add_datas8['vaca_data'] = addHttpurl($value2);
            //             $add_datas8['vaca_name'] = '';
            //             $add_datas8['vaca_first_data'] = '';
            //             $add_datas8['vaca_create_time'] = $value->orvc_update_time;
            //             $add_datas8['vaca_create_id'] = $value->orvc_adm_id;
            //             $add_datas8['vaca_data_id'] = 0;
            //             $add_datas8['vaca_first_data_id'] = 0;
            //             $add_datas8['vaca_must'] = 1;
            //             $add_datas8['vaca_part'] = '';
            //             $add_datas8['vaca_part_type'] = 0;
            //             $add_datas_res = DB::table('wash_validate_car')->insertGetId($add_datas8);
            //         }
            //     }
            // }
        }
        echo '成功';
    }

    public function getQuantity(Request $request) {
        $find_data = DB::table('wash_work_technician_part')
            ->leftjoin('work_order', 'wor_id', '=', 'wotp_wor_id')
            ->where('wotp_wor_id', '>=', $request['id1'])
            ->where('wotp_wor_id', '<=', $request['id2'])
            ->select('wotp_wor_id', 'wotp_service_adm_id', 'wotp_service_data', 'wotp_service_qualitytesting', 'wotp_shop_id', 'wor_service_adm_id', 'wotp_update_time', 'wotp_service_quality')
            ->get()->toArray();
            dump($find_data);
        foreach ($find_data as $key => $value) {
            // $wotp_service_qualitytesting = json_decode($value->wotp_service_qualitytesting, true);
            // if (!empty($wotp_service_qualitytesting)) {
            //     foreach ($wotp_service_qualitytesting as $key1 => $value1) {
            //         $add_data['quda_shop_id'] = $value->wotp_shop_id;
            //         $add_data['quda_wor_id'] = $value->wotp_wor_id;
            //         $add_data['quda_adm_id'] = $value->wotp_service_adm_id;
            //         $add_data['quda_type'] = 1;
            //         $add_data['quda_qurp_id'] = $value1['qurp_id'];
            //         $add_data['quda_qurp_data'] = $value1['qurp_name'];
            //         $add_data['quda_create_id'] = $value->wor_service_adm_id;
            //         $add_data['quda_create_time'] = $value->wotp_update_time;
            //         $add_res = DB::table('quality_data')
            //             ->insertGetId($add_data);
            //         unset($add_data);
            //         if (isset($value1['pic'])) {
            //             $pic = $value1['pic'];
            //         } else {
            //             $pic = '';
            //         }
            //         if (!empty($pic)) {
            //             foreach ($pic as $k => $v) {
            //                 $add_pic['quda_shop_id'] = $value->wotp_shop_id;
            //                 $add_pic['quda_wor_id'] = $value->wotp_wor_id;
            //                 $add_pic['quda_adm_id'] = $value->wotp_service_adm_id;
            //                 $add_pic['quda_type'] = 2;
            //                 $add_pic['quda_qurp_id'] = 0;
            //                 if (is_array($v)) {
            //                     dump($pic);
            //                     dump($v);
            //                     dump(333);
            //                     die;
            //                 }
            //                 $add_pic['quda_qurp_data'] = addHttpurl($v);
            //                 $add_pic['quda_create_id'] = $value->wor_service_adm_id;
            //                 $add_pic['quda_create_time'] = $value->wotp_update_time;
            //                 $add_res = DB::table('quality_data')
            //                     ->insertGetId($add_pic);
            //                 unset($add_pic);
            //             }
            //         }
            //     }
            // }
            // $wotp_service_data = json_decode($value->wotp_service_data, true);
            // if (!empty($wotp_service_data)) {
            //     foreach ($wotp_service_data as $k1 => $v1) {
            //         $add_data_coin['coin_shop_id'] = $value->wotp_shop_id;
            //         $add_data_coin['coin_wor_id'] = $value->wotp_wor_id;
            //         $add_data_coin['coin_adm_id'] = $value->wotp_service_adm_id;
            //         $add_data_coin['coin_type'] = 1;
            //         $add_data_coin['coin_data'] = $v1['wotp_service_part'];
            //         $add_data_coin['coin_data_id'] = $v1['wotp_id'];
            //         $part_data = DB::table('auto_parts')
            //             ->where('id', $v1['wotp_id'])
            //             ->select('type', 'type_id')
            //             ->first();
            //         $add_data_coin['coin_first_data'] = $part_data->type;
            //         $add_data_coin['coin_first_data_id'] = $part_data->type_id;
            //         $add_data_coin['coin_create_id'] = $value->wor_service_adm_id;
            //         $add_data_coin['coin_create_time'] = $value->wotp_update_time;
            //         $add_res = DB::table('completion_info')
            //             ->insertGetId($add_data_coin);
            //         unset($add_data_coin);
            //         if (isset($v1['pic'])) {
            //             $pic = $v1['pic'];
            //         } else {
            //             $pic = '';
            //         }
            //         if (!empty($pic)) {
            //             foreach ($pic as $k2 => $v2) {
            //                 $add_pic_coin['coin_shop_id'] = $value->wotp_shop_id;
            //                 $add_pic_coin['coin_wor_id'] = $value->wotp_wor_id;
            //                 $add_pic_coin['coin_adm_id'] = $value->wotp_service_adm_id;
            //                 $add_pic_coin['coin_type'] = 2;
            //                 if (is_array($v2)) {
            //                     $add_pic_coin['coin_data'] = addHttpurl($v2['img_path']);
            //                 } else {
            //                     $add_pic_coin['coin_data'] = addHttpurl($v2);
            //                 }
            //                 $add_pic_coin['coin_create_id'] = $value->wor_service_adm_id;
            //                 $add_pic_coin['coin_create_time'] = $value->wotp_update_time;
            //                 $add_res = DB::table('completion_info')
            //                     ->insertGetId($add_pic_coin);
            //                 unset($add_pic_coin);
            //             }
            //         }
            //     }
            // }

            $wotp_service_quality = json_decode($value->wotp_service_quality, true);
            if (!empty($wotp_service_quality)) {
                dump($wotp_service_quality);die;

                foreach ($wotp_service_quality as $k3 => $v3) {
                    $new_pic = $v3['upload_files'];
                    if (!empty($new_pic)) {
                        foreach ($new_pic as $k4 => $v4) {
                            if (!empty($v4)) {
                                if (isset($v4['id']) && $v4['id'] == 4) {
                                    foreach ($v4['pic_url'] as $k5 => $v5) {
                                        $add_pic3['coin_shop_id'] = $value->wotp_shop_id;
                                        $add_pic3['coin_wor_id'] = $value->wotp_wor_id;
                                        $add_pic3['coin_adm_id'] = $value->wotp_service_adm_id;
                                        $add_pic3['coin_type'] = 3;
                                        $add_pic3['coin_data_id'] = $v4['id'];
                                        if (is_array($v5)) {
                                            dump($v5);
                                            dump(222);
                                            die;
                                        }
                                        $add_pic3['coin_data'] = addHttpurl($v5);
                                        $add_pic3['coin_name'] = $v4['show_word'];
                                        $add_pic3['coin_create_id'] = $value->wor_service_adm_id;
                                        $add_pic3['coin_create_time'] = $value->wotp_update_time;
                                        $add_res = DB::table('completion_info')
                                            ->insertGetId($add_pic3);
                                    }
                                } elseif (isset($v4['id']) && $v4['id'] != 4) {
                                    $add_pic3['coin_shop_id'] = $value->wotp_shop_id;
                                    $add_pic3['coin_wor_id'] = $value->wotp_wor_id;
                                    $add_pic3['coin_adm_id'] = $value->wotp_service_adm_id;
                                    $add_pic3['coin_type'] = 3;
                                    $add_pic3['coin_data_id'] = $v4['id'];
                                    if (is_array($v4['pic_url'])) {
                                        dump($v4['pic_url']);
                                        dump(111);
                                        die;
                                    }
                                    $add_pic3['coin_data'] = addHttpurl($v4['pic_url']);
                                    $add_pic3['coin_name'] = $v4['show_word'];
                                    $add_pic3['coin_create_id'] = $value->wor_service_adm_id;
                                    $add_pic3['coin_create_time'] = $value->wotp_update_time;
                                    $add_res = DB::table('completion_info')
                                        ->insertGetId($add_pic3);
                                }
                                unset($add_pic3);
                            }
                        }
                    }
                }
            }
        }
        echo 666;
    }
}
