<?php
namespace App\Http\Controllers\Api\ActivityManagements;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\ActivityManagements\VerifyActivityListsController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

// 活动列表
class ActivityListsController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyActivityListsController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误', 'error_message' => $error_message]);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        $list_data = DB::table('activity')
            ->where('acti_cid', $user_info->adm_cid)
            ->where('acti_superior_shop_id', $shop_id)
            ->where('acti_delete', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['acti_state'])) {
                    $query->where('acti_state', 'like', '%' . $search_data['acti_state'] . '%');
                }
            }) //状态
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                    $query->whereBetween('acti_create_time', [$search_data['start_time'], $search_data['end_time'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['start_time'])) {
                        $query->where('acti_create_time', '>=', $search_data['start_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['end_time'])) {
                            $query->where('acti_create_time', '<=', $search_data['end_time'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['starts_time']) && !empty($search_data['ends_time'])) {
                    $query->whereBetween('acti_start_time', [$search_data['starts_time'], $search_data['ends_time'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['starts_time'])) {
                        $query->where('acti_start_time', '>=', $search_data['starts_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['ends_time'])) {
                            $query->where('acti_start_time', '<=', $search_data['ends_time'] . ' 23:59:59');
                        }
                    }
                }
            }) //活动时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['acti_create_id'])) {
                    $query->where('acti_create_id', $search_data['acti_create_id']);
                }
            }) //创建人
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['acti_activity_nature'])) {
                    $query->where('acti_activity_nature', $search_data['acti_activity_nature']);
                }
            }) //活动性质
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['acti_activity_type'])) {
                    $query->where('acti_activity_type', $search_data['acti_activity_type']);
                }
            }) //活动类型
            ->select('acti_id', 'acti_create_time', 'acti_name', 'acti_number', 'acti_activity_type', 'acti_start_time', 'acti_end_time', 'acti_activity_nature', 'acti_cycle_number', 'acti_create_id', 'acti_state', 'acti_activity_days')
            ->orderBy('acti_id', 'desc')
            ->paginate($this->show_count);
        $data = $list_data->items();
        if ($data) {
            // 获取创建人id
            $adm_id = array_column($data, 'acti_create_id');
            // 查询账号信息
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->select('adm_id', 'adm_name')
                ->get();
            $data_info['admin'] = $find_admin;
        }

        $state_count = DB::table('activity')
            ->where('acti_cid', $user_info->adm_cid)
            ->where('acti_superior_shop_id', $shop_id)
            ->select(DB::raw('count(*) as count, acti_state'))
            ->groupBy('acti_state')
            ->get();

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;        //一页显示多少个
        $data_info['data'] = $data;                //返回数据
        $data_info['state_count'] = $state_count;                //返回数据

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if ($list_data) {
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data_info, 'list_button' => $list_button]);
        } else {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '暂无数据']);
        }
    }

    // 发布
    public function publish(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyActivityListsController;
        $error_message = $verify_data->deliveryValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误', 'error_message' => $error_message]);
        }

        $update_data['acti_state'] = 2; //状态：1预备中2已发布3进行中4已过期5终止
        $update_data['acti_update_time'] = date('Y-m-d H:i:s');

        $acti_res = DB::table('activity')
            ->where('acti_id', $request['acti_id'])
            ->update($update_data);

        if ($acti_res) {
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);
            // 查询信息
            $acti_number = DB::table('activity')
                ->where('acti_id', $request['acti_id'])
                ->value('acti_number');
            Common::addLog($user_info, getRealIp($request), '活动列表', '发布', '活动：' . $acti_number . '发布成功');
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => '该活动发布成功']);
        } else {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '该活动发布失败']);
        }
    }

    // 删除
    public function delete(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyActivityListsController;
        $error_message = $verify_data->deleteValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误', 'error_message' => $error_message]);
        }

        // 查询信息
        $find_acti = DB::table('activity')
            ->where('acti_id', $request['acti_id'])
            ->select('acti_number', 'acti_state', 'acti_activity_type')
            ->first();
        if ($find_acti->acti_state != '1') {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '只有预备中的活动才能删除']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $update_data['acti_delete'] = 2; //是否删除1正常2删除
        $update_data['acti_update_time'] = date('Y-m-d H:i:s');

        DB::beginTransaction();

        if ($find_acti->acti_activity_type == '1') { //折扣
            $find_acdi = DB::table('activity_discount')
                ->where('acdi_acti_id', $request['acti_id'])
                ->select('acdi_id', 'acdi_goo_id')
                ->get()
                ->toArray();
            $goo_id = array_column($find_acdi, 'acdi_goo_id');
            $find_acgo = DB::table('activity_goods')
                ->where('acgo_cid', $user_info->adm_cid)
                ->where('acgo_superior_shop_id', $shop_id)
                ->whereIn('acgo_goo_id', $goo_id)
                ->select('acgo_id', 'acgo_goo_id', 'acgo_acti_id')
                ->get()
                ->toArray();
            $sql = 'UPDATE `faster_activity_goods` SET ';
            $acti_id_sql = '';
            $update_time_sql = '';
            $ids = '';
            foreach ($find_acgo as $key => $value) {
                // 把活动id字符串转成数组
                $acgo_acti_id = array_unique(explode(',', trim($value->acgo_acti_id, ',')));
                // 去掉数组中的活动id
                $new_acti_id = array_search($request['acti_id'], $acgo_acti_id);
                $v = array_splice($acgo_acti_id, $new_acti_id);
                unset($new_acti_id);
                // 把数组转成字符串
                $new_acgo_acti_id = implode(",", $acgo_acti_id);
                // 更新活动商品表的活动id数据
                $acti_id_sql = $acti_id_sql . ' WHEN ' . $value->acgo_id;
                $acti_id_sql = $acti_id_sql . ' THEN "' . ',' . $new_acgo_acti_id . '"';

                $update_time_sql = $update_time_sql . ' WHEN ' . $value->acgo_id;
                $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';
                $ids = $ids . $value->acgo_id . ',';
            }
            $sql = $sql . ' `acgo_acti_id` = CASE `acgo_id`' . $acti_id_sql . ' END,';
            $sql = $sql . ' `acgo_update_time`=  CASE `acgo_id` ' . $update_time_sql . ' END';
            $sql = $sql . ' WHERE `acgo_id` IN (' . trim($ids, ',') . ')';
            $acgo_res = DB::update($sql);
            if (!$acgo_res) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '删除失败']);
            }
        } elseif ($find_acti->acti_activity_type == '2') { //买送
            $find_acdo = DB::table('activity_donate')
                ->where('acdo_acti_id', $request['acti_id'])
                ->select('acdo_id', 'acdo_goo_id')
                ->get()
                ->toArray();
            $goo_id = array_column($find_acdo, 'acdo_goo_id');
            $find_acgo = DB::table('activity_goods')
                ->where('acgo_cid', $user_info->adm_cid)
                ->where('acgo_superior_shop_id', $shop_id)
                ->whereIn('acgo_goo_id', $goo_id)
                ->select('acgo_id', 'acgo_goo_id', 'acgo_acti_id')
                ->get()
                ->toArray();
            $sql = 'UPDATE `faster_activity_goods` SET ';
            $acti_id_sql = '';
            $update_time_sql = '';
            $ids = '';
            foreach ($find_acgo as $key => $value) {
                // 把活动id字符串转成数组
                $acgo_acti_id = array_unique(explode(',', trim($value->acgo_acti_id, ',')));
                // 去掉数组中的活动id
                $new_acti_id = array_search($request['acti_id'], $acgo_acti_id);
                $v = array_splice($acgo_acti_id, $new_acti_id);
                unset($new_acti_id);
                // 把数组转成字符串
                $new_acgo_acti_id = implode(",", $acgo_acti_id);
                // 更新活动商品表的活动id数据
                $acti_id_sql = $acti_id_sql . ' WHEN ' . $value->acgo_id;
                $acti_id_sql = $acti_id_sql . ' THEN "' . ',' . $new_acgo_acti_id . '"';

                $update_time_sql = $update_time_sql . ' WHEN ' . $value->acgo_id;
                $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';
                $ids = $ids . $value->acgo_id . ',';
            }
            $sql = $sql . ' `acgo_acti_id` = CASE `acgo_id`' . $acti_id_sql . ' END,';
            $sql = $sql . ' `acgo_update_time`=  CASE `acgo_id` ' . $update_time_sql . ' END';
            $sql = $sql . ' WHERE `acgo_id` IN (' . trim($ids, ',') . ')';
            $acgo_res = DB::update($sql);
            if (!$acgo_res) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '删除失败']);
            }
        } elseif ($find_acti->acti_activity_type == '3') { //买赠
            $find_acdo = DB::table('activity_donate')
                ->where('acdo_acti_id', $request['acti_id'])
                ->select('acdo_id', 'acdo_goo_id')
                ->get()
                ->toArray();
            $goo_id = array_column($find_acdo, 'acdo_goo_id');
            $find_acgo = DB::table('activity_goods')
                ->where('acgo_cid', $user_info->adm_cid)
                ->where('acgo_superior_shop_id', $shop_id)
                ->whereIn('acgo_goo_id', $goo_id)
                ->select('acgo_id', 'acgo_goo_id', 'acgo_acti_id')
                ->get()
                ->toArray();
            $sql = 'UPDATE `faster_activity_goods` SET ';
            $acti_id_sql = '';
            $update_time_sql = '';
            $ids = '';
            foreach ($find_acgo as $key => $value) {
                // 把活动id字符串转成数组
                $acgo_acti_id = array_unique(explode(',', trim($value->acgo_acti_id, ',')));
                // 去掉数组中的活动id
                $new_acti_id = array_search($request['acti_id'], $acgo_acti_id);
                $v = array_splice($acgo_acti_id, $new_acti_id);
                unset($new_acti_id);
                // 把数组转成字符串
                $new_acgo_acti_id = implode(",", $acgo_acti_id);
                // 更新活动商品表的活动id数据
                $acti_id_sql = $acti_id_sql . ' WHEN ' . $value->acgo_id;
                $acti_id_sql = $acti_id_sql . ' THEN "' . ',' . $new_acgo_acti_id . '"';

                $update_time_sql = $update_time_sql . ' WHEN ' . $value->acgo_id;
                $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';
                $ids = $ids . $value->acgo_id . ',';
            }
            $sql = $sql . ' `acgo_acti_id` = CASE `acgo_id`' . $acti_id_sql . ' END,';
            $sql = $sql . ' `acgo_update_time`=  CASE `acgo_id` ' . $update_time_sql . ' END';
            $sql = $sql . ' WHERE `acgo_id` IN (' . trim($ids, ',') . ')';
            $acgo_res = DB::update($sql);
            if (!$acgo_res) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '删除失败']);
            }
        } elseif ($find_acti->acti_activity_type == '7') { //活动高价回收
            $find_achr = DB::table('activity_high_recycling')
                ->where('achr_acti_id', $request['acti_id'])
                ->select('achr_id', 'achr_goo_id')
                ->get()
                ->toArray();
            $goo_id = array_column($find_achr, 'achr_goo_id');
            $find_acgo = DB::table('activity_goods')
                ->where('acgo_cid', $user_info->adm_cid)
                ->where('acgo_superior_shop_id', $shop_id)
                ->whereIn('acgo_goo_id', $goo_id)
                ->select('acgo_id', 'acgo_goo_id', 'acgo_acti_id')
                ->get()
                ->toArray();
            $sql = 'UPDATE `faster_activity_goods` SET ';
            $acti_id_sql = '';
            $update_time_sql = '';
            $ids = '';
            foreach ($find_acgo as $key => $value) {
                // 把活动id字符串转成数组
                $acgo_acti_id = array_unique(explode(',', trim($value->acgo_acti_id, ',')));
                // 去掉数组中的活动id
                $new_acti_id = array_search($request['acti_id'], $acgo_acti_id);
                $v = array_splice($acgo_acti_id, $new_acti_id);
                unset($new_acti_id);
                // 把数组转成字符串
                $new_acgo_acti_id = implode(",", $acgo_acti_id);
                // 更新活动商品表的活动id数据
                $acti_id_sql = $acti_id_sql . ' WHEN ' . $value->acgo_id;
                $acti_id_sql = $acti_id_sql . ' THEN "' . ',' . $new_acgo_acti_id . '"';

                $update_time_sql = $update_time_sql . ' WHEN ' . $value->acgo_id;
                $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';
                $ids = $ids . $value->acgo_id . ',';
            }
            $sql = $sql . ' `acgo_acti_id` = CASE `acgo_id`' . $acti_id_sql . ' END,';
            $sql = $sql . ' `acgo_update_time`=  CASE `acgo_id` ' . $update_time_sql . ' END';
            $sql = $sql . ' WHERE `acgo_id` IN (' . trim($ids, ',') . ')';
            $acgo_res = DB::update($sql);
            if (!$acgo_res) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '删除失败']);
            }
        } elseif ($find_acti->acti_activity_type == '8') { //大批量采购
            $find_acpr = DB::table('activity_procurement')
                ->where('acpr_acti_id', $request['acti_id'])
                ->select('acpr_id', 'acpr_goo_id')
                ->get()
                ->toArray();
            $goo_id = array_column($find_acpr, 'acpr_goo_id');
            $find_acgo = DB::table('activity_goods')
                ->where('acgo_cid', $user_info->adm_cid)
                ->where('acgo_superior_shop_id', $shop_id)
                ->whereIn('acgo_goo_id', $goo_id)
                ->select('acgo_id', 'acgo_goo_id', 'acgo_acti_id')
                ->get()
                ->toArray();
            $sql = 'UPDATE `faster_activity_goods` SET ';
            $acti_id_sql = '';
            $update_time_sql = '';
            $ids = '';
            foreach ($find_acgo as $key => $value) {
                // 把活动id字符串转成数组
                $acgo_acti_id = array_unique(explode(',', trim($value->acgo_acti_id, ',')));
                // 去掉数组中的活动id
                $new_acti_id = array_search($request['acti_id'], $acgo_acti_id);
                $v = array_splice($acgo_acti_id, $new_acti_id);
                unset($new_acti_id);
                // 把数组转成字符串
                $new_acgo_acti_id = implode(",", $acgo_acti_id);
                // 更新活动商品表的活动id数据
                $acti_id_sql = $acti_id_sql . ' WHEN ' . $value->acgo_id;
                $acti_id_sql = $acti_id_sql . ' THEN "' . ',' . $new_acgo_acti_id . '"';

                $update_time_sql = $update_time_sql . ' WHEN ' . $value->acgo_id;
                $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';
                $ids = $ids . $value->acgo_id . ',';
            }
            $sql = $sql . ' `acgo_acti_id` = CASE `acgo_id`' . $acti_id_sql . ' END,';
            $sql = $sql . ' `acgo_update_time`=  CASE `acgo_id` ' . $update_time_sql . ' END';
            $sql = $sql . ' WHERE `acgo_id` IN (' . trim($ids, ',') . ')';
            $acgo_res = DB::update($sql);
            if (!$acgo_res) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '删除失败']);
            }
        }

        $acti_res = DB::table('activity')
            ->where('acti_id', $request['acti_id'])
            ->update($update_data);
        if ($acti_res) {
            DB::commit();
            Common::addLog($user_info, getRealIp($request), '活动列表', '删除', '活动：' . $find_acti->acti_number . '删除成功');
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => '该活动删除成功']);
        } else {
            DB::rollBack();
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '该活动删除失败']);
        }
    }

    // 启动
    public function start(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyActivityListsController;
        $error_message = $verify_data->deliveryValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误', 'error_message' => $error_message]);
        }

        // 查询信息
        $find_acti = DB::table('activity')
            ->where('acti_id', $request['acti_id'])
            ->select('acti_number', 'acti_state')
            ->first();
        if ($find_acti->acti_state != '2') {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '只有已发布的活动才能启动']);
        }

        $update_data['acti_state'] = 3; //状态：1预备中2已发布3进行中4已过期5终止
        $update_data['acti_update_time'] = date('Y-m-d H:i:s');

        $acti_res = DB::table('activity')
            ->where('acti_id', $request['acti_id'])
            ->update($update_data);

        if ($acti_res) {
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);
            Common::addLog($user_info, getRealIp($request), '活动列表', '启动', '活动：' . $find_acti->acti_number . '启动成功');
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => '该活动启动成功']);
        } else {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '该活动启动失败']);
        }
    }

    // 撤销发布
    public function unpublish(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyActivityListsController;
        $error_message = $verify_data->deliveryValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误', 'error_message' => $error_message]);
        }

        // 查询信息
        $find_acti = DB::table('activity')
            ->where('acti_id', $request['acti_id'])
            ->select('acti_number', 'acti_state')
            ->first();
        if ($find_acti->acti_state != '2') {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '只有已发布的活动才能撤销']);
        }

        $update_data['acti_state'] = 1; //状态：1预备中2已发布3进行中4已过期5终止
        $update_data['acti_update_time'] = date('Y-m-d H:i:s');

        $acti_res = DB::table('activity')
            ->where('acti_id', $request['acti_id'])
            ->update($update_data);

        if ($acti_res) {
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);
            Common::addLog($user_info, getRealIp($request), '活动列表', '撤销发布', '活动：' . $find_acti->acti_number . '撤销发布成功');
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => '该活动撤销发布成功']);
        } else {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '该活动撤销发布失败']);
        }
    }

    // 终止
    public function terminate(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyActivityListsController;
        $error_message = $verify_data->deliveryValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误', 'error_message' => $error_message]);
        }

        // 查询信息
        $find_acti = DB::table('activity')
            ->where('acti_id', $request['acti_id'])
            ->select('acti_number', 'acti_state', 'acti_activity_type')
            ->first();
        if ($find_acti->acti_state != '3') {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '只有进行中的活动才能终止']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $update_data['acti_state'] = 5; //状态：1预备中2已发布3进行中4已过期5终止
        $update_data['acti_update_time'] = date('Y-m-d H:i:s');

        DB::beginTransaction();

        if ($find_acti->acti_activity_type == '1') { //折扣
            $find_acdi = DB::table('activity_discount')
                ->where('acdi_acti_id', $request['acti_id'])
                ->select('acdi_id', 'acdi_goo_id')
                ->get()
                ->toArray();
            $goo_id = array_column($find_acdi, 'acdi_goo_id');
            $find_acgo = DB::table('activity_goods')
                ->where('acgo_cid', $user_info->adm_cid)
                ->where('acgo_superior_shop_id', $shop_id)
                ->whereIn('acgo_goo_id', $goo_id)
                ->select('acgo_id', 'acgo_goo_id', 'acgo_acti_id')
                ->get()
                ->toArray();
            $sql = 'UPDATE `faster_activity_goods` SET ';
            $acti_id_sql = '';
            $update_time_sql = '';
            $ids = '';
            foreach ($find_acgo as $key => $value) {
                // 把活动id字符串转成数组
                $acgo_acti_id = array_unique(explode(',', trim($value->acgo_acti_id, ',')));
                // 去掉数组中的活动id
                $new_acti_id = array_search($request['acti_id'], $acgo_acti_id);
                $v = array_splice($acgo_acti_id, $new_acti_id);
                unset($new_acti_id);
                // 把数组转成字符串
                $new_acgo_acti_id = implode(",", $acgo_acti_id);
                // 更新活动商品表的活动id数据
                $acti_id_sql = $acti_id_sql . ' WHEN ' . $value->acgo_id;
                $acti_id_sql = $acti_id_sql . ' THEN "' . ',' . $new_acgo_acti_id . '"';

                $update_time_sql = $update_time_sql . ' WHEN ' . $value->acgo_id;
                $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';
                $ids = $ids . $value->acgo_id . ',';
            }
            $sql = $sql . ' `acgo_acti_id` = CASE `acgo_id`' . $acti_id_sql . ' END,';
            $sql = $sql . ' `acgo_update_time`=  CASE `acgo_id` ' . $update_time_sql . ' END';
            $sql = $sql . ' WHERE `acgo_id` IN (' . trim($ids, ',') . ')';
            $acgo_res = DB::update($sql);
            if (!$acgo_res) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '删除失败']);
            }
        } elseif ($find_acti->acti_activity_type == '2') { //买送
            $find_acdo = DB::table('activity_donate')
                ->where('acdo_acti_id', $request['acti_id'])
                ->select('acdo_id', 'acdo_goo_id')
                ->get()
                ->toArray();
            $goo_id = array_column($find_acdo, 'acdo_goo_id');
            $find_acgo = DB::table('activity_goods')
                ->where('acgo_cid', $user_info->adm_cid)
                ->where('acgo_superior_shop_id', $shop_id)
                ->whereIn('acgo_goo_id', $goo_id)
                ->select('acgo_id', 'acgo_goo_id', 'acgo_acti_id')
                ->get()
                ->toArray();
            $sql = 'UPDATE `faster_activity_goods` SET ';
            $acti_id_sql = '';
            $update_time_sql = '';
            $ids = '';
            foreach ($find_acgo as $key => $value) {
                // 把活动id字符串转成数组
                $acgo_acti_id = array_unique(explode(',', trim($value->acgo_acti_id, ',')));
                // 去掉数组中的活动id
                $new_acti_id = array_search($request['acti_id'], $acgo_acti_id);
                $v = array_splice($acgo_acti_id, $new_acti_id);
                unset($new_acti_id);
                // 把数组转成字符串
                $new_acgo_acti_id = implode(",", $acgo_acti_id);
                // 更新活动商品表的活动id数据
                $acti_id_sql = $acti_id_sql . ' WHEN ' . $value->acgo_id;
                $acti_id_sql = $acti_id_sql . ' THEN "' . ',' . $new_acgo_acti_id . '"';

                $update_time_sql = $update_time_sql . ' WHEN ' . $value->acgo_id;
                $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';
                $ids = $ids . $value->acgo_id . ',';
            }
            $sql = $sql . ' `acgo_acti_id` = CASE `acgo_id`' . $acti_id_sql . ' END,';
            $sql = $sql . ' `acgo_update_time`=  CASE `acgo_id` ' . $update_time_sql . ' END';
            $sql = $sql . ' WHERE `acgo_id` IN (' . trim($ids, ',') . ')';
            $acgo_res = DB::update($sql);
            if (!$acgo_res) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '删除失败']);
            }
        } elseif ($find_acti->acti_activity_type == '3') { //买赠
            $find_acdo = DB::table('activity_donate')
                ->where('acdo_acti_id', $request['acti_id'])
                ->select('acdo_id', 'acdo_goo_id')
                ->get()
                ->toArray();
            $goo_id = array_column($find_acdo, 'acdo_goo_id');
            $find_acgo = DB::table('activity_goods')
                ->where('acgo_cid', $user_info->adm_cid)
                ->where('acgo_superior_shop_id', $shop_id)
                ->whereIn('acgo_goo_id', $goo_id)
                ->select('acgo_id', 'acgo_goo_id', 'acgo_acti_id')
                ->get()
                ->toArray();
            $sql = 'UPDATE `faster_activity_goods` SET ';
            $acti_id_sql = '';
            $update_time_sql = '';
            $ids = '';
            foreach ($find_acgo as $key => $value) {
                // 把活动id字符串转成数组
                $acgo_acti_id = array_unique(explode(',', trim($value->acgo_acti_id, ',')));
                // 去掉数组中的活动id
                $new_acti_id = array_search($request['acti_id'], $acgo_acti_id);
                $v = array_splice($acgo_acti_id, $new_acti_id);
                unset($new_acti_id);
                // 把数组转成字符串
                $new_acgo_acti_id = implode(",", $acgo_acti_id);
                // 更新活动商品表的活动id数据
                $acti_id_sql = $acti_id_sql . ' WHEN ' . $value->acgo_id;
                $acti_id_sql = $acti_id_sql . ' THEN "' . ',' . $new_acgo_acti_id . '"';

                $update_time_sql = $update_time_sql . ' WHEN ' . $value->acgo_id;
                $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';
                $ids = $ids . $value->acgo_id . ',';
            }
            $sql = $sql . ' `acgo_acti_id` = CASE `acgo_id`' . $acti_id_sql . ' END,';
            $sql = $sql . ' `acgo_update_time`=  CASE `acgo_id` ' . $update_time_sql . ' END';
            $sql = $sql . ' WHERE `acgo_id` IN (' . trim($ids, ',') . ')';
            $acgo_res = DB::update($sql);
            if (!$acgo_res) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '删除失败']);
            }
        } elseif ($find_acti->acti_activity_type == '7') { //活动高价回收
            $find_achr = DB::table('activity_high_recycling')
                ->where('achr_acti_id', $request['acti_id'])
                ->select('achr_id', 'achr_goo_id')
                ->get()
                ->toArray();
            $goo_id = array_column($find_achr, 'achr_goo_id');
            $find_acgo = DB::table('activity_goods')
                ->where('acgo_cid', $user_info->adm_cid)
                ->where('acgo_superior_shop_id', $shop_id)
                ->whereIn('acgo_goo_id', $goo_id)
                ->select('acgo_id', 'acgo_goo_id', 'acgo_acti_id')
                ->get()
                ->toArray();
            $sql = 'UPDATE `faster_activity_goods` SET ';
            $acti_id_sql = '';
            $update_time_sql = '';
            $ids = '';
            foreach ($find_acgo as $key => $value) {
                // 把活动id字符串转成数组
                $acgo_acti_id = array_unique(explode(',', trim($value->acgo_acti_id, ',')));
                // 去掉数组中的活动id
                $new_acti_id = array_search($request['acti_id'], $acgo_acti_id);
                $v = array_splice($acgo_acti_id, $new_acti_id);
                unset($new_acti_id);
                // 把数组转成字符串
                $new_acgo_acti_id = implode(",", $acgo_acti_id);
                // 更新活动商品表的活动id数据
                $acti_id_sql = $acti_id_sql . ' WHEN ' . $value->acgo_id;
                $acti_id_sql = $acti_id_sql . ' THEN "' . ',' . $new_acgo_acti_id . '"';

                $update_time_sql = $update_time_sql . ' WHEN ' . $value->acgo_id;
                $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';
                $ids = $ids . $value->acgo_id . ',';
            }
            $sql = $sql . ' `acgo_acti_id` = CASE `acgo_id`' . $acti_id_sql . ' END,';
            $sql = $sql . ' `acgo_update_time`=  CASE `acgo_id` ' . $update_time_sql . ' END';
            $sql = $sql . ' WHERE `acgo_id` IN (' . trim($ids, ',') . ')';
            $acgo_res = DB::update($sql);
            if (!$acgo_res) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '删除失败']);
            }
        } elseif ($find_acti->acti_activity_type == '8') { //大批量采购
            $find_acpr = DB::table('activity_procurement')
                ->where('acpr_acti_id', $request['acti_id'])
                ->select('acpr_id', 'acpr_goo_id')
                ->get()
                ->toArray();
            $goo_id = array_column($find_acpr, 'acpr_goo_id');
            $find_acgo = DB::table('activity_goods')
                ->where('acgo_cid', $user_info->adm_cid)
                ->where('acgo_superior_shop_id', $shop_id)
                ->whereIn('acgo_goo_id', $goo_id)
                ->select('acgo_id', 'acgo_goo_id', 'acgo_acti_id')
                ->get()
                ->toArray();
            $sql = 'UPDATE `faster_activity_goods` SET ';
            $acti_id_sql = '';
            $update_time_sql = '';
            $ids = '';
            foreach ($find_acgo as $key => $value) {
                // 把活动id字符串转成数组
                $acgo_acti_id = array_unique(explode(',', trim($value->acgo_acti_id, ',')));
                // 去掉数组中的活动id
                $new_acti_id = array_search($request['acti_id'], $acgo_acti_id);
                $v = array_splice($acgo_acti_id, $new_acti_id);
                unset($new_acti_id);
                // 把数组转成字符串
                $new_acgo_acti_id = implode(",", $acgo_acti_id);
                // 更新活动商品表的活动id数据
                $acti_id_sql = $acti_id_sql . ' WHEN ' . $value->acgo_id;
                $acti_id_sql = $acti_id_sql . ' THEN "' . ',' . $new_acgo_acti_id . '"';

                $update_time_sql = $update_time_sql . ' WHEN ' . $value->acgo_id;
                $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';
                $ids = $ids . $value->acgo_id . ',';
            }
            $sql = $sql . ' `acgo_acti_id` = CASE `acgo_id`' . $acti_id_sql . ' END,';
            $sql = $sql . ' `acgo_update_time`=  CASE `acgo_id` ' . $update_time_sql . ' END';
            $sql = $sql . ' WHERE `acgo_id` IN (' . trim($ids, ',') . ')';
            $acgo_res = DB::update($sql);
            if (!$acgo_res) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '删除失败']);
            }
        }

        $acti_res = DB::table('activity')
            ->where('acti_id', $request['acti_id'])
            ->update($update_data);

        if ($acti_res) {
            DB::commit();
            Common::addLog($user_info, getRealIp($request), '活动列表', '终止', '活动：' . $find_acti->acti_number . '终止成功');
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => '该活动终止成功']);
        } else {
            DB::rollBack();
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '该活动终止失败']);
        }
    }

    // 新增
    public function add(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyActivityListsController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误', 'error_message' => $error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 判断名称是否存在
        $find_acti_id = DB::table('activity')
            ->where('acti_cid', $user_info->adm_cid)
            ->where('acti_superior_shop_id', $shop_id)
            ->where('acti_delete', 1)
            ->where('acti_name', $request['acti_name'])
            ->select('acti_id')
            ->first();
        if ($find_acti_id) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '活动名称已存在']);
        }

        // 新增活动
        $acti_data['acti_cid'] = $user_info->adm_cid;
        $acti_data['acti_superior_shop_id'] = $shop_id;
        $acti_data['acti_shop_id'] = $user_info->adm_shop_id;
        $acti_data['acti_create_id'] = $user_info->adm_id;
        $acti_data['acti_number'] = 'HD' . rand(10, 99) . date('mdHis') . rand(100000, 999999); //活动编号
        $acti_data['acti_name'] = $request['acti_name']; //活动名称
        $acti_data['acti_activity_nature'] = $request['acti_activity_nature']; //活动性质：1一次性2周期性
        if ($request['acti_activity_nature'] == '1') { //活动性质：1一次性
            if (empty($request['acti_start_time']) || empty($request['acti_end_time'])) {
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '开始时间和结束时间必填']);
            }
            $acti_data['acti_start_time'] = $request['acti_start_time']; //开始时间
            $acti_data['acti_end_time'] = $request['acti_end_time']; //截止时间
            $acti_data['acti_prec_id'] = $request['acti_prec_id'] ? $request['acti_prec_id'] : 0; //客户范围（业务划区）
        } else { //活动性质：2周期性
            if (empty($request['acti_start_time']) || empty($request['acti_activity_days']) || !is_numeric($request['acti_activity_days'])) {
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '开始时间和活动天数必填']);
            }
            $acti_data['acti_start_time'] = $request['acti_start_time']; //开始时间
            $acti_data['acti_activity_days'] = $request['acti_activity_days']; //活动天数
        }
        $acti_data['acti_activity_type'] = $request['acti_activity_type']; //活动类型：1折扣2买送3买赠4满减5现结折扣6累计返点7高价回收8大批量采购
        $acti_data['acti_state'] = 1; //状态：1预备中2已发布3进行中4已过期5终止

        foreach ($request['activityRuleData'] as $key => $value) {
            $acdo_row[] = $value['acdo_row']; //条数
            $acdi_discount[] = $value['acdi_discount']; //折扣
            $acdo_attached_quantity[] = $value['acdo_attached_quantity']; //赠送的商品数量
            $acdo_purchase_quantity[] = $value['acdo_purchase_quantity']; //购买的商品数量
            $acdr_reduction_price[] = $value['acdr_reduction_price']; //订单金额
            $acdr_credit_price[] = $value['acdr_credit_price']; //减免金额
            $accr_transaction_price[] = $value['accr_transaction_price']; //累计返点-交易金额
            $accr_integral[] = $value['accr_integral']; //累计返点-获得积分
            $acpr_goods_quantity[] = $value['acpr_goods_quantity']; //大批量采购-购买数量
            $acpr_recycle_quantity[] = $value['acpr_recycle_quantity']; //大批量采购-文字描述
            $acdo_range[$value['acdo_row']] = $value['acdo_range']; //商品范围1全部商品2品牌3品类4限定商品
            if (in_array($request['acti_activity_type'], [1, 2, 3, 7, 8])) {
                switch ($value['acdo_range']) {
                    case 1: //全部商品
                        $goo_id_arr = $value['goodsDataList']; //商品id
                        $gift_goo_id[$value['acdo_row']] = array_column($goo_id_arr, 'acdo_gift_id');
                        request()->offsetSet('gift_goo_id', $gift_goo_id);
                        break;
                    case 2: //2品牌id
                        $bra_id_arr = $value['brandSelectedData']; //品牌id
                        $goo_bra_id[$value['acdo_row']] = array_column($bra_id_arr, 'bra_id');
                        request()->offsetSet('goo_bra_id', $goo_bra_id);

                        $goo_id_arr = $value['goodsDataList']; //商品id
                        $gift_goo_id[$value['acdo_row']] = array_column($goo_id_arr, 'acdo_gift_id');
                        request()->offsetSet('gift_goo_id', $gift_goo_id);
                        break;
                    case 3: //品类
                        $cate_id_arr = $value['categorySelectedData']; //品类id
                        $goo_cate_id[$value['acdo_row']] = array_column($cate_id_arr, 'cate_id');
                        request()->offsetSet('goo_cate_id', $goo_cate_id);

                        $goo_id_arr = $value['goodsDataList']; //商品id
                        $gift_goo_id[$value['acdo_row']] = array_column($goo_id_arr, 'acdo_gift_id');
                        request()->offsetSet('gift_goo_id', $gift_goo_id);
                        break;
                    case 4: //限定商品
                        $goo_id_arr = $value['goodsDataList']; //商品id
                        if ($request['acti_activity_type'] == 7) {
                            $achr_recycle_quantity = array_column($goo_id_arr, 'achr_recycle_quantity');
                            $achr_recycle_price = array_column($goo_id_arr, 'achr_recycle_price');
                            $goo_id = array_column($goo_id_arr, 'goo_id');
                            request()->offsetSet('achr_recycle_quantity', $achr_recycle_quantity);
                            request()->offsetSet('achr_recycle_price', $achr_recycle_price);
                        } else {
                            $goo_id[$value['acdo_row']] = array_column($goo_id_arr, 'goo_id');
                            $gift_goo_id[$value['acdo_row']] = array_column($goo_id_arr, 'acdo_gift_id');
                            request()->offsetSet('gift_goo_id', $gift_goo_id);
                        }
                        request()->offsetSet('goo_id', $goo_id);
                        break;
                    default:
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '提交的商品参数类型错误']);
                        break;
                }
            }
        }
        request()->offsetSet('acdo_row', $acdo_row);
        request()->offsetSet('acdi_discount', $acdi_discount);
        request()->offsetSet('acdo_attached_quantity', $acdo_attached_quantity);
        request()->offsetSet('acdo_purchase_quantity', $acdo_purchase_quantity);
        request()->offsetSet('acdr_reduction_price', $acdr_reduction_price);
        request()->offsetSet('acdr_credit_price', $acdr_credit_price);
        request()->offsetSet('accr_transaction_price', $accr_transaction_price);
        request()->offsetSet('accr_integral', $accr_integral);
        request()->offsetSet('acpr_goods_quantity', $acpr_goods_quantity);
        request()->offsetSet('acpr_recycle_quantity', $acpr_recycle_quantity);
        request()->offsetSet('acdo_range', $acdo_range);

        DB::beginTransaction();

        $acti_id = DB::table('activity')->insertGetId($acti_data);

        // 活动性质2周期性,修改周期序号
        if ($request['acti_activity_nature'] == '2') {
            $time = date('Y-m-d H:i:s');
            $expire_time = date('Y-m-d', strtotime($request['acti_start_time'] . ' + ' . $request['acti_activity_days'] . ' day'));
            $acti_data['acti_update_time'] = date('Y-m-d H:i:s');
            if ($time > $expire_time) {
                DB::table('activity')
                    ->where('acti_id', $acti_id)
                    ->increment('acti_cycle_number', 1, $acti_data);
            } else {
                $acti_data['acti_cycle_number'] = 1; //周期序号
                $acti_data['acti_update_time'] = date('Y-m-d H:i:s');
                DB::table('activity')
                    ->where('acti_id', $acti_id)
                    ->update($acti_data);
            }
        }

        // 判断活动商品表有没有商品id
        $acgo_id = DB::table('activity_goods')
            ->where('acgo_cid', $user_info->adm_cid)
            ->where('acgo_superior_shop_id', $shop_id)
            ->select('acgo_id', 'acgo_goo_id', 'acgo_acti_id')
            ->get();
        // 转成数组
        $acgo_ids = json_decode(json_encode($acgo_id), true);
        $acgo_goo_id = array_column($acgo_ids, 'acgo_goo_id');
        $acgo_goo_data = array_column($acgo_ids, null, 'acgo_goo_id');
        $n = 0;
        $goo_serial = 0; //添加的活动商品序号
        $new_acgo_goo_id = [];
        //活动类型：1折扣2买送3买赠4满减5现结折扣6累计返点7高价回收8大批量采购
        if ($request['acti_activity_type'] == '1') { //折扣
            // 添加折扣商品
            // 验证数据
            $verify_data = new VerifyActivityListsController;
            $error_message = $verify_data->addsValidator($request->all());
            if ($error_message) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误', 'error_message' => $error_message]);
            }
            // 根据条数
            foreach ($request['acdo_row'] as $row_key => $row_value) {
                if ($request['acdo_range'][$row_value] == 1) { //全部商品
                    $find_goods = DB::table('goods')
                        ->where('goo_cid', $user_info->adm_cid)
                        ->where('goo_superior_shop_id', $shop_id)
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->select('goo_id')
                        ->get()->toArray();
                    if (empty($find_goods)) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无商品！']);
                    }
                    foreach ($find_goods as $goo_key => $goo_value) {
                        $acdi_data[$goo_serial]['acdi_discount'] = $request['acdi_discount'][$row_key] * 100; //折扣
                        $acdi_data[$goo_serial]['acdi_goo_id'] = $goo_value->goo_id; //商品id
                        $acdi_data[$goo_serial]['acdi_row'] = $row_value; //条数
                        $acdi_data[$goo_serial]['acdi_acti_id'] = $acti_id;
                        $acdi_data[$goo_serial]['acdi_range'] = 1;
                        $goo_serial++;

                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value->goo_id, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value->goo_id]['acgo_acti_id'] . ',' . $acti_id;
                            $acgo_update_data['acgo_acti_id'] = $acgo_acti_id;
                            $acgo_update_data['acgo_update_time'] = date('Y-m-d H:i:s');
                            $acgo_edit_id = DB::table('activity_goods')
                                ->where('acgo_id', $acgo_goo_data[$goo_value->goo_id]['acgo_id'])
                                ->update($acgo_update_data);
                        } else {
                            if ($goo_value->goo_id && !in_array($goo_value->goo_id, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                } elseif ($request['acdo_range'][$row_value] == 2) { //根据品牌选定商品
                    $find_goods = DB::table('goods')
                        ->where('goo_cid', $user_info->adm_cid)
                        ->where('goo_superior_shop_id', $shop_id)
                        // 选择品牌参数 '条数'=>'品牌id'，品牌可以选多个，是个数组
                        ->whereIn('goo_bra_id', $request['goo_bra_id'][$row_value])
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->select('goo_id')
                        ->get()->toArray();
                    if (empty($find_goods)) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'已选的品牌暂无商品！']);
                    }

                    foreach ($find_goods as $goo_key => $goo_value) {
                        $acdi_data[$goo_serial]['acdi_discount'] = $request['acdi_discount'][$row_key] * 100; //折扣
                        $acdi_data[$goo_serial]['acdi_goo_id'] = $goo_value->goo_id; //商品id
                        $acdi_data[$goo_serial]['acdi_row'] = $row_value; //条数
                        $acdi_data[$goo_serial]['acdi_acti_id'] = $acti_id;
                        $acdi_data[$goo_serial]['acdi_range'] = 2;
                        $goo_serial++;
                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value->goo_id, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value->goo_id]['acgo_acti_id'] . ',' . $acti_id;
                            $acgo_update_data['acgo_acti_id'] = $acgo_acti_id;
                            $acgo_update_data['acgo_update_time'] = date('Y-m-d H:i:s');
                            $acgo_edit_id = DB::table('activity_goods')
                                ->where('acgo_id', $acgo_goo_data[$goo_value->goo_id]['acgo_id'])
                                ->update($acgo_update_data);
                        } else {
                            if ($goo_value->goo_id && !in_array($goo_value->goo_id, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                } elseif ($request['acdo_range'][$row_value] == 3) { //根据品类选定商品
                    $find_goods = DB::table('goods')
                        ->where('goo_cid', $user_info->adm_cid)
                        ->where('goo_superior_shop_id', $shop_id)
                        // 选择品类参数 '条数'=>'品类id'
                        ->whereIn('goo_cate_id', $request['goo_cate_id'][$row_value])
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->select('goo_id')
                        ->get()->toArray();
                    if (empty($find_goods)) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'已选的品类暂无商品！']);
                    }
                    foreach ($find_goods as $goo_key => $goo_value) {
                        $acdi_data[$goo_serial]['acdi_discount'] = $request['acdi_discount'][$row_key] * 100; //折扣
                        $acdi_data[$goo_serial]['acdi_goo_id'] = $goo_value->goo_id; //商品id
                        $acdi_data[$goo_serial]['acdi_row'] = $row_value; //条数
                        $acdi_data[$goo_serial]['acdi_acti_id'] = $acti_id;
                        $acdi_data[$goo_serial]['acdi_range'] = 3;
                        $goo_serial++;
                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value->goo_id, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value->goo_id]['acgo_acti_id'] . ',' . $acti_id;
                            $acgo_update_data['acgo_acti_id'] = $acgo_acti_id;
                            $acgo_update_data['acgo_update_time'] = date('Y-m-d H:i:s');
                            $acgo_edit_id = DB::table('activity_goods')
                                ->where('acgo_id', $acgo_goo_data[$goo_value->goo_id]['acgo_id'])
                                ->update($acgo_update_data);
                        } else {
                            if ($goo_value->goo_id && !in_array($goo_value->goo_id, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                } elseif ($request['acdo_range'][$row_value] == 4) { //限定商品
                    if (empty($request['goo_id'])) {
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '请选择商品']);
                    }
                    foreach ($request['goo_id'][$row_value] as $goo_key => $goo_value) {
                        $acdi_data[$goo_serial]['acdi_discount'] = $request['acdi_discount'][$row_key] * 100; //折扣
                        $acdi_data[$goo_serial]['acdi_goo_id'] = $goo_value; //商品id
                        $acdi_data[$goo_serial]['acdi_row'] = $row_value; //条数
                        $acdi_data[$goo_serial]['acdi_acti_id'] = $acti_id;
                        $acdi_data[$goo_serial]['acdi_range'] = 4;
                        $goo_serial++;
                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value]['acgo_acti_id'] . ',' . $acti_id;
                            $acgo_update_data['acgo_acti_id'] = $acgo_acti_id;
                            $acgo_update_data['acgo_update_time'] = date('Y-m-d H:i:s');
                            $acgo_edit_id = DB::table('activity_goods')
                                ->where('acgo_id', $acgo_goo_data[$goo_value]['acgo_id'])
                                ->update($acgo_update_data);
                        } else {
                            if ($goo_value && !in_array($goo_value, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                }
            }
            $acdi_id = DB::table('activity_discount')->insert($acdi_data);
            if (isset($acgo_data)) {
                $acgo_ids = DB::table('activity_goods')->insert($acgo_data);
            } else {
                $acgo_ids = true;
            }
            if (isset($acgo_update_data)) {
                $acgo_edit_id = true;
            } else {
                $acgo_edit_id = true;
            }
            if (!$acdi_id || !$acgo_ids || !$acgo_edit_id) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '折扣添加失败']);
            }
        } elseif ($request['acti_activity_type'] == '2') { //买送
            // 添加买送商品
            if (empty($request['acdo_row']) || !is_array($request['acdo_row'])) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '请添加活动商品']);
            }
            foreach ($request['acdo_row'] as $row_key => $row_value) {
                if (
                    !is_numeric($row_value) ||
                    !is_numeric($request['acdo_purchase_quantity'][$row_key]) ||
                    !is_numeric($request['acdo_attached_quantity'][$row_key])
                ) {
                    DB::rollback();
                    return response()->json(['code' => 500, 'msg' => 'error', 'data' => '商品参数类型错误']);
                }
                if ($request['acdo_range'][$row_value] == 1) { //全部商品
                    $find_goods = DB::table('goods')
                        ->where('goo_cid', $user_info->adm_cid)
                        ->where('goo_superior_shop_id', $shop_id)
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->select('goo_id')
                        ->get()->toArray();
                    if (empty($find_goods)) {
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '暂无商品！']);
                    }
                    foreach ($find_goods as $goo_key => $goo_value) {
                        $acdo_data[$goo_serial]['acdo_goo_id'] = $goo_value->goo_id; //商品id
                        $acdo_data[$goo_serial]['acdo_gift_id'] = $goo_value->goo_id; //商品赠品id
                        $acdo_data[$goo_serial]['acdo_purchase_quantity'] = $request['acdo_purchase_quantity'][$row_key]; //购买数量
                        $acdo_data[$goo_serial]['acdo_attached_quantity'] = $request['acdo_attached_quantity'][$row_key]; //附送数量
                        $acdo_data[$goo_serial]['acdo_row'] = $row_value; //条数
                        $acdo_data[$goo_serial]['acdo_acti_id'] = $acti_id;
                        $acdo_data[$goo_serial]['acdo_range'] = 1;
                        $goo_serial++;
                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value->goo_id, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value->goo_id]['acgo_acti_id'] . ',' . $acti_id;

                            $sql = 'UPDATE `faster_activity_goods` SET ';
                            $acgo_acti_id_sql = '';
                            $time_sql = '';
                            $ids = '';

                            $acgo_acti_id_sql = $acgo_acti_id_sql . ' WHEN ' . $acgo_goo_data[$goo_value->goo_id]['acgo_id'] . ' THEN "' . $acgo_acti_id . '"';
                            $time_sql = $time_sql . ' WHEN ' . $acgo_goo_data[$goo_value->goo_id]['acgo_id'] . ' THEN "' . date('Y-m-d H:i:s') . '"';

                            $ids = $ids . $acgo_goo_data[$goo_value->goo_id]['acgo_id'] . ',';
                            $sql = $sql . ' `acgo_acti_id`=  CASE `acgo_id` ' . $acgo_acti_id_sql . ' END,';

                            $sql = $sql . ' `acgo_update_time`=  CASE `acgo_id` ' . $time_sql . ' END';
                            $sql = $sql . ' WHERE `acgo_id` = ' . trim($ids, ',');
                            $acgo_edit_id = DB::update($sql);
                        } else {
                            if ($goo_value->goo_id && !in_array($goo_value->goo_id, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                } elseif ($request['acdo_range'][$row_value] == 2) { //根据品牌选定商品
                    $find_goods = DB::table('goods')
                        ->where('goo_cid', $user_info->adm_cid)
                        ->where('goo_superior_shop_id', $shop_id)
                        // 选择品牌参数 '条数'=>'品牌id'
                        ->whereIn('goo_bra_id', $request['goo_bra_id'][$row_value])
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->select('goo_id')
                        ->get()->toArray();
                    if (empty($find_goods)) {
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '已选的品牌暂无商品！']);
                    }

                    foreach ($find_goods as $goo_key => $goo_value) {
                        $acdo_data[$goo_serial]['acdo_goo_id'] = $goo_value->goo_id; //商品id
                        $acdo_data[$goo_serial]['acdo_gift_id'] = $goo_value->goo_id; //商品赠品id
                        $acdo_data[$goo_serial]['acdo_purchase_quantity'] = $request['acdo_purchase_quantity'][$row_key]; //购买数量
                        $acdo_data[$goo_serial]['acdo_attached_quantity'] = $request['acdo_attached_quantity'][$row_key]; //附送数量
                        $acdo_data[$goo_serial]['acdo_row'] = $row_value; //条数
                        $acdo_data[$goo_serial]['acdo_acti_id'] = $acti_id;
                        $acdo_data[$goo_serial]['acdo_range'] = 2;
                        $goo_serial++;
                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value->goo_id, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value->goo_id]['acgo_acti_id'] . ',' . $acti_id;

                            $sql = 'UPDATE `faster_activity_goods` SET ';
                            $acgo_acti_id_sql = '';
                            $time_sql = '';
                            $ids = '';

                            $acgo_acti_id_sql = $acgo_acti_id_sql . ' WHEN ' . $acgo_goo_data[$goo_value->goo_id]['acgo_id'] . ' THEN "' . $acgo_acti_id . '"';
                            $time_sql = $time_sql . ' WHEN ' . $acgo_goo_data[$goo_value->goo_id]['acgo_id'] . ' THEN "' . date('Y-m-d H:i:s') . '"';

                            $ids = $ids . $acgo_goo_data[$goo_value->goo_id]['acgo_id'] . ',';
                            $sql = $sql . ' `acgo_acti_id`=  CASE `acgo_id` ' . $acgo_acti_id_sql . ' END,';

                            $sql = $sql . ' `acgo_update_time`=  CASE `acgo_id` ' . $time_sql . ' END';
                            $sql = $sql . ' WHERE `acgo_id` = ' . trim($ids, ',');
                            $acgo_edit_id = DB::update($sql);
                        } else {
                            if ($goo_value->goo_id && !in_array($goo_value->goo_id, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                } elseif ($request['acdo_range'][$row_value] == 3) { //根据品类选定商品
                    $find_goods = DB::table('goods')
                        ->where('goo_cid', $user_info->adm_cid)
                        ->where('goo_superior_shop_id', $shop_id)
                        // 选择品类参数 '条数'=>'品类id'
                        ->whereIn('goo_cate_id', $request['goo_cate_id'][$row_value])
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->select('goo_id')
                        ->get()->toArray();
                    if (empty($find_goods)) {
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '已选的品类暂无商品！']);
                    }

                    foreach ($find_goods as $goo_key => $goo_value) {
                        $acdo_data[$goo_serial]['acdo_goo_id'] = $goo_value->goo_id; //商品id
                        $acdo_data[$goo_serial]['acdo_gift_id'] = $goo_value->goo_id; //商品赠品id
                        $acdo_data[$goo_serial]['acdo_purchase_quantity'] = $request['acdo_purchase_quantity'][$row_key]; //购买数量
                        $acdo_data[$goo_serial]['acdo_attached_quantity'] = $request['acdo_attached_quantity'][$row_key]; //附送数量
                        $acdo_data[$goo_serial]['acdo_row'] = $row_value; //条数
                        $acdo_data[$goo_serial]['acdo_acti_id'] = $acti_id;
                        $acdo_data[$goo_serial]['acdo_range'] = 3;
                        $goo_serial++;
                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value->goo_id, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value->goo_id]['acgo_acti_id'] . ',' . $acti_id;

                            $sql = 'UPDATE `faster_activity_goods` SET ';
                            $acgo_acti_id_sql = '';
                            $time_sql = '';
                            $ids = '';

                            $acgo_acti_id_sql = $acgo_acti_id_sql . ' WHEN ' . $acgo_goo_data[$goo_value->goo_id]['acgo_id'] . ' THEN "' . $acgo_acti_id . '"';
                            $time_sql = $time_sql . ' WHEN ' . $acgo_goo_data[$goo_value->goo_id]['acgo_id'] . ' THEN "' . date('Y-m-d H:i:s') . '"';

                            $ids = $ids . $acgo_goo_data[$goo_value->goo_id]['acgo_id'] . ',';
                            $sql = $sql . ' `acgo_acti_id`=  CASE `acgo_id` ' . $acgo_acti_id_sql . ' END,';

                            $sql = $sql . ' `acgo_update_time`=  CASE `acgo_id` ' . $time_sql . ' END';
                            $sql = $sql . ' WHERE `acgo_id` = ' . trim($ids, ',');
                            $acgo_edit_id = DB::update($sql);
                        } else {
                            if ($goo_value->goo_id && !in_array($goo_value->goo_id, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                } elseif ($request['acdo_range'][$row_value] == 4) { //限定商品
                    if (empty($request['goo_id'])) {
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '请选择商品']);
                    }
                    foreach ($request['goo_id'][$row_value] as $goo_key => $goo_value) {
                        $acdo_data[$goo_serial]['acdo_goo_id'] = $goo_value; //商品id
                        $acdo_data[$goo_serial]['acdo_gift_id'] = $request['gift_goo_id'][$row_value][$goo_key]; //商品赠品id
                        $acdo_data[$goo_serial]['acdo_purchase_quantity'] = $request['acdo_purchase_quantity'][$row_key]; //购买数量
                        $acdo_data[$goo_serial]['acdo_attached_quantity'] = $request['acdo_attached_quantity'][$row_key]; //附送数量
                        $acdo_data[$goo_serial]['acdo_row'] = $row_value; //条数
                        $acdo_data[$goo_serial]['acdo_acti_id'] = $acti_id;
                        $acdo_data[$goo_serial]['acdo_range'] = 4;
                        $goo_serial++;
                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value]['acgo_acti_id'] . ',' . $acti_id;

                            $sql = 'UPDATE `faster_activity_goods` SET ';
                            $acgo_acti_id_sql = '';
                            $time_sql = '';
                            $ids = '';

                            $acgo_acti_id_sql = $acgo_acti_id_sql . ' WHEN ' . $acgo_goo_data[$goo_value]['acgo_id'] . ' THEN "' . $acgo_acti_id . '"';
                            $time_sql = $time_sql . ' WHEN ' . $acgo_goo_data[$goo_value]['acgo_id'] . ' THEN "' . date('Y-m-d H:i:s') . '"';

                            $ids = $ids . $acgo_goo_data[$goo_value]['acgo_id'] . ',';
                            $sql = $sql . ' `acgo_acti_id`=  CASE `acgo_id` ' . $acgo_acti_id_sql . ' END,';

                            $sql = $sql . ' `acgo_update_time`=  CASE `acgo_id` ' . $time_sql . ' END';
                            $sql = $sql . ' WHERE `acgo_id` = ' . trim($ids, ',');
                            $acgo_edit_id = DB::update($sql);
                        } else {
                            if ($goo_value && !in_array($goo_value, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                }
            }
            $acdo_id = DB::table('activity_donate')->insert($acdo_data);
            if (isset($acgo_data)) {
                $acgo_id = DB::table('activity_goods')->insert($acgo_data);
            } else {
                $acgo_id = true;
            }
            if (isset($acgo_edit_id)) {
                $acgo_edit_id = true;
            } else {
                $acgo_edit_id = true;
            }
            if (!$acdo_id || !$acgo_id || !$acgo_edit_id) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '买送添加失败']);
            }
        } elseif ($request['acti_activity_type'] == '3') { //买赠
            // 添加买赠商品
            if (empty($request['acdo_row']) || !is_array($request['acdo_row'])) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '请添加活动商品']);
            }
            foreach ($request['acdo_row'] as $row_key => $row_value) {
                if (!is_numeric($row_value) || !is_numeric($request['acdo_purchase_quantity'][$row_key]) || !is_numeric($request['acdo_attached_quantity'][$row_key])) {
                    DB::rollback();
                    return response()->json(['code' => 500, 'msg' => 'error', 'data' => '商品参数类型错误']);
                }
                if ($request['acdo_range'][$row_value] == 1) { //全部商品
                    $find_goods = DB::table('goods')
                        ->where('goo_cid', $user_info->adm_cid)
                        ->where('goo_superior_shop_id', $shop_id)
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->select('goo_id')
                        ->get()->toArray();
                    if (empty($find_goods)) {
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '暂无商品！']);
                    }
                    foreach ($find_goods as $goo_key => $goo_value) {
                        $acdo_data[$goo_serial]['acdo_goo_id'] = $goo_value->goo_id; //商品id
                        $acdo_data[$goo_serial]['acdo_gift_id'] = $request['gift_goo_id'][$row_value][0]; //商品赠品id
                        $acdo_data[$goo_serial]['acdo_purchase_quantity'] = $request['acdo_purchase_quantity'][$row_key]; //购买数量
                        $acdo_data[$goo_serial]['acdo_attached_quantity'] = $request['acdo_attached_quantity'][$row_key]; //附送数量
                        $acdo_data[$goo_serial]['acdo_row'] = $row_value; //条数
                        $acdo_data[$goo_serial]['acdo_acti_id'] = $acti_id;
                        $acdo_data[$goo_serial]['acdo_range'] = 1;
                        $goo_serial++;
                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value->goo_id, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value->goo_id]['acgo_acti_id'] . ',' . $acti_id;
                            $acgo_update_data['acgo_acti_id'] = $acgo_acti_id;
                            $acgo_update_data['acgo_update_time'] = date('Y-m-d H:i:s');
                            $acgo_edit_id = DB::table('activity_goods')
                                ->where('acgo_id', $acgo_goo_data[$goo_value->goo_id]['acgo_id'])
                                ->update($acgo_update_data);
                        } else {
                            if ($goo_value->goo_id && !in_array($goo_value->goo_id, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                } elseif ($request['acdo_range'][$row_value] == 2) { //根据品牌选定商品
                    $find_goods = DB::table('goods')
                        ->where('goo_cid', $user_info->adm_cid)
                        ->where('goo_superior_shop_id', $shop_id)
                        // 选择品牌参数 '条数'=>'品牌id'
                        ->whereIn('goo_bra_id', $request['goo_bra_id'][$row_value])
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->select('goo_id')
                        ->get()->toArray();
                    if (empty($find_goods)) {
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '已选的品牌暂无商品！']);
                    }
                    foreach ($find_goods as $goo_key => $goo_value) {
                        $acdo_data[$goo_serial]['acdo_goo_id'] = $goo_value->goo_id; //商品id
                        $acdo_data[$goo_serial]['acdo_gift_id'] = $request['gift_goo_id'][$row_value][0]; //商品赠品id
                        $acdo_data[$goo_serial]['acdo_purchase_quantity'] = $request['acdo_purchase_quantity'][$row_key]; //购买数量
                        $acdo_data[$goo_serial]['acdo_attached_quantity'] = $request['acdo_attached_quantity'][$row_key]; //附送数量
                        $acdo_data[$goo_serial]['acdo_row'] = $row_value; //条数
                        $acdo_data[$goo_serial]['acdo_acti_id'] = $acti_id;
                        $acdo_data[$goo_serial]['acdo_range'] = 2;
                        $goo_serial++;
                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value->goo_id, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value->goo_id]['acgo_acti_id'] . ',' . $acti_id;
                            $acgo_update_data['acgo_acti_id'] = $acgo_acti_id;
                            $acgo_update_data['acgo_update_time'] = date('Y-m-d H:i:s');
                            $acgo_edit_id = DB::table('activity_goods')
                                ->where('acgo_id', $acgo_goo_data[$goo_value->goo_id]['acgo_id'])
                                ->update($acgo_update_data);
                        } else {
                            if ($goo_value->goo_id && !in_array($goo_value->goo_id, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                } elseif ($request['acdo_range'][$row_value] == 3) { //根据品类选定商品
                    $find_goods = DB::table('goods')
                        ->where('goo_cid', $user_info->adm_cid)
                        ->where('goo_superior_shop_id', $shop_id)
                        // 选择品类参数 '条数'=>'品类id'
                        ->whereIn('goo_cate_id', $request['goo_cate_id'][$row_value])
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->select('goo_id')
                        ->get()->toArray();
                    if (empty($find_goods)) {
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '已选的品类暂无商品！']);
                    }
                    foreach ($find_goods as $goo_key => $goo_value) {
                        $acdo_data[$goo_serial]['acdo_goo_id'] = $goo_value->goo_id; //商品id
                        $acdo_data[$goo_serial]['acdo_gift_id'] = $request['gift_goo_id'][$row_value][0]; //商品赠品id
                        $acdo_data[$goo_serial]['acdo_purchase_quantity'] = $request['acdo_purchase_quantity'][$row_key]; //购买数量
                        $acdo_data[$goo_serial]['acdo_attached_quantity'] = $request['acdo_attached_quantity'][$row_key]; //附送数量
                        $acdo_data[$goo_serial]['acdo_row'] = $row_value; //条数
                        $acdo_data[$goo_serial]['acdo_acti_id'] = $acti_id;
                        $acdo_data[$goo_serial]['acdo_range'] = 3;
                        $goo_serial++;
                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value->goo_id, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value->goo_id]['acgo_acti_id'] . ',' . $acti_id;
                            $acgo_update_data['acgo_acti_id'] = $acgo_acti_id;
                            $acgo_update_data['acgo_update_time'] = date('Y-m-d H:i:s');
                            $acgo_edit_id = DB::table('activity_goods')
                                ->where('acgo_id', $acgo_goo_data[$goo_value->goo_id]['acgo_id'])
                                ->update($acgo_update_data);
                        } else {
                            if ($goo_value->goo_id && !in_array($goo_value->goo_id, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                } elseif ($request['acdo_range'][$row_value] == 4) { //限定商品
                    if (empty($request['goo_id'])) {
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '请选择商品']);
                    }
                    foreach ($request['goo_id'][$row_value] as $goo_key => $goo_value) {
                        $acdo_data[$goo_serial]['acdo_goo_id'] = $goo_value; //商品id
                        $acdo_data[$goo_serial]['acdo_gift_id'] = $request['gift_goo_id'][$row_value][$goo_key]; //商品赠品id
                        $acdo_data[$goo_serial]['acdo_purchase_quantity'] = $request['acdo_purchase_quantity'][$row_key]; //购买数量
                        $acdo_data[$goo_serial]['acdo_attached_quantity'] = $request['acdo_attached_quantity'][$row_key]; //附送数量
                        $acdo_data[$goo_serial]['acdo_row'] = $row_value; //条数
                        $acdo_data[$goo_serial]['acdo_acti_id'] = $acti_id;
                        $acdo_data[$goo_serial]['acdo_range'] = 4;
                        $goo_serial++;
                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value]['acgo_acti_id'] . ',' . $acti_id;
                            $acgo_update_data['acgo_acti_id'] = $acgo_acti_id;
                            $acgo_update_data['acgo_update_time'] = date('Y-m-d H:i:s');
                            $acgo_edit_id = DB::table('activity_goods')
                                ->where('acgo_id', $acgo_goo_data[$goo_value]['acgo_id'])
                                ->update($acgo_update_data);
                        } else {
                            if ($goo_value && !in_array($goo_value, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                }
            }
            $acdo_id = DB::table('activity_donate')->insert($acdo_data);
            if (isset($acgo_data)) {
                $acgo_id = DB::table('activity_goods')->insert($acgo_data);
            } else {
                $acgo_id = true;
            }
            if (isset($acgo_update_data)) {
                $acgo_edit_id = true;
            } else {
                $acgo_edit_id = true;
            }
            if (!$acdo_id || !$acgo_id || !$acgo_edit_id) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '买赠添加失败']);
            }
        } elseif ($request['acti_activity_type'] == '4') { //满减
            // 添加满减
            if (empty($request['acdr_reduction_price']) || !is_array($request['acdr_reduction_price'])) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误']);
            }
            foreach ($request['acdr_reduction_price'] as $key => $value) {
                if (
                    !is_numeric($value) ||
                    !is_numeric($request['acdr_credit_price'][$key]) ||
                    !is_numeric($request['acdo_row'][$key])
                ) {
                    DB::rollback();
                    return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数类型错误']);
                }
                $acdr_data[$key]['acdr_reduction_price'] = $value * 100; //满减金额（单位：分）
                $acdr_data[$key]['acdr_credit_price'] = $request['acdr_credit_price'][$key] * 100; //减免金额（单位：分）
                $acdr_data[$key]['acdr_row'] = $request['acdo_row'][$key]; //条数
                $acdr_data[$key]['acdr_acti_id'] = $acti_id;
            }
            $acdo_id = DB::table('activity_discount_reduction')->insert($acdr_data);
            if (!$acdo_id) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '满减添加失败']);
            }
        } elseif ($request['acti_activity_type'] == '5') { //现结折扣
            // 添加现结折扣
            if (empty($request['acdr_reduction_price']) || !is_array($request['acdr_reduction_price'])) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误']);
            }
            foreach ($request['acdr_reduction_price'] as $key => $value) {
                if (
                    !is_numeric($value) ||
                    !is_numeric($request['acdi_discount'][$key]) ||
                    !is_numeric($request['acdo_row'][$key])
                ) {
                    DB::rollback();
                    return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数类型错误']);
                }
                $acdr_data[$key]['acdr_reduction_price'] = $value * 100; //订单金额（单位：分）
                $acdr_data[$key]['acdr_discount'] = $request['acdi_discount'][$key] * 100; //折扣
                $acdr_data[$key]['acdr_row'] = $request['acdo_row'][$key]; //条数
                $acdr_data[$key]['acdr_acti_id'] = $acti_id;
            }
            $acdo_id = DB::table('activity_discount_reduction')->insert($acdr_data);
            if (!$acdo_id) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '现结折扣添加失败']);
            }
        } elseif ($request['acti_activity_type'] == '6') { //累计返点
            // 累计返点
            if (
                empty($request['accp_integral']) ||
                empty($request['accp_transaction_price']) || empty($request['accr_transaction_price'])
            ) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误']);
            }
            $accp_data['accp_acti_id'] = $acti_id;
            $accp_data['accp_transaction_price'] = $request['accp_transaction_price'] * 100; //兑现金额（单位：分）
            $accp_data['accp_integral'] = $request['accp_integral']; //兑现积分
            $accp_id = DB::table('activity_cash_points')->insert($accp_data);

            foreach ($request['accr_transaction_price'] as $key => $value) {
                if (!is_numeric($value) || !is_numeric($request['accr_integral'][$key]) || !is_numeric($request['acdo_row'][$key])) {
                    DB::rollback();
                    return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数类型错误']);
                }
                $accr_data[$key]['accr_transaction_price'] = $value * 100; //交易金额（单位：分）
                $accr_data[$key]['accr_integral'] = $request['accr_integral'][$key]; //积分
                $accr_data[$key]['accr_row'] = $request['acdo_row'][$key]; //条数
                $accr_data[$key]['accr_acti_id'] = $acti_id;
            }
            $accr_id = DB::table('activity_cumulative_rebates')->insert($accr_data);
            if (!$accp_id || !$accr_id) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '累计返点添加失败']);
            }
        } elseif ($request['acti_activity_type'] == '7') { //高价回收
            // 添加高价回收
            if (empty($request['goo_id']) || !is_array($request['goo_id'])) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误']);
            }

            foreach ($request['goo_id'] as $goo_key => $goo_value) {
                if ($request['achr_recycle_quantity'][$goo_key] < 0 || !is_numeric($request['achr_recycle_quantity'][$goo_key]) || $request['achr_recycle_price'][$goo_key] < 0 || !is_numeric($request['achr_recycle_price'][$goo_key])) {
                    DB::rollback();
                    return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数类型错误']);
                }
                $achr_data[$goo_key]['achr_acti_id'] = $acti_id;
                $achr_data[$goo_key]['achr_goo_id'] = $goo_value; //商品id
                $achr_data[$goo_key]['achr_recycle_quantity'] = $request['achr_recycle_quantity'][$goo_key]; //回收数量
                $achr_data[$goo_key]['achr_recycle_price'] = $request['achr_recycle_price'][$goo_key] * 100; //回收价格
                $achr_data[$goo_key]['achr_range'] = 4;
                // 如果没有商品,在商品活动表添加
                if (in_array($goo_value, $acgo_goo_id)) {
                    $acgo_acti_id = $acgo_goo_data[$goo_value]['acgo_acti_id'] . ',' . $acti_id;
                    $acgo_update_data['acgo_acti_id'] = $acgo_acti_id;
                    $acgo_update_data['acgo_update_time'] = date('Y-m-d H:i:s');
                    $acgo_edit_id = DB::table('activity_goods')
                        ->where('acgo_id', $acgo_goo_data[$goo_value]['acgo_id'])
                        ->update($acgo_update_data);
                    if (!$acgo_edit_id) {
                        DB::rollBack();
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '活动商品表编辑失败']);
                    }
                } else {
                    if ($goo_value && !in_array($goo_value, $new_acgo_goo_id)) {
                        $new_acgo_goo_id[] = $goo_value;
                        $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                        $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                        $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                        $acgo_data[$n]['acgo_goo_id'] = $goo_value;
                        $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                        $n++;
                    }
                }
            }

            $achr_id = DB::table('activity_high_recycling')->insert($achr_data);
            if (isset($acgo_data)) {
                $acgo_id = DB::table('activity_goods')->insert($acgo_data);
            } else {
                $acgo_id = true;
            }
            if (!$achr_id || !$acgo_id) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '高价回收添加失败']);
            }
        } elseif ($request['acti_activity_type'] == '8') { //大批量采购
            // 大批量采购
            // acpr_range 商品范围1全部商品2限定品牌3限定品类4限定商品
            if (empty($request['acdo_row']) || !is_array($request['acdo_row'])) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误']);
            }
            foreach ($request['acdo_row'] as $row_key => $row_value) {
                if (!is_numeric($row_value) || !is_numeric($request['acpr_goods_quantity'][$row_key])) {
                    DB::rollback();
                    return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数类型错误']);
                }
                if ($request['acdo_range'][$row_value] == 1) { //全部商品
                    $find_goods = DB::table('goods')
                        ->where('goo_cid', $user_info->adm_cid)
                        ->where('goo_superior_shop_id', $shop_id)
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->select('goo_id')
                        ->get()->toArray();
                    if (empty($find_goods)) {
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '暂无商品！']);
                    }
                    foreach ($find_goods as $goo_key => $goo_value) {
                        $acpr_data[$goo_serial]['acpr_acti_id'] = $acti_id;
                        $acpr_data[$goo_serial]['acpr_goo_id'] = $goo_value->goo_id; //商品id
                        $acpr_data[$goo_serial]['acpr_goods_quantity'] = $request['acpr_goods_quantity'][$row_key]; //商品购买数量
                        $acpr_data[$goo_serial]['acpr_recycle_quantity'] = $request['acpr_recycle_quantity'][$row_key]; //商品赠送礼品-文字描述
                        $acpr_data[$goo_serial]['acpr_row'] = $row_value; //条数
                        $acpr_data[$goo_serial]['acpr_range'] = 1;
                        $goo_serial++;
                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value->goo_id, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value->goo_id]['acgo_acti_id'] . ',' . $acti_id;
                            $acgo_update_data['acgo_acti_id'] = $acgo_acti_id;
                            $acgo_update_data['acgo_update_time'] = date('Y-m-d H:i:s');
                            $acgo_edit_id = DB::table('activity_goods')
                                ->where('acgo_id', $acgo_goo_data[$goo_value->goo_id]['acgo_id'])
                                ->update($acgo_update_data);
                        } else {
                            if ($goo_value->goo_id && !in_array($goo_value->goo_id, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                } elseif ($request['acdo_range'][$row_value] == 2) { //根据品牌选定商品
                    $find_goods = DB::table('goods')
                        ->where('goo_cid', $user_info->adm_cid)
                        ->where('goo_superior_shop_id', $shop_id)
                        // 选择品牌参数 '条数'=>'品牌id'
                        ->whereIn('goo_bra_id', $request['goo_bra_id'][$row_value])
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->select('goo_id')
                        ->get()->toArray();
                    if (empty($find_goods)) {
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '已选的品牌暂无商品！']);
                    }
                    foreach ($find_goods as $goo_key => $goo_value) {
                        $acpr_data[$goo_serial]['acpr_acti_id'] = $acti_id;
                        $acpr_data[$goo_serial]['acpr_goo_id'] = $goo_value->goo_id; //商品id
                        $acpr_data[$goo_serial]['acpr_goods_quantity'] = $request['acpr_goods_quantity'][$row_key]; //商品数量
                        $acpr_data[$goo_serial]['acpr_recycle_quantity'] = $request['acpr_recycle_quantity'][$row_key]; //商品赠送礼品-文字描述
                        $acpr_data[$goo_serial]['acpr_row'] = $row_value; //条数
                        $acpr_data[$goo_serial]['acpr_range'] = 2;
                        $goo_serial++;
                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value->goo_id, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value->goo_id]['acgo_acti_id'] . ',' . $acti_id;
                            $acgo_update_data['acgo_acti_id'] = $acgo_acti_id;
                            $acgo_update_data['acgo_update_time'] = date('Y-m-d H:i:s');
                            $acgo_edit_id = DB::table('activity_goods')
                                ->where('acgo_id', $acgo_goo_data[$goo_value->goo_id]['acgo_id'])
                                ->update($acgo_update_data);
                        } else {
                            if ($goo_value->goo_id && !in_array($goo_value->goo_id, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                } elseif ($request['acdo_range'][$row_value] == 3) { //根据品类选定商品
                    $find_goods = DB::table('goods')
                        ->where('goo_cid', $user_info->adm_cid)
                        ->where('goo_superior_shop_id', $shop_id)
                        // 选择品类参数 '条数'=>'品类id'
                        ->whereIn('goo_cate_id', $request['goo_cate_id'][$row_value])
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->select('goo_id')
                        ->get()->toArray();
                    if (empty($find_goods)) {
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '已选的品类暂无商品！']);
                    }
                    foreach ($find_goods as $goo_key => $goo_value) {
                        $acpr_data[$goo_serial]['acpr_acti_id'] = $acti_id;
                        $acpr_data[$goo_serial]['acpr_goo_id'] = $goo_value->goo_id; //商品id
                        $acpr_data[$goo_serial]['acpr_goods_quantity'] = $request['acpr_goods_quantity'][$row_key]; //商品数量
                        $acpr_data[$goo_serial]['acpr_recycle_quantity'] = $request['acpr_recycle_quantity'][$row_key]; //商品赠送礼品-文字描述
                        $acpr_data[$goo_serial]['acpr_row'] = $row_value; //条数
                        $acpr_data[$goo_serial]['acpr_range'] = 3;
                        $goo_serial++;
                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value->goo_id, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value->goo_id]['acgo_acti_id'] . ',' . $acti_id;
                            $acgo_update_data['acgo_acti_id'] = $acgo_acti_id;
                            $acgo_update_data['acgo_update_time'] = date('Y-m-d H:i:s');
                            $acgo_edit_id = DB::table('activity_goods')
                                ->where('acgo_id', $acgo_goo_data[$goo_value->goo_id]['acgo_id'])
                                ->update($acgo_update_data);
                        } else {
                            if ($goo_value->goo_id && !in_array($goo_value->goo_id, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value->goo_id;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                } elseif ($request['acdo_range'][$row_value] == 4) { //限定商品
                    if (empty($request['goo_id'])) {
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '请选择商品']);
                    }
                    foreach ($request['goo_id'][$row_value] as $goo_key => $goo_value) {
                        $acpr_data[$goo_serial]['acpr_acti_id'] = $acti_id;
                        $acpr_data[$goo_serial]['acpr_goo_id'] = $goo_value; //商品id
                        $acpr_data[$goo_serial]['acpr_goods_quantity'] = $request['acpr_goods_quantity'][$row_key]; //商品数量
                        $acpr_data[$goo_serial]['acpr_recycle_quantity'] = $request['acpr_recycle_quantity'][$row_key]; //商品赠送礼品-文字描述
                        $acpr_data[$goo_serial]['acpr_row'] = $row_value; //条数
                        $acpr_data[$goo_serial]['acpr_range'] = 4;
                        $goo_serial++;
                        // 如果没有商品,在商品活动表添加
                        if (in_array($goo_value, $acgo_goo_id)) {
                            $acgo_acti_id = $acgo_goo_data[$goo_value]['acgo_acti_id'] . ',' . $acti_id;
                            $acgo_update_data['acgo_acti_id'] = $acgo_acti_id;
                            $acgo_update_data['acgo_update_time'] = date('Y-m-d H:i:s');
                            $acgo_edit_id = DB::table('activity_goods')
                                ->where('acgo_id', $acgo_goo_data[$goo_value]['acgo_id'])
                                ->update($acgo_update_data);
                        } else {
                            if ($goo_value && !in_array($goo_value, $new_acgo_goo_id)) {
                                $new_acgo_goo_id[] = $goo_value;
                                $acgo_data[$n]['acgo_cid'] = $user_info->adm_cid;
                                $acgo_data[$n]['acgo_superior_shop_id'] = $shop_id;
                                $acgo_data[$n]['acgo_shop_id'] = $user_info->adm_shop_id;
                                $acgo_data[$n]['acgo_goo_id'] = $goo_value;
                                $acgo_data[$n]['acgo_acti_id'] = ',' . $acti_id;
                                $n++;
                            }
                        }
                    }
                }
            }
            $acpr_id = DB::table('activity_procurement')->insert($acpr_data);
            if (isset($acgo_data)) {
                $acgo_id = DB::table('activity_goods')->insert($acgo_data);
            } else {
                $acgo_id = true;
            }
            if (isset($acgo_update_data)) {
                $acgo_edit_id = true;
            } else {
                $acgo_edit_id = true;
            }
            if (!$acpr_id || !$acgo_id) {
                DB::rollback();
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '大批量采购添加失败']);
            }
        }
        if ($acti_id) {
            DB::commit();
            Common::addLog($user_info, getRealIp($request), '活动列表', '新增', '活动：' . $acti_data['acti_number'] . '新增成功');
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => '添加成功']);
        } else {
            DB::rollBack();
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '添加失败']);
        }
    }

    // 详情
    public function info(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyActivityListsController;
        $error_message = $verify_data->deliveryValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误', 'error_message' => $error_message]);
        }

        $res = $this->infos($request->all());
        if ($res['code'] == 200) {
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $res['data']]);
        } else {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '暂无数据']);
        }
    }

    // 明细
    public function details(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyActivityListsController;
        $error_message = $verify_data->deliveryValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误', 'error_message' => $error_message]);
        }

        $search_data = $request->all();

        $find_acti = DB::table('activity as acti')
            ->where('acti_id', $request['acti_id'])
            ->select('acti_id', 'acti_name', 'acti_number', 'acti_start_time', 'acti_end_time', 'acti_activity_type', 'acti_activity_nature', 'acti_state', 'acti_activity_days', 'acti_cycle_number')
            ->first();
        if ($find_acti->acti_activity_type == '1') {
            // 活动折扣
            $find_acdi = DB::table('activity_discount')
                ->where('acdi_acti_id', $request['acti_id'])
                ->select('acdi_discount', 'acdi_row')
                ->get();
            $find_order = DB::table('order as ord')
                ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
                ->where('ord_acti_id', $request['acti_id'])
                ->where('ord_delete', 1)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_order_number'])) {
                        $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                    }
                })
                ->select('ord_id', 'ord_create_time', 'orcl_channel_unit', 'ord_order_number', 'ord_order_price', 'ord_goods_quantity', 'ord_wor_state', 'ord_acti_id', 'ord_acti_row', 'ord_type', 'orcl_name')
                ->get();
            $data['find_order'] = $find_order;
            $data['find_acdi'] = $find_acdi;
        } elseif ($find_acti->acti_activity_type == '2') {
            // 买送
            $find_acdo = DB::table('activity_donate')
                ->where('acdo_acti_id', $request['acti_id'])
                ->select('acdo_id', 'acdo_goo_id', 'acdo_gift_id', 'acdo_purchase_quantity', 'acdo_attached_quantity', 'acdo_row')
                ->get();
            $find_order = DB::table('order as ord')
                ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
                ->where('ord_acti_id', $request['acti_id'])
                ->where('ord_delete', 1)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_order_number'])) {
                        $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                    }
                })
                ->select('ord_id', 'ord_create_time', 'orcl_channel_unit', 'ord_order_number', 'ord_order_price', 'ord_goods_quantity', 'ord_wor_state', 'ord_acti_id', 'ord_acti_row', 'ord_type', 'orcl_name')
                ->get();
            $data['find_order'] = $find_order;
            $data['find_acdo'] = $find_acdo;
        } elseif ($find_acti->acti_activity_type == '3') {
            // 买赠
            $find_acdo = DB::table('activity_donate')
                ->where('acdo_acti_id', $request['acti_id'])
                ->select('acdo_id', 'acdo_goo_id', 'acdo_gift_id', 'acdo_purchase_quantity', 'acdo_attached_quantity', 'acdo_row')
                ->get();
            $find_order = DB::table('order as ord')
                ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
                ->where('ord_acti_id', $request['acti_id'])
                ->where('ord_delete', 1)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_order_number'])) {
                        $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                    }
                })
                ->select('ord_id', 'ord_create_time', 'orcl_channel_unit', 'ord_order_number', 'ord_order_price', 'ord_goods_quantity', 'ord_wor_state', 'ord_type', 'orcl_name', 'ord_acti_id', 'ord_acti_row')
                ->get();
            $data['find_order'] = $find_order;
            $data['find_acdo'] = $find_acdo;
        } elseif ($find_acti->acti_activity_type == '4') {
            // 满减
            $find_acdr = DB::table('activity_discount_reduction')
                ->where('acdr_acti_id', $request['acti_id'])
                ->select('acdr_id', 'acdr_reduction_price', 'acdr_credit_price', 'acdr_row')
                ->get();
            $find_order = DB::table('order as ord')
                ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
                ->where('ord_acti_id', $request['acti_id'])
                ->where('ord_delete', 1)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_order_number'])) {
                        $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                    }
                })
                ->select('ord_id', 'ord_create_time', 'orcl_channel_unit', 'ord_order_number', 'ord_order_price', 'ord_goods_quantity', 'ord_wor_state', 'ord_type', 'orcl_name', 'ord_acti_id', 'ord_acti_row')
                ->get();
            $data['find_order'] = $find_order;
            $data['find_acdr'] = $find_acdr;
        } elseif ($find_acti->acti_activity_type == '5') {
            // 现结折扣
            $find_acdr = DB::table('activity_discount_reduction')
                ->where('acdr_acti_id', $request['acti_id'])
                ->select('acdr_id', 'acdr_reduction_price', 'acdr_discount', 'acdr_row')
                ->get();
            $find_order = DB::table('order as ord')
                ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
                ->where('ord_acti_id', $request['acti_id'])
                ->where('ord_delete', 1)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_order_number'])) {
                        $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                    }
                })
                ->select('ord_id', 'ord_create_time', 'orcl_channel_unit', 'ord_order_number', 'ord_order_price', 'ord_goods_quantity', 'ord_wor_state', 'ord_type', 'orcl_name', 'ord_acti_id', 'ord_acti_row')
                ->get();
            $data['find_order'] = $find_order;
            $data['find_acdr'] = $find_acdr;
        } elseif ($find_acti->acti_activity_type == '6') {
            // 积分兑现
            $find_accp = DB::table('activity_cash_points')
                ->where('accp_acti_id', $request['acti_id'])
                ->select('accp_id', 'accp_transaction_price', 'accp_integral')
                ->first();
            // 累计返点
            $find_accr = DB::table('activity_cumulative_rebates')
                ->where('accr_acti_id', $request['acti_id'])
                ->select('accr_id', 'accr_transaction_price', 'accr_integral', 'accr_row')
                ->get();
            $find_order = DB::table('order as ord')
                ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
                ->where('ord_acti_id', $request['acti_id'])
                ->where('ord_delete', 1)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_order_number'])) {
                        $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                    }
                })
                ->select('ord_id', 'ord_create_time', 'orcl_channel_unit', 'ord_order_number', 'ord_order_price', 'ord_goods_quantity', 'ord_wor_state', 'ord_type', 'orcl_name', 'ord_acti_id', 'ord_acti_row')
                ->get();
            $data['find_order'] = $find_order;
            $data['find_accp'] = $find_accp;
            $data['find_accr'] = $find_accr;
        } elseif ($find_acti->acti_activity_type == '7') {
            // 高价回收
            $find_achr = DB::table('activity_high_recycling')
                ->where('achr_acti_id', $request['acti_id'])
                ->select('achr_id', 'achr_goo_id', 'achr_recycle_quantity', 'achr_recycle_price')
                ->get();
            $find_order = DB::table('order as ord')
                ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
                ->where('ord_acti_id', $request['acti_id'])
                ->where('ord_delete', 1)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_order_number'])) {
                        $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                    }
                })
                ->select('ord_id', 'ord_create_time', 'orcl_channel_unit', 'ord_order_number', 'ord_order_price', 'ord_goods_quantity', 'ord_wor_state', 'ord_type', 'orcl_name', 'ord_acti_id', 'ord_acti_row')
                ->get();
            $data['find_order'] = $find_order;
            $data['find_achr'] = $find_achr;
        } elseif ($find_acti->acti_activity_type == '8') {
            // 大批量采购
            $find_acpr = DB::table('activity_procurement')
                ->where('acpr_acti_id', $request['acti_id'])
                ->select('acpr_id', 'acpr_goo_id', 'acpr_goods_quantity', 'acpr_recycle_quantity', 'acpr_row')
                ->get();
            $find_order = DB::table('order as ord')
                ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
                ->where('ord_acti_id', $request['acti_id'])
                ->where('ord_delete', 1)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_order_number'])) {
                        $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                    }
                })
                ->select('ord_id', 'ord_create_time', 'orcl_channel_unit', 'ord_order_number', 'ord_order_price', 'ord_goods_quantity', 'ord_wor_state', 'ord_type', 'orcl_name', 'ord_acti_id', 'ord_acti_row')
                ->get();
            $data['find_order'] = $find_order;
            $data['find_acpr'] = $find_acpr;
        }
        $data['find_acti'] = $find_acti;
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data]);
    }

    // 工作总台--查询活动名称
    public function searchActivity(Request $request)
    {
        // 验证数据
        if (empty($request['goo_id']) || !is_array($request['goo_id'])) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 查询工作总台选择的商品相关的活动
        $find_acgo = DB::table('activity_goods')
            ->where('acgo_cid', $user_info->adm_cid)
            ->where('acgo_superior_shop_id', $shop_id)
            ->where('acgo_shop_id', $user_info->adm_shop_id)
            ->whereIn('acgo_goo_id', $request['goo_id'])
            ->select('acgo_acti_id')
            ->get();
        $acgo_acti_id = explode(',', $find_acgo);
        $find_actis = DB::table('activity')
            ->whereIn('acti_id', $acgo_acti_id)
            ->where('acti_state', 3)
            ->where('acti_activity_type', '!=', 7)
            ->select('acti_id', 'acti_name', 'acti_number', 'acti_activity_type')
            ->get()->toArray();
        // dump($find_actis);
        // 查询满减、现结折扣、累计返点的活动,正在进行中的
        $find_no_goods_acti = DB::table('activity')
            ->where('acti_cid', $user_info->adm_cid)
            ->where('acti_superior_shop_id', $user_info->adm_cid)
            ->where('acti_shop_id', $user_info->adm_shop_id)
            ->where('acti_state', 3)
            ->whereIn('acti_activity_type', [4, 5])
            ->select('acti_id', 'acti_name', 'acti_number', 'acti_activity_type')
            ->get()->toArray();
        $find_acti_name = array_merge($find_actis, $find_no_goods_acti);
        $data['find_acti'] = $find_acti_name;
        foreach ($data['find_acti'] as $key => $value) {
            // acti_activity_type   活动类型：1折扣2买送3买赠4满减5现结折扣6累计返点7高价回收8大批量采购
            if ($value->acti_activity_type == '1') {
                $find_acdi = DB::table('activity_discount as acdi')
                    ->leftjoin('goods as g', 'g.goo_id', '=', 'acdi.acdi_goo_id')
                    ->whereIn('acdi_goo_id', $request['goo_id'])
                    ->select('acdi_acti_id', 'acdi_goo_id', 'acdi_discount', 'acdi_row', 'goo_name', 'goo_goods_encode', 'goo_type', 'acdi_range')
                    ->get()->toArray();
                $acdi_row_data = [];
                foreach ($find_acdi as $key => $value) {
                    $acdi_row_data[$value->acdi_acti_id]['acdi_acti_id'] = $value->acdi_acti_id; //活动id
                    $acdi_row_data[$value->acdi_acti_id]['acdi_discount'] = $value->acdi_discount; //折扣
                    $acdi_row_data[$value->acdi_acti_id]['acdi_row'] = $value->acdi_row; //条数
                    $acdi_row_data[$value->acdi_acti_id]['acdi_range'] = $value->acdi_range; //商品范围1全部商品2限定品牌3限定品类4限定商品
                    // 选择商品,返回选择的商品
                    $goods['goo_id'] = $value->acdi_goo_id;
                    $goods['goo_name'] = $value->goo_name;
                    $goods['goo_goods_encode'] = $value->goo_goods_encode;
                    $goods['goo_type'] = $value->goo_type;
                    $acdi_row_data[$value->acdi_acti_id]['goods'][] = $goods;
                }
                $data['find_acdi'] = $acdi_row_data;
            } elseif ($value->acti_activity_type == '2') {
                // 买送
                $find_acdo = DB::table('activity_donate as acdo')
                    ->leftjoin('goods as g', 'g.goo_id', '=', 'acdo.acdo_goo_id')
                    ->whereIn('acdo_goo_id', $request['goo_id'])
                    ->select('acdo_id', 'acdo_acti_id', 'acdo_goo_id', 'acdo_gift_id', 'goo_name', 'goo_goods_encode', 'acdo_purchase_quantity', 'acdo_attached_quantity', 'acdo_row', 'acdo_range', 'goo_type')
                    ->get()->toArray();
                $acdo_row_data = [];
                $acdo_gift_id = [];
                foreach ($find_acdo as $key => $value) {
                    $acdo_row_data[$key]['acdo_id'] = $value->acdo_id;
                    $acdo_row_data[$key]['acdo_acti_id'] = $value->acdo_acti_id;
                    $acdo_row_data[$key]['acdo_purchase_quantity'] = $value->acdo_purchase_quantity;
                    $acdo_row_data[$key]['acdo_attached_quantity'] = $value->acdo_attached_quantity;
                    $acdo_row_data[$key]['acdo_range'] = $value->acdo_range;
                    $acdo_row_data[$key]['acdo_row'] = $value->acdo_row;
                    $acdo_row_data[$key]['acdo_range'] = $value->acdo_range;
                    // 选择商品,返回选择的商品
                    $goods['goo_id'] = $value->acdo_goo_id;
                    $goods['goo_name'] = $value->goo_name;
                    $goods['goo_goods_encode'] = $value->goo_goods_encode;
                    $goods['goo_type'] = $value->goo_type;
                    $goods['goo_gift_id'] = $value->acdo_gift_id;
                    $acdo_gift_id[] = $value->acdo_gift_id;
                    $acdo_row_data[$key]['goods'][] = $goods;
                }
                $data['find_acdo'] = $acdo_row_data;
            } elseif ($value->acti_activity_type == '3') {
                // 买赠
                $find_acdos = DB::table('activity_donate as acdo')
                    ->leftjoin('goods as g', 'g.goo_id', '=', 'acdo.acdo_goo_id')
                    ->whereIn('acdo_goo_id', $request['goo_id'])
                    ->select('acdo_acti_id', 'acdo_goo_id', 'acdo_gift_id', 'goo_name', 'goo_goods_encode', 'acdo_purchase_quantity', 'acdo_attached_quantity', 'acdo_row', 'acdo_range', 'goo_type')
                    ->get()->toArray();
                $acdo_row_data = [];
                $acdo_gift_id = [];
                $goo_gift_data = [];
                foreach ($find_acdos as $key => $value) {
                    $acdo_row_data[$value->acdo_row]['acdo_acti_id'] = $value->acdo_acti_id;
                    $acdo_row_data[$value->acdo_row]['acdo_purchase_quantity'] = $value->acdo_purchase_quantity;
                    $acdo_row_data[$value->acdo_row]['acdo_attached_quantity'] = $value->acdo_attached_quantity;
                    $acdo_row_data[$value->acdo_row]['acdo_range'] = $value->acdo_range;
                    $acdo_row_data[$value->acdo_row]['acdo_row'] = $value->acdo_row;
                    $acdo_row_data[$value->acdo_row]['acdo_range'] = $value->acdo_range;
                    // 查询赠品商品信息
                    if (!in_array($value->acdo_gift_id, $acdo_gift_id)) {
                        $find_gift_data = DB::table('goods')
                            ->where('goo_id', $value->acdo_gift_id)
                            ->select('goo_id', 'goo_name', 'goo_goods_encode', 'goo_type')
                            ->first();
                        $goo_gift_data[$value->acdo_gift_id] = (array) $find_gift_data;
                        $acdo_gift_id[] = $value->acdo_gift_id;
                    }

                    // 选择商品，返回选择的商品
                    $goods['goo_id'] = $value->acdo_goo_id;
                    $goods['goo_name'] = $value->goo_name;
                    $goods['goo_goods_encode'] = $value->goo_goods_encode;
                    $goods['goo_type'] = $value->goo_type;
                    $goods['goo_gift_id'] = $value->acdo_gift_id;
                    $acdo_gift_id[] = $value->acdo_gift_id;
                    $acdo_row_data[$value->acdo_row]['goods'][] = $goods;
                    $acdo_row_data[$value->acdo_row]['goo_gift_id'] = $goo_gift_data[$value->acdo_gift_id];
                }
                $data['find_acdos'] = $acdo_row_data;
            } elseif ($value->acti_activity_type == '4') {
                // 满减
                $find_acdr = DB::table('activity_discount_reduction')
                    ->select('acdr_acti_id', 'acdr_reduction_price', 'acdr_credit_price', 'acdr_row')
                    ->get();
                $acdr_row_data = [];
                foreach ($find_acdr as $key => $value) {
                    $acdr_row_data[$key]['acdr_acti_id'] = $value->acdr_acti_id;
                    $acdr_row_data[$key]['acdr_reduction_price'] = $value->acdr_reduction_price;
                    $acdr_row_data[$key]['acdr_credit_price'] = $value->acdr_credit_price;
                    $acdr_row_data[$key]['acdr_row'] = $value->acdr_row;
                }
                $data['find_acdr'] = $acdr_row_data;
            } elseif ($value->acti_activity_type == '5') {
                // 现结折扣
                $find_acdrs = DB::table('activity_discount_reduction')
                    ->select('acdr_acti_id', 'acdr_reduction_price', 'acdr_discount', 'acdr_row')
                    ->get();
                $acdrs_row_data = [];
                foreach ($find_acdrs as $key => $value) {
                    $acdrs_row_data[$key]['acdr_acti_id'] = $value->acdr_acti_id;
                    $acdrs_row_data[$key]['acdr_reduction_price'] = $value->acdr_reduction_price;
                    $acdrs_row_data[$key]['acdr_discount'] = $value->acdr_discount;
                    $acdrs_row_data[$key]['acdr_row'] = $value->acdr_row;
                }
                $data['find_acdrs'] = $acdrs_row_data;
            } elseif ($value->acti_activity_type == '6') {
                // 累计返点
                $find_accp = DB::table('activity_cash_points')
                    ->where('accp_acti_id', $value->acti_id)
                    ->select('accp_acti_id', 'accp_transaction_price', 'accp_integral')
                    ->first();
                $find_accr = DB::table('activity_cumulative_rebates')
                    ->where('accr_acti_id', $value->acti_id)
                    ->select('accr_acti_id', 'accr_transaction_price', 'accr_integral', 'accr_row')
                    ->first();
            // $data['find_accp'] = $find_accp;
                // $data['find_accr'] = $find_accr;
            } elseif ($value->acti_activity_type == '7') {
                // 高价回收
                $find_achr = DB::table('activity_high_recycling as achr')
                    ->whereIn('achr_goo_id', $request['goo_id'])
                    ->select('achr_acti_id', 'achr_goo_id', 'achr_recycle_quantity', 'achr_recycle_price')
                    ->get();
            // $data['find_achr'] = $find_achr;
            } elseif ($value->acti_activity_type == '8') {
                // 大批量采购
                $find_acpr = DB::table('activity_procurement as acpr')
                    ->leftjoin('goods as goo', 'goo.goo_id', '=', 'acpr.acpr_goo_id')
                    ->whereIn('acpr_goo_id', $request['goo_id'])
                    ->select('acpr_acti_id', 'acpr_recycle_quantity', 'acpr_row', 'acpr_range', 'acpr_goods_quantity', 'acpr_goo_id', 'goo_name', 'goo_goods_encode', 'goo_type')
                    ->get()->toArray();
                $acpr_row_data = [];
                foreach ($find_acpr as $key => $value) {
                    $acpr_row_data[$value->acpr_acti_id]['acpr_acti_id'] = $value->acpr_acti_id;
                    $acpr_row_data[$value->acpr_acti_id]['acpr_goods_quantity'] = $value->acpr_goods_quantity;
                    $acpr_row_data[$value->acpr_acti_id]['acpr_recycle_quantity'] = $value->acpr_recycle_quantity;
                    $acpr_row_data[$value->acpr_acti_id]['acpr_row'] = $value->acpr_row;
                    // 选择商品
                    if ($value->acpr_range == 4) {
                        $goods['goo_id'] = $value->acpr_goo_id;
                        $goods['goo_name'] = $value->goo_name;
                        $goods['goo_goods_encode'] = $value->goo_goods_encode;
                        $goods['goo_type'] = $value->goo_type;
                        $acpr_row_data[$value->acpr_acti_id]['goods'][] = $goods;
                    }
                }
                $data['find_acpr'] = $acpr_row_data;
            }
        }
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data]);
    }

    // 工作总台--查询活动详情
    public function searchActivityDetails(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyActivityListsController;
        $error_message = $verify_data->searchActivityDetailsValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误', 'error_message' => $error_message]);
        }

        $find_acti = DB::table('activity')
            ->where('acti_id', $request['acti_id'])
            ->select('acti_id', 'acti_number', 'acti_name', 'acti_activity_type', 'acti_start_time', 'acti_end_time', 'acti_activity_nature', 'acti_activity_days', 'acti_cycle_number', 'acti_state', 'acti_prec_id')
            ->first();
        if ($find_acti->acti_activity_type == '1') {
            // 折扣
            $find_acdi = DB::table('activity_discount as acdi')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'acdi.acdi_goo_id')
                ->where('acdi_acti_id', $request['acti_id'])
                ->whereIn('acdi_goo_id', $request['goo_id'])
                ->select('acdi_id', 'acdi_discount', 'acdi_row', 'acdi_goo_id', 'acdi_range', 'goo_name', 'goo_goods_encode', 'goo_type')
                ->get()->toArray();
            $acdi_row_data = [];
            foreach ($find_acdi as $key => $value) {
                $acdi_row_data[$value->acdi_row]['acdi_discount'] = $value->acdi_discount; //折扣
                $acdi_row_data[$value->acdi_row]['acdi_row'] = $value->acdi_row; //条数
                // 选择商品
                $goods['goo_id'] = $value->acdi_goo_id;
                $goods['goo_name'] = $value->goo_name;
                $goods['goo_goods_encode'] = $value->goo_goods_encode;
                $goods['goo_type'] = $value->goo_type;
                $acdi_row_data[$value->acdi_row]['goods'][] = $goods;
            }
            $data['find_acdi'] = $acdi_row_data;
        } elseif ($find_acti->acti_activity_type == '2') {
            // 买送
            $find_acdo = DB::table('activity_donate as acdo')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'acdo.acdo_goo_id')
                ->where('acdo_acti_id', $request['acti_id'])
                ->select('acdo_id', 'acdo_goo_id', 'acdo_gift_id', 'goo_name', 'goo_goods_encode', 'acdo_purchase_quantity', 'acdo_attached_quantity', 'acdo_row', 'acdo_range', 'goo_type')
                ->get()->toArray();
            $acdo_row_data = [];
            $acdo_gift_id = [];
            foreach ($find_acdo as $key => $value) {
                $acdo_row_data[$value->acdo_row]['acdo_purchase_quantity'] = $value->acdo_purchase_quantity;
                $acdo_row_data[$value->acdo_row]['acdo_attached_quantity'] = $value->acdo_attached_quantity;
                $acdo_row_data[$value->acdo_row]['acdo_range'] = $value->acdo_range;
                $acdo_row_data[$value->acdo_row]['acdo_row'] = $value->acdo_row;
                // 选择商品
                $goods['goo_id'] = $value->acdo_goo_id;
                $goods['goo_name'] = $value->goo_name;
                $goods['goo_goods_encode'] = $value->goo_goods_encode;
                $goods['goo_type'] = $value->goo_type;
                $goods['goo_gift_id'] = $value->acdo_gift_id;
                $acdo_gift_id[] = $value->acdo_gift_id;
                $acdo_row_data[$value->acdo_row]['goods'][] = $goods;
            }
            $data['find_acdo'] = $acdo_row_data;
        } elseif ($find_acti->acti_activity_type == '3') {
            // 买赠
            $find_acdo = DB::table('activity_donate as acdo')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'acdo.acdo_goo_id')
                ->where('acdo_acti_id', $request['acti_id'])
                ->whereIn('acdo_goo_id', $request['goo_id'])
                ->select('acdo_id', 'acdo_goo_id', 'acdo_gift_id', 'goo_name', 'goo_goods_encode', 'acdo_purchase_quantity', 'acdo_attached_quantity', 'acdo_row', 'acdo_range', 'goo_type')
                ->get()->toArray();
            $acdo_row_data = [];
            $acdo_gift_id = [];
            $goo_gift_data = [];
            foreach ($find_acdo as $key => $value) {
                $acdo_row_data[$value->acdo_row]['acdo_purchase_quantity'] = $value->acdo_purchase_quantity;
                $acdo_row_data[$value->acdo_row]['acdo_attached_quantity'] = $value->acdo_attached_quantity;
                $acdo_row_data[$value->acdo_row]['acdo_range'] = $value->acdo_range;
                $acdo_row_data[$value->acdo_row]['acdo_row'] = $value->acdo_row;
                // 查询赠品商品信息
                if (!in_array($value->acdo_gift_id, $acdo_gift_id)) {
                    $find_gift_data = DB::table('goods')
                        ->where('goo_id', $value->acdo_gift_id)
                        ->select('goo_id', 'goo_name', 'goo_goods_encode', 'goo_type')
                        ->first();
                    $goo_gift_data[$value->acdo_gift_id] = (array) $find_gift_data;
                    $acdo_gift_id[] = $value->acdo_gift_id;
                }

                // 选择商品
                $goods['goo_id'] = $value->acdo_goo_id;
                $goods['goo_name'] = $value->goo_name;
                $goods['goo_goods_encode'] = $value->goo_goods_encode;
                $goods['goo_type'] = $value->goo_type;
                $goods['goo_gift_id'] = $value->acdo_gift_id;
                $acdo_gift_id[] = $value->acdo_gift_id;
                $acdo_row_data[$value->acdo_row]['goods'][] = $goods;
                $acdo_row_data[$value->acdo_row]['goo_gift_id'] = $goo_gift_data[$value->acdo_gift_id];
            }
            $data['find_acdo'] = $acdo_row_data;
        } elseif ($find_acti->acti_activity_type == '4') {
            // 满减
            $find_acdr = DB::table('activity_discount_reduction')
                ->where('acdr_acti_id', $request['acti_id'])
                ->select('acdr_id', 'acdr_reduction_price', 'acdr_credit_price', 'acdr_row')
                ->get();
            $data['find_acdr'] = $find_acdr;
        } elseif ($find_acti->acti_activity_type == '5') {
            // 现结折扣
            $find_acdr = DB::table('activity_discount_reduction')
                ->where('acdr_acti_id', $request['acti_id'])
                ->select('acdr_id', 'acdr_reduction_price', 'acdr_discount', 'acdr_row')
                ->get();
            $data['find_acdr'] = $find_acdr;
        } elseif ($find_acti->acti_activity_type == '6') {
            // 积分兑现(暂时用不到)
            // $find_accp = DB::table('activity_cash_points')
            //     ->where('accp_acti_id', $request['acti_id'])
            //     ->select('accp_id', 'accp_transaction_price', 'accp_integral')
            //     ->first();
            // // 累计返点
            // $find_accr = DB::table('activity_cumulative_rebates')
            //     ->where('accr_acti_id', $request['acti_id'])
            //     ->select('accr_id', 'accr_transaction_price', 'accr_integral', 'accr_row')
            //     ->get();
            // $data['find_accp'] = $find_accp;
            // $data['find_accr'] = $find_accr;
        } elseif ($find_acti->acti_activity_type == '7') {
            // 高价回收(暂时用不到)
            // $find_achr = DB::table('activity_high_recycling as achr')
            //     ->leftjoin('goods as goo', 'goo.goo_id', '=', 'achr.achr_goo_id')
            //     ->where('achr_acti_id', $request['acti_id'])
            //     ->whereIn('achr_goo_id', $request['goo_id'])
            //     ->select('achr_id', 'achr_recycle_quantity', 'achr_recycle_price')
            //     ->get();
            // $data['find_achr'] = $find_achr;
        } elseif ($find_acti->acti_activity_type == '8') {
            // 大批量采购
            $find_acpr = DB::table('activity_procurement as acpr')
                ->leftjoin('goods as goo', 'goo.goo_id', '=', 'acpr.acpr_goo_id')
                ->where('acpr_acti_id', $request['acti_id'])
                ->whereIn('acpr_goo_id', $request['goo_id'])
                ->select('acpr_id', 'acpr_goo_id', 'acpr_recycle_quantity', 'acpr_row', 'acpr_range', 'acpr_goods_quantity', 'goo_name', 'goo_goods_encode', 'goo_type')
                ->get()->toArray();
            $acpr_row_data = [];
            foreach ($find_acpr as $key => $value) {
                $acpr_row_data[$value->acpr_row]['acpr_goods_quantity'] = $value->acpr_goods_quantity;
                $acpr_row_data[$value->acpr_row]['acpr_recycle_quantity'] = $value->acpr_recycle_quantity;
                $acpr_row_data[$value->acpr_row]['acpr_row'] = $value->acpr_row;
                // 选择商品
                $goods['goo_id'] = $value->acpr_goo_id;
                $goods['goo_name'] = $value->goo_name;
                $goods['goo_goods_encode'] = $value->goo_goods_encode;
                $goods['goo_type'] = $value->goo_type;
                $acpr_row_data[$value->acpr_row]['goods'][] = $goods;
            }
            $data['find_acpr'] = $acpr_row_data;
        }
        $data['find_acti'] = $find_acti;
        return ['code' => 200, 'msg' => 'success', 'data' => $data];
    }

    // 活动列表-搜索活动默认数据
    public function searchDefaultDetails(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyActivityListsController;
        $error_message = $verify_data->deliveryValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误', 'error_message' => $error_message]);
        }

        $find_acti = DB::table('activity')
            ->where('acti_id', $request['acti_id'])
            ->select('acti_id', 'acti_number', 'acti_name', 'acti_activity_type', 'acti_start_time', 'acti_end_time', 'acti_activity_nature', 'acti_activity_days', 'acti_cycle_number', 'acti_state')
            ->first();
        if ($find_acti->acti_activity_type == '1') {
            // 活动折扣
            $find_acdi = DB::table('activity_discount as acdi')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'acdi.acdi_goo_id')
                ->where('acdi_acti_id', $request['acti_id'])
                ->select('acdi_goo_id', 'acdi_discount', 'acdi_row', 'goo_price', 'acdi_range', 'goo_name', 'goo_cate_name', 'goo_bra_name', 'goo_goods_encode', 'goo_type')
                ->get()->toArray();
            $acdi_row_data = [];
            foreach ($find_acdi as $key => $value) {
                if ($value->acdi_row == '1') {
                    $acdi_row_data[$value->acdi_row]['acdi_discount'] = $value->acdi_discount; //折扣
                    $acdi_row_data[$value->acdi_row]['acdi_row'] = $value->acdi_row; //条数
                }
            }
            $data['find_acdi'] = $acdi_row_data;
        } elseif ($find_acti->acti_activity_type == '2') {
            // 买送
            $find_acdo = DB::table('activity_donate as acdo')
                ->where('acdo_acti_id', $request['acti_id'])
                ->select('acdo_id', 'acdo_goo_id', 'acdo_gift_id', 'acdo_purchase_quantity', 'acdo_attached_quantity', 'acdo_row')
                ->get()->toArray();
            $acdo_row_data = [];
            foreach ($find_acdo as $key => $value) {
                if ($value->acdo_row == '1') {
                    $acdo_row_data[$value->acdo_row]['acdo_purchase_quantity'] = $value->acdo_purchase_quantity;
                    $acdo_row_data[$value->acdo_row]['acdo_attached_quantity'] = $value->acdo_attached_quantity;
                    $acdo_row_data[$value->acdo_row]['acdo_row'] = $value->acdo_row;
                }
            }
            $data['find_acdo'] = $acdo_row_data;
        } elseif ($find_acti->acti_activity_type == '3') {
            // 买赠
            $find_acdo = DB::table('activity_donate as acdo')
                ->where('acdo_acti_id', $request['acti_id'])
                ->select('acdo_id', 'acdo_goo_id', 'acdo_gift_id', 'acdo_purchase_quantity', 'acdo_attached_quantity', 'acdo_row')
                ->get()->toArray();
            $acdo_row_data = [];
            foreach ($find_acdo as $key => $value) {
                if ($value->acdo_row == '1') {
                    $acdo_row_data[$value->acdo_row]['acdo_purchase_quantity'] = $value->acdo_purchase_quantity;
                    $acdo_row_data[$value->acdo_row]['acdo_attached_quantity'] = $value->acdo_attached_quantity;
                    $acdo_row_data[$value->acdo_row]['acdo_row'] = $value->acdo_row;
                }
            }
            $data['find_acdo'] = $acdo_row_data;
        } elseif ($find_acti->acti_activity_type == '4') {
            // 满减
            $find_acdr = DB::table('activity_discount_reduction')
                ->where('acdr_acti_id', $request['acti_id'])
                ->select('acdr_id', 'acdr_reduction_price', 'acdr_credit_price', 'acdr_row')
                ->get();
            foreach ($find_acdr as $key => $value) {
                if ($value->acdr_row == '1') {
                    $data['find_acdr'][$key] = $value;
                }
            }
        } elseif ($find_acti->acti_activity_type == '5') {
            // 现结折扣
            $find_acdr = DB::table('activity_discount_reduction')
                ->where('acdr_acti_id', $request['acti_id'])
                ->select('acdr_id', 'acdr_reduction_price', 'acdr_discount', 'acdr_row')
                ->get();
            foreach ($find_acdr as $key => $value) {
                if ($value->acdr_row == '1') {
                    $data['find_acdr'][$key] = $value;
                }
            }
        } elseif ($find_acti->acti_activity_type == '6') {
            // 累计返点
            $find_accp = DB::table('activity_cash_points')
                ->where('accp_acti_id', $request['acti_id'])
                ->select('accp_id', 'accp_transaction_price', 'accp_integral')
                ->first();
            $find_accr = DB::table('activity_cumulative_rebates')
                ->where('accr_acti_id', $request['acti_id'])
                ->select('accr_id', 'accr_transaction_price', 'accr_integral', 'accr_row')
                ->get();
            foreach ($find_accr as $key => $value) {
                if ($value->accr_row == '1') {
                    $data['find_accr'][$key] = $value;
                }
            }
            $data['find_accp'] = $find_accp;
        } elseif ($find_acti->acti_activity_type == '7') {
            // 高价回收
            $find_achr = DB::table('activity_high_recycling as achr')
                ->where('achr_acti_id', $request['acti_id'])
                ->select('achr_goo_id', 'achr_recycle_quantity', 'achr_recycle_price')
                ->get();
            $data['find_achr'] = $find_achr;
        } elseif ($find_acti->acti_activity_type == '8') {
            // 大批量采购
            $find_acpr = DB::table('activity_procurement as acpr')
                ->where('acpr_acti_id', $request['acti_id'])
                ->select('acpr_goo_id', 'acpr_goods_quantity', 'acpr_recycle_quantity', 'acpr_row', 'acpr_range')
                ->get();
            $acpr_row_data = [];
            foreach ($find_acpr as $key => $value) {
                if ($value->acpr_row == '1') {
                    $acpr_row_data[$value->acpr_row]['acpr_goods_quantity'] = $value->acpr_goods_quantity;
                    $acpr_row_data[$value->acpr_row]['acpr_recycle_quantity'] = $value->acpr_recycle_quantity;
                    $acpr_row_data[$value->acpr_row]['acpr_row'] = $value->acpr_row;
                }
            }
            $data['find_acpr'] = $acpr_row_data;
        }
        $data['find_acti'] = $find_acti;
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data]);
    }

    // 详情信息
    private function infos($request)
    {
        $find_acti = DB::table('activity')
            ->where('acti_id', $request['acti_id'])
            ->select('acti_id', 'acti_number', 'acti_name', 'acti_activity_type', 'acti_start_time', 'acti_end_time', 'acti_activity_nature', 'acti_activity_days', 'acti_cycle_number', 'acti_state', 'acti_prec_id')
            ->first();
        if ($find_acti->acti_activity_type == '1') {
            // 折扣
            $find_acdi = DB::table('activity_discount as acdi')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'acdi.acdi_goo_id')
                ->where('acdi_acti_id', $request['acti_id'])
                ->select('acdi_id', 'acdi_goo_id', 'goo_cate_name', 'goo_bra_name', 'goo_name', 'goo_goods_encode', 'acdi_discount', 'acdi_row', 'goo_price', 'goo_type', 'acdi_range')
                ->get()->toArray();
            $acdi_row_data = [];
            $category = [];
            $brand = [];
            foreach ($find_acdi as $key => $value) {
                $acdi_row_data[$value->acdi_row]['acdi_discount'] = $value->acdi_discount; //折扣
                $acdi_row_data[$value->acdi_row]['acdi_row'] = $value->acdi_row; //条数
                $acdi_row_data[$value->acdi_row]['acdi_range'] = $value->acdi_range; //商品范围1全部商品2限定品牌3限定品类4限定商品
                // 组成品牌数组
                if ($value->acdi_range == '2') {
                    if ($value->goo_bra_name && !in_array($value->goo_bra_name, $brand)) {
                        $acdi_row_data[$value->acdi_row]['brand'][]['bra_name'] = $value->goo_bra_name;
                        $brand[] = $value->goo_bra_name;
                    }
                }
                // 组成品类数组
                if ($value->acdi_range == '3') {
                    if ($value->goo_cate_name && !in_array($value->goo_cate_name, $category)) {
                        $acdi_row_data[$value->acdi_row]['category'][]['cate_name'] = $value->goo_cate_name;
                        $category[] = $value->goo_cate_name;
                    }
                }
                // 选择商品
                if ($value->acdi_range == 4) {
                    $goods['goo_name'] = $value->goo_name;
                    $goods['goo_goods_encode'] = $value->goo_goods_encode;
                    $goods['goo_type'] = $value->goo_type;
                    $acdi_row_data[$value->acdi_row]['goods'][] = $goods;
                }
            }
            $data['find_acdi'] = $acdi_row_data;
        } elseif ($find_acti->acti_activity_type == '2') {
            // 买送
            $find_acdo = DB::table('activity_donate as acdo')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'acdo.acdo_goo_id')
                ->where('acdo_acti_id', $request['acti_id'])
                ->select('acdo_id', 'acdo_goo_id', 'acdo_gift_id', 'goo_cate_name', 'goo_bra_name', 'goo_name', 'goo_goods_encode', 'acdo_purchase_quantity', 'acdo_attached_quantity', 'acdo_row', 'acdo_range', 'goo_type')
                ->get()->toArray();
            $acdo_row_data = [];
            $category = [];
            $brand = [];
            $acdo_gift_id = [];
            foreach ($find_acdo as $key => $value) {
                $acdo_row_data[$value->acdo_row]['acdo_purchase_quantity'] = $value->acdo_purchase_quantity;
                $acdo_row_data[$value->acdo_row]['acdo_attached_quantity'] = $value->acdo_attached_quantity;
                $acdo_row_data[$value->acdo_row]['acdo_range'] = $value->acdo_range;
                $acdo_row_data[$value->acdo_row]['acdo_row'] = $value->acdo_row;
                // 组成品牌数组
                if ($value->acdo_range == 2) {
                    if ($value->goo_bra_name && !in_array($value->goo_bra_name, $brand)) {
                        $acdo_row_data[$value->acdo_row]['brand'][]['bra_name'] = $value->goo_bra_name;
                        $brand[] = $value->goo_bra_name;
                    }
                }
                // 组成品类数组
                if ($value->acdo_range == 3) {
                    if ($value->goo_cate_name && !in_array($value->goo_cate_name, $category)) {
                        $acdo_row_data[$value->acdo_row]['category'][]['cate_name'] = $value->goo_cate_name;
                        $category[] = $value->goo_cate_name;
                    }
                }
                // 选择商品
                if ($value->acdo_range == 4) {
                    $goods['goo_name'] = $value->goo_name;
                    $goods['goo_goods_encode'] = $value->goo_goods_encode;
                    $goods['goo_type'] = $value->goo_type;
                    $goods['goo_gift_id'] = $value->acdo_gift_id;
                    $acdo_gift_id[] = $value->acdo_gift_id;
                    $acdo_row_data[$value->acdo_row]['goods'][] = $goods;
                }
            }
            $data['find_acdo'] = $acdo_row_data;
        } elseif ($find_acti->acti_activity_type == '3') {
            // 买赠
            $find_acdo = DB::table('activity_donate as acdo')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'acdo.acdo_goo_id')
                ->where('acdo_acti_id', $request['acti_id'])
                ->select('acdo_id', 'acdo_goo_id', 'acdo_gift_id', 'goo_cate_name', 'goo_bra_name', 'goo_name', 'goo_goods_encode', 'acdo_purchase_quantity', 'acdo_attached_quantity', 'acdo_row', 'acdo_range', 'goo_type')
                ->get()->toArray();
            $acdo_row_data = [];
            $category = [];
            $brand = [];
            $acdo_gift_id = [];
            $goo_gift_data = [];
            foreach ($find_acdo as $key => $value) {
                $acdo_row_data[$value->acdo_row]['acdo_purchase_quantity'] = $value->acdo_purchase_quantity;
                $acdo_row_data[$value->acdo_row]['acdo_attached_quantity'] = $value->acdo_attached_quantity;
                $acdo_row_data[$value->acdo_row]['acdo_range'] = $value->acdo_range;
                $acdo_row_data[$value->acdo_row]['acdo_row'] = $value->acdo_row;
                // 查询赠品商品信息
                if (!in_array($value->acdo_gift_id, $acdo_gift_id)) {
                    $find_gift_data = DB::table('goods')
                        ->where('goo_id', $value->acdo_gift_id)
                        ->select('goo_name', 'goo_goods_encode', 'goo_type')
                        ->first();
                    $goo_gift_data[$value->acdo_gift_id] = (array) $find_gift_data;
                    $acdo_gift_id[] = $value->acdo_gift_id;
                }

                // 组成品牌数组
                if ($value->acdo_range == 2) {
                    if ($value->goo_bra_name && !in_array($value->goo_bra_name, $brand)) {
                        $acdo_row_data[$value->acdo_row]['brand'][]['bra_name'] = $value->goo_bra_name;
                        $brand[] = $value->goo_bra_name;
                    }
                }
                // 组成品类数组
                if ($value->acdo_range == 3) {
                    if ($value->goo_cate_name && !in_array($value->goo_cate_name, $category)) {
                        $acdo_row_data[$value->acdo_row]['category'][]['cate_name'] = $value->goo_cate_name;
                        $category[] = $value->goo_cate_name;
                    }
                }
                // 选择商品
                if ($value->acdo_range == 4) {
                    $goods['goo_name'] = $value->goo_name;
                    $goods['goo_goods_encode'] = $value->goo_goods_encode;
                    $goods['goo_type'] = $value->goo_type;
                    $goods['goo_gift_id'] = $value->acdo_gift_id;
                    $acdo_gift_id[] = $value->acdo_gift_id;
                    $acdo_row_data[$value->acdo_row]['goods'][] = $goods;
                }
                $acdo_row_data[$value->acdo_row]['goo_gift_id'] = $goo_gift_data[$value->acdo_gift_id];
            }
            $data['find_acdo'] = $acdo_row_data;
        } elseif ($find_acti->acti_activity_type == '4') {
            // 满减
            $find_acdr = DB::table('activity_discount_reduction')
                ->where('acdr_acti_id', $request['acti_id'])
                ->select('acdr_id', 'acdr_reduction_price', 'acdr_credit_price', 'acdr_row')
                ->get();
            $data['find_acdr'] = $find_acdr;
        } elseif ($find_acti->acti_activity_type == '5') {
            // 现结折扣
            $find_acdr = DB::table('activity_discount_reduction')
                ->where('acdr_acti_id', $request['acti_id'])
                ->select('acdr_id', 'acdr_reduction_price', 'acdr_discount', 'acdr_row')
                ->get();
            $data['find_acdr'] = $find_acdr;
        } elseif ($find_acti->acti_activity_type == '6') {
            // 积分兑现
            $find_accp = DB::table('activity_cash_points')
                ->where('accp_acti_id', $request['acti_id'])
                ->select('accp_id', 'accp_transaction_price', 'accp_integral')
                ->first();
            // 累计返点
            $find_accr = DB::table('activity_cumulative_rebates')
                ->where('accr_acti_id', $request['acti_id'])
                ->select('accr_id', 'accr_transaction_price', 'accr_integral', 'accr_row')
                ->get();
            $data['find_accp'] = $find_accp;
            $data['find_accr'] = $find_accr;
        } elseif ($find_acti->acti_activity_type == '7') {
            // 高价回收
            $find_achr = DB::table('activity_high_recycling as achr')
                ->leftjoin('goods as goo', 'goo.goo_id', '=', 'achr.achr_goo_id')
                ->where('achr_acti_id', $request['acti_id'])
                ->select('achr_id', 'goo_id', 'goo_cate_id', 'goo_bra_id', 'goo_name', 'goo_goods_encode', 'goo_ampere_hour', 'goo_price', 'achr_recycle_quantity', 'achr_recycle_price')
                ->get();
            $data['find_achr'] = $find_achr;
        } elseif ($find_acti->acti_activity_type == '8') {
            // 大批量采购
            $find_acpr = DB::table('activity_procurement as acpr')
                ->leftjoin('goods as goo', 'goo.goo_id', '=', 'acpr.acpr_goo_id')
                ->where('acpr_acti_id', $request['acti_id'])
                ->select('acpr_id', 'acpr_goo_id', 'goo_cate_name', 'goo_bra_name', 'goo_name', 'goo_goods_encode', 'acpr_recycle_quantity', 'acpr_row', 'acpr_range', 'acpr_goods_quantity', 'goo_type')
                ->get()->toArray();
            $acpr_row_data = [];
            $category = [];
            $brand = [];
            foreach ($find_acpr as $key => $value) {
                $acpr_row_data[$value->acpr_row]['acpr_goods_quantity'] = $value->acpr_goods_quantity;
                $acpr_row_data[$value->acpr_row]['acpr_recycle_quantity'] = $value->acpr_recycle_quantity;
                $acpr_row_data[$value->acpr_row]['acpr_row'] = $value->acpr_row;
                $acpr_row_data[$value->acpr_row]['acpr_range'] = $value->acpr_range;
                // 组成品牌数组
                if ($value->acpr_range == 2) {
                    if ($value->goo_bra_name && !in_array($value->goo_bra_name, $brand)) {
                        $acpr_row_data[$value->acpr_row]['brand'][]['bra_name'] = $value->goo_bra_name;
                        $brand[] = $value->goo_bra_name;
                    }
                }
                // 组成品类数组
                if ($value->acpr_range == 3) {
                    if ($value->goo_cate_name && !in_array($value->goo_cate_name, $category)) {
                        $acpr_row_data[$value->acpr_row]['category'][]['cate_name'] = $value->goo_cate_name;
                        $category[] = $value->goo_cate_name;
                    }
                }
                // 选择商品
                if ($value->acpr_range == 4) {
                    $goods['goo_name'] = $value->goo_name;
                    $goods['goo_goods_encode'] = $value->goo_goods_encode;
                    $goods['goo_type'] = $value->goo_type;
                    $acpr_row_data[$value->acpr_row]['goods'][] = $goods;
                }
            }
            $data['find_acpr'] = $acpr_row_data;
        }
        $data['find_acti'] = $find_acti;
        return ['code' => 200, 'msg' => 'success', 'data' => $data];
    }

    // 搜索商品
    public function searchGoods(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyActivityListsController;
        $error_message = $verify_data->searchGoodsValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误', 'error_message' => $error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        $list_data = DB::table('goods')
            ->where('goo_cid', $user_info->adm_cid)
            ->where('goo_superior_shop_id', $shop_id)
            ->where('goo_type', $request['goo_type'])
            ->where('goo_delete', 1)
            ->where('goo_state', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_name'])) {
                    $query->where('goo_name', 'like', '%' . $search_data['goo_name'] . '%')
                        ->orwhere('goo_goods_encode', 'like', '%' . $search_data['goo_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_bra_id'])) {
                    $query->where('goo_bra_id', $search_data['goo_bra_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_cate_id'])) {
                    $query->where('goo_cate_id', $search_data['goo_cate_id']);
                }
            })
            ->select('goo_id', 'goo_name', 'goo_type', 'goo_goods_encode', 'goo_ampere_hour', 'goo_price')
            ->orderBy('goo_goods_encode', 'asc')
            ->paginate($this->show_count);

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据
        if ($list_data) {
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data_info]);
        } else {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '暂无数据']);
        }
    }

    // 搜索品牌
    public function searchBrand(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $search_data = $request->all();

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $brand_info  =  DB::table('brand')
            ->where('bra_cid', $user_info->adm_cid)
            ->where('bra_superior_shop_id', $shop_id)
            ->where('bra_state', 1)
            ->where('bra_delete', 1)
            ->where('bra_goods_number', '>', 0)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['search_data'])) {
                    $query->where('bra_name', 'like', '%' . $search_data['search_data'] . '%');
                }
            })
            ->orderBy('bra_sequence', 'asc')
            ->select('bra_id', 'bra_name')
            ->paginate($this->show_count);

        $data_info['current_page'] = $brand_info->currentPage();  //当前页面页码
        $data_info['last_page'] = $brand_info->lastPage();        //表示最后一页的页码
        $data_info['total'] = $brand_info->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $brand_info->items();                //返回数据
        if ($brand_info) {
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data_info]);
        } else {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '暂无数据']);
        }
    }

    // 搜搜品类
    public function searchCategory(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $search_data = $request->all();

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $category_info  =  DB::table('category')
            ->where('cate_cid', $user_info->adm_cid)
            ->where('cate_superior_shop_id', $shop_id)
            ->where(function ($query) use ($request) {
                if (!empty($request['cate_id'])) {
                    $query->where('cate_id', '!=', $request['cate_id']);
                }
            })
            ->where('cate_delete', 1)
            ->where('cate_state', 1)
            ->where('cate_goods_number', '>', 0)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['search_data'])) {
                    $query->where('cate_name', 'like', '%' . $search_data['search_data'] . '%');
                }
            })
            ->select('cate_id', 'cate_name')
            ->paginate($this->show_count);

        $data_info['current_page'] = $category_info->currentPage();  //当前页面页码
        $data_info['last_page'] = $category_info->lastPage();        //表示最后一页的页码
        $data_info['total'] = $category_info->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $category_info->items();                //返回数据
        if ($category_info) {
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data_info]);
        } else {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '暂无数据']);
        }
    }
}
