<?php
namespace App\Http\Controllers\Api\AccountControl;

use App\Http\Models\Api\ReceivablePay;
use App\Services\Business\WashOrderService;
use App\Services\Business\WashWorkService;
use App\Services\CommonService;
use App\Services\LoginUserService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\AccountControl\VerifyReceivableBillController;
use App\Http\Models\Api\Export;
use App\Http\Models\Api\Common;
use App\Http\Models\Api\ReceivableBill;
use App\Http\Models\Api\AccountingSettlement;
use App\Http\Models\Api\AccountTitle;
use App\Http\Models\Api\AccountSubject;
use App\Services\ReceivablePay\ReceivablePayService;

// 财务系统 -- 订单应收应付
class receivablePayController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    /*
     * @name 修改应收应付状态
     * @param string ju_ordernum 订单单号
     * @retrun array
     * @author Ma 2023/7/24 11:42
     *
    */
    public function edit(Request $request)
    {
        $request = $request->all();
        $data_validator = ReceivablePayService::editValidator($request);
        if($data_validator['code'] != 200){
            //return response()->json($data_validator);exit;
        }
        if($request['type'] == 1){
            return ReceivablePayService::info($request);
        }else{
            return ReceivablePayService::edit($request);
        }

    }

    /*
     * @name 添加订单应收应付
     * @param string ju_ordernum 订单单号
     * @retrun array
     * @author Ma 2023/7/24 11:42
     *
    */
    public function add(Request $request)
    {
        $request = $request->all();
        $data_validator = ReceivablePayService::addValidator(json_decode(json_encode($request),true));
        if($data_validator['code'] != 200){
            return response()->json($data_validator);exit;
        }
       /* $params = [
            'user_info'=>$user_info,
            'ord_type'=>$request['ord_type'],
            'ord_client_id'=> isset($request['ord_client_id']) ? $request['ord_client_id'] : 0,
            'ord_order_price'=>$ord_edit_data['ord_order_price']
        ];*/
        //添加订单应收应付
        return  ReceivablePayService::add($request);
    }

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyReceivableBillController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $search_data = $request->all();
        return  ReceivablePayService::index($search_data);
    }

    /*
     * @name 详情
     * @param id 应收应付id
     * @retrun array
     * @author Ma 2023/7/24 18:20
     *
    */
    public function info(Request $request){
        // 验证参数
        /*$error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }*/
        $order_data = [];
        $word_data = [];
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $order_data = WashOrderService::info($user_info, $request->all());//订单信息
        if($order_data['code'] == 200){
            $order_data = $order_data['data'];
        }

        $all_work_orders = DB::table('work_order')->where('wor_order_id', $request['ord_id'])->get()->toArray();
        foreach ($all_work_orders as $work_key => $work_value){
            $word_info = WashWorkService::info($user_info, ['wor_id'=>$work_value->wor_id,'type'=>1]);//工单信息
            $word_data[] = $word_info['data'];
        }

        $data['order_info'] = $order_data;//订单信息
        $data['work_info'] = $word_data;//工单信息
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
    }

    /*
     * @name 导出
     * @param string ju_ordernum 订单单号
     * @retrun array
     * @author Ma 2023/8/9 16:00
     *
    */
    public function export(Request $request){
        // 验证数据
        $verify_data = new VerifyReceivableBillController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $search_data = $request->all();
        return ReceivablePayService::export($search_data);

    }

}
