<?php

namespace App\Http\Controllers\Api\AccountControl;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\AccountControl\VerifyStockSellStorageGoodsController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

// 财务系统 -- 进销存查询
class StockSellStorageGoodsController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 进销存查询列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyStockSellStorageGoodsController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->adm_shop_id;

        $search_data = $request->all();
        $list_data = DB::table('enters_sells_saves as ense')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'ense.ense_goo_id')
            ->where('ense_shop_id', $shop_id)
            ->where('ense_goo_warehouse', $request['sssg_ware_id'])
            ->where('ense_goo_waretype', $request['sssg_waon_class'])
            ->where(function ($query) use ($search_data) { //商品名称
                if (!empty($search_data['goo_name'])) {
                    $query->where('ense_goo_name', 'like', '%' . $search_data['goo_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //检索编码
                if (!empty($search_data['goo_goods_encode'])) {
                    $query->where('ense_goo_number', 'like', '%' . $search_data['goo_goods_encode'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_bra_id'])) {
                    $query->where('goo_bra_id', $search_data['goo_bra_id']);
                }
            }) //品牌id
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_cate_id'])) {
                    $query->where('goo_cate_id', $search_data['goo_cate_id']);
                }
            }) //品类id
            // ->where(function ($query) use ($search_data) { //起始时间
            //     if (!empty($search_data['ense_time_start'])) {
            //         $query->where('ense_time', '>=', $search_data['ense_time_start'] . " 00:00:00");
            //     }
            // })
            ->where(function ($query) use ($search_data) { //结束时间
                if (!empty($search_data['ense_time_end'])) {
                    $query->where('ense_time', '<=', $search_data['ense_time_end'] . " 23:59:59");
                }
            })
            ->select('ense_goo_id')
            ->orderBy('ense_id', 'asc')
            ->groupBy('ense_goo_id')
            ->paginate($this->show_count);
        // 查询出小于当前结束时间的所有商品id相关数据
        $list_items = $list_data->items();
        $list_goo_id = array_column($list_items, 'ense_goo_id'); //商品id

        // 查询商品id相关进销存数据,查询时间段内的可以查到的商品数据
        $list = DB::table('enters_sells_saves as ense')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'ense.ense_goo_id')
            ->where('ense_shop_id', $shop_id)
            ->where('ense_goo_warehouse', $request['sssg_ware_id'])
            ->where('ense_goo_waretype', $request['sssg_waon_class'])
            ->whereIn('ense_goo_id', $list_goo_id)
            ->where(function ($query) use ($search_data) { //商品名称
                if (!empty($search_data['goo_name'])) {
                    $query->where('ense_goo_name', 'like', '%' . $search_data['goo_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //检索编码
                if (!empty($search_data['goo_goods_encode'])) {
                    $query->where('ense_goo_number', 'like', '%' . $search_data['goo_goods_encode'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_bra_id'])) {
                    $query->where('goo_bra_id', $search_data['goo_bra_id']);
                }
            }) //品牌id
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_cate_id'])) {
                    $query->where('goo_cate_id', $search_data['goo_cate_id']);
                }
            }) //品类id
            ->where(function ($query) use ($search_data) { //起始时间
                if (!empty($search_data['ense_time_start'])) {
                    $query->where('ense_time', '>=', $search_data['ense_time_start'] . " 00:00:00");
                }
            })
            ->where(function ($query) use ($search_data) { //结束时间
                if (!empty($search_data['ense_time_end'])) {
                    $query->where('ense_time', '<=', $search_data['ense_time_end'] . " 23:59:59");
                }
            })
            ->select('ense_id', 'ense_goo_id', 'ense_goo_name', 'ense_goo_number', 'ense_goo_unit', 'ense_goo_specifications', 'ense_goo_waretype', 'ense_goo_warehouse', 'ense_new_inventory', 'ense_new_price', 'ense_new_amount', 'ense_end_inventory', 'ense_end_price', 'ense_end_amount', 'ense_out_num', 'ense_out_price', 'ense_out_amount', 'ense_in_num', 'ense_in_price', 'ense_in_amount', 'ense_order_number', 'ense_out_in', 'ense_type', 'ense_time')
            ->orderBy('ense_id', 'asc')
            ->get()->toArray();
        $get_goo_id = array_unique(array_column($list, 'ense_goo_id')); //已经查询出数据的商品id

        // 在选择的时间段内没有查询到的商品id数据
        $nonentity_goo_id = array_diff($list_goo_id, $get_goo_id);
        $nonentity_list = [];
        if ($nonentity_goo_id) {
            // 上面时间段没有查询到商品数据的，查询距离开始时间最近的一条数据
            foreach ($nonentity_goo_id as $key => $value) {
                $find_enters = DB::table('enters_sells_saves')
                    ->where('ense_shop_id', $shop_id)
                    ->where('ense_goo_warehouse', $request['sssg_ware_id'])
                    ->where('ense_goo_waretype', $request['sssg_waon_class'])
                    ->where('ense_goo_id', $value)
                    ->where('ense_time', '<', $search_data['ense_time_start'] . " 00:00:00")
                    ->select('ense_id', 'ense_goo_id', 'ense_goo_name', 'ense_goo_number', 'ense_goo_unit', 'ense_goo_specifications', 'ense_goo_waretype', 'ense_goo_warehouse', 'ense_new_inventory', 'ense_new_price', 'ense_new_amount', 'ense_end_inventory', 'ense_end_price', 'ense_end_amount', 'ense_out_num', 'ense_out_price', 'ense_out_amount', 'ense_in_num', 'ense_in_price', 'ense_in_amount', 'ense_order_number', 'ense_out_in', 'ense_type', 'ense_time')
                    ->orderBy('ense_id', 'desc')
                    ->first();
                // 查询的最近的一条数据，因为没有发生出入库记录，所以月入、月出、月调数据都为0
                // 期初数据等于上一次期末数据
                // 因为时间段内没有查出数据，这个数据就是上一次的数据
                // 所以这个的期初数据等于期末数据
                $find_enters->ense_new_inventory = $find_enters->ense_end_inventory;
                $find_enters->ense_new_price = $find_enters->ense_end_price;
                $find_enters->ense_new_amount = $find_enters->ense_end_amount;
                $find_enters->ense_out_num = 0;
                $find_enters->ense_out_price = 0;
                $find_enters->ense_out_amount = 0;
                $find_enters->ense_in_num = 0;
                $find_enters->ense_in_price = 0;
                $find_enters->ense_in_amount = 0;
                $nonentity_list[] = (array)$find_enters;
            }
        }
        $list = json_decode(json_encode($list), true);
        // 合并数组
        $list = array_merge($list, $nonentity_list);

        $return_data = []; //进销存返回数据
        if ($list) {
            // 查询仓库名称
            $warehouse_name = DB::table('warehouse')
                ->where('ware_id', $request['sssg_ware_id'])
                ->value('ware_name');

            // 查询仓库类别显示名称
            $warehouse_class = DB::table('warehouse_class')
                ->where('wacl_cid', $user_info->adm_cid)
                ->where('wacl_superior_shop_id', $shop_id)
                ->where('wacl_class_numerical', $request['sssg_waon_class'])
                ->value('wacl_class_name');

            // 根据商品id查询商品数据
            $find_goo_data = DB::table('goods')
                ->whereIn('goo_id', $list_goo_id)
                ->select('goo_bra_name', 'goo_brse_id', 'goo_class', 'goo_id')
                ->get()->toArray();
            $goo_data = array_column($find_goo_data, null, 'goo_id');
            $goo_brse_id = array_column($find_goo_data, 'goo_brse_id', 'goo_id');
            // 查询系列数据
            $find_brse_id = array_column($find_goo_data, 'goo_brse_id');
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $find_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();

            $list_adjust = []; //重新调整后的数据
            foreach ($list as $key => $value) {
                // 判断进销存商品id是否存在
                if (isset($list_adjust[$value['ense_goo_id']])) {
                    $list_adjust[$value['ense_goo_id']]['ense_end_inventory'] = $value['ense_end_inventory']; //结余库存
                    $list_adjust[$value['ense_goo_id']]['ense_end_price'] = sprintf("%.4f", $value['ense_end_price']); //期末平均价
                    $list_adjust[$value['ense_goo_id']]['ense_end_amount'] = sprintf("%.4f", $value['ense_end_amount']); //结余成本
                    // 判断是否为调拨单
                    if (substr($value['ense_order_number'], 0, 2) == 'DB') {
                        $list_adjust[$value['ense_goo_id']]['mouthnums'] = $list_adjust[$value['ense_goo_id']]['mouthnums'] + $value['ense_in_num'] - $value['ense_out_num'];
                        $list_adjust[$value['ense_goo_id']]['mouthprice'] = sprintf("%.4f", $list_adjust[$value['ense_goo_id']]['mouthprice'] + $value['ense_in_amount'] - $value['ense_out_amount']);
                    } else {
                        // ense_out_num 月出数量
                        $list_adjust[$value['ense_goo_id']]['ense_out_num'] = $value['ense_out_num'] + $list_adjust[$value['ense_goo_id']]['ense_out_num'];
                        // ense_out_amount 月出成本
                        $list_adjust[$value['ense_goo_id']]['ense_out_amount'] = sprintf("%.4f", $value['ense_out_amount'] + $list_adjust[$value['ense_goo_id']]['ense_out_amount']);
                        // ense_in_num 月入数量
                        $list_adjust[$value['ense_goo_id']]['ense_in_num'] = $value['ense_in_num'] + $list_adjust[$value['ense_goo_id']]['ense_in_num'];
                        // ense_in_amount 月入成本
                        $list_adjust[$value['ense_goo_id']]['ense_in_amount'] = sprintf("%.4f", $value['ense_in_amount'] + $list_adjust[$value['ense_goo_id']]['ense_in_amount']);
                    }
                } else {
                    // 判断是否为调拨单
                    if (substr($value['ense_order_number'], 0, 2) == 'DB') {
                        // 调拨单处理
                        // 月调数量 = 月入数量 - 月出数量
                        $value['mouthnums'] = $value['ense_in_num'] - $value['ense_out_num']; //月调数量
                        // 月调成本 = 月入成本 - 月出成本
                        $value['mouthprice'] = sprintf("%.4f", $value['ense_in_amount'] - $value['ense_out_amount']); //月调成本
                        $value['ense_out_num'] = 0; //月出数量
                        $value['ense_out_amount'] = 0; //月出成本
                        $value['ense_in_num'] = 0; //月入数量
                        $value['ense_in_amount'] = 0; //月入成本
                    } else {
                        $value['mouthnums'] = 0; //月调数量
                        $value['mouthprice'] = 0; //月调成本
                    }

                    $value['ense_goo_waretype'] = $warehouse_class;
                    $value['ense_goo_warehouse'] = $warehouse_name;
                    $list_adjust[$value['ense_goo_id']] = $value;
                }
            }

            $i = 0;
            foreach ($list_adjust as $key => $value) {
                $return_data[$i] = $value;
                // 平均价差异金额 = 期末平均价 - 期初平均价
                $new_end_price = sprintf("%.0f", $value['ense_end_price'] - $value['ense_new_price']); //期初平均价
                $return_data[$i]['new_end_price'] = $new_end_price;
                // ense_out_num 月出数量
                if ($value['ense_out_num'] == '0') {
                    $return_data[$i]['ense_out_price'] = '0'; //月出平均价
                } else {
                    // 月出平均价 = 月出成本 / 月出库存
                    $return_data[$i]['ense_out_price'] = sprintf("%.4f", $value['ense_out_amount'] / $value['ense_out_num']);
                }
                // ense_in_num 月入数量
                if ($value['ense_in_num'] == '0') {
                    $return_data[$i]['ense_in_price'] = '0'; //月入平均价
                } else {
                    // 月入平均价 = 月入成本 / 月入数量
                    $return_data[$i]['ense_in_price'] = sprintf("%.4f", $value['ense_in_amount'] / $value['ense_in_num']);
                }
                $i++;
            }
            // 处理商品品牌系列
            foreach ($return_data as $key => $value) {
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP')) && isset($goo_brse_id[$value['ense_goo_id']])  && isset($brse_data[$goo_brse_id[$value['ense_goo_id']]])) {
                    if (!empty($goo_brse_id[$value['ense_goo_id']])) {
                        // 显示系列名称
                        if ($goo_data[$value['ense_goo_id']]->goo_class == 2) {
                            $return_data[$key]['ense_goo_name'] = $brse_data[$goo_brse_id[$value['ense_goo_id']]] . ' ' . $value['ense_goo_name'];
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $return_data[$key]['ense_goo_name'] = $brse_data[$goo_brse_id[$value['ense_goo_id']]] . ' ' . $value['ense_goo_name'];
                                unset($goo_brse_id[$value['ense_goo_id']]);
                            }
                        }
                        unset($goo_brse_id[$value['ense_goo_id']]);
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP')) && isset($goo_data[$value['ense_goo_id']])) {
                    if ($goo_data[$value['ense_goo_id']]->goo_class == 2) {
                        $return_data[$key]['ense_goo_name'] = $goo_data[$value['ense_goo_id']]->goo_bra_name . ' ' . $return_data[$key]['ense_goo_name'];
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $return_data[$key]['ense_goo_name'] = $goo_data[$value['ense_goo_id']]->goo_bra_name . ' ' . $return_data[$key]['ense_goo_name'];
                        }
                    }
                }
            }
        }

        // 查询所有的商品id
        $all_goo_id = DB::table('enters_sells_saves as ense')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'ense.ense_goo_id')
            ->where('ense_shop_id', $shop_id)
            ->where('ense_goo_warehouse', $request['sssg_ware_id'])
            ->where('ense_goo_waretype', $request['sssg_waon_class'])
            ->where(function ($query) use ($search_data) { //商品名称
                if (!empty($search_data['goo_name'])) {
                    $query->where('ense_goo_name', 'like', '%' . $search_data['goo_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //检索编码
                if (!empty($search_data['goo_goods_encode'])) {
                    $query->where('ense_goo_number', 'like', '%' . $search_data['goo_goods_encode'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_bra_id'])) {
                    $query->where('goo_bra_id', $search_data['goo_bra_id']);
                }
            }) //品牌id
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_cate_id'])) {
                    $query->where('goo_cate_id', $search_data['goo_cate_id']);
                }
            }) //品类id
            // ->where(function ($query) use ($search_data) { //起始时间
            //     if (!empty($search_data['ense_time_start'])) {
            //         $query->where('ense_time', '>=', $search_data['ense_time_start'] . " 00:00:00");
            //     }
            // })
            ->where(function ($query) use ($search_data) { //结束时间
                if (!empty($search_data['ense_time_end'])) {
                    $query->where('ense_time', '<=', $search_data['ense_time_end'] . " 23:59:59");
                }
            })
            ->select('ense_goo_id')
            ->orderBy('ense_id', 'asc')
            ->groupBy('ense_goo_id')
            ->get()->toArray();
        $all_goo_id = array_unique(array_column($all_goo_id, 'ense_goo_id'));

        // 查询合计数据
        $statistics = DB::table('enters_sells_saves as ense')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'ense.ense_goo_id')
            ->where('ense_shop_id', $shop_id)
            ->where('ense_goo_warehouse', $request['sssg_ware_id'])
            ->where('ense_goo_waretype', $request['sssg_waon_class'])
            ->where(function ($query) use ($search_data) { //商品名称
                if (!empty($search_data['goo_name'])) {
                    $query->where('ense_goo_name', 'like', '%' . $search_data['goo_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //检索编码
                if (!empty($search_data['goo_goods_encode'])) {
                    $query->where('ense_goo_number', 'like', '%' . $search_data['goo_goods_encode'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //品牌id
                if (!empty($search_data['goo_bra_id'])) {
                    $query->where('goo.goo_bra_id', $search_data['goo_bra_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //品类id
                if (!empty($search_data['goo_cate_id'])) {
                    $query->where('goo_cate_id', $search_data['goo_cate_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //起始时间
                if (!empty($search_data['ense_time_start'])) {
                    $query->where('ense_time', '>=', $search_data['ense_time_start'] . " 00:00:00");
                }
            })
            ->where(function ($query) use ($search_data) { //结束时间
                if (!empty($search_data['ense_time_end'])) {
                    $query->where('ense_time', '<=', $search_data['ense_time_end'] . " 23:59:59");
                }
            })
            ->select('ense_id', 'ense_goo_id', 'ense_new_inventory', 'ense_new_price', 'ense_new_amount', 'ense_end_inventory', 'ense_end_price', 'ense_end_amount', 'ense_out_num', 'ense_out_price', 'ense_out_amount', 'ense_in_num', 'ense_in_price', 'ense_in_amount', 'ense_order_number')
            ->orderBy('ense_id', 'asc')
            ->get()->toArray();
        $statistics_goo_id = array_unique(array_column($statistics, 'ense_goo_id'));
        // 在选择的时间段内没有查询到的商品id数据
        $nonentity_goo_id = array_diff($all_goo_id, $statistics_goo_id);

        $nonentity_list = [];
        if ($nonentity_goo_id) {
            // 上面时间段没有查询到商品数据的，查询距离开始时间最近的一条数据
            foreach ($nonentity_goo_id as $key => $value) {
                $find_enters = DB::table('enters_sells_saves')
                    ->where('ense_shop_id', $shop_id)
                    ->where('ense_goo_warehouse', $request['sssg_ware_id'])
                    ->where('ense_goo_waretype', $request['sssg_waon_class'])
                    ->where('ense_goo_id', $value)
                    ->where('ense_time', '<', $search_data['ense_time_start'] . " 00:00:00")
                    ->select('ense_id', 'ense_goo_id', 'ense_new_inventory', 'ense_new_price', 'ense_new_amount', 'ense_end_inventory', 'ense_end_price', 'ense_end_amount', 'ense_out_num', 'ense_out_price', 'ense_out_amount', 'ense_in_num', 'ense_in_price', 'ense_in_amount', 'ense_order_number')
                    ->orderBy('ense_id', 'desc')
                    ->first();
                // 查询的最近的一条数据，因为没有发生出入库记录，所以月入、月出、月调数据都为0
                // 期初数据等于上一次期末数据
                // 因为时间段内没有查出数据，这个数据就是上一次的数据
                // 所以这个的期初数据等于期末数据
                $find_enters->ense_new_inventory = $find_enters->ense_end_inventory;
                $find_enters->ense_new_price = $find_enters->ense_end_price;
                $find_enters->ense_new_amount = $find_enters->ense_end_amount;
                $find_enters->ense_out_num = 0;
                $find_enters->ense_out_price = 0;
                $find_enters->ense_out_amount = 0;
                $find_enters->ense_in_num = 0;
                $find_enters->ense_in_price = 0;
                $find_enters->ense_in_amount = 0;
                $nonentity_list[] = (array)$find_enters;
            }
        }
        $statistics_data = array();
        $statistics_data['mouthnums'] = '0';
        $statistics_data['mouthprice'] = '0';
        $statistics = json_decode(json_encode($statistics), true);
        // 合并数组
        $statistics = array_merge($statistics, $nonentity_list);

        $isarray = array();
        foreach ($statistics as $k => $v) {
            if (isset($isarray[$v['ense_goo_id']])) {
                $isarray[$v['ense_goo_id']]['ense_end_inventory'] = $v['ense_end_inventory'];
                $isarray[$v['ense_goo_id']]['ense_end_price'] = $v['ense_end_price'];
                $isarray[$v['ense_goo_id']]['ense_end_amount'] = $v['ense_end_amount'];
                if (substr($v['ense_order_number'], 0, 2) != 'DB') {
                    if (!is_numeric($v['ense_out_amount'])) {
                        $v['ense_out_amount'] = substr($v['ense_out_amount'], 1, strlen($v['ense_out_price']) - 1);
                    }
                    if (!is_numeric($v['ense_out_price'])) {
                        $v['ense_out_price'] = substr($v['ense_out_price'], 1, strlen($v['ense_out_price']) - 1);
                    }
                    $isarray[$v['ense_goo_id']]['ense_out_num'] = $isarray[$v['ense_goo_id']]['ense_out_num'] + $v['ense_out_num'];
                    $isarray[$v['ense_goo_id']]['ense_out_amount'] = $isarray[$v['ense_goo_id']]['ense_out_amount'] + $v['ense_out_amount'];
                    $isarray[$v['ense_goo_id']]['ense_in_num'] = $isarray[$v['ense_goo_id']]['ense_in_num'] + $v['ense_in_num'];
                    $isarray[$v['ense_goo_id']]['ense_in_amount'] = $isarray[$v['ense_goo_id']]['ense_in_amount'] + $v['ense_in_amount'];
                } else {
                    $statistics_data['mouthnums'] = sprintf("%.4f", $statistics_data['mouthnums'] + $v['ense_in_num'] - $v['ense_out_num']);
                    $statistics_data['mouthprice'] = sprintf("%.4f", $statistics_data['mouthprice'] + $v['ense_in_amount'] - $v['ense_out_amount']);
                }
            } else {
                if (substr($v['ense_order_number'], 0, 2) == 'DB') {
                    $statistics_data['mouthnums'] = sprintf("%.4f", $statistics_data['mouthnums'] + $v['ense_in_num'] - $v['ense_out_num']);
                    $statistics_data['mouthprice'] = sprintf("%.4f", $statistics_data['mouthprice'] + $v['ense_in_amount'] - $v['ense_out_amount']);
                    $v['ense_out_num'] = 0;
                    $v['ense_out_amount'] = 0;
                    $v['ense_in_num'] = 0;
                    $v['ense_in_amount'] = 0;
                }
                $isarray[$v['ense_goo_id']] = $v;
                $isarray[$v['ense_goo_id']]['ense_new_inventory'] = $v['ense_new_inventory'];
                $isarray[$v['ense_goo_id']]['ense_new_price'] = $v['ense_new_price'];
                $isarray[$v['ense_goo_id']]['ense_new_amount'] = $v['ense_new_amount'];
                $isarray[$v['ense_goo_id']]['ense_end_inventory'] = $v['ense_end_inventory'];
                $isarray[$v['ense_goo_id']]['ense_end_price'] = $v['ense_end_price'];
                $isarray[$v['ense_goo_id']]['ense_end_amount'] = $v['ense_end_amount'];
            }
        }
        $statistics_data['ense_new_inventory'] = 0;
        $statistics_data['ense_new_price'] = 0;
        $statistics_data['ense_new_amount'] = 0;
        $statistics_data['ense_end_inventory'] = 0;
        $statistics_data['ense_end_price'] = 0;
        $statistics_data['ense_end_amount'] = 0;
        $statistics_data['ense_out_num'] = 0;
        $statistics_data['ense_out_amount'] = 0;
        $statistics_data['ense_in_num'] = 0;
        $statistics_data['ense_in_amount'] = 0;
        foreach ($isarray as $k => $v) {
            $statistics_data['ense_new_inventory'] = $statistics_data['ense_new_inventory'] + $v['ense_new_inventory'];
            $statistics_data['ense_new_price'] = sprintf("%.4f", $statistics_data['ense_new_price'] + $v['ense_new_price']);
            $statistics_data['ense_new_amount'] = sprintf("%.4f", $statistics_data['ense_new_amount'] + $v['ense_new_amount']);
            $statistics_data['ense_end_inventory'] = $statistics_data['ense_end_inventory'] + $v['ense_end_inventory'];
            $statistics_data['ense_end_price'] = sprintf("%.4f", $statistics_data['ense_end_price'] + $v['ense_end_price']);
            $statistics_data['ense_end_amount'] = sprintf("%.4f", $statistics_data['ense_end_amount'] + $v['ense_end_amount']);
            $statistics_data['ense_out_num'] = $statistics_data['ense_out_num'] + $v['ense_out_num'];
            $statistics_data['ense_out_amount'] = sprintf("%.4f", $statistics_data['ense_out_amount'] + $v['ense_out_amount']);
            $statistics_data['ense_in_num'] = $statistics_data['ense_in_num'] + $v['ense_in_num'];
            $statistics_data['ense_in_amount'] = sprintf("%.4f", $statistics_data['ense_in_amount'] + $v['ense_in_amount']);
        }
        if ($statistics_data['ense_in_num'] == '0') {
            $statistics_data['ense_in_price'] = '0';
        } else {
            $statistics_data['ense_in_price'] = sprintf("%.4f", $statistics_data['ense_in_amount'] / $statistics_data['ense_in_num']);
        }
        if ($statistics_data['ense_out_num'] == '0') {
            $statistics_data['ense_out_price'] = '0';
        } else {
            $statistics_data['ense_out_price'] = sprintf("%.4f", $statistics_data['ense_out_amount'] / $statistics_data['ense_out_num']);
        }
        if ($statistics_data['ense_end_inventory'] == '0') {
            $statistics_data['ense_end_price'] = '0';
        } else {
            $statistics_data['ense_end_price'] = sprintf("%.4f", $statistics_data['ense_end_amount'] / $statistics_data['ense_end_inventory']);
        }
        if ($statistics_data['ense_new_inventory'] == '0') {
            $statistics_data['ense_new_price'] = '0';
        } else {
            $statistics_data['ense_new_price'] = sprintf("%.4f", $statistics_data['ense_new_amount'] / $statistics_data['ense_new_inventory']);
        }
        $hzce = sprintf("%.0f", $statistics_data['ense_end_price'] - $statistics_data['ense_new_price']);
        $statistics_data['new_end_price'] = $hzce;
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;        //一页显示多少个
        $data_info['data'] = $return_data;                        //返回数据
        $data_info['statistics_data'] = $statistics_data;                        //返回数据

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'list_button'=>$list_button]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }
    
}
