<?php

namespace App\Http\Controllers\Api\AccountControl;

use Illuminate\Http\Request;
use App\Http\Models\Api\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
// use App\Http\Controllers\Api\Verify\AccountControl\VerifyMatchOrderController;
use App\Http\Models\Api\Export;

// 对单列表
class MatchOrderController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 对单列表
    public function index(Request $request)
    {
        // 验证数据
        if (empty($request['pri_id'])) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $search_data = $request->all();

        $orderby_type = 'desc'; //排序类型，默认倒序查询
        // 当查询待接单状态订单时，按正序查询
        if (!empty($request['ord_wor_state']) && $request['ord_wor_state'] == 7) {
            $orderby_type = 'asc'; //默认排序类型
        }
        $list_data = DB::table('order as a')
            ->leftJoin('order_client as b', 'b.orcl_ord_id', '=', 'a.ord_id')
            ->leftJoin('channel_unit as cu', 'cu.chun_id', '=', 'a.ord_client_id')
            ->leftJoin('admin as as', 'as.adm_id', '=', 'a.ord_create_id')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_superior_shop_id', $shop_id)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_order_number'])) {
                    $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_channel_unit'])) {
                    $query->where('orcl_channel_unit', 'like', '%' . $search_data['orcl_channel_unit'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_name'])) {
                    $query->where('orcl_name', 'like', '%' . $search_data['orcl_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_type'])) {
                    $query->where('ord_type', $search_data['ord_type']);
                }
            }) //买家类型：1会员零售2客户单位3速电网单
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_service_type'])) {
                    $query->where('ord_service_type', $search_data['ord_service_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_create_id'])) {
                    $query->where('a.ord_create_id', $search_data['ord_create_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_state'])) {
                    $query->where('ord_state', $search_data['ord_state']);
                }
            })
            ->where(function ($query) use ($search_data) {
                // 订单完成状态4已完成，其他值是未完成
                if (!empty($search_data['ord_wor_state'])) {
                    if ($search_data['ord_wor_state'] == 4) {
                        $query->where('ord_wor_state', $search_data['ord_wor_state']);
                    } else {
                        $query->where('ord_wor_state', '<>', 4);
                    }
                }
            })
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ord_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_form_type'])) {
                    $query->where('ord_form_type', $search_data['ord_form_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_shipment_party'])) {
                    $query->where('orcl_shipment_party', $search_data['orcl_shipment_party']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_service_shop_id'])) {
                    $query->where('ord_service_shop_id', $search_data['ord_service_shop_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_client_id'])) {
                    $query->where('ord_client_id', $search_data['ord_client_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_match_type'])) {
                    $query->where('orcl_match_type', $search_data['orcl_match_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ware_id'])) {
                    $query->where('ord_ware_id', $search_data['ware_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_payment_way'])) {
                    $query->where('ord_payment_way', $search_data['ord_payment_way']);
                }
            }) //结算方式1.账期 2.现结 3微信 4支付宝
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_match_adm_id'])) {
                    $query->where('orcl_match_adm_id', $search_data['orcl_match_adm_id']);
                }
            })//对单人
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['match_time_start']) && !empty($search_data['match_time_end'])) {
                    $query->whereBetween('orcl_match_time', [$search_data['match_time_start'], $search_data['match_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['match_time_start'])) {
                        $query->where('orcl_match_time', '>=', $search_data['match_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['match_time_end'])) {
                            $query->where('orcl_match_time', '<=', $search_data['match_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })//对单时间
            ->select('ord_id', 'ord_order_number', 'adm_name', 'chun_unit_name', 'ord_actual_price', 'ord_create_time', 'ord_service_type', 'orcl_match_type', 'ord_client_id', 'orcl_shipment_party', 'ord_type', 'ord_ware_id', 'ord_plus_minus', 'ord_payment_way', 'orcl_match_adm_id', 'orcl_match_time', 'orcl_name', 'ord_wor_state')
            ->orderBy('ord_id', $orderby_type)
            ->paginate($this->show_count);


        $list_items = $list_data->items();

        $ord_client_one = [];
        $ord_client_two = [];
        $ord_client_four = [];
        $ware_id = [];
        if ($list_items) {
            // 将对象转化为数组
            $list_items = json_decode(json_encode($list_items), true);
            $ord_client_id = array_column($list_items, 'ord_client_id');
            // 会员零售
            $mem = DB::table('member')
                ->whereIn('mem_id', $ord_client_id)
                ->pluck('mem_name', 'mem_id');
            // 查询客户单位
            $channel = DB::table('channel_unit')
                ->whereIn('chun_id', $ord_client_id)
                ->pluck('chun_unit_name', 'chun_id');
            // 虚拟加盟店
            $virtual = DB::table('virtual_shop')
                ->whereIn('vish_id', $ord_client_id)
                ->pluck('vish_name', 'vish_id');
            $ware_id = array_column($list_items, 'ord_ware_id');
            $orcl_match_adm_id = array_column($list_items, 'orcl_match_adm_id');
            // 仓库
            $ware = DB::table('warehouse')
                ->whereIn('ware_id', $ware_id)
                ->pluck('ware_name', 'ware_id');
            // 对单人
            $match_name = DB::table('admin')
                ->whereIn('adm_id', $orcl_match_adm_id)
                ->pluck('adm_name', 'adm_id');
            foreach ($list_items as $key => $value) {
                $list_items[$key]['ord_order_number'] = $value['ord_order_number'];
                $list_items[$key]['adm_name'] = $value['adm_name'];
                if ($value['ord_type'] == 1) {
                    if (empty($mem[$value['ord_client_id']])) {
                        $list_items[$key]['chun_unit_name'] = $value['orcl_name'];
                    } else {
                        $list_items[$key]['chun_unit_name'] = $mem[$value['ord_client_id']];
                    }
                } elseif ($value['ord_type'] == 2) {
                    $list_items[$key]['chun_unit_name'] = $channel[$value['ord_client_id']];
                } elseif ($value['ord_type'] == 3) {
                    $list_items[$key]['chun_unit_name'] = config('apisystem.sd_chan_info')['name'];
                } elseif ($value['orcl_shipment_party'] == 4) {
                    $list_items[$key]['chun_unit_name'] = $virtual[$value['ord_client_id']];
                }
                $list_items[$key]['ord_actual_price'] = $value['ord_actual_price']; //结算金额
                if (isset($ware[$value['ord_ware_id']])) {
                    $list_items[$key]['ware_name'] = $ware[$value['ord_ware_id']];
                } else {
                    $list_items[$key]['ware_name'] = '';
                }
                //对单人
                if (isset($match_name[$value['orcl_match_adm_id']])) {
                    $list_items[$key]['orcl_match_name'] = $match_name[$value['orcl_match_adm_id']];
                } else {
                    $list_items[$key]['orcl_match_name'] = '';
                }
            }
        }
        // 查询门店打印模板
        $shpt_data = DB::table('shop_print_template')
            ->where('shpt_shop_id', $user_info->adm_shop_id)
            ->whereIn('shpt_print_type', [14])
            ->where('shpt_delete', 1)
            ->select('shpt_id', 'shpt_print_type', 'shpt_isdefault')
            ->get()->toArray();
        if (empty($shpt_data)) {
            $shpt_data = [];
        }
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;        //一页显示多少个
        $data_info['data'] = $list_items;                        //返回数据
        $data_info['shpt_data'] = $shpt_data;                    //模板id

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'list_button'=>$list_button]);
    }

    // 确认
    public function affirm(Request $request)
    {
        // 验证数据
        if (empty($request['ord_id'])) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误']);
        }
        //获取用户信息
        $user_info = Common::getUserInfo($request['api_token']);
        $ord_order_number = DB::table('order')->where('ord_id', $request['ord_id'])->value('ord_order_number');
        $update_data['orcl_match_type'] = 2;
        $update_data['orcl_update_time'] = date('Y-m-d H:i:s');
        $update_data['orcl_match_adm_id'] = $user_info->adm_id;
        $update_data['orcl_match_time'] = date('Y-m-d H:i:s');

        $res = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->update($update_data);

        if ($res) {
            Common::addLog($user_info, getRealIp($request), '对单列表', '确认对单', '订单：' . $ord_order_number);
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'确认对单成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'确认对单失败']);
        }
    }

    // 取消确认
    public function unAffirm(Request $request)
    {
        // 验证数据
        if (empty($request['ord_id'])) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误']);
        }
        //获取用户信息
        $user_info = Common::getUserInfo($request['api_token']);
        $ord_order_number = DB::table('order')->where('ord_id', $request['ord_id'])->value('ord_order_number');

        $res = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->update(['orcl_match_type' => 1, 'orcl_update_time' => date('Y-m-d H:i:s'), 'orcl_match_adm_id' => '', 'orcl_match_time' => '0000-00-00 00:00:00']);

        if ($res) {
            Common::addLog($user_info, getRealIp($request), '对单列表', '取消对单', '订单：' . $ord_order_number);
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'取消对单成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'取消对单失败']);
        }
    }

    // 打印
    public function print(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();

        $orderby_type = 'desc'; //排序类型，默认倒序查询
        // 当查询待接单状态订单时，按正序查询
        if (!empty($request['ord_wor_state']) && $request['ord_wor_state'] == 7) {
            $orderby_type = 'asc'; //默认排序类型
        }

        $data = DB::table('order as a')
            ->leftJoin('order_client as b', 'b.orcl_ord_id', '=', 'a.ord_id')
            ->leftJoin('admin as as', 'as.adm_id', '=', 'a.ord_create_id')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_superior_shop_id', $shop_id)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_order_number'])) {
                    $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_channel_unit'])) {
                    $query->where('orcl_channel_unit', 'like', '%' . $search_data['orcl_channel_unit'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_name'])) {
                    $query->where('orcl_name', 'like', '%' . $search_data['orcl_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_type'])) {
                    $query->where('ord_type', $search_data['ord_type']);
                }
            }) //买家类型：1会员零售2客户单位3速电网单
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_service_type'])) {
                    $query->where('ord_service_type', $search_data['ord_service_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_create_id'])) {
                    $query->where('a.ord_create_id', $search_data['ord_create_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_state'])) {
                    $query->where('ord_state', $search_data['ord_state']);
                }
            })
            ->where(function ($query) use ($search_data) {
                // 订单完成状态4已完成，其他值是未完成
                if (!empty($search_data['ord_wor_state'])) {
                    if ($search_data['ord_wor_state'] == 4) {
                        $query->where('ord_wor_state', $search_data['ord_wor_state']);
                    } else {
                        $query->where('ord_wor_state', '<>', 4);
                    }
                }
            })
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ord_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_form_type'])) {
                    $query->where('ord_form_type', $search_data['ord_form_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_shipment_party'])) {
                    $query->where('orcl_shipment_party', $search_data['orcl_shipment_party']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_service_shop_id'])) {
                    $query->where('ord_service_shop_id', $search_data['ord_service_shop_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_client_id'])) {
                    $query->where('ord_client_id', $search_data['ord_client_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_match_type'])) {
                    $query->where('orcl_match_type', $search_data['orcl_match_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ware_id'])) {
                    $query->where('ord_ware_id', $search_data['ware_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_payment_way'])) {
                    $query->where('ord_payment_way', $search_data['ord_payment_way']);
                }
            }) //结算方式：1账期2现结
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_match_adm_id'])) {
                    $query->where('orcl_match_adm_id', $search_data['orcl_match_adm_id']);
                }
            })//对单人
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['match_time_start']) && !empty($search_data['match_time_end'])) {
                    $query->whereBetween('orcl_match_time', [$search_data['match_time_start'], $search_data['match_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['match_time_start'])) {
                        $query->where('orcl_match_time', '>=', $search_data['match_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['match_time_end'])) {
                            $query->where('orcl_match_time', '<=', $search_data['match_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })//对单时间
            ->select('ord_id', 'ord_order_number', 'adm_name', 'ord_client_id', 'ord_actual_price', 'ord_ware_id', 'ord_create_time', 'ord_service_type', 'orcl_match_type', 'orcl_shipment_party', 'ord_type', 'orcl_name', 'ord_payment_way')
            ->orderBy('ord_id', $orderby_type)
            ->limit(1000)
            ->get()->toArray();
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            $ord_client_id = array_column($data, 'ord_client_id');
            // 会员零售
            $mem = DB::table('member')
                ->whereIn('mem_id', $ord_client_id)
                ->pluck('mem_name', 'mem_id');
            // 查询客户单位
            $channel = DB::table('channel_unit')
                ->whereIn('chun_id', $ord_client_id)
                ->pluck('chun_unit_name', 'chun_id');
            // 虚拟加盟店
            $virtual = DB::table('virtual_shop')
                ->whereIn('vish_id', $ord_client_id)
                ->pluck('vish_name', 'vish_id');
            $ware_id = array_column($data, 'ord_ware_id');
            // 仓库
            $ware = DB::table('warehouse')
                ->whereIn('ware_id', $ware_id)
                ->pluck('ware_name', 'ware_id');
            foreach ($data as $key => $value) {
                $dataInfo[$key]['ord_order_number'] = $value['ord_order_number'];
                $dataInfo[$key]['adm_name'] = $value['adm_name'];
                if ($value['ord_type'] == 1) {
                    if (empty($mem[$value['ord_client_id']])) {
                        $dataInfo[$key]['chun_unit_name'] = $value['orcl_name'];
                    } else {
                        $dataInfo[$key]['chun_unit_name'] = $mem[$value['ord_client_id']];
                    }
                } elseif ($value['ord_type'] == 2) {
                    $dataInfo[$key]['chun_unit_name'] = $channel[$value['ord_client_id']];
                } elseif ($value['ord_type'] == 3) {
                    $dataInfo[$key]['chun_unit_name'] = config('apisystem.sd_chan_info')['name'];
                } elseif ($value['orcl_shipment_party'] == 4) {
                    $dataInfo[$key]['chun_unit_name'] = $virtual[$value['ord_client_id']];
                }
                $dataInfo[$key]['ord_actual_price'] = $value['ord_actual_price'] / 100; //结算金额
                if (isset($ware[$value['ord_ware_id']])) {
                    $dataInfo[$key]['ware_name'] = $ware[$value['ord_ware_id']];
                } else {
                    $dataInfo[$key]['ware_name'] = '';
                }
                $dataInfo[$key]['ord_create_time'] = $value['ord_create_time'];
                // 订单类型
                if ($value['ord_service_type'] == '1') {
                    $dataInfo[$key]['ord_service_type'] = '服务单';
                } elseif ($value['ord_service_type'] == '2') {
                    $dataInfo[$key]['ord_service_type'] = '销售单';
                } elseif ($value['ord_service_type'] == '3') {
                    $dataInfo[$key]['ord_service_type'] = '换货单';
                } elseif ($value['ord_service_type'] == '4') {
                    $dataInfo[$key]['ord_service_type'] = '退货单';
                } elseif ($value['ord_service_type'] == '5') {
                    $dataInfo[$key]['ord_service_type'] = '发货单';
                } elseif ($value['ord_service_type'] == '6') {
                    $dataInfo[$key]['ord_service_type'] = '结清单';
                } elseif ($value['ord_service_type'] == '7') {
                    $dataInfo[$key]['ord_service_type'] = '救援单';
                }
                // 对单状态
                if ($value['orcl_match_type'] == '1') {
                    $dataInfo[$key]['orcl_match_type'] = '未确认';
                } elseif ($value['orcl_match_type'] == '2') {
                    $dataInfo[$key]['orcl_match_type'] = '已确认';
                }
                // 结算方式
                if ($value['ord_payment_way'] == '1') {
                    $dataInfo[$key]['ord_payment_way'] = '账期';
                } elseif ($value['ord_payment_way'] == '2') {
                    $dataInfo[$key]['ord_payment_way'] = '现结';
                } elseif ($value['ord_payment_way'] == '3') {
                    $dataInfo[$key]['ord_payment_way'] = '微信';
                } elseif ($value['ord_payment_way'] == '4') {
                    $dataInfo[$key]['ord_payment_way'] = '支付宝';
                }
            }
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$dataInfo]);
        } else {
            return response()->json(['code'=> 500, 'msg'=> 'error', 'data'=> '没有符合条件的数据']);
        }
    }

    // 导出
    public function export(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $search_data = $request->all();

        $orderby_type = 'desc'; //排序类型，默认倒序查询
        // 当查询待接单状态订单时，按正序查询
        if (!empty($request['ord_wor_state']) && $request['ord_wor_state'] == 7) {
            $orderby_type = 'asc'; //默认排序类型
        }

        $data = DB::table('order as a')
            ->leftJoin('order_client as b', 'b.orcl_ord_id', '=', 'a.ord_id')
            ->leftJoin('admin as as', 'as.adm_id', '=', 'a.ord_create_id')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_superior_shop_id', $shop_id)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_order_number'])) {
                    $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_channel_unit'])) {
                    $query->where('orcl_channel_unit', 'like', '%' . $search_data['orcl_channel_unit'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_name'])) {
                    $query->where('orcl_name', 'like', '%' . $search_data['orcl_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_type'])) {
                    $query->where('ord_type', $search_data['ord_type']);
                }
            }) //买家类型：1会员零售2客户单位3速电网单
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_service_type'])) {
                    $query->where('ord_service_type', $search_data['ord_service_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_create_id'])) {
                    $query->where('a.ord_create_id', $search_data['ord_create_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_state'])) {
                    $query->where('ord_state', $search_data['ord_state']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_wor_state'])) {
                    if ($search_data['ord_wor_state'] == 4) {
                        $query->where('ord_wor_state', $search_data['ord_wor_state']);
                    } else {
                        $query->where('ord_wor_state', '<>', 4);
                    }
                }
            })
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ord_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_form_type'])) {
                    $query->where('ord_form_type', $search_data['ord_form_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_shipment_party'])) {
                    $query->where('orcl_shipment_party', $search_data['orcl_shipment_party']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_service_shop_id'])) {
                    $query->where('ord_service_shop_id', $search_data['ord_service_shop_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_client_id'])) {
                    $query->where('ord_client_id', $search_data['ord_client_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_match_type'])) {
                    $query->where('orcl_match_type', $search_data['orcl_match_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ware_id'])) {
                    $query->where('ord_ware_id', $search_data['ware_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_payment_way'])) {
                    $query->where('ord_payment_way', $search_data['ord_payment_way']);
                }
            }) //结算方式：1账期2现结
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_match_adm_id'])) {
                    $query->where('orcl_match_adm_id', $search_data['orcl_match_adm_id']);
                }
            })//对单人
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['match_time_start']) && !empty($search_data['match_time_end'])) {
                    $query->whereBetween('orcl_match_time', [$search_data['match_time_start'], $search_data['match_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['match_time_start'])) {
                        $query->where('orcl_match_time', '>=', $search_data['match_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['match_time_end'])) {
                            $query->where('orcl_match_time', '<=', $search_data['match_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })//对单时间
            ->select('ord_id', 'ord_order_number', 'adm_name', 'ord_client_id', 'ord_actual_price', 'ord_ware_id', 'ord_create_time', 'ord_service_type', 'orcl_match_type', 'orcl_shipment_party', 'ord_type', 'orcl_name', 'ord_payment_way', 'orcl_match_adm_id', 'orcl_match_time')
            ->orderBy('ord_id', $orderby_type)
            ->limit(1000)
            ->get()->toArray();
        
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            $ord_client_id = array_column($data, 'ord_client_id');
            // 会员零售
            $mem = DB::table('member')
                ->whereIn('mem_id', $ord_client_id)
                ->pluck('mem_name', 'mem_id');
            // 查询客户单位
            $channel = DB::table('channel_unit')
                ->whereIn('chun_id', $ord_client_id)
                ->pluck('chun_unit_name', 'chun_id');
            // 虚拟加盟店
            $virtual = DB::table('virtual_shop')
                ->whereIn('vish_id', $ord_client_id)
                ->pluck('vish_name', 'vish_id');
            $ware_id = array_column($data, 'ord_ware_id');
            // 仓库
            $ware = DB::table('warehouse')
                ->whereIn('ware_id', $ware_id)
                ->pluck('ware_name', 'ware_id');
            // 对单人
            $orcl_match_adm_id = array_column($data, 'orcl_match_adm_id');
            $admin = DB::table('admin')
                ->whereIn('adm_id', $orcl_match_adm_id)
                ->pluck('adm_name', 'adm_id');
            foreach ($data as $key => $value) {
                if ($value['ord_type'] == 1) {
                    if (empty($mem[$value['ord_client_id']])) {
                        $data[$key]['ord_client_id'] = $value['orcl_name'];
                    } else {
                        $data[$key]['ord_client_id'] = $mem[$value['ord_client_id']];
                    }
                } elseif ($value['ord_type'] == 2) {
                    $data[$key]['ord_client_id'] = $channel[$value['ord_client_id']];
                } elseif ($value['ord_type'] == 3) {
                    $data[$key]['ord_client_id'] = config('apisystem.sd_chan_info')['name'];
                } elseif ($value['orcl_shipment_party'] == 4) {
                    $data[$key]['ord_client_id'] = $virtual[$value['ord_client_id']];
                }
                if (isset($ware[$value['ord_ware_id']])) {
                    $data[$key]['ord_ware_id'] = $ware[$value['ord_ware_id']];
                } else {
                    $data[$key]['ord_ware_id'] = '';
                }
                
                $data[$key]['ord_actual_price'] = $value['ord_actual_price'] / 100; //结算金额
                
                // 对单状态
                if ($value['orcl_match_type'] == '1') {
                    $data[$key]['orcl_match_type'] = '未确认';
                } elseif ($value['orcl_match_type'] == '2') {
                    $data[$key]['orcl_match_type'] = '已确认';
                }

                // 结算方式
                if ($value['ord_payment_way'] == '1') {
                    $data[$key]['ord_payment_way'] = '账期';
                } elseif ($value['ord_payment_way'] == '2') {
                    $data[$key]['ord_payment_way'] = '现结';
                } elseif ($value['ord_payment_way'] == '3') {
                    $data[$key]['ord_payment_way'] = '微信';
                } elseif ($value['ord_payment_way'] == '4') {
                    $data[$key]['ord_payment_way'] = '支付宝';
                }
               
                // 服务类型
                if ($value['ord_service_type'] == '1') {
                    $data[$key]['ord_service_type'] = '服务单';
                } elseif ($value['ord_service_type'] == '2') {
                    $data[$key]['ord_service_type'] = '销售单';
                } elseif ($value['ord_service_type'] == '3') {
                    $data[$key]['ord_service_type'] = '换货单';
                } elseif ($value['ord_service_type'] == '4') {
                    $data[$key]['ord_service_type'] = '退货单';
                } elseif ($value['ord_service_type'] == '5') {
                    $data[$key]['ord_service_type'] = '发货单';
                } elseif ($value['ord_service_type'] == '6') {
                    $data[$key]['ord_service_type'] = '结清单';
                } elseif ($value['ord_service_type'] == '7') {
                    $data[$key]['ord_service_type'] = '救援单';
                }

                if (isset($admin[$value['orcl_match_adm_id']])) {
                    $data[$key]['orcl_match_adm_id'] = $admin[$value['orcl_match_adm_id']];
                } else {
                    $data[$key]['orcl_match_adm_id'] = '';
                }
                
                unset($data[$key]['ord_id']);
                unset($data[$key]['orcl_shipment_party']);
                unset($data[$key]['ord_type']);
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }
        $streamFileRand = '对单列表' . time() . rand(1000, 9999) . '.xls';
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '对单列表';
        $where['field_name'] = ['订单编号', '开单人', '客户单位', '结算金额', '仓库名称', '开单时间', '订单类型', '对单状态', '姓名', '结算方式', '对单人', '对单时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }
}
