<?php

namespace App\Http\Controllers\Api\AccountControl;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\AccountControl\VerifyAccountSubjectController;
use App\Http\Controllers\Api\YongYou\YongYouController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

// 账户管理-科目列表-用友系统
class AccountSubjectController extends Controller
{
	// 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyAccountSubjectController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        $list_data = DB::table('account_subject as acsu')
            ->leftJoin('account_subject_sublist as acss', 'acss.acss_acsu_id', '=', 'acsu.acsu_id')
            ->where('acsu_cid', $user_info->adm_cid)
            ->where('acsu_shop_id', $user_info->adm_shop_id)
            ->where('acsu_shop_superior_id', $shop_id)
            ->where('subjlev', 1)
            ->where(function($query) use($search_data) {
                if (!empty($search_data['subjcode'])) {
                    $query->where('subjcode', 'like', '%'.$search_data['subjcode'].'%');
                }
            }) //科目编码
            ->where(function($query) use($search_data) {
                if (!empty($search_data['subjname'])) {
                    $query->where('subjname', 'like', '%'.$search_data['subjname'].'%' );
                }
            }) //科目名称
            ->where(function($query) use($search_data) {
                if (!empty($search_data['dispname'])) {
                    $query->where('dispname', 'like', '%'.$search_data['dispname'].'%' );
                }
            }) //显示名称
            ->where(function($query) use($search_data) {
                if (!empty($search_data['engsubjname'])) {
                    $query->where('engsubjname', 'like', '%'.$search_data['engsubjname'].'%' );
                }
            }) //英文名称
            ->where(function($query) use($search_data) {
                if (!empty($search_data['remcode'])) {
                    $query->where('remcode', 'like', '%'.$search_data['remcode'].'%' );
                }
            }) //助记码
            ->where(function($query) use($search_data) {
                if (!empty($search_data['balanorient'])) {
                    $query->where('balanorient', $search_data['balanorient']);
                }
            }) //科目方向 1:借2:贷
            ->where(function($query) use($search_data) {
                if (!empty($search_data['endflag'])) {
                    $query->where('endflag', $search_data['endflag']);
                }
            }) //是否末级：Y：是/N：否
            ->where(function($query) use($search_data) {
                if (!empty($search_data['typeindex'])) {
                    $query->where('typeindex', $search_data['typeindex']);
                }
            }) //科目类型顺序号
            ->select('acsu_id', 'subjcode', 'subjname', 'dispname', 'engsubjname', 'remcode', 'subjlev', 'endflag',
                     'balanorient', 'sealflag', 'beginyear', 'beginperiod', 'acsu_bdin_id', 'typeindex')
            ->orderBy('subjcode', 'asc')
            ->paginate($this->show_count);
        $list_items = $list_data->items();
        if ($list_items) {
        	$list_items = $this->inquireChildren($user_info, $list_items, 1, []);
        	$suty_data =  DB::table('subject_type')
				            ->select('typeindex', 'subjtypename')
				            ->get();
        	$data_info['suty_data'] = $suty_data;//科目类型数据

        	$bdin_data =  DB::table('bdinfo')
				            ->select('bdin_id', 'bdname')
				            ->get();
        	$data_info['bdin_data'] = $bdin_data;//辅助核算项数据
        }
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;        //一页显示多少个
        $data_info['data'] = $list_items;                //返回数据

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if($list_data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info, 'list_button'=>$list_button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }

    /**
     * [inquireChildren 搜索下级数据]
     * @param  [type]  $user_info [用户信息]
     * @param  [type]  $data      [列表数据]
     * @param  integer $subjlev   [科目级数]
     * @return [type]             [description]
     */
    private function inquireChildren($user_info, $data, $subjlev = 1, $acsu_bdin_id)
    {
    	$subjlev = $subjlev + 1;//科目级次
    	foreach ($data as $key => $value) {
    		if ($value->endflag == 'N') {
    			$children = DB::table('account_subject as acsu')
		            ->leftJoin('account_subject_sublist as acss', 'acss.acss_acsu_id', '=', 'acsu.acsu_id')
		            ->where('acsu_cid', $user_info->adm_cid)
		            ->where('acsu_shop_id', $user_info->adm_shop_id)
		            ->where('subjcode', 'like', $value->subjcode.'%' )
		            ->where('subjlev', $subjlev)
		            ->select('acsu_id', 'subjcode', 'subjname', 'dispname', 'engsubjname', 'remcode', 'subjlev', 'endflag',
		                     'balanorient', 'sealflag', 'beginyear', 'beginperiod', 'acsu_bdin_id', 'typeindex')
		            ->get();
		        // 递归查询下一级的数据
		        $data[$key]->children = $this->inquireChildren($user_info, $children, $subjlev, $acsu_bdin_id);
    		}
    	}
    	return $data;
    }

    // 详情
    public function info(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyAccountSubjectController;
        $error_message = $verify_data->infoValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $search_data = $request->all();
        $find_data = DB::table('account_subject as acsu')
            ->leftJoin('account_subject_sublist as acss', 'acss.acss_acsu_id', '=', 'acsu.acsu_id')
            ->where('acsu_id', $request['acsu_id'])
            ->select('acsu_id', 'subjcode', 'subjname', 'dispname', 'engsubjname', 'remcode', 'subjlev', 'endflag',
                     'balanorient', 'sealflag', 'beginyear', 'beginperiod', 'acsu_bdin_id', 'typeindex', 'acss_bdinfo',
                     'cashbankflag', 'currency', 'sumprint_level', 'incurflag', 'balanflag', 'accremove', 
                     'outflag', 'bothorient', 'innersubj', 'unit')
            ->first();

    	// 获取科目类型顺序号
    	if (!empty($find_data->typeindex)) {
    		$suty_data =  DB::table('subject_type')
			            ->where('typeindex', $find_data->typeindex)
			            ->select('typeindex', 'subjtypename')
			            ->get();
    		$data_info['suty_data'] = $suty_data;//科目类型数据
    	}

        $find_data->numberAccounting = empty($find_data->unit) ? 'N' : 'Y';//数量核算取值：Y：是/N：否；判断计量单位
    	$find_data->sealflag = empty($find_data->sealflag) ? 'N' : 'Y';//封存：Y：是/N：否
    	// 辅助核算项id
    	if ($find_data->acsu_bdin_id) {
    		$acsu_bdin_id = array_unique(explode(',', $find_data->acsu_bdin_id));

    		$bdin_data =  DB::table('bdinfo')
			            ->whereIn('bdin_id', $acsu_bdin_id)
			            ->select('bdin_id', 'bdcode', 'bdname')
			            ->get();
    		$data_info['bdin_data'] = $bdin_data;//辅助核算项数据
    	}
        $data_info['data'] = $find_data;

        if($data_info) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }

    // 新增
    public function add(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyAccountSubjectController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 判断科目名称是否存在
        $acsu_cid = DB::table('account_subject')
            ->where('acsu_cid', $user_info->adm_cid)
            ->where('acsu_shop_id', $user_info->adm_shop_id)
            ->where('subjname', $request['subjname'])
            ->value('acsu_cid');
        if ($acsu_cid) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'科目名称已存在']);
        }
        $acsu_cid = DB::table('account_subject')
            ->where('acsu_cid', $user_info->adm_cid)
            ->where('acsu_shop_id', $user_info->adm_shop_id)
            ->where('subjcode', $request['subjcode'])
            ->value('acsu_cid');
        if ($acsu_cid) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'科目编码已存在']);
        }

        DB::beginTransaction();
        $add_data['acsu_cid'] = $user_info->adm_cid;//公司id
        $add_data['acsu_shop_id'] = $user_info->adm_shop_id;//门店id
        $add_data['acsu_shop_superior_id'] = $shop_id;//总店id
        $add_data['acsu_adm_id'] = $user_info->adm_id;//创建人id
        $add_data['pk_corp'] = '0001';//公司编码---后台查询
        $add_data['subjcode'] = $request['subjcode'];//科目编码
        $add_data['subjname'] = $request['subjname'];//科目名称
        $add_data['dispname'] = $request['subjname'];//显示名称
        $add_data['engsubjname'] = $request['engsubjname'] ? $request['engsubjname'] : '';//英文名称
        $add_data['balanorient'] = $request['balanorient'];//余额方向 1:借2:贷
        if ($request['sealflag'] == 'Y') {
            $add_data['sealflag'] = date('Y-m-d');//封存标志:封存日期；数据库存的是日期，页面显示 Y N
        }else{
            $add_data['sealflag'] = '';//封存标志:封存日期；数据库存的是日期，页面显示 Y N
        }
        $add_data['incurflag'] = $request['incurflag'];//发生额方向控制取值：Y：是/N：否
        $add_data['balanflag'] = $request['balanflag'];//余额方向控制取值：Y：是/N：否
        $add_data['bothorient'] = $request['bothorient'];//帐簿余额双向显示取值：Y：是/N：否
        $add_data['innersubj'] = $request['innersubj'];//内部交易科目取值：Y：是/N：否
        $add_data['accremove'] = $request['accremove'];//是否核销科目取值：Y：是/N：否
        $add_data['cashbankflag'] = $request['cashbankflag'];//现金银行科目 0:其他1:现金科目2:银行科目3:现金等价物
        $add_data['unit'] = $request['unit'];//计量单位
        $add_data['outflag'] = $request['outflag'];//表外科目取值：Y：是/N：否
        $add_data['remcode'] = $request['remcode'];//助记码
        $subjlev_arr = [4=>1,6=>2,8=>3,10=>4];//科目级次 4-2-2-2
        $subjcode_strlen = strlen($request['subjcode']);//新增的科目编码的长度
        // 判断是不是一级科目
        if ($subjcode_strlen != 4) {
            // 不是一级科目，将上一级的科目 末级标志取值 改为N：否
            $superior_subjcode = substr($request['subjcode'], 0, -2);//上级科目编码
            // 判断上级科目是否存在
            $superior_acsu_id = DB::table('account_subject')
            ->where('acsu_cid', $user_info->adm_cid)
            ->where('acsu_shop_id', $user_info->adm_shop_id)
            ->where('subjcode', $superior_subjcode)
            ->value('acsu_id');
            if (empty($superior_acsu_id)) {
                return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'上级科目不存在！']);
            }
            // 将上一级的科目 末级标志取值 改为N：否 
            $superior_res = DB::table('account_subject')
                ->where('acsu_id', $superior_acsu_id)
                ->update(['endflag'=>'N', 'acsu_update_time'=>date('Y-m-d H:i:s')]);
        }else{
            $superior_res = true;
        }
        $add_data['subjlev'] = $subjlev_arr[$subjcode_strlen];//科目级次
        $add_data['endflag'] = 'Y';//末级标志取值：Y：是/N：否；这个是计算的，后台判断这个科目是否是末级
        $add_data['innerinfonull'] = 'N';//内部交易信息是否必录取值：Y：是/N：否

        $add_data['currency'] = $request['currency'];//科目默认币种，可以不选择,不选择就是null
        $add_data['beginyear'] = '2020';//启用年度，年 2020 四位
        $add_data['beginperiod'] = '06';//启用期间，月 06 两位
        $add_data['stoped'] = 'N';//停用标志取值：Y：是/N：否
        $add_data['createyear'] = '2020';//创建年度
        $add_data['createperiod'] = '06';//创建月份
        $add_data['sumprint_level'] = $request['sumprint_level'];//汇总打印级次 0末级 最大数量是科目级次数量
        $add_data['pk_subjscheme'] = '0001F8100000000001T1';//科目方案
        $add_data['pk_glorgbook'] = '0001F810000000000330';//会计主体账簿
        $add_data['pk_create_glorgbook'] = '0001F810000000000330';//创建会计主体账簿

        $dbin_id_arr = json_decode($request['bdin_id'], true);
        if (!empty($dbin_id_arr)) {
            if (empty($dbin_id_arr)) {
                return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'请选择辅助核算项']);
            }
            $acsu_bdin_id = array_column($dbin_id_arr, 'bdin_id');
            $add_data['acsu_bdin_id'] = implode(',', $acsu_bdin_id);//辅助核算项id
            $acsb_data['acss_bdinfo'] = $request['bdin_id'];//辅助核算项json数据
        }else{
            $add_data['acsu_bdin_id'] = '';
            $acsb_data['acss_bdinfo'] = '';
        }
        $acsu_id =  DB::table('account_subject')->insertGetId($add_data);

        $acsb_data['acss_acsu_id'] = $acsu_id;
        $acsb_data['typeindex'] = $request['typeindex'];//科目类型
        $acsb_res = DB::table('account_subject_sublist')->insert($acsb_data);

        // 科目类型名称
        $add_data['subjtypename'] = DB::table('subject_type')
                ->where('typeindex',$request['typeindex'])
                ->value('subjtypename');

        // 调用u8系统接口，将科目数据传到用友系统上
        $yongyou = new YongYouController;
        // 获取门店对应用友系统的配置数据
        $add_data['unitcode'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['unitcode'];//用友-公司编码
        $add_data['subjschemecode']  = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['subjschemecode'];//用友-科目方案编码
        $add_data['bdin_id_json']  = $acsb_data['acss_bdinfo'];//辅助核算项数据
        // 调用u8系统接口
        $curl_return = $yongyou->u8cloudApi('会计科目从公司新增', $add_data);
        // 判断用友接口返回的数据
        if ($curl_return['status'] != 'success') {
            DB::rollBack();
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'新增科目失败！科目编码已存在！']);
        }

        if($acsu_id && $acsb_res && $superior_res){
            Common::addLog(
                $user_info, 
                getRealIp($request), 
                '账户管理',
                '新增',
                '新增科目'.$request['subjname'].'成功'
            );
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'新增科目成功']);
        }else{
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'新增科目失败']);
        }
    }
    
    // 删除
    public function delete(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyAccountSubjectController;
        $error_message = $verify_data->infoValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $find_data = DB::table('account_subject')
            ->where('acsu_id', $request['acsu_id'])
            ->select('subjcode', 'subjname', 'endflag', 'subjlev')
            ->first();
        if ($find_data->endflag != 'Y') {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'不是末级科目无法删除']);
        }

        // 1. 通过用友的查询接口，查询用友系统这个科目是否已经删除
        $yongyou = new YongYouController;
        // 获取门店对应用友系统的配置数据
        $find_data->unitcode = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['unitcode'];//用友-公司编码
        $find_data->subjschemecode = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['subjschemecode'];//用友-科目方案编码
        // 调用u8系统接口
        $curl_return = $yongyou->u8cloudApi('会计科目查询', $find_data);

        // 判断用友接口返回的数据
        if ($curl_return['status'] == 'success') {
            // 接口返回成功，判断是否返回科目数据
            $success_data = json_decode($curl_return['data'], true);
            if ($success_data['allcount']) {
                // 返回科目数据，说明用友系统还有科目，门店系统无法删除
                return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'请先删除用友U8系统的会计科目！']);
            }
        }else{
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'会计科目删除失败']);
        }

        DB::beginTransaction();
        // 2. 用友系统的科目删除之后，这个科目可以在系统里删除
        $acsu_del_res = DB::table('account_subject')
            ->where('acsu_id', $request['acsu_id'])
            ->delete();
        $acss_del_res = DB::table('account_subject_sublist')
            ->where('acss_acsu_id', $request['acsu_id'])
            ->delete();

        // 判断是否是一级科目
        if ($find_data->subjlev != 1) {
            // 不是一级科目，需要判断是否存在同级科目数据
            $superior_subjcode = substr($find_data->subjcode, 0, -2);//上级科目编码
            // 查询同级科目的数据
            $find_sibling = DB::table('account_subject')
                ->where('acsu_cid', $user_info->adm_cid)
                ->where('acsu_shop_id', $user_info->adm_shop_id)
                ->where('acsu_shop_superior_id', $shop_id)
                ->where('subjcode', 'like', $superior_subjcode.'%')
                ->where('subjlev', $find_data->subjlev)
                ->value('acsu_id');
            
            // 判断同级科目是否全部删除，全部删除之后，上级科目改为 末级
            if (empty($find_sibling)) {
                // 将上一级的科目 末级标志取值 改为Y：是
                $superior_res = DB::table('account_subject')
                    ->where('acsu_cid', $user_info->adm_cid)
                    ->where('acsu_shop_id', $user_info->adm_shop_id)
                    ->where('acsu_shop_superior_id', $shop_id)
                    ->where('subjcode', $superior_subjcode)
                    ->update(['endflag'=>'Y', 'acsu_update_time'=>date('Y-m-d H:i:s')]);
            }else{
                $superior_res = true;
            }
        }else{
            $superior_res = true;
        }

        if($acsu_del_res && $acss_del_res && $superior_res) {
            DB::commit();
            Common::addLog($user_info, getRealIp($request), '账户科目', '删除',  '账户科目 '.$find_data->subjname . '删除成功');
            return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>'删除成功']);
        }else{
            DB::rollBack();
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'删除失败']);
        }
    }

    // 上传凭证搜索-科目
    public function searchSubject(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $search_data = $request->all();
        $list_data =  DB::table('account_subject')
            ->where('acsu_cid', $user_info->adm_cid)
            ->where('acsu_shop_id', $user_info->adm_shop_id)
            ->where('endflag', 'Y')
            ->where(function($query) use($search_data) {
                if (!empty($search_data['subjcode'])) {
                    $query->where('subjcode', 'like', '%'.$search_data['subjcode'].'%');
                }
            }) //科目编码
            ->where(function($query) use($search_data) {
                if (!empty($search_data['subjname'])) {
                    $query->where('subjname', 'like', '%'.$search_data['subjname'].'%' );
                }
            }) //科目名称
            ->select('acsu_id', 'subjcode', 'subjname')
            ->orderBy('subjcode', 'asc')
            ->get();

        if($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data]);
        }else{
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // 辅助核算-基础档案资源列表
    public function searchBdinfo(Request $request)
    {
        $search_data = $request->all();
        $list_data = DB::table('bdinfo')
            ->where(function($query) use($search_data) {
                if (!empty($search_data['bdname'])) {
                    $query->where('bdname', 'like', '%'.$search_data['bdname'].'%');
                }
            }) //基础数据名称
            ->select('bdin_id', 'bdcode', 'bdname')
            ->paginate($this->show_count);
        $list_items = $list_data->items();
        if ($list_items) {
        	foreach ($list_items as $key => $value) {
        		$list_items[$key]->print_type = false;//前端使用参数
        		$list_items[$key]->balance_type = false;//前端使用参数
        	}
        }
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;        //一页显示多少个
        $data_info['data'] = $list_items;                //返回数据

        if($list_data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }

    // 搜索科目类型
    public function searchSubjectType(Request $request)
    {
        $search_data = $request->all();
        $list_data = DB::table('subject_type')
            ->where(function($query) use($search_data) {
                if (!empty($search_data['subjtypename'])) {
                    $query->where('subjtypename', 'like', '%'.$search_data['subjtypename'].'%');
                }
            }) //基础数据名称
            ->select('typeindex', 'subjtypename')
            ->paginate($this->show_count);
        $list_items = $list_data->items();

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;        //一页显示多少个
        $data_info['data'] = $list_items;                //返回数据

        if($list_data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }

    // 搜索币种
    public function searchCurrtype(Request $request)
    {
        $search_data = $request->all();
        $list_data = DB::table('currtype')
            ->where(function($query) use($search_data) {
                if (!empty($search_data['currtypename'])) {
                    $query->where('currtypename', 'like', '%'.$search_data['currtypename'].'%');
                }
            }) //基础数据名称
            ->select('currtypecode', 'currtypename')
            ->get();

        if($list_data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$list_data]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }
}
