<?php

namespace App\Services\WeChatApplet\User;

use Illuminate\Database\Eloquent\Model;
use App\Models\WeChatApplet\User\UserAddress;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\WeChatApplet\User\UserAddressValidator;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Support\Facades\Request;

class UserAddressService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new UserAddress();
        $this->mainValidator = new UserAddressValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *按工单分类查询
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function searchPage($search_data, $show_count = 10)
    {
        $list_data = DB::table('user_address_history')
            ->where('adhi_weus_id', $search_data['weus_id'])
            ->where('adhi_state', 1)
            ->select('adhi_id', 'adhi_province', 'adhi_city', 'adhi_county', 'adhi_address', 'adhi_complete_address')
            ->paginate($show_count);
        $list_items = $list_data->items();

        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    // 记录搜索内容
    public function searchRecord($request)
    {
        // 查询搜索内容是否已添加历史记录
        $find_data = DB::table('user_address_history')
            ->where('adhi_weus_id', $request['weus_id'])
            ->where('adhi_state', 1)
            ->where(function ($query) use ($request) {
                if (!empty($request['province'])) {
                    $query->where('adhi_province', $request['province']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['city'])) {
                    $query->where('adhi_city', $request['city']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['county'])) {
                    $query->where('adhi_county', $request['county']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['address'])) {
                    $query->where('adhi_address', $request['address']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['complete_address'])) {
                    $query->where('adhi_complete_address', $request['complete_address']);
                }
            })
            ->exists();
        if ($find_data) {
            // 已添加记录不做调整
            return $find_data;
        } else {
            // 没有添加记录，把搜索内容添加历史记录
            $data['adhi_province'] = Request::input('province', '');
            $data['adhi_city'] = Request::input('city', '');
            $data['adhi_county'] = Request::input('county', '');
            $data['adhi_address'] = Request::input('address', '');
            $data['adhi_complete_address'] = Request::input('complete_address', '');
            $data['adhi_weus_id'] = $request['weus_id'];
            $data['adhi_update_time'] = date('Y-m-d H:i:s');
            $res = DB::table('user_address_history')->insert($data);
            return $res;
        }
    }

    // 清空历史搜索记录
    public function clearRecord($request)
    {
        $data['adhi_state'] = 2;
        $data['adhi_weus_id'] = $request['weus_id'];
        $data['adhi_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('user_address_history')
            ->where('adhi_weus_id', $request['weus_id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'历史记录清除成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'历史记录清除失败', 'data'=>''];
        }
    }
}
