<?php

namespace App\Services\WeChatApplet\Technician;

use App\Models\OperationLog;
use App\Services\CommonService;
use Illuminate\Database\Eloquent\Model;
use App\Models\WeChatApplet\Technician\AdminMessage;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\WeChatApplet\Technician\AdminMessageValidator;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\Business\WashOrderService;
use Pinyin;

class MemberService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new AdminMessage();
        $this->mainValidator = new AdminMessageValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 添加会员
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public static function addMember($eme)
    {
        $rest = mb_substr($eme['mem_name'], 0, 1, 'utf-8');
        if ($rest) {
            $mb = mb_strlen($rest, 'utf-8');
            $st = strlen($rest);
            if ($st == $mb) { //英文
                $eme['mem_initial'] = strtoupper($rest);
            } else { //汉字
                $eme['mem_initial'] = substr(strtoupper(Pinyin::abbr($eme['mem_name'])), 0, 1);
            }
        } else {
            $eme['mem_initial'] = '';
        }
        $mem_id = DB::table('member')->insertGetId($eme);
        WashOrderService::addFestival($mem_id);//新增节日提醒
        return $mem_id;
        // if ($request['mem_car_num']) {
        //     // 判断车牌号是否存在
        //     $find_meca = DB::table('member')
        //         ->where('mem_id', '<>', $request['mem_id'])
        //         ->where('mem_shop_id', $user_info->adm_shop_id)
        //         ->where('mem_car_num', $request['mem_car_num'])
        //         ->first(['mem_id']);
        //     if ($find_meca) {
        //         return ['code' => 500, 'msg' => '当前车牌号已存在', 'data' => '当前车牌号已存在'];
        //     }
        // }

        // // 2 编辑一个手机号与车牌号的绑定关系
        // $mem_edit_data['mem_car_num'] = str_replace(' ', '', $request['mem_car_num']); //车牌号
        // $mem_edit_data['mem_update_time'] = date('Y-m-d H:i:s');

        // DB::beginTransaction(); //开启回滚事物

        // $mem_res = DB::table('member')
        //     ->where('mem_id', $request['mem_id'])
        //     ->update($mem_edit_data);
        // // 3.新增一个车辆信息
        // if ($request['mem_car_num']) {
        //     $meca_add_data['meca_cid'] = $user_info->adm_cid;
        //     $meca_add_data['meca_shop_id'] = $user_info->adm_shop_id;
        //     $meca_add_data['meca_superior_shop_id'] = $shop_id;
        //     $meca_add_data['meca_create_adm_id'] = $user_info->adm_id;
        //     $meca_add_data['meca_mem_id'] = $request['mem_id'];
        //     $meca_add_data['meca_car_num'] = $request['mem_car_num'];
        //     $meca_id = DB::table('member_car')
        //         ->where('meca_mem_id', $request['mem_id'])
        //         ->value('meca_id');
        //     if ($meca_id) {
        //         $meca_add_data['meca_update_time'] = date('Y-m-d H:i:s');
        //         $meca_res =  DB::table('member_car')
        //             ->where('meca_id', $meca_id)
        //             ->update($meca_add_data);
        //     } else {
        //         $meca_res =  DB::table('member_car')->insert($meca_add_data);
        //     }
        // } else {
        //     $meca_res = true;
        // }
        // if ($mem_res && $meca_res) {
        //     DB::commit();
        //     // Common::addLog($user_info, $request->getClientIp(), '会员列表', '编辑', '编辑会员：' . $request['mem_phone'] . '成功');
        //     return ["code" => 200, 'msg' => '编辑会员车牌号成功', 'data' => ''];
        // } else {
        //     DB::rollback();
        //     return ["code" => 500, 'msg' => '编辑会员车牌号失败', 'data' => ''];
        // }
    }

    /**
     * 根据条件搜索数据内容
     *按工单分类查询
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function editMember($user_info, $request)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        if ($request['mem_car_num']) {
            // 判断车牌号是否存在
            $find_meca = DB::table('member')
                ->where('mem_id', '<>', $request['mem_id'])
                ->where('mem_shop_id', $user_info->adm_shop_id)
                ->where('mem_car_num', $request['mem_car_num'])
                ->first(['mem_id']);
            if ($find_meca) {
                return ['code' => 500, 'msg' => '当前车牌号已存在', 'data' => '当前车牌号已存在'];
            }
        }

        // 2 编辑一个手机号与车牌号的绑定关系
        $mem_edit_data['mem_car_num'] = str_replace(' ', '', $request['mem_car_num']); //车牌号
        $mem_edit_data['mem_update_time'] = date('Y-m-d H:i:s');

        DB::beginTransaction(); //开启回滚事物

        $mem_res = DB::table('member')
            ->where('mem_id', $request['mem_id'])
            ->update($mem_edit_data);
        // 3.新增一个车辆信息
        if ($request['mem_car_num']) {
            $meca_add_data['meca_cid'] = $user_info->adm_cid;
            $meca_add_data['meca_shop_id'] = $user_info->adm_shop_id;
            $meca_add_data['meca_superior_shop_id'] = $shop_id;
            $meca_add_data['meca_create_adm_id'] = $user_info->adm_id;
            $meca_add_data['meca_mem_id'] = $request['mem_id'];
            $meca_add_data['meca_car_num'] = $request['mem_car_num'];
            $meca_id = DB::table('member_car')
                ->where('meca_mem_id', $request['mem_id'])
                ->value('meca_id');
            if ($meca_id) {
                $meca_add_data['meca_update_time'] = date('Y-m-d H:i:s');
                $meca_res =  DB::table('member_car')
                    ->where('meca_id', $meca_id)
                    ->update($meca_add_data);
            } else {
                $meca_res =  DB::table('member_car')->insert($meca_add_data);
            }
        } else {
            $meca_res = true;
        }
        if ($mem_res && $meca_res) {
            DB::commit();
            // Common::addLog($user_info, $request->getClientIp(), '会员列表', '编辑', '编辑会员：' . $request['mem_phone'] . '成功');
            return ["code" => 200, 'msg' => '编辑会员车牌号成功', 'data' => ''];
        } else {
            DB::rollback();
            return ["code" => 500, 'msg' => '编辑会员车牌号失败', 'data' => ''];
        }
    }

    // 编辑会员
    public function edit($user_info, $request)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        if ($request['mem_car_num']) {
            // 判断车牌号是否存在
            $find_meca = DB::table('member')
                ->where('mem_id', '<>', $request['mem_id'])
                ->where('mem_shop_id', $user_info->adm_shop_id)
                ->where('mem_car_num', $request['mem_car_num'])
                ->first(['mem_id']);
            if ($find_meca) {
                return ['code' => 500, 'msg' => '当前车牌号已存在', 'data' => '当前车牌号已存在'];
            }
        }

        // 2 编辑一个手机号与车牌号的绑定关系
        $mem_edit_data['mem_car_num'] = str_replace(' ', '', $request['mem_car_num']); //车牌号
        $mem_edit_data['mem_update_time'] = date('Y-m-d H:i:s');

        DB::beginTransaction(); //开启回滚事物

        $mem_res = DB::table('member')
            ->where('mem_id', $request['mem_id'])
            ->update($mem_edit_data);
        // 3.新增一个车辆信息
        if ($request['mem_car_num']) {
            $meca_add_data['meca_cid'] = $user_info->adm_cid;
            $meca_add_data['meca_shop_id'] = $user_info->adm_shop_id;
            $meca_add_data['meca_superior_shop_id'] = $shop_id;
            $meca_add_data['meca_create_adm_id'] = $user_info->adm_id;
            $meca_add_data['meca_mem_id'] = $request['mem_id'];
            $meca_add_data['meca_car_num'] = $request['mem_car_num'];
            $meca_id = DB::table('member_car')
                ->where('meca_mem_id', $request['mem_id'])
                ->value('meca_id');
            if ($meca_id) {
                $meca_add_data['meca_update_time'] = date('Y-m-d H:i:s');
                $meca_res =  DB::table('member_car')
                    ->where('meca_id', $meca_id)
                    ->update($meca_add_data);
            } else {
                $meca_res =  DB::table('member_car')->insert($meca_add_data);
            }
        } else {
            $meca_res = true;
        }
        if ($mem_res && $meca_res) {
            DB::commit();
            // Common::addLog($user_info, $request->getClientIp(), '会员列表', '编辑', '编辑会员：' . $request['mem_phone'] . '成功');
            return ["code" => 200, 'msg' => '编辑会员车牌号成功', 'data' => ''];
        } else {
            DB::rollback();
            return ["code" => 500, 'msg' => '编辑会员车牌号失败', 'data' => ''];
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 订单编辑用户信息
     * @param array $user_info 用户信息
     * @param array $request 请求信息
     * @retrun /multitype:array
     * @author dou 2025/3/28 16:38
     * |---------------------------------------------------------------------------------
    */
    public static function editOrderMember ( $user_info , $request , $ip = '' ){
        if(!isset($request['edit_type']) || !in_array($request['edit_type'], [1,2])){
            return ['code' => 500, 'msg' => '操作类型错误', 'data' => '操作类型错误'];
        }
        if(!isset($request['order_number']) || empty($request['order_number'])){
            return ['code' => 500, 'msg' => '单号信息错误', 'data' => '单号信息错误'];
        }
        if ($request['edit_type'] == 1) {
            if (isset($request['mem_id']) && !empty($request['mem_id'])) {
                $list_data = DB::table('member')
                    ->where('mem_id', $request['mem_id'])
                    ->select('mem_name', 'mem_id', 'mem_phone', 'mem_car_num', 'mem_car_series', 'mem_car_color', 'mem_source', 'mem_sex','mem_fid')
                    ->first();
                if ($list_data) {
                    if($list_data->mem_car_num=='') {
                        $list_data->mem_car_num = DB::table('member_car')
                            ->where('meca_mem_id', $request['mem_id'])
                            ->value('meca_car_num');
                    }
                    if($list_data->mem_fid>0) {
                        $list_data->mem_fphone = DB::table('member')
                            ->where('mem_id', $list_data->mem_fid)
                            ->value('mem_phone');
                    }else{
                        $list_data->mem_fphone = '';
                    }

                    return ['code' => 200, 'msg' => 'success', 'data' => $list_data];
                } else {
                    return ['code' => 500, 'msg' => '查无数据', 'data' => '查无数据'];
                }
            } else {
                return ['code' => 500, 'msg' => '请选择会员', 'data' => '请选择会员'];
            }
        }else {
            $order = DB::table('order')
                ->where('ord_order_number',$request['order_number'])
                ->select('ord_state','ord_id')
                ->first();
            $order = CommonService::dataToArray($order);
            if(!$order){
                return ['code' => 500, 'msg' => '单号不存在', 'data' => '单号不存在'];
            }
            if($order['ord_state']!=1){
                return ['code' => 500, 'msg' => '订单已结算', 'data' => '订单已结算'];
            }
            $work_order = DB::table('work_order')
                ->where('wor_order_id',$order['ord_id'])
                ->select('wor_state','wor_id')
                ->first();
            $work_order = CommonService::dataToArray($work_order);
            if($work_order && $work_order['wor_state']>5){
                return ['code' => 500, 'msg' => '工单已验车', 'data' => '工单已验车'];
            }
            // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
            $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
            DB::beginTransaction(); //开启回滚事物
            $mem_fid = 0;
            if ($request['mem_fphone']) {
                $mem_fid = DB::table('member')
                    ->where('mem_shop_id', $shop_id)
                    ->where('mem_phone', $request['mem_fphone'])
                    ->value('mem_id');
                if (!$mem_fid) {
                    return response()->json(['code' => 500, 'msg' => '未查询到该推荐人', 'data' => '']);
                }
            }
            $mem_add_data['mem_name'] = $request['mem_name'];
            $mem_add_data['mem_sex'] = $request['mem_sex'];
            $mem_add_data['mem_fid'] = $mem_fid;
            $mem_add_data['mem_phone'] = $request['mem_phone'];
            $mem_add_data['mem_birthday'] = $request['mem_birthday'] ?? '';
            $mem_add_data['mem_car_num'] = str_replace(' ', '', $request['mem_car_num']);
            $mem_add_data['mem_car_series'] = $request['mem_car_series'] ?? '';
            $mem_add_data['mem_car_color'] = $request['mem_car_color'] ?? '';
            $mem_add_data['mem_car_model'] = $request['mem_car_model'] ?? '';
//            $mem_add_data['mem_province'] = $request['mem_province'] ?? '';
//            $mem_add_data['mem_city'] = $request['mem_city'] ?? '';
//            $mem_add_data['mem_county'] = $request['mem_county'] ?? '';
//            $mem_add_data['mem_address'] = $request['mem_address'] ?? '';
            $mem_add_data['mem_bership'] = $request['mem_bership']??1;
            $mem_add_data['mem_source'] = $request['mem_source'] ?? '';
            $mem_add_data['mem_update_time'] = date("Y-m-d H:i:s");
            //订单用户信息
            $order_client['orcl_name'] = $mem_add_data['mem_name'];
            $order_client['orcl_phone'] = $mem_add_data['mem_phone'];
            $order_client['orcl_carowner_name'] = $mem_add_data['mem_name'];
            $order_client['orcl_carowner_phone'] = $mem_add_data['mem_phone'];
            $order_client['orcl_car_num'] = $mem_add_data['mem_car_num'];
            $order_client['orcl_car_vehicle_type'] = $mem_add_data['mem_car_series'];
            $order_client['orcl_car_brand_series'] = $mem_add_data['mem_car_series'];
            $order_client['orcl_update_time'] = date("Y-m-d H:i:s");
            //工单用户信息
            $work_client['wocl_name'] = $mem_add_data['mem_name'];
            $work_client['wocl_phone'] = $mem_add_data['mem_phone'];
            $work_client['wocl_carowner_name'] = $mem_add_data['mem_name'];
            $work_client['wocl_carowner_phone'] = $mem_add_data['mem_phone'];
            $work_client['wocl_car_num'] = $mem_add_data['mem_car_num'];
            $work_client['wocl_car_vehicle_type'] = $mem_add_data['mem_car_series'];
            $work_client['wocl_car_brand_series'] = $mem_add_data['mem_car_series'];
            $work_client['wocl_update_time'] = date("Y-m-d H:i:s");
            if ($request['add_type'] == 1) {
//                if($work_order && $work_order['wor_state']>5){
                $find_mem = DB::table('member')
                    ->where('mem_cid', $user_info->adm_cid)
                    ->where('mem_shop_id', $user_info->adm_shop_id)
                    ->where('mem_phone', $request['mem_phone'])
                    ->value('mem_id');
                if ($find_mem) {
                    $order_client['orcl_client_id'] = $find_mem;
                    $work_client['wocl_client_id'] = $find_mem;
                    if(isset($request['phone_type']) && $request['phone_type']==2){
                        $mem_res = DB::table('member')
                            ->where('mem_id', $find_mem)
                            ->update($mem_add_data);
                        $request['mem_id'] = $find_mem;
                    }else {
                        DB::rollback();
                        return ["code" => 10086, 'msg' => '当前手机号已存在,是否直接使用', 'data' => '当前手机号已存在,是否直接使用'];
                    }
                }else {
                    $mem_add_data['mem_cid'] = $user_info->adm_cid;
                    $mem_add_data['mem_shop_id'] = $user_info->adm_shop_id;
                    $mem_add_data['mem_superior_shop_id'] = $shop_id;
                    $mem_add_data['mem_create_name'] = $user_info->adm_name;
                    $mem_add_data['mem_create_id'] = $user_info->adm_id;
                    $mem_add_data['mem_salesman_id'] = $request['mem_salesman_id'] ?? $user_info->adm_id;;//业务员id
                    $mem_id = self::addMember($mem_add_data);
                    $order_client['orcl_client_id'] = $mem_id;
                    $work_client['wocl_client_id'] = $mem_id;
                    if ($mem_id) {
                        $mem_res = true;
                        $request['mem_id'] = $mem_res;
                    } else {
                        DB::rollback();
                        return ["code" => 500, 'msg' => '添加会员信息失败', 'data' => ''];
                    }
                }
            } else {
                if (!isset($request['mem_id']) || empty($request['mem_id'])) {
                    DB::rollback();
                    return ["code" => 500, 'msg' => '未选择对应会员', 'data' => ''];
                }else {
                    $find_mem = DB::table('member')
                        ->where('mem_cid', $user_info->adm_cid)
                        ->where('mem_shop_id', $user_info->adm_shop_id)
                        ->where('mem_phone', $request['mem_phone'])
                        ->value('mem_id');
                    if ($find_mem) {
                        $order_client['orcl_client_id'] = $find_mem;
                        $work_client['wocl_client_id'] = $find_mem;
                        if(isset($request['phone_type']) && $request['phone_type']==2){
                            $mem_res = DB::table('member')
                                ->where('mem_id', $find_mem)
                                ->update($mem_add_data);
                            $request['mem_id'] = $find_mem;
                        }else {
                            DB::rollback();
                            return ["code" => 10086, 'msg' => '当前手机号已存在,是否直接使用', 'data' => '当前手机号已存在,是否直接使用'];
                        }
                    }else {
                        $mem_res = DB::table('member')
                            ->where('mem_id', $request['mem_id'])
                            ->update($mem_add_data);
                    }
                }
            }

            $add_order_client = DB::table('order_client')->where('orcl_ord_id',$order['ord_id'])->update($order_client);
            $add_order = DB::table('order')->where('ord_id',$order['ord_id'])->update(['ord_client_id'=>$request['mem_id'],'ord_type'=>1,'ord_update_time'=>date("Y-m-d H:i:s")]);
            if($work_order) {
                $add_work_client = DB::table('work_client')->where('wocl_wor_id', $work_order['wor_id'])->update($work_client);
                $add_work = DB::table('work_order')->where('wor_id', $work_order['wor_id'])->update(['wor_update_time'=>date("Y-m-d H:i:s"),'wor_type'=>1]);
            }else{
                $add_work_client = 1;
                $add_work = 1;
            }
            if(!$add_order || !$add_work){
                DB::rollback();
                return ["code" => 500, 'msg' => '编辑用户信息失败'.$add_order.'-'.$add_work, 'data' => ''];
            }
            if(!$add_order_client || !$add_work_client){
                DB::rollback();
                return ["code" => 500, 'msg' => '编辑用户信息失败'.$add_order_client.'-'.$add_work_client, 'data' => ''];
            }
            if ($request['mem_car_num']) {
                // 判断车牌号是否存在  mem_car_num
                $meca_add_data['meca_cid'] = $user_info->adm_cid;
                $meca_add_data['meca_shop_id'] = $user_info->adm_shop_id;
                $meca_add_data['meca_superior_shop_id'] = $shop_id;
                $meca_add_data['meca_create_adm_id'] = $user_info->adm_id;
                $meca_add_data['meca_mem_id'] = $request['mem_id'];
                $meca_add_data['meca_car_num'] = $request['mem_car_num'];
                $meca_add_data['meca_car_brand_series'] = $request['mem_car_series'] ?? '';
                $meca_add_data['meca_update_time'] = date('Y-m-d H:i:s');
                $meca_id = DB::table('member_car')
                    ->where('meca_mem_id', $request['mem_id'])
                    ->where('meca_car_num', $request['mem_car_num'])
                    ->value('meca_id');
                if ($meca_id) {
                    $meca_res = DB::table('member_car')
                        ->where('meca_id', $meca_id)
                        ->update($meca_add_data);
                } else {
                    $meca_res = DB::table('member_car')->insert($meca_add_data);
                }
            }
            if ($mem_res && $meca_res) {
                DB::commit();
                if ($request['add_tyoe'] == 1) {
                    $ontent = '订单编辑会员信息-添加新会员';
                } else {
                    $ontent = '订单编辑会员信息-编辑原有会员';
                }
                OperationLog::addLog($user_info, $ip, '会员管理', '编辑会员信息', $ontent);
                return ["code" => 200, 'msg' => '操作成功', 'data' => ''];
            } else {
                DB::rollback();
                return ["code" => 500, 'msg' => '操作失败', 'data' => ''];
            }
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 设置客户来源
     * @param string type 数据类型  1 查询 2编辑
     * @param string mbs_type 数据类型1操作设置2数据设置
     * @param string mbs_data 数据
     * @param string mbs_state 数据状态
     * @param string mbs_stats 属性 sourceSet：来源设置
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2025/3/6 17:20
     * |---------------------------------------------------------------------------------
     */
    public static function setMemberData ( $input, $user_info, $ip ){
        $user_infos = CommonService::dataToArray($user_info);
        $type = $input['type'];
        switch ( $type ){
            case 1:
                if($input['mbs_type']==0){
                    $list = DB::table('member_set')
                        ->where("mbs_stats", $input['mbs_stats'])
                        ->where("mbs_shop_id", $user_infos['adm_shop_id'])
                        ->get();
                    $list = CommonService::dataToArray($list);
                    if ($list) {
                        $list = CommonService::jointArrayKey($list, 'mbs_type');
                        if($input['mbs_stats'] == 'sourceSet'){
                            $data['mbs_state'] = $list[1]['mbs_state']??2;
                            if(isset($list[2]['mbs_data'])){
                                $data['mbs_data'] = json_decode($list[2]['mbs_data'],true);
                            }else{
                                $data['mbs_data'] = [];
                            }
                        }else{
                            $data['mbs_state'] = 2;
                            $data['mbs_data'] = [];
                        }
                    }else{
                        $data['mbs_state'] = 2;
                        $data['mbs_data'] = [];
                    }
                }else {
                    $list = DB::table('member_set')
                        ->where("mbs_stats", $input['mbs_stats'])
                        ->where('mbs_type', $input['mbs_type'])
                        ->where("mbs_shop_id", $user_infos['adm_shop_id'])
                        ->first();
                    $list = CommonService::dataToArray($list);
                    if ($list) {
                        if ($input['mbs_type'] == 1) {
                            $data['mbs_stats'] = $list['mbs_stats'];
                        } elseif ($input['mbs_type'] == 2) {
                            $data = json_decode($list['mbs_data'], true);
                        }
                    } else {
                        if ($input['mbs_type'] == 1) {
                            $data['mbs_stats'] = 2;
                        } elseif ($input['mbs_type'] == 2) {
                            $data = [];
                        }
                    }
                    if (!isset($data)) {
                        $data = [];
                    }
                }
                return ['code' => 200, 'msg' => '操作成功', 'data' => $data];
            case 2:
                if($input['mbs_type'] == 1) {
                    $checkKey = CommonService::checkKey(['mbs_state'],$input);
                    if($checkKey['code']!=1){
                        return $checkKey;
                    }else {
                        $res = DB::table('member_set')
                            ->where("mbs_stats", $input['mbs_stats'])
                            ->where('mbs_type', $input['mbs_type'])
                            ->where("mbs_shop_id", $user_infos['adm_shop_id'])
                            ->value('mbs_id');
                        if ($res) {
                            $res = DB::table('member_set')
                                ->where("mbs_id", $res)
                                ->update(['mbs_state' => $input['mbs_state'], 'mbs_update_time' => date("Y-m-d H:i:s")]);
                        } else {
                            $res = DB::table('member_set')->insert(['mbs_stats' => $input['mbs_stats'], 'mbs_type' => $input['mbs_type'], 'mbs_shop_id' => $user_infos['adm_shop_id'], 'mbs_state' => $input['mbs_state'], 'mbs_update_time' => date("Y-m-d H:i:s")]);
                        }
                    }
                    $ontent = '操作设置:('.$input['mbs_state'].')';
                }elseif ($input['mbs_type'] == 2){
                    $ontent = '数据设置';
                    $checkKey = CommonService::checkKey(['mbs_data'],$input);
                    if($checkKey['code']!=1){
                        return $checkKey;
                    }else {
                        $res = DB::table('member_set')
                            ->where("mbs_stats", $input['mbs_stats'])
                            ->where('mbs_type', $input['mbs_type'])
                            ->where("mbs_shop_id", $user_infos['adm_shop_id'])
                            ->value('mbs_id');
                        if ($res) {
                            $res = DB::table('member_set')
                                ->where("mbs_id", $res)
                                ->update(['mbs_data' => json_encode($input['mbs_data'], JSON_UNESCAPED_UNICODE), 'mbs_update_time' => date("Y-m-d H:i:s")]);
                        } else {
                            $res = DB::table('member_set')->insert(['mbs_stats' => $input['mbs_stats'], 'mbs_type' => $input['mbs_type'], 'mbs_shop_id' => $user_infos['adm_shop_id'], 'mbs_data' => json_encode($input['mbs_data'], JSON_UNESCAPED_UNICODE), 'mbs_update_time' => date("Y-m-d H:i:s")]);
                        }
                    }
                }
                if($res){
                    $action = self::getSetType();
                    $ontent = $action[$input['mbs_stats']].';'.$ontent;
                    OperationLog::addLog($user_info, $ip, '会员管理', '设置会员属性', $ontent);
                    return ['code' => 200, 'msg' => '操作成功', 'data' => []];
                }else{
                    return ['code' => ErrorInc::MYSQL_FAILED, 'msg' => '操作失败', 'data' => []];
                }
            default:
                return ['code' => ErrorInc::INVALID_PARAM, 'msg' => '参数异常', 'data' => []];
        }
    }
    //获取设置属性类型
    public static function getSetType ( ){
        return ['sourceSet'=>'来源设置'];
    }
}
