<?php
namespace App\Services\Shop;

use App\Services\CommonService;
use Illuminate\Database\Eloquent\Model;
// use App\Models\Shop\Shop;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\Shop\ShopValidator;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Support\Facades\Request;
use App\Http\Models\Api\Common;
use App\Services\Software\QrCodeService;

class ShopService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;
    public function __construct()
    {
        // $this->modelMain = new Shop();
        $this->mainValidator = new ShopValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 检查是不是存在同名内容
     * @param $name 门店名称
     * @param int $id 排除这个id
     * @return mixed
     */
    public static function shopNameExists($user_info, $request, $id = 0)
    {
        if ($id == 0) {
            return DB::table('shop')
                ->where('shop_store_name', $request['shop_store_name'])
                ->where('shop_state', 1)
                ->exists();
        } else {
            return DB::table('shop')
                ->where('shop_store_name', $request['shop_store_name'])
                ->where('shop_state', 1)
                ->where('shop_id', '<>', $id)
                ->exists();
        }
    }

    /**
     * 检查是不是存在同手机号内容
     * @param shop_phone 联系人手机号
     * @return mixed
     */
    public static function verifyyPhone($request, $id = 0)
    {
        if ($id == 0) {
            return DB::table('admin')
                ->where('adm_phone', $request['shop_phone'])
                ->exists();
        } else {
            return DB::table('admin_shop_role')
                ->where('phone', $request['shop_phone'])
                ->where('shop_id', '<>', $id)
                ->exists();
        }
    }

    // 新增门店
    public static function addShop($user_info, $request)
    {
        // 判断手机号是否存在
        $adm_phone = DB::table('admin_shop_role')
            ->where('phone', $request['shop_phone'])
            ->where('adm_shop_leave', 1)
            ->value('adm_id');
        if (!empty($adm_phone)) {
            return ["code" => 500, 'msg' => '该手机号已是其他门店店长', 'data' => ''];
        }

        $data['shop_cid'] = 1; //门店名称
        $data['shop_superior_id'] = isset($request['shop_superior_id']) ? $request['shop_superior_id'] : 0; //總店id
        if (isset($request['shop_superior_id'])) {
            $data['shop_shve_id'] = 4;
            $data['shop_message_num'] = 300;
            $data['shop_free_space'] = 5;
            $data['shop_opening_end_time'] = DB::table('shop')->where('shop_id', $user_info->adm_shop_id)->value('shop_opening_end_time');
        }
        $data['shop_store_name'] = $request['shop_store_name']; //门店名称
        $find_shop = DB::table('shop')
            ->where('shop_store_name', $request['shop_store_name'])
            ->exists();
        if ($find_shop) {
            return ["code" => 500, 'msg' => '该分店名称已存在', 'data' => ''];
        }
        $data['shop_image'] = config('apisystem.server_name_https') .'/image/pcImg/shop_default_img.png'; //店铺图片
        $data['shop_name'] = $request['shop_name']; //联系人
        $data['shop_phone'] = $request['shop_phone']; //联系人电话
        $data['shop_province'] = $request['shop_province']; //省
        $data['shop_city'] = $request['shop_city']; //市
        $data['shop_county'] = $request['shop_county']; //县
        $data['shop_address'] = $request['shop_address']; //详细地址
        $data['shop_versions'] = 2; //默认运营中心
        $data['shop_opening_type'] = 2; //开通类型1免费试用2正式开通
        $data['shop_code'] = 'S' . substr(time(),5,5)  . rand(10000, 99999); //门店编码
        $data['shop_create_time'] = date('Y-m-d H:i:s'); //时间
        $shop_id = DB::table('shop')->insertGetid($data);
        self::addFestival($shop_id);

        $add_role_data['rol_cid'] = 1;
        $add_role_data['rol_shop_id'] = $shop_id;
        $add_role_data['rol_type'] = 1;//角色类型：1店主2员工3技师
        $add_role_data['rol_name'] = '店长';
        $add_role_data['rol_privilege'] = '2,587,589,590,591,592,593,594,595,663,630,631,632,633,634,635,636,637,638,639,666,640,641,642,643,644,645,646,647,71,72,73,74,75,76,344,472,577,578,579,581,79,80,81,82,83,84,85,86,87,156,159,160,194,196,237,398,399,400,403,404,459,460,465,470,409,410,411,498,499,53,54,55,56,57,58,59,60,61,62,63,64,66,67,68,107,108,109,110,111,564,565,566,567,355,654,655,672,29,3,4,5,7,8,198,484,557,23,24,25,26,27,28,30,31,32,33,34,181,665,35,36,38,39,40,41,512,42,43,44,45,46,213,610,611,612,613,614,615,616,617,618,619,620,621,622,623,624,625,626,627,628,629,69,70,673,674,675,676,677,678,679,680,681,682,683,684,685,686,687,688,689,690,691,692,693,588,668,694,695,696,697,698,699,700,701,702,703,704,705,706,707';
        if (isset($request['shop_superior_id'])) {//分店权限
            $find_pc_pri = DB::table('privileges')
                ->where('pri_shop_version', 'like', '%'.'4'.'%')
                ->where('pri_show', 1)
                ->select('pri_id')
                ->get()->toArray();

            $pc_pri = array_column($find_pc_pri, 'pri_id');

            $find_applet_pri = DB::table('privileges_technician_applet')
                ->where('pri_shop_version', 'like', '%'.'4'.'%')
                ->where('pri_show', 1)
                ->select('pri_id')
                ->get()->toArray();

            $applet_pri = array_column($find_applet_pri, 'pri_id');
            $data_role['pc'] = implode(',',$pc_pri);
            $data_role['applet'] = implode(',',$applet_pri);
            $new_data = json_encode($data_role, true);
            // $add_role_data['rol_privilege_multiple'] = '{"pc":"2,587,590,591,592,594,595,691,692,695,707,588,634,636,637,638,639,666,693,69,70,71,72,73,74,75,76,344,472,577,578,579,581,709,194,196,237,498,499,53,66,67,68,157,158,161,687,688,684,685,686,689,690,697,698,699,701,702,703,704,705,706,29,3,4,5,7,8,198,484,557,23,24,25,26,27,28,30,31,32,33,34,181,694,710,35,36,38,39,40,41,512,42,43,44,45,46,213,620,621,622,623,624","applet":"9,10,11,12,13,14,15,16,17,20,21,22"}';
            $add_role_data['rol_privilege_multiple'] = $new_data;
            $add_msg_config['msco_shop_id'] = $shop_id;
            $add_msg_config['msco_is_send'] = 1;
            $add_msg_config['msco_send_detail'] = 5;
            $add_msg_res = DB::table('msg_config')->insertGetid($add_msg_config);
        }
        $add_role_data['rol_create_time'] = date('Y-m-d H:i:s'); //时间
        $add_role_data['rol_category'] = 1;
        $role_id = DB::table('role')->insertGetid($add_role_data);
        if (!isset($request['shop_superior_id'])) {
            $add_appletrole_data['rol_cid'] = 1;
            $add_appletrole_data['rol_shop_id'] = $shop_id;
            $add_appletrole_data['rol_type'] = 3;//角色类型：1店主2员工3技师
            $add_appletrole_data['rol_name'] = '技师总管理';
            $add_appletrole_data['rol_privilege'] = '9,10,11,12,13,14,15,16,17,18,20,21,22';
            $add_appletrole_data['rol_create_time'] = date('Y-m-d H:i:s'); //时间
            $add_appletrole_data['rol_category'] = 3;//1、pc端角色2、app端角色3、微信小程序角色
            $applet_role_id = DB::table('role')->insertGetid($add_appletrole_data);
        } else {
            $applet_role_id = true;
        }

        // 新增账号
        $adm_res= DB::table('admin')
            ->where('adm_phone', $request['shop_phone'])
            ->value('adm_id');
        if(empty($adm_id)) {
            $password = md5($request['shop_password'].'faster123456');
            $admin_add_data['adm_superior_shop_id'] = isset($request['shop_superior_id']) ? $request['shop_superior_id'] : $shop_id;
            $admin_add_data['adm_shop_id'] = $shop_id;
            $admin_add_data['adm_cid'] = 1;
            $admin_add_data['adm_create_time'] = date('Y-m-d H:i:s'); //时间
            $admin_add_data['adm_leave'] = 1; //级别1店长2普通员工3技师4业务员5技师和业务员
            $admin_add_data['adm_phone'] = $request['shop_phone']; //手机号
            $admin_add_data['adm_account'] = 'os'.time().rand(100,999); //用户名（登录账号）
            $admin_add_data['adm_password'] = $password; //登录密码
            $admin_add_data['adm_name'] = $request['shop_name']; //姓名名称
            $admin_add_data['adm_role'] = $role_id; //角色id
            $admin_add_data['adm_role_applet'] = isset($applet_role_id) ? $applet_role_id : ''; //小程序角色id
            $adm_res =  DB::table('admin')->insertGetid($admin_add_data);
            $adms_data['adms_adm_id'] = $adm_res; //员工id
            $adms_data['adms_shop_id'] = $shop_id; //门店id
            $adms_data['adms_province'] = $request['shop_province']; //省
            $adms_data['adms_city'] = $request['shop_city']; //城市
            $adms_data['adms_county'] = $request['shop_county']; //县
            $adms_data['adms_address'] = $request['shop_address']; //详细地址
            $adms_data['adms_update_time'] = date('Y-m-d H:i:s'); //更新时间
            // 没有该员工的设置新增
            $adms_res = DB::table('admin_set')->insert($adms_data);
        }
        // 新增账号门店权限关系表
        $insertAdminShopRoleData = [
            'adm_id' => $adm_res,
            'shop_cid' => 1,
            'superior_shop_id' => isset($request['shop_superior_id']) ? $request['shop_superior_id'] : $shop_id,
            'shop_id' => $shop_id,
            'role_id' => $role_id,
            'adm_shop_leave' => 1,
            'phone' => $request['shop_phone'],
            'create_time' => date("Y-m-d H:i:s", time()),
            'update_time' => date("Y-m-d H:i:s", time()),
        ];
        $adminShopRoleId =  DB::table('admin_shop_role')->insertGetid($insertAdminShopRoleData);
        // 添加默认仓库分类
        $warehouse_class = config('apisystem.warehouse_class');
        foreach ($warehouse_class as $key => $value) {
            $warehouse_class[$key]['wacl_superior_shop_id'] = isset($request['shop_superior_id']) ? $request['shop_superior_id'] : $shop_id;
            $warehouse_class[$key]['wacl_shop_id'] = $shop_id;
            $warehouse_class[$key]['wacl_cid'] = 1;
        }
        $class_res = DB::table('warehouse_class')->insert($warehouse_class);
        $shco_shop_end_time = time();
        $shco_space = 0;
        $shco_message = 0;
        $shco_account = 0;
        // $shop_config = $request['shop_config'];
        // foreach ($shop_config as $key => $value) {
        //     if (!isset($value['pro_price'])) {
        //         return ['code'=>500, 'msg'=>'请上传价格', 'data'=>''];
        //     }
        //     $add_order['pror_number'] = 'PO'.time().rand(10000,99999);
        //     $add_order['pror_shop_id'] = $shop_id;
        //     $add_order['pror_payment_way'] = 2;
        //     $add_order['pror_payment_time'] = date('Y-m-d H:i:s');
        //     $add_order['pror_create_time'] = date('Y-m-d H:i:s');
        //     $add_order['pror_create_adm_id'] = 0;
        //     $add_order['pror_create_adm_name'] = $request['pror_create_adm_name'];
        //     $add_order['pror_total_price'] = $value['pro_price']*$value['pro_sum_number']*100;//总金额
        //     $add_order['pror_source'] = 1;//1供应链2美装
        //     $add_order['pror_pay_state'] = 1;//支付状态1是2否
        //     $add_order_res = DB::table('pro_order')->insertGetId($add_order);


        //     $add_order_goods['prog_shop_id'] = $shop_id;
        //     $add_order_goods['prog_pror_id'] = $add_order_res;
        //     $add_order_goods['prog_pro_id'] = $value['pro_id'];
        //     $add_order_goods['prog_pro_name'] = $value['pro_product_name'];
        //     $add_order_goods['prog_product_classification'] = $value['pro_product_classification'];
        //     $add_order_goods['prog_pro_quantity'] = $value['pro_quantity'];
        //     $add_order_goods['prog_pro_additional_condition'] = json_encode($value['pro_additional_condition'], true);
        //     $add_order['prog_pro_sell_number'] = $value['pro_sum_number'];
        //     $add_order_goods['prog_pro_price'] = $value['pro_price'];
        //     $add_order_goods['prog_pro_create_time'] = date('Y-m-d H:i:s');
        //     $add_order_goods['prog_pro_update_time'] = date('Y-m-d H:i:s');
        //     $add_prog_res = DB::table('pro_order_goods')->insertGetId($add_order_goods);
            
        //     if ($value['pro_product_classification'] == 1) {//产品分类：1有效期2账号3空间4短信
        //         if ($value['pro_type'] == 1) {//类型:1 天 2 月 3 年 4 个 5 G 6 M 7 条
        //             $shco_shop_end_time = strtotime('+'.$value['pro_quantity'].'days', $shco_shop_end_time);
        //         }
        //         if ($value['pro_type'] == 2) {
        //             $shco_shop_end_time = strtotime('+'.$value['pro_quantity'].'months', $shco_shop_end_time);
        //         }
        //         if ($value['pro_type'] == 3) {
        //             $shco_shop_end_time = strtotime('+'.$value['pro_quantity'].'years', $shco_shop_end_time);
        //         }
        //     }
        //     if ($value['pro_product_classification'] == 2) {
        //         $shco_account += $value['pro_quantity'];
        //     }
        //     if ($value['pro_product_classification'] == 3) {
        //         if ($value['pro_type'] == 5) {
        //             $value['pro_quantity'] = $value['pro_quantity'] * 1024;
        //         }
        //         $shco_space += $value['pro_quantity'];
        //     }
        //     if ($value['pro_product_classification'] == 4) {
        //         $shco_message += $value['pro_quantity'];
        //     }
        //     if ($value['pro_additional_condition']) {
        //         foreach ($value['pro_additional_condition'] as $key1 => $value1) {
        //             if ($value1['adco_category'] == '空间') {
        //                 if ($value1['adco_type'] == 'G') {
        //                     $value1['adco_quantity'] = $value1['adco_quantity'] * 1024;
        //                 }
        //                 $shco_space += $value1['adco_quantity'];
        //             }
        //             if ($value1['adco_category'] == '有效期') {
        //                 if ($value1['adco_type'] == '天') {//类型:1 天 2 月 3 年 4 个 5 G 6 M 7 条
        //                     $shco_shop_end_time = strtotime('+'.$value1['adco_quantity'].'days', $shco_shop_end_time);
        //                 }
        //                 if ($value1['adco_type'] == '月') {
        //                     $shco_shop_end_time = strtotime('+'.$value1['adco_quantity'].'months', $shco_shop_end_time);
        //                 }
        //                 if ($value1['adco_type'] == '年') {
        //                     $shco_shop_end_time = strtotime('+'.$value1['adco_quantity'].'years', $shco_shop_end_time);
        //                 }
        //             }
        //             if ($value1['adco_category'] == '账号') {
        //                 $shco_account += $value1['adco_quantity'];
        //             }
        //             if ($value1['adco_category'] == '短信') {
        //                 $shco_message += $value1['adco_quantity'];
        //             }
        //         }
        //     }
        // }
        // $shco_shop_end_time = date('Y-m-d H:i:s', $shco_shop_end_time);
        // $add_config['shco_shop_id'] = $shop_id;
        // $add_config['shco_shop_create_time'] = date('Y-m-d H:i:s');
        // $add_config['shco_shop_end_time'] = $shco_shop_end_time;
        // $add_config['shco_space'] = $shco_space;//门店空间
        // $add_config['shco_used_space'] = 0;//已使用门店空间
        // $add_config['shco_account'] = $shco_account;//账号数量
        // $add_config['shco_message'] = $shco_message;//短信数量
        // $add_config['shco_used_message'] = 0;//已使用短信数量
        // $add_config_res = DB::table('shop_config')->insertGetId($add_config);

        $update_data['shop_opening_start_time'] = date('Y-m-d H:i:s');
        $update_data['shop_opening_end_time'] = $shco_shop_end_time;
        if (isset($request['shop_superior_id'])) {
            $shop_data = DB::table('shop')
                ->where('shop_id', $request['shop_superior_id'])
                ->first();
            $update_data['shop_opening_end_time'] = $shop_data->shop_opening_end_time;
        }
        $update_data['shop_adm_id'] = $adm_res;
        $update_shop_res = DB::table('shop')
            ->where('shop_id', $shop_id)
            ->update($update_data);
        //新增一个异常数据
        $vacm_add_data = [
            'vacm_cid'=>1,
            'vacm_shop_id'=>$shop_id,
            'vacm_superior_shop_id'=>$shop_id,
        ];
        $vacm_add_data['vacm_type'] = 1;
        // 新增异常数据

        $vacm_add_data['vacm_unusual_name'] = '仪表异常 （有故障码）';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $vacm_add_data['vacm_unusual_name'] = '车内照明灯异常';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $vacm_add_data['vacm_unusual_name'] = '车内缺点烟器';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $vacm_add_data['vacm_unusual_name'] = '电动天窗异常';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $vacm_add_data['vacm_unusual_name'] = '电动座椅异常';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);

        $vacm_add_data['vacm_type'] = 2;
        $vacm_add_data['vacm_unusual_name'] = '车头、侧身等灯具类破损或异常';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $vacm_add_data['vacm_unusual_name'] = '车标、格栅、装饰条破损或损坏';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $vacm_add_data['vacm_unusual_name'] = '胶皮密封条破损或异常';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $vacm_add_data['vacm_unusual_name'] = '装饰件破损或异常';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $date = date("Y-m-d H:i:s");
        // 新增质检数据
        $reward_punishment = [
            [
                'qurp_cid'=>1,
                'qurp_superior_shop_id'=>$shop_id,
                'qurp_shop_id'=>$shop_id,
                'qurp_name'=>'刀痕',
                'qurp_standard'=>-10,
                'qurp_standard_type'=>1,
                'qurp_type'=>1,
                'qurp_update_time'=>$date
            ],
            [
                'qurp_cid'=>1,
                'qurp_superior_shop_id'=>$shop_id,
                'qurp_shop_id'=>$shop_id,
                'qurp_name'=>'气泡',
                'qurp_standard'=>-10,
                'qurp_standard_type'=>1,
                'qurp_type'=>1,
                'qurp_update_time'=>$date
            ],
            [
                'qurp_cid'=>1,
                'qurp_superior_shop_id'=>$shop_id,
                'qurp_shop_id'=>$shop_id,
                'qurp_name'=>'漏漆',
                'qurp_standard'=>-10,
                'qurp_standard_type'=>1,
                'qurp_type'=>1,
                'qurp_update_time'=>$date
            ]
        ];
        $qurp_id = DB::table('wash_quality_reward_punishment')->insert($reward_punishment);
        if ($shop_id && $role_id && $applet_role_id && $adm_res && $class_res /*&& $add_config_res && $add_order_res */&& $adminShopRoleId) {
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>$shop_id];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
        }
    }

    // 编辑
    public static function editShop($request)
    {
        $data['shop_store_name'] = $request['shop_store_name']; //门店名称
        $data['shop_province'] = isset($request['shop_province']) ? $request['shop_province']:''; //省
        $data['shop_city'] = isset($request['shop_city']) ? $request['shop_city'] : ''; //市
        $data['shop_county'] = isset($request['shop_county']) ? $request['shop_county'] : ''; //县
        $data['shop_address'] = $request['shop_address']; //详细地址
        $data['shop_update_time'] = date('Y-m-d H:i:s'); //时间
        $shop_res = DB::table('shop')->where('shop_id', $request['shop_id'])->update($data);

        if ($shop_res) {
            return ['code'=>200, 'msg'=>'编辑成功', 'data'=>[]];
        } else {
            return ['code'=>500, 'msg'=>'编辑失败', 'data'=>[]];
        }
    }

    /**
     * 编辑分店
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-18
     * @param  [type]           $request [description]
     * @return [type]                    [description]
     */
    public static function editBindShop($user_info,$request)
    {
        $data['bish_shop_store_name'] = $request['bish_shop_store_name']; //门店名称
        $data['bish_shop_type'] = $request['bish_shop_type']; //类型
        $data['bish_shop_province'] = $request['shop_province']; //省
        $data['bish_shop_city'] = $request['shop_city']; //市
        $data['bish_shop_country'] = $request['shop_county']; //县
        $data['bish_adress'] = $request['bish_adress']; //地址
        $data['bish_update_id'] = $user_info->adm_id; //更新人
        $data['bish_update_time'] = date('Y-m-d H:i:s'); //时间
        $shop_res = DB::table('bind_shop')->where('bish_id', $request['bish_id'])->update($data);
        $find_shop_id = DB::table('bind_shop')->where('bish_id', $request['bish_id'])->value('bish_lshop_id');
        $find_adm_id = DB::table('admin_shop_role as asr')
            ->leftJoin('shop as s', 's.shop_id', '=', 'asr.shop_id')
            ->where('asr.shop_id', $find_shop_id)
            ->where('adm_shop_leave', 1)
            ->value('adm_id');
        $update_data['adms_province'] = $request['shop_province'];
        $update_data['adms_city'] = $request['shop_city'];
        $update_data['adms_county'] = $request['shop_county'];
        $update_data['adms_address'] = $request['bish_adress'];
        $update_res = DB::table('admin_set')
            ->where('adms_shop_id', $find_shop_id)
            ->where('adms_adm_id', $find_adm_id)
            ->update($update_data);
        if ($shop_res) {
            return ['code'=>200, 'msg'=>'编辑成功', 'data'=>[]];
        } else {
            return ['code'=>500, 'msg'=>'编辑失败', 'data'=>[]];
        }
    }

    /**
     * 绑定门店分店
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-06
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function bindShop($user_info,$request) {
        $find_shop = DB::table('shop')
            ->where('shop_code', $request['shop_code'])
            ->first();
        if (empty($find_shop)) {
            return ['code'=>500, 'msg'=>'此门店不存在', 'data'=>''];
        }
        if ($find_shop->shop_shve_id == 3) {
            return ['code'=>500, 'msg'=>'此门店版本不支持绑定', 'data'=>''];
        }
        $bind_data = DB::table('bind_shop')
            ->where('bish_lshop_id', $find_shop->shop_id)
            ->first();
        if ($bind_data) {
            return ['code'=>500, 'msg'=>'此门店已绑定', 'data'=>''];
        }

        $add_data['bish_fshop_id'] = $user_info->adm_shop_id;
        $add_data['bish_lshop_id'] = $find_shop->shop_id;
        $add_data['bish_shop_store_name'] = $find_shop->shop_store_name;
        $add_data['bish_shop_code'] = $find_shop->shop_code;
        $add_data['bish_adress'] = $find_shop->shop_address;
        $add_data['bish_shop_province'] = $find_shop->shop_province;
        $add_data['bish_shop_city'] = $find_shop->shop_city;
        $add_data['bish_shop_country'] = $find_shop->shop_county;
        $add_data['bish_shop_adm_name'] = $find_shop->shop_name;
        $add_data['bish_shop_adm_phone'] = $find_shop->shop_phone;
        $add_data['bish_create_time'] = date('Y-m-d H:i:s');
        $add_data['bish_create_id'] = $user_info->adm_id;
        $add_data['bish_state'] = 1;
        $add_data['bish_shop_type'] = $request['bish_shop_type'];//1自营2加盟
        $add_res = DB::table('bind_shop')->insertGetId($add_data);
        $update_data['shop_superior_id'] = $user_info->adm_shop_id;
        $update_data['shop_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('shop')
            ->where('shop_id', $find_shop->shop_id)
            ->update($update_data);
        if ($add_res) {
            return ['code'=>200, 'msg'=>'绑定成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'绑定失败', 'data'=>''];
        }
    }

    /**
     * 分店列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-06
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function bindIndex($user_info,$request, $show_count = 10) {
        $list_data = DB::table('bind_shop')
            ->leftJoin('shop', 'shop_id', '=', 'bish_lshop_id')
            ->where('bish_fshop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($request) {
                if (!empty($request['bish_shop_store_name'])) {
                    $query->where('bish_shop_store_name', 'like', '%'. $request['bish_shop_store_name'].'%');
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['bish_shop_code'])) {
                    $query->where('bish_shop_code', 'like', '%'. $request['bish_shop_code'].'%');
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['bish_shop_type'])) {
                    $query->where('bish_shop_type', $request['bish_shop_type']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['bish_adress'])) {
                    $query->where('bish_adress', 'like', '%'. $request['bish_adress'].'%');
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['bish_shop_adm_name'])) {
                    $query->where('bish_shop_adm_name', 'like', '%'. $request['bish_shop_adm_name'].'%');
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['bish_shop_adm_phone'])) {
                    $query->where('bish_shop_adm_phone', 'like', '%'. $request['bish_shop_adm_phone'].'%');
                }
            })
            ->select('bind_shop.*', 'shop_message_num', 'shop_free_space', 'shop_toll_space', 'shop_province', 'shop_city', 'shop_county', 'shop_use_space')
            ->orderBy('bish_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            foreach ($list_items as $key =>$value) {
                $list_items[$key]->shop_space = $value->shop_free_space + $value->shop_toll_space;
                $list_items[$key]->shop_store_name = DB::table('shop')
                    ->where('shop_id', $value->bish_fshop_id)
                    ->value('shop_store_name');
            }
            $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['pages']['total'] = $list_data->total();               //总数据个数
            $data['pages']['current_number'] = $show_count;        //一页显示多少个
            $data['list'] = $list_items;                        //返回数据
        } else {
            $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['pages']['total'] = $list_data->total();               //总数据个数
            $data['pages']['current_number'] = $show_count;        //一页显示多少个
            $data['list'] = [];
        }
        return $data;
    }


    /**
     * 停用
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-06
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function bindState($user_info,$request) {
        $find_shop = DB::table('bind_shop')
            ->where('bish_id', $request['bish_id'])
            ->first();
        if (empty($find_shop)) {
            return ['code'=>500, 'msg'=>'此门店不存在', 'data'=>''];
        }
        if ($request['bish_state'] == 1) {
            $find_shop_data = DB::table('shop')
                ->where('shop_id', $user_info->adm_shop_id)
                ->first();
            $shop_num = $find_shop_data->shop_free_shop + $find_shop_data->shop_toll_shop;
            $find_bind_shop = DB::table('bind_shop')
                ->where('bish_fshop_id', $user_info->adm_shop_id)
                ->where('bish_state', 1)
                ->count();
            if ($shop_num <= $find_bind_shop) {
                return ["code" => 500, 'msg' => '分店数量已超出，请先前往购买或注销其他分店', 'data' => ''];
            }
        }
        
        $update_data['bish_state'] = $request['bish_state'];//是否启用1是2否
        $update_data['bish_update_time'] = date('Y-m-d H:i:s');//1自营2加盟
        $update_data['bish_update_id'] = $user_info->adm_id;
        $update_res = DB::table('bind_shop')->where('bish_id', $request['bish_id'])->update($update_data);
        $shop_res = DB::table('shop')
            ->where('shop_id', $find_shop->bish_lshop_id)
            ->update(['shop_state'=>$request['bish_state']]);
        if ($update_res) {
            return ['code'=>200, 'msg'=>'操作成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'操作失败', 'data'=>''];
        }
    }

    // 新增分类
    public static function addClassification($user_info, $request)
    {
        $data['gocl_cid'] = $user_info->adm_cid;//公司id
        $data['gocl_shop_id'] = $user_info->adm_shop_id;//门店id
        $data['gocl_name'] = $request['gocl_name'];//分类名称
        $data['gocl_sort'] = $request['gocl_sort'];//排序
        $data['gocl_remark'] = !empty($request['gocl_remark']) ? $request['gocl_remark'] : '';//备注
        $data['gocl_state'] = $request['gocl_state'];//1开启2关闭
        $data['gocl_create_time'] = date('Y-m-d H:i:s');
        $data['gocl_update_time'] = date('Y-m-d H:i:s');
        return DB::table('goods_classification')->insert($data);
    }

    // 编辑分类
    public static function editClassification($user_info, $request)
    {
        $data['gocl_cid'] = $user_info->adm_cid;//公司id
        $data['gocl_shop_id'] = $user_info->adm_shop_id;//门店id
        $data['gocl_name'] = $request['gocl_name'];//分类名称
        $data['gocl_sort'] = $request['gocl_sort'];//排序
        $data['gocl_remark'] = !empty($request['gocl_remark']) ? $request['gocl_remark'] : '';//备注
        $data['gocl_state'] = $request['gocl_state'];//1开启2关闭
        $data['gocl_create_time'] = date('Y-m-d H:i:s');
        $data['gocl_update_time'] = date('Y-m-d H:i:s');
        return DB::table('goods_classification')->where('gocl_id', $request['gocl_id'])->update($data);
    }

    // 购买产品
    public static function addOrder($user_info, $request, $type = 1)
    {
        $add_order['pror_number'] = 'PO'.time().rand(10000,99999);
        $add_order['pror_shop_id'] = $user_info->adm_shop_id;
        $add_order['pror_total_price'] = $request['pro_price']*$request['prog_pro_sell_number']*100;
        $add_order['pror_payment_way'] = 2;
        $add_order['pror_source'] = 2;//1供应链2洗美
        $add_order['pror_payment_time'] = date('Y-m-d H:i:s');
        $add_order['pror_create_time'] = date('Y-m-d H:i:s');
        $add_order['pror_create_adm_id'] = $user_info->adm_id;
        $add_order['pror_create_adm_name'] = $user_info->adm_name;
        $add_order['pror_adm_phone'] = $user_info->adm_phone;
        $pror_id = DB::table('pro_order')->insertGetId($add_order);

        $prog_data['prog_shop_id'] = $user_info->adm_shop_id;
        $prog_data['prog_pror_id'] = $pror_id;
        $prog_data['prog_pro_id'] = $request['pro_id'];
        $prog_data['prog_pro_additional_condition'] = $request['pro_additional_condition'];
        $prog_data['prog_product_classification'] = $request['pro_product_classification'];
        $prog_data['prog_pro_name'] = $request['pro_product_name'];
        $prog_data['prog_pro_quantity'] = $request['pro_quantity'];
        $prog_data['prog_pro_sell_number'] = $request['prog_pro_sell_number'];
        $prog_data['prog_pro_price'] = $request['pro_price'];
        $prog_data['prog_pro_create_time'] = date('Y-m-d H:i:s');
        $prog_id = DB::table('pro_order_goods')->insertGetId($prog_data);
        
        if ($pror_id && $prog_id) {
            $return_data['pror_id'] = $pror_id; //订单id
            $return_data['pror_number'] = $add_order['pror_number']; //订单单号
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
        }
    }

    // 编辑
    public static function edit($user_info,$request)
    {
        $del_cogo_res = DB::table('correlation_goods')
            ->where('cogo_pait_id', $request['pait_id'])
            ->delete();
        $data['pait_name'] = $request['pait_name']; //商品名称
        if (empty($request['goods_data'])) {
            return ['code'=>500, 'msg'=>'请选择商品', 'data'=>'新增失败'];
        }
        $goods_data = json_decode($request['goods_data'], true);
        $goods = '';
        foreach ($goods_data as $key => $value) {
            $value['goo_unit_conversion'] = Db::table('goods')
                ->where('goo_id', $value['goo_id'])
                ->value('goo_unit_conversion');
            if (empty($goods)) {
                if ($value['goo_unta_id'] == 1) {
                    $goods = $value['goo_name'].'*'.$value['goo_quantity'].$value['goo_unit'].'('.$value['goo_quantity']*$value['goo_unit_conversion'].'米)';
                } else {
                    $goods = $value['goo_name'].'*'.$value['goo_quantity'].$value['goo_unit'];
                }
            } else {
                if ($value['goo_unta_id'] == 1) {
                    $goods = $goods.'、'.$value['goo_name'].'*'.$value['goo_quantity'].$value['goo_unit'].'('.$value['goo_quantity']*$value['goo_unit_conversion'].'米)';
                } else {
                    $goods = $goods.'、'.$value['goo_name'].'*'.$value['goo_quantity'].$value['goo_unit'];
                }
            }
        }
        $data['pait_type'] = 3;//商品类型1包含生成工单2只包含不生成工单服务3只包含商品
        foreach ($goods_data as $key1 => $value1) {
            if ($value1['cogo_goo_type'] == 2) {
                $data['pait_type'] = 2;
                if ($value1['sepr_work_type'] == 1) {
                    $data['pait_type'] = 1;
                    break;
                }
            }
        }
        $data['pait_composition'] = $goods; //组成
        $data['pait_classify_id'] = $request['pait_classify_id']; //分类id
        $data['pait_sort'] = $request['pait_sort']; //排序
        $data['pait_saleable_quantity'] = $request['pait_saleable_quantity']; //可售数量
        $data['pait_ware_id'] = $request['pait_ware_id']; //仓库id
        $data['pait_pic'] = $request['pait_pic']; //封面
        $data['pait_detail'] = $request['pait_detail']; //详情
        if ($request['pait_sell_price'] <= 0) {
            return ['code'=>500, 'msg'=>'零售价需要大于0', 'data'=>''];
        }
        if ($request['pait_shop_price'] < $request['pait_sell_price']) {
            return ['code'=>500, 'msg'=>'门店价不能小于销售价', 'data'=>'门店价不能小于销售价'];
        }
        $data['pait_shop_price'] = $request['pait_shop_price']*100; //门店价格
        $data['pait_sell_price'] = $request['pait_sell_price']*100; //零售价
        $data['pait_create_adm_id'] = $user_info->adm_id;
        $data['pait_create_time'] = date('Y-m-d H:i:s');
        $data['pait_update_adm_id'] = $user_info->adm_id;
        $data['pait_update_time'] = date('Y-m-d H:i:s');
        $pait_id = DB::table('package_items')->where('pait_id', $request['pait_id'])->update($data);
        foreach ($goods_data as $key => $value) {
            $add_data[$key]['cogo_pait_id'] = $request['pait_id'];
            $add_data[$key]['cogo_goo_id'] = $value['goo_id'];
            $add_data[$key]['cogo_goo_quantity'] = $value['goo_quantity'];
            $add_data[$key]['cogo_goo_unta_id'] = $value['goo_unta_id'];
            $add_data[$key]['cogo_goo_unit'] = $value['goo_unit'];
            $add_data[$key]['cogo_goo_type'] = $value['cogo_goo_type'];
            $add_data[$key]['cogo_goo_price'] = $value['goo_price']*100;
            $add_data[$key]['cogo_wago_id'] = $value['wago_id'];
            $add_data[$key]['cogo_create_time'] = date('Y-m-d H:i:s');
        }
        $cogo_res = DB::table('correlation_goods')->insert($add_data);
        if ($cogo_res && $pait_id) {
            return ['code'=>200, 'msg'=>'编辑成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'编辑失败', 'data'=>'编辑失败'];
        }
    }

    // 更改分类状态
    public static function editState($ids, $state)
    {
        $data['gocl_state'] = $state;
        $data['gocl_update_time'] = date('Y-m-d H:i:s');
        return DB::table('goods_classification')->whereIn('gocl_id', $ids)
            ->update($data);
    }

    // 更改商品上架状态
    public static function goodseditState($ids, $state)
    {
        $data['pait_state'] = $state;
        $data['pait_update_time'] = date('Y-m-d H:i:s');
        return DB::table('package_items')->whereIn('pait_id', $ids)
            ->update($data);
    }

    // 更改状态
    public static function claDelete($id)
    {
        $data['gocl_is_del'] = 1;
        $data['gocl_update_time'] = date('Y-m-d H:i:s');
        return DB::table('goods_classification')->where('gocl_id', $id)
            ->update($data);
    }

     // 补货
    public static function replenishment($user_info, $request)
    {
        $find_data = DB::table('package_items')
            ->where('pait_id', $request['pait_id'])
            ->value('pait_saleable_quantity');
        $data['pait_saleable_quantity'] = $find_data + $request['number'];
        $data['pait_update_time'] = date('Y-m-d H:i:s');
        $data['pait_update_adm_id'] = $user_info->adm_id;
        $res = DB::table('package_items')
            ->where('pait_id', $request['pait_id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'编辑成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'编辑失败', 'data'=>''];
        }
    }

    // 会员卡使用明细
    public static function detailIndex($user_info, $search_data, $show_count = 10, $field_columns = [])
    {
        // 判断是否传入查询字段
        if (empty($field_columns)) {
            // 查询字段
            $field_columns = ['vcre_id', 'vcre_myvi_id', 'vcre_user_id', 'vcre_ord_num', 'vcre_ord_id', 'vcre_create_time', 'vcre_car_adm_name', 'vcre_car_adm_phone', 'vcre_myvi_num', 'myvi_name', 'vcre_num_change', 'vcre_log', 'orcl_car_num', 'myvi_surplus_times'];
        }
        // 会员卡明细表
        $list_data = DB::table('vip_card_record as v')
            ->leftJoin('myvip as m', 'm.myvi_id', '=', 'v.vcre_myvi_id')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'v.vcre_ord_id')
            ->where('vcre_user_id', $search_data['mem_id'])
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['myvi_id'])) {
                    $query->where('myvi_id', $search_data['myvi_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['vcre_myvi_num'])) {
                    $query->where('vcre_myvi_num', 'like', '%' . $search_data['vcre_myvi_num'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('vcre_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('vcre_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('vcre_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select($field_columns)
            ->orderBy('vcre_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    // 操作记录
    public static function paitLogIndex($user_info, $search_data, $show_count = 10)
    {
        // 商品操作记录
        $list_data = DB::table('pait_log as p')
            ->leftJoin('admin as a', 'a.adm_id', '=', 'p.palo_create_id')
            ->where('palo_cid', $user_info->adm_cid)
            ->where('palo_shop_id', $user_info->adm_shop_id)
            ->where('palo_pait_id', $search_data['pait_id'])
            ->select('palo_content', 'adm_name', 'adm_phone', 'palo_create_time', 'palo_remark')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['pages']['total'] = $list_data->total();               //总数据个数
            $data['pages']['current_number'] = $show_count;        //一页显示多少个
            $data['list'] = $list_items;                        //返回数据
            return $data;
        } else {
            return [];
        }
    }

    // 扫码后新增门店
    public static function createShop($user_info, $request)
    {
        $data['shop_cid'] = 1; //公司
        $find_shop = DB::table('shop')
            ->where('shop_store_name', $request['shop_store_name'])
            ->first();
        $find_shop_latitude = CommonService::jingwei($request['shop_province'],$request['shop_city'].$request['shop_county'].$request['shop_address']);
        if (!empty($find_shop_latitude)) {
            $latitude_data = explode(',',$find_shop_latitude);
            $data['shop_longitude'] = $latitude_data[0]; //经度
            $data['shop_latitude'] = $latitude_data[1]; //纬度
        }
        if ($find_shop) {
            return ['code'=>500, 'msg'=>'店铺名称已存在，请重新填写', 'data'=>''];
        }
        $data['shop_store_name'] = $request['shop_store_name']; //门店名称
        $find_admin = DB::table('admin as a')
            ->leftJoin('admin_shop_role as as', 'as.adm_id', '=', 'a.adm_id')
            ->where('a.adm_id', $user_info->adm_id)
            ->where('adm_shop_leave', 1)
            ->select('adm_name', 'adm_phone', 'adm_shop_id', 'as.adm_id')
            ->first();
        if ($find_admin) {//拥有店长权限的账号
            return ['code'=>500, 'msg'=>'已拥有店铺，请前往登录', 'data'=>''];
        }
        $find_adm = DB::table('admin as a')
            ->leftJoin('admin_shop_role as as', 'as.adm_id', '=', 'a.adm_id')
            ->where('a.adm_id', $user_info->adm_id)
            ->select('adm_name', 'adm_phone', 'adm_shop_id', 'as.adm_id')
            ->first();
        //处理服务范围
        $service_scope = '';
        if(!empty($request['service_scope'])){
            $service_arr = json_decode($request['service_scope']);
            $scopr_name = array_column($service_arr,'sesc_name');
            $service_scope = implode('、', $scopr_name);
        }

        $data['shop_versions'] = 2; //默认运营中心
        $data['shop_name'] = $find_adm->adm_name; //联系人
        $data['shop_phone'] = $find_adm->adm_phone; //联系人电话
        $data['shop_code'] = 'S' . substr(time(),5,5)  . rand(10000, 99999); //开通类型1免费试用2正式开通
        $data['shop_province'] = $request['shop_province']; //省
        $data['shop_city'] = $request['shop_city']; //市
        $data['shop_county'] = $request['shop_county']; //县
        $data['shop_address'] = $request['shop_address']; //详细地址
        $data['shop_image'] = config('apisystem.server_name_https') .'/image/pcImg/shop_default_img.png'; //店铺图片
        // $data['shop_on_trial_start_time'] = date('Y-m-d H:i:s'); //试用开始时间
        // $data['shop_on_trial_end_time'] = date('Y-m-d H:i:s',time()+24*7*3600); //试用结束时间
        $data['shop_opening_start_time'] = date('Y-m-d H:i:s'); //试用开始时间
        $data['shop_opening_end_time'] = date('Y-m-d H:i:s',strtotime("+1 year")); //试用结束时间
        $data['shop_opening_type'] = 2; //开通类型1免费试用2正式开通
        $data['shop_create_time'] = date('Y-m-d H:i:s'); //时间
        $data['shop_service_scope'] = $service_scope ; //服务范围
        $data['shop_message_num'] = 20; //赠送短信
        $data['shop_free_space'] = 5; //赠送空间
        $data['shop_type'] = 1; //门店类型总店
        $data['shop_free_shop'] = 2; //赠送分店
        
        $data['shop_source_identify'] = 6 ; //门店来源标识：6免费试用
        $data['shop_opening_time'] = $request['shop_opening_time']; //营业时间
        $shop_id = DB::table('shop')->insertGetid($data);
        self::addFestival($shop_id);
        $add_msg_config['msco_shop_id'] = $shop_id;
        $add_msg_config['msco_is_send'] = 1;
        $add_msg_config['msco_send_detail'] = 5;
        $add_msg_res = DB::table('msg_config')->insertGetid($add_msg_config);
        $add_role_data['rol_cid'] = 1;
        $add_role_data['rol_shop_id'] = $shop_id;
        $add_role_data['rol_type'] = 1;//角色类型：1店主2员工3技师
        $add_role_data['rol_name'] = '店长';
        $find_pc_pri = DB::table('privileges')
            ->where('pri_shop_version', 'like', '%'.'3'.'%')
            ->where('pri_id', '!=', 821)
            ->where('pri_show', 1)
            ->select('pri_id')
            ->get()->toArray();

        $pc_pri = array_column($find_pc_pri, 'pri_id');

        $find_applet_pri = DB::table('privileges_technician_applet')
            ->where('pri_shop_version', 'like', '%'.'3'.'%')
            ->where('pri_show', 1)
            ->select('pri_id')
            ->get()->toArray();

        $applet_pri = array_column($find_applet_pri, 'pri_id');
        $data_role['pc'] = implode(',',$pc_pri);
        $data_role['applet'] = implode(',',$applet_pri);
        $new_data = json_encode($data_role, true);
        // $add_role_data['rol_privilege_multiple'] = '{"pc":"2,587,590,591,592,594,595,691,692,695,707,588,634,636,637,638,639,666,693,69,70,71,72,73,74,75,76,344,472,577,578,579,581,709,194,196,237,498,499,53,66,67,68,157,158,161,687,688,684,685,686,689,690,697,698,699,701,702,703,704,705,706,29,3,4,5,7,8,198,484,557,23,24,25,26,27,28,30,31,32,33,34,181,694,710,35,36,38,39,40,41,512,42,43,44,45,46,213,620,621,622,623,624","applet":"9,10,11,12,13,14,15,16,17,20,21,22"}';
        $add_role_data['rol_privilege_multiple'] = $new_data;
        $add_role_data['rol_create_time'] = date('Y-m-d H:i:s'); //时间
        $add_role_data['rol_category'] = 1;
        $role_id = DB::table('role')->insertGetid($add_role_data);
        $word = substr($find_adm->adm_phone, 0,6);
        $password = md5($word.'faster123456');
        $admin_add_data['adm_superior_shop_id'] = $shop_id;
        $admin_add_data['adm_shop_id'] = $shop_id;
        $admin_add_data['adm_cid'] = 1;
        $admin_add_data['adm_leave'] = 1; //级别1店长2普通员工3技师4业务员5技师和业务员
        $admin_add_data['adm_phone'] = $find_adm->adm_phone; //手机号
        $admin_add_data['adm_account'] = 'os'.time().rand(100,999); //用户名（登录账号）
        $admin_add_data['adm_password'] = $password; //登录密码
        $admin_add_data['adm_role'] = $role_id; //角色id
        // 新增账号
        $adm_res =  DB::table('admin')->where('adm_id', $user_info->adm_id)->update($admin_add_data);
        $adms_data['adms_adm_id'] = $adm_res; //员工id
        $adms_data['adms_shop_id'] = $shop_id; //门店id
        $adms_data['adms_province'] = $request['shop_province']; //省
        $adms_data['adms_city'] = $request['shop_city']; //城市
        $adms_data['adms_county'] = $request['shop_county']; //县
        $adms_data['adms_address'] = $request['shop_address']; //详细地址
        $adms_data['adms_update_time'] = date('Y-m-d H:i:s'); //更新时间
        // 没有该员工的设置新增
        $adms_res = DB::table('admin_set')->insert($adms_data);
        //添加账号门店权限关系
        $insertAdminShopRoleData = [
            'adm_id' => $user_info->adm_id,
            'shop_cid' => 1,
            'superior_shop_id' => $shop_id,
            'shop_id' => $shop_id,
            'role_id' =>  $role_id,
            'adm_shop_leave' => 1,
            'phone' => $find_adm->adm_phone,
            'login_shop' => 1,
            'create_time' => date("Y-m-d H:i:s", time()),
            'update_time' => date("Y-m-d H:i:s", time()),
        ];
        $insertAdminShopRoleDataRes = DB::table('admin_shop_role')->insert($insertAdminShopRoleData);
        $login_temporary = DB::table('login_temporary')
            ->where('api_token','=',$request['api_token'])
            ->select('last_login','api_token', 'adm_shop_id', 'shop_opening_type', 'shop_on_trial_end_time', 'shop_opening_end_time', 'adm_id')
            ->update(['adm_shop_id'=>$shop_id]);

        // 添加默认仓库分类
        $warehouse_class = config('apisystem.warehouse_class');
        foreach ($warehouse_class as $key => $value) {
            $warehouse_class[$key]['wacl_superior_shop_id'] = $shop_id;
            $warehouse_class[$key]['wacl_shop_id'] = $shop_id;
            $warehouse_class[$key]['wacl_cid'] = 1;
        }
        $class_res = DB::table('warehouse_class')->insert($warehouse_class);

        $service_scope = json_decode($request['service_scope'], true);//服务范围
        foreach ($service_scope as $key => $value) {
            // 品类数据
            $cate_add_data['cate_cid'] = 1;
            $cate_add_data['cate_shop_id'] = $shop_id;
            $cate_add_data['cate_superior_shop_id'] = $shop_id;
            $cate_add_data['cate_parent_id'] = 0;
            $cate_add_data['cate_rank'] = 1;

            $caco['caco_shop_id'] = $shop_id;
            // 商品数据
            $goo_add_data['goo_cid'] = 1;
            $goo_add_data['goo_shop_id'] = $shop_id;
            $goo_add_data['goo_superior_shop_id'] = $shop_id;
            
            $goo_add_data['goo_type'] = 1;   //1正常商品2赠品商品3活动商品4旧货商品5无库存商品
            $goo_add_data['goo_goods_code'] = '';   //商品编号
            $goo_add_data['goo_goods_encode'] = '';   //检索编码
            $goo_add_data['goo_price'] = 100;   //商品零售价格
            $goo_add_data['goo_wholesale_price'] = 100;   //批发价
            $goo_add_data['goo_purchase_price'] = 100; //采购价
            $goo_add_data['goo_assign_state'] = $request->input('goo_assign_state', 1); //商品派单状态：1不允许派单2允许派单
            $goo_add_data['goo_system_code'] = str_pad(1, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
            $goo_add_data['goo_unta_id'] = 3; //商品单位id
            $goo_add_data['goo_unit_conversion'] = ''; //商品单位换算每卷多少米
            $goo_add_data['goo_unit'] = '个'; //商品单位名称
            $goo_add_data['goo_commodity_propert'] = 1; //商品属性：1成品2原材料
            // 2 新增一个品类数据
            $cate_add_data['cate_name'] = $value['sesc_name'];
            $cate_res =  DB::table('category')->insertGetid($cate_add_data);
            $caco['caco_cate_id'] = $cate_res;
            $caco_res = DB::table('category_correlation')->insert($caco);
            // 2 新增一个商品数据
            $goo_add_data['goo_cate_id'] = $cate_res; //所属品类id
            $goo_add_data['goo_cate_name'] = $value['sesc_name']; //品类名称

            // 2 新增一个服务项目数据
            $sepr_add_data = [
                'sepr_cid'=>1,
                'sepr_shop_id'=>$shop_id,
                'sepr_superior_shop_id'=>$shop_id,
                'sepr_money'=>100,
                'sepr_order_money'=>100,
                'sepr_order_type'=>1,
                'sepr_img'=>config('apisystem.server_name_https').'/storage/image/default_goo_img.png',
                'sepr_check_car'=>1,
                'sepr_sort'=>$request->input('sepr_sort', 0),
                'sepr_show_location'=>$request->input('sepr_show_location', 0),//显示位置
                'sepr_work_type'=>2,//流程分类1有工单2不生成工单
            ];
            if ($value['sesc_id'] == 1) {
                $sepr_add_data['sepr_name'] = '洗车';
                $goo_add_data['goo_name'] = '玻璃水';//商品名称
            } elseif ($value['sesc_id'] == 2) {
                $sepr_add_data['sepr_name'] = '贴膜';
                $sepr_add_data['sepr_work_type'] = 1;
                $goo_add_data['goo_name'] = '车膜';
            } elseif ($value['sesc_id'] == 3) {
                $sepr_add_data['sepr_name'] = '保养';
                $goo_add_data['goo_name'] = '机油';
            } elseif ($value['sesc_id'] == 4) {
                $sepr_add_data['sepr_name'] = '换轮胎';
                $goo_add_data['goo_name'] = '轮胎';
            } elseif ($value['sesc_id'] == 5) {
                $sepr_add_data['sepr_name'] = '车品安装';
                $goo_add_data['goo_name'] = '雨刷';
            } elseif ($value['sesc_id'] == 6) {
                $sepr_add_data['sepr_name'] = '其他';
                $goo_add_data['goo_name'] = '其他';
            }
            // 新增服务项目
            $sepr_res =  DB::table('service_project')->insert($sepr_add_data);
            // 新增商品
            $goo_id =  DB::table('goods')->insertGetId($goo_add_data);
        }
        //新增一个异常数据
        $vacm_add_data = [
            'vacm_cid'=>1,
            'vacm_shop_id'=>$shop_id,
            'vacm_superior_shop_id'=>$shop_id,
        ];
        $vacm_add_data['vacm_type'] = 1;
        // 新增异常数据

        $vacm_add_data['vacm_unusual_name'] = '仪表异常 （有故障码）';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $vacm_add_data['vacm_unusual_name'] = '车内照明灯异常';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $vacm_add_data['vacm_unusual_name'] = '车内缺点烟器';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $vacm_add_data['vacm_unusual_name'] = '电动天窗异常';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $vacm_add_data['vacm_unusual_name'] = '电动座椅异常';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);

        $vacm_add_data['vacm_type'] = 2;
        $vacm_add_data['vacm_unusual_name'] = '车头、侧身等灯具类破损或异常';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $vacm_add_data['vacm_unusual_name'] = '车标、格栅、装饰条破损或损坏';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $vacm_add_data['vacm_unusual_name'] = '胶皮密封条破损或异常';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $vacm_add_data['vacm_unusual_name'] = '装饰件破损或异常';
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);
        $date = date("Y-m-d H:i:s");
        // 新增质检数据
        $reward_punishment = [
            [
                'qurp_cid'=>1,
                'qurp_superior_shop_id'=>$shop_id,
                'qurp_shop_id'=>$shop_id,
                'qurp_name'=>'刀痕',
                'qurp_standard'=>-10,
                'qurp_standard_type'=>1,
                'qurp_type'=>1,
                'qurp_update_time'=>$date
            ],
            [
                'qurp_cid'=>1,
                'qurp_superior_shop_id'=>$shop_id,
                'qurp_shop_id'=>$shop_id,
                'qurp_name'=>'气泡',
                'qurp_standard'=>-10,
                'qurp_standard_type'=>1,
                'qurp_type'=>1,
                'qurp_update_time'=>$date
            ],
            [
                'qurp_cid'=>1,
                'qurp_superior_shop_id'=>$shop_id,
                'qurp_shop_id'=>$shop_id,
                'qurp_name'=>'漏漆',
                'qurp_standard'=>-10,
                'qurp_standard_type'=>1,
                'qurp_type'=>1,
                'qurp_update_time'=>$date
            ]
        ];
        $qurp_id = DB::table('wash_quality_reward_punishment')->insert($reward_punishment);
        $remind_phone = $find_adm->adm_phone;
        $remind_content = '【半径美装】尊敬的用户您好，您已成功激活半径门店系统试用权限，系统链接：'.config('apisystem.server_name_https').'，账号：'.$find_adm->adm_phone.'，密码：'.$word.'，请妥善保管切勿向他人泄露。';
        $remind_send_res = sendSmsCode($remind_phone, $remind_content);
        if ($remind_send_res > 0) {
            $send_state = 1;
        } else {
            $send_state = 2;
        }
        // 短信模块日志
        $seme_data['seme_cid'] = 1; //公司id
        $seme_data['seme_shop_id'] = $shop_id; //门店id
        $seme_data['seme_wor_id'] = 0; //订单id
        $seme_data['seme_name'] = '注册门店短信提醒'; //模板名称
        $seme_data['seme_phone'] = $remind_phone; //手机号
        $seme_data['seme_content'] = $remind_content; //内容
        $seme_data['seme_row'] = 1; //条数
        $seme_data['seme_status_code'] = $remind_send_res; //短信状态码
        $seme_data['seme_state'] = $send_state; //状态：1成功2失败
        $seme_data['seme_ip'] = ''; //ip地址
        $seme_data['seme_adm_id'] = 0; //创建人id
        $seme_id = DB::table('send_message')->insert($seme_data);
        if ($shop_id && $class_res) {
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>$shop_id];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
        }
    }

    // 购买店铺的时长、升级
    public static function addShopOrder ($user_info, $request) {
        $shop_order['shor_number'] = 'S'.time().rand(10000,99999);
        $shop_order['shor_state'] = 1;
        $shop_order['shor_create_time'] = date('Y-m-d H:i:s'); //时间
        $shop_order['shor_create_id'] = $request['adm_id'];
        $shop_order['shor_create_name'] = $request['adm_name'];//$user_info->adm_name;
        $shop_order['shor_shop_id'] = $request['adm_shop_id'];//$user_info->adm_shop_id;
        $find_shop = DB::table('shop')
            ->where('shop_id', $request['adm_shop_id'])
            ->select('shop_shve_id', 'shop_buy')
            ->first();
        // 新的版本金额
        $find_level = DB::table('shop_price')
            ->where('shpr_id', $request['shpr_id'])
            ->select('shpr_price', 'shpr_month', 'shpr_order_type')
            ->first();
        if ($find_shop->shop_buy == 2) {//没有购买过
            if ($find_level->shpr_order_type != 1) {
                return ['code'=>200, 'msg'=>'请先购买版本', 'data'=>''];
            }
        }
        if ($request['type'] == 1) {//直接购买
            if (!empty($find_shop->shop_shve_id) && $request['shve_id'] != $find_shop->shop_shve_id) {
                return ['code'=>200, 'msg'=>'套餐不一致', 'data'=>''];
            }
        }
        $find_shop = DB::table('shop as s')
            ->leftJoin('shop_versions as sv', 's.shop_shve_id', '=', 'sv.shve_id')
            ->where('shop_id', $request['adm_shop_id'])
            ->select('shve_id', 'shop_opening_type', 'shop_opening_start_time', 'shop_opening_end_time', 'shop_id', 'shop_shpr_id', 'shop_shve_id', 'shop_toll_space', 'shop_free_shop', 'shop_buy')
            ->first();
        if ($request['type'] == 2) {//升级
            if ($request['shve_id'] < $find_shop->shop_shve_id) {
                return ['code'=>200, 'msg'=>'请选择高于您系统的版本', 'data'=>''];
            }
            $find_shop = DB::table('shop')
                ->where('shop_id', $request['adm_shop_id'])
                ->first();
            $old_year_price = DB::table('shop_price')
                ->where('shpr_id', $find_shop->shop_shpr_id)
                ->value('shpr_price');
            $new_year_price = DB::table('shop_price')
                ->where('shpr_id', $request['shpr_id'])
                ->value('shpr_price');
            if ($find_shop->shop_buy == 1) {
                $price = $new_year_price - $old_year_price;
            } else {
                $price = $new_year_price;
            }
            $shop_order['shor_upPrice'] = $price;
            $shop_order['shor_shop_end_time'] = $find_shop->shop_opening_end_time;
            $shop_order['shor_order_amount'] = $price;//订单总金额
        }
        $find_shop_ver = DB::table('shop_price as sp')
            ->leftJoin('shop_versions as sv', 'sp.shpr_shve_id', '=', 'sv.shve_id')
            ->where('shpr_id', $request['shpr_id'])
            ->first();
        $space_price = 0;
        if ($request['type'] == 1) {//直接购买
            $find_shop_level = DB::table('shop_price')
                ->where('shpr_id', $request['shpr_id'])
                ->select('shpr_price', 'shpr_month', 'shpr_unit')
                ->first();
            if ($find_shop_level->shpr_unit == '天') {
                $day_num = 1;
            } elseif ($find_shop_level->shpr_unit == '周') {
                $day_num = 7;
            } elseif ($find_shop_level->shpr_unit == '月') {
                $day_num = 30;
            } elseif ($find_shop_level->shpr_unit == '年') {
                $day_num = 366;
            }
            if ($find_shop->shop_buy == 1) {//已购买过 续费
                $find_settle = DB::table('settle_in')
                    ->where('shop_id', $request['adm_shop_id'])
                    ->first();
                $find_fshop_id = DB::table('shop')
                    ->where('shop_code', $find_settle->inv_shop_code)
                    ->first();
                $find_shop_ver = DB::table('shop_price')
                    ->leftJoin('shop_versions', 'shve_id', '=', 'shpr_shve_id')
                    ->where('shpr_id', $request['shpr_id'])
                    ->first();
                if ($find_shop_ver->shpr_order_type != 4) {
                    return ['code'=>500, 'msg'=>'参数错误', 'data'=>'付款金额错误'];
                }
                if ($find_shop_level->shpr_unit == '天') {
                    $day_num = 1;
                } elseif ($find_shop_level->shpr_unit == '周') {
                    $day_num = 7;
                } elseif ($find_shop_level->shpr_unit == '月') {
                    $day_num = 30;
                } elseif ($find_shop_level->shpr_unit == '年') {
                    $day_num = 366;
                }
                $shop_opening_end_time = time() + $day_num*24*60*60;
                $shop_order['shor_shop_end_time'] = date('Y-m-d H:i:s', $shop_opening_end_time);
                $shop_space_price=config('apimesssage.shop_space_price');
                $find_bind_shop = DB::table('bind_shop')
                    ->leftJoin('shop', 'shop_id', '=', 'bish_lshop_id')
                    ->where('bish_fshop_id', $request['adm_shop_id'])
                    ->where('bish_state', 1)
                    ->get()->toArray();//分店
                $space_num = 0;
                foreach ($find_bind_shop as $key => $value) {
                    $space_num += $value->shop_toll_space;
                }
                $shop_count = count($find_bind_shop);
                if (($shop_count-$find_shop->shop_free_shop) > 0) {
                    $data['bind_num'] = $shop_count-$find_shop->shop_free_shop;
                    $data['bind_price'] = $data['bind_num']*config('apimesssage.bind_price')*$find_level->shpr_month*100;
                } else {
                    $data['bind_num'] = 0;
                    $data['bind_price'] = 0;
                }
                $data['bind_space_num'] = $space_num;
                $data['bind_space_price'] = $space_num*$shop_space_price*100;
                $space_price = $find_shop->shop_toll_space * $find_shop_level->shpr_month * $shop_space_price * 100 + $data['bind_space_price'];
                $shop_order['shor_order_amount'] = $find_shop_ver->shpr_price + $space_price;//订单总金额
            } else {
                // $shop_opening_end_time = strtotime('+'.$find_level->shpr_month.' month',strtotime($find_shop->shop_opening_end_time));
                $shop_opening_end_time = time() + $day_num*24*60*60;
                $shop_order['shor_shop_end_time'] = date('Y-m-d H:i:s', $shop_opening_end_time);
                $shop_space_price=config('apimesssage.shop_space_price');
                $space_price = $find_shop->shop_toll_space * $find_shop_level->shpr_month * $shop_space_price * 100;
                $shop_order['shor_order_amount'] = $find_shop_ver->shpr_price + $space_price;//订单总金额
            }
        }
        $shop_order['type'] = $request['type'];//1购买2升级
        $shop_order['shor_goo_id'] = $request['shve_id'];//版本id
        $shop_order['shor_shpr_id'] = $request['shpr_id'];//套餐价格id
        $shop_order['shor_goo_name'] = $find_shop_ver->shve_name;
        
        $shop_order['shor_type'] = $request['type'];//1购买2升级
        $shop_order['shor_goo_num'] = 1;
        if (!empty($request['adco_id'])) {
            $find_adco_price = DB::table('admin_coupon')
                ->where('adco_id', $request['adco_id'])
                ->value('adco_price');//优惠券金额
        } else {
            $find_adco_price = 0;
        }

        $shop_order['shor_paid_money'] = 0;//已支付金额

        if ($request['type'] == 1) {
            $shor_goo_name = '';
            $bind_num = 0;
            $bind_num = 0;
            $space_num = 0;
            $bind_price = 0;
            if ($space_price) {
                $shop_order['shor_goo_price'] = $find_shop_ver->shpr_price + ($find_shop->shop_toll_space * $shop_space_price * 100);//商品/套餐金额
                $shop_order['shor_goo_name'] = $find_shop_ver->shve_name .'+'.$find_shop->shop_toll_space.'G空间';
            } else {
                $shop_order['shor_goo_price'] = $find_shop_ver->shpr_price;
                $shop_order['shor_goo_name'] = $find_shop_ver->shve_name;
            }
            if ($find_shop->shop_shve_id == 3) {//连锁版续费加分店金额
                $find_bind_shop = DB::table('bind_shop')
                    ->leftJoin('shop', 'shop_id', '=', 'bish_lshop_id')
                    ->where('bish_fshop_id', $request['adm_shop_id'])
                    ->where('bish_state', 1)
                    ->get()->toArray();
                if (!empty($find_bind_shop)) {
                    foreach ($find_bind_shop as $key => $value) {
                        $space_num += $value->shop_toll_space;
                    }
                    $shop_count = count($find_bind_shop);
                    if (($shop_count-$find_shop->shop_free_shop) > 0) {
                        $bind_num = $shop_count-$find_shop->shop_free_shop;
                        $bind_price = $bind_num*2000*$find_level->shpr_month*100;
                        $shor_goo_name = '分店数量：'.$bind_num.'个 金额：'.$bind_num*2000*$find_level->shpr_month.'元 ';
                    }
                    $bind_space_price = $space_num*$shop_space_price*100;
                    if ($space_num > 0) {
                        $shor_goo_name = $shor_goo_name.'分店空间'.$space_num.'G 金额'.$space_num*$shop_space_price.'元';
                    }
                    $shop_order['shor_goo_price'] = $shop_order['shor_goo_price'] + $bind_price + $bind_space_price;
                    $shop_order['shor_order_amount'] = $shop_order['shor_order_amount'] + $bind_price + $bind_space_price;
                    $shop_order['shor_goo_name'] = $shop_order['shor_goo_name'].$shor_goo_name;
                }
            }
        } else {
            // $surplus_year = intval(round($surplus_time)/366);
            // $surplus_day = round($surplus_time) - $surplus_year*366;
            // $time_string = '';
            // if ($surplus_year) {
            //     $time_string = $surplus_year.'年';
            // }
            // if ($surplus_day) {
            //     $time_string = $time_string.$surplus_day.'天';
            // }
            $shop_order['shor_goo_name'] = '升级至'. $find_shop_ver->shve_name;//剩余天数;
            $shop_order['shor_goo_price'] = $find_shop_ver->shpr_price;
        }
        if ($request['type'] == 1) {
            $shop_order['shor_pay_amount'] = $find_shop_ver->shpr_price - $find_adco_price + $space_price;//需要付款的实际金额
            if ($bind_num > 0) {
                $shop_order['shor_pay_amount'] = $shop_order['shor_pay_amount'] + $bind_price + $bind_space_price;
            }
        } elseif ($request['type'] == 2) {
            $shop_order['shor_pay_amount'] = $price - $find_adco_price + $space_price;//需要付款的实际金额
        }
        if($shop_order['shor_pay_amount'] < 0){
            return ['code'=>500, 'msg'=>'付款金额错误', 'data'=>'付款金额错误'];
        }
        if (isset($request['inv_code']) && $request['inv_code']) {
            $find_shic_data = DB::table('shop_invitate_code_config')
                ->where('shic_code', $request['inv_code'])
                ->first();
            if ($find_shic_data) {
                if ($find_shop->shop_buy == 1 && $find_shic_data->shic_code_type == 2) {//购买过版本 不能使用版本类型
                    return ['code'=>500, 'msg'=>'此邀请码类型只能用于购买版本', 'data'=>''];
                }
                if ($find_shic_data->shic_state != 1) {
                    return ['code'=>500, 'msg'=>'此邀请码已失效', 'data'=>''];
                }
                if ($find_shic_data->shic_use_num >= $find_shic_data->shic_num) {
                    return ['code'=>500, 'msg'=>'此邀请码数量已超出限制', 'data'=>''];
                }
                if ($find_shic_data->shic_end_date < date('Y-m-d H:i:s')) {
                    return ['code'=>500, 'msg'=>'此邀请码过期', 'data'=>''];
                }
            }
            $update_shic_data['shic_use_num'] = $find_shic_data->shic_use_num + 1;
            if ($update_shic_data['shic_use_num'] >= $find_shic_data->shic_num) {
                $update_shic_data['shic_state'] = 2;
            }
            $update_shic_res = DB::table('shop_invitate_code_config')
                ->where('shic_id', $find_shic_data->shic_id)
                ->update($update_shic_data);
            $shop_order['shor_pay_amount'] = $shop_order['shor_pay_amount'] - $find_shic_data->shic_discount_price;
            if ($shop_order['shor_pay_amount'] < 0) {
                $shop_order['shor_pay_amount'] = 0;
            }
            $shop_order['shor_discount_amount'] = $find_shic_data->shic_discount_price;
            $shop_order['shor_inv_code'] = $find_shic_data->shic_code;
        }
        $add_shop_order_res = DB::table('shop_order')->insertGetid($shop_order);
        if ($request['type'] == 1) {//直接购买
            if (!empty($find_bind_shop)) {
                foreach ($find_bind_shop as $key => $value) {
                    if ($value->shop_toll_space > 0) {
                        $add_info['soin_shor_id'] = $add_shop_order_res;
                        $add_info['soin_shop_id'] = $request['adm_shop_id'];
                        $add_info['soin_bind_shop_id'] = $value->bish_lshop_id;
                        $add_info['soin_bind_space_num'] = $value->shop_toll_space;
                        $add_info['soin_bind_space_amount'] = $value->shop_toll_space*$shop_space_price*100;
                        $add_info_res = DB::table('shop_order_info')->insertGetid($add_info);
                    }
                }
            }
        }
        if ($request['type'] == 1 || $request['type'] == 2) {//其他未付款的订单改为已取消
            $find_shop_order = DB::table('shop_order')
                ->where('shor_shop_id', $request['adm_shop_id'])
                ->where('shor_id', '<>', $add_shop_order_res)
                ->where('shor_pay_state', 1)
                ->whereIn('shor_type',[1,2])
                ->update(['shor_state'=>4]);
        }
        $data['shor_id'] = $add_shop_order_res;
        $data['shor_number'] = $shop_order['shor_number'];
        if ($shop_order['shor_pay_amount'] == 0) {//优惠后不用付款的
            $find_order = DB::table('shop_order')
                ->leftJoin('shop', 'shop_id', '=', 'shor_shop_id')
                ->where('shor_id', $add_shop_order_res)
                ->first();
            
            if ($find_order->type == 3) {//短信充值
                $update_order = DB::table('shop_order')
                    ->where('shor_number', $find_order->shor_number)
                    ->update(['shor_pay_state'=>2,'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_other_num'=>'','shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
                // 修改店铺短信数量
                $find_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->first();
                $update_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->update(['shop_message_num'=>($find_shop->shop_message_num + $find_order->shor_goo_num)]);
                $update_log = DB::table('sms_log')
                    ->where('smlo_ord_num', $find_order->shor_number)
                    ->update(['smlo_state'=>1]);
                $msg_remind_log = DB::table('msg_remind_log')
                    ->where('mrlo_shop_id', $find_order->shor_shop_id)
                    ->where('mrlo_state', 2)
                    ->first();
                if ($msg_remind_log) {//已提醒过
                    if (($find_shop->shop_message_num + $find_order->shor_goo_num) > $find_shop->shop_msg_remind) {
                        $update_remind['mrlo_state'] = 1;
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $find_order->shor_shop_id)
                            ->where('mrlo_state', 2)
                            ->update($update_remind);
                    }
                }
                return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
            }

            if ($find_order->type == 4) {//空间购买
                $update_order = DB::table('shop_order')
                    ->where('shor_number', $find_order->shor_number)
                    ->update(['shor_pay_state'=>2,'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_other_num'=>'','shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
                // 修改店铺空间数量
                $find_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_get_shop_id)
                    ->first();
                $update_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_get_shop_id)
                    ->update(['shop_toll_space'=>($find_shop->shop_toll_space + $find_order->shor_goo_num)]);
                return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
            }

            if ($find_order->type == 5) {//分店购买
                $update_order = DB::table('shop_order')
                    ->where('shor_number', $find_order->shor_number)
                    ->update(['shor_pay_state'=>2,'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_other_num'=>'','shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
                // 修改店铺空间数量
                $find_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->first();
                $update_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->update(['shop_toll_shop'=>($find_shop->shop_toll_shop + $find_order->shor_goo_num)]);
                return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
            }
            if ($find_order->type == 1 || $find_order->type == 2) {//升级赠送空间/短信
                if ($find_order->shor_goo_id == 1) {
                    $shop_free_space = 3;
                    $update_res = DB::table('service_project')
                        ->where('sepr_shop_id', $find_order->shor_shop_id)
                        ->update(['sepr_work_type'=>2]);
                }
                if ($find_order->shor_goo_id == 2) {
                    $shop_free_space = 5;
                }
                if ($find_order->shor_goo_id == 3) {
                    $shop_free_space = 10;
                    $adm_update = DB::table('admin_shop_role')
                        ->where('shop_id', $find_order->shor_shop_id)
                        ->where('adm_shop_leave', 1)
                        ->update(['login_bind_shop'=>1]);
                }
                $shop_update['shop_free_space'] = $shop_free_space;
            }
            if (($find_order->type == 1 && $find_order->shop_shve_id != $find_order->shor_goo_id)|| $find_order->type == 2) {//初次购买此版本或者升级版本送短信
                if ($find_order->shor_goo_id == 1) {
                    $shop_message_num = 200;
                } elseif ($find_order->shor_goo_id == 2) {
                    $shop_message_num = 300;
                } elseif ($find_order->shor_goo_id == 3) {
                    $shop_message_num = 500;
                }
                if ($find_order->shop_shve_id == 1) {
                    $old_message_num = 200;
                } elseif ($find_order->shop_shve_id == 2) {
                    $old_message_num = 300;
                } elseif ($find_order->shop_shve_id == 3) {
                    $old_message_num = 500;
                } else {
                    $old_message_num = 20;
                }
                $shop_update['shop_message_num'] = $find_order->shop_message_num + $shop_message_num - $old_message_num;
            }
            
            $shop_update['shop_state'] = 1;
            $shop_update['shop_shve_id'] = $find_order->shor_goo_id;
            $shop_update['shop_shpr_id'] = $find_order->shor_shpr_id;
            $shop_update['shop_buy'] = 1;
            $shop_update['shop_opening_type'] = 2;
            $shop_update['shop_update_time'] = date('Y-m-d H:i:s');
            if ($find_order->shop_opening_start_time == '0000-00-00 00:00:00') {
                $shop_update['shop_opening_start_time'] = date('Y-m-d H:i:s');
            }
            $find_shop_versions = DB::table('shop_price')
                ->where('shpr_id', $find_order->shor_shpr_id)
                ->first();
            if($find_order->type ==1){//1购买2升级
                $find_shop_level = DB::table('shop_price')
                    ->where('shpr_id', $find_order->shor_shpr_id)
                    ->select('shpr_price', 'shpr_month', 'shpr_unit')
                    ->first();
                if ($find_shop_level->shpr_unit == '天') {
                    $day_string = '+'.$find_shop_level->shpr_month.' day';
                } elseif ($find_shop_level->shpr_unit == '周') {
                    $day_string = '+'.$find_shop_level->shpr_month.' week';
                } elseif ($find_shop_level->shpr_unit == '月') {
                    $day_string = '+'.$find_shop_level->shpr_month.' month';
                } elseif ($find_shop_level->shpr_unit == '年') {
                    $day_string = '+'.$find_shop_level->shpr_month.' year';
                }
                if ($find_order->shop_opening_end_time == '0000-00-00 00:00:00') {
                    $shop_update['shop_opening_end_time'] = date('Y-m-d H:i:s', strtotime($day_string));
                } else {
                    $shop_opening_end_time = strtotime($day_string,strtotime($find_order->shop_opening_end_time));
                    $shop_update['shop_opening_end_time'] = date('Y-m-d H:i:s', $shop_opening_end_time);
                }
                $find_bind_shop = DB::table('bind_shop')
                    ->leftJoin('shop', 'shop_id', '=', 'bish_lshop_id')
                    ->where('bish_fshop_id', $find_order->shor_shop_id)
                    ->where('bish_state', 1)
                    ->get()->toArray();
                foreach ($find_bind_shop as $key => $value) {
                    $update_bind['shop_opening_type'] = $shop_update['shop_opening_type'];
                    $update_bind['shop_opening_end_time'] = $shop_update['shop_opening_end_time'];
                    $update_bind['shop_update_time'] = date('Y-m-d H:i:s');
                    $update_bind_res = DB::table('shop')
                        ->where('shop_id', $value->bish_lshop_id)
                        ->update($update_bind);
                }
            }

            $update_order = DB::table('shop_order')
                ->where('shor_number', $find_order->shor_number)
                ->update(['shor_pay_state'=>2, 'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
            $find_shop = DB::table('shop')
                ->where('shop_id', $find_order->shor_shop_id)
                ->update($shop_update);
            //修改店铺权限
            $find_role = DB::table('role')
                ->where('rol_shop_id', $find_order->shor_shop_id)
                ->get()->toArray();
                
            $find_pc_pri = DB::table('privileges')
                ->where('pri_shop_version', 'like', '%'.$find_order->shor_goo_id.'%')
                ->select('pri_id')
                ->get()->toArray();

            $pc_pri = array_column($find_pc_pri, 'pri_id');

            $find_applet_pri = DB::table('privileges_technician_applet')
                ->where('pri_shop_version', 'like', '%'.$find_order->shor_goo_id.'%')
                ->select('pri_id')
                ->get()->toArray();

            $applet_pri = array_column($find_applet_pri, 'pri_id');
            $pri_data['pc'] = implode(',',$pc_pri);
            $pri_data['applet'] = implode(',',$applet_pri);
            $new_data = json_encode($pri_data, true);
            foreach ($find_role as $key => $value) {
                if ($value->rol_type == 1) {//店长
                    $updata_res = DB::table('role')
                        ->where('rol_id', $value->rol_id)
                        ->update(['rol_privilege_multiple'=>$new_data,'rol_update_time'=>date('Y-m-d H:i:s')]);
                } else {
                    $rol_privilege_multiple = json_decode($value->rol_privilege_multiple, true);

                    $rol_pc = explode(',', $rol_privilege_multiple['pc']);
                    $rol_applet = explode(',', $rol_privilege_multiple['applet']);
                    $new_rol_pc = array_intersect($pc_pri,$rol_pc);
                    $new_rol_applet = array_intersect($applet_pri,$rol_applet);
                    $json_data['pc'] = implode(',',$new_rol_pc);
                    $json_data['applet'] = implode(',',$new_rol_applet);
                    $update_data['rol_privilege_multiple'] = json_encode($json_data, true);
                    $update_data['rol_update_time'] = date('Y-m-d H:i:s');
                    $updata_res = DB::table('role')
                        ->where('rol_id', $value->rol_id)
                        ->update($update_data);
                }
            }
        }
        
        if ($add_shop_order_res) {
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
        }
    }

    // 付款选择打款
    public static function payShopOrder ($user_info, $request) {
        $shop_order['shor_pay_time'] = $request['shor_pay_time']; //时间
        $shop_order['shor_pay_state'] = 2;
        $shop_order['shor_pay_account'] = $request['shor_pay_account']; //支付账户
        $shop_order['shor_pay_name'] = $request['shor_pay_name']; //支付账号
        $shop_order['shor_pay_check'] = 2; //是否审核1是2否
        $add_shop_order_res = DB::table('shop_order')->where('shor_number', $request['shor_number'])->update($shop_order);
        if ($add_shop_order_res) {
            return ['code'=>200, 'msg'=>'付款成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'付款失败', 'data'=>'付款失败'];
        }
    }

    // 获取升级店铺金额
    public static function getNeedPay ($user_info, $request) {
        $find_shop = DB::table('shop as s')
            ->leftJoin('shop_versions as sv', 's.shop_shve_id', '=', 'sv.shve_id')
            ->where('shop_id', $request['shop_id'])
            ->select('shve_id', 'shop_opening_type', 'shop_opening_start_time', 'shop_opening_end_time', 'shop_id', 'shop_shpr_id')
            ->first();
        // 原来店铺的等级金额
        $find_shop_level = DB::table('shop_price')
            ->where('shpr_id', $find_shop->shop_shpr_id)
            ->select('shpr_price', 'shpr_month', 'shpr_duration')
            ->first();
        // 新的版本金额
        $find_level = DB::table('shop_price')
            ->where('shpr_shve_id', $request['shve_id'])
            ->where('shpr_month', $find_shop_level->shpr_month)
            ->select('shpr_price', 'shpr_month', 'shpr_unit')
            ->first();
        if ($find_level->shpr_unit == '天') {
            $day_num = 1;
        } elseif ($find_level->shpr_unit == '周') {
            $day_num = 7;
        } elseif ($find_level->shpr_unit == '月') {
            $day_num = 30;
        } elseif ($find_level->shpr_unit == '年') {
            $day_num = 366;
        }
        $find_shop_order = DB::table('shop_order')
            ->where('shor_shop_id', $request['shop_id'])
            ->where('shor_pay_state', 2)
            ->first();
        $lowPrice = $find_shop_level->shpr_price/($find_shop_level->shpr_month*$day_num);//原来每天的金额
        $upPrice = $find_level->shpr_price/($find_level->shpr_month*$day_num);//升级后每天的金额
        $surplus_time = ((strtotime($find_shop->shop_opening_end_time) - time())/86400)%366;//剩余天数
        $price = round($surplus_time * ($upPrice - $lowPrice));
        if ($surplus_time < 0) {
            return ['code'=>500, 'msg'=>'时间过期，不能升级', 'data'=>$price, 'lowPrice'=>$lowPrice, 'upPrice'=>$upPrice,'surplus_time'=>$surplus_time, 'find_shop_level'=>$find_shop_level];
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$price, 'lowPrice'=>$lowPrice, 'upPrice'=>$upPrice,'surplus_time'=>$surplus_time, 'find_shop_level'=>$find_shop_level];
    }

    public static function getService () {
        $service_scope = DB::table('service_scope')
            ->get()->toArray();
        
        return ['code'=>200, 'msg'=>'success', 'data'=>$service_scope];
    }
    
    /**|---------------------------------------------------------------------------------
     * @name 筛选店铺名称
     * @param string $shop_name 门店名称
     * @param string $shop_type 门店类型  1本店  2其他门店
     * @param string $screen_data 筛选信息
     * @retrun /multitype:string
     * @author dou 2023-06-26 026 上午 10:00:43
     * |---------------------------------------------------------------------------------
    */
    public static function screenShopName ( $shop_name , $shop_type , $screen_data ){
        $shop_name = CommonService::screenData($shop_name, $screen_data, 1);
        if($shop_type == 1){
            $shop_name = $shop_name.$screen_data;
        }else{

        }
        return $shop_name;
    }

    /*
     * @name 新增门店默认的客户关怀
     * @retrun array
     * @author Ma 2023/9/6 10:58
     *
    */
    public static function addFestival($shop_id){
        if($shop_id){
            $festival_arr[0] = ['fest_type'=>2,'fest_name'=>'客户生日当天提醒','fest_days'=>0,'fest_default'=>1,'fest_content'=>''];
            $festival_arr[1] = ['fest_type'=>2,'fest_name'=>'客户生日提前几天提醒','fest_days'=>2,'fest_default'=>1,'fest_content'=>''];
            $festival_arr[2] = ['fest_type'=>2,'fest_name'=>'客户生日提醒业务人员','fest_days'=>2,'fest_default'=>1,'fest_content'=>''];
            $festival_arr[3] = ['fest_type'=>1,'fest_name'=>'元旦','fest_days'=>0,'fest_date'=>'2024-01-01','fest_default'=>1,'fest_content'=>''];
            $festival_arr[4] = ['fest_type'=>1,'fest_name'=>'春节','fest_days'=>0,'fest_date'=>'2024-02-10','fest_default'=>1,'fest_content'=>''];
            $festival_arr[5] = ['fest_type'=>1,'fest_name'=>'元宵节','fest_days'=>0,'fest_date'=>'2024-02-24','fest_default'=>1,'fest_content'=>''];
            $festival_arr[6] = ['fest_type'=>1,'fest_name'=>'端午节','fest_days'=>0,'fest_date'=>'2024-06-10','fest_default'=>1,'fest_content'=>''];
            $festival_arr[7] = ['fest_type'=>1,'fest_name'=>'七夕节','fest_days'=>0,'fest_date'=>'2024-08-10','fest_default'=>1,'fest_content'=>''];
            $festival_arr[8] = ['fest_type'=>1,'fest_name'=>'中秋节','fest_days'=>0,'fest_date'=>'2023-09-29','fest_default'=>1,'fest_content'=>''];
            $festival_arr[10] = ['fest_type'=>1,'fest_name'=>'国庆节','fest_days'=>0,'fest_date'=>'2023-10-01','fest_default'=>1,'fest_content'=>''];
            foreach ($festival_arr as $key => $value){
                $fest_add_data['fest_cid'] = 1;
                $fest_add_data['fest_shop_id'] = $shop_id;
                $fest_add_data['fest_superior_shop_id'] = $shop_id;
                $fest_add_data['fest_type'] = $value['fest_type'];
                $fest_add_data['fest_name'] = $value['fest_name'];
                $fest_add_data['fest_start'] = 2;//是否自动开始：1是2否
                $fest_add_data['fest_days'] = $value['fest_days'];
                $fest_add_data['fest_content'] = $value['fest_content'];
                $fest_add_data['fest_default'] = $value['fest_default'];
                $fest_add_data['fest_create_time'] = date('Y-m-d H:i:s');
                DB::table('festival_remind')->insertGetId($fest_add_data);
            }
            $sms_add_data['shsm_shop_id'] = $shop_id;
            $sms_add_data['shsm_count'] = 100;
            DB::table('shop_sms_count')->insertGetId($sms_add_data);
        }
    }

    /**
     * 短信套餐
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-10
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function msgPackage($user_info, $request) {
        $list_data = DB::table('message_package')
            ->where('mspa_type', $request['mspa_type'])
            ->get()->toArray();
        return $list_data;
    }

    /**
     * 短信充值
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-10
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     */
    public static function addSmsOrder ($user_info, $request) {
        if ($request['mspa_type'] == 1) {//购买短信套餐
            if (empty($request['mspa_id'])) {
                return ['code'=>500, 'msg'=>'请选择套餐', 'data'=>''];
            }
        } elseif ($request['mspa_type'] == 2) {
            if (empty($request['mspa_amount'])) {
                return ['code'=>500, 'msg'=>'请输入充值金额', 'data'=>''];
            }
            $find_mspa = DB::table('message_package')
                ->where('mspa_type', 2)
                ->get()->toArray();
            $mspa_amount = $request['mspa_amount'] * 100;
            foreach ($find_mspa as $key => $value) {
                if ($mspa_amount >= $value->mspa_min && $mspa_amount <= $value->mspa_max) {
                    $mspa_price = $value->mspa_price;
                }

                if ($mspa_amount >= $value->mspa_min && $value->mspa_max == 0) {
                    $mspa_price = $value->mspa_price;
                }
            }
            $mspa_num = intval(ceil($mspa_amount/$mspa_price));
        } else {
            return ['code'=>500, 'msg'=>'充值方式错误', 'data'=>''];
        }
        $shop_order['shor_number'] = 'S'.time().rand(10000,99999);
        $shop_order['shor_state'] = 1;//1未付款2处理中3已完成4已取消
        $shop_order['shor_create_time'] = date('Y-m-d H:i:s'); //时间
        $shop_order['shor_create_id'] = $user_info->adm_id;
        $shop_order['shor_create_name'] = $user_info->adm_name;
        $shop_order['shor_shop_id'] = $user_info->adm_shop_id;
        
        $shop_order['type'] = 3;//1购买2升级3短信充值
        $shop_order['shor_goo_id'] = $request['mspa_id'];//版本id
        $shop_order['shor_shpr_id'] = $request['mspa_id'];//套餐价格id
        $shop_order['shor_pay_way'] = $request['shor_pay_way'];//支付方式
        $find_data = DB::table('message_package')
            ->where('mspa_id', $request['mspa_id'])
            ->first();
        if ($request['mspa_type'] == 1) {
            $shop_order['shor_order_amount'] = $find_data->mspa_amount;//订单总金额
            $shop_order['shor_goo_name'] = '充值'.$find_data->mspa_num.'条短信';
            $shop_order['shor_goo_price'] = $find_data->mspa_amount;//商品/套餐金额
            $shop_order['shor_pay_amount'] = $find_data->mspa_amount;//需要付款的实际金额
            $shop_order['shor_goo_num'] = $find_data->mspa_num;
            $shop_order['shor_remark'] = '短信包';
            $mspa_num = $find_data->mspa_num;
        } else {
            $shop_order['shor_order_amount'] = $request['mspa_amount']*100;//订单总金额
            $shop_order['shor_goo_name'] = '充值'.$mspa_num.'条短信';
            $shop_order['shor_goo_price'] = $mspa_price;//商品/套餐金额
            $shop_order['shor_pay_amount'] = $request['mspa_amount']*100;//需要付款的实际金额
            $shop_order['shor_goo_num'] = $mspa_num;
            $shop_order['shor_remark'] = '短信充值';
        }
        $shop_order['shor_type'] = 3;//1购买2升级3短信充值
        if (isset($request['inv_code']) && $request['inv_code']) {
            $find_shic_data = DB::table('shop_invitate_code_config')
                ->where('shic_code', $request['inv_code'])
                ->first();
            if ($find_shic_data) {
                if ($find_shic_data->shic_code_type == 2) {//购买过版本 不能使用版本类型
                    return ['code'=>500, 'msg'=>'此邀请码类型只能用于购买版本', 'data'=>''];
                }
                if ($find_shic_data->shic_state != 1) {
                    return ['code'=>500, 'msg'=>'此邀请码已失效', 'data'=>''];
                }
                if ($find_shic_data->shic_use_num >= $find_shic_data->shic_num) {
                    return ['code'=>500, 'msg'=>'此邀请码数量已超出限制', 'data'=>''];
                }
                if ($find_shic_data->shic_end_date < date('Y-m-d H:i:s')) {
                    return ['code'=>500, 'msg'=>'此邀请码过期', 'data'=>''];
                }
            }
            $update_shic_data['shic_use_num'] = $find_shic_data->shic_use_num + 1;
            if ($update_shic_data['shic_use_num'] >= $find_shic_data->shic_num) {
                $update_shic_data['shic_state'] = 2;
            }
            $update_shic_res = DB::table('shop_invitate_code_config')
                ->where('shic_id', $find_shic_data->shic_id)
                ->update($update_shic_data);
            $shop_order['shor_pay_amount'] = $shop_order['shor_pay_amount'] - $find_shic_data->shic_discount_price;
            if ($shop_order['shor_pay_amount'] < 0) {
                $shop_order['shor_pay_amount'] = 0;
            }
            $shop_order['shor_discount_amount'] = $find_shic_data->shic_discount_price;
            $shop_order['shor_inv_code'] = $find_shic_data->shic_code;
        }
        $add_shop_order_res = DB::table('shop_order')->insertGetid($shop_order);

        $add_log['smlo_shop_id'] = $user_info->adm_shop_id;
        $add_log['smlo_mem_type'] = 1;//1业务人员2会员
        $add_log['smlo_mem_id'] = $user_info->adm_id;
        $add_log['smlo_mem_name'] = $user_info->adm_name;
        $add_log['smlo_mem_phone'] = $user_info->adm_phone;
        $add_log['smlo_type'] = 1;
        $add_log['smlo_create_time'] = date('Y-m-d H:i:s');
        $add_log['smlo_state'] = 2;
        $add_log['smlo_msg_type'] = 1;
        $add_log['smlo_num'] = $mspa_num;
        $add_log['smlo_ord_num'] = $shop_order['shor_number'];
        $add_log['smlo_content'] = '充值'.$mspa_num.'条短信';
        $add_log_res = DB::table('sms_log')->insertGetId($add_log);
        $data['shor_id'] = $add_shop_order_res;
        $data['shor_number'] = $shop_order['shor_number'];
        $data['shor_pay_amount'] = $shop_order['shor_pay_amount'];
        if ($shop_order['shor_pay_amount'] == 0) {//优惠后不用付款的
            $find_order = DB::table('shop_order')
                ->leftJoin('shop', 'shop_id', '=', 'shor_shop_id')
                ->where('shor_id', $add_shop_order_res)
                ->first();
            
            if ($find_order->type == 3) {//短信充值
                $update_order = DB::table('shop_order')
                    ->where('shor_number', $find_order->shor_number)
                    ->update(['shor_pay_state'=>2,'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_other_num'=>'','shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
                // 修改店铺短信数量
                $find_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->first();
                $update_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->update(['shop_message_num'=>($find_shop->shop_message_num + $find_order->shor_goo_num)]);
                $update_log = DB::table('sms_log')
                    ->where('smlo_ord_num', $find_order->shor_number)
                    ->update(['smlo_state'=>1]);
                $msg_remind_log = DB::table('msg_remind_log')
                    ->where('mrlo_shop_id', $find_order->shor_shop_id)
                    ->where('mrlo_state', 2)
                    ->first();
                if ($msg_remind_log) {//已提醒过
                    if (($find_shop->shop_message_num + $find_order->shor_goo_num) > $find_shop->shop_msg_remind) {
                        $update_remind['mrlo_state'] = 1;
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $find_order->shor_shop_id)
                            ->where('mrlo_state', 2)
                            ->update($update_remind);
                    }
                }
                return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
            }

            if ($find_order->type == 4) {//空间购买
                $update_order = DB::table('shop_order')
                    ->where('shor_number', $find_order->shor_number)
                    ->update(['shor_pay_state'=>2,'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_other_num'=>'','shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
                // 修改店铺空间数量
                $find_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_get_shop_id)
                    ->first();
                $update_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_get_shop_id)
                    ->update(['shop_toll_space'=>($find_shop->shop_toll_space + $find_order->shor_goo_num)]);
                return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
            }

            if ($find_order->type == 5) {//分店购买
                $update_order = DB::table('shop_order')
                    ->where('shor_number', $find_order->shor_number)
                    ->update(['shor_pay_state'=>2,'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_other_num'=>'','shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
                // 修改店铺空间数量
                $find_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->first();
                $update_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->update(['shop_toll_shop'=>($find_shop->shop_toll_shop + $find_order->shor_goo_num)]);
                return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
            }
            if ($find_order->type == 1 || $find_order->type == 2) {//升级赠送空间/短信
                if ($find_order->shor_goo_id == 1) {
                    $shop_free_space = 3;
                    $update_res = DB::table('service_project')
                        ->where('sepr_shop_id', $find_order->shor_shop_id)
                        ->update(['sepr_work_type'=>2]);
                }
                if ($find_order->shor_goo_id == 2) {
                    $shop_free_space = 5;
                }
                if ($find_order->shor_goo_id == 3) {
                    $shop_free_space = 10;
                    $adm_update = DB::table('admin_shop_role')
                        ->where('shop_id', $find_order->shor_shop_id)
                        ->where('adm_shop_leave', 1)
                        ->update(['login_bind_shop'=>1]);
                }
                $shop_update['shop_free_space'] = $shop_free_space;
            }
            if (($find_order->type == 1 && $find_order->shop_shve_id != $find_order->shor_goo_id)|| $find_order->type == 2) {//初次购买此版本或者升级版本送短信
                if ($find_order->shor_goo_id == 1) {
                    $shop_message_num = 200;
                } elseif ($find_order->shor_goo_id == 2) {
                    $shop_message_num = 300;
                } elseif ($find_order->shor_goo_id == 3) {
                    $shop_message_num = 500;
                }
                if ($find_order->shop_shve_id == 1) {
                    $old_message_num = 200;
                } elseif ($find_order->shop_shve_id == 2) {
                    $old_message_num = 300;
                } elseif ($find_order->shop_shve_id == 3) {
                    $old_message_num = 500;
                } else {
                    $old_message_num = 20;
                }
                $shop_update['shop_message_num'] = $find_order->shop_message_num + $shop_message_num - $old_message_num;
            }
            
            $shop_update['shop_state'] = 1;
            $shop_update['shop_shve_id'] = $find_order->shor_goo_id;
            $shop_update['shop_shpr_id'] = $find_order->shor_shpr_id;
            $shop_update['shop_buy'] = 1;
            $shop_update['shop_opening_type'] = 2;
            $shop_update['shop_update_time'] = date('Y-m-d H:i:s');
            if ($find_order->shop_opening_start_time == '0000-00-00 00:00:00') {
                $shop_update['shop_opening_start_time'] = date('Y-m-d H:i:s');
            }
            $find_shop_versions = DB::table('shop_price')
                ->where('shpr_id', $find_order->shor_shpr_id)
                ->first();
            if($find_order->type ==1){//1购买2升级
                $find_shop_level = DB::table('shop_price')
                    ->where('shpr_id', $find_order->shor_shpr_id)
                    ->select('shpr_price', 'shpr_month', 'shpr_unit')
                    ->first();
                if ($find_shop_level->shpr_unit == '天') {
                    $day_string = '+'.$find_shop_level->shpr_month.' day';
                } elseif ($find_shop_level->shpr_unit == '周') {
                    $day_string = '+'.$find_shop_level->shpr_month.' week';
                } elseif ($find_shop_level->shpr_unit == '月') {
                    $day_string = '+'.$find_shop_level->shpr_month.' month';
                } elseif ($find_shop_level->shpr_unit == '年') {
                    $day_string = '+'.$find_shop_level->shpr_month.' year';
                }
                if ($find_order->shop_opening_end_time == '0000-00-00 00:00:00') {
                    $shop_update['shop_opening_end_time'] = date('Y-m-d H:i:s', strtotime($day_string));
                } else {
                    $shop_opening_end_time = strtotime($day_string,strtotime($find_order->shop_opening_end_time));
                    $shop_update['shop_opening_end_time'] = date('Y-m-d H:i:s', $shop_opening_end_time);
                }
                $find_bind_shop = DB::table('bind_shop')
                    ->leftJoin('shop', 'shop_id', '=', 'bish_lshop_id')
                    ->where('bish_fshop_id', $find_order->shor_shop_id)
                    ->where('bish_state', 1)
                    ->get()->toArray();
                foreach ($find_bind_shop as $key => $value) {
                    $update_bind['shop_opening_type'] = $shop_update['shop_opening_type'];
                    $update_bind['shop_opening_end_time'] = $shop_update['shop_opening_end_time'];
                    $update_bind['shop_update_time'] = date('Y-m-d H:i:s');
                    $update_bind_res = DB::table('shop')
                        ->where('shop_id', $value->bish_lshop_id)
                        ->update($update_bind);
                }
            }

            $update_order = DB::table('shop_order')
                ->where('shor_number', $find_order->shor_number)
                ->update(['shor_pay_state'=>2, 'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
            $find_shop = DB::table('shop')
                ->where('shop_id', $find_order->shor_shop_id)
                ->update($shop_update);
            //修改店铺权限
            $find_role = DB::table('role')
                ->where('rol_shop_id', $find_order->shor_shop_id)
                ->get()->toArray();
                
            $find_pc_pri = DB::table('privileges')
                ->where('pri_shop_version', 'like', '%'.$find_order->shor_goo_id.'%')
                ->select('pri_id')
                ->get()->toArray();

            $pc_pri = array_column($find_pc_pri, 'pri_id');

            $find_applet_pri = DB::table('privileges_technician_applet')
                ->where('pri_shop_version', 'like', '%'.$find_order->shor_goo_id.'%')
                ->select('pri_id')
                ->get()->toArray();

            $applet_pri = array_column($find_applet_pri, 'pri_id');
            $data['pc'] = implode(',',$pc_pri);
            $data['applet'] = implode(',',$applet_pri);
            $new_data = json_encode($data, true);
            foreach ($find_role as $key => $value) {
                if ($value->rol_type == 1) {//店长
                    $updata_res = DB::table('role')
                        ->where('rol_id', $value->rol_id)
                        ->update(['rol_privilege_multiple'=>$new_data,'rol_update_time'=>date('Y-m-d H:i:s')]);
                } else {
                    $rol_privilege_multiple = json_decode($value->rol_privilege_multiple, true);

                    $rol_pc = explode(',', $rol_privilege_multiple['pc']);
                    $rol_applet = explode(',', $rol_privilege_multiple['applet']);
                    $new_rol_pc = array_intersect($pc_pri,$rol_pc);
                    $new_rol_applet = array_intersect($applet_pri,$rol_applet);
                    $json_data['pc'] = implode(',',$new_rol_pc);
                    $json_data['applet'] = implode(',',$new_rol_applet);
                    $update_data['rol_privilege_multiple'] = json_encode($json_data, true);
                    $update_data['rol_update_time'] = date('Y-m-d H:i:s');
                    $updata_res = DB::table('role')
                        ->where('rol_id', $value->rol_id)
                        ->update($update_data);
                }
            }
        }
        if ($add_shop_order_res) {
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取结算方式名称
     * @param string $type 请求类型
     * @retrun /multitype:array
     * @author li 2023-10-11 上午 11:31:42
     * |---------------------------------------------------------------------------------
     */
    public static function getPaymentWayName($type=false){
        // 结算方式1.现金2.支付宝 3微信 4银行卡5会员卡
        $data = [['type'=>1,'name'=>'微信'],['type'=>2,'name'=>'支付宝']/*,['type'=>3,'name'=>'线下转账']*/];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }

    /**|---------------------------------------------------------------------------------
     * @name 短信类型
     * @param string $type 请求类型
     * @retrun /multitype:array
     * @author li 2023-10-11 上午 11:31:42
     * |---------------------------------------------------------------------------------
     */
    public static function getSmsType($type=false){
        // 结算方式1.现金2.支付宝 3微信 4银行卡5会员卡
        $data = [['type'=>1,'name'=>'充值'],['type'=>2,'name'=>'节日'],['type'=>3,'name'=>'生日'],['type'=>4,'name'=>'业务']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }

    // 重发
    public static function resend($user_info,$request) {
        $list_data = DB::table('sms_log')
            ->where('smlo_id', $request['smlo_id'])
            ->first();
        if ($list_data) {
            if ($list_data->smlo_msg_type == 1) {
                return ['code'=>500, 'msg'=>'充值类型不能重发', 'data'=>''];
            }
            // 2.给相应的客户发送短信
            $phone = $list_data->smlo_mem_phone;
            $message = $list_data->smlo_content;
            if (preg_match("/^1[3456789]\d{9}$/", $phone)) {
                $find_shop_data = DB::table('shop')
                    ->where('shop_id', $user_info->adm_shop_id)
                    ->first();
                if ($find_shop_data->shop_message_num < $list_data->smlo_num) {
                    return ['code'=>500, 'msg'=>'短信余额不足，请充值', 'data'=>''];
                }
                $use_count = ceil(mb_strlen($message) / 67) ;
                $msg_remind_log = DB::table('msg_remind_log')
                    ->where('mrlo_shop_id', $user_info->adm_shop_id)
                    ->where('mrlo_state', 2)
                    ->first();
                if ($msg_remind_log) {//已提醒过
                    if ($find_shop_data->shop_message_num > $find_shop_data->shop_msg_remind) {
                        $update_remind['mrlo_state'] = 1;
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $user_info->adm_shop_id)
                            ->where('mrlo_state', 2)
                            ->update($update_remind);
                    }
                }
                
                $msg_remind_log = DB::table('msg_remind_log')
                    ->where('mrlo_shop_id', $user_info->adm_shop_id)
                    ->where('mrlo_state', 2)
                    ->first();

                if (($find_shop_data->shop_message_num-1) <= $find_shop_data->shop_msg_remind && empty($msg_remind_log) && $find_shop_data->shop_msg_adm_id) {
                    $adm_data = DB::table('admin')->where('adm_id', $find_shop_data->shop_msg_adm_id)->first();
                    // $wechat_msg['pushtype'] = 5; //短信预警
                    // $wechat_msg['adm_id'] = $find_shop_data->shop_msg_adm_id; //推送人
                    // $wechat_msg['user_data'] = $adm_data->adm_name; //姓名
                    // $wechat_msg['tittle'] = '剩余短信不足'.$find_shop_data->shop_msg_remind.'条，请及时充值'; //提醒消息
                    // $wechat_msg['remark'] = '短信不足预警';
                    // $CashierDesk = new CashierDesk;
                    // $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
                    $remind_phone = $adm_data->adm_phone;
                    $remind_content = '【半径美装】 您的门店短信余额不足'.$find_shop_data->shop_msg_remind.'条，请及时充值';
                    $remind_send_res = sendSmsCode($remind_phone, $remind_content);
                    if ($remind_send_res > 0) {
                        $send_state = 1;
                        $add_remind['mrlo_shop_id'] = $user_info->adm_shop_id;
                        $add_remind['mrlo_state'] = 2;//未充值，
                        $add_remind['mrlo_adm_id'] = $find_shop_data->shop_msg_adm_id;
                        $add_remind['mrlo_num'] = $find_shop_data->shop_msg_remind;
                        $add_remind['mrlo_create_time'] = date('Y-m-d H:i:s');
                        $add_remind['mrlo_create_id'] = $user_info->adm_id;
                        $reming_res = DB::table('msg_remind_log')->insertGetId($add_remind);
                    } else {
                        $send_state = 2;
                    }
                    // 短信模块日志
                    $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                    $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                    $seme_data['seme_wor_id'] = 0; //订单id
                    $seme_data['seme_name'] = '短信不足预警'; //模板名称
                    $seme_data['seme_phone'] = $remind_phone; //手机号
                    $seme_data['seme_content'] = $remind_content; //内容
                    $seme_data['seme_row'] = 1; //条数
                    $seme_data['seme_status_code'] = $remind_send_res; //短信状态码
                    $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                    $seme_data['seme_ip'] = $request['ip']; //ip地址
                    $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                    $seme_id = DB::table('send_message')->insert($seme_data);
                }
                $send_res = sendSmsCode($phone, $message);
                if ($send_res > 0) {//成功
                    $send_state = 1;
                    $add_log['smlo_state'] = $send_state;
                    $add_log_res = DB::table('sms_log')
                        ->where('smlo_id', $request['smlo_id'])
                        ->update($add_log);
                    $update_shop = DB::table('shop')
                        ->where('shop_id', $user_info->adm_shop_id)
                        ->update(['shop_message_num'=>$find_shop_data->shop_message_num - $list_data->smlo_num]);

                    $up_data['message_status']  = 1;
                    $up_data['message_count']  = $use_count;
                    $up_data['message_send_time'] = date('Y-m-d H:i:s');//发送时间
                    $mem_data_m = DB::table('festival_message')->where('message_smlo_id', $add_log_res)
                        ->update($up_data);
                    return ['code'=>200, 'msg'=>'重发成功', 'data'=>''];
                } else {
                    $send_state = 2;
                    return ['code'=>500, 'msg'=>'重发失败', 'data'=>''];
                }
                
            }
        }
    }

    /**
     * 短信预警设置
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-17
     * @param  boolean          $type [description]
     * @return [type]                 [description]
     */
    public static function msgSet($user_info, $request){
        $update_data['shop_msg_remind'] = $request['shop_msg_remind'];
        $update_data['shop_msg_adm_id'] = $request['shop_msg_adm_id'];
        $update_data['shop_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->update($update_data);
        $msg_remind_log = DB::table('msg_remind_log')
            ->where('mrlo_shop_id', $user_info->adm_shop_id)
            ->where('mrlo_state', 2)
            ->select('mrlo_num')
            ->first();
        if ($msg_remind_log) {
            if ($request['shop_msg_remind'] < $msg_remind_log->mrlo_num) {
                $msg_remind_log = DB::table('msg_remind_log')
                    ->where('mrlo_shop_id', $user_info->adm_shop_id)
                    ->where('mrlo_state', 2)
                    ->update(['mrlo_state'=>1]);
            }
        }
        if ($res) {
            return ['code'=>200, 'msg'=>'设置成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'设置失败', 'data'=>''];
        }
    }

    /**
     * 新增banner
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-23
     * @param  boolean          $type [description]
     * @return [type]                 [description]
     */
    public static function addBanner($user_info, $request){
        $add_data['shba_shop_id'] = $user_info->adm_shop_id;
        $add_data['shba_pait_id'] = $request['shba_pait_id'];
        $add_data['shba_name'] = $request['shba_name'];
        $add_data['shba_show'] = $request['shba_show'];
        $add_data['shba_pic'] = $request['shba_pic'];
        $add_data['shba_sord'] = $request['shba_sord'];
        if ($request['shba_id']) {
            $add_data['shba_update_id'] = $user_info->adm_id;
            $add_data['shba_update_time'] = date('Y-m-d H:i:s');
            $res = DB::table('shop_banner')->where('shba_id', $request['shba_id'])->update($add_data);
        } else {
            $add_data['shba_create_id'] = $user_info->adm_id;
            $add_data['shba_create_time'] = date('Y-m-d H:i:s');
            $res = DB::table('shop_banner')->insert($add_data);
        }
        if ($res) {
            return ['code'=>200, 'msg'=>'操作成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'操作失败', 'data'=>''];
        }
    }

    /**
     * banner
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-23
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function banner($user_info, $request) {
        $list_data = DB::table('shop_banner')
            ->leftJoin('package_items', 'pait_id', '=', 'shba_pait_id')
            ->where('shba_shop_id', $user_info->adm_shop_id)
            ->select('shop_banner.*', 'pait_name')
            ->get()->toArray();
        return ['code'=>200, 'msg'=>'success', 'data'=>$list_data];
    }

    /**
     * 删除banner
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-23
     * @param  boolean          $type [description]
     * @return [type]                 [description]
     */
    public static function delBanner($user_info, $request){
        $res = DB::table('shop_banner')->where('shba_id', $request['shba_id'])->delete();
        if ($res) {
            return ['code'=>200, 'msg'=>'删除成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'删除失败', 'data'=>''];
        }
    }

    /**
     * 发送短信设置
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-24
     * @param  boolean          $type [description]
     * @return [type]                 [description]
     */
    public static function msgConfig($user_info, $request){
        $add_data['msco_shop_id'] = $user_info->adm_shop_id;
        $add_data['msco_is_send'] = $request['msco_is_send'];
        $add_data['msco_send_detail'] = $request['msco_send_detail'];
        $add_data['msco_update_id'] = $user_info->adm_id;
        $add_data['msco_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('msg_config')
            ->where('msco_shop_id', $user_info->adm_shop_id)
            ->first();
        if ($res) {
            $add_res = DB::table('msg_config')->where('msco_id', $res->msco_id)->update($add_data);
        } else {
            $add_res = DB::table('msg_config')->insert($add_data);
        }
        if ($add_res) {
            return ['code'=>200, 'msg'=>'设置成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'设置失败', 'data'=>''];
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取结算方式名称
     * @param string $type 请求类型
     * @retrun /multitype:array
     * @author li 2023-10-11 上午 11:31:42
     * |---------------------------------------------------------------------------------
     */
    public static function getMsgCon($type=false){
        $data = [['type'=>1,'name'=>'开单短信'],['type'=>2,'name'=>'使用会员卡'],['type'=>3,'name'=>'工单变更'],['type'=>4,'name'=>'验车'],['type'=>5,'name'=>'会员登录验证码'],['type'=>6,'name'=>'技师登录验证码']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }
    
    /**|---------------------------------------------------------------------------------
     * @name 获取门店信息
     * @param string $key 查询条件
     * @param string $value 查询内同
     * @retrun  /multitype:array
     * @author dou 2023/12/6 17:36
     * |---------------------------------------------------------------------------------
    */
    public static function getShopData ( $key , $value , $select = [] , $type = 'get' ){
        $db = Db::table('shop');
        if($type == 'first') {
            if (count($select) == 1) {
                $type = 'value';
            }
        }
        $list = CommonService::getMysqlData($db, [$key=>$value],$select,[],$type);
        return $list;
    }

    /**
     * 分店员工列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-06
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function shopAdmin($user_info,$request, $show_count = 10) {
        $find_shop = DB::table('bind_shop')
            ->where('bish_fshop_id', $user_info->adm_shop_id)
            ->where('bish_lshop_id', $request['shop_id'])
            ->first();
        if (empty($find_shop)) {
            return ['code'=>500, 'msg'=>'未查询到分店信息', 'data'=>[]];
        }
        $list_data = DB::table('admin as a')
            ->leftJoin('admin_shop_role as asr', 'asr.adm_id','=','a.adm_id')
            ->leftJoin('role', 'rol_id', '=', 'asr.role_id')
            ->where('shop_id', $request['shop_id'])
            ->where('create_source', 1)
            ->select('asr.adm_id', 'adm_name', 'adm_phone', 'adm_account', 'adm_role', 'rol_name', 'asr.adm_state')
            ->paginate($show_count);
        $list_items = $list_data->items();
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        //获取top按钮
        $sea_button_data = 'addAdmin';
        $sea_button_data = CommonService::getTopButton('',$sea_button_data,$list_button);
        if ($list_items) {
            $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['pages']['total'] = $list_data->total();               //总数据个数
            $data['pages']['current_number'] = $show_count;        //一页显示多少个
            foreach ($list_items as $key => $value) {
                if ($list_button) {
                    foreach ($list_button as $key_b => $value_b) {
                        if ($value_b['pri_operate_method'] == 'start' && $value->adm_state == 2) {//状态1在职2离职
                            $list_items[$key]->list_button_one[] = $value_b;
                        }
                        if ($value_b['pri_operate_method'] == 'stop' && $value->adm_state == 1) {//离职
                            $list_items[$key]->list_button_one[] = $value_b;
                        }
                    }
                }
            }
            $data['list'] = $list_items;                        //返回数据
            return ['code'=>200, 'msg'=>'success', 'data'=>$data,'top_button'=>$sea_button_data];
        } else {
            return ['code'=>500, 'msg'=>'暂无数据', 'data'=>[],'top_button'=>$sea_button_data];
        }
    }

    /**
     * 分店新增员工
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-11
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     */
    public static function addShopAdm($user_info, $request) {
        //判断手机号是否在别的门店创建过
        $adminInfo = DB::table('admin')
            ->where('adm_phone', $request['adm_phone'])
            ->first();
        if(!empty($adminInfo)) {
            //创建过
            $admId = $adminInfo->adm_id;
            $shopCid = $user_info->adm_cid;
            $superiorShopId = $request['shop_id'];
            $shopId = $request['shop_id'];
            $roleId = $request['adm_role'];
            $phone = $adminInfo->adm_phone;
            $loginShop = 2;
        }else{
            if (empty($request['adm_password'])) {
                return ['code'=>500, 'msg'=>'请填写密码', 'data'=>''];
            }
            //账号表新增一个账号数据，账号类型为员工
            $admin_add_data = [
                'adm_cid' => $user_info->adm_cid, //所属企业/品牌方id
                'adm_shop_id' =>  $request['shop_id'], //门店id
                'adm_superior_shop_id' =>  $request['shop_id'], //总店id
                'adm_leave' => 2, //级别1店长2普通员工3技师4业务员5技师和业务员
                'adm_phone' => $request['adm_phone'], //手机号
                'adm_account' => 'os' . time() . rand(100, 999), //用户名（登录账号）
                'adm_password' => md5($request['adm_password'] . 'faster123456'), //登录密码
                'adm_name' => $request['adm_name'], //姓名名称
                'adm_role' => $request['adm_role'], //角色id
                'adm_creator_id' =>  $user_info->adm_id, //操作人id
                'adm_role_applet' =>  0, //小程序角色id
            ];
            $admId =  DB::table('admin')->insertGetid($admin_add_data);
            $shopCid = $user_info->adm_cid;
            $superiorShopId = $request['shop_id'];
            $shopId = $request['shop_id'];
            $roleId = $request['adm_role'];
            $phone = $request['adm_phone'];
            $loginShop = 1;
        }

        //添加账号门店权限关系
        $insertAdminShopRoleData = [
            'adm_id' => $admId,
            'shop_cid' => $shopCid,
            'superior_shop_id' => $superiorShopId,
            'shop_id' => $shopId,
            'role_id' =>  $roleId,
            'adm_shop_leave' => 2,
            'phone' => $phone,
            'login_shop' => $loginShop,
            'create_time' => date("Y-m-d H:i:s", time()),
            'update_time' => date("Y-m-d H:i:s", time()),
        ];
        $insertAdminShopRoleDataRes = DB::table('admin_shop_role')->insert($insertAdminShopRoleData);

        //门店表，对应门店员工人数增加
        $shop_res = DB::table('shop')
            ->where('shop_id', $request['shop_id'])
            ->increment('shop_staff_number');
        if ($insertAdminShopRoleDataRes && $shop_res) {
            return ['code'=>200, 'msg'=>'添加成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'添加失败', 'data'=>''];
        }
    }

    /**
     * 编辑门店
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-11
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function editShopRole($user_info, $request) {
        $find_role = DB::table('role')
            ->where('rol_shop_id', $request['shop_id'])
            ->select('rol_privilege_multiple', 'rol_id', 'rol_type')
            ->get()->toArray();
        $role_pc = explode(',', $request['role_pc']);
        $role_applet = explode(',', $request['role_applet']);
        if ($find_role) {
            $data['pc'] = implode(',',$role_pc);
            $data['applet'] = implode(',',$role_applet);
            $new_data = json_encode($data, true);
            foreach ($find_role as $key => $value) {
                if ($value->rol_type == 1) {//店长
                    $updata_res = DB::table('role')
                        ->where('rol_id', $value->rol_id)
                        ->update(['rol_privilege_multiple'=>$new_data,'rol_update_time'=>date('Y-m-d H:i:s')]);
                } else {
                    $rol_privilege_multiple = json_decode($value->rol_privilege_multiple, true);

                    $rol_pc = explode(',', $rol_privilege_multiple['pc']);
                    $rol_applet = explode(',', $rol_privilege_multiple['applet']);
                    $new_rol_pc = array_intersect($role_pc,$rol_pc);
                    $new_rol_applet = array_intersect($role_applet,$rol_applet);
                    $json_data['pc'] = implode(',',$new_rol_pc);
                    $json_data['applet'] = implode(',',$new_rol_applet);
                    $update_data['rol_privilege_multiple'] = json_encode($json_data, true);
                    $update_data['rol_update_time'] = date('Y-m-d H:i:s');
                    $updata_res = DB::table('role')
                        ->where('rol_id', $value->rol_id)
                        ->update($update_data);
                }
            }
        }
        return ['code'=>200, 'msg'=>'修改权限成功', 'data'=>''];
    }

    /**
     * 购买空间
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-13
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     */
    public static function addSpaceOrder ($user_info, $request) {
        $shop_order['shor_number'] = 'S'.time().rand(10000,99999);
        $shop_order['shor_state'] = 1;
        $shop_order['shor_create_time'] = date('Y-m-d H:i:s'); //时间
        $shop_order['shor_create_id'] = $user_info->adm_id;
        $shop_order['shor_create_name'] = $user_info->adm_name;
        $shop_order['shor_shop_id'] = $user_info->adm_shop_id;
        
        $shop_order['type'] = 4;//1购买2升级3短信充值4空间购买
        $shop_order['shor_goo_id'] = $request['spco_id'];//空间id
        $shop_order['shor_shpr_id'] = $request['spco_id'];//套餐价格id
        $shop_order['shor_goo_num'] = $request['goo_num'];
        $find_shop = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->first();
        $shop_space_price=config('apimesssage.shop_space_price');
        $day_num =round((strtotime($find_shop->shop_opening_end_time) - time())/(24*60*60));
        $ord_amount = round($request['goo_num']*$shop_space_price*100/366*$day_num);
        if ($ord_amount<1) {
            return ['code'=>500, 'msg'=>'金额错误', 'data'=>'付款金额错误'];
        }
        $shop_order['shor_order_amount'] = $ord_amount;//订单总金额
        $shop_order['shor_goo_name'] = '购买空间'.$request['goo_num'].'G';
        
        $shop_order['shor_type'] = 4;//1购买2升级

        $shop_order['shor_goo_price'] = $shop_space_price;//商品/套餐金额
        if (isset($request['shop_id'])) {
            $shop_order['shor_get_shop_id'] = $request['shop_id'];//充值到哪个门店
            $shop_store_name = DB::table('shop')
                ->where('shop_id', $request['shop_id'])
                ->value('shop_store_name');
            $shop_order['shor_remark'] = '给分店：'. $shop_store_name.'购买空间'.$request['goo_num'].'G';//充值到哪个门店
        } else {
            $shop_order['shor_get_shop_id'] = $user_info->adm_shop_id;//充值到哪个门店
        }
        $shop_order['shor_pay_amount'] = $ord_amount;//需要付款的实际金额
        $shop_order['shor_shop_end_time'] = DB::table('shop')->where('shop_id', $user_info->adm_shop_id)->value('shop_opening_end_time');//需要付款的实际金额
        if (isset($request['inv_code']) && $request['inv_code']) {
            $find_shic_data = DB::table('shop_invitate_code_config')
                ->where('shic_code', $request['inv_code'])
                ->first();
            if ($find_shic_data) {
                if ($find_shic_data->shic_code_type == 2) {//购买过版本 不能使用版本类型
                    return ['code'=>500, 'msg'=>'此邀请码类型只能用于购买版本', 'data'=>''];
                }
                if ($find_shic_data->shic_state != 1) {
                    return ['code'=>500, 'msg'=>'此邀请码已失效', 'data'=>''];
                }
                if ($find_shic_data->shic_use_num >= $find_shic_data->shic_num) {
                    return ['code'=>500, 'msg'=>'此邀请码数量已超出限制', 'data'=>''];
                }
                if ($find_shic_data->shic_end_date < date('Y-m-d H:i:s')) {
                    return ['code'=>500, 'msg'=>'此邀请码过期', 'data'=>''];
                }
            }
            $update_shic_data['shic_use_num'] = $find_shic_data->shic_use_num + 1;
            if ($update_shic_data['shic_use_num'] >= $find_shic_data->shic_num) {
                $update_shic_data['shic_state'] = 2;
            }
            $update_shic_res = DB::table('shop_invitate_code_config')
                ->where('shic_id', $find_shic_data->shic_id)
                ->update($update_shic_data);
            $shop_order['shor_pay_amount'] = $shop_order['shor_pay_amount'] - $find_shic_data->shic_discount_price;
            if ($shop_order['shor_pay_amount'] < 0) {
                $shop_order['shor_pay_amount'] = 0;
            }
            $shop_order['shor_discount_amount'] = $find_shic_data->shic_discount_price;
            $shop_order['shor_inv_code'] = $find_shic_data->shic_code;
        }
        if($shop_order['shor_pay_amount'] < 0){
            return ['code'=>500, 'msg'=>'付款金额错误', 'data'=>'付款金额错误'];
        }

        $add_shop_order_res = DB::table('shop_order')->insertGetid($shop_order);
        $data['shor_id'] = $add_shop_order_res;
        $data['shor_number'] = $shop_order['shor_number'];
        $data['shor_pay_amount'] = $shop_order['shor_pay_amount'];
        $data['day_num'] = $day_num;
        $data['shop_space_price'] = $shop_space_price;
        if ($shop_order['shor_pay_amount'] == 0) {//优惠后不用付款的
            $find_order = DB::table('shop_order')
                ->leftJoin('shop', 'shop_id', '=', 'shor_shop_id')
                ->where('shor_id', $add_shop_order_res)
                ->first();
            
            if ($find_order->type == 3) {//短信充值
                $update_order = DB::table('shop_order')
                    ->where('shor_number', $find_order->shor_number)
                    ->update(['shor_pay_state'=>2,'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_other_num'=>'','shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
                // 修改店铺短信数量
                $find_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->first();
                $update_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->update(['shop_message_num'=>($find_shop->shop_message_num + $find_order->shor_goo_num)]);
                $update_log = DB::table('sms_log')
                    ->where('smlo_ord_num', $find_order->shor_number)
                    ->update(['smlo_state'=>1]);
                $msg_remind_log = DB::table('msg_remind_log')
                    ->where('mrlo_shop_id', $find_order->shor_shop_id)
                    ->where('mrlo_state', 2)
                    ->first();
                if ($msg_remind_log) {//已提醒过
                    if (($find_shop->shop_message_num + $find_order->shor_goo_num) > $find_shop->shop_msg_remind) {
                        $update_remind['mrlo_state'] = 1;
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $find_order->shor_shop_id)
                            ->where('mrlo_state', 2)
                            ->update($update_remind);
                    }
                }
                return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
            }

            if ($find_order->type == 4) {//空间购买
                $update_order = DB::table('shop_order')
                    ->where('shor_number', $find_order->shor_number)
                    ->update(['shor_pay_state'=>2,'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_other_num'=>'','shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
                // 修改店铺空间数量
                $find_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_get_shop_id)
                    ->first();
                $update_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_get_shop_id)
                    ->update(['shop_toll_space'=>($find_shop->shop_toll_space + $find_order->shor_goo_num)]);
                return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
            }

            if ($find_order->type == 5) {//分店购买
                $update_order = DB::table('shop_order')
                    ->where('shor_number', $find_order->shor_number)
                    ->update(['shor_pay_state'=>2,'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_other_num'=>'','shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
                // 修改店铺空间数量
                $find_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->first();
                $update_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->update(['shop_toll_shop'=>($find_shop->shop_toll_shop + $find_order->shor_goo_num)]);
                return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
            }
            if ($find_order->type == 1 || $find_order->type == 2) {//升级赠送空间/短信
                if ($find_order->shor_goo_id == 1) {
                    $shop_free_space = 3;
                    $update_res = DB::table('service_project')
                        ->where('sepr_shop_id', $find_order->shor_shop_id)
                        ->update(['sepr_work_type'=>2]);
                }
                if ($find_order->shor_goo_id == 2) {
                    $shop_free_space = 5;
                }
                if ($find_order->shor_goo_id == 3) {
                    $shop_free_space = 10;
                    $adm_update = DB::table('admin_shop_role')
                        ->where('shop_id', $find_order->shor_shop_id)
                        ->where('adm_shop_leave', 1)
                        ->update(['login_bind_shop'=>1]);
                }
                $shop_update['shop_free_space'] = $shop_free_space;
            }
            if (($find_order->type == 1 && $find_order->shop_shve_id != $find_order->shor_goo_id)|| $find_order->type == 2) {//初次购买此版本或者升级版本送短信
                if ($find_order->shor_goo_id == 1) {
                    $shop_message_num = 200;
                } elseif ($find_order->shor_goo_id == 2) {
                    $shop_message_num = 300;
                } elseif ($find_order->shor_goo_id == 3) {
                    $shop_message_num = 500;
                }
                if ($find_order->shop_shve_id == 1) {
                    $old_message_num = 200;
                } elseif ($find_order->shop_shve_id == 2) {
                    $old_message_num = 300;
                } elseif ($find_order->shop_shve_id == 3) {
                    $old_message_num = 500;
                } else {
                    $old_message_num = 20;
                }
                $shop_update['shop_message_num'] = $find_order->shop_message_num + $shop_message_num - $old_message_num;
            }
            
            $shop_update['shop_state'] = 1;
            $shop_update['shop_shve_id'] = $find_order->shor_goo_id;
            $shop_update['shop_shpr_id'] = $find_order->shor_shpr_id;
            $shop_update['shop_buy'] = 1;
            $shop_update['shop_opening_type'] = 2;
            $shop_update['shop_update_time'] = date('Y-m-d H:i:s');
            if ($find_order->shop_opening_start_time == '0000-00-00 00:00:00') {
                $shop_update['shop_opening_start_time'] = date('Y-m-d H:i:s');
            }
            $find_shop_versions = DB::table('shop_price')
                ->where('shpr_id', $find_order->shor_shpr_id)
                ->first();
            if($find_order->type ==1){//1购买2升级
                $find_shop_level = DB::table('shop_price')
                    ->where('shpr_id', $find_order->shor_shpr_id)
                    ->select('shpr_price', 'shpr_month', 'shpr_unit')
                    ->first();
                if ($find_shop_level->shpr_unit == '天') {
                    $day_string = '+'.$find_shop_level->shpr_month.' day';
                } elseif ($find_shop_level->shpr_unit == '周') {
                    $day_string = '+'.$find_shop_level->shpr_month.' week';
                } elseif ($find_shop_level->shpr_unit == '月') {
                    $day_string = '+'.$find_shop_level->shpr_month.' month';
                } elseif ($find_shop_level->shpr_unit == '年') {
                    $day_string = '+'.$find_shop_level->shpr_month.' year';
                }
                if ($find_order->shop_opening_end_time == '0000-00-00 00:00:00') {
                    $shop_update['shop_opening_end_time'] = date('Y-m-d H:i:s', strtotime($day_string));
                } else {
                    $shop_opening_end_time = strtotime($day_string,strtotime($find_order->shop_opening_end_time));
                    $shop_update['shop_opening_end_time'] = date('Y-m-d H:i:s', $shop_opening_end_time);
                }
                $find_bind_shop = DB::table('bind_shop')
                    ->leftJoin('shop', 'shop_id', '=', 'bish_lshop_id')
                    ->where('bish_fshop_id', $find_order->shor_shop_id)
                    ->where('bish_state', 1)
                    ->get()->toArray();
                foreach ($find_bind_shop as $key => $value) {
                    $update_bind['shop_opening_type'] = $shop_update['shop_opening_type'];
                    $update_bind['shop_opening_end_time'] = $shop_update['shop_opening_end_time'];
                    $update_bind['shop_update_time'] = date('Y-m-d H:i:s');
                    $update_bind_res = DB::table('shop')
                        ->where('shop_id', $value->bish_lshop_id)
                        ->update($update_bind);
                }
            }

            $update_order = DB::table('shop_order')
                ->where('shor_number', $find_order->shor_number)
                ->update(['shor_pay_state'=>2, 'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
            $find_shop = DB::table('shop')
                ->where('shop_id', $find_order->shor_shop_id)
                ->update($shop_update);
            //修改店铺权限
            $find_role = DB::table('role')
                ->where('rol_shop_id', $find_order->shor_shop_id)
                ->get()->toArray();
                
            $find_pc_pri = DB::table('privileges')
                ->where('pri_shop_version', 'like', '%'.$find_order->shor_goo_id.'%')
                ->select('pri_id')
                ->get()->toArray();

            $pc_pri = array_column($find_pc_pri, 'pri_id');

            $find_applet_pri = DB::table('privileges_technician_applet')
                ->where('pri_shop_version', 'like', '%'.$find_order->shor_goo_id.'%')
                ->select('pri_id')
                ->get()->toArray();

            $applet_pri = array_column($find_applet_pri, 'pri_id');
            $data['pc'] = implode(',',$pc_pri);
            $data['applet'] = implode(',',$applet_pri);
            $new_data = json_encode($data, true);
            foreach ($find_role as $key => $value) {
                if ($value->rol_type == 1) {//店长
                    $updata_res = DB::table('role')
                        ->where('rol_id', $value->rol_id)
                        ->update(['rol_privilege_multiple'=>$new_data,'rol_update_time'=>date('Y-m-d H:i:s')]);
                } else {
                    $rol_privilege_multiple = json_decode($value->rol_privilege_multiple, true);

                    $rol_pc = explode(',', $rol_privilege_multiple['pc']);
                    $rol_applet = explode(',', $rol_privilege_multiple['applet']);
                    $new_rol_pc = array_intersect($pc_pri,$rol_pc);
                    $new_rol_applet = array_intersect($applet_pri,$rol_applet);
                    $json_data['pc'] = implode(',',$new_rol_pc);
                    $json_data['applet'] = implode(',',$new_rol_applet);
                    $update_data['rol_privilege_multiple'] = json_encode($json_data, true);
                    $update_data['rol_update_time'] = date('Y-m-d H:i:s');
                    $updata_res = DB::table('role')
                        ->where('rol_id', $value->rol_id)
                        ->update($update_data);
                }
            }
        }
        
        if ($add_shop_order_res) {
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取订单类型
     * @param string $type 请求类型
     * @retrun /multitype:array
     * @author li 2023-07-18 031 上午 11:31:42
     * |---------------------------------------------------------------------------------
     */
    public static function getOrderType($type=false){
        $data = [['type'=>0,'name'=>'全部'],['type'=>1,'name'=>'普通订单'],['type'=>2,'name'=>'升级订单'],['type'=>3,'name'=>'短信充值'],['type'=>4,'name'=>'空间购买']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }

    /**
     * 获取空间费用+分店费用
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-14
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function getSpaPrice($user_info, $request){
        if ($request['type'] == 1 || $request['type'] == 3) {
            $find_shop = DB::table('shop')
                ->where('shop_id', $user_info->adm_shop_id)
                ->first();
            $find_level = DB::table('shop_price')
                ->where('shpr_id', $request['shpr_id'])
                ->first();
            $shop_space_price=config('apimesssage.shop_space_price');//每个G单价
            $data['shop_space_price'] = $shop_space_price*100;
            // $data['shpr_month'] = $find_level->shpr_month;
            // $data['shpr_price'] = $find_level->shpr_price;
            $data['shop_toll_space'] = $find_shop->shop_toll_space;
            $data['space_price'] = $find_shop->shop_toll_space * $find_level->shpr_month * $shop_space_price * 100;
            $find_bind_shop = DB::table('bind_shop')
                ->leftJoin('shop', 'shop_id', '=', 'bish_lshop_id')
                ->where('bish_fshop_id', $user_info->adm_shop_id)
                ->where('bish_state', 1)
                ->get()->toArray();//分店
            $space_num = 0;
            foreach ($find_bind_shop as $key => $value) {
                $space_num += $value->shop_toll_space;
            }
            $shop_count = count($find_bind_shop);
            if (($shop_count-$find_shop->shop_free_shop) > 0) {
                $data['bind_num'] = $shop_count-$find_shop->shop_free_shop;
                $data['bind_price'] = $data['bind_num']*config('apimesssage.bind_price')*$find_level->shpr_month*100;
            } else {
                $data['bind_num'] = 0;
                $data['bind_price'] = 0;
            }
            $data['bind_space_num'] = $space_num;
            $data['bind_space_price'] = $space_num*$shop_space_price*100;
        } else {
            $data['space_price'] = 0;
            $data['shop_toll_space'] = 0;
            $data['bind_num'] = 0;
            $data['bind_price'] = 0;
            $data['bind_space_num'] = 0;
            $data['bind_space_price'] = 0;
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    /**
     * 取消订购
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-14
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function cancel($user_info, $request){
        $find_shop = DB::table('shop_order')
            ->where('shor_id', $request['shor_id'])
            ->first();
        if (empty($find_shop)) {
            return ['code'=>500, 'msg'=>'未发现此订单', 'data'=>''];
        }
        if ($find_shop->shor_pay_state == 2) {
            return ['code'=>500, 'msg'=>'已支付 不可取消', 'data'=>''];
        }
        $res = DB::table('shop_order')
            ->where('shor_id', $request['shor_id'])
            ->update(['shor_state'=>4, 'shor_update_time'=>date('Y-m-d H:i:s')]);
        if ($res) {
            return ['code'=>200, 'msg'=>'取消成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'取消失败', 'data'=>''];
        }
    }

    /**
     * 获取分店角色
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-20
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public static function getShopRole($user_info, $request) {
        $find_data = DB::table('bind_shop')
            ->where('bish_id', $request['bish_id'])
            ->where('bish_fshop_id', $user_info->adm_shop_id)
            ->first();
        if (empty($find_data)) {
            return ['code'=>500, 'msg'=>'未发现此分店', 'data'=>''];
        }
        $find_role = DB::table('role')
            ->where('rol_shop_id', $find_data->bish_lshop_id)
            ->where('rol_state', 1)
            ->where('rol_type', '<>',1)
            ->select('rol_shop_id', 'rol_id', 'rol_name', 'rol_type', 'rol_state')
            ->get()->toArray();
        return ['code'=>200, 'msg'=>'success', 'data'=>$find_role]; 
    }

    /**
     * 在职离职
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-20
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public static function editShopAdm($user_info, $request) {
        $find_data = DB::table('bind_shop')
            ->where('bish_id', $request['bish_id'])
            ->where('bish_fshop_id', $user_info->adm_shop_id)
            ->first();
        if (empty($find_data)) {
            return ['code'=>500, 'msg'=>'未发现此分店', 'data'=>''];
        }
        // 编辑账号门店权限关系
        $updateAdminShopRoleData = [
            'adm_state' => $request['adm_state'],
            'update_time' => date('Y-m-d H:i:s', time()),
        ];
        $updateAdminShopRoleDataRes =  DB::table('admin_shop_role')
            ->where('adm_id', $request['adm_id'])
            ->where('shop_id', $find_data->bish_lshop_id)
            ->update($updateAdminShopRoleData);
        if ($request['adm_state'] == 1) {
            $adm_state = '在职';
        } elseif ($request['adm_state'] == 2) {
            $adm_state = '离职';
        }
        return ['code'=>200, 'msg'=>$adm_state.'成功', 'data'=>'']; 
    }

    /**
     * 划拨短信
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-22
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     */
    public static function addMsg($user_info, $request) {
        $find_data = DB::table('bind_shop')
            ->where('bish_id', $request['bish_id'])
            ->where('bish_fshop_id', $user_info->adm_shop_id)
            ->where('bish_lshop_id', $request['bish_lshop_id'])
            ->first();
        if (empty($find_data)) {
            return ['code'=>500, 'msg'=>'未发现此分店', 'data'=>''];
        }
        $find_payer = DB::table('shop')
            ->where('shop_id', $request['payer_shop_id'])
            ->select('shop_message_num', 'shop_store_name')
            ->first();
        $find_payee = DB::table('shop')
            ->where('shop_id', $request['payee_shop_id'])
            ->select('shop_message_num', 'shop_store_name')
            ->first();
        if ($find_payer->shop_message_num < $request['message_num']) {
            return ['code'=>500, 'msg'=>'短信数量不足', 'data'=>''];
        }
        DB::beginTransaction();
        $update_payer = DB::table('shop')
            ->where('shop_id', $request['payer_shop_id'])
            ->update(['shop_message_num'=>($find_payer->shop_message_num - $request['message_num'])]);
        $update_payee = DB::table('shop')
            ->where('shop_id', $request['payee_shop_id'])
            ->update(['shop_message_num'=>($find_payee->shop_message_num + $request['message_num'])]);
        //划拨出短信
        $add_log['smlo_shop_id'] = $request['payer_shop_id'];
        $add_log['smlo_mem_type'] = 1;//1业务人员2会员
        $add_log['smlo_mem_id'] = $user_info->adm_id;
        $add_log['smlo_mem_name'] = $user_info->adm_name;
        $add_log['smlo_mem_phone'] = $user_info->adm_phone;
        $add_log['smlo_type'] = 2;
        $add_log['smlo_create_time'] = date('Y-m-d H:i:s');
        $add_log['smlo_state'] = 1;
        $add_log['smlo_msg_type'] = 4;
        $add_log['smlo_num'] = $request['message_num'];
        $add_log['smlo_ord_num'] = '';
        $add_log['smlo_content'] = '划拨到分店'.$find_payee->shop_store_name.$request['message_num'].'条短信';
        $add_payer_res = DB::table('sms_log')->insertGetId($add_log);

        //划拨入短信
        $add_log_payee['smlo_shop_id'] = $request['payee_shop_id'];
        $add_log_payee['smlo_mem_type'] = 1;//1业务人员2会员
        $add_log_payee['smlo_mem_id'] = $user_info->adm_id;
        $add_log_payee['smlo_mem_name'] = $user_info->adm_name;
        $add_log_payee['smlo_mem_phone'] = $user_info->adm_phone;
        $add_log_payee['smlo_type'] = 1;
        $add_log_payee['smlo_create_time'] = date('Y-m-d H:i:s');
        $add_log_payee['smlo_state'] = 1;//是否成功1是2否
        $add_log_payee['smlo_msg_type'] = 4;
        $add_log_payee['smlo_num'] = $request['message_num'];
        $add_log_payee['smlo_ord_num'] = '';
        $add_log_payee['smlo_content'] = '总店'.$find_payer->shop_store_name.'划入'.$request['message_num'].'条短信';
        $add_payee_res = DB::table('sms_log')->insertGetId($add_log_payee);
        if ($update_payer && $update_payee && $add_payer_res && $add_payee_res) {
            DB::commit();
            return ['code'=>200, 'msg'=>'划拨成功', 'data'=>''];
        } else {
            DB::rollBack();
            return ['code'=>500, 'msg'=>'划拨失败', 'data'=>''];
        }
    }

    /**
     * 购买分店
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-13
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     */
    public static function buyShop ($user_info, $request) {
        $shop_order['shor_number'] = 'S'.time().rand(10000,99999);
        $shop_order['shor_state'] = 1;
        $shop_order['shor_create_time'] = date('Y-m-d H:i:s'); //时间
        $shop_order['shor_create_id'] = $user_info->adm_id;
        $shop_order['shor_create_name'] = $user_info->adm_name;
        $shop_order['shor_shop_id'] = $user_info->adm_shop_id;
        
        $shop_order['type'] = 5;//1购买2升级3短信充值4空间购买5购买分店
        $shop_order['shor_goo_id'] = 0;//空间id
        $shop_order['shor_shpr_id'] = 0;//分店价格
        $shop_order['shor_goo_num'] = $request['goo_num'];
        $find_shop = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->first();
        $goo_price=config('apimesssage.bind_price');
        $day_num =round((strtotime($find_shop->shop_opening_end_time) - time())/(24*60*60));
        $ord_amount = round($request['goo_num']*$goo_price/366*100*$day_num);
        if ($ord_amount<1) {
            return ['code'=>500, 'msg'=>'金额错误', 'data'=>'付款金额错误'];
        }
        $shop_order['shor_order_amount'] = $ord_amount;//订单总金额
        $shop_order['shor_goo_name'] = '购买分店'.$request['goo_num'].'个';
        
        $shop_order['shor_type'] = 5;//1购买2升级

        $shop_order['shor_goo_price'] = $goo_price*100;//商品/套餐金额
        
        $shop_order['shor_pay_amount'] = $ord_amount;//需要付款的实际金额
        $shop_order['shor_shop_end_time'] = DB::table('shop')->where('shop_id', $user_info->adm_shop_id)->value('shop_opening_end_time');//需要付款的实际金额
        
        if($shop_order['shor_pay_amount'] < 0){
            return ['code'=>500, 'msg'=>'付款金额错误', 'data'=>'付款金额错误'];
        }
        if (isset($request['inv_code']) && $request['inv_code']) {
            $find_shic_data = DB::table('shop_invitate_code_config')
                ->where('shic_code', $request['inv_code'])
                ->first();
            if ($find_shic_data) {
                if ($find_shop->shop_buy == 1 && $find_shic_data->shic_code_type == 2) {//购买过版本 不能使用版本类型
                    return ['code'=>500, 'msg'=>'此邀请码类型只能用于购买版本', 'data'=>''];
                }
                if ($find_shic_data->shic_state != 1) {
                    return ['code'=>500, 'msg'=>'此邀请码已失效', 'data'=>''];
                }
                if ($find_shic_data->shic_use_num >= $find_shic_data->shic_num) {
                    return ['code'=>500, 'msg'=>'此邀请码数量已超出限制', 'data'=>''];
                }
                if ($find_shic_data->shic_end_date < date('Y-m-d H:i:s')) {
                    return ['code'=>500, 'msg'=>'此邀请码过期', 'data'=>''];
                }
            }
            $update_shic_data['shic_use_num'] = $find_shic_data->shic_use_num + 1;
            if ($update_shic_data['shic_use_num'] >= $find_shic_data->shic_num) {
                $update_shic_data['shic_state'] = 2;
            }
            $update_shic_res = DB::table('shop_invitate_code_config')
                ->where('shic_id', $find_shic_data->shic_id)
                ->update($update_shic_data);
            $shop_order['shor_pay_amount'] = $shop_order['shor_pay_amount'] - $find_shic_data->shic_discount_price;
            if ($shop_order['shor_pay_amount'] < 0) {
                $shop_order['shor_pay_amount'] = 0;
            }
            $shop_order['shor_discount_amount'] = $find_shic_data->shic_discount_price;
            $shop_order['shor_inv_code'] = $find_shic_data->shic_code;
        }

        $add_shop_order_res = DB::table('shop_order')->insertGetid($shop_order);

        $data['shor_id'] = $add_shop_order_res;
        $data['shor_number'] = $shop_order['shor_number'];
        $data['shor_pay_amount'] = $shop_order['shor_pay_amount'];
        $data['day_num'] = $day_num;
        $data['goo_price'] = $shop_order['shor_goo_price'];
        if ($shop_order['shor_pay_amount'] == 0) {//优惠后不用付款的
            $find_order = DB::table('shop_order')
                ->leftJoin('shop', 'shop_id', '=', 'shor_shop_id')
                ->where('shor_id', $add_shop_order_res)
                ->first();
            
            if ($find_order->type == 3) {//短信充值
                $update_order = DB::table('shop_order')
                    ->where('shor_number', $find_order->shor_number)
                    ->update(['shor_pay_state'=>2,'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_other_num'=>'','shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
                // 修改店铺短信数量
                $find_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->first();
                $update_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->update(['shop_message_num'=>($find_shop->shop_message_num + $find_order->shor_goo_num)]);
                $update_log = DB::table('sms_log')
                    ->where('smlo_ord_num', $find_order->shor_number)
                    ->update(['smlo_state'=>1]);
                $msg_remind_log = DB::table('msg_remind_log')
                    ->where('mrlo_shop_id', $find_order->shor_shop_id)
                    ->where('mrlo_state', 2)
                    ->first();
                if ($msg_remind_log) {//已提醒过
                    if (($find_shop->shop_message_num + $find_order->shor_goo_num) > $find_shop->shop_msg_remind) {
                        $update_remind['mrlo_state'] = 1;
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $find_order->shor_shop_id)
                            ->where('mrlo_state', 2)
                            ->update($update_remind);
                    }
                }
                return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
            }

            if ($find_order->type == 4) {//空间购买
                $update_order = DB::table('shop_order')
                    ->where('shor_number', $find_order->shor_number)
                    ->update(['shor_pay_state'=>2,'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_other_num'=>'','shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
                // 修改店铺空间数量
                $find_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_get_shop_id)
                    ->first();
                $update_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_get_shop_id)
                    ->update(['shop_toll_space'=>($find_shop->shop_toll_space + $find_order->shor_goo_num)]);
                return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
            }

            if ($find_order->type == 5) {//分店购买
                $update_order = DB::table('shop_order')
                    ->where('shor_number', $find_order->shor_number)
                    ->update(['shor_pay_state'=>2,'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_other_num'=>'','shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
                // 修改店铺空间数量
                $find_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->first();
                $update_shop = DB::table('shop')
                    ->where('shop_id', $find_order->shor_shop_id)
                    ->update(['shop_toll_shop'=>($find_shop->shop_toll_shop + $find_order->shor_goo_num)]);
                return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
            }
            if ($find_order->type == 1 || $find_order->type == 2) {//升级赠送空间/短信
                if ($find_order->shor_goo_id == 1) {
                    $shop_free_space = 3;
                    $update_res = DB::table('service_project')
                        ->where('sepr_shop_id', $find_order->shor_shop_id)
                        ->update(['sepr_work_type'=>2]);
                }
                if ($find_order->shor_goo_id == 2) {
                    $shop_free_space = 5;
                }
                if ($find_order->shor_goo_id == 3) {
                    $shop_free_space = 10;
                    $adm_update = DB::table('admin_shop_role')
                        ->where('shop_id', $find_order->shor_shop_id)
                        ->where('adm_shop_leave', 1)
                        ->update(['login_bind_shop'=>1]);
                }
                $shop_update['shop_free_space'] = $shop_free_space;
            }
            if (($find_order->type == 1 && $find_order->shop_shve_id != $find_order->shor_goo_id)|| $find_order->type == 2) {//初次购买此版本或者升级版本送短信
                if ($find_order->shor_goo_id == 1) {
                    $shop_message_num = 200;
                } elseif ($find_order->shor_goo_id == 2) {
                    $shop_message_num = 300;
                } elseif ($find_order->shor_goo_id == 3) {
                    $shop_message_num = 500;
                }
                if ($find_order->shop_shve_id == 1) {
                    $old_message_num = 200;
                } elseif ($find_order->shop_shve_id == 2) {
                    $old_message_num = 300;
                } elseif ($find_order->shop_shve_id == 3) {
                    $old_message_num = 500;
                } else {
                    $old_message_num = 20;
                }
                $shop_update['shop_message_num'] = $find_order->shop_message_num + $shop_message_num - $old_message_num;
            }
            
            $shop_update['shop_state'] = 1;
            $shop_update['shop_shve_id'] = $find_order->shor_goo_id;
            $shop_update['shop_shpr_id'] = $find_order->shor_shpr_id;
            $shop_update['shop_buy'] = 1;
            $shop_update['shop_opening_type'] = 2;
            $shop_update['shop_update_time'] = date('Y-m-d H:i:s');
            if ($find_order->shop_opening_start_time == '0000-00-00 00:00:00') {
                $shop_update['shop_opening_start_time'] = date('Y-m-d H:i:s');
            }
            $find_shop_versions = DB::table('shop_price')
                ->where('shpr_id', $find_order->shor_shpr_id)
                ->first();
            if($find_order->type ==1){//1购买2升级
                $find_shop_level = DB::table('shop_price')
                    ->where('shpr_id', $find_order->shor_shpr_id)
                    ->select('shpr_price', 'shpr_month', 'shpr_unit')
                    ->first();
                if ($find_shop_level->shpr_unit == '天') {
                    $day_string = '+'.$find_shop_level->shpr_month.' day';
                } elseif ($find_shop_level->shpr_unit == '周') {
                    $day_string = '+'.$find_shop_level->shpr_month.' week';
                } elseif ($find_shop_level->shpr_unit == '月') {
                    $day_string = '+'.$find_shop_level->shpr_month.' month';
                } elseif ($find_shop_level->shpr_unit == '年') {
                    $day_string = '+'.$find_shop_level->shpr_month.' year';
                }
                if ($find_order->shop_opening_end_time == '0000-00-00 00:00:00') {
                    $shop_update['shop_opening_end_time'] = date('Y-m-d H:i:s', strtotime($day_string));
                } else {
                    $shop_opening_end_time = strtotime($day_string,strtotime($find_order->shop_opening_end_time));
                    $shop_update['shop_opening_end_time'] = date('Y-m-d H:i:s', $shop_opening_end_time);
                }
                $find_bind_shop = DB::table('bind_shop')
                    ->leftJoin('shop', 'shop_id', '=', 'bish_lshop_id')
                    ->where('bish_fshop_id', $find_order->shor_shop_id)
                    ->where('bish_state', 1)
                    ->get()->toArray();
                foreach ($find_bind_shop as $key => $value) {
                    $update_bind['shop_opening_type'] = $shop_update['shop_opening_type'];
                    $update_bind['shop_opening_end_time'] = $shop_update['shop_opening_end_time'];
                    $update_bind['shop_update_time'] = date('Y-m-d H:i:s');
                    $update_bind_res = DB::table('shop')
                        ->where('shop_id', $value->bish_lshop_id)
                        ->update($update_bind);
                }
            }

            $update_order = DB::table('shop_order')
                ->where('shor_number', $find_order->shor_number)
                ->update(['shor_pay_state'=>2, 'shor_state'=>3,'shor_paid_money'=>$find_order->shor_pay_amount,'shor_pay_way'=>1,'shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
            $find_shop = DB::table('shop')
                ->where('shop_id', $find_order->shor_shop_id)
                ->update($shop_update);
            //修改店铺权限
            $find_role = DB::table('role')
                ->where('rol_shop_id', $find_order->shor_shop_id)
                ->get()->toArray();
                
            $find_pc_pri = DB::table('privileges')
                ->where('pri_shop_version', 'like', '%'.$find_order->shor_goo_id.'%')
                ->select('pri_id')
                ->get()->toArray();

            $pc_pri = array_column($find_pc_pri, 'pri_id');

            $find_applet_pri = DB::table('privileges_technician_applet')
                ->where('pri_shop_version', 'like', '%'.$find_order->shor_goo_id.'%')
                ->select('pri_id')
                ->get()->toArray();

            $applet_pri = array_column($find_applet_pri, 'pri_id');
            $data['pc'] = implode(',',$pc_pri);
            $data['applet'] = implode(',',$applet_pri);
            $new_data = json_encode($data, true);
            foreach ($find_role as $key => $value) {
                if ($value->rol_type == 1) {//店长
                    $updata_res = DB::table('role')
                        ->where('rol_id', $value->rol_id)
                        ->update(['rol_privilege_multiple'=>$new_data,'rol_update_time'=>date('Y-m-d H:i:s')]);
                } else {
                    $rol_privilege_multiple = json_decode($value->rol_privilege_multiple, true);

                    $rol_pc = explode(',', $rol_privilege_multiple['pc']);
                    $rol_applet = explode(',', $rol_privilege_multiple['applet']);
                    $new_rol_pc = array_intersect($pc_pri,$rol_pc);
                    $new_rol_applet = array_intersect($applet_pri,$rol_applet);
                    $json_data['pc'] = implode(',',$new_rol_pc);
                    $json_data['applet'] = implode(',',$new_rol_applet);
                    $update_data['rol_privilege_multiple'] = json_encode($json_data, true);
                    $update_data['rol_update_time'] = date('Y-m-d H:i:s');
                    $updata_res = DB::table('role')
                        ->where('rol_id', $value->rol_id)
                        ->update($update_data);
                }
            }
        }
        if ($add_shop_order_res) {
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
        }
    }

    /**
     * 意见反馈列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-01
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function feedBack($user_info, $request, $show_count = 10) {
        $list_data = DB::table('feedback as f')
            ->leftJoin('admin as a', 'adm_id', '=', 'fee_create_id')
            ->leftJoin('shop as s', 'shop_id', '=', 'fee_shop_id')
            ->where(function ($query) use ($request) {
                if (!empty($request['shop_store_name'])) {
                    $query->where('shop_store_name', 'like', '%'. $request['shop_store_name'].'%');
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['adm_phone'])) {
                    $query->where('adm_phone', 'like', '%'. $request['adm_phone'].'%');
                }
            })
            ->select('f.*', 's.shop_store_name', 'adm_phone')
            ->orderBy('fee_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['pages']['total'] = $list_data->total();               //总数据个数
            $data['pages']['current_number'] = $show_count;        //一页显示多少个
            $data['list'] = $list_items;                        //返回数据
        } else {
            $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['pages']['total'] = $list_data->total();               //总数据个数
            $data['pages']['current_number'] = $show_count;        //一页显示多少个
            $data['list'] = [];
        }
        return $data;
    }

    /**
     * 意见反馈处理
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-01
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public static function confirm($user_info,$request) {
        $update_data['fee_remark'] = $request['fee_remark'];
        $update_data['fee_state'] = 2;
        $update_data['fee_confirm_id'] = $user_info->adm_id;
        $update_data['fee_confirm_name'] = $user_info->adm_name;
        $update_res = DB::table('feedback')->where('fee_id', $request['fee_id'])->update($update_data);
        if ($update_res) {
            return ['code'=>200, 'msg'=>'处理成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'处理失败', 'data'=>''];
        }
    }

    /**
     * 划拨空间
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-22
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     */
    public static function changeSpace($user_info, $request) {
        $find_data = DB::table('bind_shop')
            ->where('bish_id', $request['bish_id'])
            ->first();
        if (empty($find_data)) {
            return ['code'=>500, 'msg'=>'未发现此分店', 'data'=>''];
        }
        $find_payer = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->select('shop_toll_space', 'shop_free_space', 'shop_store_name', 'shop_use_space')
            ->first();
        $find_payee = DB::table('shop')
            ->where('shop_id', $find_data->bish_lshop_id)
            ->select('shop_toll_space', 'shop_free_space', 'shop_store_name', 'shop_use_space')
            ->first();
        if ($find_payer->shop_toll_space < $request['space_num']) {
            return ['code'=>500, 'msg'=>'空间数量不足', 'data'=>''];
        }
        if (($find_payer->shop_toll_space + $find_payer->shop_free_space) < ($request['space_num'] + $find_payer->shop_use_space)) {
            return ['code'=>500, 'msg'=>'空间数量不足', 'data'=>''];
        }
        DB::beginTransaction();
        $update_payer = DB::table('shop')
            ->where('shop_id', $find_data->bish_fshop_id)
            ->update(['shop_toll_space'=>($find_payer->shop_toll_space - $request['space_num'])]);
        $update_payee = DB::table('shop')
            ->where('shop_id', $find_data->bish_lshop_id)
            ->update(['shop_toll_space'=>($find_payee->shop_toll_space + $request['space_num'])]);
        if ($update_payer && $update_payee) {
            DB::commit();
            return ['code'=>200, 'msg'=>'划拨成功', 'data'=>''];
        } else {
            DB::rollBack();
            return ['code'=>500, 'msg'=>'划拨失败', 'data'=>''];
        }
    }

    /**
     * 邀请码列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-06
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function invCodeIndex($user_info,$request, $show_count = 10) {
        $list_data = DB::table('shop_invitate_code_config')
            ->orderBy('shic_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['pages']['total'] = $list_data->total();               //总数据个数
            $data['pages']['current_number'] = $show_count;        //一页显示多少个
            $data['list'] = $list_items;                        //返回数据
        } else {
            $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['pages']['total'] = $list_data->total();               //总数据个数
            $data['pages']['current_number'] = $show_count;        //一页显示多少个
            $data['list'] = [];
        }
        return $data;
    }

    /**
     * 新增视频
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-10
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     */
    public static function addVideo($user_info, $request) {
        $find_data = DB::table('instructional_video')
            ->where('inv_name', $request['inv_name'])
            ->first();
        if ($find_data) {
            return ['code'=>500, 'msg'=>'名称已存在', 'data'=>''];
        }
        $add_data['inv_type'] = $request['inv_type'];
        $add_data['inv_name'] = $request['inv_name'];
        $add_data['inv_url'] = $request['inv_url'];
        $add_data['inv_url_type'] = $request['inv_url_type'];
        $add_data['inv_sort'] = $request['inv_sort'];
        $add_data['inv_create_id'] = $user_info->adm_id;
        $add_data['inv_create_time'] = date('Y-m-d H:i:s');
        $add_data['inv_state'] = $request['inv_state'];
        $add_data['inv_time'] = $request['inv_time'];
        $add_data['inv_description'] = $request['inv_description'];
        $add_res = DB::table('instructional_video')->insertGetId($add_data);
        return ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
    }

    /**
     * 编辑视频
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-10
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     */
    public static function editVideo($user_info, $request) {
        $find_data = DB::table('instructional_video')
            ->where('inv_id', '<>', $request['inv_id'])
            ->where('inv_name', $request['inv_name'])
            ->first();
        if ($find_data) {
            return ['code'=>500, 'msg'=>'名称已存在', 'data'=>''];
        }
        $add_data['inv_type'] = $request['inv_type'];
        $add_data['inv_name'] = $request['inv_name'];
        $add_data['inv_url'] = $request['inv_url'];
        $add_data['inv_url_type'] = $request['inv_url_type'];
        $add_data['inv_sort'] = $request['inv_sort'];
        $add_data['inv_update_id'] = $user_info->adm_id;
        $add_data['inv_update_time'] = date('Y-m-d H:i:s');
        $add_data['inv_state'] = $request['inv_state'];
        $add_data['inv_time'] = $request['inv_time'];
        $add_data['inv_description'] = $request['inv_description'];
        $add_res = DB::table('instructional_video')->where('inv_id', $request['inv_id'])->update($add_data);
        return ['code'=>200, 'msg'=>'编辑成功', 'data'=>''];
    }

    /**
     * 查询地址
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-23
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function getAddress($user_info,$request) {
        $find_shop = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->first();
        if (empty($find_shop->shop_address) || empty($find_shop->shop_longitude) || empty($find_shop->shop_latitude)) {
            return ['code'=>500, 'msg'=>'请填写地址', 'data'=>''];
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>''];
    }

    /**
     * 设置地址
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-23
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     */
    public static function addAddress($user_info, $request) {
        $update_data['shop_province'] = $request['shop_province'];
        $update_data['shop_image'] = $request['shop_image'];
        $update_data['shop_city'] = $request['shop_city'];
        $update_data['shop_county'] = $request['shop_county'];
        $update_data['shop_address'] = $request['shop_address'];
        $update_data['shop_update_time'] = $request['shop_update_time'];
        $find_shop_latitude = CommonService::jingwei($request['shop_province'],$request['shop_province'].$request['shop_city'].$request['shop_county'].$request['shop_address']);
        if (!empty($find_shop_latitude)) {
            $latitude_data = explode(',',$find_shop_latitude);
            $update_data['shop_longitude'] = $latitude_data[0]; //经度
            $update_data['shop_latitude'] = $latitude_data[1]; //纬度
        }
        $update_res = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->update($update_data);
        if ($update_res) {
            return ['code'=>200, 'msg'=>'设置地址成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'设置地址失败', 'data'=>''];
        }
    }

    /**
     * 邀请记录
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-23
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function invitation($user_info,$request) {
        if (isset($request['show_count']) && $request['show_count']) {
            $show_count = $request['show_count'];
        } else {
            $show_count = 10;
        }
        $inv_data = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->first();
        $shop_code = $inv_data->shop_code;
        $list_data = DB::table('invitation_log')
            ->leftJoin('settle_in', 'id', '=', 'inlo_sein_id')
            ->where(function ($query) use ($request) {
                if (isset($request['keywords']) && $request['keywords']) {
                    $query->where('shop_name', 'like', '%' . $request['keywords'].'%')
                        ->orWhere('phone', 'like', '%' . $request['keywords'].'%')
                        ->orWhere('charge_name', 'like', '%' . $request['keywords'].'%');
                }
            })
            ->where(function ($query) use ($request) {
                if (isset($request['status']) && $request['status']) {
                    $query->where('status', $request['status']);
                }
            })
            ->where(function ($query) use ($request) {
                if (isset($request['shop_name']) && $request['shop_name']) {
                    $query->where('shop_name', 'like', '%' . $request['shop_name'] . '%');
                }
            })
            ->where(function ($query) use ($request) {
                if (isset($request['phone']) && $request['phone']) {
                    $query->where('phone', 'like', '%' . $request['phone'].'%');
                }
            })
            ->where(function ($query) use ($request) {
                if (isset($request['charge_name']) && $request['charge_name']) {
                    $query->where('charge_name','like', '%' .  $request['charge_name'].'%');
                }
            })
            ->where(function ($query) use ($inv_data) {
                if ($inv_data->shop_id == 2) {
                } else {
                    $query->where('inv_shop_code', $inv_data->shop_code);
                }
            })
            ->select('shop_name', 'charge_name', 'status', 'inv_shop_code', 'phone')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            foreach ($list_items as $key => $value) {
                if (!empty($value->inv_shop_code)) {
                    $list_items[$key]->inv_shop_name = DB::table('shop')
                        ->where('shop_code', $value->inv_shop_code)
                        ->value('shop_store_name');
                } else {
                    $list_items[$key]->inv_shop_name = '';
                }
                switch ($value->status) {//状态 1待审核 2无需审核 3已联系 4已通过 5已驳回
                    case '1':
                        $list_items[$key]->status_name = '待审核';
                        break;
                    case '2':
                        $list_items[$key]->status_name = '无需审核';
                        break;
                    case '3':
                        $list_items[$key]->status_name = '已联系';
                        break;
                    case '4':
                        $list_items[$key]->status_name = '已通过';
                        break;
                    case '5':
                        $list_items[$key]->status_name = '已驳回';
                        break;
                    default:
                        $list_items[$key]->status_name = '未定义';
                        break;
                }
            }
        }
        $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['pages']['total'] = $list_data->total();               //总数据个数
        $data['pages']['current_number'] = $show_count;        //一页显示多少个
        $data['list'] = $list_items;                        //返回数据
        
        return $data;
    }

    /**
     * 设置用户是否可以查看工单图片
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-24
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function listWorkPic($user_info, $request) {
        $update_data['shop_user_list_workpic'] = $request['state'];//1展示2不展示
        $update_data['shop_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->update($update_data);
        if ($res) {
            return ['code'=>200, 'msg'=>'设置成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'设置失败', 'data'=>''];
        }
    }

    /**
     * 获取分享码
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-26
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public static function getInvQrimg($user_info, $request) {
        $find_data = DB::table('shop_invitate_code_config')
            ->where('shic_shop_id', $user_info->adm_shop_id)
            ->where('shic_state', 1)
            ->where('shic_start_date', '<', date('Y-m-d H:i:s'))
            ->where('shic_end_date', '>', date('Y-m-d H:i:s'))
            ->orderBy('shic_id', 'desc')
            ->first();
        return ['code'=>200, 'msg'=>'success', 'data'=>$find_data];
    }

    /**
     * 获取升级店铺金额
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-11-01
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function getUpShopPrice($user_info,$request) {
        $find_shop = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->first();
        if ($find_shop->shop_buy == 1) {
            $old_year_price = DB::table('shop_price')
                ->where('shpr_id', $find_shop->shop_shpr_id)
                ->value('shpr_price');
            $new_year_price = DB::table('shop_price')
                ->where('shpr_id', $request['shpr_id'])
                ->value('shpr_price');
            $return_price = $new_year_price - $old_year_price;
        } else {
            $new_year_price = DB::table('shop_price')
                ->where('shpr_id', $request['shpr_id'])
                ->value('shpr_price');
            $return_price = $new_year_price;
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$return_price];
    }

    /**
     * 创建二维码
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-11-14
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     */
    public static function addInvCode($user_info, $request) {
        $find_shop = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->first();
        $add_data['shic_shop_id'] = $user_info->adm_shop_id;
        $add_data['shic_shop_code'] = $find_shop->shop_code;
        $add_data['shic_code'] = 'C'.time().rand(10000,99999);
        if ($user_info->adm_shop_id != 2) {
            $add_data['shic_code_type'] = 2;
            $add_data['shic_gift_time'] = $find_shop->shop_gift_time;
            $add_data['shic_invitation_time_long'] = $find_shop->shop_invitation_time_long;
            $add_data['shic_invitation_time_type'] = $find_shop->shop_invitation_time_type;
            $add_data['shic_discount_price'] = $find_shop->shop_invitation_config_price;
            $add_data['shic_start_date'] = date('Y-m-d').' 00:00:00';
            $add_data['shic_end_date'] = date('Y-m-d').' 23:59:59';
        } else {
            $add_data['shic_invitation_time_long'] = isset($request['shic_invitation_time_long']) ? $request['shic_invitation_time_long']:$find_shop->shop_invitation_time_long;
            $add_data['shic_invitation_time_type'] = isset($request['shic_invitation_time_type']) ? $request['shic_invitation_time_type']:$find_shop->shop_invitation_time_type;
            $add_data['shic_code_type'] = isset($request['shic_code_type']) ? $request['shic_code_type']:2;
            $add_data['shic_discount_price'] = isset($request['shic_discount_price']) ? $request['shic_discount_price']*100 : $find_shop->shop_invitation_config_price;
            $add_data['shic_start_date'] = date('Y-m-d').' 00:00:00';
            if (!isset($request['day_num'])) {
                $request['day_num'] = 1;
            }
            $add_data['shic_end_date'] = date('Y-m-d', strtotime('+ '.($request['day_num'] - 1).' day')).' 23:59:59';
        }
        $QrCodeService = new QrCodeService();
        $text = config('apisystem.server_name_https'). '/xminvite?shop_code='.$add_data['shic_code'];
        $qrCode = config('apisystem.server_name_https'). '/'.$QrCodeService->qrCode(2, $text);
        $add_data['shic_code_pic'] = $qrCode;
        $add_data['shic_create_time'] = date('Y-m-d H:i:s');
        $add_data['shic_num'] = $request['shic_num'];
        $add_data['shic_create_id'] = $user_info->adm_id;
        $add_data['shic_use_num'] = 0;
        $add_data['shic_state'] = 1;
        $add_res = DB::table('shop_invitate_code_config')->insertGetId($add_data);
        if ($add_res) {
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>''];
        }
    }

    /**
     * 获取邀请码金额
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-11-18
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function getCodePrice($user_info,$request) {
        $find_shic_data = DB::table('shop_invitate_code_config')
            ->where('shic_code', $request['inv_code'])
            ->first();
        $find_shop = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->first();

        if ($find_shic_data) {
            if ($find_shop->shop_buy == 1 && $find_shic_data->shic_code_type == 2) {//购买过版本 不能使用版本类型
                return ['code'=>500, 'msg'=>'此邀请码类型只能用于购买版本', 'data'=>''];
            }
            if ($find_shic_data->shic_state != 1) {
                return ['code'=>500, 'msg'=>'此邀请码已失效', 'data'=>''];
            }
            if ($find_shic_data->shic_use_num >= $find_shic_data->shic_num) {
                return ['code'=>500, 'msg'=>'此邀请码数量已超出限制', 'data'=>''];
            }
            if ($find_shic_data->shic_end_date < date('Y-m-d H:i:s')) {
                return ['code'=>500, 'msg'=>'此邀请码过期', 'data'=>''];
            }
            return ['code'=>200, 'msg'=>'success', 'data'=>$find_shic_data];
        } else {
            return ['code'=>500, 'msg'=>'未查询到此邀请码', 'data'=>''];
        }
    }
}
