<?php

namespace App\Services\Shop;

use Illuminate\Database\Eloquent\Model;
use App\Models\Shop\Goods;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\Shop\PurchaseValidator;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Support\Facades\Request;
use App\Models\Common;
use App\Http\Models\Services\WarehouseManage\PurchaseOrder;
use App\Services\Business\WashOrderBasicService;
use App\Models\OperationLog;
class PurchaseService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->mainValidator = new PurchaseValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 获取门店
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-02-27
     * @param  [type]           $user_info  [description]
     * @param  [type]           $request    [description]
     * @param  integer          $show_count [description]
     * @return [type]                       [description]
     */
    public function getShop($user_info, $request, $show_count = 10) {
        $list_data = DB::table('shop')
            ->where('shop_id', '!=', $user_info->adm_shop_id)
            ->where(function ($query) use ($request) {
                if (!empty($request['shop_code'])) {
                    $query->where('shop_code', 'like', '%' . $request['shop_code'] . '%');
                }
            })
            ->select('shop_store_name', 'shop_code', 'shop_id')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['pages']['total'] = $list_data->total();               //总数据个数
            $data['pages']['current_number'] = $show_count;        //一页显示多少个
            $data['list'] = $list_items;                        //返回数据
            return $data;
        } else {
            return [];
        }
    }

    /**
     * 获取上级门店
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-02-27
     * @param  [type]           $user_info  [description]
     * @param  [type]           $request    [description]
     * @param  integer          $show_count [description]
     * @return [type]                       [description]
     */
    public function getFshop($user_info, $request, $show_count = 10) {
        $list_data = DB::table('channel_unit')
            ->where('chun_shop_id',$user_info->adm_shop_id)
            ->where('chun_shop_fid', '!=', '')
            ->where(function ($query) use ($request) {
                if (!empty($request['shop_code'])) {
                    $query->where('chun_fshop_code', 'like', '%' . $request['shop_code'] . '%');
                }
            })
            ->select('chun_shop_fid', 'chun_unit_name', 'chun_fshop_code', 'chun_shop_id')
            ->get()->toArray();
        return $list_data;
    }

    /**
     * 获取门店详细信息
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-02-27
     * @param  [type]           $user_info  [description]
     * @param  [type]           $request    [description]
     * @param  integer          $show_count [description]
     * @return [type]                       [description]
     */
    public function getShopInfo($user_info, $request, $show_count = 10) {
        $list_data = DB::table('shop')
            ->where('shop_code', $request['shop_code'])
            ->select('shop_store_name', 'shop_id', 'shop_city', 'shop_province', 'shop_address', 'shop_longitude', 'shop_county', 'shop_latitude', 'shop_phone', 'shop_name')
            ->first();
        return $list_data;
    }

    /**
     * 获取门店商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-02-27
     * @param  [type]           $user_info  [description]
     * @param  [type]           $request    [description]
     * @param  integer          $show_count [description]
     * @return [type]                       [description]
     */
    public function getShopGoods($user_info, $request, $show_count = 10) {
        $list_data = DB::table('goods')
            ->leftJoin('bind_good', 'bigo_goo_id', '=', 'goo_id')
            ->where('goo_shop_id', $user_info->adm_shop_id)
            ->where('goo_type', 1)
            ->where(function ($query) use ($request) {
                if (!empty($request['keywords'])) {
                    $query->where('goo_name', 'like', '%' . $request['keywords'] . '%');
                }
            })
            // ->select('goo_shop_id', 'goo_name', 'goo_id')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['pages']['total'] = $list_data->total();               //总数据个数
            $data['pages']['current_number'] = $show_count;        //一页显示多少个
            $data['list'] = $list_items;                        //返回数据
            return $data;
        } else {
            return [];
        }
    }


    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function index($user_info, $search_data, $show_count = 10)
    {
        // 商品列表
        $list_data = DB::table('new_purorder as p')
            ->where('npor_shop_id', $user_info->adm_shop_id)
            ->orderBy('npor_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['pages']['total'] = $list_data->total();               //总数据个数
            $data['pages']['current_number'] = $show_count;        //一页显示多少个
            $data['list'] = $list_items;                        //返回数据
            return $data;
        } else {
            return [];
        }
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function wholesale($user_info, $search_data, $show_count = 10)
    {
        // 商品列表
        $list_data = DB::table('new_purorder as p')
            ->where('npor_fshop_id', $user_info->adm_shop_id)
            ->orderBy('npor_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['pages']['total'] = $list_data->total();               //总数据个数
            $data['pages']['current_number'] = $show_count;        //一页显示多少个
            $data['list'] = $list_items;                        //返回数据
            return $data;
        } else {
            return [];
        }
    }

    /**
     * 接单
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-04
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function receive($user_info, $request) {
        $find_data = DB::table('new_purorder')
            ->where('npor_id', $request['npor_id'])
            ->first();
        if (empty($find_data)) {
            return ['code'=>500,'msg'=>'未查到此采购订单', 'data'=>''];
        }
        if ($find_data->npor_fstate != 1) {
            return ['code'=>500,'msg'=>'不是待接单状态', 'data'=>''];
        }

        // 获取唯一字符串标识
        $ord_unique_string = md5(md5($user_info->adm_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));

        $bucl_data = DB::table('business_client')
            ->where('bucl_bind_shop_id', $find_data->npor_shop_id)
            ->first();
        if (empty($bucl_data)) {
            return ['code' => 500, 'msg' => '未查询到此企业客户', 'data' => ''];
        }
        $buac_data = DB::table('business_account')
            ->where('buac_bucl_id', $bucl_data->bucl_id)
            ->first();
        if (empty($bucl_data)) {
            return ['code' => 500, 'msg' => '未查询到此企业客户', 'data' => ''];
        }
        $post_data['ord_unique_string'] = $ord_unique_string;
        $post_data['ord_client_id'] = $buac_data->buac_id;
        $post_data['orcl_appoint_time'] = !empty($find_data->npor_appoint_time) ? $request['orcl_appoint_time'] : '';
        $post_data['orcl_business_id'] = $bucl_data->bucl_id;
        
        $post_data['ord_address_type'] = 2;
        $post_data['ord_address_id'] = $bucl_data->bucl_id;
        $post_data['ord_type'] = 2;
        $post_data['ord_address'] = $bucl_data->bucl_name;
        $post_data['ord_payment_way'] = $request['ord_payment_way'];
        $post_data['ord_explain_pic'] = $request['ord_explain_pic'];
        $post_data['ord_explain'] = $request['ord_explain'];
        if ($find_data->npor_ord_id) {
            $ord_data = DB::table('order as o')
                ->leftJoin('order_client as orcl', 'orcl_ord_id', '=', 'ord_id')
                ->select('orcl_car_num')
                ->first();
        }
        $post_data['orcl_car_num'] = isset($ord_data->orcl_car_num) ? $ord_data->orcl_car_num : '';
        $post_data['orcl_sales_adm_id'] = 0;
        $post_data['orcl_name'] = $buac_data->buac_name;
        $post_data['orcl_phone'] = $buac_data->buac_phone;
        $post_data['orcl_carowner_name'] = $buac_data->buac_name;
        $post_data['orcl_carowner_phone'] = $buac_data->buac_phone;
        $post_data['orcl_car_brand_series'] = isset($ord_data->orcl_car_brand_series) ? $ord_data->orcl_car_brand_series : '';
        $post_data['orcl_business_name'] = $bucl_data->bucl_name;
        $post_data['ord_actual_amout'] = $request['ord_actual_amout'];
        $post_data['ip'] = $request['ip'];
        $post_data['send'] = 2;
        $goods_data = DB::table('new_purgoods')->where('npgo_npor_id', $find_data->npor_id)->get();
        $have_ser = false;
        $cg = false;
        foreach ($goods_data as $key => $value) {
            $new_goods_data[$key]['goo_type'] = $value->npgo_goo_type;//1产品2服务
            $new_goods_data[$key]['goo_id'] = $value->npgo_fgoo_id;//id
            $new_goods_data[$key]['goo_name'] = $value->npgo_fgoo_name;//名称
            $new_goods_data[$key]['goo_unta_id'] = $value->npgo_goo_unit_id;//单位id
            $new_goods_data[$key]['goo_unit'] = $value->npgo_goo_unit;//单位id
            $new_goods_data[$key]['goo_quantity'] = $value->npgo_goo_num;//数量
            $new_goods_data[$key]['goo_price'] = $value->npgo_goo_price/100;//数量
            $new_goods_data[$key]['goo_state'] = 1;//数量
            if ($value->npgo_goo_type == 1) {
                $find_goods = DB::table('goods')
                    ->where('goo_id', $value->npgo_fgoo_id)
                    ->first();
                $new_goods_data[$key]['sepr_work_type'] = 2;//是否生成工单
                $cg = true;
            } elseif ($value->npgo_goo_type == 2) {
                $find_goods = DB::table('service_project')
                    ->where('sepr_id', $value->npgo_fgoo_id)
                    ->first();
                $have_ser = true;
                $new_goods_data[$key]['sepr_work_type'] = $find_goods->sepr_work_type;//是否生成工单
            }
        }
        $post_data['ware_id'] = $request['ware_id'];
        $post_data['npor_id'] = $request['npor_id'];
        $post_data['goods_data'] = json_encode($new_goods_data, true);
        $post_data['rt'] = 'business_client';
        // 基础版功能逻辑
        $order_data = WashOrderBasicService::add($user_info, $post_data);
        if ($order_data['code'] != 200) {
            DB::rollBack();
            return $order_data;
        }
        $update_npor = DB::table('new_purorder')
            ->where('npor_id', $request['npor_id'])
            ->update(['npor_ford_id'=>$order_data['data']['ord_id'], 'npor_fstate'=>2]);
        // 订单历史记录
        $data['wohi_primary_id'] = $order_data['data']['ord_id'];
        $data['wohi_state_name'] = '已创建';
        $data['wohi_state'] = 1;
        $data['wohi_type'] = 1;
        addHistory($data);
        unset($data);
        // 生成操作记录
        $orlo_res = orderLog($user_info, $order_data['data']['ord_id'], 0, '生成订单');
        OperationLog::addLog($user_info, $request['ip'], '订单列表', '生成订单', '生成订单' . $order_data['data']['ord_order_number'] . '成功');
        if ($order_data['code'] == 200) {
            DB::commit();
            return ['code' => 200, 'msg' => '接单成功', 'data' => ''];
        } else {
            DB::rollBack();
            return ['code' => 500, 'msg' => '接单失败', 'data' => ''];
        }
    }

    /**
     * 新增采购单
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-02-28
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     */
    public static function add($user_info, $request)
    {
        DB::beginTransaction();
        $data['npor_shop_id'] = $user_info->adm_shop_id;
        $data['npor_fshop_id'] = $request['npor_fshop_id'];
        $data['npor_fshop_name'] = $request['npor_fshop_name'];
        $data['npor_ware_id'] = !empty($request['npor_ware_id'])?$request['npor_ware_id']:'';
        $data['npor_remark'] = $request['npor_remark']?$request['npor_remark']:'';
        $data['npor_cg_delivertype'] = $request['npor_cg_delivertype'];//交货方式1送货上门2自提
        $data['npor_settlement_type'] = $request['npor_settlement_type'];
        $data['npor_state'] = 1;
        $data['npor_pay_state'] = 1;
        $data['npor_fstate'] = 1;
        $data['npor_cg_date'] = date('Y-m-d H:i:s');
        $data['npor_create_time'] = date('Y-m-d H:i:s');
        $data['npor_create_id'] = $user_info->adm_id;
        $npor_number = 'NCG' . time() . rand(1000, 9999);
        $data['npor_number'] = $npor_number; //商品编号
        $npor_id = DB::table('new_purorder')->insertGetId($data);
        $goods_data = $request['goods_data'];
        if (empty($goods_data)) {
            DB::rollBack();
            return ['code' => 500, 'msg' => '请选择商品', 'data' => '新增失败'];
        }
        $have_ser = false;
        $cg = false;
        $i = 0;
        foreach ($goods_data as $key => $value) {
            $add_data[$key]['npgo_npor_id'] = $npor_id;
            $add_data[$key]['npgo_shop_id'] = $user_info->adm_shop_id;
            $add_data[$key]['npgo_fshop_id'] = $request['npor_fshop_id'];
            $add_data[$key]['npgo_goo_type'] = $value['npgo_goo_type'];//1产品2服务
            if ($value['npgo_goo_type'] == 2) {
                $have_ser = true;
            }
            if ($value['npgo_goo_type'] == 1 && $value['npgo_fgoo_id'] && $value['npgo_goo_id']) {
                $cg = true;
                $new_goods_data[$i]['goods_num'] = $value['npgo_goo_num'];
                $new_goods_data[$i]['univalence'] = $value['npgo_goo_price'];
                $new_goods_data[$i]['goods_id'] = $value['npgo_goo_id'];
                $new_goods_data[$i]['tax_rate'] = 0;
                $new_goods_data[$i]['goo_type'] = 1;
                $new_goods_data[$i]['currency'] = '人民币';
                $new_goods_data[$i]['company_unit'] = $value['npgo_goo_unit'];//计量单位
                $new_goods_data[$i]['money'] = $value['npgo_goo_num']*$value['npgo_goo_price'];//金额
                $i++;
            }
            $add_data[$key]['npgo_goo_id'] = $value['npgo_goo_id'];
            $add_data[$key]['npgo_goo_name'] = $value['npgo_goo_name'];
            $add_data[$key]['npgo_fgoo_id'] = $value['npgo_fgoo_id'];
            $add_data[$key]['npgo_fgoo_name'] = $value['npgo_fgoo_name'];
            $add_data[$key]['npgo_goo_num'] = $value['npgo_goo_num'];
            $add_data[$key]['npgo_goo_price'] = $value['npgo_goo_price']*100;
            $add_data[$key]['npgo_goo_unit_id'] = $value['npgo_goo_unit_id'];
            $add_data[$key]['npgo_goo_unit'] = $value['npgo_goo_unit'];
        }
        $add_goods_res = DB::table('new_purgoods')->insert($add_data);
        if (!$have_ser && $cg) {//生成采购单
            $getdata_res = PurchaseOrder::getPurchaseData($user_info, $user_info->adm_shop_id, $request);
            $cg_number = $getdata_res['data']['cg_number'];
            $contract_number = $getdata_res['data']['contract_number'];
            // 验证采购单号是否重复
            $cg_id = DB::table('purchase_order')
                ->where('company_id', $user_info->adm_cid)
                ->where('cg_superior_shop_id', $user_info->adm_shop_id)
                ->where('cg_number', $cg_number)
                ->value('cg_id');
            if ($cg_id) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'采购单号重复', 'data'=>'采购单号重复']);
            }
            $allData['cg_number'] = $cg_number;
            $allData['contract_number'] = $contract_number;
            $allData['cg_purchasetime'] = date('Y-m-d H:i:s');
            $allData['business_type'] = 1;
            $allData['puor_supplyunit_type'] = 1;
            if (empty($request['npor_ware_id'])) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'请选择仓库', 'data'=>'']);
            }
            $allData['cg_wareid'] = $request['npor_ware_id'];
            $allData['cg_remark'] = $request['npor_remark'];
            $allData['cg_supplyunit'] = $request['npor_fshop_name'];
            $allData['contact_name'] = $request['contact_name'];
            $allData['contact_phone'] = $request['contact_phone'];
            $allData['cg_paymentype'] = $request['npor_settlement_type'];
            $allData['cg_delivertype'] = $request['npor_cg_delivertype'];
            $allData['cg_invoicetype'] = 1;
            $allData['goods'] = $new_goods_data;
            $add_res = PurchaseOrder::add($user_info, $user_info->adm_shop_id, $allData);
        }
        if ($npor_id && $add_goods_res) {
            DB::commit();
            return ['code' => 200, 'msg' => '新增成功', 'data' => $npor_id];
        } else {
            DB::rollBack();
            return ['code' => 500, 'msg' => '新增失败', 'data' => '新增失败'];
        }
    }

    /**
     * 采购计划
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-31
     * @param  [type]           $user_info   [description]
     * @param  [type]           $search_data [description]
     * @param  integer          $show_count  [description]
     * @return [type]                        [description]
     */
    public function purchasingPlan($user_info, $search_data, $show_count = 10)
    {
        // 商品列表
        $list_data = DB::table('purchasing_plan as p')
            ->leftJoin('goods', 'goo_id', '=', 'pupl_goo_id')
            ->leftJoin('warehouse', 'ware_id', '=', 'pupl_ware_id')
            ->where('pupl_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pupl_state'])) {
                    $query->where('pupl_state', $search_data['pupl_state']);
                } else {
                    $query->whereIn('pupl_state', [2,3]);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_name'])) {
                    $query->where('goo_name', 'like', '%' . $search_data['goo_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_goods_encode'])) {
                    $query->where('goo_goods_encode', 'like', '%' . $search_data['goo_goods_encode'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pupl_ware_id'])) {
                    $query->where('pupl_ware_id', $search_data['pupl_ware_id']);
                }
            })
            ->select('goo_id', 'goo_name', 'goo_bra_name', 'goo_goods_encode', 'goo_unit', 'goo_unta_id', 'pupl_ware_id', 'pupl_state', 'pupl_state_name', 'pupl_ord_nums', 'pupl_wago_nums', 'pupl_cg_nums', 'goo_purchase_price', 'ware_name', 'pupl_id')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            foreach ($list_items as $key => $value) {
                $list_items[$key]->goo_wago_id = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $value->pupl_ware_id)
                    ->where('wago_goo_id', $value->goo_id)
                    ->where('wago_class', 1)
                    ->value('wago_id');
                $list_items[$key]->goo_name = $value->goo_name.'('.$value->goo_unit.')';  
            }
            $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['pages']['total'] = $list_data->total();               //总数据个数
            $data['pages']['current_number'] = $show_count;        //一页显示多少个
            $data['list'] = $list_items;                        //返回数据
            return $data;
        } else {
            $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['pages']['total'] = $list_data->total();               //总数据个数
            $data['pages']['current_number'] = $show_count;        //一页显示多少个
            $data['list'] = $list_items;                        //返回数据
            return $data;
        }
    }

    /**
     * 采购计划明细
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-08-01
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function planInfo($user_info, $request) {
        $info = DB::table('purchasing_plan as p')
            ->leftJoin('goods', 'goo_id', '=', 'pupl_goo_id')
            ->leftJoin('warehouse', 'ware_id', '=', 'pupl_ware_id')
            ->where('pupl_id', $request['pupl_id'])
            ->select('goo_id', 'goo_name', 'goo_bra_name', 'goo_goods_encode', 'goo_unit', 'goo_unta_id', 'pupl_ware_id', 'pupl_state', 'pupl_state_name', 'pupl_ord_nums', 'pupl_wago_nums', 'pupl_cg_nums', 'goo_purchase_price', 'ware_name')
            ->first();
        $find_dego_order = DB::table('order_goods')
            ->leftjoin('order', 'ord_id', '=', 'orgo_ord_id')
            ->leftJoin('dispatch_bill', 'dego_original_number', '=', 'ord_order_number')
            ->where('ord_ware_id', $info->pupl_ware_id)
            ->where('ord_add_work_state', 2)
            ->where('orgo_goo_id', $info->goo_id)
            ->where('orgo_goo_type', 1)
            ->where('dego_order_type', 1)
            ->where('dego_type', 1)
            ->select('ord_order_number')
            ->get();
        $ord_data = json_decode(json_encode($find_dego_order,true),true);
        $find_dego_work1 = DB::table('order_goods')
            ->leftjoin('order', 'ord_id', '=', 'orgo_ord_id')
            ->leftJoin('work_order', 'wor_order_id', '=', 'ord_id')
            ->where('ord_ware_id', $info->pupl_ware_id)
            ->where('orgo_goo_id', $info->goo_id)
            ->where('ord_add_work_state', 1)
            ->where('ord_wor_quantity', 0)
            ->select('ord_order_number')
            ->get();
        $find_dego_work1 = json_decode(json_encode($find_dego_work1,true),true);
        $ord_data = array_merge($ord_data,$find_dego_work1);
        $find_dego_work2 = DB::table('order_goods')
            ->leftjoin('order', 'ord_id', '=', 'orgo_ord_id')
            ->leftJoin('work_order', 'wor_order_id', '=', 'ord_id')
            ->leftJoin('dispatch_bill', 'dego_original_number', '=', 'wor_number')
            ->where('ord_ware_id', $info->pupl_ware_id)
            ->where('orgo_goo_id', $info->goo_id)
            ->where('ord_add_work_state', 1)
            ->where('dego_order_type', 2)
            ->where('dego_type', 1)
            ->select('ord_order_number')
            ->get();
        $find_dego_work2 = json_decode(json_encode($find_dego_work2,true),true);
        $ord_data = array_merge($ord_data,$find_dego_work2);
        $info->ord_data = $ord_data;
        $purchase_order = DB::table('storage_goods')
            ->leftJoin('purchase_order', 'cg_number', '=', 'relation_number')
            ->whereIn('cg_state',[1,2,3,5,8])
            ->where('cg_shop_id', $user_info->adm_shop_id)
            ->where('goods_id', $info->goo_id)
            ->where('cg_wareid', $info->pupl_ware_id)
            ->select('cg_number')
            ->get();
        $info->purchase_order = $purchase_order;
        $find_dego_after = DB::table('wash_after_sale_items')
            ->leftjoin('wash_after_sale_list', 'afsl_id', '=', 'afsi_afsl_id')
            ->leftJoin('dispatch_bill', 'dego_original_number', '=', 'afsl_after_number')
            ->where('afsl_ware_id', $info->pupl_ware_id)
            ->where('afsi_goo_id', $info->goo_id)
            ->where('dego_order_type', 3)
            ->where('dego_type', 1)
            ->where('afsi_type', 2)
            ->select('afsl_after_number')
            ->get();
        $info->after_order = $find_dego_after;
        return $info;
    }
}
