<?php

/**
 * 登录用户服务
 *
 * @author lixiaolin
 * @Date: 2021/8/17
 * @Time: 下午17:33
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Request;

class LoginUserService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {

    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    public static function getUserShopID()
    {
        $user = static::getUser();
        if ($user) {
            return $user['adm_shop_id'];
        }

        return false;
    }

    public static function getUser( $requestType = '' ) {
        static $userInfor = [];
        if (!empty($userInfor)) {
            return $userInfor;
        }

        //测试用数据结束
        $apiToken = Request::input('api_token');
        if($requestType == '') {
            $requestType = Request::input('rt', 'pc');
        }
        if (empty($apiToken) || empty($requestType)) {
            return false;
        }
        if ($requestType == 'pc') {
            $userInfor = static::getUserInfo($apiToken);
        } elseif ($requestType == 'app') {
            $userInfor = static::webGetUserInfo($apiToken);
        } elseif ($requestType == 'business') {//微信小程序合作商获取用户信息
            $userInfor = static::BusinessGetUserInfo(Request::all());
        }  elseif ($requestType == 'wechat') {//微信小程序获取用户信息 技师
            $userInfor = static::wechatGetUserInfo($apiToken);
        } elseif ($requestType == 'wechatWash') {//洗美微信用户
            $userInfor = static::wechatWashGetUserInfo(Request::all());
        } else {
            $userInfor = static::getUserInfo($apiToken);
        }
        return $userInfor;
    }

    // PC获取用户信息
    public static function getUserInfo($api_token)
    {
        $find_user_info = DB::table('login_temporary')
            ->where('api_token', '=', $api_token)
            ->select('adm_id', 'adm_cid', 'adm_shop_id', 'shop_superior_id', 'adm_name', 'adm_phone', 'shop_versions')
            ->first();
        if ($find_user_info) {
            $find_user_info->shop_versions = 2;
        }
        return $find_user_info;
    }

    // 移动端获取用户信息
    public static function webGetUserInfo($api_token)
    {
        $find_user_info = DB::table('login_webapp')
            ->where('api_token', '=', $api_token)
            ->select('adm_id', 'adm_cid', 'adm_shop_id', 'shop_superior_id', 'adm_name', 'adm_phone', 'shop_versions')
            ->first();
        if ($find_user_info) {
            $find_user_info->shop_versions = 2;
        }
        return $find_user_info;
    }

    // 微信小程序获取用户信息
    public static function wechatGetUserInfo($api_token)
    {
        $find_user_info = DB::table('login_wechat_applet')
            ->where('api_token', '=', $api_token)
            ->select('adm_id', 'adm_cid', 'adm_shop_id', 'shop_superior_id', 'adm_name', 'adm_phone', 'shop_versions')
            ->first();
        if ($find_user_info) {
            $find_user_info->shop_versions = 2;
        }
        return $find_user_info;
    }

    // 洗美用户-微信小程序获取用户信息
    public static function wechatWashGetUserInfo($request)
    {
        $find_user_info = DB::table('user_shop as a')
            ->leftJoin('shop as b', 'a.ussh_shop_id', '=', 'b.shop_id')
            ->leftJoin('member as m', 'a.ussh_user_id', '=', 'm.mem_id')
            ->where('ussh_weus_id', $request['weus_id'])
            ->where('ussh_shop_id', $request['shop_id'])
            ->where('ussh_user_type', 1)
            ->where('ussh_now_login', 1)
            ->select('ussh_user_id', 'shop_cid as adm_cid', 'shop_id as adm_shop_id', 'shop_superior_id', 'mem_name as adm_name')
            ->first();
        return $find_user_info;
    }

    // 合作商小程序获取用户信息
    public static function BusinessGetUserInfo($request)
    {
        $find_user_info = DB::table('business_account as ba')
            ->leftJoin('shop as b', 'ba.buac_shop_id', '=', 'b.shop_id')
            ->where('buac_id', $request['buac_id'])
            ->select('buac_shop_id', 'shop_cid as adm_cid', 'shop_id as adm_shop_id', 'shop_superior_id', 'buac_name as adm_name', 'buac_phone as adm_phone', 'buac_id')
            ->first();
        return $find_user_info;
    }
}
