<?php

namespace App\Services\Business;

use App\Http\Controllers\Common\CommonController;
use App\Services\CommonService;
use Illuminate\Support\Facades\Request;
use App\Models\Business\WashWork;
use BlueCity\Core\Service\Service;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\Business\WashWorkValidator;
use BlueCity\Core\Inc\ErrorInc;
use App\Http\Models\Services\OrderManage\WorkOrders;
use App\Http\Models\Api\CashierDesk;
use App\Http\Models\Api\Export;
use App\Http\Enum\Business\WorkOrderEnum;
use App\Services\Business\WashOrderService;
use App\Services\Business\WashOrderBasicService;
use App\Http\Models\Api\Common as MCommon;

// 工单
class WashWorkService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new WashWork();
        $this->mainValidator = new WashWorkValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param object $user_info 用户信息
     * @param array $search_data 内容
     * @param int $show_count 页容量
     * @return mixed
     */
    public function searchPage($user_info, $search_data, $show_count = 10)
    {
        // 实际金额最小钱数
        if (!empty($search_data['min_price'])) {
            $search_data['min_price'] = $search_data['min_price'] * 100;
        }
        // 实际金额最大钱数
        if (!empty($search_data['max_price'])) {
            $search_data['max_price'] = $search_data['max_price'] * 100;
        }
        if(isset($search_data['is_excel']) && $search_data['is_excel']==2){
            DB::connection()->enableQueryLog();#开启执行日志
        }
        $list_data = DB::table('work_order as a')
            ->leftJoin('work_client as b', 'b.wocl_wor_id', '=', 'a.wor_id')
            ->leftJoin('order', 'a.wor_order_id', '=', 'ord_id')
            ->where('wor_cid', $user_info->adm_cid)
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->where('wor_delete', 1)
            ->where('wor_classify', 2)
            ->where('wor_collection_bill', 1) //是否代收账单：1正常工单2代收账单
            ->where(function ($query) use ($search_data) { //订单号
                if (!empty($search_data['wor_order_number'])) {
                    $query->where('wor_order_number', 'like', '%' . $search_data['wor_order_number'] . '%');
                }
                if (!empty($search_data['wor_number'])) {//工单号
                    $query->where('wor_number', 'like', '%' . $search_data['wor_number'] . '%');
                }
                if (!empty($search_data['wocl_name'])) {//姓名
                    $query->where('wocl_name', 'like', '%' . $search_data['wocl_name'] . '%');
                }
                if (!empty($search_data['wocl_phone'])) {//联系电话
                    $query->where('wocl_phone', 'like', '%' . $search_data['wocl_phone'] . '%');
                }
                if (!empty($search_data['wocl_carowner_name'])) {//姓名
                    $query->where('wocl_carowner_name', 'like', '%' . $search_data['wocl_carowner_name'] . '%');
                }
                if (!empty($search_data['wocl_carowner_phone'])) {//联系电话
                    $query->where('wocl_carowner_phone', 'like', '%' . $search_data['wocl_carowner_phone'] . '%');
                }
                if (!empty($search_data['wocl_car_num'])) {//车牌号
                    $query->where('wocl_car_num', 'like', '%' . $search_data['wocl_car_num'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //订单类型1会员零售2合作商
                if (!empty($search_data['wor_type'])) {
                    $query->where('wor_type', $search_data['wor_type']);
                }
                if (!empty($search_data['wor_service_adm_id'])) {//工单施工组长
                    $query->where('wor_service_adm_id', $search_data['wor_service_adm_id']);
                }
                //1.新订单 2未派单 3待接单/已派单 4.未出发/已接单 5.预约/已预约 6.出发/已出发  7.抵达/抵达 8.待审核/完成待审核 9驳回/完成已驳回 10完成/完成已通过
                if (!empty($search_data['wor_state'])) {
                    $query->where('wor_state', $search_data['wor_state']);
                }
                if (!empty($search_data['wor_create_id'])) {//派单人
                    $query->where('wor_create_id', $search_data['wor_create_id']);
                }
                if (!empty($search_data['wor_service_type'])) {//订单类型
                    $query->where('wor_service_type', $search_data['wor_service_type']);
                }
                if (!empty($search_data['wor_work_type'])) {//工单类型：1门店工单2智配工单
                    $query->where('wor_work_type', $search_data['wor_work_type']);
                }
                if (!empty($search_data['wor_other_audit'])) {//智配审核结果：1未审核2通过3驳回
                    $query->where('wor_other_audit', $search_data['wor_other_audit']);
                }
            })
            ->where(function ($query) use ($search_data) { //备注
                if (!empty($search_data['wor_remark'])) {
                    $query->where('wor_remark', 'like', '%' . $search_data['wor_remark'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //备注
                if (!empty($search_data['ord_new_type'])) {
                    $query->where('ord_new_type', $search_data['ord_new_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //是否返厂
                if (!empty($search_data['wor_need_return'])) {
                    $query->where('wor_need_return', $search_data['wor_need_return']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间/派单时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('wor_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('wor_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('wor_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //预约时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['appoint_time_start']) && !empty($search_data['appoint_time_end'])) {
                    $query->whereBetween('wor_appoint_time', [$search_data['appoint_time_start'], $search_data['appoint_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['appoint_time_start'])) {
                        $query->where('wor_appoint_time', '>=', $search_data['appoint_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['appoint_time_end'])) {
                            $query->where('wor_appoint_time', '<=', $search_data['appoint_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //实际金额区间搜索
                // 如果选择最小钱数并且选择最大钱数
                if (!empty($search_data['min_price']) && !empty($search_data['max_price'])) {
                    $query->whereBetween('wor_actual_price', [$search_data['min_price'], $search_data['max_price']]);
                } else {
                    // 如果选择最小钱数
                    if (!empty($search_data['min_price'])) {
                        $query->where('wor_actual_price', '>=', $search_data['min_price']);
                    } else {
                        // 如果选择最大钱数
                        if (!empty($search_data['max_price'])) {
                            $query->where('wor_actual_price', '<=', $search_data['max_price']);
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //客户id/会员id
                if (!empty($search_data['wocl_client_id'])) {
                    $query->where('wocl_client_id', $search_data['wocl_client_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //施工地址
                if (!empty($search_data['wor_address_type']) && !empty($search_data['wor_address_id'])) {
                    $query->where('wor_address_type', $search_data['wor_address_type'])
                        ->where('wor_address_id', $search_data['wor_address_id']);
                }
            })
            ->select('wor_id', 'wor_number', 'wor_create_id', 'wor_order_number', 'wor_goo_amount', 'wor_actual_price', 'wor_account_state', 'wor_type', 'wor_state', 'wor_delete', 'wocl_channel_unit', 'wocl_name', 'wocl_phone', 'wocl_car_num', 'wocl_province', 'wocl_city', 'wocl_county', 'wocl_address', 'wor_remark', 'wocl_client_id', 'wor_appoint_time', 'wocl_appoint_remark', 'wocl_car_brand_series', 'wocl_pick_up_car_time', 'wor_create_time', 'wor_province', 'wor_city', 'wor_county', 'wor_address', 'wocl_carowner_name', 'wocl_carowner_phone', 'wocl_car_vin', 'wor_explain', 'wocl_bus_name', 'wor_address_id', 'wor_address_type', 'wor_shop_id', 'wor_service_adm_id', 'wocl_carbrse_type', 'wor_work_type', 'wor_other_audit', 'wor_order_id', 'wor_list_pic', 'ord_new_type','ord_state', 'wor_need_return')
            ->orderBy('wor_id', 'desc')
            ->paginate($show_count);

        if(isset($search_data['is_excel']) && $search_data['is_excel']==2){
            $data['sqls'] = DB::getQueryLog()[1];
            $sqls = $data['sqls'];
            $excel = new CommonController();
            $amp_id = $search_data['amp_id']??0;
            return $excel->getExcelOut($amp_id,$user_info,$search_data['pri_id'], $sqls, $search_data['api_token'],200,'WashWork','工单列表');
        }
        $list_items = $list_data->items();
        // 获取枚举数据
        $object_enum = new WorkOrderEnum();
        $wor_work_type_enum = $object_enum->wor_work_type_enum;
        $wor_other_audit_enum = $object_enum->wor_other_audit_enum;

        if ($list_items) {
            $wor_work_type = array_column($wor_work_type_enum, 'state_show', 'state');
            $wor_other_audit = array_column($wor_other_audit_enum, 'state_show', 'state');

            $wor_id = array_column($list_items, 'wor_id'); //工单id
            $wor_create_id = array_unique(array_column($list_items, 'wor_create_id')); //录单人id

            // 查询商品、项目信息
            $work_goods = DB::table('work_good as wg')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'wg.wogo_goo_id')
                ->whereIn('wogo_wor_id', $wor_id)
                ->select('wogo_id', 'wogo_wor_id', 'wogo_goo_id', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_goo_amount', 'wogo_goo_price', 'wogo_goo_guarantee', 'wogo_goo_type', 'wogo_state','wogo_goo_unit', 'wogo_goo_unta_id', 'goo_unit_conversion')
                ->get()->toArray();
            $service_adm_id = array_filter(array_unique(array_column($list_items, 'wor_service_adm_id'))); //选的技师id
            $adm_id_merge = array_merge($wor_create_id, $service_adm_id);
            // 查询录单人信息
            $find_adm = DB::table('admin')
                ->whereIn('adm_id', $adm_id_merge)
                ->pluck('adm_name', 'adm_id')->toArray();

            foreach ($work_goods as $key => $value) {
                $work_goods[$key]->wogo_goo_amount = $value->wogo_goo_amount.$value->wogo_goo_unit;

            }
            $ord_new_type = DB::table('order_type')->where('orty_shop_id',$user_info->adm_shop_id)->pluck('orty_name','orty_id')->toArray();
            foreach ($list_items as $key => $value) {
//                $ord_new_type = DB::table('order')
//                    ->leftJoin('order_type', 'orty_id', '=', 'ord_new_type')
//                    ->where('ord_id', $value->wor_order_id)
//                    ->select('ord_new_type','orty_name')
//                    ->first();
//                $list_items[$key]->ord_new_type = $ord_new_type->ord_new_type;
//                $list_items[$key]->ord_new_type_name = $ord_new_type->orty_name;
                $list_items[$key]->ord_new_type_name = $ord_new_type[$value->ord_new_type] ?? '无标签';
                // 创建人
                if ($value->wor_create_id && isset($find_adm[$value->wor_create_id])) {
                    $list_items[$key]->adm_name = $find_adm[$value->wor_create_id];
                } else {
                    $list_items[$key]->adm_name = '';
                }
                $list_items[$key]->service_adm_name = '';//组长
                $list_items[$key]->team_members = '';//组员
                // if (isset($find_adm[$value->wor_service_adm_id])) {
                //     $list_items[$key]->service_adm_name = $find_adm[$value->wor_service_adm_id];
                // }
                $find_team_members = DB::table('wash_work_technician_part')
                    ->where('wotp_wor_id', $value->wor_id)
                    ->select('wotp_service_adm_id', 'wotp_service_adm_name', 'wotp_work_type')
                    ->get()->toArray();

                if ($find_team_members) {
                    $team_members = '';
                    foreach ($find_team_members as $key1 => $value1) {
                        switch ($value1->wotp_work_type) {
                            case '1':
                                $work_type_name = '取件';
                                break;
                            case '2':
                                $work_type_name = '维修';
                                break;
                            case '3':
                                $work_type_name = '还件';
                                break;
                            default:
                                $work_type_name = '取件';
                                break;
                        }
                        if ($team_members) {
                            $team_members = $team_members.','.$value1->wotp_service_adm_name.'('.$work_type_name.')';
                        } else {
                            $team_members = $value1->wotp_service_adm_name.'('.$work_type_name.')';
                        }
                    }
                    $list_items[$key]->team_members = $team_members;
                }
                // 施工地址
                if ($value->wor_address_type == 1) {//门店
                    $find_address = DB::table('shop')
                        ->where('shop_id', $value->wor_address_id)
                        ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                        ->first();
                    if ($find_address) {
                        $list_items[$key]->shop_store_name = $find_address->shop_store_name;
                        $list_items[$key]->wor_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                    } else {
                        $list_items[$key]->shop_store_name = '';
                        $list_items[$key]->wor_address = '';
                    }
                } elseif ($value->wor_address_type == 2) {//合作商
                    $find_address = DB::table('business_client')
                        ->where('bucl_id', $value->wor_address_id)
                        ->select('bucl_id', 'bucl_name', 'bucl_province', 'bucl_city', 'bucl_address', 'bucl_county')
                        ->first();
                    if ($find_address) {
                        $list_items[$key]->shop_store_name = $find_address->bucl_name;
                        $list_items[$key]->wor_address = $find_address->bucl_province.$find_address->bucl_city.$find_address->bucl_county.$find_address->bucl_address;
                    } else {
                        $list_items[$key]->shop_store_name = '';
                        $list_items[$key]->wor_address = '';
                    }
                } else {
                    $find_address = DB::table('shop')
                        ->where('shop_id', $value->wor_shop_id)
                        ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                        ->first();
                    if ($find_address) {
                        $list_items[$key]->shop_store_name = $find_address->shop_store_name;
                        $list_items[$key]->wor_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                    } else {
                        $list_items[$key]->shop_store_name = '';
                        $list_items[$key]->wor_address = '';
                    }
                }
                // 获取当前列表下的按钮
                $list_button = getListButton($search_data['api_token'], $search_data['pri_id']);
                foreach ($list_button as $key_b => $value_b) {
                    if ($value_b['pri_operate_method'] == 'info') {//详情
                        $list_items[$key]->button_one[] = $value_b;
                    }
                    if ($value_b['pri_operate_method'] == 'check' && $value->wor_state > 9 && $value->wor_state != 11) {//绩效核算
                        $list_items[$key]->button_two[] = $value_b;
                    }
                    if ($value_b['pri_operate_method'] == 'cancel' && $value->wor_state < 7) {//取消
                        $list_items[$key]->button_two[] = $value_b;
                    }
                    if ($value_b['pri_operate_method'] == 'assign' && $value->wor_state == 2) {//重新派单
                        $list_items[$key]->button_two[] = $value_b;
                    }
                    if ($value_b['pri_operate_method'] == 'withdraw' && ($value->wor_state == 3 || $value->wor_state == 5)) {//撤回工单
                        $list_items[$key]->button_two[] = $value_b;
                    }
                    if ($value_b['pri_operate_method'] == 'appointmentSet' && in_array($value->wor_state,[2,3,4,5])) {//预约设置
                        $list_items[$key]->button_two[] = $value_b;
                    }
                    if (in_array($value->ord_state, [1]) && $value_b['pri_operate_method'] == 'editOrderMember' && $value->wor_state<6 && in_array($value->wor_type, [0,1])) {//编辑客户
                        $list_items[$key]->button_two[] = $value_b;
                    }
                    if ($value_b['pri_operate_method'] == 'remark') {//备注
                        $list_items[$key]->button_two[] = $value_b;
                    }
                    if ($value_b['pri_operate_method'] == 'auditWork' && $value->wor_state == 8) {//审核施工信息
                        $list_items[$key]->button_two[] = $value_b;
                    }
                    // if ($value_b['pri_operate_method'] == 'toUserPic' && $value->wor_list_pic != 1 && $value->wor_state == 8) {//同步图片
                    //     $list_items[$key]->button_two[] = $value_b;
                    // }
                    // if ($value_b['pri_operate_method'] == 'cancelPic' && $value->wor_list_pic == 1 && $value->wor_state == 8) {//取消同步
                    //     $list_items[$key]->button_two[] = $value_b;
                    // }
                }
                $list_items[$key]->list_button = $list_button;
            }
            // 查询备注信息
            $order_reamrks = DB::table('order_remarks')
                ->whereIn('orre_wor_id', $wor_id)
                ->select('orre_create_adm_name', 'orre_content', 'orre_time', 'orre_wor_id', 'orre_module')
                ->orderby('orre_id', 'desc')
                ->get();

            // 查找操作记录
            $order_log = DB::table('order_log')
                ->whereIn('orlo_wor_id', $wor_id)
                ->orderBy('orlo_id', 'desc')
                ->select('orlo_wor_id', 'orlo_time', 'orlo_create_adm_name', 'orlo_content')
                ->get();
        } else {
            $work_goods = [];
            $order_log = [];
            $order_reamrks = [];
        }
        // 查询工单状态对应的工单数量
        $state_count = DB::table('work_order')
            ->where('wor_cid', $user_info->adm_cid)
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->where('wor_delete', 1)
            ->where('wor_classify', 2)
            ->where('wor_collection_bill', 1) //是否代收账单：1正常工单2代收账单
            ->select(DB::raw('count(*) as count, wor_state'))
            ->groupBy('wor_state')
            ->get();
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['work_goods'] = $work_goods;                //工单商品数据
        $data['state_count'] = $state_count;
        $data['order_log'] = $order_log;                    //操作记录
        $data['order_reamrks'] = $order_reamrks;           //工单备注
        $data['wor_work_type_enum'] = $wor_work_type_enum;
        $data['wor_other_audit_enum'] = $wor_other_audit_enum;
        $data['now_time'] = date('Y-m-d H:i:s');           //当前时间
        $wheres['wor_cid'] = $user_info->adm_cid;
        $wheres['wor_shop_id'] = $user_info->adm_shop_id;
        $wheres['wor_delete'] = 1;
        $wheres['wor_classify'] = 2;
        $wheres['wor_collection_bill'] = 1;
        $data['showcount'] = self::getStatusBar($wheres);
        return $data;
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取顶部状态栏
     * @param array $where 查询条件
     * @retrun /multitype:array
     * @author dou 2023-06-06 006 下午 3:45:04
     * |---------------------------------------------------------------------------------
     */
    public static function getStatusBar ($where){
        $showcount = [
            ['showname' => "全部", 'shownum' => '0','wor_state'=>0],
            ['showname' => "退回待派单", 'shownum' => '0','wor_state'=>2],
            // ['showname' => "待接单", 'shownum' => '0','wor_state'=>3],
            ['showname' => "待验件", 'shownum' => '0','wor_state'=>5],
            // ['showname' => "待施工", 'shownum' => '0','wor_state'=>6],
            ['showname' => "施工中", 'shownum' => '0','wor_state'=>7],
            ['showname' => "维修完成待审核", 'shownum' => '0','wor_state'=>8],
            ['showname' => "还件", 'shownum' => '0','wor_state'=>9],
            ['showname' => "完成待核算", 'shownum' => '0','wor_state'=>10],
            ['showname' => "取消待审核", 'shownum' => '0','wor_state'=>11],
            ['showname' => "完成", 'shownum' => '0','wor_state'=>12],
        ];
        foreach( $showcount as $k => $v ){
            $showcount[$k]['shownum'] = self::getStatusNum($v['wor_state'],$where);
        }
        return $showcount;
    }

    /**
     * 获取指定状态数量
     * @param string $status 状态栏参数
     * @param array $where 查询条件
     * @return /multitype:array
     * @author dou 2023-06-06 006 下午 3:45:04
     */
    public static function getStatusNum ( $status,$where){
        if($status > 0){
            $db = new WashWork();
            $where['wor_state'] = $status;
            $num = CommonService::getMysqlData($db,$where,[],[],'count');
            $num = $num??'0';
            return $num;
        }else{
            return '--';
        }
    }

    public function planIndex($user_info, $search_data, $show_count = 10)
    {
        // 排班计划
        $list_data = DB::table('work_plan as wopl')
            ->leftJoin('order as o', 'o.ord_id', '=', 'wopl.wopl_ord_id')
            ->where('wopl_shop_id', $user_info->adm_shop_id)
            ->where('wopl_delete', 1)
            ->where('ord_wor_state', '!=', 11)
            ->where('ord_add_work_state', 1)
            ->where(function ($query) use ($search_data) { //服务项目
                if (!empty($search_data['sepr_id'])) {
                    $query->where('wopl_sepr_id','like', '%' .','.$search_data['sepr_id'].','.'%');
                }
            })
            ->where(function ($query) use ($search_data) { //施工地址
                if (!empty($search_data['wopl_address_type']) && !empty($search_data['wopl_address_id'])) {
                    $query->where('wopl_address_type', $search_data['wopl_address_type'])
                        ->where('wopl_address_id', $search_data['wopl_address_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //施工技师
                if (!empty($search_data['adm_id'])) {
                    $query->where('wopl_service_id', 'like', '%' .','.$search_data['adm_id'].','.'%');
                }
            })
            ->where(function ($query) use ($search_data) { //订单类型
                if (!empty($search_data['ord_new_type'])) {
                    $query->where('wopl_ord_new_type', $search_data['ord_new_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //销售人
                if (!empty($search_data['wopl_sale_id'])) {
                    $query->where('wopl_sale_id', $search_data['wopl_sale_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间/派单时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('wopl_date', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('wopl_date', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('wopl_date', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('wopl_id', 'wopl_wor_id', 'wopl_sepr_name', 'wopl_sepr_id', 'wopl_address', 'wopl_sale_name', 'wopl_service_id', 'wopl_time', 'wopl_date', 'wopl_explain', 'wopl_goo_name', 'wopl_ord_new_type')
            ->orderBy('wopl_date', 'desc')
            ->groupBy('wopl_date')
            ->paginate($show_count);
        $list_items = $list_data->items();
        $new_list = [];
        if ($list_items) {
            $wopl_date=array_column($list_items,'wopl_date');
            foreach ($wopl_date as $key => $value) {
                $get_shop_reservenum =DB::table('shop_reservenum')
                    ->where('resenum_shop_id', $user_info->adm_shop_id)
                    ->where('resenum_type', 2)
                    ->where(function ($query) use ($search_data) { //订单类型
                        if (!empty($search_data['ord_new_type'])) {
                            $query->where('resenum_new_type', $search_data['ord_new_type']);
                        }
                    })
                    ->where('resenum_date', $value)
                    ->select(DB::raw('sum(resenum_num) as count, resenum_date'))
                    ->get();
                if ($get_shop_reservenum) {
                    $resenum[$get_shop_reservenum[0]->resenum_date] = $get_shop_reservenum[0]->count;
                }
            }
            // if(!empty($resenum)){
            //     $resenum=json_decode(json_encode($resenum),true);
            //     $resenum=array_column($resenum,'resenum_num','resenum_date');
            // }
            $wopl_date = array_column($list_items, 'wopl_date'); //预约日期
            foreach ($list_items as $key => $value) {
                
                $set = DB::table('shop_reservenum')
                    ->leftJoin('order_type', 'orty_id', '=', 'resenum_new_type')
                    ->where('resenum_shop_id', $user_info->adm_shop_id)
                    ->where('resenum_type', 2)
                    ->where('resenum_date', $value->wopl_date)
                    ->select('resenum_num', 'orty_name', 'resenum_date', 'resenum_new_type')
                    ->get();
                if (!empty($set)) {
                    foreach ($set as $k => $v) {
                        $set[$k]->ord_nums = DB::table('work_plan as wopl')
                            ->where('wopl_shop_id', $user_info->adm_shop_id)
                            ->where('wopl_delete', 1)
                            ->where('wopl_ord_new_type', $v->resenum_new_type)
                            ->where('wopl_date', $v->resenum_date)
                            ->count();
                    }
                }
                $new_list[$key]['set'] = $set;
                $new_list[$key]['date'] = $value->wopl_date;
                // $post_data['ord_new_type'] = $value->wopl_ord_new_type;
                $or_num=static::orderAppoinSum($user_info,$value->wopl_date,$search_data);
                if(isset($resenum[$value->wopl_date])){
                    $new_list[$key]['type']=2;  // 1 没有限制   2 有限制
                    $new_list[$key]['resenum_num']=$resenum[$value->wopl_date];  // 限制数量
                    $new_list[$key]['order_count']=$or_num['num'];  // 订单预约总数量
                    $new_list[$key]['surplus']=$new_list[$key]['resenum_num']-$new_list[$key]['order_count']; // 剩余可预约数量
                }else{
                    $new_list[$key]['type']=1;
                    $new_list[$key]['resenum_num']=0;
                    $new_list[$key]['order_count']=$or_num['num'];
                    $new_list[$key]['surplus']=0;
                }
                $new_list[$key]['data'] = DB::table('work_plan as wopl')
                    ->leftJoin('order as o', 'o.ord_id', '=', 'wopl.wopl_ord_id')
                    ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'wopl.wopl_ord_id')
                    ->leftJoin('order_type as ot', 'orty_id', '=', 'wopl.wopl_ord_new_type')
                    ->where('wopl_shop_id', $user_info->adm_shop_id)
                    ->where('wopl_delete', 1)
                    ->where('ord_wor_state', '!=', 11)
                    ->where('ord_add_work_state', 1)
                    ->where('wopl_date', $value->wopl_date)
                    ->where(function ($query) use ($search_data) { //服务项目
                        if (!empty($search_data['sepr_id'])) {
                            $query->where('wopl_sepr_id','like', '%' .','.$search_data['sepr_id'].','.'%');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //施工地址
                        if (!empty($search_data['wopl_address_type']) && !empty($search_data['wopl_address_id'])) {
                            $query->where('wopl_address_type', $search_data['wopl_address_type'])
                                ->where('wopl_address_id', $search_data['wopl_address_id']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //施工技师
                        if (!empty($search_data['adm_id'])) {
                            $query->where('wopl_service_id', 'like', '%' .','.$search_data['adm_id'].','.'%');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //销售人
                        if (!empty($search_data['wopl_sale_id'])) {
                            $query->where('wopl_sale_id', $search_data['wopl_sale_id']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //销售人
                        if (!empty($search_data['ord_new_type'])) {
                            $query->where('wopl_ord_new_type', $search_data['ord_new_type']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //创建时间/派单时间
                        // 如果选择开始时间并且选择结束时间
                        if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                            $query->whereBetween('wopl_date', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                        } else {
                            // 如果选择开始时间
                            if (!empty($search_data['create_time_start'])) {
                                $query->where('wopl_date', '>=', $search_data['create_time_start']);
                            } else {
                                // 如果选择结束时间
                                if (!empty($search_data['create_time_end'])) {
                                    $query->where('wopl_date', '<=', $search_data['create_time_end'] . ' 23:59:59');
                                }
                            }
                        }
                    })
                    ->select('wopl_id', 'wopl_wor_id', 'wopl_sepr_name', 'wopl_sepr_id', 'wopl_address', 'wopl_sale_name', 'wopl_service_id', 'wopl_time', 'wopl_date', 'wopl_explain', 'wopl_goo_name', 'orcl_car_brand_series', 'wopl_ord_new_type','orty_name')
                    ->orderBy('wopl_time', 'desc')
                    ->get()->toArray();
            }
            foreach ($new_list as $key => $value) {
                foreach ($value['data'] as $key1 => $value1) {
                    $service_adm_id = rtrim($value1->wopl_service_id, ',');
                    $service_adm_id = ltrim($service_adm_id, ',');
                    $service_adm_id = explode(',', $service_adm_id);
                    $find_admin = DB::table('admin')
                        ->whereIn('adm_id', $service_adm_id)
                        ->select('adm_name')
                        ->get()->toArray();
                    $adm_name = '';
                    foreach ($find_admin as $key2 => $value2) {
                        if (empty($adm_name)) {
                            $adm_name = $value2->adm_name;
                        } else {
                            $adm_name = $adm_name.','.$value2->adm_name;
                        }
                    }
                    if ($find_admin) {
                        $new_list[$key]['data'][$key1]->service_adm_name = $adm_name;
                    }
                }
            }
        }
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $new_list;                        //返回数据
        return $data;
    }

    // 技师小程序-首页技师预约信息
    public function homePage($user_info, $search_data, $show_count = 10)
    {
        $list_data = DB::table('work_order as b')
            ->leftJoin('work_client as c', 'c.wocl_wor_id', '=', 'b.wor_id')
            ->where('wor_cid', $user_info->adm_cid)
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->where('wor_service_adm_id', $user_info->adm_id)
            ->where('wor_delete', 1)
            ->where('wor_state', '<>', 2)
            ->where('wor_collection_bill', 1) //是否代收账单：1正常工单2代收账单
            ->where(function ($query) use ($search_data) { //关键字搜索
                if (!empty($search_data['keywords'])) {
                    $query->where('wor_order_number', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('wor_number', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('wocl_phone', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('wocl_car_num', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('wocl_name', 'like', '%' . $search_data['keywords'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //订单号
                if (!empty($search_data['wor_order_number'])) {
                    $query->where('wor_order_number', 'like', '%' . $search_data['wor_order_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //工单号
                if (!empty($search_data['wor_number'])) {
                    $query->where('wor_number', 'like', '%' . $search_data['wor_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //客户单位
                if (!empty($search_data['wocl_channel_unit'])) {
                    $query->where('wocl_channel_unit', 'like', '%' . $search_data['wocl_channel_unit'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //姓名
                if (!empty($search_data['wocl_name'])) {
                    $query->where('wocl_name', 'like', '%' . $search_data['wocl_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //联系电话
                if (!empty($search_data['wocl_phone'])) {
                    $query->where('wocl_phone', 'like', '%' . $search_data['wocl_phone'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //车牌号
                if (!empty($search_data['wocl_car_num'])) {
                    $query->where('wocl_car_num', 'like', '%' . $search_data['wocl_car_num'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //车型
                if (!empty($search_data['wocl_car_vehicle_type'])) {
                    $query->where('wocl_car_vehicle_type', 'like', '%' . $search_data['wocl_car_vehicle_type'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //订单类型1会员零售2客户单位3速电派单
                if (!empty($search_data['wor_type'])) {
                    $query->where('wor_type', $search_data['wor_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //1.新订单 2未派单 3待接单 5.待验车 6.待施工（显示开始施工按钮） 7施工中（提交施工按钮） 8.完成待核算 10核算完成
                if (!empty($search_data['wor_state'])) {
                    $query->where('wor_state', $search_data['wor_state']);
                }
            })
            ->where(function ($query) use ($search_data) { //派单人
                if (!empty($search_data['wor_create_id'])) {
                    $query->where('wor_create_id', $search_data['wor_create_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //备注
                if (!empty($search_data['wor_remark'])) {
                    $query->where('wor_remark', 'like', '%' . $search_data['wor_remark'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //订单类型
                if (!empty($search_data['wor_service_type'])) {
                    $query->where('wor_service_type', $search_data['wor_service_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间/派单时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('wor_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('wor_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('wor_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //客户id/会员id
                if (!empty($search_data['wocl_client_id'])) {
                    $query->where('wocl_client_id', $search_data['wocl_client_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //预约时间
                if (!empty($search_data['wor_appoint_time'])) {
                    $query->where('wor_appoint_time', 'like', $search_data['wor_appoint_time'] . '%');
                }
            })
            ->select('wor_id', 'wor_number', 'wor_order_number', 'wor_type', 'wor_state', 'wor_remark', 'wor_appoint_time', 'wocl_appoint_remark', 'wocl_car_vehicle_type', 'wocl_pick_up_car_time', 'wocl_check_car_state', 'wor_service_adm_id', 'wor_province', 'wor_city', 'wor_county', 'wor_address')
            ->orderBy('wor_id', 'desc')
            ->paginate($show_count);

        $list_items = $list_data->items();

        if ($list_items) {
            $wor_id = array_column($list_items, 'wor_id'); //工单id
            $wor_create_id = array_unique(array_column($list_items, 'wor_create_id')); //录单人id
            $service_adm_id = array_filter(array_unique(array_column($list_items, 'wor_service_adm_id'))); //选的技师id
            $adm_id_merge = array_merge($wor_create_id, $service_adm_id);
            // 查询录单人信息
            $find_adm = DB::table('admin')
                ->whereIn('adm_id', $adm_id_merge)
                ->pluck('adm_name', 'adm_id')->toArray();

            foreach ($list_items as $key => $value) {
                // 技师名称
                if ($value->wor_service_adm_id) {
                    $list_items[$key]->service_adm_name = $find_adm[$value->wor_service_adm_id];
                } else {
                    $list_items[$key]->service_adm_name = '';
                }
            }
        }

        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据

        $data['now_time'] = date('Y-m-d H:i:s');           //当前时间
        return $data;
    }

    // 首页-预约汇总、排行榜
    public function homeCollect($user_info, $search_data)
    {
        // 待完成单数，查询当前技师的相关的未提交完成的工单
        $wait_finish_amount = DB::table('wash_work_technician_part as a')
            ->leftJoin('work_order as b', 'b.wor_id', '=', 'a.wotp_wor_id')
            ->where('wotp_shop_id', $user_info->adm_shop_id)
            ->where('wotp_service_adm_id', $user_info->adm_id)
            ->where('wor_delete', 1)
            ->where('wor_classify', 2) //工单分类：1蓄电池2洗美店3易损件
            ->where('wor_collection_bill', 1) //是否代收账单：1正常工单2代收账单
            ->where('wor_service_state', '<', 6) //服务状态：1待接单2已接单3预约4出发5抵达/施工中6完成待审核
            ->select(DB::raw('count(*) as count'))
            ->first();
        $collect['wait_finish_amount'] = $wait_finish_amount->count; //等待完成单数
        // 预约天数,查询技师的预约时间
        $appoint_time = DB::table('wash_work_technician_part as a')
            ->leftJoin('work_order as b', 'b.wor_id', '=', 'a.wotp_wor_id')
            ->where('wotp_shop_id', $user_info->adm_shop_id)
            ->where('wotp_service_adm_id', $user_info->adm_id)
            ->where('wor_delete', 1)
            ->where('wor_classify', 2) //工单分类：1蓄电池2洗美店3易损件
            ->where('wor_collection_bill', 1) //是否代收账单：1正常工单2代收账单
            ->where('wor_service_state', '<', 6) //服务状态：1待接单2已接单3预约4出发5抵达/施工中6完成待审核
            ->where('wor_appoint_time', '<>', '0000-00-00 00:00:00') //预约时间
            ->orderBy('wor_appoint_time', 'asc')
            ->select('wor_appoint_time')
            ->get()->toArray();
        $now_time = date('Y-m-d H:i:s'); //当前时间
        if ($appoint_time) {
            $appoint_days = []; //预约时间
            foreach ($appoint_time as $key => $value) {
                $appoint_days[] = substr($value->wor_appoint_time, 0, 10); //截取预约时间
            }

            // 计算两个时间的天数差
            $collect['appoint_days'] = count(array_unique($appoint_days)); //预约天数
        } else {
            $collect['appoint_days'] = 0; //预约天数
        }

        // 查询当前年月的门店的技师的单量排行
        $now_year_month = date('Y-m');
        $list_data = DB::table('wash_performance_work')
            ->where('pewo_shop_id', $user_info->adm_shop_id)
            ->where('pewo_create_time', 'like', $now_year_month . '%')
            // ->select(DB::raw('count(pewo_wor_id) as count,pewo_service_adm_id,pewo_service_adm_name as adm_name'))
            ->select(
                DB::raw('count(DISTINCT pewo_wor_id) as count'), // 按工单ID去重统计
                'pewo_service_adm_id',
                'pewo_service_adm_name as adm_name'
            )
            ->groupBy('pewo_service_adm_id')
            ->orderBy('count', 'desc')
            ->offset(0)->limit(5)
            ->get()->toArray();

        // 单量排行
        $ranking_count = [];
        foreach ($list_data as $key => $value) {
            $ranking_count[$key]['sequence'] = $key + 1;
            $ranking_count[$key]['adm_name'] = $value->adm_name;
            $ranking_count[$key]['count'] = $value->count;
        }
        // 单量排行

        // 查询当前年月的门店的技师的分数排行
        $list_data = DB::table('wash_performance_work')
            ->where('pewo_shop_id', $user_info->adm_shop_id)
            ->where('pewo_create_time', 'like', $now_year_month . '%')
            ->select(DB::raw('sum(pewo_score) as count1, round(AVG(pewo_score),2) as count, pewo_service_adm_id, pewo_service_adm_name as adm_name, count(pewo_id) as pewo_count'))
            ->orderBy('count', 'desc')
            ->groupBy('pewo_service_adm_id')
            ->offset(0)->limit(5)
            ->get()->toArray();
        // 得分排行
        $ranking_score = [];
        foreach ($list_data as $key => $value) {
            $ranking_score[$key]['sequence'] = $key + 1;
            $ranking_score[$key]['adm_name'] = $value->adm_name;
            // $ranking_score[$key]['count1'] = round($value->count/$value->pewo_count, 2);
            $ranking_score[$key]['count'] = $value->count;
        }

        // 排行榜
        $ranking_list['ranking_count'] = $ranking_count;
        $ranking_list['ranking_score'] = $ranking_score;

        $data['collect'] = $collect;                        //预约汇总
        $data['ranking_list'] = $ranking_list;                        //排行榜
        return $data;
    }

    // 首页-预约时间
    public function homeAppointTime($user_info, $search_data)
    {
        if (empty($search_data['wor_appoint_time'])) {
            $search_data['wor_appoint_time'] = date('Y-m');
        }
        $list_data = DB::table('work_order')
            ->where('wor_cid', $user_info->adm_cid)
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->where('wor_service_adm_id', $user_info->adm_id)
            ->where('wor_delete', 1)
            ->whereIn('wor_state', [1, 2, 3, 4, 5, 6])
            ->where('wor_appoint_time', 'like', $search_data['wor_appoint_time'] . '%')
            ->where('wor_collection_bill', 1) //是否代收账单：1正常工单2代收账单
            ->select('wor_appoint_time')
            ->orderBy('wor_id', 'desc')
            ->groupBy('wor_appoint_time')
            ->get()->toArray();
        return $list_data;
    }

    // 首页-排班计划预约时间
    public function planAppointTime($user_info, $search_data)
    {
        if (empty($search_data['wopl_time'])) {
            $search_data['wopl_time'] = date('Y-m');
        }
        $list_data = DB::table('work_plan as wopl')
            ->leftJoin('order as o', 'o.ord_id', '=', 'wopl.wopl_ord_id')
            ->where('wopl_shop_id', $user_info->adm_shop_id)
            ->where('wopl_delete', 1)
            ->where('ord_wor_state', '!=', 11)
            ->where('ord_add_work_state', '!=', 2)
            ->where('wopl_date', 'like', $search_data['wopl_time'] . '%')
            ->selectRaw('wopl_date,count(wopl_id) as num')
            ->orderBy('wopl_id', 'desc')
            ->groupBy('wopl_date')
            ->get()->toArray();
        return $list_data;
    }

    // 计划预约数量  孔圣寅
    public function planAppointNum($user_info, $search_data)
    {
        if (empty($search_data['wopl_time'])) {
            $search_data['wopl_time'] = date('Y-m');
        }
        $list_data = DB::table('shop_reservenum')
            ->leftJoin('order_type', 'orty_id', '=', 'resenum_new_type')
            ->where('resenum_shop_id', $user_info->adm_shop_id)
            ->where('resenum_type', 2)
            ->where('resenum_month', $search_data['wopl_time'])
            ->select('resenum_date','resenum_num', 'resenum_new_type', 'orty_name')
            ->orderBy('resenum_date', 'desc')
            ->get()->toArray();
        return $list_data;
    }

    // 设置预约数量  孔圣寅
    public static function planappSetnum($user_info, $request){
        if (empty($request['wopl_date'])) {
            $request['wopl_date'] = date('Y-m-d');
        }
        if (empty($request['resenum_type']) || !in_array($request['resenum_type'],[1,2])) {
            $request['resenum_type'] = 1;
        }
        if (empty($request['resenum_num'])) {
            $request['resenum_num'] = 0;
        }
        if($request['resenum_type']==2 && !$request['resenum_num']){
            return ['code'=>ErrorInc::INVALID_PARAM, 'msg'=>'必须设置预约数量', 'data'=>''];
        }

        // 日期判断是今天之后的
        if(strtotime($request['wopl_date'].'23:59:59') < time()){
            return ['code'=>ErrorInc::INVALID_PARAM, 'msg'=>'选择今日或之后的日期', 'data'=>''];
        }
        // 如果限制数量，则查询某日排班总数量进行判断；
        if($request['resenum_type']==2){
            $post_data['ord_new_type'] = $request['resenum_new_type'];
            // 查询某日排班数量的总数
            $num_res=static::orderAppoinSum($user_info,$request['wopl_date'], $post_data);

            if($request['resenum_num'] < $num_res['num']){
                return ['code'=>ErrorInc::INVALID_PARAM, 'msg'=>'设置预约数量不可小于已预约数量', 'data'=>''];
            }
        }

        $res_data=[];
        $res_data['resenum_shop_id'] =$user_info->adm_shop_id;
        $res_data['resenum_type']    =$request['resenum_type'];
        $res_data['resenum_new_type']    = $request['resenum_new_type'];
        $res_data['resenum_num']     =(int)$request['resenum_num'];
        $res_data['resenum_month']   =substr($request['wopl_date'],0,7);
        $res_data['resenum_date']    =$request['wopl_date'];
        $res_data['resenum_updatime']=date("Y-m-d H:i:s");
        $resenum_id=DB::table('shop_reservenum')
            ->where('resenum_shop_id', $user_info->adm_shop_id)
            ->where('resenum_date', $request['wopl_date'])
            ->where('resenum_new_type', $request['resenum_new_type'])
            ->select('resenum_id')
            ->first();
        if(empty($resenum_id)){
            $res_data['resenum_create_id'] =$user_info->adm_id;
            $res_data['resenum_creatime']=date("Y-m-d H:i:s");
            $res=DB::table('shop_reservenum')
                ->insert($res_data);
        }else{
            $res=DB::table('shop_reservenum')
                ->where('resenum_id',$resenum_id->resenum_id)
                ->update($res_data);
        }
        if($res){
            if ($request['resenum_type'] == 1) {
                return ['code'=>200, 'msg'=>'预约数量限制已关闭', 'data'=>'','res'=>$request['wopl_date']." 设置数量:".$request['resenum_num']];
            } elseif ($request['resenum_type'] == 2) {
                return ['code'=>200, 'msg'=>'设置预约数量成功', 'data'=>'','res'=>$request['wopl_date']." 设置数量:".$request['resenum_num']];
            }
        }else{
            return ['code'=>ErrorInc::ERROR, 'msg'=>'设置预约数量失败', 'data'=>''];
        }
    }

    // 根据预约排班时间获取当日可以预约数量和已预约数量 woch_check_res
    public static function appoinTimeJudge($user_info, $request){
        if(empty($request['wopl_time'])){
            return ['code'=>ErrorInc::FAILED_PARAM, 'msg'=>'缺少预约时间', 'data'=>''];
        }
        if(!isset($request['resenum_new_type']) || empty($request['resenum_new_type'])){
            return ['code'=>ErrorInc::FAILED_PARAM, 'msg'=>'缺少订单分类', 'data'=>''];
        }
        if(strlen($request['wopl_time']) > 10){
            $request['wopl_time']=substr($request['wopl_time'],0,10);
        }
        if(strtotime($request['wopl_time']." 23:59:59") < time()){
            return ['code'=>ErrorInc::INVALID_PARAM, 'msg'=>'您的预约时间已过期，请重新选择', 'data'=>''];
        }
        // 先获取 类型是有限制的本门店的某天的限制数据
        $resenum=DB::table('shop_reservenum')
            ->where('resenum_shop_id', $user_info->adm_shop_id)
            ->where('resenum_type', 2)
            ->where('resenum_new_type', $request['resenum_new_type'])
            ->where('resenum_date', $request['wopl_time'])
            ->select('resenum_num')
            ->first();
        if(empty($resenum)){
            $data=[
                'type'=>1,
                'resenum_num'=>0,
                'order_count'=>0,
                'surplus'=>0
            ];

        }else{
            $request['ord_new_type'] = $request['resenum_new_type'];
            // 查询某日排班数量的总数
            $num_res=static::orderAppoinSum($user_info,$request['wopl_time'],$request);
            $data=[
                'type'=>2,
                'resenum_num'=>$resenum->resenum_num,
                'order_count'=>$num_res['num'],
                'surplus'=>$resenum->resenum_num-$num_res['num'],
            ];
        }
        return [
            'code'=>200,
            'msg'=>'success',
            'data'=>$data
        ];
    }
    // 返回某个门店某天的预约总数
    private static function orderAppoinSum($user_info, $wopl_date, $request = []){
        $num = DB::table('work_plan as wopl')
            ->leftJoin('order as ord', 'ord.ord_id', '=', 'wopl.wopl_ord_id')
            ->where('wopl_shop_id', $user_info->adm_shop_id)
            ->where('wopl_delete', 1)
            ->where(function ($query) use ($request) { //订单类型1会员零售2客户单位3速电派单
                if (!empty($request['ord_new_type'])) {
                    $query->where('wopl_ord_new_type', $request['ord_new_type']);
                }
            })
            ->where('ord_wor_state', '!=', 11)
            ->where('ord_add_work_state', 1)
            ->where('wopl_date', $wopl_date)
            ->count();

        return ['num'=>$num];
    }

    // 判断门店预约是否超出了限定的数量
    /**
     * 判断门店预约是否超出了限定的数量
     * 快速开单，生成工单，和订单查询回调用
     * @param  [type] $user_info 用户数据
     * @param  [type] $resenum_date 预约时间
     * @param  [type] $old_date  旧的预约时间
     * @return [type]            [description]
     */
    public static function judgmentShopReser($user_info,$resenum_date,$old_date='',$request= []){
        $resenum=DB::table('shop_reservenum')
            ->where('resenum_shop_id', $user_info->adm_shop_id)
            ->where('resenum_type', 2)
            ->where('resenum_new_type', $request['ord_new_type'])
            ->where('resenum_date', $resenum_date)
            ->select('resenum_num')//限制的预约数量
            ->first();
        if(empty($resenum)){
            return ['code'=>200];
        }
        // 截取前十位
        if(strlen($old_date) > 10){
            $old_date=substr($old_date,0,10);
        }
        if($old_date=="0000-00-00"){
            $old_date='';
        }

        // 查询某日排班数量的总数
        $num_res=static::orderAppoinSum($user_info,$resenum_date,$request);
        // 如果是大于则直接返回成功
        // 如果限制数量和已预约的数量相等，则判断旧的预约日期是否与本次预约日期相等，如果相等也可以跳过判断
        if($resenum->resenum_num > $num_res['num'] || ($resenum->resenum_num == $num_res['num'] && $resenum_date==$old_date)){
            return ['code'=>200];
        }else{
            // 如果小于，则本身就有问题，更别说大于限制预约单量了
            return ['code'=>ErrorInc::ERROR, 'msg'=>$resenum_date.'已达到预约上限,暂不能预约', 'data'=>''];
        }
    }

    // 小程序排班计划
    public function planappIndex($user_info, $request, $show_count = 50)
    {
        if (empty($request['wopl_date'])) {
            $request['wopl_date'] = date('Y-m-d');
        }
        // 排班计划
        $list_data = DB::table('work_plan as wopl')
            ->leftJoin('order as o', 'o.ord_id', '=', 'wopl.wopl_ord_id')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'wopl.wopl_ord_id')
            ->leftJoin('work_order as wor', 'wor.wor_id', '=', 'wopl.wopl_wor_id')
            ->where('wopl_shop_id', $user_info->adm_shop_id)
            ->where('wopl_delete', 1)
            ->where('ord_wor_state', '!=', 11)
            ->where('ord_add_work_state', '!=', 2)
            ->where(function ($query) use ($request) { //订单号
                if (!empty($request['wopl_ord_new_type'])) {
                    $query->where('wopl_ord_new_type', $request['wopl_ord_new_type']);
                }
            })
            ->where('wopl_date', $request['wopl_date'])
            ->select('wopl_id', 'wopl_wor_id', 'wopl_sepr_name', 'wopl_sepr_id', 'wopl_address', 'wopl_sale_name', 'wopl_service_id', 'wopl_time', 'wopl_date', 'wopl_explain', 'wopl_goo_name', 'wor_number', 'ord_order_number', 'wor_state', 'wopl_ord_id', 'orcl_carowner_name', 'orcl_carowner_phone', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'wor_service_adm_id', 'orcl_car_brand_series', 'ord_wor_state', 'wopl_ord_new_type', 'orcl_client_id', 'ord_client_id', 'ord_type')
            ->orderBy('wopl_time', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        $level_arr = [0=>'普通会员',1=>'白银会员',2=>'黄金会员',3=>'铂金会员',4=>'钻石会员',5=>'黑钻会员'];
        if ($list_items) {
            foreach ($list_items as $key => $value) {
                $list_items[$key]->wopl_date = $value->wopl_date .' '. $value->wopl_time;
                $list_items[$key]->mem_car_color = '';
                $list_items[$key]->mem_source = '';
                $mem_label_name = [];
                $list_items[$key]->mem_label_name = $mem_label_name;
                $list_items[$key]->mem_level_name = '';
                $list_items[$key]->mem_salesman_name = '';
                if ($value->ord_type == 1) {//1门店零售2企业会员
                    $find_mem = DB::table('member')
                        ->where('mem_id', $value->ord_client_id)
                        ->first();
                    $list_items[$key]->mem_car_color = $find_mem->mem_car_color;
                    $list_items[$key]->mem_source = $find_mem->mem_source;
                    //查找店铺会员标签
                    $find_label = DB::table('member_label as ml')
                        ->leftJoin('label as l', 'ml.melal_label_id', '=', 'l.mela_id')
                        ->where('melal_cid', $user_info->adm_cid)
                        ->where('melal_shop_id', $user_info->adm_shop_id)
                        ->where('melal_mem_id', $find_mem->mem_id)
                        ->where('mela_is_show', 1)
                        ->get()->toArray();
                    
                    foreach ($find_label as $key_label => $value_label) {
                        $mem_label_name[] = $value_label->mela_name;
                    }
                    $list_items[$key]->mem_label_name = $mem_label_name;
                    $list_items[$key]->mem_level_name = $level_arr[$find_mem->mem_level];
                    if (empty($find_mem->mem_salesman_id)) {
                        $list_items[$key]->mem_salesman_name = '';
                    } else {
                        $list_items[$key]->mem_salesman_name = DB::table('admin')->where('adm_id', $find_mem->mem_salesman_id)->value('adm_name');
                    }
                } elseif ($value->ord_type == 2) {

                }
                $service_adm_id = rtrim($value->wopl_service_id, ',');
                $service_adm_id = ltrim($service_adm_id, ',');
                $service_adm_id = explode(',', $service_adm_id);
                $find_admin = DB::table('admin')
                    ->whereIn('adm_id', $service_adm_id)
                    ->select('adm_name', 'adm_id')
                    ->get()->toArray();
                $adm_name = '';//组员
                $adm_names = '';
                foreach ($find_admin as $key2 => $value2) {
                    if (empty($adm_name)) {
                        if ($value2->adm_id == $value->wor_service_adm_id) {
                            $adm_names = $value2->adm_name.'(组长)';
                        } else {
                            $adm_name = $value2->adm_name;
                        }
                    } else {
                        if ($value2->adm_id == $value->wor_service_adm_id) {
                            $adm_names = $value2->adm_name.'(组长)';
                        } else {
                            $adm_name = $adm_name.','.$value2->adm_name;
                        }
                    }
                }
                if ($find_admin) {
                    if (!empty($adm_name)) {
                        $list_items[$key]->service_adm_name = $adm_names.','.$adm_name;
                    } else {
                        $list_items[$key]->service_adm_name = $adm_names;
                    }
                } else {
                    $list_items[$key]->service_adm_name = '';
                }

                if ($value->wopl_wor_id) {
                    $list_items[$key]->type = 2;
                } else {
                    $list_items[$key]->type = 1;//订单
                }
                $list_items[$key]->goods_data = DB::table('order_goods as orgo')
                    ->leftJoin('goods as g', 'orgo.orgo_goo_id', '=', 'g.goo_id')
                    ->where('orgo_ord_id', $value->wopl_ord_id)
                    ->select('orgo_id', 'orgo_goo_name', 'orgo_goo_quantity', 'orgo_goo_unit', 'goo_unit_conversion', 'orgo_goo_unta_id')
                    ->get()->toArray();
                if (!empty($value->wopl_ord_new_type)) {
                    $wopl_ord_new_type[] = $value->wopl_ord_new_type;
                }
            }
            if (!empty($wopl_ord_new_type)) {
                $wopl_ord_new_type = array_unique($wopl_ord_new_type);
            }

        } else {
            $list_items = [];
            $wopl_ord_new_type = [];
            // return $list_items;
        }

        // 排班计划
        $ord_state_count = DB::table('work_plan as wopl')
            ->leftJoin('order as ord', 'ord.ord_id', '=', 'wopl.wopl_ord_id')
            ->where('wopl_shop_id', $user_info->adm_shop_id)
            ->where('wopl_delete', 1)
            ->where('ord_add_work_state', '!=', 2)
            ->where('ord_wor_state', '!=', 11)
            ->where('wopl_wor_id', '=', '')
            ->where('wopl_date', $request['wopl_date'])
            ->select(DB::raw('count(*) as count'))
            ->get();

        // 查询工单状态对应的工单数量
        $wor_state_count = DB::table('work_plan as wopl')
            ->leftJoin('work_order as wor', 'wor.wor_id', '=', 'wopl.wopl_wor_id')
            ->leftJoin('order as o', 'o.ord_id', '=', 'wor.wor_order_id')
            ->where('wopl_shop_id', $user_info->adm_shop_id)
            ->where('wopl_delete', 1)
            ->where('wopl_wor_id', '!=', '')
            ->where('ord_add_work_state', '!=', 2)
            ->where('wopl_date', $request['wopl_date'])
            ->select(DB::raw('count(*) as count, wor_state'))
            ->groupBy('wor_state')
            ->get();
        $ord_state = 0;
        if (!empty($ord_state_count)) {
            $ord_state = $ord_state_count[0]->count;
        }
        $wor_state = 0;//待派工单
        $wor_state0 = 0;//待接单
        $wor_state1 = 0;//施工中
        $wor_state2 = 0;//已完成
        if (!empty($wor_state_count)) {
            foreach ($wor_state_count as $key => $value) {
                if ($value->wor_state == 2) {//待派工单
                    $wor_state = $value->count;
                }
                if ($value->wor_state == 3) {
                    $wor_state0 = $value->count;
                }
                if ($value->wor_state == 5 || $value->wor_state == 6 || $value->wor_state == 7) {//施工中
                    $wor_state1 += $value->count;
                }
                if ($value->wor_state == 8 || $value->wor_state == 10) {//施工中
                    $wor_state2 += $value->count;
                }
            }
        }
        $ord_state_count1 = $ord_state + $wor_state;
        $wor_state3 = $wor_state0 + $wor_state1 + $wor_state2 + $ord_state_count1;


        $find_order_type = DB::table('order_type')
            ->where('orty_shop_id', $user_info->adm_shop_id);
            // ->where(function ($query) use ($wopl_ord_new_type) {
            //     if (!empty($wopl_ord_new_type)) {
            //         $query->where('orty_state', 1)
            //             ->OrwhereIn('orty_id', $wopl_ord_new_type);
            //     } else {
            //         $query->where('orty_state', 1);
            //     }
            // })
            if ($request['wopl_date'] >= date('Y-m-d')) {
                if(empty($wopl_ord_new_type)){
                    $find_order_type = $find_order_type->where('orty_state', 1);
                } else {
                    $find_order_type = $find_order_type->whereRaw('orty_state = 1 or orty_id in ('.implode(',',$wopl_ord_new_type).')');
                }
            }
            $find_order_type = $find_order_type->get()->toArray();
        // // 查询订单类型对应的工单数量
        // $ord_type_data = DB::table('work_plan as wopl')
        //     ->leftJoin('order_type', 'orty_id', '=', 'wopl_ord_new_type')
        //     ->where('wopl_shop_id', $user_info->adm_shop_id)
        //     ->where('wopl_delete', 1)
        //     ->where('wopl_wor_id', '!=', '')
        //     ->where('wopl_date', $request['wopl_date'])
        //     ->where('wopl_ord_new_type', $request['wopl_date'])
        //     ->select(DB::raw('count(*) as count, wopl_ord_new_type,orty_name'))
        //     ->groupBy('wopl_ord_new_type')
        //     ->get();
        $new_data = [];
        $new_count =0;
        $new_all_count =0;
        foreach ($find_order_type as $key => $value) {
            $count = DB::table('work_plan as wopl')
                ->leftJoin('order_type', 'orty_id', '=', 'wopl_ord_new_type')
                ->leftJoin('order as o', 'o.ord_id', '=', 'wopl.wopl_ord_id')
                ->where('wopl_shop_id', $user_info->adm_shop_id)
                ->where('wopl_delete', 1)
                ->where('ord_wor_state', '!=', 11)
                // ->where('wopl_wor_id', '!=', '')
                ->where('wopl_date', $request['wopl_date'])
                ->where('wopl_ord_new_type', $value->orty_id)
                ->select(DB::raw('count(*) as count'))
                // ->groupBy('wopl_ord_new_type')
                ->get();
            $all_count = DB::table('shop_reservenum')
                ->where('resenum_shop_id', $user_info->adm_shop_id)
                ->where('resenum_date', $request['wopl_date'])
                ->where('resenum_new_type', $value->orty_id)
                ->value('resenum_num');
            $new_data[$key]['orty_id'] = $value->orty_id;
            $new_data[$key]['orty_name'] = $value->orty_name;
            $new_data[$key]['count'] = $count ? $count[0]->count : 0;
            $new_data[$key]['all_count'] = $all_count?$all_count:0;
            if (empty($all_count)) {
                $new_data[$key]['type'] = 2;//没设置预约数量
            } else {
                $new_data[$key]['type'] = 1;//设置预约数量
            }
            $new_count += $count[0]->count;
            $new_all_count += $all_count;
        }
        $alltype_data[0]['orty_id'] = 0;
        $alltype_data[0]['orty_name'] = '全部';
        $alltype_data[0]['count'] = $new_count;
        $alltype_data[0]['all_count'] = $new_all_count;
        if ($new_all_count > 0) {
            $alltype_data[0]['type'] = 1;
        } else {
            $alltype_data[0]['type'] = 2;
        }
        $new_data = array_merge($alltype_data,$new_data);
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['ord_state_count'] = $ord_state_count1;                        //待派单
        // $data['wor_state_count'] = $wor_state_count;                        //工单状态
        $data['wor_state0'] = $wor_state0;                        //待接单
        $data['wor_state1'] = $wor_state1;                        //施工中
        $data['wor_state2'] = $wor_state2;                        //已完成
        $data['wor_state3'] = $wor_state3;                        //总计
        $data['ord_type_data'] = $new_data;                        //总计
        return $data;
    }

    // 技师小程序-工单列表
    public function indexPage($user_info, $search_data, $show_count = 10)
    {
        $search_data['state'] = [2, 3, 4, 5, 6];
        $adm_leave = DB::table('admin_shop_role')
            ->where('adm_id', $user_info->adm_id)
            ->where('shop_id', $user_info->adm_shop_id)
            ->value('adm_shop_leave as adm_leave');
        $all_work = false;
        if (isset($search_data['pri_id'])) {
            $list_button = getAppletListButton($search_data['api_token'], $search_data['pri_id']);
            foreach ($list_button as $key => $value) {
                if ($value['pri_id'] == 79 && $value['have_pri'] == 1) {
                    $all_work = true;
                }
            }
            $pri_id = array_column($list_button, 'pri_id');
        }
        // 筛选当前技师负责施工部位的工单
        //区分是否为店长
        if($adm_leave == 1 || $all_work){
            $list_data = DB::table('work_order as b')
                ->leftJoin('shop as s', 's.shop_id', '=', 'b.wor_shop_id')
                ->leftJoin('order as o', 'o.ord_id', '=', 'b.wor_order_id')
                ->leftJoin('work_client as c', 'c.wocl_wor_id', '=', 'b.wor_id')
                ->leftJoin('order_client as oc', 'oc.orcl_ord_id', '=', 'b.wor_order_id')
                ->where('wor_shop_id', $user_info->adm_shop_id);
        }else{
            $list_data = DB::table('wash_work_technician_part as a')
                ->leftJoin('work_order as b', 'b.wor_id', '=', 'a.wotp_wor_id')
                ->leftJoin('shop as s', 's.shop_id', '=', 'b.wor_shop_id')
                ->leftJoin('order as o', 'o.ord_id', '=', 'b.wor_order_id')
                ->leftJoin('work_client as c', 'c.wocl_wor_id', '=', 'a.wotp_wor_id')
                ->leftJoin('order_client as oc', 'oc.orcl_ord_id', '=', 'b.wor_order_id')
                ->where('wotp_shop_id', $user_info->adm_shop_id)
                ->where('wotp_service_adm_id', $user_info->adm_id);
        }
        $list_data = $list_data->where('wor_delete', 1)
            ->where('wor_collection_bill', 1) //是否代收账单：1正常工单2代收账单
            ->where(function ($query) use ($search_data) { //关键字搜索
                if (!empty($search_data['keywords'])) {
                    $query->where('wor_order_number', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('wor_number', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('wocl_phone', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('wocl_car_num', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('wocl_sales_adm_name', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('wocl_name', 'like', '%' . $search_data['keywords'] . '%');
                }
            })
            ->where(function ($query) use ($search_data,$user_info) {
                if (!empty($search_data['search_state'])) {
                    if ($search_data['search_state'] == 1) { //待接单列表
                        $query->where('wor_service_state', 1)
                            ->where('wor_service_adm_id', $user_info->adm_id);
                    } elseif ($search_data['search_state'] == 2) { //待验车
                        $query->whereIn('wor_service_state', [3]);
                    } elseif ($search_data['search_state'] == 3) { //待施工
                        $query->where('wor_service_state', 4);
                    } elseif ($search_data['search_state'] == 4) { //施工中
                        $query->whereIn('wor_service_state', [5,6]);
                    } elseif ($search_data['search_state'] == 5) { //完成待审核
                        $query->whereIn('wor_service_state', [8]);
                    } elseif ($search_data['search_state'] == 6) { //待还件
                        $query->whereIn('wor_service_state', [7]);
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //订单号
                if (!empty($search_data['wor_order_number'])) {
                    $query->where('wor_order_number', 'like', '%' . $search_data['wor_order_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //工单号
                if (!empty($search_data['wor_number'])) {
                    $query->where('wor_number', 'like', '%' . $search_data['wor_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //姓名
                if (!empty($search_data['wocl_name'])) {
                    $query->where('wocl_name', 'like', '%' . $search_data['wocl_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //联系电话
                if (!empty($search_data['wocl_phone'])) {
                    $query->where('wocl_phone', 'like', '%' . $search_data['wocl_phone'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //车牌号
                if (!empty($search_data['wocl_car_num'])) {
                    $query->where('wocl_car_num', 'like', '%' . $search_data['wocl_car_num'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //订单类型1会员零售2客户单位3速电派单
                if (!empty($search_data['wor_type'])) {
                    $query->where('wor_type', $search_data['wor_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //1.新订单 2未派单 3待接单/已派单 4.未出发/已接单 5.预约/已预约 6.出发/已出发  7.抵达/抵达 8.待审核/完成待审核 9驳回/完成已驳回 10完成/完成已通过 11终止 12锁定13.速电撤销回收
                if (!empty($search_data['wor_state'])) {
                    $query->where('wor_state', $search_data['wor_state']);
                }
            })
            ->where(function ($query) use ($search_data) { //派单人
                if (!empty($search_data['wor_create_id'])) {
                    $query->where('wor_create_id', $search_data['wor_create_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //备注
                if (!empty($search_data['wor_remark'])) {
                    $query->where('wor_remark', 'like', '%' . $search_data['wor_remark'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //订单类型
                if (!empty($search_data['wor_service_type'])) {
                    $query->where('wor_service_type', $search_data['wor_service_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //智配审核结果：1未审核2通过3驳回
                if (!empty($search_data['wor_other_audit'])) {
                    $query->where('wor_other_audit', $search_data['wor_other_audit'])
                        ->where('wor_work_type', 2);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间/派单时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('wor_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('wor_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('wor_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //客户id/会员id
                if (!empty($search_data['wocl_client_id'])) {
                    $query->where('wocl_client_id', $search_data['wocl_client_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //是否验车
                if (!empty($search_data['wocl_check_car_state'])) {
                    $query->where('wocl_check_car_state', $search_data['wocl_check_car_state']);
                }
            })
            ->select('wor_id', 'wor_number', 'wor_order_number', 'wor_shop_id', 'wor_create_id', 'wor_type', 'wor_state', 'wor_service_state', 'wor_appoint_time', 'wocl_appoint_remark', 'wocl_car_vehicle_type', 'wocl_pick_up_car_time', 'wocl_check_car_state', 'wocl_name', 'wocl_phone', 'wocl_car_num', 'wocl_car_vehicle_type', 'wocl_car_vin', 'wocl_car_brand_series', 'wor_province', 'wor_city', 'wor_county', 'wor_address', 'wocl_carowner_phone', 'wocl_carowner_name', 'wor_explain as wor_remark', 'wocl_bus_name', 'shop_store_name', 'wor_address_type', 'wor_address_id', 'wor_service_adm_id', 'wocl_carbrse_type', 'wor_work_type', 'wor_order_id', 'wocl_client_id', 'wor_list_pic', 'ord_new_type')
            ->orderBy('wor_appoint_time', 'desc')
            ->orderBy('wor_id', 'desc')
            ->paginate($show_count);
        //, 'wotp_service_adm_name', 'wotp_grle_name', 'wotp_grpr_name'
        $list_items = $list_data->items();
        if ($list_items) {
            $wor_id = array_column($list_items, 'wor_id'); //工单id
            // 获取该工单下的商品信息
            $goods_data = DB::table('work_good as wg')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'wg.wogo_goo_id')
                ->whereIn('wogo_wor_id', $wor_id)
                ->select('wogo_id', 'wogo_wor_id', 'wogo_goo_id', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_goo_amount', 'wogo_goo_guarantee', 'wogo_goo_type', 'wogo_state', 'wogo_goo_unit', 'wogo_goo_unta_id', 'goo_unit_conversion')
                ->get()->toArray();

            $wor_create_id = array_unique(array_column($list_items, 'wor_create_id')); //录单人id
            $wor_service_adm_id = array_filter(array_unique(array_column($list_items, 'wor_service_adm_id'))); //技师id-负责人
            $adm_id_merge = array_unique(array_merge($wor_create_id, $wor_service_adm_id));
            // 查询录单人信息
            $find_adm = DB::table('admin')
                ->whereIn('adm_id', $adm_id_merge)
                ->pluck('adm_name', 'adm_id')->toArray();
            $find_dis = DB::table('dispatch_bill')
                ->where('dego_shop_id', $user_info->adm_shop_id)
                ->whereIn('dego_wor_id', $wor_id)
                ->where('dego_order_type', 2)
                ->pluck('dego_type', 'dego_wor_id')->toArray();
            $find_dis_pic = DB::table('dispatch_bill')
                ->where('dego_shop_id', $user_info->adm_shop_id)
                ->whereIn('dego_wor_id', $wor_id)
                ->where('dego_order_type', 2)
                ->pluck('dego_pic', 'dego_wor_id')->toArray();
            foreach ($list_items as $key => $value) {
                $list_items[$key]->ord_new_type_name = DB::table('order_type')
                    ->where('orty_id', $value->ord_new_type)
                    ->value('orty_name');
                // 录单人名称
                if ($value->wor_create_id && isset($find_adm[$value->wor_create_id])) {
                    $list_items[$key]->wor_create_name = $find_adm[$value->wor_create_id];
                } else {
                    $list_items[$key]->wor_create_name = '';
                }
                // 发货状态
                if (isset($find_dis[$value->wor_id])) {
                    $list_items[$key]->dego_type = $find_dis[$value->wor_id];
                } else {
                    $list_items[$key]->dego_type = 0;
                }
                // 发货图片
                if (isset($find_dis_pic[$value->wor_id])) {
                    $list_items[$key]->dego_pic = $find_dis_pic[$value->wor_id];
                } else {
                    $list_items[$key]->dego_pic = '';
                }
                //工单的质检状态
                $find_all_wotp = DB::table('wash_work_technician_part')
                    ->where('wotp_wor_id', $value->wor_id)
                    ->select('wotp_submit_state', 'wotp_service_adm_name', 'wotp_service_adm_id', 'wotp_service_data')
                    ->get()->toArray();
                foreach ($find_all_wotp as $key1 => $value1) {
                    if ($value1->wotp_submit_state != 2) {
                        $list_items[$key]->wor_check_res = $value1->wotp_submit_state;
                        break;
                    } else {
                        $list_items[$key]->wor_check_res = 2;
                    }
                }

                foreach ($find_all_wotp as $key1 => $value1) {
                    if ($value1->wotp_submit_state == 0) {
                        $list_items[$key]->wor_all_submit = 2;
                        break;
                    } else {
                        $list_items[$key]->wor_all_submit = 1;
                    }
                }
                $wor_service_adm_id = DB::table('work_order')
                    ->where('wor_id', $value->wor_id)
                    ->value('wor_service_adm_id');
                $num = 0;
                foreach ($find_all_wotp as $key2 => $value2) {
                    if ($value2->wotp_service_adm_name && !empty($list_items[$key]->service_adm_names)) {
                        if ($wor_service_adm_id == $value2->wotp_service_adm_id) {
                            $list_items[$key]->service_adm_names = $value2->wotp_service_adm_name.'(组长)' .'、'. $list_items[$key]->service_adm_names;
                        } else {
                            $list_items[$key]->service_adm_names = $list_items[$key]->service_adm_names.'、'.$value2->wotp_service_adm_name;
                        }
                    } else {
                        if ($wor_service_adm_id == $value2->wotp_service_adm_id) {
                            $list_items[$key]->service_adm_names = $value2->wotp_service_adm_name.'(组长)';
                        } else {
                            $list_items[$key]->service_adm_names = $value2->wotp_service_adm_name;
                        }
                    }
                    $num++;
                }
                $list_items[$key]->service_adm_num = $num;
                unset($num);
                unset($find_all_wotp);
                // 质检状态
                $find_woch = DB::table('wash_work_check_history')
                    ->where('woch_wor_id', $value->wor_id)
                    ->where('woch_adm_id', $user_info->adm_id)
                    ->select('woch_check_res', 'woch_check')
                    ->orderBy('woch_create_time', 'desc')
                    ->first();
                if ($find_woch) {
                    $list_items[$key]->woch_check_res = $find_woch->woch_check_res;
                    $list_items[$key]->woch_check_data = $find_woch->woch_check;
                } else {
                    $list_items[$key]->woch_check_res = 0;
                    $list_items[$key]->woch_check_data = '';
                }
                if ($value->wor_appoint_time == '0000-00-00 00:00:00') {
                    $list_items[$key]->wor_appoint_time = '--';
                }
                // 施工地址
                if ($value->wor_address_type == 1) {//门店
                    $find_address = DB::table('shop')
                        ->where('shop_id', $value->wor_address_id)
                        ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                        ->first();
                    if ($find_address) {
                        $list_items[$key]->shop_store_name = $find_address->shop_store_name;
                        $list_items[$key]->wor_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                    } else {
                        $list_items[$key]->shop_store_name = '';
                        $list_items[$key]->wor_address = '';
                    }
                } elseif ($value->wor_address_type == 2) {
                    $find_address = DB::table('business_client')
                        ->where('bucl_id', $value->wor_address_id)
                        ->select('bucl_id', 'bucl_name', 'bucl_province', 'bucl_city', 'bucl_address', 'bucl_county')
                        ->first();
                    if ($find_address) {
                        $list_items[$key]->shop_store_name = $find_address->bucl_name;
                        $list_items[$key]->wor_address = $find_address->bucl_province.$find_address->bucl_city.$find_address->bucl_county.$find_address->bucl_address;
                    } else {
                        $list_items[$key]->shop_store_name = '';
                        $list_items[$key]->wor_address = '';
                    }
                } else {
                    $find_address = DB::table('shop')
                        ->where('shop_id', $value->wor_shop_id)
                        ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                        ->first();
                    if ($find_address) {
                        $list_items[$key]->shop_store_name = $find_address->shop_store_name;
                        $list_items[$key]->wor_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                    } else {
                        $list_items[$key]->shop_store_name = '';
                        $list_items[$key]->wor_address = '';
                    }
                }
                $find_wogo_data = DB::table('work_good as wogo')
                    ->leftJoin('service_project as sp', 'sp.sepr_id', '=', 'wogo.wogo_goo_id')
                    ->where('wogo_wor_id', $value->wor_id)
                    ->where('wogo_goo_type', 2)
                    ->select('wogo_goo_id', 'sepr_name', 'sepr_check_car', 'sepr_id', 'wogo_goo_type')
                    ->get()->toArray();
                if ($find_wogo_data) {
                    $sepr_check_car = 2;
                    foreach ($find_wogo_data as $key1 => $value1) {
                        if ($value1->sepr_check_car == 1) {
                            $list_items[$key]->sepr_check_car = 1;
                            break;
                        }
                    }
                    $service_project = '';
                    foreach ($find_wogo_data as $key_g => $value_g) {
                        if (empty($service_project)) {
                            $service_project = $value_g->sepr_name;
                        } else {
                            $service_project = $service_project . '、' . $value_g->sepr_name;
                        }
                    }
                    $list_items[$key]->wor_service_project = $service_project;
                } else {
                    $list_items[$key]->wor_service_project = '';
                }
            }
            foreach ($goods_data as $key => $value) {
                // 商品信息
                if (empty($value->wogo_goo_id)) {
                    $goods_data[$key]->wogo_goo_name = '';
                    $goods_data[$key]->wogo_goo_amount = '';
                }
            }
        } else {
            $goods_data = [];
        }

        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['goods_data'] = $goods_data;
        $data['now_time'] = date('Y-m-d H:i:s');           //当前时间
        return $data;
    }

    // 技师小程序-待派单列表
    public function dispatchList($user_info, $request, $show_count = 10)
    {
        $list_data = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->leftJoin('shop as s', 's.shop_id', '=', 'ord.ord_shop_id')
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('ord_classify', 2) //工单分类：1蓄电池2洗美店3易损件
            ->where('ord_is_split', '<>', 3) //订单是否拆分，1是2否
            ->where('ord_service_type', 1)
            ->where(function ($query) use ($request) { //关键字搜索
                if (!empty($request['type'])) {
                    if ($request['type'] == 1) {
                        $query->where('ord_wor_state', 7);
                    } elseif ($request['type'] == 2) {
                        $query->where('ord_wor_state', 1);
                    }
                } else {
                    $query->whereIn('ord_wor_state', [1,7]);
                }
            })
            ->where(function ($query) use ($request) { //关键字搜索
                if (!empty($request['keywords'])) {
                    $query->where('ord_order_number', 'like', '%' . $request['keywords'] . '%')
                        ->orwhere('orcl_phone', 'like', '%' . $request['keywords'] . '%')
                        ->orwhere('orcl_name', 'like', '%' . $request['keywords'] . '%')
                        ->orwhere('orcl_car_num', 'like', '%' . $request['keywords'] . '%')
                        ->orwhere('orcl_car_vin', 'like', '%' . $request['keywords'] . '%')
                        ->orwhere('orcl_car_vehicle_type', 'like', '%' . $request['keywords'] . '%');
                }
            })
            ->select('ord_id', 'ord_create_id', 'ord_order_number', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_type', 'ord_order_state', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_delete', 'ord_create_time', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address', 'ord_order_price', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_car_vehicle_type', 'orcl_pick_up_car_time', 'orcl_pick_up_car_adm_id', 'orcl_check_car_state', 'orcl_car_vin', 'orcl_sales_adm_id', 'ord_is_split', 'ord_province', 'ord_city', 'ord_county', 'ord_address', 'orcl_car_brand_series', 'orcl_carowner_name', 'orcl_carowner_phone', 'ord_explain as ord_remark', 'orcl_business_name', 'shop_store_name', 'ord_shop_id', 'ord_address_type', 'ord_address_id', 'orcl_carbrse_type', 'ord_new_type', 'ord_source')
            ->orderBy('ord_create_time', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            $ord_id = array_column($list_items, 'ord_id'); //订单id
            $ord_create_id = array_unique(array_column($list_items, 'ord_create_id')); //录单人id

            // 查询商品、项目信息
            $order_goods = DB::table('order_goods as orgo')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'orgo.orgo_goo_id')
                ->whereIn('orgo_ord_id', $ord_id)
                ->select('orgo_id', 'orgo_ord_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_price', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orgo_goo_unit as goo_unit', 'orgo_goo_unta_id as goo_unta_id', 'goo_unit_conversion')
                ->get()->toArray();

            $orcl_sales_adm_id = array_filter(array_unique(array_column($list_items, 'orcl_sales_adm_id'))); //销售人员id
            $adm_id_merge = array_merge($ord_create_id, $orcl_sales_adm_id);
            // 查询录单人信息
            $find_adm = DB::table('admin')
                ->whereIn('adm_id', $adm_id_merge)
                ->pluck('adm_name', 'adm_id')->toArray();
            $ord_new_type = DB::table('order_type')->where('orty_shop_id',$user_info->adm_shop_id)->pluck('orty_name','orty_id')->toArray();
            foreach ($list_items as $key => $value) {
//                $list_items[$key]->ord_new_type_name = DB::table('order_type')
//                    ->where('orty_id', $value->ord_new_type)
//                    ->value('orty_name');
                $list_items[$key]->ord_new_type_name = $ord_new_type[$value->ord_new_type] ?? '无标签';
                $ord_service_project = '';
                foreach ($order_goods as $k1 => $v1) {
                    if ($v1->orgo_goo_type == 2 && $v1->orgo_ord_id == $value->ord_id) {
                        if (empty($ord_service_project)) {
                            $ord_service_project = $v1->orgo_goo_name;
                        } else {
                            $ord_service_project = $ord_service_project.'、'.$v1->orgo_goo_name;
                        }
                    }
                }
                $list_items[$key]->ord_service_project = $ord_service_project;
                $typeState = self::getOrderState(true);//订单状态
                if (!empty($value->ord_wor_state)) {
                    $value->ord_worstate_name = WashOrderService::getTypeData($value->ord_wor_state, $typeState);
                } else {
                    $value->ord_worstate_name = '';
                }
                if ($value->ord_wor_state == 7) {
                    $list_items[$key]->orcl_phone = substr($value->orcl_phone,0,3).'****'.substr($value->orcl_phone,-4);
                    $list_items[$key]->orcl_name = mb_substr($value->orcl_name,0,1,'utf-8').str_repeat("*",(strlen($value->orcl_name)/3-1));
                }
                // 创建人
                if ($value->ord_create_id && isset($find_adm[$value->ord_create_id])) {
                    $list_items[$key]->adm_name = $find_adm[$value->ord_create_id];
                } else {
                    $list_items[$key]->adm_name = '';
                }
                // 销售人员
                if ($value->orcl_sales_adm_id && isset($find_adm[$value->orcl_sales_adm_id])) {
                    $list_items[$key]->orcl_sales_adm_name = $find_adm[$value->orcl_sales_adm_id];
                } else {
                    $list_items[$key]->orcl_sales_adm_name = '';
                }
                // 预约时间
                if ($value->orcl_appoint_time == '0000-00-00 00:00:00') {
                    $list_items[$key]->orcl_appoint_time = '';
                }
                // 施工地址
                if ($value->ord_address_type == 1) {//门店
                    $find_address = DB::table('shop')
                        ->where('shop_id', $value->ord_address_id)
                        ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                        ->first();
                    $list_items[$key]->shop_store_name = $find_address->shop_store_name;
                    $list_items[$key]->ord_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                } elseif ($value->ord_address_type == 2) {
                    $find_address = DB::table('business_client')
                        ->where('bucl_id', $value->ord_address_id)
                        ->select('bucl_id', 'bucl_name', 'bucl_province', 'bucl_city', 'bucl_address', 'bucl_county')
                        ->first();
                    $list_items[$key]->shop_store_name = $find_address->bucl_name;
                    $list_items[$key]->ord_address = $find_address->bucl_province.$find_address->bucl_city.$find_address->bucl_county.$find_address->bucl_address;
                } else {
                    $find_address = DB::table('shop')
                        ->where('shop_id', $value->ord_shop_id)
                        ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                        ->first();
                    $list_items[$key]->shop_store_name = $find_address->shop_store_name;
                    $list_items[$key]->ord_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                }
            }
        } else {
            $order_goods = [];
        }
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['order_goods'] = $order_goods;                //订单商品数据
        $data['now_time'] = date('Y-m-d H:i:s');           //当前时间
        return $data;
        // if ($request['type'] == 1) {//订单未派单

        // }elseif($request['type']==3){
        //     return self::waitGetOrders($user_info, $request);
        // } else {//未派工单
        /* $list_data = DB::table('work_order as a')
             // ->leftJoin('wash_work_technician_part as b', 'a.wor_id', '=', 'b.wotp_wor_id')
             ->leftJoin('work_client as c', 'c.wocl_wor_id', '=', 'a.wor_id')
             ->leftJoin('shop as s', 's.shop_id', '=', 'a.wor_shop_id')
             ->where('wor_shop_id', $user_info->adm_shop_id)
             ->where('wor_delete', 1)
             ->where('wor_classify', 2) //工单分类：1蓄电池2洗美店3易损件
             ->where('wor_collection_bill', 1) //是否代收账单：1正常工单2代收账单
             ->where('wor_service_state', 0)
             ->where('wor_state', 2)
             ->where(function ($query) use ($request) { //关键字搜索
                 if (!empty($request['keywords'])) {
                     $query->where('wor_number', 'like', '%' . $request['keywords'] . '%')
                         ->orwhere('wocl_phone', 'like', '%' . $request['keywords'] . '%')
                         ->orwhere('wocl_name', 'like', '%' . $request['keywords'] . '%')
                         ->orwhere('wocl_car_num', 'like', '%' . $request['keywords'] . '%')
                         ->orwhere('wocl_car_vin', 'like', '%' . $request['keywords'] . '%')
                         ->orwhere('wor_order_number', 'like', '%' . $request['keywords'] . '%');
                 }
             })
             ->select('wor_id', 'wor_number', 'wor_order_number', 'wor_shop_id', 'wor_create_id', 'wor_type', 'wor_state', 'wor_service_state', 'wor_appoint_time', 'wocl_appoint_remark', 'wocl_car_vehicle_type', 'wocl_pick_up_car_time', 'wocl_check_car_state', 'wocl_name', 'wocl_phone', 'wocl_car_num', 'wocl_car_brand_series', /*'wotp_service_adm_name', 'wotp_grle_name', 'wotp_grpr_name', 'wocl_car_vin', 'wor_create_time', 'wor_province', 'wor_city', 'wor_county', 'wor_address', 'wocl_carowner_name', 'wocl_carowner_phone', 'wor_explain as wor_remark', 'wocl_bus_name', 'shop_store_name', 'wor_address_type', 'wor_address_id', 'wor_service_adm_id', 'wocl_carbrse_type', 'wor_order_id')
             // ->orderBy('wor_id', 'desc')
             ->orderBy('wor_appoint_time', 'desc')
             ->orderBy('wor_create_time', 'desc')
             ->groupBy('wor_id')
             ->paginate($show_count);
         $list_items = $list_data->items();
         if ($list_items) {
             $wor_id = array_column($list_items, 'wor_id'); //工单id
             $goods_data = DB::table('work_good as wg')
                 ->leftjoin('goods as g', 'g.goo_id', '=', 'wg.wogo_goo_id')
                 ->whereIn('wogo_wor_id', $wor_id)
                 ->select('wogo_id', 'wogo_wor_id', 'wogo_goo_id', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_goo_amount', 'wogo_goo_guarantee', 'wogo_goo_type', 'wogo_state', 'wogo_goo_unit', 'wogo_goo_unta_id', 'goo_unit_conversion')
                 ->get()->toArray();

             $wor_create_id = array_unique(array_column($list_items, 'wor_create_id')); //录单人id
             $wor_service_adm_id = array_filter(array_unique(array_column($list_items, 'wor_service_adm_id'))); //技师id
             $adm_id_merge = array_unique(array_merge($wor_create_id, $wor_service_adm_id));
             // 查询录单人信息
             $find_adm = DB::table('admin')
                 ->whereIn('adm_id', $adm_id_merge)
                 ->pluck('adm_name', 'adm_id')->toArray();

             foreach ($list_items as $key => $value) {
                 // 技师组长名称
                 if ($value->wor_service_adm_id && isset($find_adm[$value->wor_service_adm_id])) {
                     $list_items[$key]->wor_service_adm_name = $find_adm[$value->wor_service_adm_id];
                 } else {
                     $list_items[$key]->wor_service_adm_name = '';
                 }

                 // 录单人名称
                 if ($value->wor_create_id && isset($find_adm[$value->wor_create_id])) {
                     $list_items[$key]->wor_create_name = $find_adm[$value->wor_create_id];
                 } else {
                     $list_items[$key]->wor_create_name = '';
                 }
                 // 施工地址
                 if ($value->wor_address_type == 1) {//门店
                     $find_address = DB::table('shop')
                         ->where('shop_id', $value->wor_address_id)
                         ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                         ->first();
                     if ($find_address) {
                         $list_items[$key]->shop_store_name = $find_address->shop_store_name;
                         $list_items[$key]->wor_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                     } else {
                         $list_items[$key]->shop_store_name = '';
                         $list_items[$key]->wor_address = '';
                     }
                 } elseif ($value->wor_address_type == 2) {
                     $find_address = DB::table('business_client')
                         ->where('bucl_id', $value->wor_address_id)
                         ->select('bucl_id', 'bucl_name', 'bucl_province', 'bucl_city', 'bucl_address', 'bucl_county')
                         ->first();
                     if ($find_address) {
                         $list_items[$key]->shop_store_name = $find_address->bucl_name;
                         $list_items[$key]->wor_address = $find_address->bucl_province.$find_address->bucl_city.$find_address->bucl_county.$find_address->bucl_address;
                     } else {
                         $list_items[$key]->shop_store_name = '';
                         $list_items[$key]->wor_address = '';
                     }
                 } else {
                     $find_address = DB::table('shop')
                         ->where('shop_id', $value->wor_shop_id)
                         ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                         ->first();
                     if ($find_address) {
                         $list_items[$key]->shop_store_name = $find_address->shop_store_name;
                         $list_items[$key]->wor_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                     } else {
                         $list_items[$key]->shop_store_name = '';
                         $list_items[$key]->wor_address = '';
                     }
                 }
             }

             foreach ($goods_data as $key => $value) {
                 // 商品信息
                 if (empty($value->wogo_goo_id)) {
                     $goods_data[$key]->wogo_goo_name = '';
                     $goods_data[$key]->wogo_goo_amount = '';
                 }
             }
         } else {
             $goods_data = [];
         }

         $data['current_page'] = $list_data->currentPage();  //当前页面页码
         $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
         $data['total'] = $list_data->total();               //总数据个数
         $data['current_number'] = $show_count;        //一页显示多少个
         $data['data'] = $list_items;                        //返回数据
         $data['goods_data'] = $goods_data;
         $data['now_time'] = date('Y-m-d H:i:s');           //当前时间
         return $data;
     }*/
    }

    /**
     * @name 待领取
     * @param $user_info
     * @param $input
     * @param int $show_count
     * @return array
     * @author du
     * @date 2023/6/9
     * @Time: 10:07
     */
    public static function waitGetOrders($user_info, $input, $show_count = 10){
        //订单未派单
        $list_data = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->leftJoin('shop as s', 's.shop_id', '=', 'ord.ord_shop_id')
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_source', 5) //智配单
            ->where('ord_delete', 1) //正常单
            ->where('ord_is_split', '<>', 3) //订单是否拆分，1是2否
            ->where('ord_wor_state', 7)
            ->where('ord_service_type', 1)
            ->where(function ($query) use ($input) { //关键字搜索
                if (!empty($input['keywords'])) {
                    $query->where('ord_order_number', 'like', '%' . $input['keywords'] . '%')
                        ->orwhere('orcl_phone', 'like', '%' . $input['keywords'] . '%')
                        ->orwhere('orcl_name', 'like', '%' . $input['keywords'] . '%')
                        ->orwhere('orcl_car_num', 'like', '%' . $input['keywords'] . '%')
                        ->orwhere('orcl_car_vin', 'like', '%' . $input['keywords'] . '%')
                        ->orwhere('orcl_car_vehicle_type', 'like', '%' . $input['keywords'] . '%');
                }
            })
            ->select('ord_id', 'ord_create_id', 'ord_order_number', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_type', 'ord_order_state', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_delete', 'ord_create_time', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address', 'ord_order_price', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_car_vehicle_type', 'orcl_pick_up_car_time', 'orcl_pick_up_car_adm_id', 'orcl_check_car_state', 'orcl_car_vin', 'orcl_sales_adm_id', 'ord_is_split', 'ord_province', 'ord_city', 'ord_county', 'ord_address', 'orcl_car_brand_series', 'orcl_carowner_name', 'orcl_carowner_phone', 'ord_explain as ord_remark', 'orcl_business_name', 'shop_store_name', 'ord_shop_id', 'ord_address_type', 'ord_address_id', 'orcl_carbrse_type')
            ->orderBy('ord_create_time', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();

        if ($list_items) {
            $ord_id = array_column($list_items, 'ord_id'); //订单id
            $ord_create_id = array_unique(array_column($list_items, 'ord_create_id')); //录单人id

            // 查询商品、项目信息
            $order_goods = DB::table('order_goods as orgo')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'orgo.orgo_goo_id')
                ->whereIn('orgo_ord_id', $ord_id)
                ->select('orgo_id', 'orgo_ord_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_price', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orgo_goo_unit as goo_unit', 'orgo_goo_unta_id as goo_unta_id', 'goo_unit_conversion')
                ->get()->toArray();

            $orcl_sales_adm_id = array_filter(array_unique(array_column($list_items, 'orcl_sales_adm_id'))); //销售人员id
            $adm_id_merge = array_merge($ord_create_id, $orcl_sales_adm_id);
            // 查询录单人信息
            $find_adm = DB::table('admin')
                ->whereIn('adm_id', $adm_id_merge)
                ->pluck('adm_name', 'adm_id')->toArray();

            foreach ($list_items as $key => $value) {
                // 创建人
                if ($value->ord_create_id) {
                    $list_items[$key]->adm_name = $find_adm[$value->ord_create_id];
                } else {
                    $list_items[$key]->adm_name = '';
                }
                // 销售人员
                if ($value->orcl_sales_adm_id) {
                    $list_items[$key]->orcl_sales_adm_name = $find_adm[$value->orcl_sales_adm_id];
                } else {
                    $list_items[$key]->orcl_sales_adm_name = '';
                }
                // 预约时间
                if ($value->orcl_appoint_time == '0000-00-00 00:00:00') {
                    $list_items[$key]->orcl_appoint_time = '';
                }
                // 施工地址
                if ($value->ord_address_type == 1) {//门店
                    $find_address = DB::table('shop')
                        ->where('shop_id', $value->ord_address_id)
                        ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                        ->first();
                    $list_items[$key]->shop_store_name = $find_address->shop_store_name;
                    $list_items[$key]->ord_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                } elseif ($value->ord_address_type == 2) {
                    $find_address = DB::table('business_client')
                        ->where('bucl_id', $value->ord_address_id)
                        ->select('bucl_id', 'bucl_name', 'bucl_province', 'bucl_city', 'bucl_address', 'bucl_county')
                        ->first();
                    $list_items[$key]->shop_store_name = $find_address->bucl_name;
                    $list_items[$key]->ord_address = $find_address->bucl_province.$find_address->bucl_city.$find_address->bucl_county.$find_address->bucl_address;
                } else {
                    $find_address = DB::table('shop')
                        ->where('shop_id', $value->ord_shop_id)
                        ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                        ->first();
                    $list_items[$key]->shop_store_name = $find_address->shop_store_name;
                    $list_items[$key]->ord_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                }
            }
        } else {
            $order_goods = [];
        }
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['order_goods'] = $order_goods;                //订单商品数据
        $data['now_time'] = date('Y-m-d H:i:s');           //当前时间

        return $data;
    }

    // 绩效计算
    public static function check($user_info, $request)
    {
        //查询工单及相关信息
        $find_work = DB::table('work_order as wo')
            ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
            ->where('wor_id', $request['wor_id'])
            ->select('wor_number', 'wor_state', 'wor_delete', 'wor_pass', 'wor_shop_id', 'wor_order_id', 'wor_order_number', 'wocl_car_vehicle_type', 'wocl_car_vin', 'wocl_car_brand_series', 'wor_id', 'wocl_car_num', 'wor_service_adm_id')
            ->first();
        if (empty($find_work)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单不存在，无法绩效计算！', 'data'=>''];
        }
        if ($find_work->wor_delete != 1) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已经取消！', 'data'=>''];
        }
        if (!in_array($find_work->wor_state, [8,10,12])) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单不是待审核状态，无法绩效计算！', 'data'=>''];
        }
        if ($find_work->wor_pass == 4) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已经锁定，无法绩效计算！', 'data'=>''];
        }
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $wor_edit_data['wor_service_state'] = 10; //8完成通过
        $wor_edit_data['wor_state'] = 12; //10完成/完成已通过
        if (!empty($request['remark'])) {
            $wor_edit_data['wor_remark'] = $request['remark'];
        }
        $ord_edit_data['ord_wor_state'] = 20; //审核后订单状态改成4已完成
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $order_res = DB::table('order')
            ->where('ord_id', $find_work->wor_order_id)
            ->update($ord_edit_data);
        $technician_part = json_decode(json_encode($request['technician_part'], true), true);
        $choose_type = $request['choose_type']; //绩效考核方法1按施工部位2按整车3按其他
        if (empty($choose_type)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'请选择绩效考核方法', 'data'=>''];
        }
        $request['choose_name'] = '按整车';
        // if ($choose_type == 2 && empty($request['choose_name'])) {
        //     return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'请选择车型', 'data'=>''];
        // }
        $find_wogo_data = DB::table('work_good as wogo')
            ->leftJoin('service_project as sp', 'sp.sepr_id', '=', 'wogo.wogo_goo_id')
            ->where('wogo_wor_id', $request['wor_id'])
            ->where('wogo_goo_type', 2)
            ->select('wogo_goo_id', 'sepr_name', 'sepr_check_car', 'sepr_id', 'wogo_goo_type')
            ->get()->toArray();
        $sepr_name = '';
        if ($find_wogo_data) {
            foreach ($find_wogo_data as $key => $value) {
                if ($sepr_name) {
                    $sepr_name = $sepr_name.','.$value->sepr_name;
                } else {
                    $sepr_name = $value->sepr_name;
                }
            }
        }

        $find_viti = DB::table('violation_ticket')
            ->where('viti_wor_number', $find_work->wor_number)
            ->where('viti_bind_work', 1)
            ->select('viti_id')
            ->get();
        $find_viti = json_decode(json_encode($find_viti,true),true);
        if ($find_viti) {
            $viti_id = array_column($find_viti, 'viti_id');
            $del_viti_detail = DB::table('violation_ticket_detail')
                ->whereIn('vtde_viti_id',$viti_id)
                ->delete();
            $find_viti = DB::table('violation_ticket')
                ->where('viti_wor_number', $find_work->wor_number)
                ->where('viti_bind_work', 1)
                ->select('viti_id')
                ->delete();
        }
        foreach ($technician_part as $key => $value) {
            //添加该技师的绩效
            $add_pewo_data['pewo_shop_id'] = $find_work->wor_shop_id;
            $add_pewo_data['pewo_wor_id'] = $request['wor_id'];
            $add_pewo_data['pewo_wor_number'] = $find_work->wor_number;
            $add_pewo_data['pewo_ord_id'] = $find_work->wor_order_id;
            $add_pewo_data['pewo_ord_order_number'] = $find_work->wor_order_number;
            $add_pewo_data['pewo_service_adm_id'] = $value['wotp_service_adm_id'];
            if ($value['wotp_service_adm_id']) {
                $pewo_service_adm_name = DB::table('admin')
                    ->where('adm_id', $value['wotp_service_adm_id'])
                    ->value('adm_name');
            }
            if ($value['wotp_id']) {
                $pewo_service_time = DB::table('wash_work_technician_part')
                    ->where('wotp_id', $value['wotp_id'])
                    ->value('wotp_service_start_time');
                $wotp_service_end_time = DB::table('wash_work_technician_part')
                    ->where('wotp_id', $value['wotp_id'])
                    ->value('wotp_service_end_time');
            }
            $add_pewo_data['pewo_service_adm_name'] = isset($pewo_service_adm_name) ? $pewo_service_adm_name : '';
            $add_pewo_data['pewo_service_time'] = isset($pewo_service_time) ? $pewo_service_time : '';
            $add_pewo_data['pewo_service_end_time'] = isset($wotp_service_end_time) ? $wotp_service_end_time : '';//施工结束时间
            // if (!empty($find_work->wogo_goo_id)) {
            //     $add_pewo_data['pewo_goo_id'] = $find_work->wogo_goo_id;
            //     $add_pewo_data['pewo_goo_name'] = $find_work->wogo_goo_name;
            //     $add_pewo_data['pewo_goo_goods_encode'] = $find_work->wogo_goo_goods_encode;
            //     $add_pewo_data['pewo_goo_quantity'] = $find_work->wogo_goo_amount;
            // }
            $add_pewo_data['pewo_car_vin'] = $find_work->wocl_car_vin;
            $add_pewo_data['pewo_sepr_name'] = $sepr_name;
            $add_pewo_data['pewo_car_brand_series'] = $find_work->wocl_car_brand_series;
            $add_pewo_data['pewo_performance_method'] = $request['choose_type'];
            $add_pewo_data['pewo_create_adm_id'] = $user_info->adm_id;
            $add_pewo_data['pewo_create_time'] = date('Y-m-d H:i:s');
            $add_pewo_data['pewo_update_time'] = date('Y-m-d H:i:s');
            //计算该技师的奖惩金额
            $rewards_punishment_score = 0;
            $punishment_count = 0;
            $pubishment_reason = '绩效审核：';
            if (!empty($value['rewards_punishment'])) {
                $rewards_punishment = json_decode($value['rewards_punishment'], true);
                foreach ($rewards_punishment as $rp_key => $rp_value) {
                    $rewards_punishment_score += $rp_value['rewards_punishment_score']; //质检项总分数
                    $rewards_punishment[$rp_key]['rewards_punishment_score'] = $rp_value['rewards_punishment_score'];
                    if ($rp_value['rewards_punishment_score'] < 0) {
                        $punishment_count += $rp_value['rewards_punishment_score'];
                        $pubishment_reason .= $rp_value['rewards_punishment_name'].','.$rp_value['rewards_punishment_score'];
                    }
                }
            } else {
                $rewards_punishment = [];
            }
            if ($punishment_count < 0) {
                $viti_data['viti_cid'] = $user_info->adm_cid;
                $viti_data['viti_shop_id'] = $user_info->adm_shop_id;
                $viti_data['viti_order_number'] = $find_work->wor_order_number; //订单号
                $viti_data['viti_wor_number'] = $find_work->wor_number; //工单号
                $viti_data['viti_reason'] = $pubishment_reason; //处罚原因
                $viti_data['viti_create_id'] = $user_info->adm_id; //创建人
                $viti_data['viti_create_name'] = $user_info->adm_name; //创建人
                $viti_data['viti_create_time'] = date('Y-m-d H:i:s');
                $viti_data['viti_state'] = 1;
                $viti_data['viti_bind_work'] = 1;
                $viti_id = DB::table('violation_ticket')->insertGetId($viti_data);
                $add_adm_data['vtde_shop_id'] = $user_info->adm_shop_id;
                $add_adm_data['vtde_viti_id'] = $viti_id;
                $add_adm_data['vtde_adm_id'] = $value['wotp_service_adm_id'];
                $add_adm_data['vtde_adm_name'] = isset($pewo_service_adm_name) ? $pewo_service_adm_name : '';
                $add_adm_data['vtde_punish_money'] = abs($punishment_count)*100;
                $add_adm_res = DB::table('violation_ticket_detail')->insert($add_adm_data);
            }
            //计算该技师的质检项扣分分数
            $quality_item_score = 0;
            if (!empty($value['wotp_service_qualitytesting'])) {
                $wotp_service_qualitytesting = json_decode($value['wotp_service_qualitytesting'], true);
                foreach ($wotp_service_qualitytesting as $qc_key => $qc_value) {
                    if (isset($qc_value['qurp_standard'])) {
                        $quality_item_score += abs($qc_value['qurp_standard']); //质检项总分数
                    }
                }
            } else {
                $wotp_service_qualitytesting = '';
            }

            //该施工部位的得分情况
            $pewo_score1 = 100 - $quality_item_score;
            //是否有该技师的工单绩效信息
            $find_pewo_data = DB::table('wash_performance_work')
                ->where('pewo_wor_id', $request['wor_id'])
                ->where('pewo_service_adm_id', $value['wotp_service_adm_id'])
                ->where('pewo_work_type', $value['wotp_work_type'])
                ->select('pewo_id', 'pewo_score', 'pewo_performance_total_price')
                ->first();
            $find_adm_data = DB::table('admin_shop_role as asr')
                ->leftJoin('wash_grade_level as grle', 'asr.adm_grle_id', '=', 'grle.grle_id')
                ->where('adm_id', $value['wotp_service_adm_id'])
                ->where('shop_id', $value['wotp_service_adm_id'])
                ->select('adm_grle_id', 'grle_grpr_id')
                ->first();
            $pewo_performance_total_price = $value['person_car_price_total']*100; //整车的绩效金额
            if ($find_pewo_data) {
                $pewo_score = 100 - $quality_item_score; //绩效分数
            } else {
                $pewo_score = 100 - $quality_item_score;
            }
            $add_pewo_data['pewo_score'] = $pewo_score; //绩效分数
            $add_pewo_data['pewo_work_type'] = $value['wotp_work_type']; //绩效分数
            $add_pewo_data['pewo_rewards_punishment_price'] = $rewards_punishment_score*100; //奖惩金额
            $add_pewo_data['pewo_performance_total_price'] = $pewo_performance_total_price; //绩效总金额
            unset($pewo_performance_total_price);
            unset($rewards_punishment_score);
            if ($find_pewo_data) {
                $add_pewo_data_res = DB::table('wash_performance_work')
                    ->where('pewo_id', $find_pewo_data->pewo_id)
                    ->update($add_pewo_data);
            } else {
                $add_pewo_data_res = DB::table('wash_performance_work')->insertGetId($add_pewo_data);
            }
            unset($add_pewo_data);

            if (!$add_pewo_data_res) {
                return ['code'=>500, 'msg'=>'审核失败002', 'data'=>''];
            }
            if (!empty($value['wotp_service_qualitytesting'])) {
                $find_peti_data = DB::table('wash_performance_technician_items')
                    ->where('peti_pewo_id', $request['wor_id'])
                    ->select('peti_id')
                    ->get()->toArray();
                if ($find_peti_data) {
                    $del_peti_data_res = DB::table('wash_performance_technician_items')
                        ->where('peti_pewo_id', $request['wor_id'])
                        ->delete();
                }
                $wotp_service_qualitytesting = json_decode($value['wotp_service_qualitytesting'], true);
                foreach ($wotp_service_qualitytesting as $qc_key => $qc_value) {
                    $add_peti_data['peti_shop_id'] = $find_work->wor_shop_id;
                    $add_peti_data['peti_pewo_id'] = $request['wor_id']; //工单id
                    $add_peti_data['peti_service_adm_id'] = $value['wotp_service_adm_id'];
                    // $add_peti_data['peti_pema_id'] = $pema_id; //施工部位绩效管理表绩效的id
                    // $add_peti_data['peti_pema_name'] = $value['wotp_service_part']; //绩效管理的施工部位
                    $add_peti_data['peti_create_adm_id'] = $user_info->adm_id;
                    $add_peti_data['peti_create_time'] = date('Y-m-d H:i:s');
                    $add_peti_data['peti_update_time'] = date('Y-m-d H:i:s');
                    $add_peti_data['peti_score'] = isset($qc_value['qurp_standard']) ? $qc_value['qurp_standard']:0; //绩效分数
                    $add_peti_data['peti_items_id'] = $qc_value['qurp_id']; //考核项id
                    $add_peti_data['peti_items_name'] = $qc_value['qurp_name']; //考核项目名称
                    $add_peti_data_res = DB::table('wash_performance_technician_items')->insert($add_peti_data);
                    unset($add_peti_data);
                    if (!$add_peti_data_res) {
                        return ['code'=>500, 'msg'=>'审核失败003', 'data'=>''];
                    }
                }
            } else {
                $wotp_service_qualitytesting = '';
            }
            if (!empty($value['wotp_service_data'])) {
                $wotp_service_data = json_decode($value['wotp_service_data'], true);
                if (!empty($wotp_service_data)) {
                    foreach ($wotp_service_data as $s_key => $s_value){
                        $wotp_service_data[$s_key]['part_price'] = $s_value['part_price']*100;
                        $wotp_service_data[$s_key]['person_part_price'] = $s_value['person_part_price']*100;
                        //20230821
                        $completion_update['coin_part_price'] = $s_value['part_price']*100;
                        $completion_update['coin_person_part_price'] = $s_value['person_part_price']*100;

                        $wash_res = DB::table('completion_info')
                            ->where('coin_shop_id', $find_work->wor_shop_id)//门店id
                            ->where('coin_wor_id', $request['wor_id'])//工单id
                            ->where('coin_adm_id', $value['wotp_service_adm_id'])//技师id
                            ->where('coin_type', 1)//1快捷部位
                            // ->where('coin_data_id', $s_value['wotp_id'])//部位id
                            ->update($completion_update);
                    }
                }
            } else {
                $wotp_service_data = [];
            }
            $wotp_edit_data['wotp_total_price'] = $value['person_car_price_total']*100; //按整车计算总金额
            if (!empty($wotp_service_data)) {
                $wotp_edit_data['wotp_service_data'] = json_encode($wotp_service_data, true); //绩效考核信息json数据
            } else {
                $wotp_edit_data['wotp_service_data'] = '';
            }
            $wotp_edit_data['wotp_choose_type'] = $request['choose_type']; //绩效考核类型
            if ($choose_type == 2) {
                $wotp_edit_data['wotp_person_car_price'] = $value['person_car_price']*100; //按整车计算每个人的基础绩效
                $wotp_edit_data['wotp_car_name'] = $request['choose_name']; //绩效考核车型名称
                $wotp_edit_data['wotp_car_name_id'] = $request['choose_name_id']; //绩效考核id
            }
            if ($choose_type == 3) {
                if (!empty($value['wotp_remark'])){
                    $wotp_edit_data['wotp_remark'] = $value['wotp_remark'];
                }
            }
            $wotp_edit_data['wotp_rewards_punishment'] = json_encode($rewards_punishment, true); //绩效考核信息json数据
            $wotp_edit_data['wotp_service_qualitytesting'] = $value['wotp_service_qualitytesting']; //绩效考核信息json数据
            $wotp_edit_data['wotp_update_time'] = date('Y-m-d H:i:s');
            $wash_res = DB::table('wash_work_technician_part')
                ->where('wotp_wor_id', $request['wor_id'])
                ->where('wotp_service_adm_id', $value['wotp_service_adm_id'])
                ->where('wotp_work_type', $value['wotp_work_type'])
                ->update($wotp_edit_data);
            unset($wotp_edit_data);
        }
        $wor_edit_data['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_edit_res = WashWork::where('wor_id', $request['wor_id'])->update($wor_edit_data);
        if ($wor_edit_res && $wash_res /*&& $order_res*/) {
            $return_data['wor_number'] = $find_work->wor_number; //工单单号
            $return_data['wocl_car_num'] = $find_work->wocl_car_num; //工单单号
            return ['code'=>200, 'msg'=>'绩效计算成功', 'data'=>$return_data];
        } else {
            $return_data['wor_edit_res'] = $wor_edit_res; //工单单号
            $return_data['wash_res'] = $wash_res; //工单单号
            return ['code'=>500, 'msg'=>'绩效计算失败', 'data'=>$return_data];
        }
    }

    // 完成提交-技师小程序
    public static function accomplish($user_info, $request)
    {
        $find_work = DB::table('work_order as wor')
            ->leftJoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->select('wor_number', 'wor_state', 'wor_delete', 'wor_pass', 'wor_service_adm_id', 'wor_type', 'wor_ware_id', 'wor_order_id', 'wor_order_number', 'wocl_client_id', 'wor_actual_price', 'wocl_car_num', 'wor_work_type', 'wor_quality', 'wor_is_recycle', 'wor_need_return')
            ->first();
        if (empty($find_work)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单不存在，无法提交！', 'data'=>''];
        }
        // if ($find_work->wor_quality != 1) {
        //     return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'质检不合格，重新质检', 'data'=>''];
        // }

        if ($find_work->wor_delete != 1) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已经取消！', 'data'=>''];
        }
        if (!in_array($find_work->wor_state, [6,7])) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单不是施工中，无法提交！', 'data'=>''];
        }
        if ($find_work->wor_pass == 4) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已经锁定，无法提交！', 'data'=>''];
        }

        // // 查询当前工单是否有未发货的发货单
        // $dego_id = DB::table('dispatch_bill')
        //     ->where('dego_wor_id', $request['wor_id'])
        //     ->where('dego_order_type', 2)
        //     ->where('dego_type', 1)
        //     ->value('dego_id');
        // if ($dego_id) {
        //     return ['code'=>500, 'msg'=>'请取货后再完成！', 'data'=>'{}'];
        // }
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        // 获取该工单下的商品信息
        if ($user_info->adm_id == $find_work->wor_service_adm_id) {//组长提交的数据
            $goo_return_number = 0; //退回总数量
            $goo_waste_number = 0;//废料数量
            // 验证提交的商品信息
            $goo_return_data = []; //退回商品数据
            $remain_goo_amounts = 0;//单位换算后的剩余商品数量
            $goo_return_numbers = 0;//退回总数量
            $goods_data = DB::table('work_good')
                ->where('wogo_wor_id', $request['wor_id'])
                ->where('wogo_goo_type', 1)
                ->get()->toArray();
            // if (!empty($goods_data) && $find_work->wor_ware_id) {
            //     $goods_all = json_decode(json_encode($goods_data, true), true);
            //     $remain_goo_amount = 0; //剩余商品数量
            //     foreach ($goods_all as $key => $value) {
            //         if ($value['wogo_goo_type'] == 1) {//正常商品
            //             if (empty($value['wogo_goo_unta_id'])) {
            //                 return ['code'=>500, 'msg'=>'单位数据错误', 'data'=>'单位数据错误'];
            //             }
            //         }
            //         // if ($value['wogo_goo_unta_id'] == 1) {
            //         //     $goo_unit_conversion = DB::table('goods')
            //         //         ->where('goo_id', $value['wogo_goo_id'])
            //         //         ->value('goo_unit_conversion');
            //         //     $value['wogo_goo_amount'] =  $value['wogo_goo_amount']*$goo_unit_conversion;
            //         // }
                    
            //         // 判断商品退回数量和废料是否大于工单商品数量
            //         if (($value['wogo_goo_waste_number'] + $value['wogo_recycle_quantity']) > $value['wogo_goo_amount']) {
            //             return ['code'=>500, 'msg'=>'施工余料+施工废料不能大于商品的仓库出料', 'data'=>''];
            //         }

            //         $remain_goo_amount = $value['wogo_goo_amount']; //剩余需要出库商品数量
            //         if ($value['wogo_goo_waste_number']) {
            //             $remain_goo_amount = $value['wogo_goo_amount'] - $value['wogo_goo_waste_number']; //剩余需要出库商品数量
            //         }
            //         // 商品有退回数量，同时不是换货单的退回商品
            //         if ($value['wogo_recycle_quantity']) {
            //             // 更改订单商品、工单商品表数据
            //             $remain_goo_amount = $remain_goo_amount - $value['wogo_recycle_quantity']; //剩余需要出库商品数量
            //             $goo_return_data[] = $value; //退回商品数据
            //             $goo_return_numbers = $goo_return_numbers + $value['wogo_recycle_quantity'];  //退回总数量
            //         }
            //         // 工单商品表数据
            //         $return_wogo_data['wogo_new_goo_amount'] = $remain_goo_amount; //用料-工单商品剩余商品数量
            //         $return_wogo_data['wogo_update_time'] = date('Y-m-d H:i:s'); //工单商品更新时间
            //         // 更改商品数量
            //         $return_wogo_res = DB::table('work_good')
            //             ->where('wogo_id', $value['wogo_id'])
            //             ->update($return_wogo_data);
            //         $return_orgo_data['orgo_new_goo_quantity'] = $remain_goo_amount; //订单商品剩余商品数量
            //         $return_orgo_data['orgo_update_time'] = date('Y-m-d H:i:s'); //订单商品更新时间
            //         $return_orgo_res = DB::table('order_goods')
            //             ->where('orgo_id', $value['wogo_orgo_id'])
            //             ->update($return_orgo_data);
            //         unset($return_orgo_data);
            //         if (!$return_orgo_res) {
            //             return ['code'=>500, 'msg'=>'提交失败01！', 'data'=>'{}'];
            //         }
            //     }
            //     // 存在工单商品退回的情况，生成退换入库单
            //     if (!empty($goo_return_data) && $find_work->wor_is_recycle == 1 && !empty($find_work->wor_ware_id)) {
            //         // 10.1退换回收单表添加数据
            //         $rec_number = 'TH' . rand(100, 999) . date('mdHis') . rand(100000, 999999); // 回收单号
            //         $add_recycle['rec_cid'] = $user_info->adm_cid; //公司id
            //         $add_recycle['rec_shop_id'] = $user_info->adm_shop_id; //门店id
            //         $add_recycle['rec_superior_shop_id'] = $shop_id; //总店id
            //         $add_recycle['rec_date'] = date('Y-m-d'); //日期
            //         $add_recycle['rec_number'] = $rec_number; //回收单号
            //         $add_recycle['rec_ord_id'] = $request['wor_id']; //工单id
            //         $add_recycle['rec_ord_order_number'] = $find_work->wor_number; //工单号
            //         $add_recycle['rec_source_type'] = 5; //类型 4 (工单号)退货单 5技师退回 6技师拒单 7技师终止 8(订单号)退货单
            //         $add_recycle['rec_amount'] = $goo_return_numbers; //退换总数量
            //         $add_recycle['rec_state'] = 1; //回收状态 1.未回收 2.已回收
            //         $add_recycle['rec_type'] = $find_work->wor_type; //买家类型 1.门店零售 2.来往单位
            //         $add_recycle['rec_ware_id'] =  $find_work->wor_ware_id; //仓库id
            //         $add_recycle['rec_create_adm_id'] = $user_info->adm_id; //创建人id
            //         $recycle_id = DB::table('recede_recycle')->insertGetId($add_recycle);
            //         if (empty($recycle_id)) {
            //             return ['code'=>500, 'msg'=>'商品退回失败！', 'data'=>'{}'];
            //         }
            //         $rego_key = 0;
            //         // 10.2退换回收商品表添加数据
            //         foreach ($goo_return_data as $key => $value) {
            //             $rego_data[$rego_key]['rego_rec_id'] = $recycle_id; //退换回收单id
            //             $rego_data[$rego_key]['rego_orgo_id'] = $value['wogo_orgo_id']; //订单商品主键id
            //             $rego_data[$rego_key]['rego_ware_id'] = $find_work->wor_ware_id; //仓库id
            //             $rego_data[$rego_key]['rego_waon_class'] = $value['wogo_waon_class']; //仓库类别
            //             $rego_data[$rego_key]['rego_wago_id'] = $value['wogo_wago_id']; //仓库商品id
            //             $rego_data[$rego_key]['rego_goo_id'] = $value['wogo_goo_id']; //商品id
            //             $rego_data[$rego_key]['rego_sell_number'] =  $value['wogo_goo_amount']; //销售数量
            //             $rego_data[$rego_key]['rego_recycle_number'] =  $value['wogo_recycle_quantity']; //回收数量
            //             $rego_data[$rego_key]['rego_goo_inventory'] =  $value['wogo_goo_inventory']; //出库类型1.良品 2.优先
            //             $rego_data[$rego_key]['rego_goo_unit'] =  isset($value['wogo_goo_unit'])?$value['wogo_goo_unit']:''; //单位
            //             $rego_data[$rego_key]['rego_goo_unta_id'] =  isset($value['wogo_goo_unta_id'])?$value['wogo_goo_unta_id']:''; //单位id
            //             $rego_data[$rego_key]['rego_goo_name'] = $value['wogo_goo_name'];
            //             $rego_data[$rego_key]['rego_goo_goods_encode'] = isset($value['wogo_goo_goods_encode']) ? $value['wogo_goo_goods_encode'] :'';
            //             if ($value['wogo_goo_inventory'] == 1) {
            //                 $rego_data[$rego_key]['rego_fine_quantity'] = $value['wogo_recycle_quantity'];
            //                 $rego_data[$rego_key]['rego_priority_quantity'] = 0;
            //             } else {
            //                 $rego_data[$rego_key]['rego_fine_quantity'] = 0;
            //                 $rego_data[$rego_key]['rego_priority_quantity'] = $value['goo_return_number'];
            //             }
            //             $rego_key++;
            //         }
            //         $add_goods =  DB::table('recede_goods')->insert($rego_data);

            //         $work_client = DB::table('work_client')
            //             ->where('wocl_wor_id', $request['wor_id'])
            //             ->select('wocl_client_id', 'wocl_bus_name', 'wocl_name', 'wocl_phone')
            //             ->first();
            //         // 10.3 退换回收客户表添加数据
            //         $recl_data['recl_rec_id'] = $recycle_id; //回收单id
            //         $recl_data['recl_client_id'] = $work_client->wocl_client_id; //来往单位id/客户id
            //         $recl_data['recl_name'] = $work_client->wocl_name; //客户姓名
            //         $recl_data['recl_phone'] = $work_client->wocl_phone; //联系电话
            //         if ($find_work->wor_type == 2) {
            //             $recl_data['recl_channel_unit'] = $work_client->wocl_bus_name; //合作商
            //         }
            //         $add_client =  DB::table('recede_client')->insert($recl_data);
            //         if (empty($add_client) || empty($add_goods)) {
            //             return ['code'=>500, 'msg'=>'商品退回失败！', 'data'=>'{}'];
            //         }
            //     }
            // }
        }
        // 3.工单修改为完成状态 上传图片 旧货总的实际回收数量 审核
        $update_data['wor_update_time'] = date('Y-m-d H:i:s');
        $update_data['wor_pass'] = 1; //改为待审核状态
        $update_data['wor_achieve_time'] = date('Y-m-d H:i:s'); //修改完成时间
        $find_shop_listpic = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->value('shop_user_list_workpic');
        if ($find_shop_listpic == 1) {
            $update_data['wor_list_pic'] = 1;
        } else {
            $update_data['wor_list_pic'] = 2;
        }
        $save_state = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->update($update_data);
        if (!$save_state) {
            return ['code'=>500, 'msg'=>'提交失败', 'data'=>''];
        }

        if (!empty($request['remark'])) {
            $wor_edit_data['wor_remark'] = $request['remark'];
        }
        $find_com_img = DB::table('completion_info')
            ->where('coin_wor_id', $request['wor_id'])
            ->where('coin_type', 3)
            ->where('coin_must', 1)
            ->get()->toArray();
        if (!empty($find_com_img)) {
            foreach ($find_com_img as $key => $value) {
                if (empty($value->coin_data)) {
                    return ['code'=>500, 'msg'=>'请上传施工图片', 'data'=>''];
                }
            }
        }

        if ($find_work->wor_need_return == 1) {
            $wor_edit_data['wor_service_state'] = 6;
            $wor_edit_data['wor_state'] = 8;//施工待审核
        } else {
            $wor_edit_data['wor_service_state'] = 7;
            $wor_edit_data['wor_state'] = 9;//还件
        }
        $wor_edit_data['wor_other_audit'] = 1;
        $wor_edit_data['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_edit_res = WashWork::where('wor_id', $request['wor_id'])->update($wor_edit_data);
        // 智配贴装的订单状态改为已完成，不用评价
        // if ($find_work->wor_work_type == 2) {
        //     $ord_edit_data['ord_wor_state'] = 20;
        // } else {
        //     $ord_edit_data['ord_wor_state'] = 4;
        //     if (empty($find_work->wocl_client_id)) {
        //         $ord_edit_data['ord_wor_state'] = 20;
        //     }
        // }
        // $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        // $ord_edit_res = DB::table('order')->where('ord_id', $find_work->wor_order_id)->update($ord_edit_data);

        // 同步智配贴装提交信息
        // if ($find_work->wor_work_type == 2) {
        //     $find_service_adm = DB::table('admin')
        //         ->where('adm_id', $find_work->wor_service_adm_id)
        //         ->select('adm_name', 'adm_phone')
        //         ->first();
        //     $order_data = DB::table('order')
        //         ->where('ord_id', $find_work->wor_order_id)
        //         ->select('ord_other_system_number')
        //         ->first();
        //     $server = config('apisystem.server_name') . '/';
        //     $find_image_upload = [];
        //     $image_key = 0;
        //     $wotp_service_data = DB::table('completion_info')
        //         ->where('coin_wor_id', $request['wor_id'])
        //         ->whereIn('coin_type', [2,3])
        //         ->select('coin_data', 'coin_name')
        //         ->get()->toArray();
        //     foreach ($wotp_service_data as $key => $value) {
        //         $find_image_upload[$image_key]['imup_path'] = addHttpurl($value->coin_data); //$server . $pic_value;
        //         $find_image_upload[$image_key]['imup_image_name'] = $value->coin_name; //$server . $pic_value;
        //         $image_key++;
        //     }
        //     $check_car_image = [];
        //     $ca_key = 0;
        //     $check_car = DB::table('wash_validate_car')
        //         ->where('vaca_ord_id', $find_work->wor_order_id)
        //         ->where('vaca_type', 1)
        //         ->where('vaca_must', 1)
        //         ->select('vaca_name', 'vaca_data')
        //         ->get()->toArray();
        //     foreach ($check_car as $k1 => $v1) {
        //         $check_car_image[$ca_key]['imup_path'] = addHttpurl($v1->vaca_data); //$server . $pic_value;
        //         $check_car_image[$ca_key]['imup_image_name'] = $v1->vaca_name; //$server . $pic_value;
        //         $ca_key++;
        //     }
        //     $find_image_upload = array_merge($find_image_upload,$check_car_image);
        //     $url = config('apiconnect.ZPTZ_URL') . '/index.php/api/supplychain/SupplyMz/installLine';
        //     $param['state'] = 5;
        //     $param['time'] = date('Y-m-d H:i:s');
        //     $param['ip'] = Request::getClientIp();
        //     $param['filePic'] = $find_image_upload; //图片
        //     $param['token'] = md5(md5($param['time'] . config('apiconnect.ZPTZ_TOKEN'))); //token
        //     $param['serial_number'] = $order_data->ord_other_system_number; //第三方工单号
        //     $param['install_name'] = $find_service_adm->adm_name;
        //     $param['install_phone'] = $find_service_adm->adm_phone;
        //     $param['app_achieve_time'] = date('Y-m-d H:i:s'); //完成提交时间
        //     $param_return = doPost($param, $url, 2);
        //     $param_return = json_decode($param_return, true);
        //     if ($param_return['code'] != 200) {
        //         return ['code'=>500, 'msg'=>'完成提交同步失败', 'data'=>$order_data->ord_other_system_number, 'zptzmsg'=>$param_return];
        //     }
        // }
        $ord_data = DB::table('order')
            ->where('ord_id', $find_work->wor_order_id)
            ->select('ord_state', 'ord_wor_state', 'ord_type')
            ->first();
        // if ($ord_data->ord_state == 2 && ($ord_data->ord_wor_state == 4 || $ord_data->ord_wor_state == 20) && $ord_data->ord_type == 1) {//已结算 待评价或已完成 个人会员 添加积分
        //     $add_point = WashOrderBasicService::addPoint($user_info,$find_work->wocl_client_id,$find_work->wor_order_id);
        // }
        if ($wor_edit_res) {
            $return_data['wor_number'] = $find_work->wor_number; //工单单号
            $return_data['wocl_car_num'] = $find_work->wocl_car_num; //工单单号
            // 工单的历史记录
            $data['wohi_primary_id'] = $request['wor_id'];
            $data['wohi_state_name'] = '已完成';
            $data['wohi_state'] = 5;//服务状态：5已完成
            $data['wohi_type'] = 2;//1订单2工单
            addHistory($data);
            unset($data);
            return ['code'=>200, 'msg'=>'提交工单成功', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'提交工单失败', 'data'=>''];
        }
    }

    // 提交施工
    public static function submitConstruction($user_info, $request)
    {
        // 查询当前工单的商品是否发货，没有发货的不能开始施工
        $dispatch_bill = DB::table('dispatch_bill')
            ->where('dego_wor_id', $request['wor_id'])
            ->where('dego_order_type', 2)
            ->where('dego_type', 1)
            ->first();
        if (!empty($dispatch_bill)) {
            return ['code'=>500, 'msg'=>'请取货后再开始施工！', 'data'=>'请取货后再开始施工！'];
        }
        $find_work = DB::table('work_order as wor')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_state', 'wor_order_id', 'wor_order_number', 'wor_service_adm_id', 'wor_appoint_time', 'wor_create_time')
            ->first();
        if (empty($find_work)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前工单不存在', 'data'=>''];
        }
        if ($find_work->wor_state != 7) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前工单不是待施工状态', 'data'=>''];
        }

        $sub_work_data = $request['sub_work_data'];
        foreach ($sub_work_data as $key => $value) {
            $find_woch2 = DB::table('wash_work_check_history')
                ->where('woch_shop_id', $user_info->adm_shop_id)
                ->where('woch_adm_id', $value['adm_id'])
                ->where('woch_wor_id', $request['wor_id'])
                ->where('woch_check_res', 2)
                ->value('woch_check_res');
            if ($find_woch2 && $value['adm_id'] != $find_work->wor_service_adm_id) {
                return ['code'=>500, 'msg'=>'质检已通过!', 'data'=>''];
            }
            $find_woch1 = DB::table('wash_work_check_history')
                ->where('woch_shop_id', $user_info->adm_shop_id)
                ->where('woch_adm_id', $value['adm_id'])
                ->where('woch_wor_id', $request['wor_id'])
                ->where('woch_check_res', 1)
                ->value('woch_id');
            if ($find_woch1) {
                return ['code'=>500, 'msg'=>'质检审核中', 'data'=>''];
            }
            $add_data['woch_shop_id'] = $user_info->adm_shop_id;
            $add_data['woch_adm_id'] = $value['adm_id'];
            $add_data['woch_wor_id'] = $request['wor_id'];
            $add_data['woch_part_data'] = $value['woch_part_data'];//施工数据
            if ($find_work->wor_service_adm_id == $user_info->adm_id) {//判断是否是组长
                $add_data['woch_check_res'] = 2;//质检结果1提交/未质检2通过3返工
                $update_data['wotp_submit_state'] = 2;//提交状态:0未提交1提交待审核2通过3返工
            } else {
                $add_data['woch_check_res'] = 1;//质检结果1提交/未质检2通过3返工
                $update_data['wotp_submit_state'] = 1;//提交状态:0未提交1提交待审核2返工3通过
            }
            $add_data['woch_create_time'] = date('Y-m-d H:i:s');
            if ($find_work->wor_service_adm_id == $value['adm_id'] && $find_woch2) {
                // 组长修改施工信息不用添加施工历史
                $add_data_res = true;
            } else {
                $add_data_res = DB::table('wash_work_check_history')->insertGetId($add_data);
                if (!$add_data_res) {
                    return ['code'=>500, 'msg'=>'提交失败', 'data'=>''];
                }
            }
            $update_data['wotp_service_data'] = $value['woch_part_data'];//施工数据
            $update_data['wotp_update_time'] = date('Y-m-d H:i:s');
            $update_res = DB::table('wash_work_technician_part')
                ->where('wotp_shop_id', $user_info->adm_shop_id)
                ->where('wotp_wor_id', $request['wor_id'])
                ->where('wotp_service_adm_id', $value['adm_id'])
                ->update($update_data);
            if (!$update_res) {
                return ['code'=>500, 'msg'=>'提交失败！', 'data'=>''];
            }
        }

        //工单的质检状态
        $find_all_wotp = DB::table('wash_work_technician_part')
            ->where('wotp_wor_id', $request['wor_id'])
            ->select('wotp_submit_state', 'wotp_service_adm_name', 'wotp_service_adm_id')
            ->get()->toArray();
        foreach ($find_all_wotp as $key1 => $value1) {
            if ($value1->wotp_submit_state == 1 || $value1->wotp_submit_state == 2) {//提交状态:0未提交1提交待审核2通过3返工
                $wor_check_res = $value1->wotp_submit_state;
            } elseif ($value1->wotp_submit_state == 0 || $value1->wotp_submit_state == 3) {
                $wor_check_res = $value1->wotp_submit_state;
                break;
            }
        }
        $count_admin = count($find_all_wotp);
        if ($wor_check_res == 1 || $wor_check_res == 2 && $count_admin > 1 && $user_info->adm_id != $find_work->wor_service_adm_id) {
            // 添加技师消息
            $add_data_admin['adm_id'] = $find_work->wor_service_adm_id;
            $add_data_admin['shop_id'] = $user_info->adm_shop_id;
            $add_data_admin['primary_id'] = $request['wor_id']; //单据的主键id
            $add_data_admin['primary_type'] = 2; //单据类型：1订单2工单3预约单4售后单
            $add_data_admin['message_type'] = 1;
            $add_data_admin['title'] = '待质检通知'; //操作内容
            $add_data_admin['content'] = '组员已全部提交施工，请及时质检'; //操作内容
            $add_data_admin['read_state'] = 1; //阅读状态：1未读2已读
            $add_data_admin['create_adm_name'] = $user_info->adm_name; //操作人姓名
            $add_data_admin['create_adm_id'] = $user_info->adm_id; //操作人id
            $addAdminMessage_res = addAdminMessage($add_data_admin);
            if ($addAdminMessage_res['code'] != 200) {
                return $addAdminMessage_res;
            }
            $find_admin = DB::table('admin')
                ->where('adm_id', $find_work->wor_service_adm_id)
                ->select('adm_name', 'adm_phone', 'adm_id')
                ->first();
            $find_wogo_data = DB::table('work_good as wogo')
                ->leftJoin('service_project as sp', 'sp.sepr_id', '=', 'wogo.wogo_goo_id')
                ->where('wogo_wor_id', $request['wor_id'])
                ->where('wogo_goo_type', 2)
                ->select('wogo_goo_id', 'sepr_name', 'sepr_check_car', 'sepr_id', 'wogo_goo_type')
                ->get()->toArray();
            $sepr_name = '';
            if ($find_wogo_data) {
                foreach ($find_wogo_data as $key => $value) {
                    $sepr_name = $sepr_name.','.$value->sepr_name;
                }
            }
            // 微信消息推送
            $wechat_msg['pushtype'] = 3; //工单进度通知
            $wechat_msg['adm_id'] = $find_work->wor_service_adm_id; //推送人
            $wechat_msg['wor_number'] = $find_work->wor_number; //工单号
            $wechat_msg['ord_number'] = $find_work->wor_order_number; //订单号
            $wechat_msg['user_name'] = $find_admin->adm_name; //姓名
            $wechat_msg['user_phone'] = $find_admin->adm_phone; //手机号
            $wechat_msg['sepr_name'] = $sepr_name; //服务项目
            $wechat_msg['wor_state'] = '待质检'; //服务项目
            $wechat_msg['orcl_appoint_time'] = $find_work->wor_appoint_time; //预约时间
            $wechat_msg['ord_create_time'] = $find_work->wor_create_time; //工单创建时间
            $wechat_msg['tittle'] = '组员已全部提交施工，请及时质检'; //手机
            $wechat_msg['remark'] = !empty($find_work->wor_remark) ? $find_work->wor_remark : '';
            $CashierDesk = new CashierDesk;
            $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
        }
        if ($add_data_res && $update_res) {
            return ['code'=>200, 'msg'=>'提交施工成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'提交施工失败', 'data'=>''];
        }
    }

    // 质检
    public static function qualityTesting($user_info, $request)
    {
        $find_work_item_adm = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->select('wor_service_adm_id')
            ->first();
        if ($request['type'] == 1) {//查看所有组员的最新质检信息
            if ($user_info->adm_id == $find_work_item_adm->wor_service_adm_id) {
                $find_data = DB::table('wash_work_technician_part as w')
                    ->leftJoin('admin as a', 'a.adm_id', '=', 'w.wotp_service_adm_id')
                    ->where('wotp_shop_id', $user_info->adm_shop_id)
                    ->where('wotp_service_adm_id', '<>', $find_work_item_adm->wor_service_adm_id)
                    ->where('wotp_wor_id', $request['wor_id'])
                    ->select('wotp_service_adm_id', 'wotp_service_data', 'wotp_service_qualitytesting', 'adm_name', 'adm_phone', 'wotp_submit_state')
                    ->get()->toArray();
            } else {
                $find_data = DB::table('wash_work_technician_part as w')
                    ->leftJoin('admin as a', 'a.adm_id', '=', 'w.wotp_service_adm_id')
                    ->where('wotp_shop_id', $user_info->adm_shop_id)
                    ->where('wotp_service_adm_id', $user_info->adm_id)
                    ->where('wotp_wor_id', $request['wor_id'])
                    ->select('wotp_service_adm_id', 'wotp_service_data', 'wotp_service_qualitytesting', 'adm_name', 'adm_phone', 'wotp_submit_state')
                    ->get()->toArray();
            }
            return ['code'=>200, 'msg'=>'success', 'data'=>$find_data];
        } elseif ($request['type'] == 2) {//提交质检
            if (!isset($request['wotp_service_qualitytesting']) || empty($request['wotp_service_qualitytesting'])) {
                $update_woch_data['woch_check'] = '';
                $update_wotp_data['wotp_service_qualitytesting'] = '';
            } else {
                $update_woch_data['woch_check'] = $request['wotp_service_qualitytesting'];
                $update_wotp_data['wotp_service_qualitytesting'] = $request['wotp_service_qualitytesting'];
            }
            $update_wotp_data['wotp_submit_state'] = $request['woch_check_res'];//2通过3返工
            $update_woch_data['woch_check_res'] = $request['woch_check_res'];//质检结果1未质检2通过3返工
            $update_woch_data['woch_update_time'] = date('Y-m-d H:i:s');
            $update_woch_res = DB::table('wash_work_check_history')
                ->where('woch_wor_id', $request['wor_id'])
                ->where('woch_adm_id', $request['woch_adm_id'])
                ->where('woch_check_res', 1)
                ->update($update_woch_data);
            $update_wotp_data['wotp_update_time'] = date('Y-m-d H:i:s');
            $update_wotp_res = DB::table('wash_work_technician_part')
                ->where('wotp_shop_id', $user_info->adm_shop_id)
                ->where('wotp_wor_id', $request['wor_id'])
                ->where('wotp_service_adm_id', $request['woch_adm_id'])
                ->update($update_wotp_data);
            if ($request['woch_check_res'] == 3) {
                $find_work = DB::table('work_order as wor')
                    ->where('wor_id', $request['wor_id'])
                    ->select('wor_number', 'wor_order_number', 'wor_appoint_time', 'wor_remark')
                    ->first();
                $find_admin = DB::table('wash_work_check_history as w')
                    ->leftJoin('admin as a', 'a.adm_id', '=', 'w.woch_adm_id')
                    ->where('woch_wor_id', $request['wor_id'])
                    ->where('woch_adm_id', $request['woch_adm_id'])
                    ->select('adm_name', 'adm_id', 'adm_phone')
                    ->first();
                // 添加技师消息
                $add_data_admin['adm_id'] = $find_admin->adm_id;
                $add_data_admin['shop_id'] = $user_info->adm_shop_id;
                $add_data_admin['primary_id'] = $request['wor_id']; //单据的主键id
                $add_data_admin['primary_type'] = 2; //单据类型：1订单2工单3预约单4售后单
                $add_data_admin['message_type'] = 1;
                $add_data_admin['title'] = '返工通知'; //操作内容
                $add_data_admin['content'] = '您提交的施工需要返工，请查看'; //操作内容
                $add_data_admin['read_state'] = 1; //阅读状态：1未读2已读
                $add_data_admin['create_adm_name'] = $user_info->adm_name; //操作人姓名
                $add_data_admin['create_adm_id'] = $user_info->adm_id; //操作人id
                $addAdminMessage_res = addAdminMessage($add_data_admin);
                if ($addAdminMessage_res['code'] != 200) {
                    return $addAdminMessage_res;
                }
                $find_wogo_data = DB::table('work_good as wogo')
                    ->leftJoin('service_project as sp', 'sp.sepr_id', '=', 'wogo.wogo_goo_id')
                    ->where('wogo_wor_id', $request['wor_id'])
                    ->where('wogo_goo_type', 2)
                    ->select('wogo_goo_id', 'sepr_name', 'sepr_check_car', 'sepr_id', 'wogo_goo_type')
                    ->get()->toArray();
                $sepr_name = '';
                if ($find_wogo_data) {
                    foreach ($find_wogo_data as $key => $value) {
                        $sepr_name = $sepr_name.','.$value->sepr_name;
                    }
                }
                // 微信消息推送
                $wechat_msg['pushtype'] = 3; //质检返工
                $wechat_msg['adm_id'] = $find_admin->adm_id; //推送人
                $wechat_msg['wor_number'] = $find_work->wor_number; //工单号
                $wechat_msg['ord_number'] = $find_work->wor_order_number; //订单号
                $wechat_msg['user_name'] = $find_admin->adm_name; //姓名
                $wechat_msg['wor_state'] = '返工'; //工单进度
                $wechat_msg['user_data'] = $find_admin->adm_name.' '.$find_admin->adm_phone; //姓名
                $wechat_msg['sepr_name'] = $sepr_name; //服务项目
                $wechat_msg['orcl_appoint_time'] = $find_work->wor_appoint_time; //预约时间
                $wechat_msg['user_phone'] = $find_admin->adm_phone; //手机号
                $wechat_msg['tittle'] = '您提交的施工需要返工，请查看'; //手机
                $wechat_msg['remark'] = !empty($find_work->wor_remark) ? $find_work->wor_remark : '';
                $CashierDesk = new CashierDesk;
                $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
            }
            if ($update_woch_res && $update_wotp_res) {
                return ['code'=>200, 'msg'=>'success', 'data'=>'质检成功'];
            } else {
                return ['code'=>500, 'msg'=>'error', 'data'=>'质检失败'];
            }
        } elseif ($request['type'] == 3) {//查看施工历史
            if (!isset($request['woch_adm_id']) || empty($request['woch_adm_id'])) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'请选择技师，参数错误'];
            }
            /*$find_data = DB::table('wash_work_check_history')
                ->leftJoin('admin as a', 'a.adm_id', '=', 'woch_adm_id')
                ->where('woch_shop_id', $user_info->adm_shop_id)
                ->where('woch_wor_id', $request['wor_id'])
                ->where('woch_adm_id', $request['woch_adm_id'])
                ->select('woch_adm_id', 'woch_part_data', 'woch_check_res', 'woch_check', 'adm_name', 'woch_create_time')
                ->orderBy('woch_create_time', 'desc')
                ->get()->toArray();*/
            //$completion_info = self::completionInfoByWorId($request['wor_id']);//施工数据
            $qulity_info = self::qualityDataByWorId($request['wor_id']);//质检数据
            //$data['new_wotp_service_data'] = $completion_info[$request['woch_adm_id']]['technician']??[];//施工数据
            $data['quality_data'] = $qulity_info[$request['woch_adm_id']]['quality']??[];//质检数据
            if(empty($data['quality_data'])){
                $data['quality_data']['img'] = [];
                $data['quality_data']['tab'] = [];
            }
            return ['code'=>200, 'msg'=>'success', 'data'=>$data];
        }
    }

    // 详情
    public static function info($user_info, $request)
    {
        $info = DB::table('work_order as wo')
            ->leftJoin('order_client as oc', 'oc.orcl_ord_id', '=', 'wo.wor_order_id')
            ->leftJoin('order as o', 'o.ord_id', '=', 'wo.wor_order_id')
            ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
            ->leftJoin('shop as s', 's.shop_id', '=', 'wo.wor_shop_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_id', 'wor_number', 'wor_create_id', 'wor_goo_amount', 'wor_actual_price', 'wor_account_state', 'wor_type', 'wor_state', 'wor_delete', 'wocl_channel_unit', 'wocl_name', 'wocl_phone', 'wocl_car_num', 'wocl_province', 'wocl_city', 'wocl_county', 'wocl_address', 'wocl_client_id', 'wor_appoint_time', 'wocl_appoint_remark', 'wocl_car_vehicle_type', 'wocl_pick_up_car_time', 'wocl_check_car_state', 'wocl_service_quality', 'wocl_car_vin', 'shop_store_name', 'wor_service_state', 'wor_province', 'wor_city', 'wor_county', 'wor_address', 'orcl_sales_adm_id', 'wocl_car_brand_series', 'wocl_carowner_name', 'wocl_carowner_phone', 'wor_create_time', 'wor_new_goo_amount', 'wor_explain as wor_remark', 'wocl_bus_name', 'wor_address_type', 'wor_address_id', 'wor_shop_id', 'wor_service_adm_id', 'wocl_carbrse_type', 'wor_order_id', 'wor_work_type', 'wor_other_audit', 'ord_type', 'ord_address', 'orcl_cus_msg', 'ord_id', 'orcl_cus_msg','orcl_mileage', 'orcl_check_goods', 'orcl_check_goods', 'wor_order_number', 'wor_list_pic', 'ord_new_type','ord_state')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前工单不存在', 'data'=>''];
        }
        $ord_Explainpic = [];
        $Explainpic = WashOrderService::getExplainpic($user_info, $info->ord_id);
        if (!empty($Explainpic['data'])) {
            $ord_Explainpic = $Explainpic['data'];
        }
        $info->ord_explain_pic = $ord_Explainpic;
        // 获取该工单下的商品信息
        $goods_data = DB::table('work_good as wg')
            ->leftjoin('goods as g', 'g.goo_id', '=', 'wg.wogo_goo_id')
            ->where('wogo_wor_id', $request['wor_id'])
            ->select('wogo_id', 'wogo_wor_id', 'wogo_goo_id', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_goo_price', 'wogo_goo_guarantee', 'wogo_goo_type', 'wogo_state', 'wogo_goo_amount', 'wogo_goo_unit', 'wogo_goo_unta_id', 'goo_unit_conversion', 'wogo_new_goo_amount', 'wogo_goo_waste_number', 'wogo_recycle_quantity')
            ->get()->toArray();
        $validate_car = DB::table('wash_order_validate_car')
            ->where('orvc_ord_id', $info->wor_order_id)
            ->select('orvc_adm_id')
            ->first();
        if ($validate_car) {
            $info->orvc_adm_id = $validate_car->orvc_adm_id; //验车人
        } else {
            $info->orvc_adm_id = '';
        }
        $adm_id[] = $info->wor_service_adm_id; //服务技师组长id
        // 账号id
        $adm_id[] = $info->wor_create_id;
        $adm_id[] = $info->orcl_sales_adm_id;
        $adm_id = array_filter(array_unique($adm_id));
        // 查询账号id对应姓名
        $adm_name = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->pluck('adm_name', 'adm_id')
            ->toArray();
        // 查询账号id对应电话
        $adm_phone = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->pluck('adm_phone', 'adm_id')
            ->toArray();
        $info->create_name = '';
        if ($info->wor_create_id != '0' && isset($adm_name[$info->wor_create_id])) {
            $info->create_name = $adm_name[$info->wor_create_id]; //创建人
        }
        // 施工地址
        if ($info->wor_address_type == 1) {//门店
            $find_address = DB::table('shop')
                ->where('shop_id', $info->wor_address_id)
                ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                ->first();
            if ($find_address) {
                $info->shop_store_name = $find_address->shop_store_name;
                $info->wor_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
            }
        } elseif ($info->wor_address_type == 2) {
            $find_address = DB::table('business_client')
                ->where('bucl_id', $info->wor_address_id)
                ->select('bucl_id', 'bucl_name', 'bucl_province', 'bucl_city', 'bucl_address', 'bucl_county')
                ->first();
            if ($find_address) {
                $info->shop_store_name = $find_address->bucl_name;
                $info->wor_address = $find_address->bucl_province.$find_address->bucl_city.$find_address->bucl_county.$find_address->bucl_address;
            }
        } else {
            $find_address = DB::table('shop')
                ->where('shop_id', $info->wor_shop_id)
                ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                ->first();
            if ($find_address) {
                $info->shop_store_name = $find_address->shop_store_name;
                $info->wor_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
            }
        }
        $info->orcl_sales_adm_name = '';
        $info->orcl_sales_adm_phone = '';
        if ($info->orcl_sales_adm_id != '0') {
            $info->orcl_sales_adm_name = $adm_name[$info->orcl_sales_adm_id]??''; //销售人
            $info->orcl_sales_adm_phone = $adm_phone[$info->orcl_sales_adm_id]??''; //销售人电话
        }
        $find_all_wotp = DB::table('wash_work_technician_part')
            ->where('wotp_wor_id', $request['wor_id'])
            ->select('wotp_submit_state', 'wotp_service_adm_name', 'wotp_service_adm_id', 'wotp_work_type')
            ->orderBy('wotp_work_type')
            ->get()->toArray();
        foreach ($find_all_wotp as $key1 => $value1) {
            if ($value1->wotp_submit_state != 2) {
                $info->wor_check_res = $value1->wotp_submit_state;
                break;
            } else {
                $info->wor_check_res = 2;
            }
        }

        $info->service_adm_num = count($find_all_wotp);
        $wor_service_adm_id = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->value('wor_service_adm_id');
        $num = 0;

        foreach ($find_all_wotp as $key2 => $value2) {
            switch ($value2->wotp_work_type) {
                case '1':
                    $work_type_name = '取件';
                    break;
                case '2':
                    $work_type_name = '维修';
                    break;
                case '3':
                    $work_type_name = '还件';
                    break;
                default:
                    $work_type_name = '取件';
                    break;
            }
            if ($value2->wotp_service_adm_name && !empty($info->service_adm_names)) {
                $info->service_adm_names = $info->service_adm_names.'、'.$value2->wotp_service_adm_name.'('.$work_type_name.')';
            } else {
                $info->service_adm_names = $value2->wotp_service_adm_name.'('.$work_type_name.')';
            }
            $num++;
        }
        $info->service_adm_num = $num;
        unset($num);
        unset($find_all_wotp);
        // 质检状态
        $find_woch = DB::table('wash_work_check_history')
            ->where('woch_wor_id', $request['wor_id'])
            ->where('woch_adm_id', $user_info->adm_id)
            ->select('woch_check_res', 'woch_check')
            ->orderBy('woch_create_time', 'desc')
            ->first();
        if ($find_woch) {
            $info->woch_check_res = $find_woch->woch_check_res;
            $info->woch_check_data = $find_woch->woch_check;
        } else {
            $info->woch_check_res = 0;
            $info->woch_check_data = '';
        }
        unset($info->wor_create_id);

        foreach ($goods_data as $key => $value) {
            if ($value->wogo_state == 2) {
                $goods_data[$key]->wogo_goo_amount = '';
                $goods_data[$key]->wogo_goo_price = '';
            }
            $goods_data[$key]->wogo_new_goo_amount = $value->wogo_new_goo_amount.$value->wogo_goo_unit;
            $goods_data[$key]->wogo_recycle_quantity = $value->wogo_recycle_quantity.$value->wogo_goo_unit;
            $goods_data[$key]->wogo_goo_waste_number = $value->wogo_goo_waste_number.$value->wogo_goo_unit;
        }
        $info->sepr_check_car = 2;
        foreach ($goods_data as $key => $value) {
            if ($value->wogo_goo_type == 2) {
                $sepr_check_car = DB::table('service_project')
                    ->where('sepr_id', $value->wogo_goo_id)
                    ->value('sepr_check_car');
                if ($sepr_check_car == 1) {
                    $info->sepr_check_car = 1;
                    break;
                }
            }
        }
        $find_dis = DB::table('dispatch_bill')
            ->where('dego_shop_id', $user_info->adm_shop_id)
            ->where('dego_wor_id', $request['wor_id'])
            ->where('dego_order_type', 2)
            ->orderBy('dego_id', 'desc')
            ->limit(1)
            ->pluck('dego_type', 'dego_wor_id')->toArray();
        $find_dis_pic = DB::table('dispatch_bill')
            ->where('dego_shop_id', $user_info->adm_shop_id)
            ->where('dego_wor_id', $request['wor_id'])
            ->where('dego_order_type', 2)
            ->pluck('dego_pic', 'dego_wor_id')->toArray();

        // 发货状态
        if (isset($find_dis[$info->wor_id])) {
            $info->dego_type = $find_dis[$info->wor_id];
        } else {
            $info->dego_type = 0;
        }
        // 发货图片
        if (isset($find_dis_pic[$info->wor_id])) {
            $info->dego_pic = $find_dis_pic[$info->wor_id];
        } else {
            $info->dego_pic = '';
        }

        // 获取枚举数据
        $object_enum = new WorkOrderEnum();
        $wor_work_type_enum = $object_enum->keyValueEnum($object_enum->wor_work_type_enum);
        $wor_other_audit_enum = $object_enum->keyValueEnum($object_enum->wor_other_audit_enum);
        $info->wor_work_type_show = $wor_work_type_enum[$info->wor_work_type];
        $info->wor_other_audit_show = $wor_other_audit_enum[$info->wor_other_audit];

        // 查看工单技师施工检测信息
        $technician_part = DB::table('wash_work_technician_part')
            ->where('wotp_wor_id', $request['wor_id'])
            // ->where('wotp_work_type', 2)
            ->select('wotp_id', 'wotp_service_adm_id', 'wotp_grle_id', 'wotp_grle_name', 'wotp_grpr_id', 'wotp_grpr_name', 'wotp_service_adm_name', 'wotp_service_adm_phone', 'wotp_service_part', 'wotp_service_quality', 'wotp_rewards_punishment', 'wotp_service_data', 'wotp_service_qualitytesting', 'wotp_choose_type', 'wotp_car_name', 'wotp_total_price', 'wotp_remark', 'wotp_car_name_id', 'wotp_person_car_price', 'wotp_work_type')
            ->orderBy('wotp_work_type', 'asc')
            ->get()->toArray();
        
        $validate_info = self::washValidateCarByWorId($info->ord_id);//验车数据
        $completion_info = self::completionInfoByWorId($request['wor_id']);//施工数据
        $huanjian_info = self::huanjianInfoByWorId($request['wor_id']);//还件数据
        if($technician_part){
            $qujian_data = [];
            $weixiu_data = [];
            $huanjian_data = [];
            foreach($goods_data as $nk=>$nv) {
                $wash_performance_manage = DB::table('wash_performance_manage')
                    ->where('pema_state', 1)
                    ->where('pema_delete', 1)
                    ->where('pema_service_type_id', $nv->wogo_goo_id)
                    ->select('pema_standard', 'pema_weixiu', 'pema_huanjian')
                    ->first();
                $qujian_data[] = ['wotp_service_part'=>$nv->wogo_goo_name, 'price'=>$wash_performance_manage?$wash_performance_manage->pema_standard:0];
                $weixiu_data[] = ['wotp_service_part'=>$nv->wogo_goo_name, 'price'=>$wash_performance_manage?$wash_performance_manage->pema_weixiu:0];
                $huanjian_data[] = ['wotp_service_part'=>$nv->wogo_goo_name, 'price'=>$wash_performance_manage?$wash_performance_manage->pema_huanjian:0];
            }
            foreach ($technician_part as $tec_key => $tec_value){
                switch ($tec_value->wotp_work_type) {
                    case 1 : 
                        $technician_part[$tec_key]->wotp_work_type_name = '取件';
                        break;
                    case 2 : 
                        $technician_part[$tec_key]->wotp_work_type_name = '维修';
                        break;
                    case 3 : 
                        $technician_part[$tec_key]->wotp_work_type_name = '还件';
                        break;
                    default :
                        $technician_part[$tec_key]->wotp_work_type_name = '取件';
                        break;
                }
                if ($tec_value->wotp_work_type == 1) {
                    $technician_part[$tec_key]->wotp_service_data = $qujian_data;//施工内容
                    $technician_part[$tec_key]->new_wotp_service_data['img'] = $validate_info['data']['img']??[];//验车数据
                }
                if ($tec_value->wotp_work_type == 2) {
                    $technician_part[$tec_key]->wotp_service_data = $weixiu_data;//施工内容
                    $technician_part[$tec_key]->new_wotp_service_data = $completion_info[$tec_value->wotp_service_adm_id]['technician']??[];//施工数据
                }
                if ($tec_value->wotp_work_type == 3) {
                    $technician_part[$tec_key]->wotp_service_data = $huanjian_data;//施工内容
                    $technician_part[$tec_key]->new_wotp_service_data = $huanjian_info[$tec_value->wotp_service_adm_id]['technician']??[];//施工数据
                }
                $technician_part[$tec_key]->quality_data = $qulity_info[$tec_value->wotp_service_adm_id]['quality']??[];//质检数据
                $technician_part[$tec_key]->wotp_service_data_new = [];
                //绩效
                if(isset($completion_info[$tec_value->wotp_service_adm_id]['performance'])){
                    $new_completion = CommonService::jointArrayKey(json_decode(json_encode($completion_info[$tec_value->wotp_service_adm_id]['performance']),true),'coin_adm_id',2);
                    if(!empty($new_completion)){
                        //$find_wotp_data[$key]['wotp_service_data'] = $new_completion[$tec_value->wotp_service_adm_id];
                        foreach ($new_completion[$tec_value->wotp_service_adm_id] as $key_one => $value_one) {
                            $technician_part[$tec_key]->wotp_service_data_new = $new_completion[$tec_value->wotp_service_adm_id];
                        }
                    }
                }
                //质检
                if(isset($qulity_info[$tec_value->wotp_service_adm_id]['quality_info'])){
                    $new_qulity = CommonService::jointArrayKey(json_decode(json_encode($qulity_info[$tec_value->wotp_service_adm_id]['quality_info']),true),'quda_adm_id',2);
                    if(!empty($new_qulity)){
                        foreach ($new_qulity[$tec_value->wotp_service_adm_id] as $keyq_one => $valueq_one) {
                            $technician_part[$tec_key]->wotp_service_qualitytesting = json_encode($new_qulity[$tec_value->wotp_service_adm_id]);
                        }
                    }
                }
            }
        }
        $info->ord_new_type_name = DB::table('order_type')
            ->where('orty_id', $info->ord_new_type)
            ->value('orty_name');
        $data['work_data'] = $info;
        $data['goods_data'] = $goods_data;
        $data['technician_part'] = $technician_part;
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    public static function huanjianInfoByWorId($wor_id){
        //查看工单技师施工检测信息 20230821
        $technician_part = DB::table('completion_info as com')
            ->leftJoin('admin as a', 'com.coin_adm_id', '=', 'a.adm_id')
            ->leftJoin('wash_grade_level as b', 'b.grle_id', '=', 'a.adm_grle_id')
            ->leftJoin('wash_grade_professional as c', 'c.grpr_id', '=', 'b.grle_grpr_id')
            ->where('coin_wor_id', $wor_id)
            ->whereIn('coin_type', [5,6])
            ->select('coin_id', 'coin_shop_id', 'coin_wor_id', 'coin_adm_id', 'coin_type', 'coin_data', 'coin_data_id', 'coin_first_data', 'coin_first_data_id', 'coin_name', 'coin_create_time', 'coin_ord_id', 'coin_must', 'adm_id', 'adm_phone', 'adm_name', 'grle_id', 'grle_name','coin_part_price','coin_person_part_price')
            ->get()->toArray();
        $data = [];
        if($technician_part){
            foreach ($technician_part as $tech_key => $tech_value){
                $data[$tech_value->coin_adm_id]['admin_info']['adm_id'] = $tech_value->adm_id;
                $data[$tech_value->coin_adm_id]['admin_info']['adm_name'] = $tech_value->adm_name;
                $data[$tech_value->coin_adm_id]['admin_info']['adm_phone'] = $tech_value->adm_phone;
                $data[$tech_value->coin_adm_id]['admin_info']['grle_id'] = $tech_value->grle_id;
                $data[$tech_value->coin_adm_id]['admin_info']['grle_name'] = $tech_value->grle_name;
                $data[$tech_value->coin_adm_id]['technician']['all'][] = json_decode(json_encode($tech_value),true);
                $data[$tech_value->coin_adm_id]['technician']['time'] = $tech_value->coin_create_time;
                if(!isset($data[$tech_value->coin_adm_id]['technician']['img'])){$data[$tech_value->coin_adm_id]['technician']['img'] = [];}
                if(!isset($data[$tech_value->coin_adm_id]['technician']['set'])){$data[$tech_value->coin_adm_id]['technician']['set'] = [];}
                if(!isset($data[$tech_value->coin_adm_id]['technician']['tab'])){$data[$tech_value->coin_adm_id]['technician']['tab'] = [];}
                if(!isset($data[$tech_value->coin_adm_id]['technician']['text'])){$data[$tech_value->coin_adm_id]['technician']['text'] = '';}
                if($tech_value->coin_type == 1){//1快捷部位2快捷图片3配置图片
                    $data[$tech_value->coin_adm_id]['technician']['tab'][] = $tech_value->coin_data;
                    $data[$tech_value->coin_adm_id]['technician']['performance'][] = $tech_value;
                    $performance['coin_adm_id'] = $tech_value->coin_adm_id;
                    $performance['wotp_id'] = $tech_value->coin_data_id;
                    $performance['wotp_service_part'] = $tech_value->coin_data;
                    $performance['part_price'] = $tech_value->coin_part_price;
                    $performance['person_part_price'] = $tech_value->coin_person_part_price;
                    if (isset($buwen[$tech_value->coin_data_id])) {
                        $buwen[$tech_value->coin_data_id]['adm_num'] += 1;
                    } else {
                        $buwen[$tech_value->coin_data_id]['adm_num'] = 1;
                    }
                    $data[$tech_value->coin_adm_id]['performance'][] = $performance;
                }else if ($tech_value->coin_type == 5){
                    $data[$tech_value->coin_adm_id]['technician']['img'][] = $tech_value->coin_data;
                }else if ($tech_value->coin_type == 6){
                    $data[$tech_value->coin_adm_id]['technician']['text'] = $tech_value->coin_data;
                }
            }
            if($data){
                foreach ($data as $d_key => $d_value){
                    if(isset($data[$d_key]['performance'])){
                        foreach ($data[$d_key]['performance'] as $p_key => $p_value){
                            $data[$d_key]['performance'][$p_key]['adm_num'] = $buwen[$p_value['wotp_id']]['adm_num'];
                        }

                    }
                }
            }

        }
        return $data;
    }

    /*
     * @name 20230821  新的施工对应的数据
     * @param string ju_ordernum 工单id
     * @retrun array 施工数据
     * @author Ma 2023/8/22 9:32
     *
    */
    public static function completionInfoByWorId($wor_id){
        //查看工单技师施工检测信息 20230821
        $technician_part = DB::table('completion_info as com')
            ->leftJoin('admin as a', 'com.coin_adm_id', '=', 'a.adm_id')
            ->leftJoin('wash_grade_level as b', 'b.grle_id', '=', 'a.adm_grle_id')
            ->leftJoin('wash_grade_professional as c', 'c.grpr_id', '=', 'b.grle_grpr_id')
            ->where('coin_wor_id', $wor_id)
            ->whereIn('coin_type', [1,2,3,4])
            ->select('coin_id', 'coin_shop_id', 'coin_wor_id', 'coin_adm_id', 'coin_type', 'coin_data', 'coin_data_id', 'coin_first_data', 'coin_first_data_id', 'coin_name', 'coin_create_time', 'coin_ord_id', 'coin_must', 'adm_id', 'adm_phone', 'adm_name', 'grle_id', 'grle_name','coin_part_price','coin_person_part_price')
            ->get()->toArray();
        $data = [];
        if($technician_part){
            foreach ($technician_part as $tech_key => $tech_value){
                $data[$tech_value->coin_adm_id]['admin_info']['adm_id'] = $tech_value->adm_id;
                $data[$tech_value->coin_adm_id]['admin_info']['adm_name'] = $tech_value->adm_name;
                $data[$tech_value->coin_adm_id]['admin_info']['adm_phone'] = $tech_value->adm_phone;
                $data[$tech_value->coin_adm_id]['admin_info']['grle_id'] = $tech_value->grle_id;
                $data[$tech_value->coin_adm_id]['admin_info']['grle_name'] = $tech_value->grle_name;
                $data[$tech_value->coin_adm_id]['technician']['all'][] = json_decode(json_encode($tech_value),true);
                $data[$tech_value->coin_adm_id]['technician']['time'] = $tech_value->coin_create_time;
                if(!isset($data[$tech_value->coin_adm_id]['technician']['img'])){$data[$tech_value->coin_adm_id]['technician']['img'] = [];}
                if(!isset($data[$tech_value->coin_adm_id]['technician']['set'])){$data[$tech_value->coin_adm_id]['technician']['set'] = [];}
                if(!isset($data[$tech_value->coin_adm_id]['technician']['tab'])){$data[$tech_value->coin_adm_id]['technician']['tab'] = [];}
                if(!isset($data[$tech_value->coin_adm_id]['technician']['text'])){$data[$tech_value->coin_adm_id]['technician']['text'] = '';}
                if($tech_value->coin_type == 1){//1快捷部位2快捷图片3配置图片
                    // $data[$tech_value->coin_adm_id]['technician']['tab'][] = $tech_value->coin_data;
                    // $data[$tech_value->coin_adm_id]['technician']['performance'][] = $tech_value;
                    // $performance['coin_adm_id'] = $tech_value->coin_adm_id;
                    // $performance['wotp_id'] = $tech_value->coin_data_id;
                    // $performance['wotp_service_part'] = $tech_value->coin_data;
                    // $performance['part_price'] = $tech_value->coin_part_price;
                    // $performance['person_part_price'] = $tech_value->coin_person_part_price;
                    // if (isset($buwen[$tech_value->coin_data_id])) {
                    //     $buwen[$tech_value->coin_data_id]['adm_num'] += 1;
                    // } else {
                    //     $buwen[$tech_value->coin_data_id]['adm_num'] = 1;
                    // }
                    // $data[$tech_value->coin_adm_id]['performance'][] = $performance;
                }else if ($tech_value->coin_type == 2 || $tech_value->coin_type == 3){
                    $data[$tech_value->coin_adm_id]['technician']['img'][] = $tech_value->coin_data;
                }else if ($tech_value->coin_type == 3){
                    // $data[$tech_value->coin_adm_id]['technician']['img'][] = $tech_value->coin_data;
                    $data[$tech_value->coin_adm_id]['technician']['set'][] = $tech_value->coin_name;
                }else if ($tech_value->coin_type == 4){
                    $data[$tech_value->coin_adm_id]['technician']['text'] = $tech_value->coin_data;
                }
            }
            // if($data){
            //     foreach ($data as $d_key => $d_value){
            //         if(isset($data[$d_key]['performance'])){
            //             foreach ($data[$d_key]['performance'] as $p_key => $p_value){
            //                 $data[$d_key]['performance'][$p_key]['adm_num'] = $buwen[$p_value['wotp_id']]['adm_num'];
            //             }

            //         }
            //     }
            // }

        }
        return $data;
    }

    /*
     * @name 20230821  新的验车对应的数据
     * @param string ju_ordernum 订单id
     * @retrun array    验车数据
     * @author Ma 2023/8/22 9:37
     *
    */
    public static function washValidateCarByWorId($ord_id){
        $find_wash_order_validate_car = DB::table('wash_validate_car as ovc')
            ->leftJoin('order_client as oc', 'ovc.vaca_ord_id', '=', 'oc.orcl_ord_id')
            ->leftJoin('work_order as w', 'ovc.vaca_ord_id', '=', 'w.wor_order_id')
            ->leftJoin('admin as a', 'ovc.vaca_create_id', '=', 'a.adm_id')
            ->leftJoin('wash_validate_car_manage as vm', 'vm.vacm_id', '=', 'ovc.vaca_data_id')
            //->where('vaca_shop_id', $user_info->adm_shop_id)
            ->where('vaca_ord_id', $ord_id)
            ->select('vaca_ord_id', 'orcl_check_car_state', 'orcl_signature_img', 'vaca_create_id', 'adm_name', 'adm_phone', 'wor_order_id', 'vaca_create_time','vacm_unusual_name','vaca_type','vaca_data','vaca_name','vaca_first_data','vaca_data_id','vaca_first_data_id','vaca_must','vaca_part','vaca_part_type')
            ->get()->toArray();
        $signature_img = DB::table('order_client')
            ->where('orcl_ord_id', $ord_id)
            ->value('orcl_signature_img');
        $data['signature_img'] = $signature_img;
        $data['time'] = '';
        $data['check'] = [];
        $data['tab'] = [];
        $data['img'] = [];
        if($find_wash_order_validate_car){
            foreach ($find_wash_order_validate_car as $validate_key =>$validate_value){
                $data['time'] = $validate_value->vaca_create_time;
                if($validate_value->vaca_type == 1){//1检验商品图片2快捷部位3快捷图片
                    $data['check'][] = $validate_value->vaca_data;
                }else if ($validate_value->vaca_type == 2){
                    $data['tab'][] = $validate_value->vaca_data;
                }else if ($validate_value->vaca_type == 3){
                    $data['img'][] = $validate_value->vaca_data;
                }
                $wor_order_id = $validate_value->wor_order_id;
                $data['check'] = array_filter($data['check']);
            }
            $chsu_data = DB::table('checkcar_supplement as chsu')
                ->leftJoin('admin as a', 'a.adm_id', '=', 'chsu.chsu_adm_id')
                ->where('chsu_ord_id', $wor_order_id)
                ->select('chsu_id', 'chsu_img', 'chsu_explain', 'chsu_sign', 'adm_name', 'adm_phone', 'chsu_update_time')
                ->get()->toArray();
        }else {
            $chsu_data = [];
        }
        return ['data'=>$data,'chsu'=>$chsu_data];
    }

    /*
     * @name 20230821  新的质检对应的数据
     * @param string ju_ordernum 工单单号
     * @retrun array  质检数据
     * @author Ma 2023/8/22 9:43
     *
    */
    public static function qualityDataByWorId($wor_id){
        $quality_data = DB::table('quality_data as qu')
            ->leftJoin('admin as a', 'qu.quda_adm_id', '=', 'a.adm_id')
            ->leftJoin('wash_grade_level as b', 'b.grle_id', '=', 'a.adm_grle_id')
            ->leftJoin('wash_grade_professional as c', 'c.grpr_id', '=', 'b.grle_grpr_id')
            ->where('quda_wor_id', $wor_id)
            ->where('quda_delete', 2)
            ->select('quda_id', 'quda_shop_id', 'quda_wor_id', 'quda_adm_id', 'quda_qurp_id', 'quda_qurp_data', 'quda_type', 'adm_id', 'adm_phone', 'adm_name', 'grle_id', 'grle_name', 'quda_update_time','quda_standard')
            ->get()->toArray();
        $data = [];
        if($quality_data) {
            foreach ($quality_data as $qua_key => $qua_value) {
                $data[$qua_value->quda_adm_id]['admin_info']['adm_id'] = $qua_value->adm_id;
                $data[$qua_value->quda_adm_id]['admin_info']['adm_name'] = $qua_value->adm_name;
                $data[$qua_value->quda_adm_id]['admin_info']['adm_phone'] = $qua_value->adm_phone;
                $data[$qua_value->quda_adm_id]['admin_info']['grle_id'] = $qua_value->grle_id;
                $data[$qua_value->quda_adm_id]['admin_info']['grle_name'] = $qua_value->grle_name;
                $data[$qua_value->quda_adm_id]['quality']['time'] = $qua_value->quda_update_time;
                if($qua_value->quda_type == 1){//类型1标签2图片
                    $data[$qua_value->quda_adm_id]['quality']['tab'][] = $qua_value->quda_qurp_data;
                    $performance['quda_adm_id'] = $qua_value->quda_adm_id;
                    $performance['qurp_id'] = $qua_value->quda_qurp_id;
                    $performance['qurp_name'] = $qua_value->quda_qurp_data;
                    $performance['qurp_standard'] = $qua_value->quda_standard;
                    $data[$qua_value->quda_adm_id]['quality_info'][] = $performance;
                }else if ($qua_value->quda_type == 2){
                    $data[$qua_value->quda_adm_id]['quality']['img'][] = $qua_value->quda_qurp_data;
                }
            }
        }
        return $data;
    }

    // 订单详情
    public static function orderInfo($user_info, $request)
    {
        $info = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
            ->leftJoin('shop as c', 'ord.ord_shop_id', '=', 'c.shop_id')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_id', 'ord_create_id', 'ord_order_number', 'ord_goods_quantity', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_type', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address', 'ord_create_time', 'ord_delete', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_car_vehicle_type', 'orcl_pick_up_car_time', 'orcl_pick_up_car_adm_id', 'orcl_check_car_state', 'orcl_car_vin', 'orcl_car_brand_series', 'orcl_signature_img', 'shop_store_name', 'ord_province', 'ord_city', 'ord_county', 'ord_address', 'orcl_sales_adm_id', 'orcl_carowner_name', 'orcl_carowner_phone', 'ord_explain as ord_remark', 'orcl_business_name', 'ord_address_type', 'ord_address_id', 'orcl_carbrse_type','ord_shop_id', 'ord_order_price', 'orcl_cus_msg', 'ord_new_type', 'ord_source', 'ord_add_type')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前订单不存在', 'data'=>''];
        }

        $ord_Explainpic = [];
        $Explainpic = WashOrderService::getExplainpic($user_info, $request['ord_id']);
        if (!empty($Explainpic['data'])) {
            $ord_Explainpic = $Explainpic['data'];
        }
        $info->ord_explain_pic = $ord_Explainpic;
        $info->ord_new_type_name = DB::table('order_type')
            ->where('orty_id', $info->ord_new_type)
            ->value('orty_name');
        // 获取该订单下的商品信息
        $goods_data = DB::table('order_goods as orgo')
            ->leftjoin('goods as g', 'g.goo_id', '=', 'orgo.orgo_goo_id')
            ->where('orgo_ord_id', $request['ord_id'])
            ->select('orgo_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_price', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orgo_goo_unit as goo_unit', 'orgo_goo_unta_id as goo_unta_id', 'goo_unit_conversion')
            ->get()->toArray();

        // 账号id
        $adm_id[] = $info->ord_create_id;
        $adm_id[] = $info->orcl_sales_adm_id;//销售人员
        $adm_id = array_filter(array_unique($adm_id));
        // 查询账号id对应姓名
        $find_adm = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->select('adm_name', 'adm_phone', 'adm_id')
            ->get()->toArray();
        $find_adm = array_column($find_adm, null, 'adm_id');

        $info->create_name = '';
        if (!empty($info->ord_create_id)) {
            $info->create_name = $find_adm[$info->ord_create_id]->adm_name; //创建人
        }
        if ($info->ord_wor_state == 7) {
            $info->orcl_phone = substr($info->orcl_phone,0,3).'****'.substr($info->orcl_phone,-4);
            $info->orcl_name = mb_substr($info->orcl_name,0,1,'utf-8').str_repeat("*",(strlen($info->orcl_name)/3-1));
        }
        // 施工地址
        if ($info->ord_address_type == 1) {//门店
            $find_address = DB::table('shop')
                ->where('shop_id', $info->ord_address_id)
                ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                ->first();
            $info->shop_store_name = $find_address->shop_store_name;
            $info->ord_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
        } elseif ($info->ord_address_type == 2) {
            $find_address = DB::table('business_client')
                ->where('bucl_id', $info->ord_address_id)
                ->select('bucl_id', 'bucl_name', 'bucl_province', 'bucl_city', 'bucl_address', 'bucl_county')
                ->first();
            $info->shop_store_name = $find_address->bucl_name;
            $info->ord_address = $find_address->bucl_province.$find_address->bucl_city.$find_address->bucl_county.$find_address->bucl_address;
        } else {
            // dd($info);
            $find_address = DB::table('shop')
                ->where('shop_id', $info->ord_shop_id)
                ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                ->first();
            $info->shop_store_name = $find_address->shop_store_name;
            $info->ord_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
        }
        // 销售人手机号
        $info->orcl_sales_adm_phone = '';
        $info->orcl_sales_adm_name = '';
        if ($info->orcl_sales_adm_id) {
            $info->orcl_sales_adm_phone = $find_adm[$info->orcl_sales_adm_id]->adm_phone;
            $info->orcl_sales_adm_name = $find_adm[$info->orcl_sales_adm_id]->adm_name;
        }
        unset($info->ord_create_id);
        // unset($info->orcl_sales_adm_id);

        // 查询工单完成时间
        $find_wor_data = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->pluck('wor_achieve_time', 'wor_order_id')->toArray();

        // 技师完成时间
        if (isset($find_wor_data[$request['ord_id']]) && $find_wor_data[$request['ord_id']] != '0000-00-00 00:00:00') {
            $info->wor_achieve_time = $find_wor_data[$request['ord_id']];
        } else {
            $info->wor_achieve_time = '';
        }
        // 预约时间
        if ($info->orcl_appoint_time == '0000-00-00 00:00:00') {
            $info->orcl_appoint_time = '';
        }
        // 接车时间
        if ($info->orcl_pick_up_car_time == '0000-00-00 00:00:00') {
            $info->orcl_pick_up_car_time = '';
        }
        // 订单作品
        if ($info->ord_wor_state >= 4) {
            $info->order_works = DB::table('order_works')
                ->where('orwo_ord_id', $request['ord_id'])
                ->where('orwo_delete', 2)
                ->select('orwo_title', 'orwo_type', 'orwo_description', 'orwo_data')
                ->get()->toArray();
        }
        $info->dego_pic = '';//发货图片
        // 查看工单技师施工检测信息
        $technician_part = DB::table('wash_work_technician_part as a')
            ->leftJoin('work_order as b', 'a.wotp_wor_id', 'b.wor_id')
            ->where('wor_order_id', $request['ord_id'])
            ->select('wotp_id', 'wotp_service_adm_id', 'wotp_grle_id', 'wotp_grle_name', 'wotp_grpr_id', 'wotp_grpr_name', 'wotp_service_adm_name', 'wotp_service_adm_phone', 'wotp_service_part', 'wotp_service_quality', 'wotp_service_data', 'wotp_service_qualitytesting', 'wotp_rewards_punishment')
            ->get()->toArray();

        // 查询验车信息
        $validate_car_data = DB::table('wash_order_validate_car')
            ->where('orvc_ord_id', $request['ord_id'])
            ->select('orvc_mileage', 'orvc_film_roll_number', 'orvc_car_interior', 'orvc_car_exterior')
            ->first();
        $data['order_data'] = $info;
        $data['goods_data'] = $goods_data;
        $data['technician_part'] = $technician_part;
        $data['validate_car_data'] = $validate_car_data;

        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 拒单-技师小程序
    public static function refuse($user_info, $request)
    {
        // 查询信息
        $find_work = DB::table('work_order as wor')
            ->leftJoin('order as o', 'o.ord_id', '=', 'wor.wor_order_id')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_state', 'wor_order_id', 'wor_pass', 'wor_service_type', 'wor_type', 'wor_delete', 'wor_service_state', 'wocl_wor_type', 'wor_ware_id', 'wor_create_id', 'wor_order_number', 'wor_appoint_time', 'ord_create_time', 'wor_remark')
            ->first();

        if (empty($find_work)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单不存在！', 'data'=>''];
        }
        if ($find_work->wor_delete != 1) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已经取消！', 'data'=>''];
        }

        // 判断该订单是否有未发货的 发货单
        $dego_data = DB::table('dispatch_bill')
            ->where('dego_wor_id', $request['wor_id'])
            ->where('dego_order_type', 2)
            ->where('dego_type', 1)
            ->select('dego_id', 'dego_out_ware_id', 'dego_count', 'dego_number', 'dego_type')
            ->first();

        // 有未发货的工单,不是退货单类型 对发货单进行修改
        if (!empty($dego_data->dego_id) && $find_work->wor_service_type != 4) {
            // 作废原来的发货单，商品库存数量不变
            $update_type['dego_type'] = 3;
            $update_type['dego_update_time'] = date('Y-m-d H:i:s');
            $dego_type = DB::table('dispatch_bill')
                ->where('dego_id', $dego_data->dego_id)
                ->update($update_type);
        } elseif ($find_work->wocl_wor_type == 4) {
            $dego_type = true;
        } else {
            // 查看工单选择的仓库类型，如果是技师仓库不需要更改，如果是固定仓库需要更改
            // ware_type 仓库类型：1固定仓2技师库3移动仓
            $ware_type = DB::table('warehouse')
                ->where('ware_id', $find_work->wor_ware_id)
                ->value('ware_type');
            if ($ware_type == '2') {
                $dego_type = true;
            } else {
                // 选的是固定仓库，工单对应的发货单已经发货
                // 订单类型：1服务单 2洗车单3商品单
                if (in_array($find_work->wor_service_type, [1])) {
                    // 获取工单商品数据
                    //wogo_state 商品状态1正常2删除3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
                    $work_goods = DB::table('work_good as wogo')
                        ->leftJoin('goods as g', 'g.goo_id', '=', 'wogo.wogo_goo_id')
                        ->where('wogo_wor_id', $request['wor_id'])
                        ->whereNotIn('wogo_state', [2, 3, 4])
                        ->where('wogo_goo_type', 1)
                        ->select('wogo_goo_id', 'wogo_waon_class', 'wogo_goo_amount', 'wogo_goo_inventory', 'wogo_id', 'wogo_ware_id', 'wogo_actual_goo_id', 'wogo_wago_id', 'wogo_goo_price', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_wafr_id', 'wogo_wafg_id', 'wogo_orgo_id', 'wogo_goo_unit', 'wogo_goo_unta_id', 'goo_unit_conversion')
                        ->get()->toArray();
                    // 工单商品有数据，生成退换回收单，后台入库
                    if (!empty($work_goods) && !empty($find_work->wor_ware_id)) {
                        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
                        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
                        $goo_all_quantity = 0;
                        // 生成退换回收单，退换回收商品表添加数据
                        foreach ($work_goods as $key => $value) {
                            $goo_unit = $value->wogo_goo_unit;
                            $goo_unta_id = $value->wogo_goo_unta_id;
                            $goo_all_quantity += $value->wogo_goo_amount;

                            if ($value->wogo_goo_inventory == 1) {
                                $rego_data[$key]['rego_fine_quantity'] = $value->wogo_goo_amount;
                                $rego_data[$key]['rego_priority_quantity'] = 0;
                            } else {
                                $rego_data[$key]['rego_fine_quantity'] = 0;
                                $rego_data[$key]['rego_priority_quantity'] = $value->wogo_goo_amount;
                            }

                            $rego_data[$key]['rego_ware_id'] = $value->wogo_ware_id;
                            $rego_data[$key]['rego_waon_class'] = $value->wogo_waon_class;
                            $rego_data[$key]['rego_wago_id'] = $value->wogo_wago_id;
                            $rego_data[$key]['rego_orgo_id'] = $value->wogo_orgo_id;
                            $rego_data[$key]['rego_wafr_id'] = $value->wogo_wafr_id;
                            $rego_data[$key]['rego_wafg_id'] = $value->wogo_wafg_id;
                            $rego_data[$key]['rego_goo_id'] = $value->wogo_goo_id;
                            $rego_data[$key]['rego_sell_number'] =  $value->wogo_goo_amount;
                            $rego_data[$key]['rego_recycle_number'] =  $value->wogo_goo_amount;
                            $rego_data[$key]['rego_goo_inventory'] =  $value->wogo_goo_inventory;
                            $rego_data[$key]['rego_goo_name'] = $value->wogo_goo_name;
                            $rego_data[$key]['rego_goo_goods_encode'] = $value->wogo_goo_goods_encode;
                            $rego_data[$key]['rego_goo_unit'] = $goo_unit;
                            $rego_data[$key]['rego_goo_unta_id'] = $goo_unta_id;
                        }

                        // 生成退换回收单，退换回收单表添加数据
                        $rec_number = 'TH' . rand(100, 999) . date('mdHis') . rand(100000, 999999); // 回收单号

                        $add_recycle['rec_cid'] = $user_info->adm_cid; //公司id
                        $add_recycle['rec_shop_id'] = $user_info->adm_shop_id; //门店id
                        $add_recycle['rec_superior_shop_id'] = $shop_id; //总店id
                        $add_recycle['rec_date'] = date('Y-m-d'); //日期
                        $add_recycle['rec_number'] = $rec_number; //回收单号
                        $add_recycle['rec_ord_id'] = $request['wor_id']; //工单id
                        $add_recycle['rec_ord_order_number'] = $find_work->wor_number; //工单号
                        $add_recycle['rec_source_type'] = 6; //类型：6技师拒单
                        $add_recycle['rec_amount'] = $goo_all_quantity; //回收总数量
                        $add_recycle['rec_state'] = 1; //回收状态 1.未回收 2.已回收
                        $add_recycle['rec_type'] = $find_work->wor_type; //买家类型 1.门店零售 2.来往单位
                        $add_recycle['rec_ware_id'] =  $find_work->wor_ware_id; //仓库id
                        $add_recycle['rec_create_adm_id'] = $user_info->adm_id; //创建人id
                        $add_recycle['rec_remark'] = isset($request['cause']) ? $request['cause'] : ''; //备注
                        $recycle_id = DB::table('recede_recycle')->insertGetId($add_recycle);

                        // 2退换回收商品表添加数据
                        foreach ($work_goods as $key => $value) {
                            $rego_data[$key]['rego_rec_id'] = $recycle_id;
                        }
                        $add_goods =  DB::table('recede_goods')->insert($rego_data);

                        $find_wocl_data = DB::table('work_client')
                            ->where('wocl_wor_id', $request['wor_id'])
                            ->select('wocl_client_id', 'wocl_channel_unit', 'wocl_name', 'wocl_phone')
                            ->first();
                        // 10.3 退换回收客户表添加数据
                        $recl_data['recl_rec_id'] = $recycle_id; //回收单id
                        $recl_data['recl_client_id'] = $find_wocl_data->wocl_client_id; //来往单位id/客户id
                        $recl_data['recl_name'] = $find_wocl_data->wocl_name; //客户姓名
                        $recl_data['recl_phone'] = $find_wocl_data->wocl_phone; //联系电话
                        $recl_data['recl_channel_unit'] = $find_wocl_data->wocl_channel_unit; //渠道单位
                        $add_client =  DB::table('recede_client')->insert($recl_data);
                        if ($add_client && $add_goods && $recycle_id) {
                            $dego_type = true;
                        } else {
                            return ['code'=>500, 'msg'=>'拒单失败2-1', 'data'=>'{}'];
                        }
                    } else {
                        $dego_type = true;
                    }
                } else {
                    $dego_type = true;
                }
            }
        }
        $wor_data['wor_state'] = 2; //1.新订单 2未派单 3待接单/已派单
        $wor_data['wor_service_adm_id'] = 0; //服务技师清空
        $wor_data['wor_service_state'] = 0; //服务状态：1待接单2已接单3预约4出发5抵达6完成待审核
        $wor_data['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_res = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->update($wor_data);
        $wotp_res = DB::table('wash_work_technician_part')
            ->where('wotp_wor_id', $request['wor_id'])
            ->delete();
        DB::table('work_client')
            ->where('wocl_wor_id', $request['wor_id'])
            ->update(['wocl_check_car_lock'=>2,'wocl_update_time'=>date('Y-m-d H:i:s')]);

        // 添加技师消息
        $add_data['adm_id'] = $find_work->wor_create_id;
        $add_data['shop_id'] = $user_info->adm_shop_id;
        $add_data['primary_id'] = $request['wor_id']; //单据的主键id
        $add_data['primary_type'] = 2; //单据类型：1订单2工单3预约单4售后单
        $add_data['message_type'] = 1;
        // $add_data['message_type'] = $data['message_type'];
        $add_data['title'] = '拒单通知'; //操作内容
        $add_data['content'] = '您派出的工单被拒单，请重新派单'; //操作内容
        $add_data['read_state'] = 1; //阅读状态：1未读2已读
        $add_data['create_adm_name'] = $user_info->adm_name; //操作人姓名
        $add_data['create_adm_id'] = $user_info->adm_id; //操作人id
        $addAdminMessage_res = addAdminMessage($add_data);
        if ($addAdminMessage_res['code'] != 200) {
            return $addAdminMessage_res;
        }
        $dis_name = DB::table('admin')
            ->where('adm_id', $find_work->wor_create_id)
            ->select('adm_name', 'adm_phone')->first();
        // 微信消息推送
        $wechat_msg['pushtype'] = 3; //工单进度通知
        $wechat_msg['adm_id'] = $find_work->wor_create_id; //推送人
        $wechat_msg['wor_number'] = $find_work->wor_number; //工单号
        $wechat_msg['ord_number'] = $find_work->wor_order_number; //订单号
        $wechat_msg['user_name'] = $dis_name->adm_name; //姓名
        $wechat_msg['user_phone'] = $dis_name->adm_phone; //手机号
        $wechat_msg['wor_state'] = '拒单'; //工单进度
        $find_work_goods = DB::table('work_good')
            ->where('wogo_wor_id', $request['wor_id'])
            ->where('wogo_goo_type', 2)
            ->select('wogo_id', 'wogo_goo_name')
            ->get()->toArray();
        $sepr_data = '';
        if ($find_work_goods) {
            foreach ($find_work_goods as $key => $value) {
                if ($sepr_data) {
                    $sepr_data = $sepr_data.','.$value->wogo_goo_name;
                } else {
                    $sepr_data = $sepr_data;
                }
            }
        }
        $wechat_msg['sepr_name'] = $sepr_data; //服务项目
        $wechat_msg['orcl_appoint_time'] = $find_work->wor_appoint_time; //预约时间
        $wechat_msg['ord_create_time'] = $find_work->ord_create_time; //订单创建时间
        $wechat_msg['tittle'] = '您派出的工单被拒单，请重新派单'; //手机
        $wechat_msg['remark'] = !empty($find_work->wor_remark) ? $find_work->wor_remark : '';
        $CashierDesk = new CashierDesk;
        $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
        if ($wor_res) {
            $data['wor_number'] = $find_work->wor_number;
            return ['code'=>200, 'msg'=>'拒单成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'拒单成功', 'data'=>''];
        }
    }

    // 撤回工单
    public static function withdraw($user_info, $request)
    {
        // 查询信息
        $find_work = DB::table('work_order as wor')
            ->leftJoin('order as o', 'o.ord_id', '=', 'wor.wor_order_id')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_state', 'wor_order_id', 'wor_pass', 'wor_service_type', 'wor_type', 'wor_delete', 'wor_service_state', 'wocl_wor_type', 'wor_ware_id', 'wor_create_id', 'wor_order_number', 'wor_appoint_time', 'ord_create_time', 'wor_remark')
            ->first();

        if (empty($find_work)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单不存在！', 'data'=>''];
        }
        if ($find_work->wor_delete != 1) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已经取消！', 'data'=>''];
        }

        // 判断该订单是否有未发货的 发货单
        $dego_data = DB::table('dispatch_bill')
            ->where('dego_wor_id', $request['wor_id'])
            ->where('dego_order_type', 2)
            ->where('dego_type', 1)
            ->select('dego_id', 'dego_out_ware_id', 'dego_count', 'dego_number', 'dego_type')
            ->first();

        // 有未发货的工单,不是退货单类型 对发货单进行修改
        if (!empty($dego_data->dego_id) && $find_work->wor_service_type != 4) {
            // 作废原来的发货单，商品库存数量不变
            $update_type['dego_type'] = 3;
            $update_type['dego_update_time'] = date('Y-m-d H:i:s');
            $dego_type = DB::table('dispatch_bill')
                ->where('dego_id', $dego_data->dego_id)
                ->update($update_type);
        } elseif ($find_work->wocl_wor_type == 4) {
            $dego_type = true;
        } else {
            // 查看工单选择的仓库类型，如果是技师仓库不需要更改，如果是固定仓库需要更改
            // ware_type 仓库类型：1固定仓2技师库3移动仓
            $ware_type = DB::table('warehouse')
                ->where('ware_id', $find_work->wor_ware_id)
                ->value('ware_type');
            if ($ware_type == '2') {
                $dego_type = true;
            } else {
                // 选的是固定仓库，工单对应的发货单已经发货
                // 订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单 7救援单
                // 服务单、销售单、换货单有发货单需要发货，救援单可能有发货单需要发货，其他类型没有发货单不需要处理
                if (in_array($find_work->wor_service_type, [1, 2, 3, 7])) {
                    // 获取工单商品数据
                    //wogo_state 商品状态1正常2删除3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
                    $work_goods = DB::table('work_good as wogo')
                        ->leftJoin('goods as g', 'g.goo_id', '=', 'wogo.wogo_goo_id')
                        ->where('wogo_wor_id', $request['wor_id'])
                        ->where('wogo_goo_type', 1)
                        ->whereNotIn('wogo_state', [2, 3, 4])
                        ->select('wogo_goo_id', 'wogo_waon_class', 'wogo_goo_amount', 'wogo_goo_inventory', 'wogo_id', 'wogo_ware_id', 'wogo_actual_goo_id', 'wogo_wago_id', 'wogo_goo_price', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_wafr_id', 'wogo_wafg_id', 'wogo_orgo_id', 'wogo_goo_unit', 'wogo_goo_unta_id', 'goo_unit_conversion')
                        ->get()->toArray();
                    // 工单商品有数据，生成退换回收单，后台入库
                    if (!empty($work_goods) && !empty($find_work->wor_ware_id)) {
                        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
                        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
                        $goo_all_quantity = 0;
                        // 生成退换回收单，退换回收商品表添加数据
                        foreach ($work_goods as $key => $value) {
                            // if ($value->wogo_goo_unta_id == 1) {//单位转换
                            //     $value->wogo_goo_amount = $value->wogo_goo_amount * $value->goo_unit_conversion;
                            //     $goo_unit = '米';
                            //     $goo_unta_id = 4;
                            // } else {
                            // }
                            $goo_unit = $value->wogo_goo_unit;
                            $goo_unta_id = $value->wogo_goo_unta_id;
                            $goo_all_quantity += $value->wogo_goo_amount;

                            if ($value->wogo_goo_inventory == 1) {
                                $rego_data[$key]['rego_fine_quantity'] = $value->wogo_goo_amount;
                                $rego_data[$key]['rego_priority_quantity'] = 0;
                            } else {
                                $rego_data[$key]['rego_fine_quantity'] = 0;
                                $rego_data[$key]['rego_priority_quantity'] = $value->wogo_goo_amount;
                            }

                            $rego_data[$key]['rego_ware_id'] = $value->wogo_ware_id;
                            $rego_data[$key]['rego_waon_class'] = $value->wogo_waon_class;
                            $rego_data[$key]['rego_wago_id'] = $value->wogo_wago_id;
                            $rego_data[$key]['rego_orgo_id'] = $value->wogo_orgo_id;
                            $rego_data[$key]['rego_wafr_id'] = $value->wogo_wafr_id;
                            $rego_data[$key]['rego_wafg_id'] = $value->wogo_wafg_id;
                            $rego_data[$key]['rego_goo_id'] = $value->wogo_goo_id;
                            $rego_data[$key]['rego_sell_number'] =  $value->wogo_goo_amount;
                            $rego_data[$key]['rego_recycle_number'] =  $value->wogo_goo_amount;
                            $rego_data[$key]['rego_goo_inventory'] =  $value->wogo_goo_inventory;
                            $rego_data[$key]['rego_goo_name'] = $value->wogo_goo_name;
                            $rego_data[$key]['rego_goo_goods_encode'] = $value->wogo_goo_goods_encode;
                            $rego_data[$key]['rego_goo_unit'] = $goo_unit;
                            $rego_data[$key]['rego_goo_unta_id'] = $goo_unta_id;
                        }

                        // 生成退换回收单，退换回收单表添加数据
                        $rec_number = 'TH' . rand(100, 999) . date('mdHis') . rand(100000, 999999); // 回收单号

                        $add_recycle['rec_cid'] = $user_info->adm_cid; //公司id
                        $add_recycle['rec_shop_id'] = $user_info->adm_shop_id; //门店id
                        $add_recycle['rec_superior_shop_id'] = $shop_id; //总店id
                        $add_recycle['rec_date'] = date('Y-m-d'); //日期
                        $add_recycle['rec_number'] = $rec_number; //回收单号
                        $add_recycle['rec_ord_id'] = $request['wor_id']; //工单id
                        $add_recycle['rec_ord_order_number'] = $find_work->wor_number; //工单号
                        $add_recycle['rec_source_type'] = 6; //类型：6技师拒单
                        $add_recycle['rec_amount'] = $goo_all_quantity; //回收总数量
                        $add_recycle['rec_state'] = 1; //回收状态 1.未回收 2.已回收
                        $add_recycle['rec_type'] = $find_work->wor_type; //买家类型 1.门店零售 2.企业客户
                        $add_recycle['rec_ware_id'] =  $find_work->wor_ware_id; //仓库id
                        $add_recycle['rec_create_adm_id'] = $user_info->adm_id; //创建人id
                        $add_recycle['rec_remark'] = isset($request['cause']) ? $request['cause'] : ''; //备注
                        $recycle_id = DB::table('recede_recycle')->insertGetId($add_recycle);

                        // 2退换回收商品表添加数据
                        foreach ($work_goods as $key => $value) {
                            $rego_data[$key]['rego_rec_id'] = $recycle_id;
                        }
                        $add_goods =  DB::table('recede_goods')->insert($rego_data);

                        $find_wocl_data = DB::table('work_client')
                            ->where('wocl_wor_id', $request['wor_id'])
                            ->select('wocl_client_id', 'wocl_channel_unit', 'wocl_name', 'wocl_phone')
                            ->first();
                        // 10.3 退换回收客户表添加数据
                        $recl_data['recl_rec_id'] = $recycle_id; //回收单id
                        $recl_data['recl_client_id'] = $find_wocl_data->wocl_client_id; //来往单位id/客户id
                        $recl_data['recl_name'] = $find_wocl_data->wocl_name; //客户姓名
                        $recl_data['recl_phone'] = $find_wocl_data->wocl_phone; //联系电话
                        $recl_data['recl_channel_unit'] = $find_wocl_data->wocl_channel_unit; //渠道单位
                        $add_client =  DB::table('recede_client')->insert($recl_data);
                        if ($add_client && $add_goods && $recycle_id) {
                            $dego_type = true;
                        } else {
                            return ['code'=>500, 'msg'=>'拒单失败2-1', 'data'=>'{}'];
                        }
                    } else {
                        $dego_type = true;
                    }
                } else {
                    $dego_type = true;
                }
            }
        }
        $wor_data['wor_state'] = 2; //1.新订单 2未派单 3待接单/已派单
        $wor_data['wor_service_adm_id'] = 0; //服务技师清空
        $wor_data['wor_service_state'] = 0; //服务状态：1待接单2已接单3预约4出发5抵达6完成待审核
        $wor_data['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_res = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->update($wor_data);
        $plan_edit['wopl_service_id'] = '';
        $plan_edit['wopl_update_time'] = date('Y-m-d H:i:s');
        $plan_res = DB::table('work_plan')
            ->where('wopl_wor_id', $request['wor_id'])
            ->update($plan_edit);
        $wotp_res = DB::table('wash_work_technician_part')
            ->where('wotp_wor_id', $request['wor_id'])
            ->delete();

        // 添加技师消息
        // $add_data['adm_id'] = $find_work->wor_create_id;
        // $add_data['shop_id'] = $user_info->adm_shop_id;
        // $add_data['primary_id'] = $request['wor_id']; //单据的主键id
        // $add_data['primary_type'] = 2; //单据类型：1订单2工单3预约单4售后单
        // $add_data['message_type'] = 1;
        // // $add_data['message_type'] = $data['message_type'];
        // $add_data['title'] = '撤回通知'; //操作内容
        // $add_data['content'] = '您派出的工单被撤回，请重新派单'; //操作内容
        // $add_data['read_state'] = 1; //阅读状态：1未读2已读
        // $add_data['create_adm_name'] = $user_info->adm_name; //操作人姓名
        // $add_data['create_adm_id'] = $user_info->adm_id; //操作人id
        // $addAdminMessage_res = addAdminMessage($add_data);
        // if ($addAdminMessage_res['code'] != 200) {
        //     return $addAdminMessage_res;
        // }
        $dis_name = DB::table('admin')
            ->where('adm_id', $find_work->wor_create_id)
            ->select('adm_name', 'adm_phone')->first();
        $find_sepr_name = DB::table('work_good')
            ->where('wogo_wor_id', $request['wor_id'])
            ->where('wogo_goo_type', 2)
            ->select('wogo_goo_name', 'wogo_goo_type')
            ->get()->toArray();
        $sepr_name = '';
        if ($find_sepr_name) {
            foreach ($find_sepr_name as $key => $value) {
                if ($sepr_name) {
                    $sepr_name = $sepr_name.','.$value->wogo_goo_name;
                } else {
                    $sepr_name = $value->wogo_goo_name;
                }
            }
        }
        // // 微信消息推送
        // $wechat_msg['pushtype'] = 3; //工单进度通知
        // $wechat_msg['adm_id'] = $find_work->wor_create_id; //推送人
        // $wechat_msg['wor_number'] = $find_work->wor_number; //工单号
        // $wechat_msg['ord_number'] = $find_work->wor_order_number; //订单号
        // $wechat_msg['user_name'] = $dis_name->adm_name; //姓名
        // $wechat_msg['user_phone'] = $dis_name->adm_phone; //手机号
        // $wechat_msg['wor_state'] = '撤回工单'; //工单进度
        // $wechat_msg['sepr_name'] = $sepr_name; //服务项目
        // $wechat_msg['orcl_appoint_time'] = $find_work->wor_appoint_time; //预约时间
        // $wechat_msg['ord_create_time'] = $find_work->ord_create_time; //订单创建时间
        // $wechat_msg['tittle'] = '您派出的工单被撤回，请重新派单'; //提示信息
        // $wechat_msg['remark'] = !empty($find_work->wor_remark) ? $find_work->wor_remark : '';
        // $CashierDesk = new CashierDesk;
        // $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
        if ($wor_res) {
            $data['wor_number'] = $find_work->wor_number;
            $data['wor_order_id'] = $find_work->wor_order_id;
            $data['wor_order_number'] = $find_work->wor_order_number;
            return ['code'=>200, 'msg'=>'撤回工单成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'撤回工单失败', 'data'=>''];
        }
    }

    // 接单提交-技师小程序
    public static function receiveSubmit($user_info, $request)
    {
        $find_work = DB::table('work_order as wor')
            ->leftJoin('order as o', 'wor.wor_order_id', '=', 'o.ord_id')
            ->leftJoin('admin as a', 'a.adm_id', '=', 'wor.wor_service_adm_id')
            ->leftJoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->select('wor_number', 'wor_state', 'wor_delete', 'wor_pass', 'wor_appoint_time', 'wor_order_number', 'wor_remark', 'ord_create_time', 'wor_service_adm_id', 'adm_name', 'adm_phone', 'wocl_province', 'wocl_city', 'wocl_county', 'wocl_address', 'wor_order_id', 'wor_province', 'wor_city', 'wor_county', 'wor_address', 'wor_service_state', 'wor_work_type')
            ->first();
        if (empty($find_work)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单不存在，无法提交！', 'data'=>''];
        }
        if ($find_work->wor_delete != 1) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已经取消！', 'data'=>''];
        }
        if ($find_work->wor_pass == 4) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已经锁定，无法提交！', 'data'=>''];
        }
        if ($find_work->wor_service_state != 1) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单不是待接单状态，无法接单！', 'data'=>''];
        }
        $find_wogo_data = DB::table('work_good as wogo')
            ->leftJoin('service_project as sp', 'sp.sepr_id', '=', 'wogo.wogo_goo_id')
            ->where('wogo_wor_id', $request['wor_id'])
            ->where('wogo_goo_type', 2)
            ->select('wogo_goo_id', 'sepr_name', 'sepr_check_car', 'sepr_id', 'wogo_goo_type')
            ->get()->toArray();
        $find_sepr = 2;//服务项目不需要验车
        $sepr_name = '';
        if ($find_wogo_data) {
            foreach ($find_wogo_data as $key => $value) {
                $sepr_name = $sepr_name.','.$value->sepr_name;
            }
            foreach ($find_wogo_data as $key => $value) {
                if ($value->sepr_check_car == 1) {
                    $find_sepr = 1;
                    break;
                }
            }
        }
        if ($find_work->wor_work_type == 2) {//智配的工单都需要验车
            $find_sepr = 1;
            $wocl_edit_data['wocl_check_car_state'] = 2;
            $wocl_edit_data['wocl_update_time'] = date('Y-m-d H:i:s');
            $wocl_edit_res = DB::table('work_client')
                ->where('wocl_wor_id', $request['wor_id'])
                ->update($wocl_edit_data);
        }
        // 判断是否有预约时间，有预约时间状态改为预约状态
        if ($find_work->wor_appoint_time != '0000-00-00 00:00:00') {
            if ($find_sepr == 1) {//服务项目需要验车
                $wor_edit_data['wor_service_state'] = 3; //服务状态：1待接单2已接单3预约4出发5抵达6完成待审核
                $wor_edit_data['wor_state'] = 5; //3待接单/已派单 5.已接单/待验车 6.出发/已出发  7.抵达/抵达 8.待审核/完成待审核
            } else {
                $wor_edit_data['wor_service_state'] = 4; //服务状态：1待接单2已接单3预约4施工中5抵达6完成待审核
                $wor_edit_data['wor_state'] = 6; //3待接单/已派单 4.未出发/已接单 5.预约/已预约 6.施工中 7.抵达/抵达 8.待审核/完成待审核
                $wocl_edit_data['wocl_check_car_state'] = 5;//验车状态
                $wocl_edit_data['wocl_update_time'] = date('Y-m-d H:i:s');
                $wocl_edit_res = DB::table('work_client')
                    ->where('wocl_wor_id', $request['wor_id'])
                    ->update($wocl_edit_data);
            }
        } else {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单没有预约时间，请联系管理人员！', 'data'=>''];
            // 更改工单表的工单状态
            $wor_edit_data['wor_service_state'] = 2; //服务状态：1待接单2已接单/待验车3预约4已验车/待施工 （出发）5抵达6完成待审核
            $wor_edit_data['wor_state'] = 4; //3待接单/已派单 4.待验车/已接单 5.预约/已预约 6.出发/已出发  7.抵达/抵达 8.待审核/完成待审核
        }

        if (!empty($request['remark'])) {
            $wor_edit_data['wor_remark'] = $request['remark'];
        }
        $wor_edit_data['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_edit_res = WashWork::where('wor_id', $request['wor_id'])->update($wor_edit_data);

        // // 接单组员
        // $receive_data = json_decode($request['receive_data'], true);
        // if (empty($receive_data)) {
        //     $wash_res = true;
        // } else {
        //     foreach ($receive_data as $key => $value) {
        //         $find_admin = DB::table('admin as a')
        //             ->leftJoin('wash_grade_level as grle', 'a.adm_grle_id', '=', 'grle.grle_id')
        //             ->leftJoin('wash_grade_professional as grpr', 'grle.grle_grpr_id', '=', 'grpr.grpr_id')
        //             ->where('adm_id', $value['adm_id'])
        //             ->select('adm_name', 'grle_name', 'grle_id', 'grpr_id', 'grpr_name')
        //             ->first();
        //         if ($find_admin) {
        //             $temp_data['wotp_grle_id'] = $find_admin->grle_id ? $find_admin->grle_id : 0;
        //             $temp_data['wotp_grle_name'] = $find_admin->grle_name ? $find_admin->grle_name : '';
        //             $temp_data['wotp_grpr_id'] = $find_admin->grpr_id ? $find_admin->grpr_id : 0;
        //             $temp_data['wotp_grpr_name'] = $find_admin->grpr_name ? $find_admin->grpr_name : '';
        //         }
        //         $temp_data['wotp_shop_id'] = $user_info->adm_shop_id;
        //         $temp_data['wotp_wor_id'] = $request['wor_id'];
        //         $temp_data['wotp_service_adm_id'] = $value['adm_id'];
        //         $temp_data['wotp_service_adm_name'] = $value['adm_name'];
        //         $temp_data['wotp_service_adm_phone'] = $value['adm_phone'];
        //         $temp_data['wotp_update_time'] = date('Y-m-d H:i:s');
        //         $wotp_data[] = $temp_data;
        //         unset($temp_data);

        //         // 添加技师消息
        //         $add_data['adm_id'] = $value['adm_id'];
        //         $add_data['shop_id'] = $user_info->adm_shop_id;
        //         $add_data['primary_id'] = $request['wor_id']; //单据的主键id
        //         $add_data['primary_type'] = 2; //单据类型：1订单2工单3预约单4售后单
        //         $add_data['message_type'] = 1;
        //         $add_data['title'] = '派单通知'; //操作内容
        //         $add_data['content'] = '您被分配新的工单，请查看'; //操作内容
        //         $add_data['read_state'] = 1; //阅读状态：1未读2已读
        //         $add_data['create_adm_name'] = $user_info->adm_name; //操作人姓名
        //         $add_data['create_adm_id'] = $user_info->adm_id; //操作人id
        //         $addAdminMessage_res = addAdminMessage($add_data);
        //         if ($addAdminMessage_res['code'] != 200) {
        //             return $addAdminMessage_res;
        //         }
        //         // 微信消息推送
        //         $wechat_msg['pushtype'] = 1; //工单推送
        //         $wechat_msg['adm_id'] = $value['adm_id']; //推送人
        //         $wechat_msg['wor_number'] = $find_work->wor_number; //工单号
        //         $wechat_msg['ord_number'] = $find_work->wor_order_number; //订单号
        //         $wechat_msg['user_name'] = $value['adm_name']; //姓名
        //         $wechat_msg['sepr_name'] = $sepr_name; //服务项目
        //         $wechat_msg['orcl_appoint_time'] = $find_work->wor_appoint_time; //预约时间
        //         $wechat_msg['ord_create_time'] = $find_work->ord_create_time; //订单创建时间
        //         $wechat_msg['user_phone'] = $value['adm_phone']; //手机号
        //         $wechat_msg['tittle'] = '您被分配新的工单，请查看'; //手机
        //         $wechat_msg['remark'] = !empty($find_work->wor_remark) ? $find_work->wor_remark : '';
        //         $CashierDesk = new CashierDesk;
        //         $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
        //     }
        //     $wash_res = DB::table('wash_work_technician_part')
        //         ->insert($wotp_data);
        // }

        // $find_wopl = DB::table('work_plan')->where('wopl_wor_id', $request['wor_id'])->select('wopl_id')->first();
        // if (!empty($receive_data) && $find_wopl) {
        //     $find_wotp_data = DB::table('wash_work_technician_part')
        //         ->where('wotp_wor_id', $request['wor_id'])
        //         ->select('wotp_service_adm_id')
        //         ->get()->toArray();
        //     $wopl_service_id = '';
        //     foreach ($find_wotp_data as $key => $value) {
        //         if (empty($wopl_service_id)){
        //             $wopl_service_id = ','.$value->wotp_service_adm_id.',';
        //         } else {
        //             $wopl_service_id = $wopl_service_id.$value->wotp_service_adm_id.',';
        //         }
        //     }
        //     $wopl_data['wopl_service_id'] = $wopl_service_id;
        //     $wopl_res = DB::table('work_plan')->where('wopl_wor_id', $request['wor_id'])->update($wopl_data);
        // } else {
        //     $wopl_res = true;
        // }
        // 智配订单,同步信息
        if ($find_work->wor_work_type == 2) {
            $find_service_adm = DB::table('admin')
                ->where('adm_id', $find_work->wor_service_adm_id)
                ->select('adm_name', 'adm_phone')
                ->first();
            $order_data = DB::table('order')
                ->where('ord_id', $find_work->wor_order_id)
                ->select('ord_other_system_number')
                ->first();
            $url = config('apiconnect.ZPTZ_URL') . '/index.php/api/supplychain/SupplyMz/installLine';
            $param['state'] = 2;//接单出发
            $param['time'] = date('Y-m-d H:i:s');
            $param['ip'] = Request::getClientIp();
            $param['token'] = md5(md5($param['time'] . config('apiconnect.ZPTZ_TOKEN'))); //token
            $param['serial_number'] = $order_data->ord_other_system_number; //第三方工单号
            $param['install_name'] = $find_service_adm->adm_name;
            $param['install_phone'] = $find_service_adm->adm_phone;
            $param_return = doPost($param, $url, 2);
            $param_return = json_decode($param_return, true);
            if ($param_return['code'] != 200) {
                return ['code'=>500, 'msg'=>'接单失败失败0', 'data'=>''];
            }
        }

        if ($wor_edit_res) {
            $find_dis_data = DB::table('dispatch_bill')
                ->where('dego_shop_id', $user_info->adm_shop_id)
                ->where('dego_wor_id', $request['wor_id'])
                ->where('dego_order_type', 2)
                ->where('dego_type', 1)
                ->select('dego_out_ware_id', 'dego_id')
                ->first();
            if (!empty($find_dis_data)) {
                $find_admin = DB::table('warehouse as w')
                    ->leftJoin('admin as a', 'w.ware_leader_id', '=', 'a.adm_id')
                    ->where('ware_id', $find_dis_data->dego_out_ware_id)
                    ->select('ware_leader_id', 'adm_name', 'adm_phone')
                    ->first();

                // 添加技师消息
                $add_data['adm_id'] = $find_admin->ware_leader_id;
                $add_data['shop_id'] = $user_info->adm_shop_id;
                $add_data['primary_id'] = $find_dis_data->dego_id; //单据的主键id
                $add_data['primary_type'] = 5; //单据类型：1订单2工单3预约单4售后单5发货单
                $add_data['message_type'] = 1;
                $add_data['title'] = '待发货通知'; //操作内容
                $add_data['content'] = '您有新的发货申请，请及时处理'; //操作内容
                $add_data['read_state'] = 1; //阅读状态：1未读2已读
                $add_data['create_adm_name'] = $user_info->adm_name; //操作人姓名
                $add_data['create_adm_id'] = $user_info->adm_id; //操作人id
                $addAdminMessage_res = addAdminMessage($add_data);
                if ($addAdminMessage_res['code'] != 200) {
                    return $addAdminMessage_res;
                }
                // 微信消息推送
                $ware_leader_id = explode(',', $find_admin->ware_leader_id);
                foreach($ware_leader_id as $k => $v) {
                    $wechat_msg['pushtype'] = 2; //发货推送
                    $wechat_msg['adm_id'] = $v; //推送人
                    $wechat_msg['wor_number'] = $find_work->wor_number; //工单号
                    $wechat_msg['ord_number'] = $find_work->wor_order_number; //订单号
                    $wechat_msg['user_data'] = $find_work->adm_name . ' ' . $find_work->adm_phone; //姓名
                    $wechat_msg['sepr_name'] = $sepr_name; //服务项目
                    $wechat_msg['orcl_appoint_time'] = $find_work->wor_appoint_time; //预约时间
                    $wechat_msg['ord_create_time'] = $find_work->ord_create_time; //订单创建时间
                    $wechat_msg['user_phone'] = $find_admin->adm_phone; //手机号
                    $wechat_msg['user_dress'] = $find_work->wor_province . $find_work->wor_city . $find_work->wor_county . $find_work->wor_address; //详细地址
                    $wechat_msg['tittle'] = '您有新的发货申请，请及时处理'; //手机
                    $wechat_msg['remark'] = '请确认信息，如有变动，请联系收货人';
                    $CashierDesk = new CashierDesk;
                    $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
                }
            }
            // 订单历史记录
            $data['wohi_primary_id'] = $find_work->wor_order_id;
            $data['wohi_state_name'] = '服务中';
            $data['wohi_state'] = 3;
            $data['wohi_type'] = 1;
            addHistory($data);
            unset($data);
            // 工单的历史记录
            $data['wohi_primary_id'] = $request['wor_id'];
            $data['wohi_state_name'] = '待验车';
            $data['wohi_state'] = 3;//服务状态：3待验车
            $data['wohi_type'] = 2;//1订单2工单
            addHistory($data);
            unset($data);
            if ($find_sepr == 2) {//服务项目不用验车
                // 工单的历史记录
                $data['wohi_primary_id'] = $request['wor_id'];
                $data['wohi_state_name'] = '施工中';
                $data['wohi_state'] = 4;//服务状态：4施工中
                $data['wohi_type'] = 2;//1订单2工单
                addHistory($data);
                unset($data);
            }
            $return_data['wor_number'] = $find_work->wor_number; //工单单号
            $return_data['order_number'] = $find_work->wor_order_number; //订单单号
            return ['code'=>200, 'msg'=>'接单成功', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'接单失败', 'data'=>''];
        }
    }

    // 验件-技师小程序
    public static function validateCar($user_info, $request)
    {
        $find_work = DB::table('work_order as w')
            ->leftJoin('work_client as wc', 'wc.wocl_wor_id', '=', 'w.wor_id')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'w.wor_order_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_order_id', 'wor_order_number', 'wocl_check_car_state', 'wocl_check_car_lock', 'wocl_phone', 'wocl_check_car_lockadmid', 'wocl_car_num', 'wor_work_type', 'wor_service_adm_id', 'orcl_mileage', 'orcl_car_brand_series', 'orcl_check_car_state', 'orcl_check_goods', 'wor_appoint_time', 'orcl_signature_img', 'orcl_check_car_app', 'orcl_is_submit', 'wor_ver_code', 'wor_need_return')
            ->first();
        if (empty($find_work)) {
            return ['code'=>1000, 'msg'=>'当前工单不存在', 'data'=>''];
        }
        $is_code = DB::table('sd_order_code')->where('sdoc_order_id',$find_work->wor_order_id)->value('sdoc_type');
        if(empty($is_code)){
            $is_code = 1;
        }
        $return_data['is_code'] = $is_code??1;
        // 查询当前订单验车数据
        $find_orvc_data = DB::table('wash_validate_car as orvc')
            ->where('vaca_shop_id', $user_info->adm_shop_id)
            ->where('vaca_ord_id', $find_work->wor_order_id)
            ->select('vaca_id', 'vaca_data', 'vaca_name', 'vaca_first_data', 'vaca_data_id', 'vaca_first_data_id', 'vaca_type', 'vaca_must', 'vaca_part', 'vaca_part_type')
            ->get()->toArray();
        if ($request['type'] == 1) {
            if ($find_work->wocl_check_car_lock == 1 && $find_work->wocl_check_car_lockadmid != $user_info->adm_id) {
                return ['code'=>1000, 'msg'=>'验车锁定中，其他技师正在验车', 'data'=>''];
            }
            $updata_data['wocl_check_car_lock'] = 1;//验车锁定
            $updata_data['wocl_check_car_lockadmid'] = $user_info->adm_id;//验车锁定人
            $updata_data['wocl_update_time'] = date('Y-m-d H:i:s');//更新时间
            $update_res = DB::table('work_client')
                ->where('wocl_wor_id', $request['wor_id'])
                ->update($updata_data);
        }
        if ($request['type'] == 1 || $request['type'] == 4) {//类型1获取验车数据并锁定2提交验车数据3取消验车4验车信息
            $find_goods_img = [];
            $fast_postion = [];
            $fast_img = [];
            $explain = '';//补充说明
            // 整车
            $fast_postion[0]['one'] = '整车';
            $fast_postion[0]['one_id'] = 0;
            $all_car[0] = ['id' => 0, 'vacm_type' => 0, 'title'=>'整车'];
            $all_car_num = 0;
            foreach ($all_car as $key => $value) {
                foreach ($find_orvc_data as $key1 => $value1) {
                    if ($value1->vaca_part_type == 0 && $value['title'] == $value1->vaca_data) {
                        $all_car[$key]['vaca_select'] = 1;
                        $all_car[$key]['vaca_id'] = $value1->vaca_id;
                        $all_car_num++;
                    }
                }
            }
            $fast_postion[0]['one_num'] = $all_car_num;
            $fast_postion[0]['two'] = $all_car;
            $car_in = DB::table('wash_validate_car_manage')
                ->where('vacm_shop_id', $user_info->adm_shop_id)
                ->where('vacm_state', 1)
                ->where('vacm_type', 1)
                ->where('vacm_delete', 1) //是否删除：1正常2已删除
                ->select('vacm_id as id', 'vacm_unusual_name as title', 'vacm_type', 'vacm_remark')
                ->get()->toArray();
            $fast_postion[1]['one'] = '车内部分';
            $car_in_num = 0;
            $fast_postion[1]['one_id'] = 1;
            foreach ($car_in as $key => $value) {
                foreach ($find_orvc_data as $key1 => $value1) {
                    if ($value1->vaca_part_type == 1 && $value->title == $value1->vaca_data) {
                        $car_in[$key]->vaca_select = 1;
                        $car_in[$key]->vaca_id = $value1->vaca_id;
                        $car_in_num++;
                    }
                }
            }
            $fast_postion[1]['one_num'] = $car_in_num;
            $fast_postion[1]['two'] = $car_in;
            $car_out = DB::table('wash_validate_car_manage')
                ->where('vacm_shop_id', $user_info->adm_shop_id)
                ->where('vacm_state', 1)
                ->where('vacm_type', 2)
                ->where('vacm_delete', 1) //是否删除：1正常2已删除
                ->select('vacm_id as id', 'vacm_unusual_name as title', 'vacm_type', 'vacm_remark')
                ->get()->toArray();
            $car_out_num = 0;
            foreach ($car_out as $key => $value) {
                foreach ($find_orvc_data as $key1 => $value1) {
                    if ($value1->vaca_part_type == 2 && $value->title == $value1->vaca_data) {
                        $car_out[$key]->vaca_select = 1;
                        $car_out[$key]->vaca_id = $value1->vaca_id;
                        $car_out_num++;
                    }
                }
            }
            $fast_postion[2]['one'] = '外观部分';
            $fast_postion[2]['one_num'] = $car_out_num;
            $fast_postion[2]['one_id'] = 2;
            $fast_postion[2]['two'] = $car_out;
            $type = DB::table('auto_parts')
                ->where('enabled', 1)
                ->select('type', 'type_id')
                ->groupBy('type')
                ->get()->toArray();
            $new_data = [];
            $new_data_one = [];
            foreach ($type as $key1 => $value1) {
                $new_data[$key1]['type'] = $value1->type;
                $new_data[$key1]['type_id'] = $value1->type_id;
                $new_data[$key1]['type_num'] = 0;
                $new_data[$key1]['data'] = DB::table('auto_parts')
                    ->where('enabled', 1)
                    ->where('type', $value1->type)
                    ->select('title', 'id', 'type')
                    ->get()->toArray();
                $new_data_one[$key1]['type'] = $value1->type;
                $new_data_one[$key1]['type_id'] = $value1->type_id;
                $new_data_one[$key1]['type_num'] = 0;
                $new_data_one[$key1]['data'] = DB::table('auto_parts')
                    ->where('enabled', 1)
                    ->where('type', $value1->type)
                    ->select('title', 'id', 'type')
                    ->get()->toArray();
            }
            $car_lacquer = $new_data;
            $car_dismounting = $new_data_one;

            // 查询当前订单验车漆面部分数据
            $car_lacquer_data = DB::table('wash_validate_car as orvc')
                ->where('vaca_shop_id', $user_info->adm_shop_id)
                ->where('vaca_ord_id', $find_work->wor_order_id)
                ->where('vaca_type', 2)
                ->where('vaca_part_type', 3)
                ->select('vaca_id', 'vaca_data', 'vaca_name', 'vaca_first_data', 'vaca_data_id', 'vaca_first_data_id', 'vaca_type', 'vaca_must')
                ->get()->toArray();
            $one_num = 0;
            foreach ($car_lacquer as $key_l => $value_l) {
                foreach ($car_lacquer_data as $key1 => $value1) {
                    if ($value_l['type'] == $value1->vaca_first_data) {
                        foreach ($car_lacquer[$key_l]['data'] as $key2 => $value2) {
                            if ($value2->title == $value1->vaca_data) {
                                $car_lacquer[$key_l]['data'][$key2]->vaca_select = 1;
                                $car_lacquer[$key_l]['data'][$key2]->vaca_id = $value1->vaca_id;
                                $car_lacquer[$key_l]['type_num']++;
                                $one_num++;
                            }
                        }
                    }
                }
            }
            $fast_postion[3]['one'] = '漆面部分';
            $fast_postion[3]['one_id'] = 3;
            $fast_postion[3]['one_num'] = $one_num;
            $fast_postion[3]['two'] = $car_lacquer;
            // 查询当前订单验车数据
            $car_dismounting_data = DB::table('wash_validate_car as orvc')
                ->where('vaca_shop_id', $user_info->adm_shop_id)
                ->where('vaca_ord_id', $find_work->wor_order_id)
                ->where('vaca_type', 2)
                ->where('vaca_part_type', 4)
                ->select('vaca_id', 'vaca_data', 'vaca_name', 'vaca_first_data', 'vaca_data_id', 'vaca_first_data_id', 'vaca_type', 'vaca_must')
                ->get()->toArray();
            $one_num = 0;

            foreach ($car_dismounting as $key => $value) {
                foreach ($car_dismounting_data as $key1 => $value1) {
                    if ($value['type'] == $value1->vaca_first_data) {
                        foreach ($car_dismounting[$key]['data'] as $key2 => $value2) {
                            if ($value2->id == $value1->vaca_data_id) {
                                $car_dismounting[$key]['data'][$key2]->vaca_select = 1;
                                $car_dismounting[$key]['data'][$key2]->vaca_id = $value1->vaca_id;
                                $car_dismounting[$key]['type_num']++;
                                $one_num++;
                            }
                        }
                    }
                }
            }

            $fast_postion[4]['one'] = '拆卸部分';
            $fast_postion[4]['one_id'] = 4;
            $fast_postion[4]['one_num'] = $one_num;
            $fast_postion[4]['two'] = $car_dismounting;
            $i = 0;
            $j = 0;
            $k = 0;
            foreach ($find_orvc_data as $key => $value) {
                if ($value->vaca_type == 1) {//检验商品图片
                    $find_goods_img[$i]['vaca_id'] = $value->vaca_id;
                    $find_goods_img[$i]['vaca_name'] = $value->vaca_name;
                    $find_goods_img[$i]['vaca_data'] = $value->vaca_data;
                    $find_goods_img[$i]['vaca_must'] = $value->vaca_must;
                    $find_goods_img[$i]['vaca_type'] = $value->vaca_type;
                    $find_goods_img[$i]['vaca_data_id'] = $value->vaca_data_id;
                    $i++;
                }

                if ($value->vaca_type == 3) {//快捷图片
                    $fast_img[$j]['vaca_id'] = $value->vaca_id;
                    $fast_img[$j]['vaca_data'] = $value->vaca_data;
                    $j++;
                }
            }
            $chsu_data = DB::table('checkcar_supplement')
                ->where('chsu_ord_id', $find_work->wor_order_id)
                ->select('chsu_id', 'chsu_img', 'chsu_explain', 'chsu_sign')
                ->get()->toArray();
            $return_data['find_goods_img'] = $find_goods_img;
            $return_data['fast_postion'] = $fast_postion;
            $return_data['fast_img'] = $fast_img;
            $return_data['find_work'] = $find_work;
            $return_data['chsu_data'] = $chsu_data;
            if ($request['type'] == 1) {
                if (empty($find_work->wor_appoint_time) || $find_work->wor_appoint_time == '0000-00-00 00:00:00' || empty($find_work->orcl_signature_img)) {
                    $return_data['find_work']->is_submit = 2;
                } else {
                    $return_data['find_work']->is_submit = 1;
                }
            }
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        }

        // if ($request['type'] == 3) {//验车锁定取消
        //     $updata_data['wocl_check_car_lock'] = 2;//验车锁定取消
        //     $updata_data['wocl_update_time'] = date('Y-m-d H:i:s');//更新时间
        //     $update_res = DB::table('work_client')
        //         ->where('wocl_wor_id', $request['wor_id'])
        //         ->update($updata_data);
        //     if ($update_res) {
        //         return ['code'=>200, 'msg'=>'success', 'data'=>'验车取消锁定成功'];
        //     } else {
        //         return ['code'=>1000, 'msg'=>'error',  'data'=>'验车取消锁定失败'];
        //     }
        // }

        // if (!empty($find_work->wor_appoint_time) && $find_work->wor_appoint_time != '0000-00-00 00:00:00' ) {
        //     if ($request['signature'] == 1) {//客户签字在技师端签字
        //         $find_data = DB::table('work_order as w')
        //             ->leftJoin('order as o', 'o.ord_id', '=', 'w.wor_order_id')
        //             ->leftJoin('order_client as orcl', 'o.ord_id', '=', 'orcl.orcl_ord_id')
        //             ->where('wor_id', $request['wor_id'])
        //             ->where('ord_shop_id', $user_info->adm_shop_id)
        //             ->select('ord_id', 'ord_order_number', 'orcl_check_car_state')
        //             ->first();
        //         if (empty($find_data->ord_id)) {
        //             return ['code'=>1000, 'msg'=>'当前订单不存在', 'data'=>''];
        //         }

        //         $orcl_data['orcl_check_car_state'] = 3; //是否验车：1是、已验车2否、未验车3客户已签字
        //         $orcl_data['orcl_check_car_app'] = 1; //验车签字端1技师端客户签字
        //         // $orcl_data['orcl_signature_img'] = $request['img_path'];
        //         $orcl_data['orcl_update_time'] = date('Y-m-d H:i:s');
        //         $orcl_res = DB::table('order_client')
        //             ->where('orcl_ord_id', $find_data->ord_id)
        //             ->update($orcl_data);
        //         if (!$orcl_res) {
        //             return ['code'=>1000, 'msg'=>'失败', 'data'=>'失败'];
        //         }
        //     } else {
        //         // 更改订单客户表的验车字段数据
        //         $ord_data['orcl_check_car_state'] = 1; //是否验车：1是2否
        //         $ord_data['orcl_update_time'] = date('Y-m-d H:i:s');
        //         $orcl_res = DB::table('order_client')
        //             ->where('orcl_ord_id', $find_work->wor_order_id)
        //             ->update($ord_data);
        //     }
        //     // 更改工单客户表的验车字段数据
        //     $wocl_data['wocl_check_car_lock'] = 2;//验车解锁
        //     $wocl_data['wocl_check_car_state'] = 1; //是否验车：1是2否
        //     $wocl_data['wocl_update_time'] = date('Y-m-d H:i:s');
        //     $wocl_res = DB::table('work_client')
        //         ->where('wocl_wor_id', $request['wor_id'])
        //         ->update($wocl_data);
        //     // 更改工单表的工单状态
        //     $wor_edit_data['wor_service_state'] = 5; //服务状态：1待接单2已接单3预约4验车（出发）5抵达6完成待审核 4改成验车
        //     $wor_edit_data['wor_state'] = 7; //3待接单/已派单 4.未出发/已接单 5.预约/已预约 6.验车（出发/已出发）  7.抵达/抵达 8.待审核/完成待审核 6改成 验车/已验车
        //     $wor_edit_data['wor_update_time'] = date('Y-m-d H:i:s');
        //     $wor_edit_res = WashWork::where('wor_id', $request['wor_id'])->update($wor_edit_data);
        // } else {
        //     $orcl_data['orcl_is_submit'] = 1;
        //     $orcl_data['orcl_update_time'] = date('Y-m-d H:i:s');
        //     $res = DB::table('order_client')
        //         ->where('orcl_ord_id', $find_work->wor_order_id)
        //         ->update($orcl_data);
        //     $return_data['wor_number'] = $find_work->wor_number;
        //     $return_data['wor_order_id'] = $find_work->wor_order_id;
        //     return ['code'=>200, 'msg'=>'请联系主管排班，再提交验车信息', 'data'=>$return_data];
        // }

        // 更改工单客户表的验车字段数据
        $wocl_data['wocl_check_car_lock'] = 2;//验车解锁
        $wocl_data['wocl_check_car_state'] = 1; //是否验车：1是2否
        $wocl_data['wocl_update_time'] = date('Y-m-d H:i:s');
        $wocl_res = DB::table('work_client')
            ->where('wocl_wor_id', $request['wor_id'])
            ->update($wocl_data);
        // 更改工单表的工单状态
        if (isset($request['wor_need_return'])) {
            $wor_edit_data['wor_need_return'] = $request['wor_need_return']; //是否返厂维修1是2否
        }
        $wor_edit_data['wor_service_state'] = 5; //服务状态：1待接单2已接单3预约4验车（出发）5抵达、施工中6施工完成待审核7施工完成审核完成待还件8待还件9完成工单待审核绩效 4改成验车
        $wor_edit_data['wor_state'] = 7; //3待接单/已派单 4.未出发/已接单 5.待验车 6.验车（出发/已出发）  7.施工中 8.待审核/完成待审核 6改成 验车/已验车
        $wor_edit_data['wor_update_time'] = date('Y-m-d H:i:s');

        $wor_edit_res = WashWork::where('wor_id', $request['wor_id'])->update($wor_edit_data);
        $orcl_data['orcl_check_car_state'] = 3; //是否验车：1是、已验车2否、未验车3客户已签字
        $orcl_data['orcl_check_car_app'] = 1; //验车签字端1技师端客户签字
        $orcl_data['orcl_update_time'] = date('Y-m-d H:i:s');
        $orcl_res = DB::table('order_client')
            ->where('orcl_ord_id', $find_work->wor_order_id)
            ->update($orcl_data);
        if ($orcl_res && $wocl_res) {
            // 工单的历史记录
            $data['wohi_primary_id'] = $request['wor_id'];
            $data['wohi_state_name'] = '施工中';
            $data['wohi_state'] = 4;//服务状态：4施工中
            $data['wohi_type'] = 2;//1订单2工单
            addHistory($data);
            unset($data);
            $return_data['wor_number'] = $find_work->wor_number;
            $return_data['wor_order_id'] = $find_work->wor_order_id;
            return ['code'=>200, 'msg'=>'验件成功', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'验件失败', 'data'=>''];
        }
    }

    // 验车数据上传
    public static function checkCar($user_info, $request)
    {
        $find_work = DB::table('work_order as w')
            ->leftJoin('work_client as wc', 'wc.wocl_wor_id', '=', 'w.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_order_id', 'wor_order_number', 'wocl_check_car_state', 'wocl_check_car_lock', 'wocl_phone', 'wocl_check_car_lockadmid', 'wocl_car_num', 'wor_state')
            ->first();

        if (empty($find_work)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前工单不存在', 'data'=>'当前工单不存在'];
        }
        if ($find_work->wor_state >= 8) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已完成', 'data'=>'当前工单已完成'];
        }
        // 验车里程数
        if ($request['vaca_type'] == 4) {
            $update_data['orcl_mileage'] = $request['orcl_mileage'];
            $update_data['orcl_update_time'] = date('Y-m-d H:i:s');
            $update_res = DB::table('order_client')->where('orcl_ord_id', $find_work->wor_order_id)->update($update_data);
            if ($update_res) {
                return ['code'=>200, 'msg'=>'保存成功', 'data'=>''];
            } else {
                return ['code'=>500, 'msg'=>'保存失败', 'data'=>''];
            }
        }
        // 商品是否合格
        if ($request['vaca_type'] == 5) {
            $update_data['orcl_check_goods'] = $request['orcl_check_goods'];
            $update_data['orcl_update_time'] = date('Y-m-d H:i:s');
            $update_res = DB::table('order_client')->where('orcl_ord_id', $find_work->wor_order_id)->update($update_data);
            if ($update_res) {
                return ['code'=>200, 'msg'=>'保存成功', 'data'=>''];
            } else {
                return ['code'=>500, 'msg'=>'保存失败', 'data'=>''];
            }
        }

        // 签字图片
        if ($request['vaca_type'] == 6) {
            $update_data['orcl_is_submit'] = 1;
            $update_data['orcl_check_car_app'] = 1;
            $update_data['orcl_signature_img'] = $request['orcl_signature_img'];//签字图片
            $update_data['orcl_update_time'] = date('Y-m-d H:i:s');
            $find_work_order = DB::table('work_order')
                ->leftJoin('order', 'ord_id', '=', 'wor_order_id')
                ->leftJoin('order_client', 'ord_id', '=', 'orcl_ord_id')
                ->where('wor_id', $request['wor_id'])
                ->select('wor_service_adm_id', 'orcl_signature_img')
                ->first();
            if ($find_work_order->wor_service_adm_id != $user_info->adm_id) {
//                $return['wor_service_adm_id'] = $find_work_order->wor_service_adm_id;
//                $return['adm_id'] = $user_info->adm_id;
//                return ['code'=>500, 'msg'=>'不是本工单组长', 'data'=>$return];
                return ['code'=>500, 'msg'=>'不是本工单组长', 'data'=>''];
            }

            if (!empty($find_work_order->orcl_signature_img)) {
                return ['code'=>500, 'msg'=>'已签字', 'data'=>''];
            }
            $update_res = DB::table('order_client')->where('orcl_ord_id', $find_work->wor_order_id)->update($update_data);
            if ($update_res) {
                return ['code'=>200, 'msg'=>'保存成功', 'data'=>''];
            } else {
                return ['code'=>500, 'msg'=>'保存失败', 'data'=>''];
            }
        }
        // 核销码
        if ($request['vaca_type'] == 7) {
            // 提交订单编辑数据
            $return_data = self::verificationCode($user_info, $request);
            if($return_data['code'] == 202){
                return ['code'=>1000, 'msg'=>'核销失败', 'data'=>''];
            }else{
                $update_data['wor_ver_code'] = !empty($request['wor_ver_code']) ? $request['wor_ver_code']:'';
                $update_data['wor_update_time'] = date('Y-m-d H:i:s');
                $update_res = DB::table('work_order')->where('wor_id', $request['wor_id'])->update($update_data);
                if ($update_res) {
                    return ['code'=>200, 'msg'=>'保存成功', 'data'=>''];
                } else {
                    return ['code'=>500, 'msg'=>'保存失败', 'data'=>''];
                }
            }
        }
        if ($request['vaca_type'] != 3) {
            if ($request['vaca_type'] == 2) {
                // 查询当前订单验车数据
                $vaca_id = DB::table('wash_validate_car as vaca')
                    ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'vaca.vaca_ord_id')
                    ->where('vaca_shop_id', $user_info->adm_shop_id)
                    ->where('vaca_ord_id', $find_work->wor_order_id)
                    ->where('vaca_part_type', $request['vaca_part_type'])
                    ->where('vaca_type', $request['vaca_type'])
                    ->where('vaca_data_id', $request['vaca_data_id'])
                    ->value('vaca_id');
            } else {
                $vaca_id = DB::table('wash_validate_car as vaca')
                    ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'vaca.vaca_ord_id')
                    ->where('vaca_shop_id', $user_info->adm_shop_id)
                    ->where('vaca_ord_id', $find_work->wor_order_id)
                    ->where('vaca_type', $request['vaca_type'])
                    ->where('vaca_data_id', $request['vaca_data_id'])
                    ->value('vaca_id');
            }
        } else {
            $vaca_id = 0;
        }

        $add_vaca_data['vaca_shop_id'] = $user_info->adm_shop_id;
        $add_vaca_data['vaca_ord_id'] = $find_work->wor_order_id;
        $add_vaca_data['vaca_type'] = $request['vaca_type'];
        $add_vaca_data['vaca_part_type'] = isset($request['vaca_part_type']) ? $request['vaca_part_type'] : '';
        $add_vaca_data['vaca_part'] = isset($request['vaca_part']) ? $request['vaca_part'] : '';
        $add_vaca_data['vaca_data'] = $request['vaca_data'] ? $request['vaca_data'] : '';
        $add_vaca_data['vaca_name'] = isset($request['vaca_name']) ? $request['vaca_name'] : '';
        $add_vaca_data['vaca_data_id'] = isset($request['vaca_data_id']) ? $request['vaca_data_id'] : '';
        $add_vaca_data['vaca_first_data_id'] = isset($request['vaca_first_data_id']) ? $request['vaca_first_data_id'] : '';
        $add_vaca_data['vaca_first_data'] = isset($request['vaca_first_data']) ? $request['vaca_first_data'] : '';
        if ($vaca_id) {
            $data_id = $vaca_id;
            $add_vaca_data['vaca_update_id'] = $user_info->adm_id;
            $add_vaca_data['vaca_update_time'] = date('Y-m-d H:i:s');
            $add_res = DB::table('wash_validate_car')
                ->where('vaca_id', $vaca_id)
                ->update($add_vaca_data);
        } else {
            $add_vaca_data['vaca_create_id'] = $user_info->adm_id;
            $add_vaca_data['vaca_create_time'] = date('Y-m-d H:i:s');
            $add_res = DB::table('wash_validate_car')->insertGetId($add_vaca_data);
            $data_id = $add_res;
        }

        if ($add_res) {
            return ['code'=>200, 'msg'=>'保存成功', 'data'=>$data_id];
        } else {
            return ['code'=>500, 'msg'=>'保存失败', 'data'=>''];
        }
    }

    // 验车补充
    public static function addCheckCar($user_info, $request)
    {
        $find_work = DB::table('work_order as w')
            ->leftJoin('work_client as wc', 'wc.wocl_wor_id', '=', 'w.wor_id')
            ->leftJoin('order as o', 'o.ord_id', '=', 'w.wor_order_id')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'w.wor_order_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_order_id', 'wor_order_number', 'wocl_check_car_state', 'wocl_check_car_lock', 'wocl_phone', 'wocl_check_car_lockadmid', 'wocl_car_num', 'wor_state', 'orcl_signature_img')
            ->first();
        $find_checkcar_supplement = DB::table('checkcar_supplement')
            ->where('chsu_ord_id', $find_work->wor_order_id)
            ->select('chsu_id')
            ->get()->toArray();
        $find_checkcar_supplement = count($find_checkcar_supplement);
        if ($find_checkcar_supplement >= 50) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单验车已补充50次', 'data'=>'当前工单验车已补充50次'];
        }
        if (empty($find_work)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前工单不存在', 'data'=>'当前工单不存在'];
        }
        if ($find_work->wor_state >= 8) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已完成', 'data'=>'当前工单已完成'];
        }
        $add_chca_data['chsu_ord_id'] = $find_work->wor_order_id;
        $add_chca_data['chsu_img'] = $request['chsu_img'];
        $add_chca_data['chsu_adm_id'] = $user_info->adm_id;
        $add_chca_data['chsu_update_time'] = date('Y-m-d H:i:s');
        $add_chca_data['chsu_explain'] = $request['chsu_explain'] ? $request['chsu_explain'] : '';

        // 更改订单客户表的验车字段数据
        $ord_data['orcl_check_car_state'] = 4; //是否验车：1是2否3签字4补充验车
        $ord_data['orcl_update_time'] = date('Y-m-d H:i:s');
        if (empty($find_work->orcl_signature_img)) {
            $ord_data['orcl_signature_img'] = $request['chsu_sign'];
        }
        // $wor_data['wocl_check_car_state'] = 4; //是否验车：1是2否3签字4补充验车
        $wor_data['wocl_update_time'] = date('Y-m-d H:i:s');
        if ($request['type'] == 2) {// 发送给客户
            $send = isSend($user_info,4);
            if ($send) {
                // 2.给相应的客户发送短信
                $phone = $find_work->wocl_phone;
                $message = '【半径服务】尊敬的客户您好，您的爱车（'.$find_work->wocl_car_num.'）已完成验车，请到小程序(半径服务)中签字确认。';
                if (preg_match("/^1[3456789]\d{9}$/", $phone)) {
                    $find_shop_data = DB::table('shop')
                        ->where('shop_id', $user_info->adm_shop_id)
                        ->first();
                    if ($find_shop_data->shop_message_num <= 0) {
                        $send_state = 2;
                        $send_res = 0;
                    } else {
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $user_info->adm_shop_id)
                            ->where('mrlo_state', 2)
                            ->first();
                        if ($msg_remind_log) {//已提醒过
                            if ($find_shop_data->shop_message_num > $find_shop_data->shop_msg_remind) {
                                $update_remind['mrlo_state'] = 1;
                                $msg_remind_log = DB::table('msg_remind_log')
                                    ->where('mrlo_shop_id', $user_info->adm_shop_id)
                                    ->where('mrlo_state', 2)
                                    ->update($update_remind);
                            }
                        }
                        
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $user_info->adm_shop_id)
                            ->where('mrlo_state', 2)
                            ->first();

                        if (($find_shop_data->shop_message_num-1) <= $find_shop_data->shop_msg_remind && empty($msg_remind_log) && $find_shop_data->shop_msg_adm_id) {
                            $adm_data = DB::table('admin')->where('adm_id', $find_shop_data->shop_msg_adm_id)->first();
                            // $wechat_msg['pushtype'] = 5; //短信预警
                            // $wechat_msg['adm_id'] = $find_shop_data->shop_msg_adm_id; //推送人
                            // $wechat_msg['user_data'] = $adm_data->adm_name; //姓名
                            // $wechat_msg['tittle'] = '剩余短信不足'.$find_shop_data->shop_msg_remind.'条，请及时充值'; //提醒消息
                            // $wechat_msg['remark'] = '短信不足预警';
                            // $CashierDesk = new CashierDesk;
                            // $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
                            $remind_phone = $adm_data->adm_phone;
                            $remind_content = '【半径服务】 您的门店短信余额不足'.$find_shop_data->shop_msg_remind.'条，请及时充值';
                            $remind_send_res = sendSmsCode($remind_phone, $remind_content);
                            if ($remind_send_res > 0) {
                                $send_state = 1;
                                $add_remind['mrlo_shop_id'] = $user_info->adm_shop_id;
                                $add_remind['mrlo_state'] = 2;//未充值，
                                $add_remind['mrlo_adm_id'] = $find_shop_data->shop_msg_adm_id;
                                $add_remind['mrlo_num'] = $find_shop_data->shop_msg_remind;
                                $add_remind['mrlo_create_time'] = date('Y-m-d H:i:s');
                                $add_remind['mrlo_create_id'] = $user_info->adm_id;
                                $reming_res = DB::table('msg_remind_log')->insertGetId($add_remind);
                            } else {
                                $send_state = 2;
                            }
                            // 短信模块日志
                            $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                            $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                            $seme_data['seme_wor_id'] = 0; //订单id
                            $seme_data['seme_name'] = '短信不足预警'; //模板名称
                            $seme_data['seme_phone'] = $remind_phone; //手机号
                            $seme_data['seme_content'] = $remind_content; //内容
                            $seme_data['seme_row'] = 1; //条数
                            $seme_data['seme_status_code'] = $remind_send_res; //短信状态码
                            $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                            $seme_data['seme_ip'] = $request['ip']; //ip地址
                            $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                            $seme_id = DB::table('send_message')->insert($seme_data);
                        }
                        $send_res = sendSmsCode($phone, $message);
                        if ($send_res > 0) {
                            $send_state = 1;
                            $update_shop = DB::table('shop')
                                ->where('shop_id', $user_info->adm_shop_id)
                                ->update(['shop_message_num'=>$find_shop_data->shop_message_num - 1]);
                        } else {
                            $send_state = 2;
                        }
                    }
                    // 短信模块日志
                    $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                    $seme_data['seme_shop_id'] = $user_info->adm_shop_id; //门店id
                    $seme_data['seme_wor_id'] = $request['wor_id']; //工单id
                    $seme_data['seme_name'] = '验车签字提醒'; //模板名称
                    $seme_data['seme_phone'] = $phone; //手机号
                    $seme_data['seme_content'] = $message; //内容
                    $seme_data['seme_row'] = 1; //条数
                    $seme_data['seme_status_code'] = $send_res; //短信状态码
                    $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                    $seme_data['seme_ip'] = $request['ip']; //ip地址
                    $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                    $seme_id = DB::table('send_message')->insert($seme_data);
                    $find_member = DB::table('member')
                        ->where('mem_shop_id', $user_info->adm_shop_id)
                        ->where('mem_phone', $phone)
                        ->first();
                    $add_log['smlo_shop_id'] = $user_info->adm_shop_id;
                    $add_log['smlo_mem_type'] = 2;//1业务人员2会员
                    $add_log['smlo_mem_id'] = $find_member->mem_id;
                    $add_log['smlo_mem_name'] = $find_member->mem_name;
                    $add_log['smlo_mem_phone'] = $phone;
                    $add_log['smlo_type'] = 2;
                    $add_log['smlo_create_time'] = date('Y-m-d H:i:s');
                    $add_log['smlo_state'] = $send_state;
                    $add_log['smlo_msg_type'] = 4;
                    $add_log['smlo_num'] = 1;
                    $add_log['smlo_content'] = $message; //内容
                    $add_log_res = DB::table('sms_log')->insertGetId($add_log);
                }
            }
        } elseif ($request['type'] == 1) {//客户签字
            if (empty($request['chsu_sign'])) {
                return ['code'=>500, 'msg'=>'请签字', 'data'=>'请签字'];
            }
            $add_chca_data['chsu_sign'] = $request['chsu_sign'];//补充验车签字图片
            $ord_data['orcl_check_car_state'] = 3; //是否验车：1是、已验车2否、未验车3客户已签字
            // $wor_data['wocl_check_car_state'] = 3; //是否验车：1是2否3签字4补充验车
        }
        $add_chca_res = DB::table('checkcar_supplement')->insertGetId($add_chca_data);
        // 其他补充验车的未签字图片更新
        $update_data['chsu_sign'] = $request['chsu_sign'];
        $update_data['chsu_update_time'] = date('Y-m-d H:i:s');
        $checkcar_supplement_res = DB::table('checkcar_supplement')
            ->where('chsu_ord_id', $find_work->wor_order_id)
            ->where('chsu_sign', '')
            ->update($update_data);

        $orcl_res = DB::table('order_client')
            ->where('orcl_ord_id', $find_work->wor_order_id)
            ->update($ord_data);
        $wocl_res = DB::table('work_client')
            ->where('wocl_wor_id', $request['wor_id'])
            ->update($wor_data);
        if ($add_chca_res && $orcl_res && $wocl_res) {
            $return_data['wor_number'] = $find_work->wor_number;
            $return_data['wor_order_id'] = $find_work->wor_order_id;
            return ['code'=>200, 'msg'=>'补充成功', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'补充失败', 'data'=>'补充失败'];
        }
    }

    /**
     * 验车取消选择
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-15
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function cancelSelect($user_info, $request) {
        $find_vaca_data = DB::table('wash_validate_car')
            ->where('vaca_id', $request['vaca_id'])
            ->select('vaca_type', 'vaca_data')
            ->first();
        if (empty($find_vaca_data)) {
            return ['code'=>200, 'msg'=>'查无数据', 'data'=>''];
        }
        if ($find_vaca_data->vaca_type == 1) {
            $path = str_replace(config('apisystem.server_name_https').'/storage', storage_path(), $find_vaca_data->vaca_data);
            deleteImage([$path]);
            $update_data['vaca_data'] = '';
            $update_data['vaca_update_time'] = date('Y-m-d H:i:s');
            $update_data['vaca_update_id'] = $user_info->adm_id;
            $update_data_res = DB::table('wash_validate_car')
                ->where('vaca_id', $request['vaca_id'])
                ->update($update_data);
            return ['code'=>200, 'msg'=>'删除成功', 'data'=>''];
        }
        if ($find_vaca_data->vaca_type == 2) {
            $update_data_res = DB::table('wash_validate_car')
                ->where('vaca_id', $request['vaca_id'])
                ->delete();
            return ['code'=>200, 'msg'=>'删除成功', 'data'=>''];
        }

        if ($find_vaca_data->vaca_type == 3) {
            $path = str_replace(config('apisystem.server_name_https').'/storage', storage_path(), $find_vaca_data->vaca_data);
            deleteImage([$path]);
            $update_data_res = DB::table('wash_validate_car')
                ->where('vaca_id', $request['vaca_id'])
                ->delete();
            return ['code'=>200, 'msg'=>'删除成功', 'data'=>''];
        }
    }

    // 微信技师小程序-签字图片提交
    public static function signatureSubmit($user_info, $request)
    {
        $find_data = DB::table('work_order as w')
            ->leftJoin('order as o', 'o.ord_id', '=', 'w.wor_order_id')
            ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
            ->where('wor_id', $request['wor_id'])
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->select('ord_id', 'ord_order_number', 'orcl_check_car_state')
            ->first();
        if (empty($find_data)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前订单不存在', 'data'=>''];
        }

        $data['orcl_check_car_state'] = 3; //是否验车：1是、已验车2否、未验车3客户已签字
        $data['orcl_signature_img'] = $request['img_path'];
        $data['orcl_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'失败'];
        }
    }

    // 施工开始-技师小程序
    public static function construction($user_info, $request)
    {
        // 查询当前工单的商品是否发货，没有发货的不能开始施工
        $dispatch_bill = DB::table('dispatch_bill')
            ->where('dego_wor_id', $request['wor_id'])
            ->where('dego_order_type', 2)
            ->where('dego_type', 1)
            ->first();
        if (!empty($dispatch_bill)) {
            return ['code'=>500, 'msg'=>'请取货后再开始施工！', 'data'=>'请取货后再开始施工！'];
        }
        logRecord($request, 'zptx', 2);

        $find_work = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_state', 'wor_order_id', 'wor_order_number', 'wor_work_type', 'wor_service_adm_id')
            ->first();

        if (empty($find_work)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前工单不存在', 'data'=>''];
        }
        if ($find_work->wor_state >= 7) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单正在施工中，请勿重复点击', 'data'=>''];
        }
        // 查询验车状态，判断客户是否签字
        $find_orcl_data = DB::table('order_client as oc')
            ->leftJoin('wash_order_items as orit', 'orit.orit_ord_id', '=', 'oc.orcl_ord_id')
            ->leftJoin('service_project as sp', 'sp.sepr_id', '=', 'orit.orit_sepr_id')
            ->where('orcl_ord_id', $find_work->wor_order_id)
            ->select('orcl_check_car_state', 'sepr_check_car')
            ->first();
        if ($find_orcl_data->orcl_check_car_state != 3 && $find_orcl_data->sepr_check_car == 1) {
            if ($request['submit_type'] == 1) {
                return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前订单客户尚未签字，确认继续施工?', 'data'=>$find_orcl_data];
            } elseif ($request['submit_type'] == 2) {
                $worre_res = orderRemark($user_info, 0, $request['wor_id'],  '客户未签名，直接施工！', '工单列表');
            }
        } else {
            $worre_res = true;
        }
        $data['wotp_service_start_time'] = date('Y-m-d H:i:s'); //施工开始时间
        $data['wotp_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_work_technician_part')
            ->where('wotp_shop_id', $user_info->adm_shop_id)
            ->where('wotp_wor_id', $request['wor_id'])
            ->update($data);
        // 更改工单表的状态
        $wor_data['wor_state'] = 7; //4.未出发/已接单/待施工 5.预约/已预约  6.出发/已出发  7.施工中  8.待审核/完成待审核
        $wor_data['wor_service_state'] = 5; //服务状态：1待接单2已接单3预约4出发5施工中6维修完成待审核7待还件8还件完成
        $wor_data['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_res = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->update($wor_data);

        // 智配订单,同步信息
        if ($find_work->wor_work_type == 2) {
            $find_service_adm = DB::table('admin')
                ->where('adm_id', $find_work->wor_service_adm_id)
                ->select('adm_name', 'adm_phone')
                ->first();
            $order_data = DB::table('order')
                ->where('ord_id', $find_work->wor_order_id)
                ->select('ord_other_system_number')
                ->first();
            $url = config('apiconnect.ZPTZ_URL') . '/index.php/api/supplychain/SupplyMz/installLine';
            $param['state'] = 4;//开始施工
            $param['time'] = date('Y-m-d H:i:s');
            $param['ip'] = Request::getClientIp();
            $param['token'] = md5(md5($param['time'] . config('apiconnect.ZPTZ_TOKEN'))); //token
            $param['serial_number'] = $order_data->ord_other_system_number; //第三方工单号
            $param['install_name'] = $find_service_adm->adm_name;
            $param['install_phone'] = $find_service_adm->adm_phone;
            $param_return = doPost($param, $url, 2);
            $param_return = json_decode($param_return, true);
            if ($param_return['code'] != 200) {
                return ['code'=>500, 'msg'=>'开始施工失败0', 'data'=>''];
            }
        }
        if ($res && $wor_res) {
            $return_data['wor_number'] = $find_work->wor_number;
            $return_data['wor_order_id'] = $find_work->wor_order_id;
            return ['code'=>200, 'msg'=>'开始施工成功', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'开始施工失败', 'data'=>''];
        }
    }

    // 施工单信息-技师小程序
    public static function constructionInfo($user_info, $request)
    {
        $info = DB::table('work_order as wo')
            ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_id', 'wor_number', 'wor_delete', 'wocl_channel_unit', 'wocl_name', 'wocl_phone', 'wocl_car_num', 'wocl_province', 'wocl_city', 'wocl_county', 'wocl_address', 'wor_remark', 'wor_appoint_time', 'wocl_appoint_remark', 'wocl_car_vehicle_type', 'wocl_check_car_state', 'wocl_service_quality', 'wor_service_state', 'wor_service_adm_id', 'wor_state')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前工单不存在', 'data'=>''];
        }

        // 获取该工单下的商品信息
        $goods_data = DB::table('work_good as wg')
            ->where('wogo_wor_id', $request['wor_id'])
            ->where('wogo_state', '!=', 2)
            ->select('wogo_id', 'wogo_wor_id', 'wogo_goo_id', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_goo_amount', 'wogo_goo_guarantee', 'wogo_goo_type', 'wogo_state', 'wogo_goo_unit', 'wogo_goo_unta_id', 'wogo_recycle_quantity', 'wogo_goo_waste_number')
            ->get()->toArray();
        $service_adm_id[] = $info->wor_service_adm_id; //服务技师id
        // 账号id
        $adm_id = array_filter(array_unique($service_adm_id));
        // 查询账号id对应姓名
        $adm_name = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->pluck('adm_name', 'adm_id')
            ->toArray();
        $info->service_adm_name = isset($adm_name[$info->wor_service_adm_id]) ? $adm_name[$info->wor_service_adm_id] : '';
        // 技师施工部位
        $wotp_data = DB::table('wash_work_technician_part')
            ->where('wotp_shop_id', $user_info->adm_shop_id)
            ->where('wotp_wor_id', $request['wor_id'])
            ->where(function ($query) use ($info, $user_info) { //施工组员只能看自己的信息
                if (!in_array($info->wor_state, [8,10])) {
                    if ($info->wor_service_adm_id != $user_info->adm_id) {
                        $query->where('wotp_service_adm_id', $user_info->adm_id);
                    }
                }
            })
            ->select('wotp_id', 'wotp_service_adm_id', 'wotp_wor_id', 'wotp_grle_name', 'wotp_grpr_name', 'wotp_service_adm_name', 'wotp_service_part', 'wotp_service_start_time', 'wotp_submit_state', 'wotp_service_quality', 'wotp_rewards_punishment', 'wotp_service_data', 'wotp_service_qualitytesting')
            ->get()->toArray();
        if (!empty($wotp_data)) {
            $info->wotp_service_start_time = $wotp_data[0]->wotp_service_start_time; //施工开始时间
        }
        // 补全图片路径
        foreach ($wotp_data as $key => $value) {
            if (!empty($value->wotp_service_quality)) {
                $wotp_service_quality = json_decode($value->wotp_service_quality, true);
                $new_data = [];
                foreach ($wotp_service_quality as $k => $v) {
                    $upload_files = $v['upload_files'];
                    $new_upload_files = [];
                    foreach ($upload_files as $k1 => $v1) {
                        $new_upload_files[$k1]['id'] = $v1['id'];
                        $new_upload_files[$k1]['show_word'] = $v1['show_word'];
                        if ($v1['id'] == 4) {
                            $pic_url = $v1['pic_url'];
                            $new_pic_url = [];
                            foreach ($pic_url as $k2=>$v2) {
                                $new_pic_url[] = addHttpurl($v2);
                            }
                            $new_upload_files[$k1]['pic_url'] = $new_pic_url;
                        } else {
                            $new_upload_files[$k1]['pic_url'] = addHttpurl($v1['pic_url']);
                        }
                    }
                    $new_data[$k]['construction_data'] = $v['construction_data'];
                    $new_data[$k]['upload_files'] = $new_upload_files;
                }
                $wotp_data[$key]->wotp_service_quality = json_encode($new_data, true);
            }

            if (!empty($value->wotp_service_data)) {
                $wotp_service_data = json_decode($value->wotp_service_data, true);
                $new_wotp_service_data = [];
                foreach ($wotp_service_data as $k => $v) {
                    $pic = $v['pic'];
                    $new_pic = [];
                    foreach ($pic as $k1 => $v1) {
                        $new_pic[] = addHttpurl($v1);
                    }
                    $new_wotp_service_data[$k]['wotp_id'] = $v['wotp_id'];
                    $new_wotp_service_data[$k]['wotp_service_part'] = $v['wotp_service_part'];
                    if (isset($v['remark'])) {
                        $new_wotp_service_data[$k]['remark'] = $v['remark'];
                    }
                    $new_wotp_service_data[$k]['pic'] = $new_pic;
                    if (isset($v['person_part_price'])) {
                        $new_wotp_service_data[$k]['person_part_price'] = $v['person_part_price'];
                    }
                    if (isset($v['part_price'])) {
                        $new_wotp_service_data[$k]['part_price'] = $v['part_price'];
                    }
                    if (isset($v['adm_num'])) {
                        $new_wotp_service_data[$k]['adm_num'] = $v['adm_num'];
                    }
                }
                $wotp_data[$key]->wotp_service_data = json_encode($new_wotp_service_data, true);
            }
        }

        $leader = [];
        $worker = [];
        foreach ($wotp_data as $key => $value) {
            if ($info->wor_service_adm_id == $value->wotp_service_adm_id) {
                $leader[] = $value;
            } else {
                $worker[] = $value;
            }
        }

        $wotp_data = array_merge($leader, $worker);

        $data['work_data'] = $info;
        $data['goods_data'] = $goods_data;
        $data['wotp_data'] = $wotp_data;
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 提交施工-施工单信息-技师小程序
    public static function conInfo($user_info, $request)
    {
        $info = DB::table('work_order as wo')
            ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_id', 'wor_number', 'wor_delete', 'wocl_channel_unit', 'wocl_name', 'wocl_phone', 'wocl_car_num', 'wocl_province', 'wocl_city', 'wocl_county', 'wocl_address', 'wor_remark', 'wor_appoint_time', 'wocl_appoint_remark', 'wocl_car_vehicle_type', 'wocl_check_car_state', 'wocl_service_quality', 'wor_service_state', 'wor_service_adm_id')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前工单不存在', 'data'=>''];
        }

        // 获取该工单下的商品信息
        $goods_data = DB::table('work_good as wg')
            ->where('wogo_wor_id', $request['wor_id'])
            ->where('wogo_state', '!=', 2)
            ->select('wogo_id', 'wogo_wor_id', 'wogo_goo_id', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_goo_amount', 'wogo_goo_guarantee', 'wogo_goo_type', 'wogo_state', 'wogo_goo_unit', 'wogo_goo_unta_id', 'wogo_recycle_quantity', 'wogo_goo_waste_number')
            ->get()->toArray();
        $service_adm_id[] = $info->wor_service_adm_id; //服务技师id
        // 账号id
        $adm_id = array_filter(array_unique($service_adm_id));
        // 查询账号id对应姓名
        $adm_name = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->pluck('adm_name', 'adm_id')
            ->toArray();
        $info->service_adm_name = isset($adm_name[$info->wor_service_adm_id]) ? $adm_name[$info->wor_service_adm_id] : '';
        // 技师施工部位
        $wotp_data = DB::table('wash_work_technician_part')
            ->where('wotp_shop_id', $user_info->adm_shop_id)
            ->where('wotp_wor_id', $request['wor_id'])
            ->where(function ($query) use ($info, $user_info) { //施工组员只能看自己的信息
                if ($info->wor_service_adm_id != $user_info->adm_id) {
                    $query->where('wotp_service_adm_id', $user_info->adm_id);
                }
            })
            ->select('wotp_id', 'wotp_service_adm_id', 'wotp_wor_id', 'wotp_grle_name', 'wotp_grpr_name', 'wotp_service_adm_name', 'wotp_service_part', 'wotp_service_start_time', 'wotp_submit_state', 'wotp_service_quality', 'wotp_rewards_punishment', 'wotp_service_data', 'wotp_service_qualitytesting')
            ->get()->toArray();
        if (!empty($wotp_data)) {
            $info->wotp_service_start_time = $wotp_data[0]->wotp_service_start_time; //施工开始时间
        }
        // 补全图片路径
        foreach ($wotp_data as $key => $value) {
            if (!empty($value->wotp_service_quality)) {
                $wotp_service_quality = json_decode($value->wotp_service_quality, true);
                $new_data = [];
                foreach ($wotp_service_quality as $k => $v) {
                    $upload_files = $v['upload_files'];
                    $new_upload_files = [];
                    foreach ($upload_files as $k1 => $v1) {
                        $new_upload_files[$k1]['id'] = $v1['id'];
                        $new_upload_files[$k1]['show_word'] = $v1['show_word'];
                        if ($v1['id'] == 4) {
                            $pic_url = $v1['pic_url'];
                            $new_pic_url = [];
                            foreach ($pic_url as $k2=>$v2) {
                                $new_pic_url[] = addHttpurl($v2);
                            }
                            $new_upload_files[$k1]['pic_url'] = $new_pic_url;
                        } else {
                            $new_upload_files[$k1]['pic_url'] = addHttpurl($v1['pic_url']);
                        }
                    }
                    $new_data[$k]['construction_data'] = $v['construction_data'];
                    $new_data[$k]['upload_files'] = $new_upload_files;
                }
                $wotp_data[$key]->wotp_service_quality = json_encode($new_data, true);
            }

            if (!empty($value->wotp_service_data)) {
                $wotp_service_data = json_decode($value->wotp_service_data, true);
                $new_wotp_service_data = [];
                foreach ($wotp_service_data as $k => $v) {
                    $pic = $v['pic'];
                    $new_pic = [];
                    foreach ($pic as $k1 => $v1) {
                        $new_pic[] = addHttpurl($v1);
                    }
                    $new_wotp_service_data[$k]['wotp_id'] = $v['wotp_id'];
                    $new_wotp_service_data[$k]['wotp_service_part'] = $v['wotp_service_part'];
                    if (isset($v['remark'])) {
                        $new_wotp_service_data[$k]['remark'] = $v['remark'];
                    }
                    $new_wotp_service_data[$k]['pic'] = $new_pic;
                    if (isset($v['person_part_price'])) {
                        $new_wotp_service_data[$k]['person_part_price'] = $v['person_part_price'];
                    }
                    if (isset($v['part_price'])) {
                        $new_wotp_service_data[$k]['part_price'] = $v['part_price'];
                    }
                    if (isset($v['adm_num'])) {
                        $new_wotp_service_data[$k]['adm_num'] = $v['adm_num'];
                    }
                }
                $wotp_data[$key]->wotp_service_data = json_encode($new_wotp_service_data, true);
            }
        }

        $leader = [];
        $worker = [];
        foreach ($wotp_data as $key => $value) {
            if ($info->wor_service_adm_id == $value->wotp_service_adm_id) {
                $leader[] = $value;
            } else {
                $worker[] = $value;
            }
        }

        $wotp_data = array_merge($leader, $worker);

        $data['work_data'] = $info;
        $data['goods_data'] = $goods_data;
        $data['wotp_data'] = $wotp_data;
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 取消工单
    public static function cancel($user_info, $request)
    {
        // 查询信息
        $find_work = DB::table('work_order as wor')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_state', 'wor_order_id', 'wor_goo_amount', 'wor_type', 'wor_actual_price', 'wor_ware_id', 'wor_remark', 'wor_pass', 'wor_service_type', 'wor_type', 'wocl_client_id', 'wocl_sd_virtual_type', 'wocl_wor_type', 'wor_order_number', 'wor_delete')
            ->first();

        if (empty($find_work)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单不存在，无法取消工单！', 'data'=>''];
        }
        if (!in_array($find_work->wor_state, [1, 2, 12])) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单不是未派单状态，无法取消工单！', 'data'=>''];
        }
        if ($find_work->wor_pass == 4) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已经锁定，无法取消工单！', 'data'=>''];
        }
        if ($find_work->wor_delete != 1) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已经取消！', 'data'=>''];
        }

        $work_order = new WorkOrders();
        $return_data = $work_order->deletes($user_info, $request, $find_work);
        if ($return_data['code'] == 200) {
            $data['wor_order_id'] = $find_work->wor_order_id;
            $data['wor_order_number'] = $find_work->wor_order_number;
            return ['code'=>200, 'msg'=>'取消工单成功', 'data'=>$data];
        } else {
            return $return_data;
        }
    }

    // 重新派单
    public static function assign($user_info, $request)
    {
        // 查询信息
        $find_work = DB::table('work_order as wor')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_state', 'wor_order_id', 'wor_order_number', 'wor_pass', 'wor_service_type', 'wor_type', 'wor_delete', 'wocl_wor_type', 'wor_ware_id', 'wocl_client_id', 'wor_goo_amount', 'wor_service_shop_id', 'wor_service_adm_id', 'wor_remark', 'wor_create_id', 'wor_appoint_time')
            ->first();
        if (empty($find_work)) {
            return ['code'=>500, 'msg'=>'当前工单不存在，无法派单！', 'data'=>'当前工单不存在，无法派单！'];
        }
        if (!in_array($find_work->wor_state, [2])) {
            return ['code'=>500, 'msg'=>'该状态不是未派单状态, 不能重新派单', 'data'=>'该状态不是未派单状态, 不能重新派单'];
        }

        // 如果有传预约时间；则判断预约限制数量
        if (isset($request['orcl_appoint_time']) && $request['orcl_appoint_time'] != '0000-00-00 00:00:00' && !empty($request['orcl_appoint_time'])) {
            $resenum_date=substr($request['orcl_appoint_time'],0,10);
            $post_data['ord_new_type'] = DB::table('order')
                ->where('ord_id', $find_work->wor_order_id)
                ->value('ord_new_type');
            $jud_res=static::judgmentShopReser($user_info,$resenum_date,$find_work->wor_appoint_time,$post_data);
            if($jud_res['code'] != 200) return $jud_res;
        }
        $service_adm_data = json_decode($request['service_adm_data'], true);
        $service_adm_id = array_column($service_adm_data, 'service_adm_id');
        if (empty($service_adm_data)) {
            return ['code'=>500, 'msg'=>'请选择技师', 'data'=>'请选择技师'];
        }
        // 判断当前技师状态
        $adm_state = DB::table('admin_shop_role')
            ->whereIn('adm_id', $service_adm_id)
            ->where('shop_id', $user_info->adm_shop_id)
            ->select('adm_state')
            ->get()->toArray();
        foreach ($adm_state as $key => $value) {
            if ($value->adm_state != 1) { //状态1在职2离职
                return ['data'=>500, 'msg'=>'当前技师已离职,无法派单', 'data'=>'当前技师已离职,无法派单'];
            }
        }
        $work_order = new WorkOrders();
        $return_data = $work_order->sendAssing($user_info, $request, 1, $find_work);
        if ($return_data['code'] == 500) {
            return $return_data;
        }

        $find_wotp_data = DB::table('wash_work_technician_part')
            ->where('wotp_wor_id', $request['wor_id'])
            ->select('wotp_id')
            ->get()->toArray();
        if ($find_wotp_data) {
            $del_wotp_data = DB::table('wash_work_technician_part')
                ->where('wotp_wor_id', $request['wor_id'])
                ->delete();
        } else {
            $del_wotp_data = true;
        }
        $service_adm_data = json_decode($request['service_adm_data'], true);
        $service_adm_id = '';
        foreach ($service_adm_data as $key => $value) {
            // 工单技师施工部位表
            $wotp_data['wotp_shop_id'] = $user_info->adm_shop_id;
            $wotp_data['wotp_wor_id'] = $request['wor_id'];
            $wotp_data['wotp_service_adm_id'] = $value['adm_id'];

            // 查询技师相关信息
            $find_adm_data = DB::table('admin as a')
                ->leftJoin('wash_grade_level as b', 'b.grle_id', '=', 'a.adm_grle_id')
                ->leftJoin('wash_grade_professional as c', 'c.grpr_id', '=', 'b.grle_grpr_id')
                ->where('adm_id', $value['adm_id'])
                ->select('adm_id', 'adm_name', 'adm_phone', 'grle_id', 'grle_name', 'grpr_id', 'grpr_name')
                ->first();
            if (empty($find_adm_data)) {
                return ['code'=>500, 'msg'=>'未找到技师相关信息', 'data'=>''];
            }
            $wotp_data['wotp_service_adm_name'] = $find_adm_data->adm_name;
            $wotp_data['wotp_service_adm_phone'] = $find_adm_data->adm_phone;
            if ($find_adm_data->grle_id) {
                $wotp_data['wotp_grle_id'] = $find_adm_data->grle_id;
            } else {
                $wotp_data['wotp_grle_id'] = '';
            }
            if ($find_adm_data->grle_name) {
                $wotp_data['wotp_grle_name'] = $find_adm_data->grle_name;
            } else {
                $wotp_data['wotp_grle_name'] = '';
            }
            if ($find_adm_data->grpr_id) {
                $wotp_data['wotp_grpr_id'] = $find_adm_data->grpr_id;
            } else {
                $wotp_data['wotp_grpr_id'] = '';
            }
            if ($find_adm_data->grpr_name) {
                $wotp_data['wotp_grpr_name'] = $find_adm_data->grpr_name;
            } else {
                $wotp_data['wotp_grpr_name'] = '';
            }
            $wotp_data['wotp_update_time'] = date('Y-m-d H:i:s');
            // $service_adm_id = $service_adm_id.','.$value['adm_id'];
            $add_wotp_res = DB::table('wash_work_technician_part')->insert($wotp_data);
            $wotp_data1 = $wotp_data;
            $wotp_data2 = $wotp_data;
            $wotp_data1['wotp_work_type'] = 2;
            $wotp_data2['wotp_work_type'] = 3;
            $add_wotp_res = DB::table('wash_work_technician_part')->insert($wotp_data1);
            $add_wotp_res = DB::table('wash_work_technician_part')->insert($wotp_data2);
        }
        // $wopl_data['wopl_address_type'] = $request['wor_address_type'];
        // $wopl_data['wopl_address_id'] = $request['wor_address_id'];
        // $wopl_data['wopl_address'] = $request['wor_address'];
        // $wopl_data['wopl_explain'] = $request['wor_explain'];
        // $wopl_data['wopl_service_id'] = $service_adm_id;
        // $wopl_data['wopl_time'] = date('H:i:s', strtotime($request['orcl_appoint_time']));
        // $wopl_data['wopl_date'] = date('Y-m-d', strtotime($request['orcl_appoint_time']));
        // $wopl_data['wopl_update_time'] = date('Y-m-d H:i:s');
        // $wopl_res = DB::table('work_plan')->where('wopl_wor_id', $request['wor_id'])->update($wopl_data);
        
        if ($add_wotp_res) {
            return ['code'=>200, 'msg'=>'重新派单成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'重新派单失败'.$add_wotp_res.$wopl_res, 'data'=>''];
        }
    }

    // 备注查询数据
    public static function remarkSearch($user_info, $request)
    {
        $find_work = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->first(['wor_order_id', 'wor_number']);
        $data['wor_order_id'] = $find_work->wor_order_id;
        $data['wor_number'] = $find_work->wor_number;
        return $data;
    }

    // 预约设置
    public function appointmentSet($user_info, $request)
    {
        $find_work = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->select('wor_order_id', 'wor_number', 'wor_state', 'wor_delete','wor_appoint_time')
            ->first();
        if (empty($find_work)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单不存在！', 'data'=>''];
        }
        if ($find_work->wor_delete != 1) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已经取消！', 'data'=>''];
        }
        $find_order = DB::table('order')
            ->where('ord_id', $find_work->wor_order_id)
            ->first();
        $post_data['ord_new_type'] = $find_order->ord_new_type;
        $resenum_date=substr($request['appoint_time'],0,10);
        $jud_res=static::judgmentShopReser($user_info,$resenum_date,$find_work->wor_appoint_time,$post_data);
        if($jud_res['code'] != 200) return $jud_res;

        // 如果技师已经接单，工单状态改为预约状态
        if ($find_work->wor_state == 4) {
            $wor_edit['wor_service_state'] = 3; //服务状态：1待接单2已接单3预约4已验车/待施工 出发5抵达/施工中
            $wor_edit['wor_state'] = 5; //3待接单/已派单 4.未出发/已接单 5.预约/已预约
        }

        // 工单更改预约时间
        $wor_edit['wor_appoint_time'] = $request['appoint_time'];
        $wor_edit['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_edit_res = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->update($wor_edit);
        $wopl_data=[];
        $wopl_data['wopl_time'] = date('H:i:s', strtotime($request['appoint_time']));
        $wopl_data['wopl_date'] = date('Y-m-d', strtotime($request['appoint_time']));
        Db::table('work_plan')
            ->where('wopl_wor_id',$request['wor_id'])
            ->update($wopl_data);
        if (isset($request['appoint_remark']) && !empty($request['appoint_remark'])) {
            $wocl_edit['wocl_appoint_remark'] = $request['appoint_remark'];
            $wocl_edit['wocl_update_time'] = date('Y-m-d H:i:s');
            $wocl_edit_res = DB::table('work_client')
                ->where('wocl_wor_id', $request['wor_id'])
                ->update($wocl_edit);

            $orcl_edit['orcl_appoint_remark'] = $request['appoint_remark'];
        } else {
            $wocl_edit_res = true;
        }

        // 订单客户表更改预约时间、预约备注
        $orcl_edit['orcl_appoint_time'] = $request['appoint_time'];
        $orcl_edit['orcl_update_time'] = date('Y-m-d H:i:s');
        $orcl_res = DB::table('order_client')
            ->where('orcl_ord_id', $find_work->wor_order_id)
            ->update($orcl_edit);
        $ord_data['ord_new_type'] = $request['ord_new_type'];
        $ord_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_res = DB::table('order')
            ->where('ord_id', $find_work->wor_order_id)
            ->update($ord_data);
        if ($wocl_edit_res && $wor_edit_res && $orcl_res) {
            // // 2.给施工小组发送短信
            $find_data = DB::table('wash_work_technician_part')
                ->where('wotp_wor_id', $request['wor_id'])
                ->select('wotp_service_adm_name', 'wotp_service_adm_phone')
                ->get()->toArray();
            foreach ($find_data as $key => $value) {
                $send = isSend($user_info,3);
                if ($send) {
                    $phone = $value->wotp_service_adm_phone;
                    $message = '【半径美装】您负责的工单（工单号：'.$find_work->wor_number.'）施工时间已变更，请知晓！';
                    if (preg_match("/^1[3456789]\d{9}$/", $phone)) {
                        $find_shop_data = DB::table('shop')
                            ->where('shop_id', $user_info->adm_shop_id)
                            ->first();
                        if ($find_shop_data->shop_message_num <= 0) {
                            $send_state = 2;
                            $send_res = 0;
                        } else {
                            $msg_remind_log = DB::table('msg_remind_log')
                                ->where('mrlo_shop_id', $user_info->adm_shop_id)
                                ->where('mrlo_state', 2)
                                ->first();
                            if ($msg_remind_log) {//已提醒过
                                if ($find_shop_data->shop_message_num > $find_shop_data->shop_msg_remind) {
                                    $update_remind['mrlo_state'] = 1;
                                    $msg_remind_log = DB::table('msg_remind_log')
                                        ->where('mrlo_shop_id', $user_info->adm_shop_id)
                                        ->where('mrlo_state', 2)
                                        ->update($update_remind);
                                }
                            }
                            
                            $msg_remind_log = DB::table('msg_remind_log')
                                ->where('mrlo_shop_id', $user_info->adm_shop_id)
                                ->where('mrlo_state', 2)
                                ->first();

                            if (($find_shop_data->shop_message_num-1) <= $find_shop_data->shop_msg_remind && empty($msg_remind_log) && $find_shop_data->shop_msg_adm_id) {
                                $adm_data = DB::table('admin')->where('adm_id', $find_shop_data->shop_msg_adm_id)->first();
                                // $wechat_msg['pushtype'] = 5; //短信预警
                                // $wechat_msg['adm_id'] = $find_shop_data->shop_msg_adm_id; //推送人
                                // $wechat_msg['user_data'] = $adm_data->adm_name; //姓名
                                // $wechat_msg['tittle'] = '剩余短信不足'.$find_shop_data->shop_msg_remind.'条，请及时充值'; //提醒消息
                                // $wechat_msg['remark'] = '短信不足预警';
                                // $CashierDesk = new CashierDesk;
                                // $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
                                $remind_phone = $adm_data->adm_phone;
                                $remind_content = '【半径服务】 您的门店短信余额不足'.$find_shop_data->shop_msg_remind.'条，请及时充值';
                                $remind_send_res = sendSmsCode($remind_phone, $remind_content);
                                if ($remind_send_res > 0) {
                                    $send_state = 1;
                                    $add_remind['mrlo_shop_id'] = $user_info->adm_shop_id;
                                    $add_remind['mrlo_state'] = 2;//未充值，
                                    $add_remind['mrlo_adm_id'] = $find_shop_data->shop_msg_adm_id;
                                    $add_remind['mrlo_num'] = $find_shop_data->shop_msg_remind;
                                    $add_remind['mrlo_create_time'] = date('Y-m-d H:i:s');
                                    $add_remind['mrlo_create_id'] = $user_info->adm_id;
                                    $reming_res = DB::table('msg_remind_log')->insertGetId($add_remind);
                                } else {
                                    $send_state = 2;
                                }
                                // 短信模块日志
                                $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                                $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                                $seme_data['seme_wor_id'] = 0; //订单id
                                $seme_data['seme_name'] = '短信不足预警'; //模板名称
                                $seme_data['seme_phone'] = $remind_phone; //手机号
                                $seme_data['seme_content'] = $remind_content; //内容
                                $seme_data['seme_row'] = 1; //条数
                                $seme_data['seme_status_code'] = $remind_send_res; //短信状态码
                                $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                                $seme_data['seme_ip'] = $request['ip']; //ip地址
                                $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                                $seme_id = DB::table('send_message')->insert($seme_data);
                            }
                            $send_res = sendSmsCode($phone, $message);
                            if ($send_res > 0) {
                                $send_state = 1;
                                $update_shop = DB::table('shop')
                                    ->where('shop_id', $user_info->adm_shop_id)
                                    ->update(['shop_message_num'=>$find_shop_data->shop_message_num - 1]);
                            } else {
                                $send_state = 2;
                            }
                        }
                        // 短信模块日志
                        $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                        $seme_data['seme_shop_id'] = $user_info->adm_shop_id; //门店id
                        $seme_data['seme_wor_id'] = $request['wor_id']; //工单id
                        $seme_data['seme_name'] = '预约时间修改'; //模板名称
                        $seme_data['seme_phone'] = $phone; //手机号
                        $seme_data['seme_content'] = $message; //内容
                        $seme_data['seme_row'] = 1; //条数
                        $seme_data['seme_status_code'] = $send_res; //短信状态码
                        $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                        $seme_data['seme_ip'] = $request['ip']; //ip地址
                        $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                        $seme_id = DB::table('send_message')->insert($seme_data);
                        $find_member = DB::table('member')
                            ->where('mem_shop_id', $user_info->adm_shop_id)
                            ->where('mem_phone', $phone)
                            ->first();
                        $add_log['smlo_shop_id'] = $user_info->adm_shop_id;
                        $add_log['smlo_mem_type'] = 2;//1业务人员2会员
                        $add_log['smlo_mem_id'] = $find_member->mem_id;
                        $add_log['smlo_mem_name'] = $find_member->mem_name;
                        $add_log['smlo_mem_phone'] = $phone;
                        $add_log['smlo_type'] = 2;
                        $add_log['smlo_create_time'] = date('Y-m-d H:i:s');
                        $add_log['smlo_state'] = $send_state;
                        $add_log['smlo_msg_type'] = 4;
                        $add_log['smlo_num'] = 1;
                        $add_log['smlo_content'] = $message; //内容
                        $add_log_res = DB::table('sms_log')->insertGetId($add_log);
                    }
                }
            }
            $data['wor_order_id'] = $find_work->wor_order_id;
            $data['wor_number'] = $find_work->wor_number;
            return ['code'=>200, 'msg'=>'预约设置成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'预约设置失败', 'data'=>''];
        }
    }

    // 预约时间修改
    public function appointmentOrderSet($user_info, $request)
    {
        $find_order = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_id', 'ord_order_number')
            ->first();
        if (empty($find_order)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单不存在！', 'data'=>''];
        }

        // 订单客户表更改预约时间、预约备注
        $orcl_edit['orcl_appoint_time'] = $request['appoint_time'];
        $orcl_edit['orcl_update_time'] = date('Y-m-d H:i:s');
        $orcl_res = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->update($orcl_edit);

        if ($orcl_res) {
            $data['ord_id'] = $find_order->ord_id;
            $data['ord_order_number'] = $find_order->ord_order_number;
            return ['code'=>200, 'msg'=>'预约设置成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'预约设置失败', 'data'=>''];
        }
    }

    // 获取字段数据
    public static function getFieldsById($id, $fields = '*', $shopID = 0)
    {
        $entity = WashWork::where('wor_id', $id)
            ->where('wor_shop_id', $shopID)
            ->select($fields)
            ->first();

        return $entity;
    }

    // 获取技师的绩效金额
    public static function getMeritPay($user_info, $request)
    {
        // 组长id
        $wor_service_adm_id = DB::table('work_order')
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->where('wor_id', $request['wor_id'])
            ->value('wor_service_adm_id');
        // 服务项目id
        $sepr_data = DB::table('work_good')
            ->where('wogo_wor_id', $request['wor_id'])
            ->where('wogo_goo_type', 2)
            ->select('wogo_goo_id')
            ->get()->toArray();
        $sepr_id = array_unique(array_column($sepr_data, 'wogo_goo_id'));
        $find_wotp_data = DB::table('wash_work_technician_part as w')
            ->where('wotp_shop_id', $user_info->adm_shop_id)
            ->where('wotp_wor_id', $request['wor_id'])
            ->select('wotp_service_data', 'wotp_service_adm_id', 'wotp_grle_name', 'wotp_grpr_name', 'wotp_service_qualitytesting', 'wotp_service_adm_name', 'wotp_work_type')
            ->get()->toArray();

        $new_tech_data = [];
        $find_wotp_data = json_decode(json_encode($find_wotp_data, true), true);
        $completion_info = self::completionInfoByWorId($request['wor_id']);//施工数据
        $qulity_info = self::qualityDataByWorId($request['wor_id']);//质检数据

        if($completion_info){
            foreach ($find_wotp_data as $key => $value) {
                if(isset($completion_info[$value['wotp_service_adm_id']]['performance'])){
                    $new_completion = CommonService::jointArrayKey(json_decode(json_encode($completion_info[$value['wotp_service_adm_id']]['performance']),true),'coin_adm_id',2);
                    if(!empty($new_completion)){
                        foreach ($new_completion[$value['wotp_service_adm_id']] as $key_one => $value_one) {
                            // 统计施工部位的施工人数、施工技师、施工部位名称
                            if (isset($new_tech_data[$value_one['wotp_id']])) {
                                $new_tech_data[$value_one['wotp_id']]['adm_num'] += 1;
                            } else {
                                $new_tech_data[$value_one['wotp_id']]['adm_num'] = 1;
                            }
                            $new_tech_data[$value_one['wotp_id']]['adm_id'][] = $value['wotp_service_adm_id'];//施工技师id
                            $new_tech_data[$value_one['wotp_id']]['part_name'] = $value_one['wotp_service_part'];//施工部位名称
                        }
                        $find_wotp_data[$key]['wotp_service_data'] = $new_completion[$value['wotp_service_adm_id']];
                    }
                }
                //质检
                if(isset($qulity_info[$value['wotp_service_adm_id']]['quality_info'])){
                    $new_qulity = CommonService::jointArrayKey(json_decode(json_encode($qulity_info[$value['wotp_service_adm_id']]['quality_info']),true),'quda_adm_id',2);
                    if(!empty($new_qulity)){
                        foreach ($new_qulity[$value['wotp_service_adm_id']] as $keyq_one => $valueq_one) {
                            $find_wotp_data[$key]['wotp_service_qualitytesting'] = json_encode($new_qulity[$value['wotp_service_adm_id']]);
                        }
                    }
                }
            }
        }

        // 统计施工部位的施工人数、施工技师、施工部位名称  20230821
        /*$completion_info = self::completionInfoByWorId($request['wor_id']);//施工数据
        if($completion_info){
            foreach ($completion_info as $com_key => $com_value){
                foreach ($com_value['technician']['all'] as $tab_key => $tab_value){
                    if($tab_value['coin_type'] == 1){
                        if (isset($new_tech_data[$tab_value['coin_data_id']])) {
                            $new_tech_data[$tab_value['coin_data_id']]['adm_num'] += 1;
                        } else {
                            $new_tech_data[$tab_value['coin_data_id']]['adm_num'] = 1;
                        }
                        $new_tech_data[$tab_value['coin_data_id']]['adm_id'][] = $tab_value['coin_adm_id'];//施工技师id
                        $new_tech_data[$tab_value['coin_data_id']]['part_name'] = $tab_value['coin_data'];//施工部位名称
                    }
                }
            }
        }*/

        $return_data = [];
        if ($request['choose_type'] == 1) {// 按施工部位计算
            foreach ($new_tech_data as $key => $value) {
                foreach ($value['adm_id'] as $key_one => $value_one) {
                    // 查询技师的职级
                    $adm_data = DB::table('admin_shop_role')
                        ->where('adm_id', $value_one)
                        ->where('shop_id', $user_info->adm_shop_id)
                        ->select('adm_grle_id')
                        ->first();
                    // 如果有技师的职级，根据技师职级，服务项目、施工部位查询绩效金额，否则为0
                    if (!empty($adm_data)) {
                        $part_price[] = DB::table('wash_performance_manage')
                            ->where('pema_shop_id', $user_info->adm_shop_id)
                            ->where('pema_grle_id', $adm_data->adm_grle_id)
                            ->whereIn('pema_service_type_id', $sepr_id)
                            ->where('pema_name', $value['part_name'])
                            ->where('pema_type', 1)
                            ->where('pema_state', 1)
                            ->value('pema_standard');
                    } else {
                        $part_price[] = 0;
                    }
                }
                // 多个技师施工同一个部位，取绩效金额最高的技师的绩效
                $new_tech_data[$key]['max'] = max($part_price);
                unset($part_price);
            }

            foreach ($find_wotp_data as $key_two => $value_two) {
                //$wotp_service_data = json_decode($value_two['wotp_service_data'], true);
                if(isset($completion_info[$value_two['wotp_service_adm_id']]['performance'])){
                    $new_completion = CommonService::jointArrayKey(json_decode(json_encode($completion_info[$value_two['wotp_service_adm_id']]['performance']),true),'coin_adm_id',2);
                    if(!empty($new_completion)){
                        foreach ($new_completion[$value_two['wotp_service_adm_id']] as $key_ones => $value_ones) {
                            $new_completion[$value_two['wotp_service_adm_id']][$key_ones]['part_price'] = $new_tech_data[$value_ones['wotp_id']]['max'] / 100;// 技师施工部位总金额
                            $new_completion[$value_two['wotp_service_adm_id']][$key_ones]['adm_num'] = $new_tech_data[$value_ones['wotp_id']]['adm_num'];// 技师施工部位总金额
                            $new_completion[$value_two['wotp_service_adm_id']][$key_ones]['person_part_price'] = round($new_tech_data[$value_ones['wotp_id']]['max']/$new_tech_data[$value_ones['wotp_id']]['adm_num']) / 100;// 技师施工部位总金额
                        }
                        $find_wotp_data[$key_two]['wotp_service_data'] = $new_completion[$value_two['wotp_service_adm_id']];
                    }
                }

            }
            /*foreach ($find_wotp_data as $key_two => $value_two) {
                if(isset($completion_info[$value_two['wotp_service_adm_id']]['technician']['performance'])){
                    $jixiao = $completion_info[$value_two['wotp_service_adm_id']]['technician']['performance'];
                    if(!empty($jixiao)){
                        foreach ($jixiao as $jix_key => $jix_value){
                            $find_wotp_data[$key_two]['coin_data_id'] = $jix_value->coin_data_id;
                            $find_wotp_data[$key_two]['coin_part_price'] = $new_tech_data[$jix_value->coin_data_id]['max'];
                            $find_wotp_data[$key_two]['adm_num'] = $new_tech_data[$jix_value->coin_data_id]['adm_num'];
                            $find_wotp_data[$key_two]['coin_person_part_price'] = round($new_tech_data[$jix_value->coin_data_id]['max']/$new_tech_data[$jix_value->coin_data_id]['adm_num']);
                        }
                    }
                }
            }*/
        } elseif ($request['choose_type'] == 2) {// 按整车施工
            // 查询所有的施工技师
            $adm_service_part = DB::table('wash_work_technician_part')
                ->where('wotp_shop_id', $user_info->adm_shop_id)
                ->where('wotp_wor_id', $request['wor_id'])
                ->select('wotp_service_adm_id')
                ->get()->toArray();
            $car_price = DB::table('wash_performance_manage')
                ->where('pema_shop_id', $user_info->adm_shop_id)
                ->where('pema_service_type_id', $sepr_id)
                ->where('pema_name', $request['vehicle_type_name'])
                ->where('pema_type', 2)
                ->where('pema_state', 1)
                ->select('pema_standard', 'pema_weixiu', 'pema_huanjian')
                ->first();
            // // 统计施工人数
            $adm_sum = count($adm_service_part);
            // $car_price = DB::table('wash_performance_manage')
            //     ->where('pema_shop_id', $user_info->adm_shop_id)
            //     ->where('pema_service_type_id', $sepr_id)
            //     ->where('pema_name', $request['vehicle_type_name'])
            //     ->where('pema_type', 2)
            //     ->where('pema_state', 1)
            //     ->value('pema_standard');
            if (empty($car_price)) {
                $car_price = 0;
            }
            // 获取绩效最大值
            foreach ($find_wotp_data as $key_two => $value_two) {
                if ($car_price) {
                    if ($value_two['wotp_work_type'] == 1) {
                        $find_wotp_data[$key_two]['car_price'] = $car_price->pema_standard;//取件的绩效
                        $find_wotp_data[$key_two]['person_car_price'] = $car_price->pema_standard;
                         // round($car_price/$adm_sum);//每个人的施工绩效金额
                    }

                    if ($value_two['wotp_work_type'] == 2) {
                        $find_wotp_data[$key_two]['car_price'] = $car_price->pema_weixiu;//维修的绩效
                        $find_wotp_data[$key_two]['person_car_price'] = $car_price->pema_weixiu;
                         // round($car_price/$adm_sum);//每个人的施工绩效金额
                    }

                    if ($value_two['wotp_work_type'] == 3) {
                        $find_wotp_data[$key_two]['car_price'] = $car_price->pema_huanjian;//还件的绩效
                        $find_wotp_data[$key_two]['person_car_price'] = $car_price->pema_huanjian;
                         // round($car_price/$adm_sum);//每个人的施工绩效金额
                    }
                    $find_wotp_data[$key_two]['adm_num'] = 1;//施工人数
                    
                } else {
                    $find_wotp_data[$key_two]['car_price'] = $car_price;//整车的绩效
                    $find_wotp_data[$key_two]['adm_num'] = $adm_sum;//施工人数
                    $find_wotp_data[$key_two]['person_car_price'] = round($car_price/$adm_sum);//每个人的施工绩效金额
                }
            }
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$find_wotp_data];
    }

    // 生成售后单
    public static function afterSale($user_info, $request)
    {
        $return_data = self::info($user_info, $request);
        if ($return_data['code'] != 200) {
            return $return_data;
        }

        $find_work_data = $return_data['data']['work_data'];
        $goods_data = $return_data['data']['goods_data'];
        if ($find_work_data->wor_service_state == 7) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'error', 'data'=>'当前订单存在售后单，无法生成售后单'];
        }
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 获取售后单编号
        $afsl_number = Common::numberRule((object)$user_info, 6);
        $afsl_data['afsl_after_number'] = $afsl_number; //售后单号
        $afsl_data['afsl_cid'] = $user_info->adm_cid;
        $afsl_data['afsl_superior_shop_id'] = $shop_id;
        $afsl_data['afsl_shop_id'] = $user_info->adm_shop_id;
        $afsl_data['afsl_ord_id'] = $find_work_data->wor_id; //工单id
        $afsl_data['afsl_order_number'] = $find_work_data->wor_number; //工单号
        // $afsl_data['afsl_order_price'] = $find_work_data->ord_order_number;//订单号
        $afsl_data['afsl_actual_price'] = $find_work_data->wor_actual_price; //结算金额
        $afsl_data['afsl_reservation_time'] = $find_work_data->wor_appoint_time; //预约时间
        $afsl_data['afsl_client_type'] = $find_work_data->wor_type; //类型：1会员2客户单位
        $afsl_data['afsl_client_id'] = $find_work_data->wocl_client_id; //客户单位id，会员id
        if (!empty($request['remark'])) {
            $afsl_data['afsl_remark'] = $request['remark']; //售后备注
        }
        $afsl_data['afsl_create_id'] = $user_info->adm_id; //用户id
        $afsl_id = DB::table('wash_after_sale_list')->insertGetId($afsl_data);

        // 售后单客户信息
        $afsc_data['afsc_shop_id'] = $user_info->adm_shop_id;
        $afsc_data['afsc_afsl_id'] = $afsl_id;
        $afsc_data['afsc_client_id'] = $find_work_data->wocl_client_id;
        $afsc_data['afsc_channel_unit'] = $find_work_data->wocl_channel_unit;
        $afsc_data['afsc_name'] = $find_work_data->wocl_name;
        $afsc_data['afsc_phone'] = $find_work_data->wocl_phone;
        $afsc_data['afsc_car_num'] = $find_work_data->wocl_car_num;
        $afsc_data['afsc_province'] = $find_work_data->wocl_province;
        $afsc_data['afsc_city'] = $find_work_data->wocl_city;
        $afsc_data['afsc_county'] = $find_work_data->wocl_county;
        $afsc_data['afsc_address'] = $find_work_data->wocl_address;
        $afsc_id = DB::table('wash_after_sale_client')->insertGetId($afsc_data);

        $afsi_data = [];
        foreach ($goods_data as $key => $value) {
            $afsi_data[$key]['afsi_afsl_id'] = $afsl_id;
            $afsi_data[$key]['afsi_shop_id'] = $user_info->adm_shop_id;
            $afsi_data[$key]['afsi_sepr_id'] = $value->woit_sepr_id;
            $afsi_data[$key]['afsi_sepr_name'] = $value->woit_sepr_name;
            $afsi_data[$key]['afsi_part_state'] = $value->woit_part_state;
            $afsi_data[$key]['afsi_service_price'] = $value->woit_service_price;
            if (!empty($value->wogo_id)) {
                $afsi_data[$key]['afsi_goo_price'] = $value->wogo_goo_price;
                $afsi_data[$key]['afsi_goo_quantity'] = $value->wogo_goo_quantity;
                $afsi_data[$key]['afsi_goo_warranty_time'] = $value->wogo_goo_guarantee;
                $afsi_data[$key]['afsi_goo_id'] = $value->wogo_goo_id;
                $afsi_data[$key]['afsi_goo_name'] = $value->wogo_goo_name;
                $afsi_data[$key]['afsi_goo_goods_encode'] = $value->wogo_goo_goods_encode;
                $afsi_data[$key]['afsi_goo_type'] = $value->wogo_goo_type;
            }
        }
        if (!empty($afsi_data)) {
            $afsi_id = DB::table('wash_after_sale_items')->insert($afsi_data);
        } else {
            $afsi_id = true;
        }

        if ($afsl_id && $afsc_id && $afsi_id) {
            $return_data['afsl_id'] = $afsl_id;
            $return_data['afsl_after_number'] = $afsl_number;
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'转售后失败'];
        }
    }

    // 获取整车车型
    public static function getMeritPayCar($user_info, $request, $show_count = 10)
    {
        $search_data = $request;
        // 判断是否传入查询字段
        if (empty($field_columns)) {
            $field_columns = ['pema_id', 'pema_name', 'pema_grpr_id', 'pema_grle_id', 'pema_standard', 'pema_remark', 'grle_name', 'grpr_name', 'pema_state', 'pema_service_type_id', 'pema_service_type_name'];
        }
        // 绩效管理表
        $list_data = DB::table('wash_performance_manage as w')
            ->leftJoin('wash_grade_level as wgl', 'w.pema_grle_id', '=', 'wgl.grle_id')
            ->leftJoin('wash_grade_professional as wgp', 'w.pema_grpr_id', '=', 'wgp.grpr_id')
            ->where('pema_cid', $user_info->adm_cid)
            ->where('pema_shop_id', $user_info->adm_shop_id)
            ->where('pema_delete', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pema_name'])) {
                    $query->where('pema_name', 'like', '%' . $search_data['pema_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pema_state'])) {
                    $query->where('pema_state', $search_data['pema_state']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pema_type'])) {
                    $query->where('pema_type', $search_data['pema_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pema_grpr_id'])) {
                    $query->where('pema_grpr_id', $search_data['pema_grpr_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pema_grle_id'])) {
                    $query->where('pema_grle_id', $search_data['pema_grle_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pema_service_type_id'])) {
                    $query->where('pema_service_type_id', $search_data['pema_service_type_id']);
                }
            })
            ->select($field_columns)
            ->groupBy('pema_name')
            ->orderBy('pema_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    public static function getWorkHistory($user_info, $request)
    {
        $find_data = DB::table('work_order_history')
            ->where('wohi_primary_id', $request['wor_id'])
            ->where('wohi_type', 2)
            ->select('wohi_state_name', 'wohi_create_time', 'wohi_state')
            ->orderBy('wohi_state')
            ->get()->toArray();
        $wohi_state = array_column($find_data, 'wohi_state');
        $data[0] = ['wohi_state_name'=>'已创建','wohi_state'=>1];
        $data[1] = ['wohi_state_name'=>'待接单','wohi_state'=>2];
        $data[2] = ['wohi_state_name'=>'待验车','wohi_state'=>3];
        $data[3] = ['wohi_state_name'=>'施工中','wohi_state'=>4];
        $data[4] = ['wohi_state_name'=>'已完成','wohi_state'=>5];
        foreach ($data as $key => $value) {
            $wohi_create_time = '';
            foreach ($find_data as $key1 => $value1) {
                if ($value['wohi_state'] == $value1->wohi_state) {
                    $wohi_create_time = $value1->wohi_create_time;
                    break;
                } else {
                    $data[$key]['wohi_create_time'] = '';
                }
            }
            $data[$key]['wohi_create_time'] = $wohi_create_time;
            unset($wohi_create_time);
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 修改技师
    public static function editTechnician($user_info, $request)
    {
        $find_work = DB::table('work_order as wor')
            ->leftJoin('order as o', 'wor.wor_order_id', '=', 'o.ord_id')
            ->leftJoin('admin as a', 'a.adm_id', '=', 'wor.wor_service_adm_id')
            ->leftJoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->select('wor_number', 'wor_state', 'wor_delete', 'wor_pass', 'wor_appoint_time', 'wor_order_number', 'wor_remark', 'ord_create_time', 'wor_service_adm_id', 'adm_name', 'adm_phone', 'wocl_province', 'wocl_city', 'wocl_county', 'wocl_address', 'wor_order_id', 'wor_service_state', 'wor_address')
            ->first();
        if (empty($find_work)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单不存在，无法提交！', 'data'=>''];
        }
        if ($find_work->wor_delete != 1) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已经取消！', 'data'=>''];
        }
        if ($find_work->wor_pass == 4) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已经锁定，无法提交！', 'data'=>''];
        }
        $find_adm = DB::table('admin')
            ->where('adm_id', $request['adm_id'])
            ->first();
        if (!$find_adm) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'未查询到此技师', 'data'=>''];
        }
        if ($request['wotp_work_type'] == 1 && $find_work->wor_state > 5) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'已验件，不可更换验件技师', 'data'=>''];
        }
        if ($request['wotp_work_type'] == 2 && $find_work->wor_state > 7) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'已验件，不可更换维修技师', 'data'=>''];
        }
        if ($request['wotp_work_type'] == 3 && $find_work->wor_state > 9) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'已验件，不可更换还件技师', 'data'=>''];
        }
        $update_woch_data = DB::table('wash_work_technician_part')
            ->where('wotp_wor_id', $request['wor_id'])
            ->where('wotp_work_type', $request['wotp_work_type'])
            ->update(['wotp_service_adm_id'=>$request['adm_id'], 'wotp_service_adm_name'=>$find_adm->adm_name, 'wotp_service_adm_phone'=>$find_adm->adm_phone]);
        
        if ($update_woch_data) {
            return ['code'=>200, 'msg'=>'修改技师成功', 'data'=>'修改技师成功'];
        } else {
            return ['code'=>500, 'msg'=>'修改技师失败', 'data'=>'修改技师失败'];
        }
    }

    // 获取小红点
    public static function getMessage($user_info, $request)
    {
        $find_shop = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->select('shop_source_identify')
            ->first();
        // 查询智配订单状态对应的订单数量　du add 2023-6-9
        $wait_count = DB::table('order')
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_source', 5)
            ->where('ord_delete', 1) //
            ->where('ord_wor_state', 7) //
            ->where('ord_is_split', '<>', 3) //订单是否拆分，1是2否
            ->select(DB::raw('count(*) as count, ord_wor_state'))
            ->groupBy('ord_wor_state')
            ->get()->toArray();
        if (!empty($wait_count)) {
            $wait_number = $wait_count[0]->count;
        } else {
            $wait_number = 0;
        }

        // 查询订单状态对应的订单数量
        $state_count = DB::table('order')
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_classify', 2)
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('ord_wor_state', 1) //1未派工单
            ->where('ord_is_split', '<>', 3) //订单是否拆分，1是2否
            ->select(DB::raw('count(*) as count, ord_wor_state'))
            ->groupBy('ord_wor_state')
            ->get()->toArray();
        if (!empty($state_count)) {
            $order_number = $state_count[0]->count;
        } else {
            $order_number = 0;
        }
        $dis_state_count = DB::table('dispatch_bill')
            ->where('dego_cid', $user_info->adm_cid)
            ->where('dego_shop_id', $user_info->adm_shop_id)
            ->where('dego_type', 1)//1未出库2已出库3作废4锁定
            ->select(DB::raw('count(*) as count'))
            ->get()->toArray();
        if (!empty($dis_state_count)) {
            $dis_number = $dis_state_count[0]->count;
        } else {
            $dis_number = 0;
        }
        $rec_state_count = DB::table('recede_recycle')
            ->where('rec_cid', $user_info->adm_cid)
            ->where('rec_shop_id', $user_info->adm_shop_id)
            ->where('rec_state', 1)//回收状态 1.未回收 2.已回收
            ->select(DB::raw('count(*) as count'))
            ->get()->toArray();
        if (!empty($rec_state_count)) {
            $rec_number = $rec_state_count[0]->count;
        } else {
            $rec_number = 0;
        }
        $state_wor_count = DB::table('work_order')
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->where('wor_delete', 1)
            ->where('wor_classify', 2) //工单分类：1蓄电池2洗美店3易损件
            ->where('wor_collection_bill', 1) //是否代收账单：1正常工单2代收账单
            ->where('wor_service_state', 0)
            ->where('wor_state', 2) //1.新订单 2未派单 
            ->select(DB::raw('count(*) as count, wor_state'))
            ->groupBy('wor_state')
            ->get()->toArray();
        if (!empty($state_wor_count)) {
            $wor_number = $state_wor_count[0]->count;
        } else {
            $wor_number = 0;
        }
        $shop_source_identify = explode(',',$find_shop->shop_source_identify);
        if (in_array('5',$shop_source_identify) || $find_shop->shop_source_identify == '5') {
            $ord_wor_num = $wor_number + $order_number + $wait_number;
        } else {
            $ord_wor_num = $wor_number + $order_number;
        }

        $data[0]['num'] = $ord_wor_num;
        $data[0]['model'] = 'createWork';
        $data[1]['num'] = $order_number;
        $data[1]['model'] = 'order';
        $data[2]['num'] = $wor_number;
        $data[2]['model'] = 'work_order';
        $data[3]['num'] = $dis_number + $rec_number;
        $data[3]['model'] = 'shipments';
        $data[4]['num'] = $wait_number;
        $data[4]['model'] = 'wait_order';


        $wor_count3 = DB::table('wash_work_technician_part as a')
            ->leftJoin('work_order as b', 'b.wor_id', '=', 'a.wotp_wor_id')
            ->where('wotp_shop_id', $user_info->adm_shop_id)
            ->where('wor_service_adm_id', $user_info->adm_id)
            ->where('wotp_service_adm_id', $user_info->adm_id)
            ->where('wor_delete', 1)
            ->where('wor_classify', 2) //工单分类：1蓄电池2洗美店3易损件
            ->where('wor_collection_bill', 1) //是否代收账单：1正常工单2代收账单
            ->whereIn('wor_state', [3]) //1.新订单 2未派单 3待接单/已派单  5.已接单/待验车 6.已验车（显示开始施工按钮） 7施工中（提交施工按钮）   8.待审核/完成待审核
            ->select(DB::raw('count(*) as count, wor_state'))
            ->groupBy('wor_state')
            ->get()->toArray();
        if (!empty($wor_count3)) {
            $wor_number3 = $wor_count3[0]->count;
        } else {
            $wor_number3 = 0;
        }
        $data[5]['num'] = $wor_number3;
        $data[5]['model'] = 'receiveSubmit';
        // 账单数量
        $list_order = DB::table('sd_order_bill')
            ->whereIn('sdob_state', [0,1])
            ->where('sdob_shop_id',$user_info->adm_shop_id)
            ->select(DB::raw('count(*) as count, sdob_state'))
            ->groupBy('sdob_state')
            ->get()->toArray();
        if (empty($list_order)) {
            $data[6]['num'] = 0;
        } else {
            $data[6]['num'] = $list_order[0]->count;
        }
        $data[6]['model'] = 'listOrder';
        //区分是否为店长
        $adm_leave = DB::table('admin_shop_role')
            ->where('adm_id',$user_info->adm_id)
            ->where('shop_id',$user_info->adm_shop_id)
            ->value('adm_shop_leave');
        $list_button = getAppletListButton($request['api_token'], 40);
        $pri_id = array_column($list_button, 'pri_id');
        if($adm_leave == 1 || in_array(79,$pri_id)){
            $wor_count = DB::table('work_order');
        }else{
            $wor_count = DB::table('wash_work_technician_part as a')
                ->leftJoin('work_order as b', 'b.wor_id', '=', 'a.wotp_wor_id')
                ->where('wotp_service_adm_id', $user_info->adm_id);
        }
        $wor_count = $wor_count->where('wor_shop_id', $user_info->adm_shop_id)
            ->where('wor_delete', 1)
            ->where('wor_classify', 2) //工单分类：1蓄电池2洗美店3易损件
            ->where('wor_collection_bill', 1) //是否代收账单：1正常工单2代收账单
            ->whereIn('wor_state', [5,6,7]) //1.新订单 2未派单 3待接单/已派单  5.已接单/待验车 6.已验车（显示开始施工按钮） 7施工中（提交施工按钮）   8.待审核/完成待审核
            ->select(DB::raw('count(*) as count, wor_state'))
            ->groupBy('wor_state')
            ->get();
        foreach ($wor_count as $key => $value) {
            // if ($value->wor_state == 3) {
            //     $data[$key+5]['num'] = $value->count;
            //     $data[$key+5]['model'] = 'receiveSubmit';
            // }
            if ($value->wor_state == 5) {
                $data[$key+7]['num'] = $value->count;
                $data[$key+7]['model'] = 'validateCar';
            }
            if ($value->wor_state == 6) {
                $data[$key+7]['num'] = $value->count;
                $data[$key+7]['model'] = 'construction';
            }
            if ($value->wor_state == 7 || $value->wor_state == 8) {
                if (isset($data[$key+7]['num'])) {
                    $data[$key+7]['num'] += $value->count;
                } else {
                    $data[$key+7]['num'] = $value->count;
                }
                $data[$key+7]['model'] = 'submitConstruction';
            }
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 获取智配工单驳回数量
    public static function rejectCount($user_info)
    {
        // 查找属于当前登录技师的驳回的单子数量
        $wor_count = DB::table('work_order')
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->where('wor_service_adm_id', $user_info->adm_id)
            ->where('wor_work_type', 2)//工单类型：1门店工单2智配工单
            ->where('wor_other_audit', 3)//智配审核结果：1未审核2通过3驳回
            ->where('wor_delete', 1)//是否删除 1.正常工单 2.取消工单
            ->count();
        $data['count'] = $wor_count;
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 智配驳回订单-获取驳回订单数据
    public static function findResubmit($user_info, $request)
    {
        // 查找驳回原因
        $find_remark = DB::table('zptz_remarks')
            ->where('orre_shop_id', $user_info->adm_shop_id)
            ->where('orre_wor_id', $request['wor_id'])
            ->where('orre_module', '智配订单-驳回')
            ->orderby('orre_id', 'desc')
            ->select('orre_content')
            ->first();
        $orre_content = '';
        if ($find_remark) {
            $orre_content = $find_remark->orre_content;
        }
        // 查找技师提交的工单图片数据
        $find_all_wotp = DB::table('wash_work_technician_part')
            ->where('wotp_wor_id', $request['wor_id'])
            ->select('wotp_id', 'wotp_submit_state', 'wotp_service_data')
            ->get()->toArray();
        $wotp_service_data = [];
        foreach ($find_all_wotp as $key => $value) {
            if ($value->wotp_service_data) {
                $temp_service_data = json_decode($value->wotp_service_data, true);
                foreach ($temp_service_data as $temp_key => $temp_value) {
                    $temp_service_data[$temp_key]['primary_id'] = $value->wotp_id;
                }
                $wotp_service_data = array_merge($wotp_service_data, $temp_service_data);
                unset($temp_service_data);
            }
        }
        $data['remarks'] = $orre_content;
        $data['wotp_service_data'] = $wotp_service_data;
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 智配驳回订单-重新提交
    public static function resubmit($user_info, $request)
    {
        if (empty($request['wotp_service_data'])) {
            return ['code'=>500, 'msg'=>'请提交审核图片', 'data'=>'请提交审核图片'];
        }
        $find_work = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->select('wor_work_type', 'wor_service_adm_id', 'wor_order_id', 'wor_other_audit')
            ->first();
        if ($find_work->wor_other_audit != 3) {
            return ['code'=>500, 'msg'=>'当前工单已提交审核！', 'data'=>'当前工单已提交审核！'];
        }

        $request_service_data = json_decode($request['wotp_service_data'], true);
        $wotp_service_data = [];
        $find_image_upload = [];
        $image_key = 0;
        $server = config('apisystem.server_name') . '/';
        foreach ($request_service_data as $key => $value) {
            $temp_data = $value;
            unset($temp_data['primary_id']);
            $wotp_service_data[$value['primary_id']][] = $temp_data;
            unset($temp_data);

            // 同步智配订单图片数据
            if ($value['pic']) {
                foreach ($value['pic'] as $pic_key => $pic_value) {
                    $find_image_upload[$image_key]['imup_path'] = $server . $pic_value;
                    $find_image_upload[$image_key]['imup_image_name'] = $value['wotp_service_part'];
                    $image_key++;
                }
            }
        }

        DB::beginTransaction();
        foreach ($wotp_service_data as $primary_id => $value) {
            // 更新施工图片
            $edit_data['wotp_service_data'] = json_encode($value, JSON_UNESCAPED_UNICODE);
            $edit_data['wotp_update_time'] = date('Y-m-d H:i:s');
            $wopt_res = DB::table('wash_work_technician_part')
                ->where('wotp_id', $primary_id)
                ->update($edit_data);
            unset($edit_data);
            if (!$wopt_res) {
                DB::rollBack();
                return ['code'=>500, 'msg'=>'提交审核失败', 'data'=>'提交审核失败'];
            }
        }

        // 同步智配贴装提交信息
        if ($find_work->wor_work_type == 2) {
            $find_service_adm = DB::table('admin')
                ->where('adm_id', $find_work->wor_service_adm_id)
                ->select('adm_name', 'adm_phone')
                ->first();
            $order_data = DB::table('order')
                ->where('ord_id', $find_work->wor_order_id)
                ->select('ord_other_system_number')
                ->first();
            $find_image_upload = [];
            $image_key = 0;
            foreach ($wotp_service_data as $key => $value) {
                foreach ($value as $wotp_key => $wotp_value) {
                    if ($wotp_value['pic']) {
                        foreach ($wotp_value['pic'] as $pic_key => $pic_value) {
                            if ($pic_value) {
                                if (strpos($pic_value, 'http') === false) {
                                    $find_image_upload[$image_key]['imup_path'] = $server . $pic_value;
                                } else {
                                    $find_image_upload[$image_key]['imup_path'] = $pic_value;
                                }
                                $find_image_upload[$image_key]['imup_image_name'] = $wotp_value['wotp_service_part'];
                                $image_key++;
                            }
                        }
                    }
                }
            }
            if (empty($find_image_upload)) {
                DB::rollBack();
                return ['code'=>500, 'msg'=>'请上传图片', 'data'=>''];
            }

            $url = config('apiconnect.ZPTZ_URL') . '/index.php/api/supplychain/SupplyMz/installLine';
            $param['state'] = 5;
            $param['time'] = date('Y-m-d H:i:s');
            $param['ip'] = Request::getClientIp();
            $param['filePic'] = $find_image_upload; //图片
            $param['token'] = md5(md5($param['time'] . config('apiconnect.ZPTZ_TOKEN'))); //token
            $param['serial_number'] = $order_data->ord_other_system_number; //第三方工单号
            $param['install_name'] = $find_service_adm->adm_name;
            $param['install_phone'] = $find_service_adm->adm_phone;
            $param['app_achieve_time'] = date('Y-m-d H:i:s'); //完成提交时间
            $param_return = doPost($param, $url, 2);
            $param_return = json_decode($param_return, true);
            if ($param_return['code'] != 200) {
                DB::rollBack();
                return ['code'=>500, 'msg'=>'完成提交同步失败', 'data'=>''];
            }
        }

        // 更改工单审核状态
        $wor_data['wor_other_audit'] = 1;
        $wor_data['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_res = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->update($wor_data);
        if ($wor_res) {
            DB::commit();
            return ['code'=>200, 'msg'=>'提交审核成功', 'data'=>''];
        } else {
            DB::rollBack();
            return ['code'=>500, 'msg'=>'提交审核成功', 'data'=>''];
        }
    }

    public static function export($user_info, $search_data)
    {
        // 实际金额最小钱数
        if (!empty($search_data['min_price'])) {
            $search_data['min_price'] = $search_data['min_price'] * 100;
        }
        // 实际金额最大钱数
        if (!empty($search_data['max_price'])) {
            $search_data['max_price'] = $search_data['max_price'] * 100;
        }

        $data = DB::table('work_order as a')
            ->leftJoin('work_client as b', 'b.wocl_wor_id', '=', 'a.wor_id')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'a.wor_order_id')
            ->leftJoin('order as o', 'o.ord_id', '=', 'a.wor_order_id')
            ->where('wor_cid', $user_info->adm_cid)
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->where('wor_delete', 1)
            ->where('wor_classify', 2)
            ->where('wor_collection_bill', 1) //是否代收账单：1正常工单2代收账单
            ->where(function ($query) use ($search_data) { //订单号
                if (!empty($search_data['wor_order_number'])) {
                    $query->where('wor_order_number', 'like', '%' . $search_data['wor_order_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //工单号
                if (!empty($search_data['wor_number'])) {
                    $query->where('wor_number', 'like', '%' . $search_data['wor_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //姓名
                if (!empty($search_data['wocl_name'])) {
                    $query->where('wocl_name', 'like', '%' . $search_data['wocl_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //联系电话
                if (!empty($search_data['wocl_phone'])) {
                    $query->where('wocl_phone', 'like', '%' . $search_data['wocl_phone'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //姓名
                if (!empty($search_data['wocl_carowner_name'])) {
                    $query->where('wocl_carowner_name', 'like', '%' . $search_data['wocl_carowner_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //联系电话
                if (!empty($search_data['wocl_carowner_phone'])) {
                    $query->where('wocl_carowner_phone', 'like', '%' . $search_data['wocl_carowner_phone'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //车牌号
                if (!empty($search_data['wocl_car_num'])) {
                    $query->where('wocl_car_num', 'like', '%' . $search_data['wocl_car_num'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //订单类型1会员零售2合作商
                if (!empty($search_data['wor_type'])) {
                    $query->where('wor_type', $search_data['wor_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //工单施工组长
                if (!empty($search_data['wor_service_adm_id'])) {
                    $query->where('wor_service_adm_id', $search_data['wor_service_adm_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //1.新订单 2未派单 3待接单/已派单 4.未出发/已接单 5.预约/已预约 6.出发/已出发  7.抵达/抵达 8.待审核/完成待审核 9驳回/完成已驳回 10完成/完成已通过
                if (!empty($search_data['wor_state'])) {
                    $query->where('wor_state', $search_data['wor_state']);
                }
            })
            ->where(function ($query) use ($search_data) { //派单人
                if (!empty($search_data['wor_create_id'])) {
                    $query->where('wor_create_id', $search_data['wor_create_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //备注
                if (!empty($search_data['wor_remark'])) {
                    $query->where('wor_remark', 'like', '%' . $search_data['wor_remark'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //订单类型
                if (!empty($search_data['wor_service_type'])) {
                    $query->where('wor_service_type', $search_data['wor_service_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间/派单时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('wor_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('wor_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('wor_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //预约时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['appoint_time_start']) && !empty($search_data['appoint_time_end'])) {
                    $query->whereBetween('wor_appoint_time', [$search_data['appoint_time_start'], $search_data['appoint_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['appoint_time_start'])) {
                        $query->where('wor_appoint_time', '>=', $search_data['appoint_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['appoint_time_end'])) {
                            $query->where('wor_appoint_time', '<=', $search_data['appoint_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //实际金额区间搜索
                // 如果选择最小钱数并且选择最大钱数
                if (!empty($search_data['min_price']) && !empty($search_data['max_price'])) {
                    $query->whereBetween('wor_actual_price', [$search_data['min_price'], $search_data['max_price']]);
                } else {
                    // 如果选择最小钱数
                    if (!empty($search_data['min_price'])) {
                        $query->where('wor_actual_price', '>=', $search_data['min_price']);
                    } else {
                        // 如果选择最大钱数
                        if (!empty($search_data['max_price'])) {
                            $query->where('wor_actual_price', '<=', $search_data['max_price']);
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //客户id/会员id
                if (!empty($search_data['wocl_client_id'])) {
                    $query->where('wocl_client_id', $search_data['wocl_client_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //施工地址
                if (!empty($search_data['wor_address_type']) && !empty($search_data['wor_address_id'])) {
                    $query->where('wor_address_type', $search_data['wor_address_type'])
                        ->where('wor_address_id', $search_data['wor_address_id']);
                }
            })
            ->select('wor_id', 'wor_number', 'wor_create_id', 'wor_order_number', 'wor_goo_amount', 'wor_actual_price', 'wor_account_state', 'wor_type', 'wor_state', 'wor_delete', 'wocl_channel_unit', 'wocl_name', 'wocl_phone', 'wocl_car_num', 'wor_remark', 'wocl_client_id', 'wor_appoint_time', 'wocl_appoint_remark', 'wocl_car_brand_series', 'wocl_pick_up_car_time', 'wor_create_time', 'wor_province', 'wor_city', 'wor_county', 'wor_address', 'wocl_carowner_name', 'wocl_carowner_phone', 'wor_explain', 'wocl_bus_name', 'wor_address_id', 'wor_address_type', 'wor_shop_id', 'wor_service_adm_id', 'wocl_carbrse_type', 'wor_service_state', 'orcl_sales_adm_id', 'wor_achieve_time', 'ord_create_id')
            ->orderBy('wor_id', 'desc')
            ->get()->toArray();
        if (!empty($data)) {
            $wor_id = array_column($data, 'wor_id'); //工单id
            $wor_create_id = array_unique(array_column($data, 'wor_create_id')); //录单人id
            $ord_create_id = array_unique(array_column($data, 'ord_create_id')); //开单人id
            $orcl_sales_adm_id = array_unique(array_column($data, 'orcl_sales_adm_id')); //销售人id


            $service_adm_id = array_filter(array_unique(array_column($data, 'wor_service_adm_id'))); //选的技师id
            $orcl_sales_adm_id = array_filter(array_unique(array_column($data, 'orcl_sales_adm_id'))); //销售人id
            $adm_id_merge = array_merge($wor_create_id, $service_adm_id);
            $adm_id_merge = array_merge($adm_id_merge, $ord_create_id);
            $adm_id_merge = array_merge($adm_id_merge, $orcl_sales_adm_id);
            // 查询录单人信息
            $find_adm = DB::table('admin')
                ->whereIn('adm_id', $adm_id_merge)
                ->pluck('adm_name', 'adm_id')->toArray();
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            $new_data = [];
            $i = 0;
            foreach ($data as $key => $value) {
                $new_data[$i]['wor_number'] = $value['wor_number'];
                if ($value['ord_create_id'] && isset($find_adm[$value['ord_create_id']])) {
                    $new_data[$i]['ord_create_name'] = $find_adm[$value['ord_create_id']];
                } else {
                    $new_data[$i]['ord_create_name'] = '';
                }
                // if ($value['wor_create_id']) {
                //     $new_data[$i]['wor_create_name'] = $find_adm[$value['wor_create_id']];
                // } else {
                //     $new_data[$i]['wor_create_name'] = '';
                // }
                if ($value['wor_state'] == 2) {
                    $new_data[$i]['wor_state'] = '退回待派单';
                } elseif ($value['wor_state'] == 3) {
                    $new_data[$i]['wor_state'] = '待接单';
                } elseif ($value['wor_state'] == 5) {
                    $new_data[$i]['wor_state'] = '待验车';
                } elseif ($value['wor_state'] == 6) {
                    $new_data[$i]['wor_state'] = '待施工';
                } elseif ($value['wor_state'] == 7) {
                    $new_data[$i]['wor_state'] = '施工中';
                } elseif ($value['wor_state'] == 8) {
                    $new_data[$i]['wor_state'] = '完成待核算';
                } elseif ($value['wor_state'] == 10) {
                    $new_data[$i]['wor_state'] = '核算完成';
                }
                $new_data[$i]['wor_create_time'] = $value['wor_create_time'];
                $new_data[$i]['orcl_sales_adm_name'] = '';
                if ($value['orcl_sales_adm_id'] && isset($find_adm[$value['orcl_sales_adm_id']])) {//销售人
                    $new_data[$i]['orcl_sales_adm_name'] = $find_adm[$value['orcl_sales_adm_id']];
                }
                $new_data[$i]['wor_explain'] = $value['wor_explain'];//施工说明
                $new_data[$i]['wor_address'] = $value['wor_address'];//施工门店
                $new_data[$i]['wor_appoint_time'] = $value['wor_appoint_time'];
                // 施工地址
                if ($value['wor_address_type'] == 1) {//门店
                    $find_address = DB::table('shop')
                        ->where('shop_id', $value['wor_address_id'])
                        ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                        ->first();
                    $new_data[$i]['wor_address_detail']  = !empty($find_address) ?  $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address : '';
                } elseif ($value['wor_address_type'] == 2) {
                    $find_address = DB::table('business_client')
                        ->where('bucl_id', $value['wor_address_id'])
                        ->select('bucl_id', 'bucl_name', 'bucl_province', 'bucl_city', 'bucl_address', 'bucl_county')
                        ->first();
                    $new_data[$i]['wor_address_detail']  = !empty($find_address) ?  $find_address->bucl_province.$find_address->bucl_city.$find_address->bucl_county.$find_address->bucl_address : '';
                } else {
                    $find_address = DB::table('shop')
                        ->where('shop_id', $value['wor_shop_id'])
                        ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                        ->first();
                    $new_data[$i]['wor_address_detail']  = !empty($find_address) ?  $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address : '';
                }
                $new_data[$i]['wocl_name'] = $value['wocl_name'];
                $new_data[$i]['wocl_phone'] = $value['wocl_phone'];
                $new_data[$i]['wor_type'] = ($value['wor_type']==1) ? '个人会员':'企业会员';
                $new_data[$i]['wocl_carowner_name'] = $value['wocl_carowner_name'];
                $new_data[$i]['wocl_carowner_phone'] = $value['wocl_carowner_phone'];
                $new_data[$i]['wocl_car_brand_series'] = $value['wocl_car_brand_series'];
                // 查询商品、项目信息
                $work_goods = DB::table('work_good as wg')
                    ->leftJoin('goods as g', 'g.goo_id', '=', 'wg.wogo_goo_id')
                    ->where('wogo_wor_id', $value['wor_id'])
                    ->where('wogo_goo_type', 1)
                    ->select('wogo_id', 'wogo_wor_id', 'wogo_goo_id', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_goo_amount', 'wogo_goo_price', 'wogo_goo_guarantee', 'wogo_goo_type', 'wogo_state','wogo_goo_unit', 'wogo_goo_unta_id', 'goo_unit_conversion', 'wogo_recycle_quantity', 'wogo_goo_waste_number', 'wogo_new_goo_amount')
                    ->get()->toArray();
                $work_goods = json_decode(json_encode($work_goods,true),true);
                for ($j=0; $j < 5; $j++) {
                    // 产品一
                    $new_data[$i]['wogo_goo_name'.$j.''] = isset($work_goods[$j]) ? $work_goods[$j]['wogo_goo_name'] : '';
                    // if (isset($work_goods[$j]) && $work_goods[$j]['wogo_goo_unta_id'] == 1) {
                    //     $new_data[$i]['wogo_goo_amount'.$j.''] = isset($work_goods[$j]) ? $work_goods[$j]['wogo_goo_amount'].$work_goods[$j]['wogo_goo_unit'].'('.$work_goods[$j]['wogo_goo_amount']*$work_goods[$j]['goo_unit_conversion'].'米)' : '';//数量
                    // } else {
                    // }
                    $new_data[$i]['wogo_goo_amount'.$j.''] = isset($work_goods[$j]) ? $work_goods[$j]['wogo_goo_amount'].$work_goods[$j]['wogo_goo_unit'] : '';//数量

                    // if (isset($work_goods[$j]) && $work_goods[$j]['wogo_goo_unta_id'] == 1) {
                    //     $new_data[$i]['wogo_recycle_quantity'.$j.''] = isset($work_goods[$j]) ? $work_goods[$j]['wogo_recycle_quantity'].'米' : '';//退回数量
                    // } else {
                    // }
                    $new_data[$i]['wogo_recycle_quantity'.$j.''] = isset($work_goods[$j]) ? $work_goods[$j]['wogo_recycle_quantity'].$work_goods[$j]['wogo_goo_unit'] : '';//退回数量

                    // if (isset($work_goods[$j]) && $work_goods[$j]['wogo_goo_unta_id'] == 1) {
                    //     $new_data[$i]['wogo_goo_waste_number'.$j.''] = isset($work_goods[$j]) ? $work_goods[$j]['wogo_goo_waste_number'].'米' : '';//
                    // } else {
                    // }
                    $new_data[$i]['wogo_goo_waste_number'.$j.''] = isset($work_goods[$j]) ? $work_goods[$j]['wogo_goo_waste_number'].$work_goods[$j]['wogo_goo_unit'] : '';//废料
                    // if (isset($work_goods[$j]) && $work_goods[$j]['wogo_goo_unta_id'] == 1) {
                    //     $new_data[$i]['wogo_new_goo_amount'.$j.''] = isset($work_goods[$j]) ? $work_goods[$j]['wogo_new_goo_amount'].'米' : '';//数量
                    // } else {
                    // }
                    $new_data[$i]['wogo_new_goo_amount'.$j.''] = isset($work_goods[$j]) ? $work_goods[$j]['wogo_new_goo_amount'].$work_goods[$j]['wogo_goo_unit'] : '';//数量
                }

                // 查询商品、项目信息
                $work_goods_data = DB::table('work_good as wg')
                    ->where('wogo_wor_id', $value['wor_id'])
                    ->where('wogo_goo_type', 2)
                    ->select('wogo_id', 'wogo_wor_id', 'wogo_goo_id', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_goo_amount', 'wogo_goo_price', 'wogo_goo_guarantee', 'wogo_goo_type', 'wogo_state','wogo_goo_unit', 'wogo_goo_unta_id')
                    ->get()->toArray();
                $work_goods_data = json_decode(json_encode($work_goods_data,true),true);
                for ($k=5; $k < 10; $k++) {
                    $new_data[$i]['wogo_goo_name'.$k.''] = isset($work_goods_data[$k-5]['wogo_goo_name']) ?  $work_goods_data[$k-5]['wogo_goo_name'] : '';
                }

                $new_data[$i]['wor_achieve_time'] = $value['wor_achieve_time'];
                $wash_res = DB::table('wash_work_technician_part')
                    ->where('wotp_wor_id', $value['wor_id'])
                    ->where('wotp_service_adm_id', $value['wor_service_adm_id'])
                    ->select('wotp_service_quality')
                    ->first();
                if (!empty($wash_res->wotp_service_quality)) {
                    $wotp_service_quality = json_decode($wash_res->wotp_service_quality, true);
                    $new_data[$i]['wor_time'] = '';//施工用时
                    if(isset($wotp_service_quality[0]['construction_data']['construction_duration_time'])){
                        $new_data[$i]['wor_time'] = $wotp_service_quality[0]['construction_data']['construction_duration_time'];//施工用时
                    }
                } else {
                    $new_data[$i]['wor_time'] = '';//施工用时
                }
                // 查看工单技师施工检测信息
                $leader_data = DB::table('wash_work_technician_part')
                    ->where('wotp_wor_id', $value['wor_id'])
                    ->where('wotp_service_adm_id', $value['wor_service_adm_id'])
                    ->select('wotp_id', 'wotp_service_adm_id', 'wotp_grle_id', 'wotp_grle_name', 'wotp_grpr_id', 'wotp_grpr_name', 'wotp_service_adm_name', 'wotp_service_adm_phone', 'wotp_total_price')
                    ->first();

                $new_data[$i]['leader_name'] = !empty($leader_data) ? $leader_data->wotp_service_adm_name : '';
                $new_data[$i]['leader_lepr'] = !empty($leader_data)? $leader_data->wotp_grpr_name.'-'.$leader_data->wotp_grle_name : '';
                $new_data[$i]['jixiao'] = !empty($leader_data) ? $leader_data->wotp_total_price/100 : '';

                // 查看工单技师施工检测信息
                $team_data = DB::table('wash_work_technician_part')
                    ->where('wotp_wor_id', $value['wor_id'])
                    ->where('wotp_service_adm_id', '!=', $value['wor_service_adm_id'])
                    ->select('wotp_id', 'wotp_service_adm_id', 'wotp_grle_id', 'wotp_grle_name', 'wotp_grpr_id', 'wotp_grpr_name', 'wotp_service_adm_name', 'wotp_service_adm_phone', 'wotp_total_price')
                    ->get()->toArray();
                for ($n=0; $n < 5; $n++) {
                    $new_data[$i]['team_name'.$n.''] = isset($team_data[$n]) ? $team_data[$n]->wotp_service_adm_name : '';
                    $new_data[$i]['team_lepr'.$n.''] = isset($team_data[$n]) ? $team_data[$n]->wotp_grpr_name.'-'.$team_data[$n]->wotp_grle_name : '';
                    $new_data[$i]['team_jixiao'.$n.''] = isset($team_data[$n]) ? $team_data[$n]->wotp_total_price/100 : '';
                }
                $i++;
            }
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据'];
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        $streamFileRand = '工单列表' . time() . rand(10000, 99999) . '.xls'; //
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '工单列表';
        $where['field_name'] = [
            '基本信息', '会员信息', '车主信息', '产品1', '产品2', '产品3', '产品4', '产品5', '服务信息',
            '施工信息', '组长', '组员1', '组员2', '组员3', '组员4', '组员5'];
        $where1['field_name'] = [
            '工单单号', '订单开单人', '工单状态', '创建时间', '销售人', '施工说明', '门店名称', '预约时间', '施工地址',
            '会员姓名', '会员电话', '会员类型', '车主姓名', '车主电话', '品牌车系', '名称', '数量', '余料', '废料', '用料', '名称', '数量', '余料', '废料', '用料', '名称', '数量', '余料', '废料', '用料', '名称', '数量', '余料', '废料', '用料', '名称', '数量', '余料', '废料', '用料', '服务类型1', '服务类型2', '服务类型3', '服务类型4', '服务类型5', '施工结束时间', '施工用时', '姓名', '职级', '绩效', '姓名', '职级', '绩效', '姓名', '职级', '绩效', '姓名', '职级', '绩效', '姓名', '职级', '绩效', '姓名', '职级', '绩效'
        ];
        // 调用导出的公共方法
        export::newpublicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $where1,    //sheet名及其每一行的标题
            $new_data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($pathName)) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'导出失败'];
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取订单状态
     * @param string $type 请求类型
     * @retrun /multitype:array
     * @author li 2023-07-18 031 上午 11:31:42
     * |---------------------------------------------------------------------------------
     */
    public static function getOrderState($type=false){
        $data = [['type'=>1,'name'=>'待派单'],['type'=>2,'name'=>'服务中'],['type'=>4,'name'=>'已完成'],['type'=>3,'name'=>'微信'],['type'=>4,'name'=>'银行卡'],['type'=>5,'name'=>'会员卡'],['type'=>7,'name'=>'待领取'],['type'=>18,'name'=>'待评价'],['type'=>20,'name'=>'已完成']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }

    /**|---------------------------------------------------------------------------------
     * @name 左侧列表
     * @param string $type 请求类型
     * @retrun /multitype:array
     * @author li 2023-07-18 031 上午 11:31:42
     * |---------------------------------------------------------------------------------
     */
    public static function getLeft($user_info,$request){
        $find_worker = DB::table('wash_work_technician_part as w')
            ->leftJoin('admin', 'w.wotp_service_adm_id', '=', 'adm_id')
            ->where('wotp_wor_id', $request['wor_id'])
            ->where('wotp_work_type', 2)
            ->where(function ($query) use ($request) { //技师id
                if (!empty($request['adm_id'])) {
                    $query->where('wotp_service_adm_id', $request['adm_id']);
                }
            })
            ->select('wotp_service_adm_id', 'adm_name', 'wotp_submit_state', 'wotp_work_type')
            ->get()->toArray();

        if (empty($find_worker)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'查无数据', 'data'=>''];
        }
        $find_shop = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->select('shop_versions', 'shop_source_identify')
            ->first();
        if ($find_shop->shop_source_identify == '5') {
            $wor_quality = 1;
            $update_data['wor_quality'] = 1;
            $update_data['wor_update_time'] = date('Y-m-d H:i:s');
            $update_data_res = DB::table('work_order')
                ->where('wor_id', $request['wor_id'])
                ->update($update_data);
            // $left_data[] = ['id'=>1,'name'=>'质检信息','have_pri'=>2];
            $left_data[] = ['id'=>2,'name'=>'完工信息','have_pri'=>1];
            // $left_data[] = ['id'=>3,'name'=>'余料废料','have_pri'=>2];
        } else {
            $wor_quality = DB::table('work_order')
                ->where('wor_id', $request['wor_id'])
                ->value('wor_quality');
            // $left_data[] = ['id'=>1,'name'=>'质检信息','have_pri'=>1];
            $left_data[] = ['id'=>2,'name'=>'完工信息','have_pri'=>1];
            // $left_data[] = ['id'=>3,'name'=>'余料废料','have_pri'=>1];
        }
        $wor_service_adm_id = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->value('wor_service_adm_id');
        $new_find_worker = [];
        $new_worker = [];
        foreach ($find_worker as $key => $value) {
            switch ($value->wotp_work_type) {
                case '1':
                    $worker_type = '取件';
                    break;
                case '2':
                    $worker_type = '维修';
                    break;
                case '3':
                    $worker_type = '还件';
                    break;
                default:
                    $worker_type = '取件';
                    break;
            }
            $find_worker[$key]->adm_name = $value->adm_name.'('.$worker_type.')';
        }
        
        $data['left_data'] = $left_data;
        $data['wor_service_adm_id'] = $wor_service_adm_id;
        $data['wor_quality'] = $wor_quality;
        $data['find_worker'] = $find_worker;
        $data['find_shop'] = $find_shop;
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    /**
     * 完工数据查询
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-15
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function completionInfo($user_info, $request)
    {
        $find_worker = DB::table('wash_work_technician_part as w')
            ->leftJoin('admin', 'w.wotp_service_adm_id', '=', 'adm_id')
            ->where('wotp_wor_id', $request['wor_id'])
            ->where('wotp_work_type', 2)
            ->where(function ($query) use ($request) { //技师id
                if (!empty($request['adm_id'])) {
                    $query->where('wotp_service_adm_id', $request['adm_id']);
                }
            })
            ->select('wotp_service_adm_id', 'adm_name', 'wotp_work_type')
            ->get()->toArray();

        if (empty($find_worker)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'查无数据', 'data'=>''];
        }

        $wor_service_adm_id = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->value('wor_service_adm_id');
        if (empty($request['adm_id'])) {
            foreach ($find_worker as $key => $value) {
                $label = [];
                $image_data = [];
                $config_image = [];
                $explain = '';
                $return_data[$key]['adm_id'] = $value->wotp_service_adm_id;
                $return_data[$key]['adm_name'] = $value->adm_name;
                // if ($wor_service_adm_id == $value->wotp_service_adm_id) {
                //     $return_data[$key]['adm_name'] = $value->adm_name.'(组长)';
                // }
                $completion_info = DB::table('completion_info')
                    ->where('coin_wor_id', $request['wor_id'])
                    ->where('coin_adm_id', $value->wotp_service_adm_id)
                    // ->where('coin_must', 1)
                    ->select('coin_data_id', 'coin_type', 'coin_id', 'coin_data', 'coin_name', 'coin_must')
                    ->get()->toArray();
                if ($wor_service_adm_id == $value->wotp_service_adm_id) {
                    $j = 0;
                    foreach ($completion_info as $key4 => $value4) {
                        if ($value4->coin_type == 3 && $value4->coin_data) {//配置的图片
                            $config_image[$j]['coin_id'] = $value4->coin_id;
                            $config_image[$j]['coin_data'] = $value4->coin_data;
                            $config_image[$j]['coin_name'] = $value4->coin_name;
                            $config_image[$j]['coin_must'] = $value4->coin_must;
                            $config_image[$j]['coin_image_type'] = DB::table('image_config')
                                ->where('imco_id', $value4->coin_data_id)
                                ->value('imco_image_type');
                            $j++;
                        }
                        if ($value4->coin_type == 1) {
                            $label[] = $value4->coin_data;
                        }
                        if ($value4->coin_type == 2) {
                            $image_data[] = $value4->coin_data;
                        }
                        if ($value4->coin_type == 4) {
                            $explain = $value4->coin_data;
                        }
                    }
                } else {
                    foreach ($completion_info as $key4 => $value4) {
                        if ($value4->coin_type == 1) {
                            $label[] = $value4->coin_data;
                        }
                        if ($value4->coin_type == 2) {
                            $image_data[] = $value4->coin_data;
                        }
                        if ($value4->coin_type == 4) {
                            $explain = $value4->coin_data;
                        }
                    }
                }
                $return_data[$key]['explain'] = $explain;
                $return_data[$key]['image_data'] = $image_data;
                $return_data[$key]['config_image'] = $config_image;
                $return_data[$key]['label'] = $label;
            }
            $data_one = [];
            $data_two = [];
            foreach ($return_data as $k1 => $v1) {
                if ($wor_service_adm_id == $v1['adm_id']) {
                    $data_one[] = $v1;
                } else {
                    $data_two[] = $v1;
                }
            }
            $return_data = array_merge($data_one, $data_two);
            $data['list'] = $return_data;
            return ['code'=>200, 'msg'=>'success', 'data'=>$data];
        }

        $type = DB::table('auto_parts')
            ->where('enabled', 1)
            ->select('type', 'type_id')
            ->groupBy('type')
            ->get()->toArray();
        $new_data = [];
        foreach ($type as $key1 => $value1) {
            $new_data[$key1]['type'] = $value1->type;
            $new_data[$key1]['type_id'] = $value1->type_id;
            $new_data[$key1]['type_num'] = 0;
            $new_data[$key1]['data'] = DB::table('auto_parts')
                ->where('enabled', 1)
                ->where('type', $value1->type)
                ->select('title', 'id', 'type')
                ->get()->toArray();
        }

        $return_data = [];
        foreach ($find_worker as $key => $value) {
            $image_data = [];
            $config_image = [];
            $return_data[$key]['adm_id'] = $value->wotp_service_adm_id;
            $return_data[$key]['adm_name'] = $value->adm_name;
            switch ($value->wotp_work_type) {
                case '1':
                    $worker_type = '取件';
                    break;
                case '2':
                    $worker_type = '维修';
                    break;
                case '3':
                    $worker_type = '还件';
                    break;
                default:
                    $worker_type = '取件';
                    break;
            }
            
            if ($wor_service_adm_id == $value->wotp_service_adm_id) {
                $return_data[$key]['adm_name'] = $value->adm_name.'('.$worker_type.')';
            }
            $num = 0;
            $com_data = $new_data;
            $completion_info = DB::table('completion_info')
                ->where('coin_wor_id', $request['wor_id'])
                ->where('coin_adm_id', $value->wotp_service_adm_id)
                // ->where('coin_must', 1)
                ->select('coin_data_id', 'coin_type', 'coin_id', 'coin_data', 'coin_name', 'coin_must')
                ->get()->toArray();

            $label = [];
            foreach ($com_data as $key1 => $value1) {
                foreach ($value1['data'] as $k => $v) {
                    foreach ($completion_info as $key2 => $value2) {
                        if ($value2->coin_data_id == $v->id && $value2->coin_type == 1) {
                            $com_data[$key1]['data'][$k]->vaca_select = 1;
                            $com_data[$key1]['data'][$k]->coin_id = $value2->coin_id;
                            $label[] = $value2->coin_data;
                            $com_data[$key1]['type_num']++;
                        }
                    }
                }
            }
            $i = 0;
            foreach ($completion_info as $key3 => $value3) {
                if ($value3->coin_type == 2) {
                    $image_data[$i]['coin_id'] = $value3->coin_id;
                    $image_data[$i]['coin_data'] = $value3->coin_data;
                    $i++;
                }
            }

            if ($wor_service_adm_id == $value->wotp_service_adm_id) {
                $j = 0;
                foreach ($completion_info as $key4 => $value4) {
                    if ($value4->coin_type == 3) {
                        $config_image[$j]['coin_id'] = $value4->coin_id;
                        $config_image[$j]['coin_data'] = $value4->coin_data;
                        $config_image[$j]['coin_name'] = $value4->coin_name;
                        $config_image[$j]['coin_must'] = $value4->coin_must;
                        $config_image[$j]['coin_image_type'] = DB::table('image_config')
                            ->where('imco_id', $value4->coin_data_id)
                            ->value('imco_image_type');
                        $j++;
                    }
                }
            }
            $explain = '';
            foreach ($completion_info as $key5 => $value5) {
                if ($value5->coin_type == 4) {
                    $explain = $value5->coin_data;
                }
            }
            if (empty($request['adm_id'])) {
                $return_data[$key]['data'] = $label;
            } else {
                $return_data[$key]['data'] = $com_data;
            }
            $return_data[$key]['image_data'] = $image_data;
            $return_data[$key]['config_image'] = $config_image;
            $return_data[$key]['explain'] = $explain;
        }
        $data['list'] = $return_data;
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    /**
     * 完工数据实时存储
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-15
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function completion($user_info, $request)
    {
        $find_work = DB::table('work_order as w')
            ->leftJoin('work_client as wc', 'wc.wocl_wor_id', '=', 'w.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_order_id', 'wor_order_number', 'wocl_check_car_state', 'wocl_check_car_lock', 'wocl_phone', 'wocl_check_car_lockadmid', 'wocl_car_num', 'wor_state')
            ->first();

        if (empty($find_work)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前工单不存在', 'data'=>'当前工单不存在'];
        }
        if ($find_work->wor_state >= 10) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已完成', 'data'=>'当前工单已完成'];
        }

        if ($request['coin_type'] == 3) {//配置图片
            $add_data['coin_update_id'] = $user_info->adm_id;
            $add_data['coin_data'] = $request['coin_data'];
            $add_data['coin_update_time'] = date('Y-m-d H:i:s');
            $add_res = DB::table('completion_info')->where('coin_id', $request['coin_id'])->update($add_data);
            $data_id = $request['coin_id'];
        } elseif ($request['coin_type'] == 4) {//补充说明
            $add_data['coin_shop_id'] = $user_info->adm_shop_id;
            $add_data['coin_wor_id'] = $request['wor_id'];
            $add_data['coin_adm_id'] = $request['adm_id'];
            $add_data['coin_type'] = $request['coin_type'];
            $add_data['coin_data'] = $request['coin_data'];
            $add_data['coin_create_id'] = $user_info->adm_id;
            $add_data['coin_update_id'] = $user_info->adm_id;
            $add_data['coin_create_time'] = date('Y-m-d H:i:s');
            $find_explain = DB::table('completion_info')
                ->where('coin_type', 4)
                ->where('coin_wor_id', $request['wor_id'])
                ->value('coin_id');
            if ($find_explain) {
                $update_data['coin_data'] = $request['coin_data'];
                $update_data['coin_update_time'] = date('Y-m-d H:i:s');
                $add_res = DB::table('completion_info')
                    ->where('coin_id', $find_explain)
                    ->update($update_data);
                $data_id = $find_explain;
            } else {
                $add_res = DB::table('completion_info')->insertGetId($add_data);
                $data_id = $add_res;
            }
        } else {
            $add_data['coin_shop_id'] = $user_info->adm_shop_id;
            $add_data['coin_wor_id'] = $request['wor_id'];
            $add_data['coin_adm_id'] = $user_info->adm_id;
            $add_data['coin_type'] = $request['coin_type'];
            $add_data['coin_data'] = $request['coin_data'];
            if ($request['coin_type'] == 1) {//快捷部位
                if (empty($request['coin_first_data']) || empty($request['coin_first_data_id']) || empty($request['coin_data_id'])) {
                    return ['code'=>500, 'msg'=>'数据错误，请上传部位', 'data'=>''];
                }
                $add_data['coin_data_id'] = $request['coin_data_id'];
                $add_data['coin_first_data_id'] = $request['coin_first_data_id'];
                $add_data['coin_first_data'] = $request['coin_first_data'];
            }
            $add_data['coin_create_id'] = $user_info->adm_id;
            $add_data['coin_update_id'] = $user_info->adm_id;
            $add_data['coin_create_time'] = date('Y-m-d H:i:s');
            $add_res = DB::table('completion_info')->insertGetId($add_data);
            $data_id = $add_res;
        }

        if ($add_res) {
            return ['code'=>200, 'msg'=>'保存成功', 'data'=>$data_id];
        } else {
            return ['code'=>500, 'msg'=>'保存失败', 'data'=>''];
        }
    }

    /**
     * 完工数据实时存储-取消
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-15
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function cancelCom($user_info, $request)
    {
        $find_work = DB::table('work_order as w')
            ->leftJoin('work_client as wc', 'wc.wocl_wor_id', '=', 'w.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_order_id', 'wor_order_number', 'wocl_check_car_state', 'wocl_check_car_lock', 'wocl_phone', 'wocl_check_car_lockadmid', 'wocl_car_num', 'wor_state')
            ->first();

        if (empty($find_work)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前工单不存在', 'data'=>'当前工单不存在'];
        }
        if ($find_work->wor_state >= 10) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已完成', 'data'=>'当前工单已完成'];
        }
        if ($request['coin_type'] == 3) {//配置图片
            $add_data['coin_update_id'] = $user_info->adm_id;
            $add_data['coin_data'] = '';
            $add_data['coin_update_time'] = date('Y-m-d H:i:s');
            $add_res = DB::table('completion_info')->where('coin_id', $request['coin_id'])->update($add_data);
        } else {
            $add_res = DB::table('completion_info')
                ->where('coin_id', $request['coin_id'])->delete();
        }

        if ($add_res) {
            return ['code'=>200, 'msg'=>'删除成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'删除失败', 'data'=>''];
        }
    }

    /**
     * 质检数据查询
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-15
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function qualityInfo($user_info, $request)
    {
        $find_worker = DB::table('wash_work_technician_part as w')
            ->leftJoin('admin', 'w.wotp_service_adm_id', '=', 'adm_id')
            ->where('wotp_wor_id', $request['wor_id'])
            ->where(function ($query) use ($request) { //仓库名称
                if (!empty($request['adm_id'])) {
                    $query->where('wotp_service_adm_id', $request['adm_id']);
                }
            })
            ->select('wotp_service_adm_id', 'adm_name', 'wotp_submit_state')
            ->get()->toArray();

        if (empty($find_worker)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'查无数据', 'data'=>''];
        }
        $wor_service_adm_id = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->value('wor_service_adm_id');
        $wor_quality = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->value('wor_quality');
        if (empty($request['adm_id'])) {
            foreach ($find_worker as $key => $value) {
                $return_data[$key]['adm_id'] = $value->wotp_service_adm_id;
                $return_data[$key]['adm_name'] = $value->adm_name;
                if ($wor_service_adm_id == $value->wotp_service_adm_id) {
                    $return_data[$key]['adm_name'] = $value->adm_name.'(组长)';
                }
                $return_data[$key]['label'] = DB::table('quality_data')
                    ->where('quda_wor_id', $request['wor_id'])
                    ->where('quda_adm_id', $value->wotp_service_adm_id)
                    ->where('quda_delete', 2)
                    ->where('quda_type', 1)
                    ->select('quda_qurp_data', 'quda_id')
                    ->get()->toArray();
                $return_data[$key]['image'] = DB::table('quality_data')
                    ->where('quda_wor_id', $request['wor_id'])
                    ->where('quda_adm_id', $value->wotp_service_adm_id)
                    ->where('quda_type', 2)
                    ->select('quda_qurp_data', 'quda_id', 'quda_delete')
                    ->get()->toArray();
                $return_data[$key]['explain'] = DB::table('quality_data')
                    ->where('quda_wor_id', $request['wor_id'])
                    ->where('quda_adm_id', $value->wotp_service_adm_id)
                    ->where('quda_type', 4)
                    ->value('quda_qurp_data');
            }
            $data_one = [];
            $data_two = [];
            foreach ($return_data as $k1 => $v1) {
                if ($wor_service_adm_id == $v1['adm_id']) {
                    $data_one[] = $v1;
                } else {
                    $data_two[] = $v1;
                }
            }
            $return_data = array_merge($data_one, $data_two);
            $data['wor_quality'] = $wor_quality;
            $data['list'] = $return_data;
            return ['code'=>200, 'msg'=>'success', 'data'=>$data];
        }
        $new_data = DB::table('wash_quality_reward_punishment')
            ->where('qurp_shop_id', $user_info->adm_shop_id)
            ->where('qurp_type', 1)
            ->where('qurp_state', 1)
            ->select('qurp_id', 'qurp_name')
            ->get()->toArray();
        $return_data = [];
        foreach ($find_worker as $key => $value) {
            $image_data = [];
            $return_data[$key]['adm_id'] = $value->wotp_service_adm_id;
            $return_data[$key]['adm_name'] = $value->adm_name;
            $return_data[$key]['wor_quality'] = $value->wotp_submit_state;
            if ($wor_service_adm_id == $value->wotp_service_adm_id) {
                $return_data[$key]['adm_name'] = $value->adm_name.'(组长)';
            }
            $num = 0;
            $com_data = json_decode(json_encode($new_data, true), true);
            $quality_data = DB::table('quality_data')
                ->where('quda_wor_id', $request['wor_id'])
                ->where('quda_adm_id', $value->wotp_service_adm_id)
                ->get()->toArray();
            foreach ($com_data as $key1 => $value1) {
                if ($quality_data) {
                    foreach ($quality_data as $key2 => $value2) {
                        if ($value1['qurp_id'] == $value2->quda_qurp_id && $value2->quda_type == 1 && $value2->quda_delete == 2) {
                            $com_data[$key1]['qurp_select'] = 1;
                            $com_data[$key1]['quda_id'] = $value2->quda_id;
                        }
                    }
                }
            }
            $i = 0;
            foreach ($quality_data as $key3 => $value3) {
                if ($value3->quda_type == 2) {
                    $image_data[$i]['quda_id'] = $value3->quda_id;
                    $image_data[$i]['quda_qurp_data'] = $value3->quda_qurp_data;
                    $image_data[$i]['quda_delete'] = $value3->quda_delete;
                    $i++;
                }
            }
            $return_data[$key]['explain'] = DB::table('quality_data')
                ->where('quda_wor_id', $request['wor_id'])
                ->where('quda_adm_id', $value->wotp_service_adm_id)
                ->where('quda_type', 4)
                ->value('quda_qurp_data');
            $return_data[$key]['data'] = $com_data;
            $return_data[$key]['image_data'] = $image_data;
        }
        $data['list'] = $return_data;
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    /**
     * 质检数据实时存储
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-15
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function quality($user_info, $request)
    {
        $find_work = DB::table('work_order as w')
            ->leftJoin('work_client as wc', 'wc.wocl_wor_id', '=', 'w.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_order_id', 'wor_order_number', 'wocl_check_car_state', 'wocl_check_car_lock', 'wocl_phone', 'wocl_check_car_lockadmid', 'wocl_car_num', 'wor_state')
            ->first();

        if (empty($find_work)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前工单不存在', 'data'=>'当前工单不存在'];
        }
        if ($find_work->wor_state >= 8) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已完成', 'data'=>'当前工单已完成'];
        }
        if ($request['quda_type'] == 3) {//质检合格
            if (empty($request['adm_id'])) {//全部-是否合格1是2否
                $update_data['wor_quality'] = $request['quda_qurp_data'];
                $update_data['wor_update_time'] = date('Y-m-d H:i:s');
                $update_res = DB::table('work_order')
                    ->where('wor_id', $request['wor_id'])
                    ->update($update_data);
                if ($request['quda_qurp_data'] == 1) {
                    $update_data['wotp_submit_state'] = $request['quda_qurp_data'];
                    $update_data['wotp_update_time'] = date('Y-m-d H:i:s');
                    $update_res = DB::table('wash_work_technician_part')
                        ->where('wotp_wor_id', $request['wor_id'])
                        ->update(['wotp_submit_state'=>1,'wotp_update_time'=>date('Y-m-d H:i:s')]);
                }
            } else {
                $update_data['wotp_submit_state'] = $request['quda_qurp_data'];
                $update_data['wotp_update_time'] = date('Y-m-d H:i:s');
                $update_res = DB::table('wash_work_technician_part')
                    ->where('wotp_wor_id', $request['wor_id'])
                    ->where('wotp_service_adm_id', $request['adm_id'])
                    ->update($update_data);
                $find_all = DB::table('wash_work_technician_part')
                    ->where('wotp_wor_id', $request['wor_id'])
                    ->where('wotp_submit_state', '!=', 1)
                    ->first();
                if (empty($find_all)) {
                    $update_data_new['wor_quality'] = $request['quda_qurp_data'];
                    $update_data_new['wor_update_time'] = date('Y-m-d H:i:s');
                    $update_res = DB::table('work_order')
                        ->where('wor_id', $request['wor_id'])
                        ->update($update_data_new);
                }
            }
            return ['code'=>200, 'msg'=>'保存成功', 'data'=>''];
        }
        $add_data['quda_shop_id'] = $user_info->adm_shop_id;
        $add_data['quda_wor_id'] = $request['wor_id'];
        $add_data['quda_adm_id'] = $request['adm_id'];
        $add_data['quda_type'] = $request['quda_type'];//类型
        if ($request['quda_type'] == 4) {
            $find_explain = DB::table('quality_data')
                ->where('quda_type', 4)
                ->where('quda_wor_id', $request['wor_id'])
                ->value('quda_id');
            if ($find_explain) {
                $update_data['quda_qurp_data'] = $request['quda_qurp_data'];
                $update_data['quda_update_time'] = date('Y-m-d H:i:s');
                $add_res = DB::table('quality_data')
                    ->where('quda_id', $find_explain)
                    ->update($update_data);
                $data_id = $find_explain;
            } else {
                $add_data['quda_qurp_data'] = $request['quda_qurp_data'];
                $add_data['quda_create_id'] = $user_info->adm_id;
                $add_data['quda_update_id'] = $user_info->adm_id;
                $add_data['quda_create_time'] = date('Y-m-d H:i:s');
                $add_res = DB::table('quality_data')->insertGetId($add_data);
                $data_id = $add_res;
            }
            if ($add_res) {
                return ['code'=>200, 'msg'=>'保存成功', 'data'=>$data_id];
            } else {
                return ['code'=>500, 'msg'=>'保存失败', 'data'=>''];
            }
        }
        if ($request['quda_type'] == 1) {//标签
            $add_data['quda_qurp_id'] = $request['quda_qurp_id'];//质检项id
            $find_qurp_standard = DB::table('wash_quality_reward_punishment')
                ->where('qurp_id', $request['quda_qurp_id'])
                ->value('qurp_standard');
            $add_data['quda_standard'] = $find_qurp_standard;//质检项分数
            $find_data = DB::table('quality_data')
                ->where('quda_wor_id', $request['wor_id'])
                ->where('quda_adm_id', $request['adm_id'])
                ->where('quda_qurp_id', $request['quda_qurp_id'])
                ->select('quda_id', 'quda_delete')
                ->first();
        } else {
            $find_data = false;
        }
        $add_data['quda_qurp_data'] = $request['quda_qurp_data'];
        $add_data['quda_create_id'] = $user_info->adm_id;
        $add_data['quda_update_id'] = $user_info->adm_id;
        $add_data['quda_create_time'] = date('Y-m-d H:i:s');
        if ($find_data && $find_data->quda_delete == 1) {
            $update_data['quda_delete'] = 2;//是否删除1是2否
            $update_data['quda_update_id'] = $user_info->adm_id;
            $update_data['quda_update_time'] = date('Y-m-d H:i:s');
            $add_res = DB::table('quality_data')->where('quda_id', $find_data->quda_id)->update($update_data);
            $data_id = $find_data->quda_id;
        } elseif($find_data && $find_data->quda_delete == 2) {

        } else {
            $add_res = DB::table('quality_data')->insertGetId($add_data);
            $data_id = $add_res;
        }

        if ($add_res) {
            return ['code'=>200, 'msg'=>'保存成功', 'data'=>$data_id];
        } else {
            return ['code'=>500, 'msg'=>'保存失败', 'data'=>''];
        }
    }

    /**
     * 质检数据实时存储-取消
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-15
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function cancelQuality($user_info, $request)
    {
        $find_work = DB::table('work_order as w')
            ->leftJoin('work_client as wc', 'wc.wocl_wor_id', '=', 'w.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_order_id', 'wor_order_number', 'wocl_check_car_state', 'wocl_check_car_lock', 'wocl_phone', 'wocl_check_car_lockadmid', 'wocl_car_num', 'wor_state')
            ->first();

        if (empty($find_work)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前工单不存在', 'data'=>'当前工单不存在'];
        }
        if ($find_work->wor_state >= 8) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已完成', 'data'=>'当前工单已完成'];
        }
        $add_data['quda_update_id'] = $user_info->adm_id;
        $add_data['quda_delete'] = 1;//是否删除1是2否
        $add_data['quda_update_time'] = date('Y-m-d H:i:s');
        $add_res = DB::table('quality_data')
            ->where('quda_id', $request['quda_id'])
            ->update($add_data);

        if ($add_res) {
            return ['code'=>200, 'msg'=>'删除成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'删除失败', 'data'=>''];
        }
    }

    /**
     * 质检数据实时存储
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-15
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function materials($user_info, $request)
    {
        $find_work = DB::table('work_order as w')
            ->leftJoin('work_client as wc', 'wc.wocl_wor_id', '=', 'w.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_state')
            ->first();

        if (empty($find_work)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前工单不存在', 'data'=>'当前工单不存在'];
        }
        if ($find_work->wor_state >= 8) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已完成', 'data'=>'当前工单已完成'];
        }
        if ($request['type'] == 1) {//1商品回收按钮2商品回收数量3此工单余料是否回收4废料按钮5废料数量
            $update_data['wogo_is_recycle'] = $request['data'];
            if ($request['data'] == 2) {
                $update_data['wogo_recycle_quantity'] = 0;
            }
            $update_data['wogo_update_time'] = date('Y-m-d H:i:s');
            $update_res = DB::table('work_good')
                ->where('wogo_id', $request['wogo_id'])
                ->update($update_data);
        }

        if ($request['type'] == 2) {//1商品回收按钮2商品回收数量3此工单余料是否回收4废料按钮5废料数量
            $update_data['wogo_recycle_quantity'] = $request['data'];
            $update_data['wogo_update_time'] = date('Y-m-d H:i:s');
            $update_res = DB::table('work_good')
                ->where('wogo_id', $request['wogo_id'])
                ->update($update_data);
        }

        if ($request['type'] == 3) {//1商品回收按钮2商品回收数量3此工单余料是否回收4废料按钮5废料数量
            $update_data['wor_is_recycle'] = $request['data'];//1.回收2.不回收
            $update_data['wor_update_time'] = date('Y-m-d H:i:s');
            $update_res = DB::table('work_order')
                ->where('wor_id', $request['wor_id'])
                ->update($update_data);
        }

        if ($request['type'] == 4) {//1商品回收按钮2商品回收数量3此工单余料是否回收4废料按钮5废料数量
            $update_data['wogo_is_waste'] = $request['data'];
            if ($request['data'] == 2) {
                $update_data['wogo_goo_waste_number'] = 0;
            }
            $update_data['wogo_update_time'] = date('Y-m-d H:i:s');
            $update_res = DB::table('work_good')
                ->where('wogo_id', $request['wogo_id'])
                ->update($update_data);
        }

        if ($request['type'] == 5) {//1商品回收按钮2商品回收数量3此工单余料是否回收4废料按钮5废料数量
            $update_data['wogo_goo_waste_number'] = $request['data'];
            $update_data['wogo_update_time'] = date('Y-m-d H:i:s');
            $update_res = DB::table('work_good')
                ->where('wogo_id', $request['wogo_id'])
                ->update($update_data);
        }

        if ($update_res) {
            return ['code'=>200, 'msg'=>'保存成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'保存失败', 'data'=>''];
        }
    }

    /**
     * * 校验核销码
     */
    public static function verificationCode($user_info, $request)
    {
        $find_data = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_order_number','wor_ver_code')
            ->first();
        if(empty($find_data)){
            return ['code'=>204, 'msg'=>'工单不存在', 'data'=>''];
        }
        $order_number = DB::table('order')
            ->where('ord_order_number', $find_data->wor_order_number)
            ->value('ord_other_order_num');
        if(empty($order_number)){
            return ['code'=>204, 'msg'=>'订单不存在', 'data'=>''];
        }
        //和智配贴砖的核销码比对
        $url = config('apisystem.sd_server_name') . '/index.php/api/supplychain/SupplyMz/checkUserCode';
        $param['sys_num'] = $order_number;
        $param['user_code'] = $request['wor_ver_code'];
        $doPost_res = MCommon::doPost($param, $url, 2);
        $doPost_res = json_decode($doPost_res,true);
        if ($doPost_res['code'] == 200) {
            return ['code'=>200, 'msg'=>'核销成功', 'data'=>'核销成功'];
        }else if($doPost_res['code'] == 202){
            return ['code'=>202, 'msg'=>$doPost_res['msg'], 'data'=>''];
        }else if($doPost_res['code'] == 203){//203，平台未开启验证或者订单不存在
            return ['code'=>200, 'msg'=>'核销完成', 'data'=>$doPost_res['msg']];
        }
    }

    /**
     * 同步图片
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-24
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function userPicState($user_info, $request) {
        $update_data['wor_list_pic'] = $request['state'];
        $update_data['wor_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->update($update_data);
        if ($update_res) {
            return ['code'=>200, 'msg'=>'操作成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'操作失败', 'data'=>''];
        }
    }

    /**
     * 施工中取消订单
     */
    public static function cancelOrder($user_info, $request) {
        // 查询信息
        $find_work = DB::table('work_order as wor')
            ->leftJoin('order as o', 'o.ord_id', '=', 'wor.wor_order_id')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_state', 'wor_order_id', 'wor_pass', 'wor_service_type', 'wor_type', 'wor_delete', 'wor_service_state', 'wocl_wor_type', 'wor_ware_id', 'wor_create_id', 'wor_order_number', 'wor_appoint_time', 'ord_create_time', 'wor_remark')
            ->first();

        if (empty($find_work)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单不存在！', 'data'=>''];
        }
        if ($find_work->wor_delete != 1) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已经取消！', 'data'=>''];
        }
        
        $find_order = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_id', $find_work->wor_order_id)
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->select('ord_order_number', 'ord_state', 'ord_delete', 'ord_wor_quantity', 'ord_wor_state', 'ord_service_type', 'ord_type', 'ord_client_id', 'ord_goods_quantity', 'ord_actual_price', 'ord_service_shop_id', 'ord_create_id', 'orcl_shipment_party', 'ord_ware_id', 'ord_create_time', 'ord_source', 'orcl_carowner_name', 'orcl_carowner_phone', 'ord_payment_way', 'ord_order_price', 'orcl_phone', 'orcl_name', 'ord_other_payway')
            ->first();
        
        if (empty($find_order)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单不存在！', 'data'=>''];
        }
        
        if ($find_order->ord_delete == 2) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单已经取消！', 'data'=>''];
        }

        
        // 查询出该订单下所有的工单
        $all_work = DB::table('work_order')
            ->where('wor_order_id', $find_work->wor_order_id)
            ->select('wor_delete', 'wor_id')
            ->get();

        

        $now_time = date('Y-m-d H:i:s');
        $find_basic_settings = DB::table('basic_settings')
            ->where('shop_id', $user_info->adm_shop_id)
            ->first();
        $add_pic['ord_id'] = $find_work->wor_order_id;
        if (empty($request['pic_data'])) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'请上传图片', 'data'=>''];
        }
        $add_pic['pic_data'] = json_encode($request['pic_data'], true);
        $add_pic['remark'] = $request['remark'];
        $add_pic['create_id'] = $user_info->adm_id;
        $add_pic['create_time'] = date('Y-m-d H:i:s');
        
        if ($find_order->ord_order_price >= $find_basic_settings->order_amount) {
            $add_pic['state'] = 1;//1待审核2通过3驳回
            $wor_data['wor_state'] = 11; //11取消待审核
            // $wor_data['wor_service_adm_id'] = 0; //服务技师清空
            // $wor_data['wor_service_state'] = 0; //服务状态：1待接单2已接单3预约4出发5抵达6完成待审核
            $wor_data['wor_update_time'] = date('Y-m-d H:i:s');
            $wor_res = DB::table('work_order')
                ->where('wor_order_id', $find_work->wor_order_id)
                ->where('wor_delete', 1)
                ->update($wor_data);
            $ord_data['ord_delete'] = 3; //是否删除：1正常订单2取消订单3取消待审核
            $ord_data['ord_wor_state'] = 12; //订单的工单状态1未派工单2服务中4已完成7待接单11取消订单
            $ord_data['ord_update_time'] = $now_time;
            $ord_res = DB::table('order')
                ->where('ord_id', $find_work->wor_order_id)
                ->update($ord_data);
        } else {
            // 验证当前订单下工单是否已经全部取消
            $work_order = new WorkOrders();
            foreach ($all_work as $key => $value) {
                $find_work1 = DB::table('work_order as wor')
                    ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                    ->where('wor_id', $value->wor_id)
                    ->where('wor_shop_id', $user_info->adm_shop_id)
                    ->select('wor_number', 'wor_state', 'wor_order_id', 'wor_goo_amount', 'wor_type', 'wor_actual_price', 'wor_ware_id', 'wor_remark', 'wor_pass', 'wor_service_type', 'wor_type', 'wocl_client_id', 'wocl_sd_virtual_type', 'wocl_wor_type', 'wor_order_number', 'wor_delete')
                    ->first();
                if ($value->wor_delete == 1) {
                    $return_data = $work_order->deletes($user_info, $request, $find_work1);
                }
            }
            $wotp_res = DB::table('wash_work_technician_part')
                ->where('wotp_wor_id', $request['wor_id'])
                ->delete();
            $ord_data['ord_delete'] = 2; //是否删除：1正常订单2取消订单
            $ord_data['ord_payment_way'] = 0; //结算方式
            $ord_data['ord_actual_price'] = 0; //结算金额
            $ord_data['ord_zero_price'] = 0; //优惠金额
            $ord_data['ord_settlement_time'] = ''; //结算时间
            $ord_data['ord_state'] = 1; //结算状态1未结算2已结算
            $ord_data['ord_wor_state'] = 11; //订单的工单状态1未派工单2服务中4已完成7待接单11取消订单
            $ord_data['ord_update_time'] = $now_time;
            $ord_res = DB::table('order')
                ->where('ord_id', $find_work->wor_order_id)
                ->update($ord_data);
            $add_pic['state'] = 2;//1待审核2通过3驳回
        }
        $add_pic_res = DB::table('cancel_order_data')->insertGetId($add_pic);
        
        if ($ord_res) {
            $data['ord_order_number'] = $find_order->ord_order_number;
            $data['orcl_name'] = $find_order->orcl_name;
            $data['orcl_phone'] = $find_order->orcl_phone;
            $wohi_data['wohi_primary_id'] = $find_work->wor_order_id;
            $wohi_data['wohi_state_name'] = '已取消';
            $wohi_data['wohi_state'] = 6;
            $wohi_data['wohi_type'] = 1;
            addHistory($wohi_data);
            unset($wohi_data);
            return ['code'=>200, 'msg'=>'取消订单成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'取消订单失败', 'data'=>'取消订单失败'];
        }
    }

    /**
     * 施工审核
     */
    public static function auditWork($user_info, $request) {
        if ($request['state'] == 1) {
            // 通过
            $wor_edit_data['wor_service_state'] = 7;
            $wor_edit_data['wor_state'] = 9;
            $wor_edit_data['wor_update_time'] = date('Y-m-d H:i:s');
            $wor_edit_res = WashWork::where('wor_id', $request['wor_id'])->update($wor_edit_data);
        } else {
            $add_data['wor_id'] = $request['wor_id'];
            $add_data['wor_refuse_remark'] = $request['wor_refuse_remark'];
            $add_data['wor_refuse_data'] = $request['wor_refuse_data'];
            $add_data['type'] = 1;
            $add_data['create_id'] = $user_info->adm_id;
            $add_data['create_time'] = date('Y-m-d H:i:s');
            $add_res = DB::table('work_refuse')->insertGetId($add_data);
            $wor_edit_data['wor_service_state'] = 5;
            $wor_edit_data['wor_state'] = 7;
            $wor_edit_data['wor_update_time'] = date('Y-m-d H:i:s');
            $wor_edit_res = WashWork::where('wor_id', $request['wor_id'])->update($wor_edit_data);
        }
        return ['code'=>200, 'msg'=>'审核成功', 'data'=>'审核成功'];
    }

    /**
     * 还件-返工
     */
    public static function returnWork($user_info, $request) {
        $add_data['wor_id'] = $request['wor_id'];
        $add_data['wor_refuse_remark'] = $request['wor_refuse_remark'];
        $add_data['wor_refuse_data'] = $request['wor_refuse_data'];
        $add_data['type'] = 2;
        $add_data['create_id'] = $user_info->adm_id;
        $add_data['create_time'] = date('Y-m-d H:i:s');
        $add_res = DB::table('work_refuse')->insertGetId($add_data);
        $wor_edit_data['wor_service_state'] = 5;
        $wor_edit_data['wor_state'] = 7;
        $wor_edit_data['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_edit_res = WashWork::where('wor_id', $request['wor_id'])->update($wor_edit_data);
        return ['code'=>200, 'msg'=>'返工成功', 'data'=>'返工成功'];
    }

    /**
     * 还件-提交还件信息
     */
    public static function returnItem($user_info,$request) {
        $find_work = DB::table('work_order as wor')
            ->leftJoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->select('wor_number', 'wor_state', 'wor_delete', 'wor_pass', 'wor_service_adm_id', 'wor_type', 'wor_ware_id', 'wor_order_id', 'wor_order_number', 'wocl_client_id', 'wor_actual_price', 'wocl_car_num', 'wor_work_type', 'wor_quality', 'wor_is_recycle')
            ->first();
        if (empty($find_work)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单不存在，无法提交！', 'data'=>''];
        }

        if ($find_work->wor_delete != 1) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已经取消！', 'data'=>''];
        }
        if (!in_array($find_work->wor_state, [9])) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单不是还件中，无法提交！', 'data'=>''];
        }
        if ($request['return_image']) {
            $return_image = json_decode($request['return_image'], true);
            foreach ($return_image as $key=>$value) {
                $add_data['coin_shop_id'] = $user_info->adm_shop_id;
                $add_data['coin_wor_id'] = $request['wor_id'];
                $add_data['coin_adm_id'] = $user_info->adm_id;
                $add_data['coin_type'] = 5;
                $add_data['coin_data'] = $value;
                $add_data['coin_create_id'] = $user_info->adm_id;
                $add_data['coin_update_id'] = $user_info->adm_id;
                $add_data['coin_create_time'] = date('Y-m-d H:i:s');
                $add_res = DB::table('completion_info')->insertGetId($add_data);
            }
        }
        if ($request['return_remark']) {
            $add_data['coin_shop_id'] = $user_info->adm_shop_id;
            $add_data['coin_wor_id'] = $request['wor_id'];
            $add_data['coin_adm_id'] = $user_info->adm_id;
            $add_data['coin_type'] = 6;
            $add_data['coin_data'] = $request['return_remark'];
            $add_data['coin_create_id'] = $user_info->adm_id;
            $add_data['coin_update_id'] = $user_info->adm_id;
            $add_data['coin_create_time'] = date('Y-m-d H:i:s');
            $add_res = DB::table('completion_info')->insertGetId($add_data);
        }
        $wor_edit_data['wor_service_state'] = 8;
        $wor_edit_data['wor_state'] = 10;
        $wor_edit_data['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_edit_res = WashWork::where('wor_id', $request['wor_id'])->update($wor_edit_data);
        return ['code'=>200, 'msg'=>'还件成功', 'data'=>'还件成功'];
    }

    public static function returnItemData($user_info, $request)
    {
        $find_work = DB::table('work_order as w')
            ->leftJoin('work_client as wc', 'wc.wocl_wor_id', '=', 'w.wor_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select('wor_number', 'wor_order_id', 'wor_order_number', 'wocl_check_car_state', 'wocl_check_car_lock', 'wocl_phone', 'wocl_check_car_lockadmid', 'wocl_car_num', 'wor_state')
            ->first();

        if (empty($find_work)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前工单不存在', 'data'=>'当前工单不存在'];
        }
        if ($find_work->wor_state >= 10) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前工单已完成', 'data'=>'当前工单已完成'];
        }

        if($request['coin_type'] == 6) {//补充说明
            $add_data['coin_shop_id'] = $user_info->adm_shop_id;
            $add_data['coin_wor_id'] = $request['wor_id'];
            $add_data['coin_adm_id'] = $request['adm_id'];
            $add_data['coin_type'] = $request['coin_type'];
            $add_data['coin_data'] = $request['coin_data'];
            $add_data['coin_create_id'] = $user_info->adm_id;
            $add_data['coin_update_id'] = $user_info->adm_id;
            $add_data['coin_create_time'] = date('Y-m-d H:i:s');
            $find_explain = DB::table('completion_info')
                ->where('coin_type', 4)
                ->where('coin_wor_id', $request['wor_id'])
                ->value('coin_id');
            if ($find_explain) {
                $update_data['coin_data'] = $request['coin_data'];
                $update_data['coin_update_time'] = date('Y-m-d H:i:s');
                $add_res = DB::table('completion_info')
                    ->where('coin_id', $find_explain)
                    ->update($update_data);
                $data_id = $find_explain;
            } else {
                $add_res = DB::table('completion_info')->insertGetId($add_data);
                $data_id = $add_res;
            }
        } elseif($request['coin_type'] == 5) {
            $add_data['coin_shop_id'] = $user_info->adm_shop_id;
            $add_data['coin_wor_id'] = $request['wor_id'];
            $add_data['coin_adm_id'] = $request['adm_id'];
            $add_data['coin_type'] = $request['coin_type'];
            $add_data['coin_data'] = $request['coin_data'];
            $add_data['coin_create_id'] = $user_info->adm_id;
            $add_data['coin_update_id'] = $user_info->adm_id;
            $add_data['coin_create_time'] = date('Y-m-d H:i:s');
            $add_res = DB::table('completion_info')->insertGetId($add_data);
            $data_id = $add_res;
        }

        if ($add_res) {
            return ['code'=>200, 'msg'=>'保存成功', 'data'=>$data_id];
        } else {
            return ['code'=>500, 'msg'=>'保存失败', 'data'=>''];
        }
    }

    public static function returnItemInfo($user_info, $request)
    {
        $find_worker = DB::table('wash_work_technician_part as w')
            ->leftJoin('admin', 'w.wotp_service_adm_id', '=', 'adm_id')
            ->where('wotp_wor_id', $request['wor_id'])
            ->where('wotp_work_type', 3)
            ->where(function ($query) use ($request) { //技师id
                if (!empty($request['adm_id'])) {
                    $query->where('wotp_service_adm_id', $request['adm_id']);
                }
            })
            ->select('wotp_service_adm_id', 'adm_name', 'wotp_work_type')
            ->first();

        if (empty($find_worker)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'查无数据', 'data'=>''];
        }

        $image_data = DB::table('completion_info')
            ->where('coin_wor_id', $request['wor_id'])
            ->where('coin_adm_id', $find_worker->wotp_service_adm_id)
            ->where('coin_type', 5)
            ->select('coin_data_id', 'coin_type', 'coin_id', 'coin_data', 'coin_name', 'coin_must')
            ->get()->toArray();
        $remark_data = DB::table('completion_info')
            ->where('coin_wor_id', $request['wor_id'])
            ->where('coin_adm_id', $find_worker->wotp_service_adm_id)
            ->where('coin_type', 6)
            // ->where('coin_must', 1)
            ->select('coin_data_id', 'coin_type', 'coin_id', 'coin_data', 'coin_name', 'coin_must')
            ->first();
        $return_data['image_data'] = array_column($image_data,'coin_data');
        $return_data['remark_data'] = $remark_data? $remark_data->coin_data:'';
        
        return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
    }
}
