<?php

namespace App\Services\Business;

use Illuminate\Http\Request;
use BlueCity\Core\Service\Service;
use Illuminate\Database\Query\Builder;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\recycleManage\VerifyRecedeRecycleController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Api\OutinRecord;
use App\Http\Models\Services\WarehouseManage\OutinStockLock;
use App\Http\Models\Services\WarehouseManage\ReturnWarehousing;
use App\Http\Requests\Validators\Business\WashRecedeRecycleValidator;
use App\Services\Business\WashOrderService;

class WashRecedeRecycleService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->mainValidator = new WashRecedeRecycleValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param object $user_info 用户信息
     * @param array $search_data 内容
     * @param int $show_count 页容量
     * @return mixed
     */
    public function searchPage($user_info, $request, $show_count = 10)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->adm_shop_id;
        $search_data = $request;
        $list_data = DB::table('recede_recycle as r')
            ->leftJoin('recede_client as c', 'r.rec_id', '=', 'c.recl_rec_id')
            ->leftjoin('work_order as wor', 'wor.wor_id', '=', 'r.rec_ord_id')
            ->where('rec_cid', $user_info->adm_cid)
            ->where('rec_shop_id', $shop_id)
            ->where(function ($query) use ($search_data) { //关键字搜索
                if (!empty($search_data['keywords'])) {
                    $query->where('rec_number', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('wor_order_number', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('rec_ord_order_number', 'like', '%' . $search_data['keywords'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //是否回收1已回收2未回收
                if (!empty($search_data['rec_state'])) {
                    $query->where('r.rec_state', $search_data['rec_state']);
                }
            })
            ->select('r.rec_id', 'r.rec_date', 'r.rec_number', 'r.rec_ord_order_number', 'r.rec_type', 'r.rec_price', 'r.rec_amount', 'c.recl_name', 'c.recl_phone', 'r.rec_remark', 'r.rec_create_adm_id', 'r.rec_ware_id', 'r.rec_state', 'rec_source_type', 'recl_client_id', 'wor_order_number as rec_ord_id', 'wor_service_adm_id', 'rec_create_time', 'recl_channel_unit')
            ->orderBy('r.rec_id', 'desc')
            ->paginate($show_count);

        $list_items = $list_data->items();
        if ($list_items) {
            // 查询出当前列表的账号信息
            $adm_id = array_unique(array_column($list_items, 'rec_create_adm_id'));
            $recl_client_id = array_unique(array_column($list_items, 'recl_client_id')); //客户id
            $admin = DB::table('admin')
                ->where('adm_cid', $user_info->adm_cid)
                ->where('adm_shop_id', $shop_id)
                ->whereIn('adm_id', $adm_id)
                ->pluck('adm_name', 'adm_id')->toArray();
            $admin_phone = DB::table('admin')
                ->where('adm_cid', $user_info->adm_cid)
                ->where('adm_shop_id', $shop_id)
                ->whereIn('adm_id', $adm_id)
                ->pluck('adm_phone', 'adm_id')->toArray();
            // 查询出当前列表的仓库信息
            $rec_ware_id = array_unique(array_column($list_items, 'rec_ware_id'));
            $warehouse = DB::table('warehouse')
                ->where('ware_cid', $user_info->adm_cid)
                ->where('ware_shop_id', $shop_id)
                ->whereIn('ware_id', $rec_ware_id)
                ->select('ware_type', 'ware_name', 'ware_id')
                ->get()
                ->keyBy('ware_id')->toArray();

            $adms_ware_id = DB::table('admin_set')
                ->where('adms_adm_id', $user_info->adm_id)
                ->where('adms_shop_id', $user_info->adm_shop_id)
                ->value('adms_myware_id');
            $adms_ware_id = explode(',', $adms_ware_id);
            // 查询会员客户
            $member_data = DB::table('member')
                ->where('mem_shop_id', $user_info->adm_shop_id)
                ->whereIn('mem_id', $recl_client_id)
                ->pluck('mem_name', 'mem_id')
                ->toArray();
            foreach ($list_items as $key => $value) {
                // 创建人-组长
                if (isset($admin[$value->rec_create_adm_id])) {
                    $list_items[$key]->rec_create_adm_name = $admin[$value->rec_create_adm_id];
                } else {
                    $list_items[$key]->rec_create_adm_name = '';
                }
                // 创建人电话
                if (isset($admin[$value->rec_create_adm_id])) {
                    $list_items[$key]->rec_create_adm_phone = $admin_phone[$value->rec_create_adm_id];
                } else {
                    $list_items[$key]->rec_create_adm_phone = '';
                }
                // 仓库名称
                if (isset($warehouse[$value->rec_ware_id])) {
                    $list_items[$key]->rec_ware_name = $warehouse[$value->rec_ware_id]->ware_name;
                } else {
                    $list_items[$key]->rec_ware_name = '';
                }
                if (isset($warehouse[$value->rec_ware_id])) {
                    $list_items[$key]->ware_type = $warehouse[$value->rec_ware_id]->ware_type;
                    if ($warehouse[$value->rec_ware_id]->ware_type == 2 || in_array($value->rec_ware_id, $adms_ware_id)) {
                        $list_items[$key]->privilege_state = 1;
                    } else {
                        $list_items[$key]->privilege_state = 2;
                    }
                } else {
                    $list_items[$key]->ware_type = '';
                }
                if ($value->rec_type == 1) { //会员零售
                    if (isset($member_data[$value->recl_client_id])) {
                        $list_items[$key]->recl_channel_unit = $member_data[$value->recl_client_id];
                    } else {
                        $list_items[$key]->recl_channel_unit = $value->recl_channel_unit ? $value->recl_channel_unit : $value->recl_name;
                    }
                } else {
                    // 客户单位名称
                    if (isset($channel[$value->recl_client_id])) {
                        $list_items[$key]->recl_channel_unit = $channel[$value->recl_client_id];
                    } else {
                        $list_items[$key]->recl_channel_unit = $value->recl_channel_unit ? $value->recl_channel_unit : $value->recl_name;
                    }
                }
                $goo_data = DB::table('recede_goods')
                    ->where('rego_rec_id', $value->rec_id)
                    ->select('rego_goo_unit', 'rego_goo_unta_id', 'rego_goo_name', 'rego_recycle_number')
                    ->get()->toArray();
                if ($goo_data) {
                    $list_items[$key]->goo_data = $goo_data;
                } else {
                    $list_items[$key]->goo_data = '';
                }
            }
        }

        $state_count = DB::table('dispatch_bill')
            ->where('dego_cid', $user_info->adm_cid)
            ->where('dego_shop_id', $user_info->adm_shop_id)
            ->select(DB::raw('count(*) as count, dego_type'))
            ->groupBy('dego_type')
            ->get();
        $rec_state_count = DB::table('recede_recycle')
            ->where('rec_cid', $user_info->adm_cid)
            ->where('rec_superior_shop_id', $user_info->adm_shop_id)
            ->select(DB::raw('count(*) as count, rec_state'))
            ->groupBy('rec_state')
            ->get();

        $data['state_count'] = $state_count;
        $data['rec_state_count'] = $rec_state_count;
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                              //返回数据

        // 获取当前列表下的按钮
        if ($list_data) {
            return ['code'=>200, 'msg'=>'success', 'data'=>$data];
        } else {
            return ['code'=>200, 'msg'=>'暂无数据', 'data'=>$data];
        }
    }

    public static function recycle($user_info, $request, $find_recede)
    {
        if (empty($request['goo_data'])) {
            return ['code'=>500, 'msg'=>'退换商品不能为空', 'data'=>'退换商品不能为空'];
        }
        // 查询出客户单位名称 客户姓名 联系电话
        $client = DB::table('recede_client')
            ->where('recl_rec_id', $request['rec_id'])
            ->select('recl_channel_unit', 'recl_name', 'recl_phone', 'recl_client_id')
            ->first();
        $goo_data = json_decode($request['goo_data'], true);
        $goo_amount = 0;
        if (!empty($goo_data)) {
            foreach ($goo_data as $key => $value) {
                // $find_wor_data = DB::table('work_good as wogo')
                //     ->leftjoin('goods as g', 'g.goo_id', '=', 'wogo.wogo_goo_id')
                //     ->where('wogo_wor_id', $find_recede->rec_ord_id)
                //     ->where('wogo_goo_id', $value['goo_id'])
                //     ->select('wogo_goo_amount', 'wogo_recycle_quantity', 'wogo_goo_waste_number', 'goo_unit_conversion', 'wogo_goo_unta_id')
                //     ->first();
                // if(empty($find_wor_data)){
                //     $find_wor_data = DB::table('order_goods as wogo')
                //         ->leftjoin('goods as g', 'g.goo_id', '=', 'wogo.orgo_goo_id')
                //         ->where('orgo_ord_id', $find_recede->rec_ord_id)
                //         ->where('orgo_goo_id', $value['goo_id'])
                //         ->select('orgo_goo_amount as wogo_goo_amount', 'orgo_recycle_quantity as wogo_recycle_quantity', 'goo_unit_conversion', 'orgo_goo_unta_id as wogo_goo_unta_id')
                //         ->first();
                // }
                // if ($find_wor_data->wogo_goo_unta_id == 1) {
                //     $wogo_goo_amount = $find_wor_data->wogo_goo_amount * $find_wor_data->goo_unit_conversion;
                // } else {
                //     $wogo_goo_amount = $find_wor_data->wogo_goo_amount;
                // }
                // if ($value['goo_recycle_amount'] > $wogo_goo_amount) {
                //     return ['code'=>500, 'msg'=>'退回数量错误', 'data'=>'退回数量错误'];
                // }
                if (!isset($value['goo_wafr_id'])) {
                    $goo_data[$key]['goo_wafr_id'] = Db::table('warehouse_freight')
                        ->where('wafr_ware_id', $find_recede->rec_ware_id)
                        ->value('wafr_id');
                }
                $find_disgoods = DB::table('dispatch_goods')
                    ->leftjoin('dispatch_bill', 'dego_id', '=', 'digo_dego_id')
                    ->leftjoin('goods', 'goo_id', '=', 'digo_goo_id')
                    ->where('dego_order_type', 1)
                    ->where('dego_wor_id', $find_recede->rec_ord_id)
                    ->where('digo_goo_id', $value['goo_id'])
                    ->first();
                if (empty($find_disgoods)) {
                    // $wor_data = DB::table('work_order')
                    //     ->where('wor_order_id', $find_recede->rec_ord_id)
                    //     ->first();
                    // dump($wor_data);
                    // dump($find_recede->rec_ord_id);
                    // die;
                    $find_disgoods = DB::table('dispatch_goods')
                        ->leftjoin('dispatch_bill', 'dego_id', '=', 'digo_dego_id')
                        ->leftjoin('goods', 'goo_id', '=', 'digo_goo_id')
                        ->where('dego_order_type', 2)
                        ->where('dego_wor_id', $find_recede->rec_ord_id)
                        ->where('digo_goo_id', $value['goo_id'])
                        ->first();
                }
                if ($find_disgoods->digo_goo_unta_id == 1) {
                    $wogo_goo_amount = $find_disgoods->digo_goo_quantity * $find_disgoods->goo_unit_conversion;
                } else {
                    $wogo_goo_amount = $find_disgoods->digo_goo_quantity;
                }
                
                if ($value['goo_recycle_amount'] > $wogo_goo_amount) {
                    return ['code'=>500, 'msg'=>'退回数量错误', 'data'=>'退回数量错误'];
                }
            }
        }
        // rec_source_type 来源类型1. 售后退货 2. 工单退货(换货单) 3 页面新增 4 (工单号)退货单 5技师退回 6技师拒单 7技师终止 8(订单号)退货单
       
        // 根据原始单id,查询到订单id
        $find_order = DB::table('work_order')
            ->where('wor_id', $find_recede->rec_ord_id)
            ->select('wor_order_id', 'wor_order_number', 'wor_service_type')
            ->first();
        if(empty($find_order)){
            $find_order = DB::table('order')
                ->where('ord_id', $find_recede->rec_ord_id)
                ->select('ord_id as wor_order_id', 'ord_order_number as wor_order_number', 'ord_service_type as wor_service_type')
                ->first();
        }
        // 查询订单状态值
        $ord_wor_state = DB::table('order')
            ->where('ord_id', $find_order->wor_order_id)
            ->where('ord_order_number', $find_order->wor_order_number)
            ->value('ord_wor_state');

        // 查询仓库类型 类型：1固定仓2技师库3移动仓
        $rec_ware_type = DB::table('warehouse')
            ->where('ware_id', $find_recede->rec_ware_id)
            ->value('ware_type');
        // 来源类型 6技师拒单
        if ($find_recede->rec_source_type == 6) {
            // 技师拒单
            $return_warehousing_data = ReturnWarehousing::technicianRejection(
                $user_info, //用户信息
                $request, //前端传过来的数据
                $find_recede, //退货入库数据
                $find_order, //原始单相关数据
                $rec_ware_type, //类型：1固定仓2技师库3移动仓
                $ord_wor_state, //查询速电订单状态值是否为撤销状态
                $goo_data //商品数据
            );
            $post_data['ware_id'] = $find_recede->rec_ware_id;
            $post_data['new_goods_data'] = $goo_data;
            $addGoodPlan = WashOrderBasicService::addGoodPlan($user_info, $post_data);
            if ($return_warehousing_data['code'] != 200) {
                return $return_warehousing_data;
            } else {
                return ['code'=>200, 'msg'=>'退换入库成功', 'data'=>'退换入库成功'];
            }
        }

        $goo_id = array_column($goo_data, 'goo_id');
        // 查询商品名称
        $find_goods = DB::table('goods')
            ->where('goo_cid', $user_info->adm_cid)
            ->where('goo_shop_id', $user_info->adm_shop_id)
            ->whereIn('goo_id', $goo_id)
            ->select('goo_id', 'goo_name', 'goo_goods_encode', 'goo_class')
            ->get()->toArray();
        $find_goods = array_column($find_goods, null, 'goo_id');
        $goo_id = array_column($find_goods, 'goo_id');

        $oure_type = 5;

        // 退货入库
        $recede_return_data = ReturnWarehousing::returnOrder(
            $user_info, //用户信息
            $find_recede, //退换入库数据
            $request, //前端传过来的数据
            $goo_data,
            $find_order,
            $rec_ware_type
        );

        //退换入库修改商品单价和总价
        $amount_ret = self::updateWagoAmountRecede($goo_data,$request['rec_ware_id']);
        if($amount_ret['code'] != 200){
            return ['code'=>500, 'msg'=>'error', 'data'=>'退换货入库失败011'];
        }
        //申请退货，更新退货管理的退货状态
        $amount_ret = self::updateOrderGoods($find_recede,$goo_data,$user_info,$client->recl_client_id);
        if($amount_ret['code'] != 200){
            return ['code'=>500, 'msg'=>'error', 'data'=>'退换货入库失败012'];
        }

        $post_data['ware_id'] = $find_recede->rec_ware_id;
        $post_data['new_goods_data'] = $goo_data;
        $addGoodPlan = WashOrderBasicService::addGoodPlan($user_info, $post_data);
        if ($recede_return_data['code'] == 200) {
            return ['code'=>200, 'msg'=>'退换入库成功', 'data'=>'退换入库成功'];
        } else {
            return ['code'=>500, 'msg'=>'退换入库失败', 'data'=>'退换入库失败'];
        }
    }

    /*
     * @name 申请退货，更新退货管理的退货状态
     * @param string ju_ordernum 订单单号
     * @retrun array
     * @author Ma 2023/9/18 14:47
     *
    */
    public static function updateOrderGoods($find_recede,$goo_data,$user_info,$recl_client_id){
        //申请退货，更新退货管理的退货状态
        $retgo_data = DB::table('return_goods')->where('retgo_number', $find_recede->rec_number)->first();
        if($retgo_data){
            $new_order_number = $find_recede->rec_ord_order_number;
            $order_data = DB::table('order_goods')->where('orgo_order_number', $find_recede->rec_ord_order_number)
                ->get()->toArray();
            if(empty($order_data)){
                $order_number = DB::table('work_order')
                    ->where('wor_number', $find_recede->rec_ord_order_number)
                    ->value('wor_order_number');
                $new_order_number = $order_number;
                $order_data = DB::table('order_goods')->where('orgo_order_number',$order_number)
                    ->get()->toArray();
            }
            foreach ($order_data as $o_key => $o_value){
                $order_goods[$o_value->orgo_order_number][$o_value->orgo_goo_id] = $o_value->orgo_goo_return_quantity;//已退数量
            }
            DB::table('return_goods')->where('retgo_number',  $find_recede->rec_number)->update(['retgo_return_status'=>3]);
            //更新订单退货数量
            foreach ($goo_data as $t_key => $t_value){
                $order = DB::table('order')->where('ord_order_number', $retgo_data->retgo_order_number)
                    ->select('ord_state','ord_id','ord_client_id','ord_order_price','ord_type')->first();
                if($order->ord_state == 1){//未结算,发货，数量不变，金额变
                    $order_good = DB::table('order')->where('ord_order_number', $retgo_data->retgo_order_number)
                        ->update(['ord_order_price'=>$retgo_data->retgo_amount]);
                    $order_goods_num = DB::table('order_goods')->where('orgo_order_number', $retgo_data->retgo_order_number)
                        ->where('orgo_goo_id', $t_value['goo_id'])->first();
                    //$up_order_goods['orgo_goo_quantity'] = $order_goods_num->orgo_goo_quantity - $t_value['goo_recycle_amount'];
                    $up_order_goods['orgo_can_assign_quantity'] = $order_goods_num->orgo_can_assign_quantity - $t_value['goo_recycle_amount'];
                    $up_order_goods['orgo_new_goo_quantity'] = $order_goods_num->orgo_new_goo_quantity - $t_value['goo_recycle_amount'];
                    $up_order_goods['orgo_goo_amount'] = $order_goods_num->orgo_goo_amount - $t_value['goo_recycle_amount'] * $order_goods_num->orgo_goo_price;
                    $order_good = DB::table('order_goods')->where('orgo_order_number', $retgo_data->retgo_order_number)
                        ->where('orgo_goo_id', $t_value['goo_id'])
                        ->update($up_order_goods);

                    if($order->ord_type == 1){
                        //修改会员欠收金额
                        $find_mem = DB::table('member')->where('mem_id', $order->ord_client_id)
                            ->value('mem_arrears');
                        $mem_arrears = $find_mem - ($order->ord_order_price - $retgo_data->retgo_amount);//欠收金额 = 本来欠收的金额 - （订单原金额 - 订单现在的金额）
                        $update_mem = DB::table('member')->where('mem_id', $order->ord_client_id)
                            ->update(['mem_arrears'=>$mem_arrears]);
                    }else if($order->ord_type == 2){
                        //修改企业会员欠收金额
                        $find_bucl = DB::table('business_client')->where('bucl_id', $order->ord_client_id)
                            ->value('bucl_arrears');
                        $mem_arrears = $find_bucl - ($order->ord_order_price - $retgo_data->retgo_amount);//欠收金额 = 本来欠收的金额 - （订单原金额 - 订单现在的金额）
                        $update_mem = DB::table('business_client')->where('bucl_id', $order->ord_client_id)
                            ->update(['bucl_arrears'=>$mem_arrears]);
                    }
                }
                DB::table('order_goods')->where('orgo_order_number', $new_order_number)
                    ->where('orgo_goo_id', $t_value['goo_id'])
                    ->update(['orgo_goo_return_quantity'=>$order_goods[$new_order_number][$t_value['goo_id']] + $t_value['goo_recycle_amount']]);
                //工单
                $work_order = DB::table('work_order')->where('wor_order_number', $retgo_data->retgo_order_number)
                    ->select('wor_id','wor_goo_amount','wor_new_goo_amount')->first();
                if($work_order){
                    $up_work_order['wor_goo_amount'] = $work_order->wor_goo_amount - $t_value['goo_recycle_amount'];
                    $up_work_order['wor_new_goo_amount'] = $work_order->wor_goo_amount - $t_value['goo_recycle_amount'];
                    $order_good = DB::table('work_order')->where('wor_order_number', $retgo_data->retgo_order_number)
                        ->update($up_work_order);
                    $find_work_good = DB::table('work_good')->where('wogo_wor_id', $work_order->wor_id)
                        ->where('wogo_goo_id', $t_value['goo_id'])
                        ->first();
                    $up_work_order_goods['wogo_goo_amount'] = $find_work_good->wogo_goo_amount - $t_value['goo_recycle_amount'];
                    $rec_goods_one = DB::table('recede_goods as re')
                        ->leftjoin('goods as g', 'g.goo_id', '=', 're.rego_goo_id')
                        ->where('rego_rec_id', $find_recede->rec_id)
                        ->where('rego_goo_id', $t_value['goo_id'])
                        ->select('rego_goo_unta_id','goo_unit_conversion')
                        ->first();
                    $wogo_new_goo_amount = $t_value['goo_recycle_amount'];
                    $up_work_order_goods['wogo_new_goo_amount'] = $find_work_good->wogo_new_goo_amount - $wogo_new_goo_amount;
                    $work_good = DB::table('work_good')->where('wogo_wor_id', $work_order->wor_id)
                        ->where('wogo_goo_id', $t_value['goo_id'])
                        ->update($up_work_order_goods);
                }
            }
            //如果货和款都退了就取消订单
            $params['ord_id'] = $order->ord_id;
            $params['ord_order_number'] = $find_recede->rec_ord_order_number;
            $params['remark'] = '全部退货取消订单';
            $cancel_ret = WashOrderService::cancelOrder($user_info,$params);
            if($cancel_ret['code'] != 200){
                return ['code'=>500, 'msg'=>'取消订单失败', 'data'=>''];
            }
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>'修改订单成功'];
    }


    /* 商品库存有变化的时候，修改仓库商品得总价 20230518
     * $ware_id  商品id
     * $goo_data 退换商品信息
     */
    public static function updateWagoAmountRecede($goo_data,$ware_id)
    {
        if(empty($goo_data)){
            return ['code'=>500, 'msg'=>'success', 'data'=>'仓库商品不存在'];
        }
        $good_ids = array_column($goo_data,'goo_id');//商品id

        // 查询仓库商品信息
        $find_tror = DB::table('warehouse_goods')
            ->whereIn('wago_goo_id', $good_ids)
            ->where('wago_class', 1)
            ->where('wago_ware_id', $ware_id)
            ->select('wago_id', 'wago_goo_price', 'wago_goo_amount', 'wago_stock_number', 'wago_lock_quantity', 'wago_ware_id', 'wago_goo_id')
            ->get()->toArray();
        if(empty($find_tror)){
            return ['code'=>500, 'msg'=>'success', 'data'=>'仓库商品不存在'];
        }
        foreach ($find_tror as $k => $v){
            $trod_data = [];
            //仓库商品得总价 = 商品单价 * （商品库存 + 商品锁定数量）
            $amount = $v->wago_goo_price * ($v->wago_stock_number + $v->wago_lock_quantity);
            $trod_data['wago_goo_amount'] = $amount;
            $trod_data['wago_update_time'] =  date('Y-m-d H:i:s'); //更新时间
            //修改仓库商品的总价
            $ware_goo_ret = DB::table('warehouse_goods')
                ->where('wago_ware_id', $v->wago_ware_id)
                ->where('wago_goo_id', $v->wago_goo_id)
                ->where('wago_class', 1)
                ->update($trod_data);
        }
        //查找仓库所有商品总价
        $find_tror_all = DB::table('warehouse_goods')
            ->where('wago_ware_id', $ware_id)
            ->where('wago_class', 1)
            ->select('wago_id', 'wago_goo_amount', 'wago_ware_id')
            ->get()->toArray();
        if(empty($find_tror_all)){
            return ['code'=>500, 'msg'=>'success', 'data'=>'仓库不存在'];
        }
        $ware_all_data = [];
        foreach ($find_tror_all as $a_k => $a_v){
            if(isset($ware_all_data[$a_v->wago_ware_id])){
                $ware_all_data[$a_v->wago_ware_id] += $a_v->wago_goo_amount;
            }else{
                $ware_all_data[$a_v->wago_ware_id] = $a_v->wago_goo_amount;
            }
        }
        foreach ($ware_all_data as $k => $v){
            //修改仓库商品的总金额
            $ware_ret = DB::table('warehouse')
                ->where('ware_id', $k)
                ->where('ware_type', 1)
                ->update(['ware_goo_amount'=>$v]);
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>'修改总价成功'];
    }

    // 详情
    public function details($user_info, $request)
    {
        // 获取回收单数据
        $find_recede = DB::table('recede_recycle as re')
            ->leftjoin('admin as a', 'a.adm_id', '=', 're.rec_create_adm_id')
            ->where('rec_id', $request['rec_id'])
            ->first(['rec_number', 'rec_ord_order_number', 'rec_create_time', 'rec_state', 'rec_amount', 'rec_remark', 'rec_date', 'rec_price', 'rec_ware_id', 'adm_name as rec_create_adm_name', 'rec_type', 'adm_phone as rec_create_adm_phone']);

        if (empty($find_recede)) {
            return['code'=>500, 'msg'=>'error', 'data'=>'当前回收单不存在'];
        }

        // 查询出客户单位名称 客户姓名 联系电话
        $client = DB::table('recede_client')
            ->where('recl_rec_id', $request['rec_id'])
            ->first(['recl_channel_unit', 'recl_name', 'recl_phone', 'recl_client_id']);
        if ($find_recede->rec_type == 1) {
            $find_recede->recl_channel_unit = DB::table('member')
                ->where('mem_id', $client->recl_client_id)
                ->value('mem_name as chun_unit_name');
        } else {
            $find_recede->recl_channel_unit = DB::table('channel_unit')
                ->where('chun_id', $client->recl_client_id)
                ->value('chun_unit_name');
        }
        unset($client->recl_client_id);
        $find_recede->recl_name = $client->recl_name;
        $find_recede->recl_phone = $client->recl_phone;
        // 查询出仓库名称
        $find_recede->ware_name = DB::table('warehouse')
            ->where('ware_id', $find_recede->rec_ware_id)
            ->value('ware_name');

        $find_goods = DB::table('recede_goods as rego')
            ->leftjoin('goods as goo', 'goo.goo_id', '=', 'rego.rego_goo_id')
            ->where('rego_rec_id', $request['rec_id'])
            ->select('rego_goo_id as goo_id', 'goo_name', 'rego_goo_goods_encode as goo_goods_encode', 'rego_goo_price as goo_price', 'rego_sell_number as goo_amount', 'rego_recycle_number as goo_recycle_amount', 'rego_fine_quantity', 'rego_priority_quantity', 'rego_unchecked_quantity', 'goo_type', 'goo_bra_name', 'goo_brse_id', 'goo_class', 'rego_wafr_id', 'rego_goo_inventory', 'rego_waon_class', 'rego_id', 'rego_goo_unit', 'rego_goo_unta_id', 'goo_unit_conversion')
            ->get()->toArray();
        // 查询系列数据
        $goo_brse_id = array_column($find_goods, 'goo_brse_id');
        $brse_data = DB::table('brand_serie')
            ->whereIn('brse_id', $goo_brse_id)
            ->pluck('brse_name', 'brse_id')
            ->toArray();
        foreach ($find_goods as $key => $value) {
            $find_wfog_data = DB::table('warehouse_freight_outin_goods as w')
                ->leftJoin('warehouse_freight as wf', 'w.wfog_wafr_id', '=', 'wf.wafr_id')
                ->where('wfog_original_id', $request['rec_id'])
                ->where('wfog_outin_type', 2)
                ->where('wfog_primary_id', $value->rego_id)
                ->select('wfog_wafr_id', 'wfog_stock_amount as goo_recycle_amount', 'wafr_name as rego_wafr_name', 'wfog_stock_type as rego_goo_inventory')
                ->get()->toArray();
            $find_wfog_data = json_decode(json_encode($find_wfog_data, true), true);
            if ($find_wfog_data) {
                $find_goods[$key]->rego_wafr_data = $find_wfog_data;
            } else {
                $ware_name = DB::table('warehouse')
                    ->where('ware_id', $find_recede->rec_ware_id)
                    ->value('ware_name');
                $new_data['goo_recycle_amount'] = $value->goo_recycle_amount;
                $new_data['rego_goo_inventory'] = $value->rego_goo_inventory;
                $new_data['rego_wafr_name'] = $ware_name;
                $find_goods[$key]->rego_wafr_data[] = $new_data;
            }
            // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                if (!empty($value->goo_brse_id)) {
                    if ($value->goo_class == 2) {
                        $find_goods[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $find_goods[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                        }
                    }
                }
            }
            // 显示品牌名称
            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                if ($value->goo_class == 2) {
                    $find_goods[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                } else {
                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                        $find_goods[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                    }
                }
            }
            unset($find_goods[$key]->goo_brse_id);
            unset($find_goods[$key]->goo_class);
        }
        $list_button = getAppletListButton($request['api_token'], $request['pri_id']);
        $recycle = false;
        foreach ($list_button as $key_b => $value_b) {
            if ($value_b['pri_operate_method'] == 'recycle' && $value_b['have_pri'] == 1) {
                $recycle = true;
            }
        }
        if($find_recede->rec_state == 1 && $recycle){
            $find_recede->is_can_recycle = 1;
        } else {
            $find_recede->is_can_recycle = 2;
        }
        $data['goods_data'] = $find_goods;
        $data['recede_data'] = $find_recede;
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 获取字段数据
    public static function getFieldsById($id, $fields = '*', $shopID = 0)
    {
        $entity = WashOrder::where('ord_id', $id)
            ->where('ord_shop_id', $shopID)
            ->select($fields)
            ->first();

        return $entity;
    }
}
