<?php

namespace App\Services\Business;

use App\Models\Business\OrderSettlementDetails;
use App\Services\CommonService;
use Illuminate\Support\Facades\Request;
use App\Models\Business\WashOrder;
use BlueCity\Core\Service\Service;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\Business\WashOrderValidator;
use BlueCity\Core\Inc\ErrorInc;
use App\Http\Models\Api\DispatchBill;
use App\Services\WeChatApplet\User\MemberCarService;
use App\Http\Models\Api\CashierDesk;
use App\Services\ReceivablePay\ReceivablePayService;
use App\Services\Business\WashOrderService;
use App\Services\WeChatApplet\Technician\MemberService;
use App\Services\Business\NewOrderService;
use App\Services\Point\PointService;
use App\Services\WeChatApplet\user\MemberLevelService;

// 美装基础版
class WashOrderBasicService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new WashOrder();
        $this->mainValidator = new WashOrderValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 生成订单
     * @authors ldj
     * @date   2023-07-03
     * @param  [type]     $user_info [用户信息]
     * @param  [type]     $request   [请求参数]
     */
    public static function add($user_info, $request)
    {
        if (empty($request['ord_unique_string'])) {
            return ['code' => ErrorInc::FAILED_PARAM, 'msg' => '生成订单验证密钥未提交，请刷新页面或重新登录系统！', 'data' => ''];
        }
        // 判断唯一标识是否存在
        $find_unique = DB::table('order')
            ->where('ord_unique_string', $request['ord_unique_string'])
            ->value('ord_unique_string');
        if ($find_unique) {
            return ['code' => ErrorInc::DATA_EXIST, 'msg' => '当前订单已提交，请勿重复操作！', 'data' => ''];
        }
        if (!isset($request['mem_id']) || empty($request['mem_id'])) {
            $request['mem_id'] = $request['ord_client_id'];
        }
        // 如果有预约时间，则判断是否超出限制预约数量；
        if (isset($request['orcl_appoint_time'])) {

            $resenum_date=substr($request['orcl_appoint_time'],0,10);

            $jud_res=WashWorkService::judgmentShopReser($user_info,$resenum_date,'',$request);

            if($jud_res['code'] != 200) return $jud_res;
        }
        // 商品 整理使用会员卡的数据
        $goods_data = json_decode($request['goods_data'], true);
        if (empty($goods_data)) {
            return ['code' => 500, 'msg' => '请选择服务', 'data' => ''];
        }
        $new_goods_data_one = [];
        foreach ($goods_data as $key => $value) {
            if (isset($new_goods_data_one[$value['goo_id']])) {
                $new_goods_data_one[$value['goo_id']]['goo_quantity'] += $value['goo_quantity'];
                if (!isset($value['use_num'])) {
                    $value['use_num'] = 0;
                }
                if (!isset($new_goods_data_one[$value['goo_id']]['use_num'])) {
                    $new_goods_data_one[$value['goo_id']]['use_num'] = 0;
                }
                $new_goods_data_one[$value['goo_id']]['use_num'] += $value['use_num'];
            } else {
                $new_goods_data_one[$value['goo_id']] = $value;
            }
        }
        $goods_data = [];
        foreach ($new_goods_data_one as $key => $value) {
            $goods_data[] = $value; 
        }
        if ($request['ord_payment_way'] == 5) {//使用会员卡结算
            if (!isset($request['myvi_id']) && empty($request['myvi_id'])) {
                return ['code' => 500, 'msg' => '请选择会员卡', 'data' => ''];
            }
            $vip_data = DB::table('myvip_detail')
                ->where('myvid_mvid', $request['myvi_id'])
                ->get()->toArray();
            $ord_goods_quantity = 0;
            foreach ($goods_data as $key => $value) {
                if (!isset($value['use_num'])) {
                    $value['use_num'] = 0;
                    $goods_data[$key]['use_num'] = 0;
                }
                $ord_goods_quantity += $value['goo_quantity'];
                $goods_data[$key]['use_vip_num'] = 0;
                $goods_data[$key]['use_vip_price'] = 0;
                foreach ($vip_data as $k => $v) {
                    if ($value['goo_type'] == $v->myvid_type && $value['goo_id'] == $v->myvid_data_id) {
                        $goods_data[$key]['myvid_surplus_times'] = $v->myvid_surplus_times;
                        if ($value['goo_quantity'] <= $v->myvid_surplus_times) {
                            $goods_data[$key]['use_vip_num'] = $value['goo_quantity'];
                        } else {
                            $goods_data[$key]['use_vip_num'] = $v->myvid_surplus_times;
                        }
                        $goods_data[$key]['use_vip_price'] = $value['goo_price'];
                        $goods_data[$key]['myvid_id'] = $v->myvid_id;
                        if ($v->myvid_surplus_times < $value['use_num']) {
                            return ["code"=>500, 'msg'=>'会员卡剩余次数不足', 'data'=>'会员卡剩余次数不足'];
                        }
                    }
                }
            }
        } else {
            foreach ($goods_data as $key => $value) {
                $goods_data[$key]['use_vip_num'] = 0;
                $goods_data[$key]['use_vip_price'] = 0;
            }
        }
        // 计算金额
        $order_amount = 0;//实际需支付的现金金额
        $ord_use_vip_price = 0;//用会员卡支付的金额
        $use_vip_allnum = 0;//使用会员卡项目次数
        foreach ($goods_data as $key => $value) {
            if ($request['ord_payment_way'] ==5) {
                $ord_use_vip_price += $value['use_vip_price']*$value['use_vip_num'];
                $use_vip_allnum+=$value['use_vip_num'];
            }
            $order_amount+=($value['goo_price']*($value['goo_quantity'] - $value['use_vip_num']));//实际需要支付金额
        }
        $ord_order_price = $ord_use_vip_price + $order_amount;
        // 订单单号
        $ord_order_number = Common::numberRule($user_info, 1);

        $data['ord_cid'] = $user_info->adm_cid;
        $data['ord_superior_shop_id'] = $user_info->adm_shop_id;
        $data['ord_shop_id'] = $user_info->adm_shop_id;
        $data['ord_create_id'] = $user_info->adm_id;
        $data['ord_client_id'] = isset($request['ord_client_id']) ? $request['ord_client_id'] : 0;
        $data['ord_ware_id'] = $request['ware_id'] ? $request['ware_id'] : '';
        if ($request['ord_address_type'] == 1) { //本店
            $ord_address = DB::table('shop')
                ->where('shop_id', $request['ord_address_id'])
                ->value('shop_store_name');
            if ($request['ord_address'] != ($ord_address . '(本店)')) {
                return ['code' => ErrorInc::REQUEST_INAPTNESS, 'msg' => '施工门店错误1', 'data' => ''];
            }
        } elseif ($request['ord_address_type'] == 2) { //合作商
            $ord_address = DB::table('business_client')
                ->where('bucl_id', $request['ord_address_id'])
                ->value('bucl_name');
            if ($request['ord_address'] != $ord_address) {
                return ['code' => ErrorInc::REQUEST_INAPTNESS, 'msg' => '施工门店错误', 'data' => ''];
            }
        } elseif ($request['ord_address_type'] == 3) { //分店
            $ord_address = DB::table('shop')
                ->where('shop_id', $request['ord_address_id'])
                ->value('shop_store_name');
        }
        $request['ord_type'] = isset($request['ord_type']) ? $request['ord_type'] : 0;
        $data['ord_address'] = $request['ord_address'];
        $data['ord_address_id'] = $request['ord_address_id'];
        $data['ord_address_type'] = $request['ord_address_type'];
        $data['ord_new_type'] = $request['ord_new_type'];
        $data['ord_order_number'] = $ord_order_number;
        $data['ord_type'] = $request['ord_type']; //买家类型：0散户1门店零售2企业客户
        $data['ord_service_type'] = 1; //订单类型：1服务单 2洗车单3商品单4会员卡
        $data['ord_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['ord_is_split'] = 1; //订单拆分1正常单服务订单2多服务分订单3多服务总订单
        $data['ord_payment_way'] = $request['ord_payment_way']; //结算方式结算方式1现金、2支付宝、3微信、4银行卡5会员卡
        $data['ord_service_adm_id'] = isset($request['ord_service_adm_id']) ? $request['ord_service_adm_id'] : ''; //服务技师
        if (empty($request['ord_payment_way']) || $request['ord_payment_way'] == 8) {//结算状态暂不结算
            $data['ord_state'] = 1; //结算状态1未结算2已结算
            $data['ord_pay_state'] = 2; //是否支付1是2否
        } elseif (in_array($request['ord_payment_way'], [1,2,3,4,6,7])) {//全部结算
            $data['ord_state'] = 2; //结算状态1未结算2已结算
            $data['ord_pay_state'] = 1; //是否支付1是2否
            $data['ord_settlement_time'] = date('Y-m-d H:i:s'); //结算状态1未结算2已结算
            $data['ord_settlement_adm_id'] = $user_info->adm_id; //结算人
        } elseif (in_array($request['ord_payment_way'], [5])) {//会员卡
            if ($order_amount > 0) {//除了会员卡还有其他未结算的商品
                if (in_array($request['ord_other_payway'],[1,2,3,4])) {//其他支付方式为现金的
                    $data['ord_state'] = 2; //结算状态1未结算2已结算
                } elseif(in_array($request['ord_other_payway'],[6,7])) {//其他支付方式为余额

                }
            }
            if ($request['ord_actual_price'] == $order_amount) {
                $data['ord_state'] = 2; //结算状态1未结算2已结算
            }
            $data['ord_pay_state'] = 1; //是否支付1是2否
            $data['ord_settlement_time'] = date('Y-m-d H:i:s'); //结算状态1未结算2已结算
            $data['ord_settlement_adm_id'] = $user_info->adm_id; //结算人
        } elseif ($request['ord_payment_way'] == 9) {
            $data['ord_state'] = 3; //结算状态1未结算2已结算3部分结算
            $data['ord_pay_state'] = 1; //是否支付1是2否
            $data['ord_settlement_time'] = date('Y-m-d H:i:s'); //结算状态1未结算2已结算
            $data['ord_settlement_adm_id'] = $user_info->adm_id; //结算人
        }
        $data['ord_source'] = static::getOrdsource($request);  // 来源  1 pc  2 车主小程序   3 技师
        $data['ord_update_time'] = date('Y-m-d H:i:s');
        $data['ord_unique_string'] = $request['ord_unique_string'];
        $data['ord_explain'] = !empty($request['ord_explain']) ? $request['ord_explain'] : '';
        // $ord_id = WashOrder::insertGetId($data);
        $ord_id = NewOrderService::newOrder($data);
        
        // 施工说明图片
        if (isset($request['ord_explain_pic']) && !empty($request['ord_explain_pic'])) {
            foreach ($request['ord_explain_pic'] as $key => $value) {
                $add_pic[$key]['orvp_image'] = $value;
                $add_pic[$key]['orvp_type'] = 2;
                $add_pic[$key]['orvp_ord_id'] = $ord_id;
                $add_pic[$key]['orvp_create_time'] = date('Y-m-d H:i:s');
                $add_pic[$key]['orvp_create_id'] = $user_info->adm_id;
                $add_pic[$key]['orvp_create_name'] = $user_info->adm_name;
            }
            $add_pic_res = DB::table('order_voucher_pic')->insert($add_pic);
        }
        // 订单凭证图片
        if (isset($request['ord_pic']) && !empty($request['ord_pic'])) {
            foreach ($request['ord_pic'] as $key => $value) {
                $add_pz_pic[$key]['orvp_image'] = $value;
                $add_pz_pic[$key]['orvp_type'] = 1;
                $add_pz_pic[$key]['orvp_ord_id'] = $ord_id;
                $add_pz_pic[$key]['orvp_create_time'] = date('Y-m-d H:i:s');
                $add_pz_pic[$key]['orvp_create_id'] = $user_info->adm_id;
                $add_pz_pic[$key]['orvp_create_name'] = $user_info->adm_name;
            }
            $add_pz_pic_res = DB::table('order_voucher_pic')->insert($add_pz_pic);
        }
        if (!empty($request['orcl_phone'])) {
            // 查询手机号是否存在
            $find_weixin_data = DB::table('user_shop')
                ->leftJoin('weixin_user','ussh_weus_id', '=', 'weus_id')
                ->where('ussh_phone', $request['orcl_phone'])
                ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
                ->first();
            if ($find_weixin_data) {
                $weus_id = $find_weixin_data->weus_id;
            } else {
                $weus_id = 0;
            }
        } else {
            $weus_id = 0;
        }

        // 选择的客户id
        if ($request['ord_type'] != 0 && empty($request['ord_client_id'])) {
            if ($request['ord_type'] == 2) { //买家类型：2企业客户
                // 1. 判断企业客户账号名称是否存在
                $find_buac = DB::table('business_account')
                    ->where('buac_bucl_id', $request['orcl_business_id'])
                    ->where('buac_name', $request['orcl_name'])
                    ->first(['buac_id']);
                if ($find_buac) {
                    return ['code' => 500, 'msg' => '客户名称已存在，生成订单失败', 'data' => ''];
                }

                // 2 新增一个企业会员账号
                $add_buac_data['buac_shop_id'] = $user_info->adm_shop_id;
                $add_buac_data['buac_cid'] = $user_info->adm_cid;
                $add_buac_data['buac_name'] = $request['orcl_name'];
                $add_buac_data['buac_phone'] = $request['orcl_phone'];
                $add_buac_data['buac_bucl_id'] = $request['orcl_business_id'];
                $add_buac_data['buac_create_adm_id'] = $user_info->adm_id;
                $add_buac_data['buac_create_time'] = date('Y-m-d H:i:s');
                $buac_res =  DB::table('business_account')->insertGetId($add_buac_data);
                $request['ord_client_id'] = $buac_res;
                //如果有省市区修改
                $find_buac_client = DB::table('business_client')
                    ->where('bucl_id', $request['orcl_business_id'])
                    ->first();
                if(empty($find_buac_client->bucl_province) && empty($find_buac_client->bucl_city) && empty($find_buac_client->ucl_county) && empty($find_buac_client->bucl_address)  && $request['orcl_province'] && $request['orcl_city'] && $request['orcl_county'] && $request['orcl_address']){
                    $bucl_data['bucl_province'] = isset($request['orcl_province']) ? $request['orcl_province'] : '';//省
                    $bucl_data['bucl_city'] = isset($request['orcl_city']) ? $request['orcl_city'] : '';//市
                    $bucl_data['bucl_county'] = isset($request['orcl_county']) ? $request['orcl_county'] : '';//区
                    $bucl_data['bucl_address'] = isset($request['orcl_address']) ? $request['orcl_address'] : '';//地址
                    $mem_id = DB::table('business_client')->where('bucl_id',  $request['orcl_business_id'])->update($bucl_data);
                }
            } elseif ($request['ord_type'] == 1) {
                $eme['mem_cid'] = $user_info->adm_cid;
                $eme['mem_superior_shop_id'] = $user_info->adm_shop_id;
                $eme['mem_shop_id'] = $user_info->adm_shop_id;
                $eme['mem_create_id'] = $user_info->adm_id;
                $eme['mem_create_name'] = $user_info->adm_name;
                $eme['mem_name'] = isset($request['orcl_name']) ? $request['orcl_name'] : '';
                $eme['mem_bership'] = 2;
                $eme['mem_sex'] = 3;
                if (!empty($request['orcl_phone'])) {
                    $find_mem = DB::table('member')
                        ->where('mem_cid', $user_info->adm_cid)
                        ->where('mem_shop_id', $user_info->adm_shop_id)
                        ->where('mem_phone', $request['orcl_phone'])
                        ->first(['mem_id']);
                    if ($find_mem) {
                        return ["code" => 500, 'msg' => '当前手机号已存在', 'data' => '当前手机号已存在'];
                    }
                }
                $mem_fid = 0;
                if ($request['mem_fphone']) {
                    $mem_fid = DB::table('member')
                        ->where('mem_shop_id', $user_info->adm_shop_id)
                        ->where('mem_phone', $request['mem_fphone'])
                        ->value('mem_id');
                    if (!$mem_fid) {
                        return ['code' => 500, 'msg' => '未查询到该邀请人', 'data' => ''];
                    }
                    
                }
                $eme['mem_phone'] = isset($request['orcl_phone']) ? $request['orcl_phone'] : '';
                $eme['mem_source'] = isset($request['orcl_mem_source']) ? $request['orcl_mem_source'] : ''; //来源
                $eme['mem_car_num'] = isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '';
                $eme['mem_province'] = isset($request['orcl_province']) ? $request['orcl_province'] : '';//省
                $eme['mem_city'] = isset($request['orcl_city']) ? $request['orcl_city'] : '';//市
                $eme['mem_county'] = isset($request['orcl_county']) ? $request['orcl_county'] : '';//区
                $eme['mem_address'] = isset($request['orcl_address']) ? $request['orcl_address'] : '';//地址
                $eme['mem_fid'] = $mem_fid;//分享人
                // $mem_id = DB::table('member')->insertGetId($eme);
                $mem_id = MemberService::addMember($eme);
                if ($mem_fid) {
                    $add_data_bind['bilo_shop_id'] = $user_info->adm_shop_id;
                    $add_data_bind['bilo_Inviter_id'] = $mem_fid;
                    $add_data_bind['bilo_Invitee_id'] = $mem_id;
                    $add_data_bind['bilo_state'] = 1;
                    $add_data_bind['bilo_create_time'] = date('Y-m-d H:i:s');
                    $add_data_bind['bilo_update_time'] = date('Y-m-d H:i:s');
                    $add_res = DB::table('bind_log')->insertGetId($add_data_bind);
                }
                WashOrderService::addFestival($mem_id,$user_info);//新增节日提醒
                if (!$mem_id) {
                    return ['code' => 500, 'msg' => '新增会员失败', 'data' => '新增会员失败'];
                }
                $request['ord_client_id'] = $mem_id;

                if (isset($request['orcl_phone'])) {
                    if (empty($find_weixin_data)) {
                        // // 不存在就新增用户
                        // $weus_data['weus_openid'] = $mem_id;
                        // $weus_data['weus_phone'] = $request['orcl_phone'];
                        // $weus_data['weus_nickmame'] = $request['orcl_name'];
                        // $weus_data['weus_follow'] = 1;
                        // $weus_data['weus_sex'] = 0;
                        // $weus_data['weus_province'] = '';
                        // $weus_data['weus_city'] = '';
                        // $weus_data['weus_headimgurl'] = '';
                        // $weus_data['weus_update_time'] = date('Y-m-d H:i:s');
                        // $weus_id = DB::table('weixin_user')->insertGetId($weus_data);
                        // if (!$weus_id) {
                        //     return ['code' => 500, 'msg' => '新增失败', 'data' => ''];
                        // }
                        $weus_id = false;
                        // unset($weus_data['weus_update_time']);
                    } else {
                        // 更新微信用户信息
                        $edit_weus['weus_phone'] = $request['orcl_phone'];
                        $edit_weus['weus_nickmame'] = $request['orcl_name'];
                        if (!empty($request['weus_headimgurl'])) {
                            $edit_weus['weus_headimgurl'] = $request['weus_headimgurl'];
                        }
                        $edit_weus['weus_update_time'] = date('Y-m-d H:i:s');
                        $edit_weus_res = DB::table('weixin_user')
                            ->where('weus_id', $find_weixin_data->weus_id)
                            ->update($edit_weus);
                        unset($edit_weus);
                        $weus_id = $find_weixin_data->weus_id;
                    }
                } else {
                    $weus_id = false;
                }
                // if (isset($request['orcl_phone'])) {
                //     // 查询微信用户与门店的关系是否存在绑定关系
                //     $find_user_shop_data = DB::table('user_shop')
                //         ->where('ussh_weus_id', $weus_id)
                //         ->where('ussh_shop_id', $user_info->adm_shop_id)
                //         ->select('ussh_id', 'ussh_user_id', 'ussh_user_type', 'ussh_phone')
                //         ->first();
                //     if (empty($find_user_shop_data) && $weus_id) {
                //         // 用户没有与当前门店绑定，把用户与当前门店绑定
                //         $ussh_data['ussh_user_id'] = $mem_id;
                //         $ussh_data['ussh_weus_id'] = $weus_id;
                //         $ussh_data['ussh_shop_id'] = $user_info->adm_shop_id;
                //         $ussh_data['ussh_user_type'] = 1;
                //         $ussh_data['ussh_phone'] = $request['orcl_phone'];
                //         $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
                //         $ussh_data['ussh_register_time'] = date('Y-m-d H:i:s');
                //         $ussh_id = DB::table('user_shop')->insertGetId($ussh_data);
                //         if (!$ussh_id) {
                //             return ['code' => 500, 'msg' => '新增失败2', 'data' => ''];
                //         }
                //     } else {
                //         if (empty($find_user_shop_data->ussh_user_id)) {
                //             $ussh_data['ussh_user_type'] = 1;
                //             $ussh_data['ussh_phone'] = $request['orcl_phone'];
                //             $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
                //             $ussh_id = DB::table('user_shop')
                //                 ->where('ussh_id', $find_user_shop_data->ussh_id)
                //                 ->update($ussh_data);
                //         }
                //     }
                // }
            }
        }else{
            if($request['ord_type'] == 1 && !empty($request['ord_client_id'])){
                $find_mem_data = DB::table('member')
                    ->where('mem_cid', $user_info->adm_cid)
                    ->where('mem_shop_id', $user_info->adm_shop_id)
                    ->where('mem_id', $request['ord_client_id'])
                    ->first();
                if(empty($find_mem_data->mem_province) && empty($find_mem_data->mem_city) && empty($find_mem_data->mem_county) && empty($find_mem_data->mem_address)){
                    $eme['mem_province'] = $request['orcl_province']??'';//省
                    $eme['mem_city'] = $request['orcl_city']??'';//市
                    $eme['mem_county'] = $request['orcl_county']??'';//区
                    $eme['mem_address'] = $request['orcl_address']??'';//地址
                    $mem_id = DB::table('member')->where('mem_id',  $request['ord_client_id'])->update($eme);
                }
            }else if($request['ord_type'] == 2 && isset($request['orcl_business_id']) && !empty($request['orcl_business_id'])){
                $find_buac_client = DB::table('business_client')
                    ->where('bucl_id', $request['orcl_business_id'])
                    ->first();
                if(empty($find_buac_client->bucl_province) && empty($find_buac_client->bucl_city) && empty($find_buac_client->ucl_county) && empty($find_buac_client->bucl_address) && isset($request['orcl_province'])  && $request['orcl_province'] && isset($request['orcl_city']) && $request['orcl_city'] && isset($request['orcl_county']) && $request['orcl_county'] && isset($request['orcl_address']) && $request['orcl_address']){
                    //如果有省市区修改
                    $bucl_data['bucl_province'] = isset($request['orcl_province']) ? $request['orcl_province'] : '';//省
                    $bucl_data['bucl_city'] = isset($request['orcl_city']) ? $request['orcl_city'] : '';//市
                    $bucl_data['bucl_county'] = isset($request['orcl_county']) ? $request['orcl_county'] : '';//区
                    $bucl_data['bucl_address'] = isset($request['orcl_address']) ? $request['orcl_address'] : '';//地址
                    $mem_id = DB::table('business_client')->where('bucl_id',  $request['orcl_business_id'])->update($bucl_data);
                }
            }
        }

        if (!empty($request['orcl_car_num'])) {
            $isCarLicense = isCarLicense($request['orcl_car_num']); // 正则判断车牌号格式
            if (!$isCarLicense) {
                return ['code' => 500, 'msg' => '车牌照格式不正确', 'data' => ''];
            }
        }
        $mem_address = [];
        if($request['ord_type'] == 1 && !empty($request['ord_client_id'])){
            $mem_address = DB::table('member')
                ->where('mem_id', $request['ord_client_id'])
                ->select('mem_province', 'mem_city', 'mem_county','mem_address')
                ->first();
        }else if($request['ord_type'] == 2 && isset($request['orcl_business_id']) && !empty($request['orcl_business_id'])){
            $mem_address = DB::table('business_client')
                ->where('bucl_id', $request['orcl_business_id'])
                ->select('bucl_province as mem_province','bucl_city as mem_city','bucl_county as mem_county','bucl_address as mem_address')
                ->first();
        }
        if(!empty($mem_address)){
            $mem_province = isset($request['orcl_province']) ? $request['orcl_province'] : $mem_address->mem_province;
            $mem_city = isset($request['orcl_city']) ? $request['orcl_city'] : $mem_address->mem_city;
            $mem_county = isset($request['orcl_county']) ? $request['orcl_county'] : $mem_address->mem_county;
            $orcl_address = isset($request['orcl_address']) ? $request['orcl_address'] : $mem_address->mem_address;
        }else{
            $mem_province = isset($request['orcl_province'])??'';
            $mem_city = isset($request['orcl_city'])??'';
            $mem_county = isset($request['orcl_county'])??'';
            $orcl_address = isset($request['orcl_address'])??'';
        }
        if ($request['orcl_sales_adm_id']) {
            $find_adm = DB::table('admin')->where('adm_id', $request['orcl_sales_adm_id'])->value('adm_name');
        } else {
            $find_adm = '';
        }
        // 添加订单客户表数据
        $orcl_data = [
            'orcl_ord_id' => $ord_id,
            'orcl_client_id' => isset($request['ord_client_id']) ? $request['ord_client_id'] : 0, //选择客户id
            'orcl_sales_adm_id' => isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : '', // 销售人员id
            'orcl_sales_adm_name' => $find_adm ? $find_adm : '', // 销售人员
            'orcl_business_name' => isset($request['orcl_business_name']) ? $request['orcl_business_name'] : '', //企业名称
            'orcl_business_id' => isset($request['orcl_business_id']) ? $request['orcl_business_id'] : '', //企业id
            'orcl_name' => isset($request['orcl_name']) ? $request['orcl_name'] : '散户',
            'orcl_phone' => isset($request['orcl_phone']) ? $request['orcl_phone'] : '',
            'orcl_carowner_name' => isset($request['orcl_carowner_name']) ? $request['orcl_carowner_name'] : '散户',
            'orcl_carowner_phone' => isset($request['orcl_carowner_phone']) ? $request['orcl_carowner_phone'] : '',
            'orcl_car_num' => isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '',
            'orcl_pick_up_car_adm_id' => isset($request['orcl_pick_up_car_adm_id']) ? $request['orcl_pick_up_car_adm_id'] : 0, //接车人id
            'orcl_car_vin' => isset($request['orcl_car_vin']) ? $request['orcl_car_vin'] : '', //车架号 车辆识别码
            'orcl_car_brand_series' => isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : '', //品牌车系
            'orcl_carbrse_type' => isset($request['orcl_carbrse_type']) ? $request['orcl_carbrse_type'] : 1, //品牌车系分类
            'orcl_mem_source' => isset($request['orcl_mem_source']) ? $request['orcl_mem_source'] : '', //客户来源
            'orcl_update_time' => date('Y-m-d H:i:s'),
            'orcl_province' => $mem_province,
            'orcl_city' => $mem_city,
            'orcl_county' => $mem_county,
            'orcl_address' => $orcl_address,
        ];
        $ord_actual_price = $order_amount*100;
        if (!empty($request['orcl_car_num']) && $request['ord_type'] == 1 && !empty($request['ord_client_id'])) {
            $request['shop_id'] = $user_info->adm_shop_id;
            $request['weus_id'] = DB::table('user_shop')
                ->where('ussh_user_id', $request['ord_client_id'])
                ->where('ussh_shop_id', $user_info->adm_shop_id)
                ->value('ussh_weus_id');
            $request['meca_car_num'] = $request['orcl_car_num'];
            $request['meca_car_brand_series'] = isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : ''; //品牌车系
            $request['meca_car_frame'] = isset($request['orcl_car_vin']) ? $request['orcl_car_vin'] : '';
            $exist = MemberCarService::nameExists($request['meca_car_num'], $request['shop_id'], $request['weus_id']);
            if (!$exist) {
                $meca_data['meca_cid'] = $user_info->adm_cid;
                $meca_data['meca_superior_shop_id'] = $user_info->shop_superior_id;
                $meca_data['meca_mem_id'] = $request['ord_client_id'];
                $meca_data['meca_shop_id'] = $request['shop_id'];
                $meca_data['meca_car_num'] = $request['meca_car_num'];
                if (!empty($request['meca_car_brand_series'])) {//品牌车系
                    $meca_data['meca_car_brand_series'] = $request['meca_car_brand_series'];
                }
                if (!empty($request['meca_car_frame'])) {//车架号
                    $meca_data['meca_car_frame'] = $request['meca_car_frame'];
                } else {
                    $meca_data['meca_car_frame'] = '';
                }
                $meca_data['meca_update_time'] = date('Y-m-d H:i:s');
                $return_car_data = DB::table('member_car')->insert($meca_data);
                // $return_car_data = MemberCarService::add($request);
            } else {
                $return_car_data = true;
            }
        } else {
            $return_car_data = true;
        }
        // 预约时间
        if (isset($request['orcl_appoint_time'])) {
            $orcl_data['orcl_appoint_time'] = $request['orcl_appoint_time'];
        }
        $orcl_id = DB::table('order_client')->insertGetId($orcl_data);

        $sepr_id = '';
        $is_goods = false;//是否有产品
        $only_goods = false;//是否只有产品
        $ord_add_work_state = 2;//是否生成工单1是2否
        //$orgo_is_mem_price = $request['orgo_is_mem_price']??2;
        if (!empty($goods_data)) {
            $goo_type = array_column($goods_data, 'goo_type');
            if (in_array(1, $goo_type)) {
                $is_goods = true;
            }
            if (!in_array(2, $goo_type)) {
                $only_goods = true;
            }
            $sepr_work_type = array_column($goods_data, 'sepr_work_type');
            if (in_array(1, $sepr_work_type)) {//是否生成工单
                $ord_add_work_state = 1;
            }
            $goo_all_price = 0; //商品总金额
            $goo_all_quantity = 0; //商品总数量
            $new_goo_all_quantity = 0;
            $sepr_name = '';
            $goo_id = '';
            $goo_name = '';
            $goods_data_count = count($goods_data);
            // 新增订单商品数据
            foreach ($goods_data as $key => $value) {
                if ($value['goo_type'] == 2) {//服务类商品
                    if ($sepr_id) {
                        $sepr_id = $sepr_id . $value['goo_id'] . ',';
                        $sepr_name = $sepr_name . ',' . $value['goo_name'];
                    } else {
                        $sepr_id = ',' . $value['goo_id'] . ',';
                        $sepr_name = $value['goo_name'];
                    }
                    $image_id = [];//根据服务项目确定需要上传的图片
                    $sepr_image = DB::table('sepr_img')
                        ->where('seim_sepr_id', $value['goo_id'])
                        ->select('seim_imco_id')
                        ->get()->toArray();
                    if (!empty($sepr_image)) {
                        foreach ($sepr_image as $ks => $vs) {
                            if (!in_array($vs->seim_imco_id, $image_id)) {
                                $image_id[] = $vs->seim_imco_id;
                            }
                        }
                    }
                } elseif ($value['goo_type'] == 1) {
                    $goo_unit_conversion = DB::table('goods')
                        ->where('goo_id', $value['goo_id'])
                        ->value('goo_unit_conversion');
                    if ($goo_id) {
                        $goo_id = $goo_id . $value['goo_id'] . ',';
                    } else {
                        $goo_id = ',' . $value['goo_id'] . ',';
                    }
                    if ($goo_name) {
                        $goo_name = $goo_name . ',' . $value['goo_name'] . '*' . $value['goo_quantity'] . $value['goo_unit'];
                    } else {
                        $goo_name = $value['goo_name'] . '*' . $value['goo_quantity'] . $value['goo_unit'];
                    }
                }
                if (!isset($value['goo_waon_class'])) {
                    $value['goo_waon_class'] = 1;
                    $goods_data[$key]['goo_waon_class'] = 1;
                }
                if (!isset($value['goo_type'])) {
                    $value['goo_type'] = 1;
                    $goods_data[$key]['goo_type'] = 1;
                }
                if (!isset($value['goo_inventory'])) {
                    $value['goo_inventory'] = 1;
                    $goods_data[$key]['goo_inventory'] = 1;
                }
                if (!isset($value['wago_id']) && $value['goo_type'] == 1) {
                    $find_wago_id = DB::table('warehouse_goods')
                        ->where('wago_goo_id', $value['goo_id'])
                        ->where('wago_class', $value['goo_waon_class'])
                        ->where('wago_ware_id', $request['ware_id'])
                        ->value('wago_id');
                    if (!$find_wago_id && $request['ware_id']) {
                        return ['code' => 500, 'msg' => '仓库库存不足', 'data' => '仓库库存不足'];
                    }
                    $value['wago_id'] = $find_wago_id;
                    $goods_data[$key]['wago_id'] = $find_wago_id;
                } elseif (!isset($value['wago_id']) && $value['goo_type'] == 2) {
                    $value['wago_id'] = 0;
                    $goods_data[$key]['wago_id'] = 0;
                }
                if(isset($value['wago_id']) && $value['goo_type'] == 1){
                    $find_wago_price = DB::table('warehouse_goods')
                        ->where('wago_goo_id', $value['goo_id'])
                        ->where('wago_class', $value['goo_waon_class'])
                        ->where('wago_ware_id', $request['ware_id'])
                        ->where('wago_id', $value['wago_id'])
                        ->value('wago_goo_price');
                    $goods_price[$value['wago_id']]['price'] = $find_wago_price;//商品成本价
                    $goods_price[$value['wago_id']]['quantity'] = $value['goo_quantity'];//商品数量
                }
                if (!empty($value['goo_id'])) {
                    if (empty($value['goo_id'])  || $value['goo_quantity'] < 0  || !is_numeric($value['goo_id']) || !in_array($value['goo_state'], [1, 2]) || !is_numeric($value['goo_quantity'])) {
                        return ['code' => 500, 'msg' => 'error', 'data' => '请完善服务信息02'];
                    }
                    $orgo_data['orgo_ord_id'] = $ord_id;
                    $orgo_data['orgo_order_number'] = $ord_order_number;
                    $orgo_data['orgo_ware_id'] = isset($request['ware_id']) ? $request['ware_id'] : 0;
                    $orgo_data['orgo_wago_id'] = isset($value['wago_id']) ? $value['wago_id'] : 0;
                    $orgo_data['orgo_goo_id'] = $value['goo_id'];
                    $orgo_data['orgo_goo_name'] = $value['goo_name'];
                    $orgo_data['orgo_goo_type'] = $value['goo_type'];
                    if ($value['goo_type'] == 1) {
                        $goo_goods_encode = DB::table('goods')
                            ->where('goo_id', $value['goo_id'])
                            ->value('goo_goods_encode');
                        $orgo_data['orgo_goo_goods_encode'] = !empty($goo_goods_encode) ? $goo_goods_encode : '';
                    }
                    $orgo_data['orgo_goo_inventory'] = isset($request['goo_inventory']) ? $request['goo_inventory'] : 1;
                    $orgo_data['orgo_state'] = $value['goo_state'];
                    $orgo_data['orgo_goo_unit'] = $value['goo_unit'];
                    if ($value['goo_type'] == 2) {
                        $orgo_data['orgo_goo_unit'] = '个';
                    }
                    $orgo_data['orgo_goo_unta_id'] = $value['goo_unta_id'];
                    $orgo_data['orgo_goo_quantity'] = $value['goo_quantity'];
                    $orgo_data['orgo_goo_use_vip_num'] = $value['use_vip_num'];
                    $orgo_data['orgo_goo_price'] = $value['goo_price'] * 100;
                    $orgo_data['orgo_goo_amount'] = $value['goo_quantity']*$value['goo_price'] * 100;
                    $orgo_data['orgo_can_assign_quantity'] = $value['goo_quantity'];
                    // 查询商品积分
                    if ($value['goo_type'] == 1) {// 实物商品
                        $pogo_goo_type = 2;
                    } else {
                        $pogo_goo_type = 1;
                    }
                    $orgo_goo_point = DB::table('point_goods')  
                        ->where('pogo_shop_id', $user_info->adm_shop_id)
                        ->where('pogo_goo_type', $pogo_goo_type)
                        ->where('pogo_enable', 1)
                        ->where('pogo_goo_id', $value['goo_id'])
                        ->value('pogo_goo_point');
                    $orgo_data['orgo_goo_point'] = $orgo_goo_point;
                    $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
                    if (!empty($request['orcl_sales_adm_id'])) {
                        $gptype = DB::table('goods_performance_type')
                            ->where('gpt_shop_id', $user_info->adm_shop_id)
                            ->where('gpt_sale_adm_id', $request['orcl_sales_adm_id'])
                            ->where('gpt_state', 1)
                            ->where('gpt_type', 1)
                            ->first();
                        if ($gptype) {
                            $gppe_performance = DB::table('goods_performance')
                                ->where('gppe_shop_id', $user_info->adm_shop_id)
                                ->where('gppe_sale_id', $request['orcl_sales_adm_id'])
                                ->where('gppe_type', $orgo_data['orgo_goo_type'])
                                ->where('gppe_goo_id', $value['goo_id'])
                                ->value('gppe_performance');
                            $orgo_data['orgo_sale_performance'] = $gppe_performance??0;
                        } else {
                            $orgo_data['orgo_sale_performance'] = 0;
                        }
                    } else {
                        $orgo_data['orgo_sale_performance'] = 0;
                    }
                    //$orgo_data['orgo_is_mem_price'] = $orgo_is_mem_price;// 20231124  pc会员价格下单暂时屏蔽
                    $orgo_id = DB::table('order_goods')->insertGetId($orgo_data);
                    $goods_data[$key]['orgo_id'] = $orgo_id; //立即派单使用
                    if ($value['goo_type'] == 1) {//实物类
                        $value['orgo_id'] = $orgo_id;
                        $new_goods_data[] = $value;
                    }
                    if ($value['goo_quantity']) {
                        $goo_all_quantity += $value['goo_quantity']; //商品总数量
                        if ($value['goo_type'] == 1) {
                            $new_goo_all_quantity += $value['goo_quantity']; //商品总数量
                        }
                    }
                    $goo_unit_conversion = DB::table('goods')
                        ->where('goo_id', $value['goo_id'])
                        ->value('goo_unit_conversion');
                }
                $goo_all_price += $value['goo_price'] * $value['goo_quantity']; //商品总金额
            }
            if ($ord_add_work_state == 1) {
                $find_imco = DB::table('image_config')
                    ->where('imco_type', 1)
                    ->get()->toArray();
                foreach ($find_imco as $kf => $vf) {
                    $add_imdata['vaca_shop_id'] = $user_info->adm_shop_id;
                    $add_imdata['vaca_ord_id'] = $ord_id;
                    $add_imdata['vaca_type'] = 1;
                    $add_imdata['vaca_name'] = $vf->imco_name;
                    $add_imdata['vaca_data_id'] = $vf->imco_id;
                    if (in_array($vf->imco_id, $image_id)) {
                        $add_imdata['vaca_must'] = 1;
                    } else {
                        $add_imdata['vaca_must'] = 2;
                    }
                    $add_imdata['vaca_create_time'] = date('Y-m-d H:i:s');
                    $add_imdata['vaca_create_id'] = $user_info->adm_id;
                    $im_res = DB::table('wash_validate_car')->insert($add_imdata);
                }

                $find_com_img = DB::table('image_config')
                    ->where('imco_type', 2)
                    ->get()->toArray();
                foreach ($find_com_img as $kf => $vf) {
                    $add_comdata['coin_shop_id'] = $user_info->adm_shop_id;
                    $add_comdata['coin_ord_id'] = $ord_id;
                    $add_comdata['coin_type'] = 3;
                    $add_comdata['coin_name'] = $vf->imco_name;
                    $add_comdata['coin_data_id'] = $vf->imco_id;
                    $add_comdata['coin_create_time'] = date('Y-m-d H:i:s');
                    $add_comdata['coin_create_id'] = $user_info->adm_id;
                    if (in_array($vf->imco_id, $image_id)) {
                        $add_comdata['coin_must'] = 1;
                        $co_res = DB::table('completion_info')->insert($add_comdata);
                    }
                }
            }

            $ord_edit_data['ord_order_price'] = $ord_order_price * 100;
            $mem_points_multiple = 1;
            $mem_price = self::mem_price($request,$user_info);
            if($mem_price['code'] == 200){
                $mem_points_multiple = $mem_price['data']['meml_points_multiple'];
            }
            if (empty($request['ord_payment_way']) || $request['ord_payment_way'] == 8) {
                $ord_edit_data['ord_actual_price'] = 0;
            }
            if ($request['ord_payment_way'] != 9 && !empty($request['ord_payment_way']) && $request['ord_payment_way'] != 8) {
                $ord_edit_data['ord_actual_price'] = $order_amount * 100; //结算金额
            }
            // if ($request['ord_payment_way'] == 5) { //会员卡支付实付金额修改为0
            //     $ord_edit_data['ord_payment_money'] = $ord_use_vip_price*100;
            //     $ord_edit_data['ord_other_payway'] = $request['ord_other_payway'];
            //     $ord_edit_data['ord_banlance'] = 0;
            //     $ord_edit_data['ord_actual_price'] = $order_amount*100;
            //     $ord_edit_data['ord_zero_price'] = $ord_use_vip_price * 100;
            //     if ($order_amount > 0) {
            //         if ($request['ord_other_payway'] == 0 || $request['ord_other_payway'] ==5) {
            //             return ['code' => 500, 'msg' => '请选择其他支付方式', 'data' => ''];
            //         }
            //     }
            //     if ($request['ord_other_payway'] == 6 || $request['ord_other_payway'] ==7) {//余额 他人代付
            //         if ($request['ord_other_payway'] == 6) {
            //             $request['mem_id'] = $request['ord_client_id'];
            //         }
            //         $find_mem = DB::table('member')
            //             ->where('mem_id', $request['mem_id'])
            //             ->select('mem_id', 'mem_rec_banlance', 'mem_gift_banlance')
            //             ->first();
            //         $banlance = $find_mem->mem_rec_banlance + $find_mem->mem_gift_banlance;

            //         if (($request['ord_other_payway'] == 6 ||$request['ord_other_payway'] == 7) && $banlance == 0) {
            //             return ['code' => 500, 'msg' => '余额为0，请选择其他支付方式', 'data' => ''];
            //         }
            //         if ($ord_actual_price >= $banlance) {//余额不足
            //             return ['code' => 500, 'msg' => '余额不足，请添加其他支付方式', 'data' => ''];
            //         } elseif ($ord_actual_price < $banlance) {
            //             $ord_edit_data['ord_banlance'] = $ord_actual_price;
            //             // 消费记录
            //             $add_rec_log['relo_type'] = 2;
            //             if ($find_mem->mem_rec_banlance >= $ord_actual_price) {
            //                 $add_rec_log['relo_rec_num'] = $ord_actual_price;
            //                 $add_rec_log['relo_gift_num'] = 0;
            //                 $update_mem['mem_rec_banlance'] = $find_mem->mem_rec_banlance - $ord_actual_price;
            //             } else {
            //                 $add_rec_log['relo_rec_num'] = $find_mem->mem_rec_banlance;
            //                 $add_rec_log['relo_gift_num'] = $ord_actual_price - $find_mem->mem_rec_banlance;
            //                 $update_mem['mem_rec_banlance'] = 0;
            //                 $update_mem['mem_gift_banlance'] = $find_mem->mem_gift_banlance - ($ord_actual_price - $find_mem->mem_rec_banlance);
            //             }
            //             $add_rec_log['relo_mem_id'] = $request['mem_id'];
            //             $add_rec_log['relo_ord_id'] = $ord_id;
            //             $add_rec_log['relo_remark'] = '订单消费';
            //             $add_rec_log['relo_create_id'] = $user_info->adm_id;
            //             $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
            //             $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
            //         }
            //         $update_mem['mem_update_time'] = date('Y-m-d H:i:s');
            //         $update_mem_res = DB::table('member')->where('mem_id', $request['mem_id'])->update($update_mem);
            //         $request['ord_actual_amout'] = 0;//洗车单使用余额支付，实际付款金额为0
            //         $outstanding_amount = 0;
            //     }
            //     //添加支付明细
            //     if(!in_array($request['ord_other_payway'], [0,8]) && $ord_actual_price != 0) {
            //         OrderSettlementDetails::addOrderSettlementDetails($ord_id, $data['ord_type'], $request, $user_info, $ord_actual_price, $ord_edit_data['ord_banlance'],$request['ord_other_payway']);
            //         $outstanding_amount = 0;
            //     } else {
            //         $outstanding_amount = $ord_actual_price;
            //     }
            // }
            if ($request['ord_payment_way'] == 9) {
                if ($request['ord_actual_amout'] == $order_amount) {
                    $ord_edit_data['ord_state'] = 2;
                }
                $ord_edit_data['ord_actual_price'] = $request['ord_actual_amout']*100;
            }

            $ord_edit_data['ord_goods_quantity'] = $goo_all_quantity;
        } else {
            return ['code' => 500, 'msg' => '请选择产品或服务', 'data' => '请选择产品或服务'];
        }

        

        // 不生成工单流程
        if ($ord_add_work_state == 2) {
            // 买家类型：1门店零售2客户单位3速电派单4第三方派单5运营中心给门店派单
            // 判断是否为散户，ord_type为空值，是散户
            if (empty($request['ord_type'])) {
                // 散户开单流程
                $order_data['data']['ord_order_number'] = $ord_order_number;
                $order_data['data']['ord_id'] = $ord_id;
                $order_data['data']['shop_id'] = $user_info->adm_shop_id;
                $order_data['data']['ord_type'] = 0;
                $order_data['data']['ord_client_id'] = 0;
                if ($request['ware_id'] && $is_goods) {//选择仓库并且选择产品
                    $ord_edit_data['ord_wor_state'] = 2;//服务中
                    $request['service_shop_id'] = $user_info->adm_shop_id;
                    $dibi_data = DispatchBill::create(
                        $user_info,   //用户信息
                        $request,  //订单提交数据
                        $new_goods_data,  //提交的商品数据
                        1,  //类型：1.订单发货 2.工单发货
                        $request['ware_id'],  //出库仓库id
                        $order_data['data']['ord_order_number'],  //原始单号，订单号/工单号
                        $order_data['data']['ord_id'],  //发货单关联的工单/订单id
                        $order_data['data']['shop_id'],  //所属总店id
                        $order_data['data']['ord_type'],  //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                        $order_data['data']['ord_client_id'],  //选择的客户id,会员id/单位id
                        $new_goo_all_quantity  //发货总数量
                    );
                    if ($dibi_data['code'] == 500) {
                        return $dibi_data;
                    }
                } else {
                    $ord_edit_data['ord_wor_state'] = 20;//已完成
                }
            } else {
                // 不是散户，未选择产品或未选择仓库，生成订单，订单状态为待评价状态
                // 不是散户，选择产品并且选择仓库，生成订单，订单状态是服务中，生成发货单
                $order_data['data']['ord_order_number'] = $ord_order_number;
                $order_data['data']['ord_id'] = $ord_id;
                $order_data['data']['shop_id'] = $user_info->adm_shop_id;
                $order_data['data']['ord_type'] = $request['ord_type'];
                $order_data['data']['ord_client_id'] = 0;
                if ($request['ware_id'] && $is_goods) {//选择仓库并且选择产品
                    $ord_edit_data['ord_wor_state'] = 2;//服务中
                    $request['service_shop_id'] = $user_info->adm_shop_id;
                    $dibi_data = DispatchBill::create(
                        $user_info,   //用户信息
                        $request,  //订单提交数据
                        $new_goods_data,  //提交的商品数据
                        1,  //类型：1.订单发货 2.工单发货
                        $request['ware_id'],  //出库仓库id
                        $order_data['data']['ord_order_number'],  //原始单号，订单号/工单号
                        $order_data['data']['ord_id'],  //发货单关联的工单/订单id
                        $order_data['data']['shop_id'],  //所属总店id
                        $order_data['data']['ord_type'],  //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                        $order_data['data']['ord_client_id'],  //选择的客户id,会员id/单位id
                        $new_goo_all_quantity  //发货总数量
                    );
                    if ($dibi_data['code'] == 500) {
                        return $dibi_data;
                    }
                } else {
                    $ord_edit_data['ord_wor_state'] = 4;//待评价
                    if (empty($request['orcl_phone'])) {
                        $ord_edit_data['ord_wor_state'] = 20;//已完成
                    }
                    
                }
            }
            $ord_edit_data['ord_service_type'] = 2;//洗车-不生成工单的订单
        }
        // $ord_actual_price = $order_amount*100;
        if ($request['ord_payment_way'] == 6 ||$request['ord_payment_way'] == 7) {//使用余额支付
            if ($request['ord_type'] == 1 || $request['ord_type'] == 0) {//个人会员
                if ($request['ord_payment_way'] == 6) {
                    $request['mem_id'] = $request['ord_client_id'];
                }
                $find_mem = DB::table('member')
                    ->where('mem_id', $request['mem_id'])
                    ->select('mem_id', 'mem_rec_banlance', 'mem_gift_banlance')
                    ->first();
                $banlance = $find_mem->mem_rec_banlance + $find_mem->mem_gift_banlance;
                if ($request['ord_payment_way'] == 6 && $banlance == 0) {
                    return ['code' => 500, 'msg' => '余额为0，请选择其他支付方式', 'data' => ''];
                }
                if ($ord_actual_price >= $banlance) {//余额不足
                    if (empty($request['ord_other_payway']) && $ord_actual_price > $banlance) {
                        return ['code' => 500, 'msg' => '余额不足，请添加其他支付方式', 'data' => ''];
                    }
                    $ord_edit_data['ord_actual_price'] = $ord_actual_price - $banlance;
                    $ord_edit_data['ord_other_payway'] = $request['ord_other_payway'];
                    $ord_edit_data['ord_payment_money'] = $ord_actual_price - $banlance;
                    $ord_edit_data['ord_banlance'] = $banlance;
                    $thistime_price = $ord_actual_price - $banlance;//本次实付金额
                    // 消费记录
                    $add_rec_log['relo_type'] = 2;
                    $add_rec_log['relo_rec_num'] = $find_mem->mem_rec_banlance;
                    $add_rec_log['relo_gift_num'] = $find_mem->mem_gift_banlance;
                    $add_rec_log['relo_mem_id'] = $request['mem_id'];
                    $add_rec_log['relo_ord_id'] = $ord_id;
                    $add_rec_log['relo_remark'] = '订单消费';
                    $add_rec_log['relo_create_id'] = $user_info->adm_id;
                    $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                    $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                    $update_mem['mem_rec_banlance'] = 0;
                    $update_mem['mem_gift_banlance'] = 0;
                } elseif ($ord_actual_price < $banlance) {
                    $ord_edit_data['ord_payment_money'] = 0;
                    $ord_edit_data['ord_banlance'] = $ord_actual_price;
                    $ord_edit_data['ord_actual_price'] = 0;
                    $thistime_price = 0;
                    // 消费记录
                    $add_rec_log['relo_type'] = 2;
                    if ($find_mem->mem_rec_banlance >= $ord_actual_price) {
                        $add_rec_log['relo_rec_num'] = $ord_actual_price;
                        $add_rec_log['relo_gift_num'] = 0;
                        $update_mem['mem_rec_banlance'] = $find_mem->mem_rec_banlance - $ord_actual_price;
                    } else {
                        $add_rec_log['relo_rec_num'] = $find_mem->mem_rec_banlance;
                        $add_rec_log['relo_gift_num'] = $ord_actual_price - $find_mem->mem_rec_banlance;
                        $update_mem['mem_rec_banlance'] = 0;
                        $update_mem['mem_gift_banlance'] = $find_mem->mem_gift_banlance - ($ord_actual_price - $find_mem->mem_rec_banlance);
                    }
                    $add_rec_log['relo_mem_id'] = $request['mem_id'];
                    $add_rec_log['relo_ord_id'] = $ord_id;
                    $add_rec_log['relo_remark'] = '订单消费';
                    $add_rec_log['relo_create_id'] = $user_info->adm_id;
                    $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                    $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                }
                $update_mem['mem_update_time'] = date('Y-m-d H:i:s');
                $update_mem_res = DB::table('member')->where('mem_id', $request['mem_id'])->update($update_mem);
                $request['ord_actual_amout'] = $thistime_price;
                $outstanding_amount = 0;
            } elseif ($request['ord_type'] == 2) {//企业客户
                $request['bucl_id'] = $request['orcl_business_id'];
                $business_client = DB::table('business_client')
                    ->where('bucl_id', $request['bucl_id'])
                    ->select('bucl_id', 'bucl_rec_banlance', 'bucl_gift_banlance')
                    ->first();
                $banlance = $business_client->bucl_rec_banlance + $business_client->bucl_gift_banlance;
                if ($request['ord_payment_way'] == 6 && $banlance == 0) {
                    return ['code' => 500, 'msg' => '余额为0，请选择其他支付方式', 'data' => ''];
                }
                if ($ord_actual_price >= $banlance) {//余额不足
                    if (empty($request['ord_other_payway']) && $ord_actual_price > $banlance) {
                        return ['code' => 500, 'msg' => '余额不足，请添加其他支付方式', 'data' => ''];
                    }
                    $ord_edit_data['ord_actual_price'] = $ord_actual_price - $banlance;
                    $ord_edit_data['ord_other_payway'] = $request['ord_other_payway'];
                    $ord_edit_data['ord_payment_money'] = $ord_actual_price - $banlance;
                    $ord_edit_data['ord_banlance'] = $banlance;
                    $thistime_price = $ord_actual_price - $banlance;//本次实付金额
                    // 消费记录
                    $add_rec_log['relo_type'] = 2;
                    $add_rec_log['relo_mem_type'] = 2;
                    $add_rec_log['relo_rec_num'] = $business_client->bucl_rec_banlance;
                    $add_rec_log['relo_gift_num'] = $business_client->bucl_gift_banlance;
                    $add_rec_log['relo_mem_id'] = $request['bucl_id'];
                    $add_rec_log['relo_ord_id'] = $ord_id;
                    $add_rec_log['relo_remark'] = '订单消费';
                    $add_rec_log['relo_create_id'] = $user_info->adm_id;
                    $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                    $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                    $update_mem['bucl_rec_banlance'] = 0;
                    $update_mem['bucl_gift_banlance'] = 0;
                } elseif ($ord_actual_price < $banlance) {
                    $ord_edit_data['ord_payment_money'] = 0;
                    $ord_edit_data['ord_banlance'] = $ord_actual_price;
                    $ord_edit_data['ord_actual_price'] = 0;
                    $thistime_price = 0;
                    // 消费记录
                    $add_rec_log['relo_type'] = 2;
                    $add_rec_log['relo_mem_type'] = 2;
                    if ($business_client->bucl_rec_banlance >= $ord_actual_price) {
                        $add_rec_log['relo_rec_num'] = $ord_actual_price;
                        $add_rec_log['relo_gift_num'] = 0;
                        $update_mem['bucl_rec_banlance'] = $business_client->bucl_rec_banlance - $ord_actual_price;
                    } else {
                        $add_rec_log['relo_rec_num'] = $business_client->bucl_rec_banlance;
                        $add_rec_log['relo_gift_num'] = $ord_actual_price - $business_client->bucl_rec_banlance;
                        $update_mem['bucl_rec_banlance'] = 0;
                        $update_mem['bucl_gift_banlance'] = $business_client->bucl_gift_banlance - ($ord_actual_price - $business_client->bucl_rec_banlance);
                    }
                    $add_rec_log['relo_mem_id'] = $request['bucl_id'];
                    $add_rec_log['relo_ord_id'] = $ord_id;
                    $add_rec_log['relo_remark'] = '订单消费';
                    $add_rec_log['relo_create_id'] = $user_info->adm_id;
                    $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                    $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                }
                $update_mem['bucl_update_time'] = date('Y-m-d H:i:s');
                $update_mem_res = DB::table('business_client')->where('bucl_id', $request['bucl_id'])->update($update_mem);
                $request['ord_actual_amout'] = $thistime_price;
                $outstanding_amount = 0;
            }
        } elseif ($request['ord_payment_way'] == 9) {//部分结款
            $ord_edit_data['ord_payment_money'] = $request['ord_actual_amout']*100;
            $ord_edit_data['ord_other_payway'] = $request['ord_other_payway'];
            $ord_edit_data['ord_banlance'] = 0;
            $outstanding_amount = $ord_actual_price - $request['ord_actual_amout']*100;
            if ($outstanding_amount == 0) {
                $ord_edit_data['ord_state'] = 2;
            }
        } elseif (in_array($request['ord_payment_way'], [1,2,3,4])) {
            $ord_edit_data['ord_payment_money'] = $goo_all_price * 100;
            $ord_edit_data['ord_banlance'] = 0;
            $request['ord_actual_amout'] = $goo_all_price * 100;
            $outstanding_amount = 0;
        } elseif(in_array($request['ord_payment_way'], [0,8])) {//0暂不结算5会员卡结算8账期
            $ord_edit_data['ord_payment_money'] = 0;
            $ord_edit_data['ord_banlance'] = 0;
            $request['ord_actual_amout'] = 0;
            $outstanding_amount = $ord_actual_price;
        } elseif($request['ord_payment_way'] == 5) {//0暂不结算5会员卡结算8账期
            $ord_edit_data['ord_payment_money'] = $order_amount*100;
            $ord_edit_data['ord_other_payway'] = $request['ord_other_payway'];
            $ord_edit_data['ord_banlance'] = 0;
            $request['ord_actual_amout'] = 0;
            $outstanding_amount = 0;

            if (!isset($request['myvi_id'])) {
                return ["code"=>500, 'msg'=>'请选择会员卡', 'data'=>'请选择会员卡'];
            }
            $find_myvi_data = DB::table('myvip as myvi')
                ->leftJoin('member as m', 'm.mem_id', '=', 'myvi.myvi_adm_id')
                ->where('myvi_id', $request['myvi_id'])
                ->select('myvi_id', 'myvi_end_time', 'myvi_surplus_times', 'myvi_num', 'myvi_adm_id', 'mem_phone', 'mem_name', 'myvi_name')
                ->first();
            if ($find_myvi_data->myvi_end_time < date('Y-m-d H:i:s')) {
                return ["code"=>500, 'msg'=>'会员卡已过期', 'data'=>'会员卡已过期'];
            }
            if ($find_myvi_data->myvi_surplus_times == 0) {
                return ["code"=>500, 'msg'=>'会员卡次数已用完', 'data'=>'会员卡次数已用完'];
            }
            $update_myvi_data['myvi_surplus_times'] = $find_myvi_data->myvi_surplus_times - $use_vip_allnum;
            if ($update_myvi_data['myvi_surplus_times'] == 0) {
                $update_myvi_data['myvi_state'] = 2;//已失效
            }
            $update_myvi_data['myvi_update_time'] = date('Y-m-d H:i:s');
            $update_res = DB::table('myvip')
                ->where('myvi_id', $find_myvi_data->myvi_id)
                ->update($update_myvi_data);

            $add_vip_record['vcre_myvi_id'] = $request['myvi_id'];
            $add_vip_record['vcre_user_id'] = $find_myvi_data->myvi_adm_id;
            $add_vip_record['vcre_ord_num'] = $ord_order_number;
            $add_vip_record['vcre_ord_id'] = $ord_id;
            $add_vip_record['vcre_create_time'] = date('Y-m-d H:i:s');
            $add_vip_record['vcre_car_adm_name'] = $request['orcl_carowner_name'];
            $add_vip_record['vcre_car_adm_phone'] = $request['orcl_carowner_phone'];
            $add_vip_record['vcre_myvi_num'] = $find_myvi_data->myvi_num;
            $add_vip_record['vcre_log'] = 1;
            $add_vip_record['vcre_num_change'] = '-'.$use_vip_allnum.'（剩余：'.($find_myvi_data->myvi_surplus_times - $use_vip_allnum).'次）';
            $add_vire_res = DB::table('vip_card_record')->insertGetId($add_vip_record);
            $use_vip_data = [];
            //使用会员卡结算
            $vip_data = DB::table('myvip_detail')
                ->where('myvid_mvid', $request['myvi_id'])
                ->get()->toArray();
            // 使用会员卡结算
            $use_detail = '';
            foreach ($goods_data as $key => $value) {
                foreach ($vip_data as $k => $v) {
                    if ($value['goo_type'] == $v->myvid_type && $value['goo_id'] == $v->myvid_data_id) {
                        $myvid_surplus_times = DB::table('myvip_detail')
                            ->where('myvid_id',$v->myvid_id)
                            ->value('myvid_surplus_times');
                        $use_vip_data['myvid_surplus_times'] = $myvid_surplus_times - $value['use_vip_num'];
                        // $use_vip_data['myvid_surplus_times'] = $v->myvid_surplus_times - $goods_data[$key]['use_vip_num'];
                        $update_vip_data = DB::table('myvip_detail')
                            ->where('myvid_id',$v->myvid_id)
                            ->update($use_vip_data);
                        $goods_data[$key]['myvid_id'] = $v->myvid_id;
                        $add_vcrd_data['vcrd_vcre_id'] = $add_vire_res;
                        $add_vcrd_data['vcrd_myvid_id'] = $v->myvid_id;
                        $add_vcrd_data['vcrd_num'] = $goods_data[$key]['use_vip_num'];
                        $add_vcrd_data['vcrd_description'] = '-'.$goods_data[$key]['use_vip_num'].'/余'.$use_vip_data['myvid_surplus_times'];
                        $add_vcrd_data['vcrd_create_time'] = date('Y-m-d H:i:s');
                        $add_vcrd_data['vcrd_create_id'] = $user_info->adm_id;
                        $add_vcre_res = DB::table('vipca_record_datail')->insertGetId($add_vcrd_data);
                        $use_detail = $use_detail.$value['goo_name'].'*'.$goods_data[$key]['use_vip_num'].' ';
                    }
                }
            }
            $send = isSend($user_info,2);
            if ($send) {
                // 2.给相应的客户发送短信
                $phone = $find_myvi_data->mem_phone;
                $message = '【半径服务】您的'.$find_myvi_data->myvi_name.'消费1次，消费项目'.$use_detail;
                if (preg_match("/^1[3456789]\d{9}$/", $phone)) {
                    $find_shop_data = DB::table('shop')
                        ->where('shop_id', $user_info->adm_shop_id)
                        ->first();
                    if ($find_shop_data->shop_message_num <= 0) {
                        $send_state = 2;
                        $send_res = 0;
                    } else {
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $user_info->adm_shop_id)
                            ->where('mrlo_state', 2)
                            ->first();
                        if ($msg_remind_log) {//已提醒过
                            if ($find_shop_data->shop_message_num > $find_shop_data->shop_msg_remind) {
                                $update_remind['mrlo_state'] = 1;
                                $msg_remind_log = DB::table('msg_remind_log')
                                    ->where('mrlo_shop_id', $user_info->adm_shop_id)
                                    ->where('mrlo_state', 2)
                                    ->update($update_remind);
                            }
                        }
                        
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $user_info->adm_shop_id)
                            ->where('mrlo_state', 2)
                            ->first();
                        // 短信不足提醒
                        if (($find_shop_data->shop_message_num-1) <= $find_shop_data->shop_msg_remind && empty($msg_remind_log) && $find_shop_data->shop_msg_adm_id) {
                            $adm_data = DB::table('admin')->where('adm_id', $find_shop_data->shop_msg_adm_id)->first();
                            // $wechat_msg['pushtype'] = 5; //短信预警
                            // $wechat_msg['adm_id'] = $find_shop_data->shop_msg_adm_id; //推送人
                            // $wechat_msg['user_data'] = $adm_data->adm_name; //姓名
                            // $wechat_msg['tittle'] = '剩余短信不足'.$find_shop_data->shop_msg_remind.'条，请及时充值'; //提醒消息
                            // $wechat_msg['remark'] = '短信不足预警';
                            // $CashierDesk = new CashierDesk;
                            // $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
                            $remind_phone = $adm_data->adm_phone;
                            $remind_content = '【半径服务】 您的门店短信余额不足'.$find_shop_data->shop_msg_remind.'条，请及时充值';
                            $remind_send_res = sendSmsCode($remind_phone, $remind_content);
                            if ($remind_send_res > 0) {
                                $send_state = 1;
                                $add_remind['mrlo_shop_id'] = $user_info->adm_shop_id;
                                $add_remind['mrlo_state'] = 2;//未充值，
                                $add_remind['mrlo_adm_id'] = $find_shop_data->shop_msg_adm_id;
                                $add_remind['mrlo_num'] = $find_shop_data->shop_msg_remind;
                                $add_remind['mrlo_create_time'] = date('Y-m-d H:i:s');
                                $add_remind['mrlo_create_id'] = $user_info->adm_id;
                                $reming_res = DB::table('msg_remind_log')->insertGetId($add_remind);
                            } else {
                                $send_state = 2;
                            }
                            // 短信模块日志
                            $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                            $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                            $seme_data['seme_wor_id'] = 0; //订单id
                            $seme_data['seme_name'] = '短信不足预警'; //模板名称
                            $seme_data['seme_phone'] = $remind_phone; //手机号
                            $seme_data['seme_content'] = $remind_content; //内容
                            $seme_data['seme_row'] = 1; //条数
                            $seme_data['seme_status_code'] = $remind_send_res; //短信状态码
                            $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                            $seme_data['seme_ip'] = $request['ip']; //ip地址
                            $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                            $seme_id = DB::table('send_message')->insert($seme_data);
                        }
                        $send_res = sendSmsCode($phone, $message);
                        if ($send_res > 0) {
                            $send_state = 1;
                            $update_shop = DB::table('shop')
                                ->where('shop_id', $user_info->adm_shop_id)
                                ->update(['shop_message_num'=>$find_shop_data->shop_message_num - 1]);
                        } else {
                            $send_state = 2;
                        }
                    }
                    // 短信模块日志
                    $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                    $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                    $seme_data['seme_wor_id'] = $request['ord_id']; //订单id
                    $seme_data['seme_name'] = '会员卡消费通知'; //模板名称
                    $seme_data['seme_phone'] = $phone; //手机号
                    $seme_data['seme_content'] = $message; //内容
                    $seme_data['seme_row'] = 1; //条数
                    $seme_data['seme_status_code'] = $send_res; //短信状态码
                    $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                    $seme_data['seme_ip'] = $request['ip']; //ip地址
                    $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                    $seme_id = DB::table('send_message')->insert($seme_data);

                    $find_member = DB::table('member')
                        ->where('mem_shop_id', $user_info->adm_shop_id)
                        ->where('mem_phone', $phone)
                        ->first();
                    $add_log['smlo_shop_id'] = $user_info->adm_shop_id;
                    $add_log['smlo_mem_type'] = 2;//1业务人员2会员
                    $add_log['smlo_mem_id'] = $find_member->mem_id;
                    $add_log['smlo_mem_name'] = $find_member->mem_name;
                    $add_log['smlo_mem_phone'] = $phone;
                    $add_log['smlo_type'] = 2;
                    $add_log['smlo_create_time'] = date('Y-m-d H:i:s');
                    $add_log['smlo_state'] = $send_state;
                    $add_log['smlo_msg_type'] = 4;
                    $add_log['smlo_num'] = 1;
                    $add_log['smlo_content'] = $message; //内容
                    $add_log_res = DB::table('sms_log')->insertGetId($add_log);
                }
            }
        }

        if ($request['ord_type'] == 1) {//会员
            $find_mem = DB::table('member')
                ->where('mem_id', $request['ord_client_id'])
                ->select('mem_arrears')
                ->first();
            $update_data_mem['mem_arrears'] = $find_mem->mem_arrears + $outstanding_amount;
            $update_data_mem['mem_update_time'] = date('Y-m-d H:i:s');
            $update_data_mem_res = DB::table('member')->where('mem_id', $request['ord_client_id'])->update($update_data_mem);
        } elseif ($request['ord_type'] == 2) {
            $find_mem = DB::table('business_account')
                ->leftJoin('business_client', 'bucl_id', '=', 'buac_bucl_id')
                ->where('buac_id', $request['ord_client_id'])
                ->select('buac_arrears', 'buac_bucl_id', 'bucl_arrears')
                ->first();
            $update_data_mem['buac_arrears'] = $find_mem->buac_arrears + $outstanding_amount;
            $update_data_mem['buac_update_time'] = date('Y-m-d H:i:s');
            $update_data_mem_res = DB::table('business_account')->where('buac_id', $request['ord_client_id'])->update($update_data_mem);
            
            $update_bucl['bucl_arrears'] = $find_mem->bucl_arrears + $outstanding_amount;
            $update_bucl['bucl_update_time'] = date('Y-m-d H:i:s');
            $update_bucl_res = DB::table('business_client')->where('bucl_id', $find_mem->buac_bucl_id)->update($update_bucl);
        }

        //添加支付明细
        if(!in_array($request['ord_payment_way'], [0,8])) {
            if ($request['ord_payment_way'] == 5) {
                OrderSettlementDetails::addOrderSettlementDetails($ord_id, $request['ord_type'], $request, $user_info, $ord_use_vip_price*100, $ord_edit_data['ord_banlance']);
            } else {
                OrderSettlementDetails::addOrderSettlementDetails($ord_id, $request['ord_type'], $request, $user_info, $ord_edit_data['ord_payment_money'], $ord_edit_data['ord_banlance']);
            }
        }
//        $order_settlement_details['orsd_ord_id'] = $ord_id;
//        if ($request['ord_payment_way'] == 9) {
//            $order_settlement_details['orsd_payment_way'] = $request['ord_other_payway'];
//        } else {
//            $order_settlement_details['orsd_payment_way'] = $request['ord_payment_way'];
//        }
//        $order_settlement_details['orsd_pay_money'] = $request['ord_actual_amout']*100;
//        $order_settlement_details['orsd_mem_id'] = $request['mem_id'];
//        $order_settlement_details['orsd_mem_type'] = $request['ord_type'];
//        $order_settlement_details['orsd_create_id'] = $user_info->adm_id;
//        $order_settlement_details['orsd_create_time'] = date('Y-m-d H:i:s');
//        $typeName = WashOrderService::getPaymentWayName(true);//获取支付方式名称
//        $ord_payment_name = WashOrderService::getTypeData($order_settlement_details['orsd_payment_way'], $typeName);
//        if (!empty($request['ord_payment_way'])) {
//            $order_settlement_details['orsd_payment_way_name'] = $ord_payment_name;
//        } else {
//            $order_settlement_details['orsd_payment_way_name'] = '未结算';
//        }
//        $sede_res = DB::table('order_settlement_details')->insertGetId($order_settlement_details);
        $ord_edit_data['ord_add_work_state'] = $ord_add_work_state;
        $ord_edit_data['ord_orcl_id'] = $orcl_id;
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_data['ord_client_id'] = $request['ord_client_id'];
        //查询销售员绩效分类
        if (isset($request['orcl_sales_adm_id']) && $request['orcl_sales_adm_id']) {
            // return ['code' => 500, 'msg' => '新增失败', 'data' =>$request['orcl_sales_adm_id']];
            $get_performance_type = DB::table('goods_performance_type')
                ->where('gpt_sale_adm_id', $request['orcl_sales_adm_id'])
                ->where('gpt_state', 1)
                ->first();
            if ($get_performance_type) {
                if ($get_performance_type->gpt_type == 2) {
                    $get_performance = DB::table('goods_performance')
                        ->where('gppe_type', 3)
                        ->where('gppe_performance', '>', 0)
                        ->where('gppe_sale_id', $request['orcl_sales_adm_id'])
                        ->first();
                    if ($get_performance) {
                        $ord_edit_data['ord_saleman_type'] = $get_performance->gppe_goo_id;
                        if ($get_performance->gppe_goo_id == 1) {
                            $ord_edit_data['ord_saleman_performance'] = $get_performance->gppe_performance;
                        } else {
                            $ord_edit_data['ord_saleman_performance'] = $get_performance->gppe_performance;
                        }
                    }
                }
            }
        }
        $ord_edit_res = NewOrderService::editOrder($ord_id,$ord_edit_data);
        //个人会员下服务单更新会员下单时间
        if(isset($request['ord_type']) && $request['ord_type'] == 1){
            self::updateOrderCount($request['ord_client_id']);
        }
        //计算会员消费总金额
        if($request['ord_type'] == 1 && !empty($request['ord_client_id'])){
            WashOrderService::consume_money($request['ord_client_id']);
        }

        if ($request['ord_type'] == 1) {
            if ($weus_id) {
                // 添加客户消息
                $add_data['weus_id'] = $weus_id;
                $add_data['shop_id'] = $user_info->adm_shop_id;
                $add_data['primary_id'] = $ord_id; //单据的主键id
                $add_data['primary_type'] = 1; //单据类型：1订单2工单3预约单4售后单
                $add_data['read_state'] = 1; //阅读状态：1未读2已读
                $add_data['title'] = '预约成功通知'; //消息标题
                $add_data['content'] = '您申请的服务已预约成功，我们会尽快处理，请耐心等待'; //操作内容'.$value['sepr_name'].'
                $add_data['create_adm_name'] = $user_info->adm_name; //操作人姓名
                $add_data['create_adm_id'] = $user_info->adm_id; //操作人id
                $addUserMessage_res = addUserMessage($add_data);
                unset($add_data);
            }

            if (isset($request['send']) && $request['send'] == 1) {
                // 2.给相应的客户发送短信
                if (isset($request['orcl_phone']) && !empty($request['orcl_phone'])) {
                    $phone = $request['orcl_phone'];
                    $message = '【半径服务】尊敬的客户您好，您申请的服务已预约成功，请登录(半径服务)小程序查看';
                    if (preg_match("/^1[3456789]\d{9}$/", $phone)) {
                        $find_shop_data = DB::table('shop')
                            ->where('shop_id', $user_info->adm_shop_id)
                            ->first();
                        if ($find_shop_data->shop_message_num <= 0) {
                            $send_state = 2;
                            $send_res = 0;
                        } else {
                            $msg_remind_log = DB::table('msg_remind_log')
                                ->where('mrlo_shop_id', $user_info->adm_shop_id)
                                ->where('mrlo_state', 2)
                                ->first();
                            if ($msg_remind_log) {//已提醒过
                                if ($find_shop_data->shop_message_num > $find_shop_data->shop_msg_remind) {
                                    $update_remind['mrlo_state'] = 1;
                                    $msg_remind_log = DB::table('msg_remind_log')
                                        ->where('mrlo_shop_id', $user_info->adm_shop_id)
                                        ->where('mrlo_state', 2)
                                        ->update($update_remind);
                                }
                            }
                            $msg_remind_log = DB::table('msg_remind_log')
                                ->where('mrlo_shop_id', $user_info->adm_shop_id)
                                ->where('mrlo_state', 2)
                                ->first();

                            if (($find_shop_data->shop_message_num-1) <= $find_shop_data->shop_msg_remind && empty($msg_remind_log) && $find_shop_data->shop_msg_adm_id) {
                                $adm_data = DB::table('admin')->where('adm_id', $find_shop_data->shop_msg_adm_id)->first();
                                // $wechat_msg['pushtype'] = 5; //短信预警
                                // $wechat_msg['adm_id'] = $find_shop_data->shop_msg_adm_id; //推送人
                                // $wechat_msg['user_data'] = $adm_data->adm_name; //姓名
                                // $wechat_msg['tittle'] = '剩余短信不足'.$find_shop_data->shop_msg_remind.'条，请及时充值'; //提醒消息
                                // $wechat_msg['remark'] = '短信不足预警';
                                // $CashierDesk = new CashierDesk;
                                // $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
                                $remind_phone = $adm_data->adm_phone;
                                $remind_content = '【半径服务】 您的门店短信余额不足'.$find_shop_data->shop_msg_remind.'条，请及时充值';
                                $remind_send_res = sendSmsCode($remind_phone, $remind_content);
                                if ($remind_send_res > 0) {
                                    $send_state = 1;
                                    $add_remind['mrlo_shop_id'] = $user_info->adm_shop_id;
                                    $add_remind['mrlo_state'] = 2;//未充值，
                                    $add_remind['mrlo_adm_id'] = $find_shop_data->shop_msg_adm_id;
                                    $add_remind['mrlo_num'] = $find_shop_data->shop_msg_remind;
                                    $add_remind['mrlo_create_time'] = date('Y-m-d H:i:s');
                                    $add_remind['mrlo_create_id'] = $user_info->adm_id;
                                    $reming_res = DB::table('msg_remind_log')->insertGetId($add_remind);
                                } else {
                                    $send_state = 2;
                                }
                                // 短信模块日志
                                $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                                $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                                $seme_data['seme_wor_id'] = 0; //订单id
                                $seme_data['seme_name'] = '短信不足预警'; //模板名称
                                $seme_data['seme_phone'] = $remind_phone; //手机号
                                $seme_data['seme_content'] = $remind_content; //内容
                                $seme_data['seme_row'] = 1; //条数
                                $seme_data['seme_status_code'] = $remind_send_res; //短信状态码
                                $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                                $seme_data['seme_ip'] = $request['ip']; //ip地址
                                $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                                $seme_id = DB::table('send_message')->insert($seme_data);
                            }
                            $send_res = sendSmsCode($phone, $message);
                            if ($send_res > 0) {
                                $send_state = 1;
                                $update_shop = DB::table('shop')
                                    ->where('shop_id', $user_info->adm_shop_id)
                                    ->update(['shop_message_num'=>$find_shop_data->shop_message_num - 1]);
                            } else {
                                $send_state = 2;
                            }
                        }
                        
                        // 短信模块日志
                        $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                        $seme_data['seme_shop_id'] = $user_info->adm_shop_id; //门店id
                        $seme_data['seme_wor_id'] = $ord_id; //订单id
                        $seme_data['seme_name'] = '预约成功通知'; //模板名称
                        $seme_data['seme_phone'] = $phone; //手机号
                        $seme_data['seme_content'] = $message; //内容
                        $seme_data['seme_row'] = 1; //条数
                        $seme_data['seme_status_code'] = $send_res; //短信状态码
                        $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                        $seme_data['seme_ip'] = $request['ip']; //ip地址
                        $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                        $seme_id = DB::table('send_message')->insert($seme_data);
                        $find_member = DB::table('member')
                            ->where('mem_shop_id', $user_info->adm_shop_id)
                            ->where('mem_phone', $phone)
                            ->first();
                        $add_log['smlo_shop_id'] = $user_info->adm_shop_id;
                        $add_log['smlo_mem_type'] = 2;//1业务人员2会员
                        $add_log['smlo_mem_id'] = $find_member->mem_id;
                        $add_log['smlo_mem_name'] = $find_member->mem_name;
                        $add_log['smlo_mem_phone'] = $phone;
                        $add_log['smlo_type'] = 2;
                        $add_log['smlo_create_time'] = date('Y-m-d H:i:s');
                        $add_log['smlo_state'] = $send_state;
                        $add_log['smlo_msg_type'] = 4;
                        $add_log['smlo_num'] = 1;
                        $add_log['smlo_content'] = $message; //内容
                        $add_log_res = DB::table('sms_log')->insertGetId($add_log);
                    }
                }
            }
        }

        if ($user_info->shop_versions == 2 && $ord_add_work_state == 1) {//企业版有排班计划
            // 添加排班计划
            $wopl_data['wopl_shop_id'] = $user_info->adm_shop_id;
            // $wopl_data['wopl_wor_id'] = $wor_id;
            $wopl_data['wopl_ord_id'] = $ord_id;
            $wopl_data['wopl_ord_new_type'] = $request['ord_new_type'];
            $wopl_data['wopl_sepr_id'] = $sepr_id;
            $wopl_data['wopl_sepr_name'] = $sepr_name;
            $wopl_data['wopl_goo_id'] = $goo_id;
            $wopl_data['wopl_goo_name'] = $goo_name;
            $wopl_data['wopl_address_id'] = $request['ord_address_id'];
            $wopl_data['wopl_address'] = $request['ord_address'];
            $wopl_data['wopl_address_type'] = $request['ord_address_type'];
            if ($request['orcl_sales_adm_id']) {
                $find_adm = DB::table('admin')->where('adm_id', $request['orcl_sales_adm_id'])->value('adm_name');
            } else {
                $find_adm = '';
            }
            $wopl_data['wopl_sale_name'] = $find_adm;
            $wopl_data['wopl_sale_id'] = isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : '';
            $wopl_data['wopl_explain'] = isset($request['ord_explain']) ? $request['ord_explain'] : '';
            $wopl_data['wopl_time'] = isset($request['orcl_appoint_time']) ? date('H:i:s', strtotime($request['orcl_appoint_time'])) : '';
            $wopl_data['wopl_date'] = isset($request['orcl_appoint_time']) ? date('Y-m-d', strtotime($request['orcl_appoint_time'])) : '';
            // $wopl_data['wopl_service_id'] = ','.$service_adm_id.',';
            $wopl_data['wopl_create_time'] = date('Y-m-d H:i:s');
            $wopl_id = DB::table('work_plan')->insertGetId($wopl_data);
        }
        $ord_data = DB::table('order')
            ->where('ord_id', $ord_id)
            ->select('ord_state', 'ord_wor_state', 'ord_type')
            ->first();
        if ($ord_data->ord_state == 2 && ($ord_data->ord_wor_state == 4 || $ord_data->ord_wor_state == 20) && $ord_data->ord_type == 1) {//已结算 待评价或已完成 个人会员 添加积分
            $add_point = self::addPoint($user_info,$request['ord_client_id'],$ord_id,$mem_points_multiple);
        }
        //添加采购计划
        if ($request['ware_id'] && $is_goods) {
            $post_data['ware_id'] = $request['ware_id'];
            $post_data['new_goods_data'] = $new_goods_data;
            $res = self::addGoodPlan($user_info, $post_data);
        }
        if ($ord_id && $orcl_id && $ord_edit_res && $return_car_data) {
            $return_data['ord_id'] = $ord_id; //订单id
            $return_data['ord_order_number'] = $ord_order_number; //订单单号
            $return_data['goods_data'] = json_encode($goods_data); //商品信息
            $return_data['ord_type'] = $request['ord_type']; //买家类型1.会员零售2.合作商
            $return_data['ord_client_id'] = isset($request['ord_client_id']) ? $request['ord_client_id'] : 0; //选择的客户id,会员id/单位id
            if ($only_goods && $request['ware_id'] && $is_goods) {
                //发货通知
                // 微信消息推送
                if(isset($request['orcl_sales_adm_id'])){
                    $admin = DB::table('admin')->where("adm_id",$request['orcl_sales_adm_id'])->select('adm_phone','adm_name')->first();
                    if($admin){
                        $user_data = $admin->adm_name."  ".$admin->adm_phone;
                    }else{
                        $user_data = '未选择销售人员';
                    }
                }else{
                    $user_data = '未选择销售人员';
                }
                $ware_leader_id = DB::table('warehouse')->where("ware_id",$request['ware_id'])->value('ware_leader_id');
                if($ware_leader_id) {
                    $ware_leader_id = explode(',', $ware_leader_id);
                    foreach($ware_leader_id as $k => $v){
                        $wechat_msg['pushtype'] = 2; //发货推送
                        $wechat_msg['dego_id'] = $dibi_data['dego_id']??0; //发货推送
                        $wechat_msg['adm_id'] = $v; //推送人  ord_ware_id  ware_leader_id
                        $wechat_msg['wor_number'] = ""; //工单号
                        $wechat_msg['ord_number'] = $data['ord_order_number']; //订单号
                        $wechat_msg['user_data'] = $user_data; //姓名
                        $wechat_msg['user_dress'] = $data['ord_address']; //详细地址
                        $wechat_msg['tittle'] = '您有新的发货申请，请及时处理'; //手机
                        $wechat_msg['remark'] = '请确认信息，如有变动，请联系收货人';
                        $CashierDesk = new CashierDesk;
                        $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
                    }
                }
            }
            //20230724  添加订单应收应付
            $recpay_receivable_price = $goo_all_price * 100;//应收金额
            $recpay_actual_price = 0;//默认实收金额为0
            $recpay_arrears_price = $recpay_receivable_price - $recpay_actual_price;//欠收金额 = 应收金额 - 实收金额
            //支付方式为1.现金2.支付宝 3微信 4银行卡  的实收金额
            /*if (in_array($request['ord_payment_way'],[1,2,3,4])) {
                $recpay_actual_price = $goo_all_price * 100; //实收金额
                $recpay_arrears_price = 0;
            }else if(in_array($request['ord_payment_way'],[5,6])){
                $recpay_arrears_price = 0;
            }*/
            if(in_array($request['ord_payment_way'],[5,6])){//会员卡
                if(isset($ord_edit_data['ord_payment_money'])){
                    $recpay_actual_price = $ord_edit_data['ord_payment_money'] ;//实收金额
                }else{
                    $recpay_actual_price = 0;//实收金额
                }
                $recpay_arrears_price = 0;//欠收金额
            } elseif($request['ord_payment_way'] == 9){//部分结款
                $recpay_actual_price = $request['ord_actual_amout']*100;//实收金额
                $recpay_arrears_price = $outstanding_amount;//欠收金额
            } elseif($request['ord_payment_way'] > 0 && $request['ord_payment_way'] != 9){
                if(isset($ord_edit_data['ord_payment_money'])){
                    $recpay_actual_price = $ord_edit_data['ord_payment_money'] ;//实收金额
                }else{
                    $recpay_actual_price = $recpay_receivable_price ;//实收金额
                }
                $recpay_arrears_price = 0;//欠收金额
            }
            $recpay_cost_price = 0;//成本价
            if(isset($goods_price)){
                foreach ($goods_price as $g_k => $g_v){
                    $recpay_cost_price += $g_v['price'] * $g_v['quantity'] * 100;
                }
            }
            $profit = $recpay_actual_price - $recpay_cost_price;
            if($profit > 0){
                $minus = 1;
            }else{
                $minus = 2;
                $profit = abs($profit);
            }
            //企业信息
            $type_id =isset($request['ord_client_id']) ? $request['ord_client_id'] : 0;
            $type_name = isset($request['orcl_business_name']) ? $request['orcl_business_name'] : $request['orcl_name'];
            $rece_params = [
                'recpay_type'=>1,//类型：1销售订单2充值卡
                'recpay_original_id'=>$ord_id,//订单id
                'recpay_original_number'=>$ord_order_number,//订单号
                'recpay_client_type'=>$request['ord_type'], //买家类型：0散户1门店零售2企业客户
                'recpay_client_id'=>$type_id,//
                'recpay_client_name'=>$type_name,
                'recpay_receivable_price'=>$recpay_receivable_price,//应收金额
                'recpay_arrears_price'=>$recpay_arrears_price,//欠收金额
                'recpay_actual_price'=>$recpay_actual_price,//实收金额
                'recpay_cost_price'=>$recpay_cost_price,//成本价
                /*'recpay_receivable_pay'=>0,//应付金额
                'recpay_actual_pay'=>0,//实付金额*/
                'recpay_state'=>1,//状态：1未确认2已确认
                'recpay_order_state'=>1,//订单状态：1正常2退款3取消
                'recpay_plus_minus'=>$minus,//盈利正负：1正值2负值
                'recpay_profit'=>$profit,//盈利金额
            ];
            ReceivablePayService::add($rece_params);
            return ['code' => 200, 'msg' => '新增成功', 'data' => $return_data];
        } else {
            return ['code' => 500, 'msg' => '新增失败', 'data' => '新增失败'];
        }
    }

    // 来源  1 pc  2 车主小程序   3 技师
    private static function getOrdsource($request)
    {
        $ord_source = 1;  // 来源  1 pc  2 车主小程序   3 技师
        if (isset($request['rt'])) {
            if ($request['rt'] == 'wechat') {
                $ord_source = 3;
            } elseif ($request['rt'] == 'wechatWash') {
                $ord_source = 2;
            }  elseif ($request['rt'] == 'business_client') {
                $ord_source = 4;
            }
        }
        return $ord_source;
    }

    public static function mem_price($request,$user_info)
    {
        $data['meml_discount'] = 0;
        $data['meml_points_multiple'] = 1;
        if($request['ord_type'] == 1 && !empty($request['ord_client_id'])) {
            $mem_level = DB::table('member')
                ->where('mem_cid', $user_info->adm_cid)
                ->where('mem_shop_id', $user_info->adm_shop_id)
                ->where('mem_id', $request['ord_client_id'])
                ->value('mem_level');
            if($mem_level > 0){
                $level = DB::table('member_level')
                    ->where('meml_cid',$user_info->adm_cid)
                    ->where('meml_shop_id',$user_info->adm_shop_id)
                    ->where('meml_level',$mem_level)
                    ->first();
                if($level->meml_discount > 0){
                    $data['meml_discount'] = $level->meml_discount;//折扣
                }
                if($level->meml_points_multiple > 0){
                    $data['meml_points_multiple'] = $level->meml_points_multiple;//积分倍数
                }
            }
        }
        return ['code' => 200, 'msg' => '新增成功', 'data' => $data];
    }
    
    /**
     * [createWork 生成工单]
     * @param  [type]  $user_info [description]
     * @param  [type]  $request   [description]
     * @param  integer $type      [类型：1生成工单调用2订单立即派单调用]
     * @return [type]             [description]
     */
    public static function createWork($user_info, $request, $type = 1)
    {
        $find_order_data = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
            ->where('ord_id', $request['ord_id'])
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->select('ord_id', 'ord_order_number', 'ord_wor_state', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_type', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'ord_remark', 'ord_order_price', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_pick_up_car_time', 'orcl_pick_up_car_adm_id', 'orcl_check_car_state', 'orcl_adm_id', 'orcl_car_vin', 'orcl_car_brand_series', 'ord_ware_id', 'ord_client_id', 'ord_create_time', 'ord_province', 'ord_city', 'ord_county', 'ord_address', 'orcl_carowner_name', 'orcl_carowner_phone', 'ord_explain', 'ord_address_type', 'ord_address_id', 'orcl_business_name', 'orcl_business_id', 'orcl_sales_adm_id', 'ord_service_type', 'orcl_carbrse_type', 'ord_source', 'ord_other_system_number', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address')
            ->first();
        if (empty($find_order_data)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'订单不存在', 'data'=>'订单不存在'];
        }
        if ($find_order_data->ord_wor_state == 2) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'已生成工单，无法重复生成', 'data'=>'已生成工单，无法重复生成'];
        }
        if ($find_order_data->ord_wor_state == 4) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单已完成，无法派单', 'data'=>'当前订单已完成，无法派单'];
        }
        if ($find_order_data->ord_wor_state == 11) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单已取消，无法派单', 'data'=>'当前订单已取消，无法派单'];
        }

        $find_work_data = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->where('wor_delete', 1)
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->value('wor_id');
        if (!empty($find_work_data)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单已生成工单，请勿重复生成！', 'data'=>'当前订单已生成工单，请勿重复生成！'];
        }
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $wor_order_number = Common::numberRule($user_info, 2);

        $data['wor_cid'] = $user_info->adm_cid;
        $data['wor_superior_shop_id'] = $shop_id;
        $data['wor_shop_id'] = $user_info->adm_shop_id;
        $data['wor_create_id'] = $user_info->adm_id;
        $data['wor_number'] = $wor_order_number;
        $data['wor_order_id'] = $request['ord_id'];
        $data['wor_order_number'] = $find_order_data->ord_order_number;
        $data['wor_service_shop_id'] = $user_info->adm_shop_id; //服务门店id
        $data['wor_type'] = $find_order_data->ord_type;
        $data['wor_ware_id'] = $find_order_data->ord_ware_id;
        $data['wor_address'] = isset($request['ord_address']) ? $request['ord_address']:$find_order_data->ord_address;
        $data['wor_address_type'] = isset($request['ord_address_type']) ? $request['ord_address_type']:$find_order_data->ord_address_type;
        $data['wor_address_id'] = isset($request['ord_address_id']) ? $request['ord_address_id']:$find_order_data->ord_address_id;
        $data['wor_service_type'] = $find_order_data->ord_service_type; //订单类型：1服务单2销售单3换货单
        $data['wor_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['wor_remark'] = $find_order_data->ord_remark;
        $data['wor_explain'] = isset($request['ord_explain']) ? $request['ord_explain']:$find_order_data->ord_explain;
        $data['wor_service_state'] = 5;
        $data['wor_state'] = 7;//7.抵达/抵达/施工中
        $data['wor_pass'] = 1; //审核：1.待审核 2.合格 3.不合格
        $data['wor_actual_price'] = $find_order_data->ord_actual_price; //工单结算金额（单位：分）
        $data['wor_goo_amount'] = $find_order_data->ord_goods_quantity; //总的商品数量
        $data['wor_new_goo_amount'] = $find_order_data->ord_goods_quantity; //总的商品数量(用料)
        if ($find_order_data->ord_source == 5) {
            $data['wor_work_type'] = 2;//工单类型：1门店工单2智配工单
        }
        if (isset($request['orcl_appoint_time']) && $request['orcl_appoint_time'] != '0000-00-00 00:00:00' && !empty($request['orcl_appoint_time'])) {
            $data['wor_appoint_time'] = $request['orcl_appoint_time']; //预约时间
        } else {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'请填写预约时间', 'data'=>'请填写预约时间'];
        }
        $data['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_id = DB::table('work_order')->insertGetId($data);

        $request['goods_data'] = DB::table('order_goods')
            ->where('orgo_ord_id', $request['ord_id'])
            ->where('orgo_goo_type', '!=', 3)
            ->select('orgo_id', 'orgo_goo_id as goo_id', 'orgo_goo_name as goo_name', 'orgo_state as goo_state', 'orgo_goo_price as goo_price', 'orgo_goo_quantity as goo_quantity', 'orgo_goo_unit as goo_unit', 'orgo_goo_unta_id as goo_unta_id', 'orgo_goo_type as goo_type', 'orgo_goo_goods_encode as goo_goods_encode', 'orgo_wago_id as wago_id', 'orgo_goo_amount')
            ->get()->toArray();
        $goods_data = json_decode(json_encode($request['goods_data'], true), true);

        // 添加工单客户表数据
        $wocl_data = [
            'wocl_wor_id' => $wor_id,
            'wocl_client_id' => $find_order_data->orcl_client_id ? $find_order_data->orcl_client_id : 0, //选择客户id
            'wocl_adm_id' => $find_order_data->orcl_sales_adm_id ? $find_order_data->orcl_sales_adm_id : 0, //销售人员id
            'wocl_sales_adm_name' => $find_order_data->orcl_sales_adm_name ? $find_order_data->orcl_sales_adm_name : 0, //销售人员id
            'wocl_name' => $find_order_data->orcl_name ? $find_order_data->orcl_name : '',
            'wocl_bus_name' => $find_order_data->orcl_business_name ? $find_order_data->orcl_business_name : '',
            'wocl_bus_id' => $find_order_data->orcl_business_id ? $find_order_data->orcl_business_id : 0,
            'wocl_phone' => $find_order_data->orcl_phone ? $find_order_data->orcl_phone : '',
            'wocl_carowner_name' => $find_order_data->orcl_carowner_name ? $find_order_data->orcl_carowner_name : '',
            'wocl_carowner_phone' => $find_order_data->orcl_carowner_phone ? $find_order_data->orcl_carowner_phone : '',
            'wocl_car_num' => $find_order_data->orcl_car_num ? $find_order_data->orcl_car_num : '',
            'wocl_appoint_remark' => $find_order_data->orcl_appoint_remark ? $find_order_data->orcl_appoint_remark : '', //预约备注
            'wocl_car_vin' => $find_order_data->orcl_car_vin ? $find_order_data->orcl_car_vin : '', //车架号车辆识别码
            'wocl_car_brand_series' => $find_order_data->orcl_car_brand_series ? $find_order_data->orcl_car_brand_series : '', //品牌车系
            'wocl_carbrse_type' => $find_order_data->orcl_carbrse_type ? $find_order_data->orcl_carbrse_type : 1, //品牌车系
            'wocl_check_car_state' => 2, //是否验车1是2否
            'wocl_update_time' => date('Y-m-d H:i:s'),
            'wocl_province' => $find_order_data->orcl_province ? $find_order_data->orcl_province : '',
            'wocl_city' => $find_order_data->orcl_city ? $find_order_data->orcl_city : '',
            'wocl_county' => $find_order_data->orcl_county ? $find_order_data->orcl_county : '',
            'wocl_address' => $find_order_data->orcl_address ? $find_order_data->orcl_address : '',
        ];
        $wocl_id = DB::table('work_client')->insertGetId($wocl_data);

        
        $goo_all_price = 0; //商品总金额
        $goo_all_quantity = 0; //商品总数量
        $goo_all_quantitys = 0;
        $create_dis = false;
        $sepr_id = '';
        $sepr_name = '';
        
        $new_goods_data = [];
        
        // 新增工单商品数据
        foreach ($goods_data as $key => $value) {
            if (!isset($value['goo_waon_class'])) {
                $value['goo_waon_class'] = 1;
                $goods_data[$key]['goo_waon_class'] = 1;
            }
            if (!isset($value['goo_inventory'])) {
                $value['goo_inventory'] = 1;
                $goods_data[$key]['goo_inventory'] = 1;
            }
            
            if ($value['goo_type'] == 2) {
                if ($sepr_id) {
                    $sepr_id = $sepr_id.$value['goo_id'].',';
                } else {
                    $sepr_id = ','.$value['goo_id'].',';
                }
                if ($sepr_name) {
                    $sepr_name = $sepr_name.','.$value['goo_name'];
                } else {
                    $sepr_name = $value['goo_name'];
                }
                $value['wago_id'] = 0;
                $goods_data[$key]['wago_id'] = 0;
            } else {
                if ($find_order_data->ord_ware_id) {
                    $find_wago_id = DB::table('warehouse_goods')
                        ->where('wago_goo_id', $value['goo_id'])
                        ->where('wago_class', $value['goo_waon_class'])
                        ->where('wago_ware_id', $find_order_data->ord_ware_id)
                        ->value('wago_id');
                    $value['wago_id'] = $find_wago_id;
                    $goods_data[$key]['wago_id'] = $find_wago_id;
                    $new_goods_data[] = $value;
                }
            }
            // 搜索商品id对应的商品名称、商品编号
            $find_goods_data = DB::table('goods')
                ->where('goo_id', $value['goo_id'])
                ->first(['goo_name', 'goo_goods_encode', 'goo_type', 'goo_class']);
            if (!empty($value['goo_id'])) {
                if ($value['goo_type'] != 2) {
                    $create_dis = true;
                }
                $wogo_data['wogo_wor_id'] = $wor_id;
                $wogo_data['wogo_orgo_id'] = $value['orgo_id'];
                $wogo_data['wogo_wago_id'] = ($value['goo_type']==1) ? $value['wago_id'] : 0;
                $wogo_data['wogo_goo_id'] = $value['goo_id'];
                $wogo_data['wogo_goo_name'] = $value['goo_name'];
                $wogo_data['wogo_goo_type'] = $value['goo_type'];
                $wogo_data['wogo_goo_inventory'] = $value['goo_inventory'];
                $wogo_data['wogo_state'] = $value['goo_state'];
                $wogo_data['wogo_goo_amount'] = $value['goo_quantity'];
                if ($value['goo_type'] == 1) {
                    if (empty($value['goo_unit']) || empty($value['goo_unta_id'])) {
                        return ['code'=>500, 'msg'=>'请选择单位', 'data'=>'请选择单位'];
                    }
                }
                $wogo_data['wogo_goo_unit'] = $value['goo_unit'];
                $wogo_data['wogo_goo_price'] = $value['goo_price'];
                $wogo_data['wogo_goo_sum'] = $value['goo_price']*$value['goo_quantity'];
                $wogo_data['wogo_goo_unta_id'] = $value['goo_unta_id'];
                $wogo_data['wogo_goo_goods_encode'] = $value['goo_goods_encode'];
                $wogo_data['wogo_update_time'] = date('Y-m-d H:i:s');
                $wogo_id = DB::table('work_good')->insertGetId($wogo_data);
            } else {
                $wogo_id = 0;
            }
            $goo_all_price += $value['goo_price']*$value['goo_quantity']; //总金额

            $goo_all_quantity += $value['goo_quantity']; //商品总数量
            if ($value['goo_type'] == 1) {
                $goo_all_quantitys += $value['goo_quantity']; //商品总数量
            }
        }
        if (!isset($request['service_adm_data'])) {
            return ['code'=>500, 'msg'=>'请选择技师', 'data'=>'请选择技师'];
        }
        $service_adm_data = json_decode($request['service_adm_data'], true);
        $service_adm_id = '';
        if (empty($service_adm_data)) {
            return ['code'=>500, 'msg'=>'请选择技师', 'data'=>'请选择技师'];
        }
        foreach ($service_adm_data as $key1 => $value1) {
            // 工单技师施工部位表
            $wotp_data['wotp_shop_id'] = $user_info->adm_shop_id;
            $wotp_data['wotp_wor_id'] = $wor_id;
            $wotp_data['wotp_service_adm_id'] = $value1['adm_id'];
            // 查询技师相关信息
            $find_adm_data = DB::table('admin as a')
                ->leftJoin('wash_grade_level as b', 'b.grle_id', '=', 'a.adm_grle_id')
                ->leftJoin('wash_grade_professional as c', 'c.grpr_id', '=', 'b.grle_grpr_id')
                ->where('adm_id', $value1['adm_id'])
                ->select('adm_id', 'adm_name', 'adm_phone', 'grle_id', 'grle_name', 'grpr_id', 'grpr_name')
                ->first();
            if (empty($find_adm_data)) {
                return ['code'=>500, 'msg'=>'未找到技师相关信息', 'data'=>'未找到技师相关信息'];
            }
            $wotp_data['wotp_service_adm_name'] = $find_adm_data->adm_name;
            $wotp_data['wotp_service_adm_phone'] = $find_adm_data->adm_phone;
            if ($find_adm_data->grle_id) {
                $wotp_data['wotp_grle_id'] = $find_adm_data->grle_id;
            }
            if ($find_adm_data->grle_name) {
                $wotp_data['wotp_grle_name'] = $find_adm_data->grle_name;
            }
            if ($find_adm_data->grpr_id) {
                $wotp_data['wotp_grpr_id'] = $find_adm_data->grpr_id;
            }
            if ($find_adm_data->grpr_name) {
                $wotp_data['wotp_grpr_name'] = $find_adm_data->grpr_name;
            }
            $wotp_res = DB::table('wash_work_technician_part')->insert($wotp_data);
            unset($wotp_data);
            $service_adm_id = $service_adm_id.','.$value1['adm_id'];
        }
        $order_data['data']['shop_id'] = $shop_id;
        $request['ord_client_id'] = $find_order_data->ord_client_id; //客户id
        $request['ord_type'] = $find_order_data->ord_type;
        $request['service_shop_id'] = $user_info->adm_shop_id;
        if ($create_dis && $find_order_data->ord_ware_id) {
            $dibi_data = DispatchBill::create(
                $user_info,   //用户信息
                $request,  //订单提交数据
                $new_goods_data,  //提交的商品数据
                2,  //类型：1.订单发货 2.工单发货
                $find_order_data->ord_ware_id,  //出库仓库id
                $wor_order_number,  //原始单号，订单号/工单号
                $wor_id,  //发货单关联的工单/订单id
                $order_data['data']['shop_id'],  //所属总店id
                $request['ord_type'],  //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                $request['ord_client_id'],  //选择的客户id,会员id/单位id
                $goo_all_quantitys  //发货总数量
            );
            if ($dibi_data['code'] == 500) {
                return $dibi_data;
            }
        }
        
        if (isset($request['orcl_appoint_time'])) {
            $edit_orcl_data['orcl_appoint_time'] = $request['orcl_appoint_time']; //预约时间
            $edit_orcl_data['orcl_update_time'] = date('Y-m-d H:i:s'); //更新时间
            $orcl_edit_res = DB::table('order_client')->where('orcl_ord_id', $request['ord_id'])->update($edit_orcl_data);
        }
        $edit_data['ord_wor_quantity'] = 1; //工单数量
        $edit_data['ord_explain'] = isset($request['ord_explain']) ? $request['ord_explain'] : $find_order_data->ord_explain; //施工说明
        $edit_data['ord_address'] = isset($request['ord_address']) ? $request['ord_address'] : $find_order_data->ord_address; //施工门店
        $edit_data['ord_address_id'] = isset($request['ord_address_id']) ? $request['ord_address_id'] : $find_order_data->ord_address_id; //施工门店id
        $edit_data['ord_address_type'] = isset($request['ord_address_type']) ? $request['ord_address_type'] : $find_order_data->ord_address_type; //施工门店类型
        $edit_data['ord_wor_state'] = 2; //订单的工单状态1未派工单2服务中3售后中
        $edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = WashOrder::where('ord_id', $request['ord_id'])->update($edit_data);
        $edit_wor_data['wor_service_adm_id'] = $request['service_adm_id'];
        $edit_wor_data['wor_update_time'] = date('Y-m-d H:i:s');
        $edit_wor_res = DB::table('work_order')->where('wor_id', $wor_id)->update($edit_wor_data);

        if ($wor_id && $wocl_id && $ord_edit_res && $wotp_res) {
            $return_data['wor_id'] = $wor_id;
            $return_data['wor_order_number'] = $wor_order_number;
            foreach ($service_adm_data as $key => $value) {
                // 查询技师相关信息
                $find_adm_data = DB::table('admin as a')
                    ->leftJoin('wash_grade_level as b', 'b.grle_id', '=', 'a.adm_grle_id')
                    ->leftJoin('wash_grade_professional as c', 'c.grpr_id', '=', 'b.grle_grpr_id')
                    ->where('adm_id', $value['adm_id'])
                    ->select('adm_id', 'adm_name', 'adm_phone', 'grle_id', 'grle_name', 'grpr_id', 'grpr_name')
                    ->first();
                // 微信消息推送
                $wechat_msg['pushtype'] = 1; //工单推送
                $wechat_msg['adm_id'] = $value['adm_id']; //推送人
                $wechat_msg['wor_number'] = $wor_order_number; //工单号
                $wechat_msg['ord_number'] = $find_order_data->ord_order_number; //订单号
                $wechat_msg['order_type'] = ordType($request['ord_service_type']); //订单类型
                $wechat_msg['user_name'] = $find_adm_data->adm_name; //姓名
                $wechat_msg['sepr_name'] = $sepr_name; //服务项目
                $wechat_msg['orcl_appoint_time'] = $request['orcl_appoint_time']; //预约时间
                $wechat_msg['ord_create_time'] = $find_order_data->ord_create_time; //订单创建时间

                $wechat_msg['user_phone'] = $find_adm_data->adm_phone; //手机号
                $wechat_msg['user_dress'] = $find_order_data->ord_province . $find_order_data->ord_city . $find_order_data->ord_county . $find_order_data->ord_address; //详细地址
                $wechat_msg['tittle'] = '您有新的工单，请及时处理'; //手机
                $wechat_msg['remark'] = !empty($find_order_data->ord_remark) ? $find_order_data->ord_remark : '';
                $CashierDesk = new CashierDesk;
                $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
            }

            //如果是智配贴装订单
            if ($find_order_data->ord_source == 5) {
                $param['serial_number'] = $find_order_data->ord_other_system_number;
                $param['time'] = date('Y-m-d H:i:s');
                $param['daytime'] = $request['orcl_appoint_time'];
                $param['ip'] = Request::getClientIp();
                $param['token'] = config('apiconnect.ZPTZ_TOKEN');
                $url = config('apiconnect.ZPTZ_URL') . '/index.php/api/supplychain/SupplyMz/addDayTime';
                $param_return = doPost($param, $url, 2);
                $param_return = json_decode($param_return, true);
            }
            
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'生成工单失败'];
        }
    }

    /**
     * 获取商品信息
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-03
     * @param  [type]           $user_info  [description]
     * @param  [type]           $request    [description]
     * @param  [type]           $show_count [description]
     * @return [type]                       [description]
     */
    public static function getGoods($user_info, $request, $show_count)
    {
        $search_data = $request;
        $post['string'] = 'goo_';
        $post['user_info'] = $user_info;
        $type = 3;
        $where_data = whereFunction($post,$type);
        $list_data = DB::table('goods as g')
            ->leftJoin('brand_serie as brse', 'brse.brse_id', '=', 'g.goo_brse_id')
            ->where('goo_cid', $user_info->adm_cid)
            ->whereIn($where_data['string'], $where_data['shop_id'])
            ->where('goo_state', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_name'])) {
                    $query->where('goo_name', 'like', '%' . $search_data['goo_name'] . '%')
                        ->orwhere('goo_goods_encode', 'like', '%' . $search_data['goo_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_type'])) {//商品类型
                    $query->where('goo_type', $search_data['goo_type']);
                } else {
                    $query->where('goo_type', 1);
                }

                if (!empty($search_data['goo_bra_id'])) {//品牌
                    $query->where('goo_bra_id', $search_data['goo_bra_id']);
                }
                
                if (!empty($search_data['goo_cate_id'])) {//品类
                    $query->where('goo_cate_id', $search_data['goo_cate_id']);
                }
                if (!empty($search_data['goo_brse_id'])) {//品牌系列id
                    $query->where('goo_brse_id', $search_data['goo_brse_id']);
                }
            }) 
            ->select('goo_id', 'goo_name', 'goo_type', 'goo_goods_encode', 'goo_wholesale_price as goo_price', 'goo_brse_id', 'goo_bra_name', 'goo_unta_id', 'goo_unit', 'goo_unit_conversion', 'brse_name', 'goo_cate_name', 'goo_pic', 'goo_level', 'goo_fid')
            ->orderBy('goo_create_time', 'desc')
            ->orderBy('goo_goods_encode', 'asc')
            ->groupBy('goo_id')
            ->paginate($show_count);

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $show_count;       //一页显示多少个
        $goods_data = $list_data->items();

        if ($goods_data) {
            foreach ($goods_data as $k => $v) {
                $goods_data[$k]->new_goo_unit = $v->goo_unit;
                if (empty($v->goo_pic)) {
                   $goods_data[$k]->goo_pic = config('apisystem.server_name_https').'/image/artificerImg/default_goo_img.png';
                }
                $ware_data = DB::table('warehouse_goods')
                    ->leftJoin('goods', 'goo_id', '=', 'wago_goo_id')
                    ->leftJoin('warehouse', 'ware_id', '=', 'wago_ware_id')
                    ->where('ware_shop_id', $user_info->adm_shop_id)
                    ->where('ware_type', 1)
                    ->where('wago_goo_id', $v->goo_id)
                    ->select('ware_id', 'ware_name', 'wago_stock_number', 'wago_goo_id')
                    ->get()->toArray();
                $goods_data[$k]->ware_data = $ware_data;
                if ($v->goo_level == 1 || ($v->goo_level ==2 && $v->goo_fid)) {
                    $goods_data[$k]->goo_change = 1;
                } else {
                    $goods_data[$k]->goo_change = 2;
                }
            }
        }
        $data_info['goods_data'] = $goods_data;
        $list_button = getAppletListButton($request['api_token'], $request['pri_id']);
        if (!empty($list_button)) {
            $pri_operate_method = array_column($list_button, 'pri_operate_method');
            foreach ($list_button as $key => $value) {
                if ($value['pri_operate_method'] == 'addGoods' && $value['have_pri'] == 1) {
                    $data_info['addGoods'] = true;
                    break;
                } else {
                    $data_info['addGoods'] = false;
                }
            }
        } else {
            $data_info['addGoods'] = false;
        }
        if (!empty($goods_data)) {
            foreach ($goods_data as $key => $value) {
                $buttonData = [];
                foreach ($list_button as $k => $v) {
                    if (in_array('goToOrder',$pri_operate_method) && $v['have_pri'] == 1) {
                        $buttonData[] = 'goToOrder';
                    }
                    if (in_array('stock',$pri_operate_method) && $v['have_pri'] == 1) {
                        $buttonData[] = 'stock';
                    }
                }
                $button = CommonService::getAppletListButton($buttonData,$list_button);
                $goods_data[$key]->button_one = $button['button_one']??[];
                $goods_data[$key]->button_two = $button['button_two']??[];
                $goods_data[$key]->button_three = $button['button_three']??[];
            }
            $data_info['goods_data'] = $goods_data;
            return ['code' => 200, 'msg' => 'success', 'data' => $data_info, 'list_button'=>$list_button];
        } else {
            return ['code' => 200, 'msg' => '暂无数据', 'data' => $data_info, 'list_button'=> $list_button];
        }
    }

    // 获取商品信息详情
    public static function getGoodsInfo($user_info, $request, $show_count)
    {
        $list_data = DB::table('goods as g')
            ->leftJoin('brand_serie as brse', 'brse.brse_id', '=', 'g.goo_brse_id')
            ->where('goo_id', $request['goo_id'])
            ->select('goo_id', 'goo_name', 'goo_type', 'goo_goods_encode', 'goo_wholesale_price as goo_price', 'goo_brse_id', 'goo_bra_name', 'goo_unta_id', 'goo_unit', 'goo_unit_conversion', 'brse_name', 'goo_cate_name', 'goo_pic','goo_level','goo_fid')
            ->first();

        if ($list_data) {
            $list_data->new_goo_unit = $list_data->goo_unit;
            if (empty($list_data->goo_pic)) {
               $list_data->goo_pic = config('apisystem.server_name_https').'/image/artificerImg/default_goo_img.png';
            }
            if ($list_data->goo_level == 1 || ($list_data->goo_level ==2 && !empty($list_data->goo_fid))) {
                $list_data->goo_change = 1;
            } else {
                $list_data->goo_change = 2;
            }
            $ware_data = DB::table('warehouse_goods')
                ->leftJoin('goods', 'goo_id', '=', 'wago_goo_id')
                ->leftJoin('warehouse', 'ware_id', '=', 'wago_ware_id')
                ->where('ware_shop_id', $user_info->adm_shop_id)
                ->where('ware_type', 1)
                // ->where('wago_stock_number', '>', 0)
                ->where('wago_goo_id', $list_data->goo_id)
                ->select('ware_id', 'ware_name', 'wago_stock_number', 'wago_goo_id', 'wago_id', 'goo_unta_id')
                ->get()->toArray();
            
            $list_button = getAppletListButton($request['api_token'], $request['pri_id']);
            $pri_operate_method = array_column($list_button, 'pri_operate_method');
            foreach ($ware_data as $key => $value) {
                $buttonData = [];
                foreach ($list_button as $k => $v) {
                    if (in_array('goToOrder',$pri_operate_method) && $v['have_pri'] == 1 && $value->wago_stock_number > 0) {
                        $buttonData[] = 'goToOrder';
                    }
                    if (in_array('stock',$pri_operate_method) && $v['have_pri'] == 1) {
                        $buttonData[] = 'stock';
                    }
                    if (in_array('unitConversion',$pri_operate_method) && $v['have_pri'] == 1 && $list_data->goo_change == 1) {
                        $buttonData[] = 'unitConversion';
                    }
                }
                $button = CommonService::getAppletListButton($buttonData,$list_button);
                $ware_data[$key]->button_one = $button['button_one']??[];
                $ware_data[$key]->button_two = $button['button_two']??[];
                $ware_data[$key]->button_three = $button['button_three']??[];
            }
            $list_data->ware_data = $ware_data;
        }

        if ($list_data) {
            return ['code' => 200, 'msg' => 'success', 'data' => $list_data];
        } else {
            return ['code' => 500, 'msg' => 'error', 'data' => '暂无数据'];
        }
    }

    /*
     * @name 下服务单修改会员下单时间
     * @param string ju_ordernum 订单单号
     * @retrun array
     * @author Ma 2023/9/6 14:43
     *
    */
    public static function updateOrderCount($mem_id){
        $mem_data = DB::table('member')
            ->where('mem_id', $mem_id)
            ->first();
        if($mem_data){
            if(empty($mem_data->mem_first_time) || $mem_data->mem_first_time == '0000-00-00 00:00:00'){
                $update['mem_first_time'] = date('Y-m-d H:i:s');//首次下单时间
            }
            $update['mem_last_time'] = date('Y-m-d H:i:s');//最后下单时间
            $ret = DB::table('member')->where('mem_id', $mem_id)->update($update);
        }
    }

    //获取当前经验值
    public static function currentExperience($user_info){
        $all_price = 0;
        $amount = DB::table('order')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->whereIN('ord_wor_state', [4,18,19,20])
            ->where('ord_delete', 1)
            ->where('ord_add_type', 1)
            ->where('ord_client_id', $user_info->ussh_user_id)
            /*->select(DB::raw('sum(ord_actual_price) as ord_actual_price'))
            ->first();*/
            ->select('ord_actual_price','ord_mem_price')
            ->get()->toArray();
        foreach ($amount as $key => $value){
            if($value->ord_mem_price > 0){
                $price = $value->ord_mem_price;
            }else{
                $price = $value->ord_actual_price;
            }
            $all_price += $price;
        }
        $value = intval($all_price);
        return $value;
    }

    //会员积分倍数
    public static function getMemLevel($mem_id,$user_info){
        //经验值
        $mem_points_multiple = 1;
        $user_info->ussh_user_id = $mem_id;
        $user_info->adm_shop_id = $user_info->adm_shop_id;
        $user_info->adm_cid = $user_info->adm_cid;
        $user_info->adm_id = $mem_id;
        $experience = self::currentExperience($user_info);

        $mem_level = DB::table('member')
            ->where('mem_id', $mem_id)
            ->value('mem_level');
        if($mem_level != 5){
            $level = DB::table('member_level')
                ->where('meml_shop_id', $user_info->adm_shop_id)
                ->where('meml_type',1)
                ->where('meml_show', 2)//是否显示：1否2是
                ->where('meml_total_amount', '<=',$experience)
                ->select('meml_level','meml_points_multiple')
                ->orderBy('meml_level','desc')
                ->first();
            if($level){
                $mem_level = $level->meml_level;
                $mem_points_multiple = $level->meml_points_multiple;
                $updatelevel = DB::table('member')
                    ->where('mem_id', $mem_id)
                    ->update(['mem_level'=>$mem_level]);
            }
        }else{
            $mem_points_multiple = DB::table('member_level')
                ->where('meml_shop_id', $user_info->adm_shop_id)
                ->where('meml_show', 2)//是否显示：1否2是
                ->where('meml_level', 5)
                ->value('meml_points_multiple');
        }
        return $mem_points_multiple;
    }

    /**
     * 开单添加积分
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-15
     * @param  [type]           $user_info [description]
     * @param  [type]           $mem_id    [description]
     * @param  [type]           $ord_id    [description]
     */
    public static function addPoint($user_info,$mem_id,$ord_id,$mem_points_multiple = 1) {
        
        //积分倍数
        $mem_points_multiple = self::getMemLevel($mem_id,$user_info);
        $find_point_config = DB::table('point_config')
            ->where('poco_shop_id', $user_info->adm_shop_id)
            ->select('poco_point_switch', 'poco_firstord_point', 'poco_firstord_times')
            ->first();
        if(empty($find_point_config)){
            return [];
        }
        $find_point_config->poco_firstord_point = $find_point_config->poco_firstord_point * $mem_points_multiple;
        $find_share_config = DB::table('share_config')
            ->where('shco_shop_id', $user_info->adm_shop_id)
            ->first();
        //shco_first_point  消费者首次进店分享人获取积分数
        //shco_proportion  分享人默认获得积分倍数
        //shco_divide_point  消费者首次进店获取积分数
        //shco_divide_proportion  消费人默认获得积分倍数
//        $find_share_config->shco_first_point = $find_share_config->shco_first_point * $mem_points_multiple;
//        $find_share_config->shco_proportion = $find_share_config->shco_proportion * $mem_points_multiple;
//        $find_share_config->shco_divide_point = $find_share_config->shco_divide_point * $mem_points_multiple;
        if($find_share_config->shco_divide_proportion < $mem_points_multiple) {
            $find_share_config->shco_divide_proportion = $mem_points_multiple;
        }
        $find_mem = DB::table('member')
            ->where('mem_id', $mem_id)
            ->first();
        $find_order_data = DB::table('order')
            ->where('ord_id', $ord_id)
            ->first();
        if ($find_point_config->poco_point_switch == 1) {//开启积分
            if (!empty($find_mem->mem_fid)) {//分享-首次消费获积分
                $point_detail = DB::table('point_detail')
                    ->leftJoin('order', 'pode_ord_id', '=', 'ord_id')
                    ->where('ord_wor_state', '<>', 11)
                    ->where('pode_shop_id', $user_info->adm_shop_id)
                    ->where('pode_mem_id', $mem_id)
                    ->where('pode_add_type', 1)
                    ->first();
                if (empty($point_detail)) {
                    $add_point['pode_shop_id'] = $user_info->adm_shop_id;
                    $add_point['pode_mem_id'] = $mem_id;
                    $add_point['pode_type'] = 1;//1添加积分2扣除积分
                    $add_point['pode_name'] = '首次消费得积分';
                    $add_point['pode_points'] = $find_share_config->shco_divide_point;
                    $add_point['pode_year_month'] = date('Y-m');
                    $add_point['pode_create_time'] = date('Y-m-d H:i:s');
                    $add_point['pode_create_id'] = $user_info->adm_id;
                    $add_point['pode_soure'] = $find_order_data->ord_source;
                    $add_point['pode_add_type'] = 1;
                    $add_point['pode_ord_id'] = $ord_id;
                    if ($add_point['pode_points'] > 0) {
                        $add_point_res = PointService::addPointDetail($add_point);
                    }

                    $add_share_point['pode_shop_id'] = $user_info->adm_shop_id;
                    $add_share_point['pode_mem_id'] = $find_mem->mem_fid;
                    $add_share_point['pode_type'] = 1;
                    $add_share_point['pode_name'] = '好友首次消费得积分';
                    $add_share_point['pode_points'] = $find_share_config->shco_first_point;
                    $add_share_point['pode_year_month'] = date('Y-m');
                    $add_share_point['pode_create_time'] = date('Y-m-d H:i:s');
                    $add_share_point['pode_create_id'] = $user_info->adm_id;
                    $add_share_point['pode_soure'] = $find_order_data->ord_source;
                    $add_share_point['pode_add_type'] = 2;
                    $add_share_point['pode_ord_id'] = $ord_id;
                    if ($add_share_point['pode_points'] > 0) {
                        $add_share_point_res = PointService::addPointDetail($add_share_point);
                    }
                }
                $add_shord_point['pode_shop_id'] = $user_info->adm_shop_id;
                $add_shord_point['pode_mem_id'] = $find_mem->mem_fid;
                $add_shord_point['pode_type'] = 1;
                $add_shord_point['pode_name'] = '好友消费得积分';
                $add_shord_point['pode_points'] = intval($find_share_config->shco_proportion*($find_order_data->ord_actual_price + $find_order_data->ord_banlance)/10);
                $money = intval(($find_order_data->ord_actual_price + $find_order_data->ord_banlance)/100);
                $add_shord_point['pode_year_month'] = date('Y-m');
                $add_shord_point['pode_create_time'] = date('Y-m-d H:i:s');
                $add_shord_point['pode_create_id'] = $user_info->adm_id;
                $add_shord_point['pode_soure'] = $find_order_data->ord_source;
                $add_shord_point['pode_add_type'] = 3;
                $add_shord_point['pode_ord_id'] = $ord_id;
                if ($add_shord_point['pode_points'] > 0 && $money > 0) {
                    $add_shord_point_res = PointService::addPointDetail($add_shord_point);
                }
            }
            // 首单送积分
            if ($find_point_config->poco_firstord_times == 1) {//仅一次
                $point_detail = DB::table('point_detail')
                    ->leftJoin('order', 'pode_ord_id', '=', 'ord_id')
                    ->where('pode_shop_id', $user_info->adm_shop_id)
                    ->where('pode_mem_id', $mem_id)
                    ->where('ord_wor_state', '<>', 11)
                    ->where('pode_add_type', 4)
                    ->first();
            }
            if ($find_point_config->poco_firstord_times == 2) {//每月
                $point_detail = DB::table('point_detail')
                    ->leftJoin('order', 'pode_ord_id', '=', 'ord_id')
                    ->where('pode_shop_id', $user_info->adm_shop_id)
                    ->where('ord_wor_state', '<>', 11)
                    ->where('pode_year_month', date('Y-m'))
                    ->where('pode_mem_id', $mem_id)
                    ->where('pode_add_type', 4)
                    ->first();
            }
            if ($find_point_config->poco_firstord_times == 3) {//每年
                $point_detail = DB::table('point_detail')
                    ->leftJoin('order', 'pode_ord_id', '=', 'ord_id')
                    ->where('pode_shop_id', $user_info->adm_shop_id)
                    ->where('ord_wor_state', '<>', 11)
                    ->where('pode_mem_id', $mem_id)
                    ->where('pode_year_month', 'like', date('Y') . '%')
                    ->where('pode_add_type', 4)
                    ->first();
            }
            if (empty($point_detail)) {
                $add_point_detail['pode_shop_id'] = $user_info->adm_shop_id;
                $add_point_detail['pode_mem_id'] = $mem_id;
                $add_point_detail['pode_type'] = 1;
                $add_point_detail['pode_name'] = '首单送积分';
                $add_point_detail['pode_points'] = $find_point_config->poco_firstord_point;
                $add_point_detail['pode_year_month'] = date('Y-m');
                $add_point_detail['pode_create_time'] = date('Y-m-d H:i:s');
                $add_point_detail['pode_create_id'] = $user_info->adm_id;
                $add_point_detail['pode_soure'] = $find_order_data->ord_source;
                $add_point_detail['pode_add_type'] = 4;
                $add_point_detail['pode_ord_id'] = $ord_id;
                if ($add_point_detail['pode_points'] > 0) {
                    $add_point_detail_res = PointService::addPointDetail($add_point_detail);
                }
            }

            $goods_data = DB::table('order_goods')
                ->where('orgo_ord_id', $ord_id)
                ->select('orgo_id', 'orgo_goo_id', 'orgo_goo_type', 'orgo_goo_point', 'orgo_goo_name')
                ->get()->toArray();
            $point_count = 0;
            foreach ($goods_data as $key => $value) {
                $add_true = false;
                if ($value->orgo_goo_type == 1) {
                    $orgo_goo_type = 2;
                } elseif ($value->orgo_goo_type == 2) {
                    $orgo_goo_type = 1;
                } elseif ($value->orgo_goo_type == 4) {
                    $orgo_goo_type = 3;
                } elseif ($value->orgo_goo_type == 5) {
                    $orgo_goo_type = 3;
                }
                if ($value->orgo_goo_type != 3) {//套餐商品
                    $find_rule = DB::table('point_goods')
                        ->where('pogo_shop_id', $user_info->adm_shop_id)
                        ->where('pogo_enable', 1)
                        ->where('pogo_goo_type', $orgo_goo_type)
                        ->where('pogo_goo_id', $value->orgo_goo_id)
                        ->first();
                } else {
                    $find_rule = '';
                }
                if ($find_rule) {
                    if ($find_rule->pogo_rule == 1) {//仅一次
                        $find_ogpo_data = DB::table('order_goods_point')
                            ->where('ogpo_shop_id', $user_info->adm_shop_id)
                            ->where('ogpo_mem_id', $mem_id)
                            ->where('ogpo_type', 1)
                            ->where('ogpo_orgo_goo_id', $value->orgo_goo_id)
                            ->first();
                        if (!$find_ogpo_data) {
                            $point_count += $value->orgo_goo_point;
                            $add_true = true;
                        }
                    }
                    if ($find_rule->pogo_rule == 2) {//每月
                        $find_ogpo_data = DB::table('order_goods_point')
                            ->where('ogpo_shop_id', $user_info->adm_shop_id)
                            ->where('ogpo_mem_id', $mem_id)
                            ->where('ogpo_type', 1)
                            ->where('ogpo_create_time', 'like', date('Y-m').'%')
                            ->where('ogpo_orgo_goo_id', $value->orgo_goo_id)
                            ->first();
                        if (!$find_ogpo_data) {
                            $point_count += $value->orgo_goo_point;
                            $add_true = true;
                        }
                    }
                    if ($find_rule->pogo_rule == 3) {//每年
                        $find_ogpo_data = DB::table('order_goods_point')
                            ->where('ogpo_shop_id', $user_info->adm_shop_id)
                            ->where('ogpo_mem_id', $mem_id)
                            ->where('ogpo_type', 1)
                            ->where('ogpo_create_time', 'like', date('Y').'%')
                            ->where('ogpo_orgo_goo_id', $value->orgo_goo_id)
                            ->first();
                        if (!$find_ogpo_data) {
                            $point_count += $value->orgo_goo_point;
                            $add_true = true;
                        }
                    }
                    if ($add_true) {
                        $order_goods_point['ogpo_shop_id'] = $user_info->adm_shop_id;
                        $order_goods_point['ogpo_ord_id'] = $ord_id;
                        $order_goods_point['ogpo_orgo_id'] = $value->orgo_id;
                        $order_goods_point['ogpo_orgo_goo_id'] = $value->orgo_goo_id;
                        $order_goods_point['ogpo_mem_id'] = $mem_id;
                        $order_goods_point['ogpo_create_id'] = $user_info->adm_id;
                        $order_goods_point['ogpo_create_time'] = date('Y-m-d H:i:s');
                        $add_order_goods_point = DB::table('order_goods_point')->insertGetId($order_goods_point);
                    }
                }
            }
            $add_ordm_point['pode_shop_id'] = $user_info->adm_shop_id;
            $add_ordm_point['pode_mem_id'] = $mem_id;
            $add_ordm_point['pode_type'] = 1;
            $add_ordm_point['pode_name'] = '消费送积分';
            if (!empty($find_mem->mem_fid)) {//被分享人
                $add_ordm_point['pode_points'] = intval(($find_order_data->ord_actual_price + $find_order_data->ord_banlance)/10*$find_share_config->shco_divide_proportion);
            } else {
                $add_ordm_point['pode_points'] = intval(($find_order_data->ord_actual_price + $find_order_data->ord_banlance)/10*$mem_points_multiple);
            }
            // $add_ordm_point['pode_points'] = intval(($find_order_data->ord_actual_price + $find_order_data->ord_banlance)/10);
            $money = intval(($find_order_data->ord_actual_price + $find_order_data->ord_banlance)/100);
            $add_ordm_point['pode_year_month'] = date('Y-m');
            $add_ordm_point['pode_create_time'] = date('Y-m-d H:i:s');
            $add_ordm_point['pode_create_id'] = $user_info->adm_id;
            $add_ordm_point['pode_soure'] = $find_order_data->ord_source;
            $add_ordm_point['pode_add_type'] = 5;
            $add_ordm_point['pode_ord_id'] = $ord_id;
            if ($add_ordm_point['pode_points'] >= 10 && $money > 0) {
                $add_ordm_point_res = PointService::addPointDetail($add_ordm_point);
            }
            if (intval($point_count) > 0) {
                $add_goo_point['pode_shop_id'] = $user_info->adm_shop_id;
                $add_goo_point['pode_mem_id'] = $mem_id;
                $add_goo_point['pode_type'] = 1;
                $add_goo_point['pode_name'] = '购买商品送积分';
                $add_goo_point['pode_points'] = intval($point_count);
                $add_goo_point['pode_year_month'] = date('Y-m');
                $add_goo_point['pode_create_time'] = date('Y-m-d H:i:s');
                $add_goo_point['pode_create_id'] = $user_info->adm_id;
                $add_goo_point['pode_soure'] = $find_order_data->ord_source;
                $add_goo_point['pode_add_type'] = 6;
                $add_goo_point['pode_ord_id'] = $ord_id;
                $add_goo_point_res = PointService::addPointDetail($add_goo_point);
            }
        }
    }

    /**
     * 取消订单或退款还回积分
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-15
     * @param  [type]           $user_info [用户信息]
     * @param  [type]           $mem_id    [会员id]
     * @param  [type]           $ord_id    [订单id]
     * @return [type]                      [description]
     */
    public static function reducePoint($user_info,$mem_id,$ord_id,$refund_id=0) {
        $point_detail = DB::table('point_detail')
            ->where('pode_shop_id', $user_info->adm_shop_id)
            ->where('pode_ord_id', $ord_id)
            ->get()->toArray();
        $find_order_data = DB::table('order')
            ->where('ord_id', $ord_id)
            ->first();
        $money = $find_order_data->ord_actual_price + $find_order_data->ord_banlance;
        if (!empty($point_detail)) {
            // pode_add_type 1被分享者首次消费得积分2好友首次消费分享者得积分3好友消费得积分4首单送积分5消费送积分
            foreach ($point_detail as $key => $value) {
                if ($money == 0) {
                    if ($value->pode_add_type == 1) {
                        $add_point['pode_shop_id'] = $user_info->adm_shop_id;
                        $add_point['pode_mem_id'] = $value->pode_mem_id;
                        $add_point['pode_type'] = 2;//1添加积分2扣除积分
                        $add_point['pode_name'] = '首次消费得积分(退)';
                        $add_point['pode_points'] = -$value->pode_points;
                        $add_point['pode_year_month'] = date('Y-m');
                        $add_point['pode_create_time'] = date('Y-m-d H:i:s');
                        $add_point['pode_create_id'] = $user_info->adm_id;
                        $add_point['pode_soure'] = $value->pode_soure;
                        $add_point['pode_add_type'] = 7;
                        $add_point['pode_ord_id'] = $ord_id;
                        $add_point_res = PointService::addPointDetail($add_point);
                    }

                    if ($value->pode_add_type == 2) {
                        $add_share_point['pode_shop_id'] = $user_info->adm_shop_id;
                        $add_share_point['pode_mem_id'] = $value->pode_mem_id;
                        $add_share_point['pode_type'] = 2;
                        $add_share_point['pode_name'] = '好友首次消费得积分(退)';
                        $add_share_point['pode_points'] = -$value->pode_points;
                        $add_share_point['pode_year_month'] = date('Y-m');
                        $add_share_point['pode_create_time'] = date('Y-m-d H:i:s');
                        $add_share_point['pode_create_id'] = $user_info->adm_id;
                        $add_share_point['pode_soure'] = $value->pode_soure;
                        $add_share_point['pode_add_type'] = 8;
                        $add_share_point['pode_ord_id'] = $ord_id;
                        $add_share_point_res = PointService::addPointDetail($add_share_point);
                    }

                    if ($value->pode_add_type == 4) {
                        $add_point_detail['pode_shop_id'] = $user_info->adm_shop_id;
                        $add_point_detail['pode_mem_id'] = $value->pode_mem_id;
                        $add_point_detail['pode_type'] = 2;
                        $add_point_detail['pode_name'] = '首单送积分(退)';
                        $add_point_detail['pode_points'] = -$value->pode_points;
                        $add_point_detail['pode_year_month'] = date('Y-m');
                        $add_point_detail['pode_create_time'] = date('Y-m-d H:i:s');
                        $add_point_detail['pode_create_id'] = $user_info->adm_id;
                        $add_point_detail['pode_soure'] = $value->pode_soure;
                        $add_point_detail['pode_add_type'] = 9;
                        $add_point_detail['pode_ord_id'] = $ord_id;
                        $add_point_detail_res = PointService::addPointDetail($add_point_detail);
                    }
                }
                if ($refund_id) {
                    $find_reprice = DB::table('refund')
                        ->where('ref_id', $refund_id)
                        ->value('ref_amount');
                }
                if ($value->pode_add_type == 3) {
                    $add_shord_point['pode_shop_id'] = $user_info->adm_shop_id;
                    $add_shord_point['pode_mem_id'] = $value->pode_mem_id;
                    $add_shord_point['pode_type'] = 2;
                    $add_shord_point['pode_name'] = '好友消费得积分(退)';
                    if ($refund_id) {
                        $add_shord_point['pode_points']  = - intval($value->pode_points*$find_reprice/$find_order_data->ord_order_price);
                    } else {
                        $add_shord_point['pode_points'] = - intval($value->pode_points);
                    }
                    $add_shord_point['pode_year_month'] = date('Y-m');
                    $add_shord_point['pode_create_time'] = date('Y-m-d H:i:s');
                    $add_shord_point['pode_create_id'] = $user_info->adm_id;
                    $add_shord_point['pode_soure'] = $value->pode_soure;
                    $add_shord_point['pode_add_type'] = 10;
                    $add_shord_point['pode_ord_id'] = $ord_id;
                    $add_shord_point_res = PointService::addPointDetail($add_shord_point);
                }

                if ($value->pode_add_type == 5) {
                    $add_goo_point['pode_shop_id'] = $user_info->adm_shop_id;
                    $add_goo_point['pode_mem_id'] = $value->pode_mem_id;
                    $add_goo_point['pode_type'] = 2;
                    $add_goo_point['pode_name'] = '消费送积分(退)';
                    if ($refund_id) {
                        $add_goo_point['pode_points']  = - intval($value->pode_points*$find_reprice/$find_order_data->ord_order_price);
                    } else {
                        $add_goo_point['pode_points'] = - intval($value->pode_points);
                    }
                    $add_goo_point['pode_year_month'] = date('Y-m');
                    $add_goo_point['pode_create_time'] = date('Y-m-d H:i:s');
                    $add_goo_point['pode_create_id'] = $user_info->adm_id;
                    $add_goo_point['pode_soure'] = $value->pode_soure;
                    $add_goo_point['pode_add_type'] = 11;
                    $add_goo_point['pode_ord_id'] = $ord_id;
                    $add_shord_point_res = PointService::addPointDetail($add_goo_point);
                }

                if ($value->pode_add_type == 6) {
                    $find_goods = DB::table('order_goods_point as ogpo')
                        ->leftJoin('order_goods as orgo', 'orgo_id', '=', 'ogpo_orgo_id')
                        ->where('ogpo_ord_id', $ord_id)
                        ->select('orgo_recycle_quantity', 'orgo_goo_quantity', 'orgo_goo_point', 'ogpo_id', 'orgo_goo_return_quantity')
                        ->get()->toArray();
                    $find_refund = DB::table('refund')
                        ->where('ref_status', 2)
                        ->where('ref_order_number', $find_order_data->ord_order_number)
                        ->sum('ref_amount');
                    $orgo_goo_point = 0;
                    foreach ($find_goods as $key1 => $value1) {
                        if ($find_order_data->ord_wor_state == 11 || $find_refund == $find_order_data->ord_order_price) {
                            $update_data['ogpo_type'] = 2;
                            $update_data['ogpo_update_time'] = date('Y-m-d H:i:s');
                            $update_data_res = DB::table('order_goods_point')
                                ->where('ogpo_id', $value1->ogpo_id)
                                ->update($update_data);
                            $orgo_goo_point += $value1->orgo_goo_point;
                        }
                    }
                    if ($orgo_goo_point > 0) {
                        $add_ordm_point['pode_shop_id'] = $user_info->adm_shop_id;
                        $add_ordm_point['pode_mem_id'] = $value->pode_mem_id;
                        $add_ordm_point['pode_type'] = 2;
                        $add_ordm_point['pode_name'] = '购买商品送积分(退)';
                        $add_ordm_point['pode_points'] = -$orgo_goo_point;
                        $add_ordm_point['pode_year_month'] = date('Y-m');
                        $add_ordm_point['pode_create_time'] = date('Y-m-d H:i:s');
                        $add_ordm_point['pode_create_id'] = $user_info->adm_id;
                        $add_ordm_point['pode_soure'] = $value->pode_soure;
                        $add_ordm_point['pode_add_type'] = 12;
                        $add_ordm_point['pode_ord_id'] = $ord_id;
                        $add_shord_point_res = PointService::addPointDetail($add_ordm_point);
                    }
                }
            }
        }
    }

    public static function add_most($user_info, $request) {
        $adm_shop_leave = DB::table('admin_shop_role')
            ->where('adm_id', $user_info->adm_id)
            ->where('shop_id', $user_info->adm_shop_id)
            ->value('adm_shop_leave');
        if ($adm_shop_leave == 1) {//店长
            $find_most = DB::table('moudle_statistics')
                ->where('most_shop_id', $user_info->adm_shop_id)
                ->where('most_adm_id', $user_info->adm_id)
                ->where('most_moudle_id', $request['most_moudle_id'])
                ->exists();
            if (!$find_most) {
                $add_most['most_shop_id'] = $user_info->adm_shop_id;
                $add_most['most_adm_id'] = $user_info->adm_id;
            }
        }
    }

    /**
     * 新增采购计划
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-31
     * @param  [type]           $user_info [description]
     * @param  [type]           $data      [description]
     */
    public static function addGoodPlan($user_info,$data) {
        $goods_data = $data['new_goods_data'];
        foreach ($goods_data as $key => $value) {
            $find_warehouse_goods = DB::table('warehouse_goods')
                ->where('wago_ware_id', $data['ware_id'])
                ->where('wago_goo_id', $value['goo_id'])
                ->where('wago_class', 1)
                ->select('wago_goo_id', 'wago_ware_id', 'wago_stock_number')
                ->first();
            $find_dego_order = DB::table('order_goods')
                ->leftjoin('order', 'ord_id', '=', 'orgo_ord_id')
                ->leftJoin('dispatch_bill', 'dego_original_number', '=', 'ord_order_number')
                ->where('ord_ware_id', $data['ware_id'])
                ->where('ord_add_work_state', 2)
                ->where('orgo_goo_id', $value['goo_id'])
                ->where('orgo_goo_type', 1)
                ->where('dego_order_type', 1)
                ->where('ord_delete', 1)
                ->where('dego_type', 1)
                ->select(DB::raw('SUM(orgo_goo_quantity) as count'))
                ->get();//产品单 未发货
            $find_dego_work1 = DB::table('order_goods')
                ->leftjoin('order', 'ord_id', '=', 'orgo_ord_id')
                ->leftJoin('work_order', 'wor_order_id', '=', 'ord_id')
                ->where('ord_ware_id', $data['ware_id'])
                ->where('orgo_goo_id', $value['goo_id'])
                ->where('ord_add_work_state', 1)
                ->where('ord_wor_quantity', 0)
                ->where('ord_delete', 1)
                ->select(DB::raw('SUM(orgo_goo_quantity) as count'))
                ->get();//待派单 未发货
            $find_dego_work2 = DB::table('order_goods')
                ->leftjoin('order', 'ord_id', '=', 'orgo_ord_id')
                ->leftJoin('work_order', 'wor_order_id', '=', 'ord_id')
                ->leftJoin('dispatch_bill', 'dego_original_number', '=', 'wor_number')
                ->where('ord_ware_id', $data['ware_id'])
                ->where('orgo_goo_id', $value['goo_id'])
                ->where('ord_add_work_state', 1)
                ->where('dego_order_type', 2)
                ->where('dego_type', 1)
                ->where('ord_delete', 1)
                ->select(DB::raw('SUM(orgo_goo_quantity) as count'))
                ->get();//生成工单未发货
            $find_dego_after = DB::table('wash_after_sale_items')
                ->leftjoin('wash_after_sale_list', 'afsl_id', '=', 'afsi_afsl_id')
                ->leftJoin('dispatch_bill', 'dego_original_number', '=', 'afsl_after_number')
                ->where('afsl_ware_id', $data['ware_id'])
                ->where('afsi_goo_id', $value['goo_id'])
                ->where('dego_order_type', 3)
                ->where('dego_type', 1)
                ->where('afsi_type', 2)
                ->select(DB::raw('SUM(afsi_goo_quantity) as count'))
                ->get();
            $storage_goods = DB::table('storage_goods')
                ->leftJoin('purchase_order', 'cg_number', '=', 'relation_number')
                ->whereIn('cg_state',[1,2,3,5,8])
                ->where('cg_shop_id', $user_info->adm_shop_id)
                ->where('goods_id', $value['goo_id'])
                ->where('cg_wareid', $data['ware_id'])
                ->select(DB::raw('SUM((goods_num - ruku_num)) as count'))
                ->get();
            $ord_goods_quantity = $find_dego_order[0]->count + $find_dego_work1[0]->count + $find_dego_work2[0]->count + $find_dego_after[0]->count;//订单待发货数量
            $wago_stock_number = $find_warehouse_goods ? $find_warehouse_goods->wago_stock_number : 0;
            $goods_num = $storage_goods[0]->count;
            // dump($find_dego_order[0]->count);
            // dump($find_dego_work1[0]->count);
            // dump($find_dego_work2[0]->count);
            // dump($find_dego_after[0]->count);
            // die;
            
            if ($ord_goods_quantity > $wago_stock_number) {
                $state = 2;
                $state_name = '缺货';
                if (!empty($goods_num)) {
                    $state = 3;
                    $state_name = '采购中';
                }
            } else {
                $state = 1;
                $state_name = '正常';
            }
            $find_pupl = DB::table('purchasing_plan')
                ->where('pupl_shop_id',$user_info->adm_shop_id)
                ->where('pupl_ware_id', $data['ware_id'])
                ->where('pupl_goo_id', $value['goo_id'])
                ->first();
            if (empty($find_pupl)) {
                $add_data['pupl_shop_id'] = $user_info->adm_shop_id;
                $add_data['pupl_goo_id'] = $value['goo_id'];
                $add_data['pupl_ware_id'] = $data['ware_id'];
                $add_data['pupl_state'] = $state;
                $add_data['pupl_state_name'] = $state_name;
                $add_data['pupl_ord_nums'] = $ord_goods_quantity;
                $add_data['pupl_wago_nums'] = $wago_stock_number;
                $add_data['pupl_cg_nums'] = $goods_num;
                $add_res = DB::table('purchasing_plan')->insertGetId($add_data);
            } else {
                $add_data['pupl_state'] = $state;
                $add_data['pupl_state_name'] = $state_name;
                $add_data['pupl_ord_nums'] = $ord_goods_quantity;
                $add_data['pupl_wago_nums'] = $wago_stock_number;
                $add_data['pupl_cg_nums'] = $goods_num;
                $add_res = DB::table('purchasing_plan')
                    ->where('pupl_id', $find_pupl->pupl_id)
                    ->update($add_data);
            }
        }
            // die;
    }
}
