<?php

namespace App\Services\Business;

use App\Models\Business\WashOrder;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\Business\WashDispatchValidator;
use App\Http\Models\Services\Dispatch;
use App\Services\Business\WashOrderService;

class WashDispatchService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->mainValidator = new WashDispatchValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param object $user_info 用户信息
     * @param array $search_data 内容
     * @param int $show_count 页容量
     * @return mixed
     */
    public function searchPage($user_info, $request, $show_count = 10)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->adm_shop_id;
        $search_data = $request;
        $list_data = DB::table('dispatch_bill as dibi')
            ->leftjoin('work_order as wor', 'wor.wor_id', '=', 'dibi.dego_wor_id')
            ->leftJoin('admin as a', 'a.adm_id', '=', 'dibi.dego_service_adm_id')
            ->leftJoin('warehouse as w', 'w.ware_id', '=', 'dibi.dego_out_ware_id')
            ->where('dego_cid', $user_info->adm_cid)
            ->where('dego_shop_id', $shop_id)
            ->where('dego_type', '<>', 3)
            ->where(function ($query) use ($search_data) { //类型：1未出库2已出库
                if (!empty($search_data['dego_type'])) {
                    $query->where('dego_type', $search_data['dego_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //关键字搜索
                if (!empty($search_data['keywords'])) {
                    $query->where('dego_number', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('wor_order_number', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('dego_original_number', 'like', '%' . $search_data['keywords'] . '%');
                }
            })
            ->select('dego_id', 'wor_order_number', 'dego_create_time', 'dego_number', 'dego_original_number', 'dego_count', 'dego_service_shop_id', 'dego_out_ware_id', 'dego_service_adm_id', 'dego_type', 'dego_wor_id', 'dego_order_type', 'adm_phone', 'adm_name', 'ware_name', 'wor_service_state')
            ->orderBy('dego_id', 'desc')
            ->paginate($show_count);

        $list_items = $list_data->items();
        if ($list_items) {
            $order_id = [];
            $wor_id = [];
            $after_id = [];
            $shop_id = array_unique(array_column($list_items, 'dego_service_shop_id')); //服务门店id
            $ware_id = array_unique(array_column($list_items, 'dego_out_ware_id')); //出库仓库id
            $dego_client_id = array_unique(array_column($list_items, 'dego_client_id')); //选择的客户id,会员id/单位id
            foreach ($list_items as $key => $value) {
                // 订单发货 显示销售人
                if ($value->dego_order_type == 1) {
                    $dego_service_adm_data = DB::table('order')
                        ->leftjoin('order_client', 'orcl_ord_id', '=', 'ord_id')
                        ->leftjoin('admin', 'adm_id', '=', 'orcl_sales_adm_id')
                        ->where('ord_order_number', $value->dego_original_number)
                        ->select('orcl_sales_adm_id', 'adm_name', 'adm_phone', 'ord_create_id')
                        ->first();
                    if (!empty($dego_service_adm_data)) {
                        $list_items[$key]->dego_service_adm_id = $dego_service_adm_data->orcl_sales_adm_id;
                        $list_items[$key]->adm_name = $dego_service_adm_data->adm_name;
                        $list_items[$key]->adm_phone = $dego_service_adm_data->adm_phone;
                        $list_items[$key]->ord_create_name = DB::table('admin')
                            ->where('adm_id', $dego_service_adm_data->ord_create_id)
                            ->value('adm_name');
                        $list_items[$key]->orcl_sales_adm_name = $dego_service_adm_data->adm_name;
                    } else {
                        $list_items[$key]->dego_service_adm_id = '';
                        $list_items[$key]->adm_name = '';
                        $list_items[$key]->adm_phone = '';
                        $list_items[$key]->ord_create_name = '';
                    }
                }
                // 工单发货
                if ($value->dego_order_type == 2) {
                    $wor_id[] = $value->dego_wor_id;
                    $list_items[$key]->ord_create_name = DB::table('work_order')
                        ->leftjoin('order', 'ord_id', '=', 'wor_order_id')
                        ->leftjoin('admin', 'adm_id', '=', 'ord_create_id')
                        ->where('wor_id', $value->dego_wor_id)
                        ->value('adm_name');

                    $list_items[$key]->orcl_sales_adm_name = DB::table('work_order')
                        ->leftjoin('order', 'ord_id', '=', 'wor_order_id')
                        ->leftjoin('order_client', 'ord_id', '=', 'orcl_ord_id')
                        ->leftjoin('admin', 'adm_id', '=', 'orcl_sales_adm_id')
                        ->where('wor_id', $value->dego_wor_id)
                        ->value('adm_name');
                }
                // 售后单发货
                if ($value->dego_order_type == '3') {
                    $after_id[] = $value->dego_wor_id;
                }
                $goo_data = DB::table('dispatch_goods as dg')
                    ->leftjoin('goods as g', 'g.goo_id', '=', 'dg.digo_goo_id')
                    ->where('digo_dego_id', $value->dego_id)
                    ->select('goo_name', 'digo_goo_unit', 'digo_goo_unta_id', 'goo_unit_conversion', 'goo_unit', 'goo_unta_id', 'digo_goo_quantity')
                    ->get()->toArray();
                if ($goo_data) {
                    $list_items[$key]->goo_data = $goo_data;
                    unset($goo_data);
                }   
            }

            // 查找门店id对应的门店名称
            $shop_id = array_unique($shop_id);
            $find_shop = DB::table('shop')
                ->whereIn('shop_id', $shop_id)
                ->select('shop_id', 'shop_store_name')
                ->get()->toArray();
            // 查找仓库id对应的仓库名称 / 负责人
            $ware_id = array_unique($ware_id);
            $find_ware = DB::table('warehouse as w')
                ->whereIn('ware_id', $ware_id)
                ->select('ware_id', 'ware_name', 'ware_type', 'ware_leader_id')
                ->get()->toArray();
            foreach ($find_ware as $key => $value) {
                $adm_id = explode(',',$value->ware_leader_id);
                $adm_name = DB::table('admin')
                    ->whereIn('adm_id', $adm_id)
                    ->select('adm_name')
                    ->get()->toArray();
                $adm_name = array_column($adm_name, 'adm_name');
                $adm_name =  implode(',', $adm_name);
                $find_ware[$key]->adm_name = $adm_name;
            }
            // 查询客户单位
            $channel = DB::table('channel_unit')
                ->whereIn('chun_id', $dego_client_id)
                ->where('chun_shop_id', $shop_id)
                ->where('chun_state', '1')
                ->pluck('chun_id', 'chun_unit_name')
                ->toArray();
            // 查找工单客户信息
            $work_client = DB::table('work_order as wor')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->whereIn('wocl_wor_id', $wor_id)
                ->select('wocl_wor_id', 'wocl_channel_unit', 'wocl_name', 'wor_type', 'wor_service_state', 'wocl_standby_battery_type', 'wor_order_number', 'wocl_client_id')
                ->get()->toArray();
            foreach ($work_client as $key => $value) {
                // 客户单位名称
                if (isset($channel[$value->wocl_client_id])) {
                    $work_client[$key]->wocl_channel_unit = $channel[$value->wocl_client_id];
                } else {
                    $work_client[$key]->wocl_channel_unit = $value->wocl_channel_unit ? $value->wocl_channel_unit : $value->wocl_name;
                }
            }
            // 查找订单客户信息
            $order_client = DB::table('order as ord')
                ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                ->whereIn('orcl_ord_id', $order_id)
                ->get(['orcl_ord_id', 'orcl_channel_unit', 'orcl_name', 'ord_type', 'orcl_standby_battery_type', 'ord_order_number', 'orcl_client_id']);
            foreach ($order_client as $key => $value) {
                // 客户单位名称
                if (isset($channel[$value->orcl_client_id])) {
                    $order_client[$key]->orcl_channel_unit = $channel[$value->orcl_client_id];
                } else {
                    $order_client[$key]->orcl_channel_unit = $value->orcl_channel_unit ? $value->orcl_channel_unit : $value->orcl_name;
                }
            }

            // 查询当前账号所拥有的仓库权限
            $find_admin_set = DB::table('admin_set')
                ->where('adms_adm_id', $user_info->adm_id)
                ->where('adms_shop_id', $user_info->adm_shop_id)
                ->value('adms_myware_id');
        } else {
            $find_shop = [];
            $find_ware = [];
            $find_admin = [];
            $order_client = [];
            $work_client = [];
            $find_admin_set = '';
        }

        $state_count = DB::table('dispatch_bill')
            ->where('dego_cid', $user_info->adm_cid)
            ->where('dego_shop_id', $user_info->adm_shop_id)
            ->select(DB::raw('count(*) as count, dego_type'))
            ->groupBy('dego_type')
            ->get();
        $rec_state_count = DB::table('recede_recycle')
            ->where('rec_cid', $user_info->adm_cid)
            ->where('rec_superior_shop_id', $user_info->adm_shop_id)
            ->select(DB::raw('count(*) as count, rec_state'))
            ->groupBy('rec_state')
            ->get();

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据
        $data_info['state_count'] = $state_count;
        $data_info['rec_state_count'] = $rec_state_count;
        $data_info['order_client'] = $order_client;    //订单客户名称
        $data_info['work_client'] = $work_client;      //工单客户名称
        $data_info['find_admin_set'] = $find_admin_set;      //当前账号所拥有的仓库权限

        // 获取当前列表下的按钮
        if ($list_data) {
            return ['code'=>200, 'msg'=>'success', 'data'=>$data_info];
        } else {
            return ['code'=>200, 'msg'=>'暂无数据', 'data'=>$data_info];
        }
    }

    public static function shipments($user_info, $request)
    {
        // 验证已经发货的不能再次发货
        $dis_data = DB::table('dispatch_bill')
            ->where('dego_id', $request['dego_id'])
            ->select('dego_type', 'dego_cid', 'dego_shop_id', 'dego_out_ware_id', 'dego_service_adm_id', 'dego_number', 'dego_order_type', 'dego_wor_id', 'dego_original_number', 'dego_service_shop_id', 'dego_count', 'dego_create_adm_id', 'dego_id', 'dego_client_type', 'dego_client_id', 'dego_remark')
            ->first();
        if (empty($dis_data)) {
            return ['code'=>500, 'msg'=>'当前发货单不存在！', 'data'=>'当前发货单不存在！'];
        }
        if ($dis_data->dego_type == 2) {
            return ['code'=>500, 'msg'=>'当前发货单已发货！', 'data'=>'当前发货单已发货！'];
        }
        if ($dis_data->dego_type == 3) {
            return ['code'=>500, 'msg'=>'当前发货单已作废！', 'data'=>'当前发货单已作废！'];
        }
        if ($dis_data->dego_type == 4) {
            return ['code'=>500, 'msg'=>'当前发货单已锁定，无法发货！', 'data'=>'当前发货单已锁定，无法发货！'];
        }

        if ($request['type'] == '1') { //获取页面数据
            $digo_data = DB::table('dispatch_goods as digo')
                ->leftjoin('goods as goo', 'goo.goo_id', '=', 'digo.digo_goo_id')
                ->where('digo_dego_id', $request['dego_id'])
                ->where('digo_state', '!=', '2')
                ->select('digo_id', 'digo_wago_class', 'digo_goo_id', 'digo_goo_type', 'digo_goo_name', 'digo_goo_goods_encode', 'digo_goo_quantity', 'digo_is_recycle', 'digo_goo_inventory', 'digo_state', 'digo_tem_goo_name', 'goo_bra_name', 'goo_brse_id', 'goo_class', 'digo_wago_id', 'digo_orgo_id', 'digo_goo_unit', 'digo_goo_unta_id', 'goo_unit_conversion', 'goo_unta_id')
                ->get()->toArray();
            // 查询系列数据
            $goo_brse_id = array_column($digo_data, 'goo_brse_id');
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $goo_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            foreach ($digo_data as $key => $value) {
                // 查询仓位商品表中有发货商品的数据
                $digo_data[$key]->option_freight = DB::table('warehouse_freight_goods as wafg')
                    ->leftjoin('warehouse_freight as wafr', 'wafg.wafg_wafr_id', '=', 'wafr.wafr_id')
                    ->where('wafg_ware_id', $dis_data->dego_out_ware_id)
                    ->where('wafg_wago_id', $value->digo_wago_id)
                    ->where('wafg_class', $value->digo_wago_class)
                    ->where('wafg_goo_id', $value->digo_goo_id)
                    ->where(function ($query) use ($value) {
                        if ($value->digo_goo_inventory == 1) {
                            $query->where('wafg_stock_number', '>', 0);
                        } else {
                            $query->where('wafg_priority_stock_number', '>', 0);
                        }
                    })
                    ->select('wafr_id', 'wafr_name', 'wafr_rank', 'wafg_stock_number', 'wafg_priority_stock_number')
                    ->get()->toArray();

                // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                    if (!empty($value->goo_brse_id)) {
                        if ($value->goo_class == 2) {
                            $digo_data[$key]->digo_goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->digo_goo_name;
                            unset($digo_data[$key]->goo_brse_id);
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $digo_data[$key]->digo_goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->digo_goo_name;
                                unset($digo_data[$key]->goo_brse_id);
                            }
                        }
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if ($value->goo_class == 2) {
                        $digo_data[$key]->digo_goo_name = $value->goo_bra_name . ' ' . $value->digo_goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $digo_data[$key]->digo_goo_name = $value->goo_bra_name . ' ' . $value->digo_goo_name;
                        }
                    }
                }
                unset($digo_data[$key]->goo_class);
            }
            // 查询服务门店名称
            $dis_data->dego_service_shop_name = DB::table('shop')
                ->where('shop_id', $dis_data->dego_service_shop_id)
                ->value('shop_store_name');
            // 查询仓库名称
            $dis_data->ware_name = DB::table('warehouse')
                ->where('ware_id', $dis_data->dego_out_ware_id)
                ->value('ware_name');
            // 查询领货人名称
            $dis_data->adm_name = DB::table('admin')
                ->where('adm_id', $dis_data->dego_create_adm_id)
                ->value('adm_name');
            // 订单发货
            if ($dis_data->dego_order_type == 1) {
                // 查找订单客户信息
                $order_client = DB::table('order as ord')
                    ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                    ->where('orcl_ord_id', $dis_data->dego_wor_id)
                    ->select('orcl_ord_id', 'orcl_channel_unit', 'ord_type', 'orcl_standby_battery_type', 'orcl_client_id', 'ord_create_time', 'orcl_name', 'orcl_phone', 'ord_explain')
                    ->first();
                $wor_create_time = $order_client->ord_create_time;
                $order_client->orcl_channel_unit = DB::table('channel_unit')
                    ->where('chun_id', $order_client->orcl_client_id)
                    ->value('chun_unit_name');
                unset($order_client->orcl_client_id);
                $dego_service_adm_data = DB::table('order')
                    ->leftjoin('order_client', 'orcl_ord_id', '=', 'ord_id')
                    ->leftjoin('admin', 'adm_id', '=', 'orcl_sales_adm_id')
                    ->where('ord_order_number', $dis_data->dego_original_number)
                    ->select('orcl_sales_adm_id', 'adm_name', 'adm_phone')
                    ->first();
                if (!empty($dego_service_adm_data)) {
                    $dis_data->dego_service_adm_id = $dego_service_adm_data->orcl_sales_adm_id;
                    $dis_data->adm_name = $dego_service_adm_data->adm_name;
                    $dis_data->adm_phone = $dego_service_adm_data->adm_phone;
                } else {
                    $dis_data->dego_service_adm_id = '';
                    $dis_data->adm_name = '';
                    $dis_data->adm_phone = '';
                }
            } else {
                $order_client = [];
            }

            // 工单发货
            if ($dis_data->dego_order_type == 2) {
                // 查找工单客户信息
                $work_client = DB::table('work_order as wor')
                    ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                    ->leftjoin('admin as a', 'a.adm_id', '=', 'wor.wor_service_adm_id')
                    ->where('wocl_wor_id', $dis_data->dego_wor_id)
                    ->select('wocl_wor_id', 'wocl_channel_unit', 'wocl_name', 'wor_type', 'wocl_standby_battery_type', 'wocl_client_id', 'wor_create_time', 'wor_service_adm_id', 'adm_name as wor_service_adm_name', 'adm_phone as wor_service_adm_phone', 'wocl_phone', 'wocl_province', 'wocl_city', 'wocl_county', 'wocl_address')
                    ->first();
                $wor_create_time = $work_client->wor_create_time;
                $work_client->wocl_channel_unit = DB::table('channel_unit')
                    ->where('chun_id', $work_client->wocl_client_id)
                    ->value('chun_unit_name');
                unset($work_client->wocl_client_id);
                $dis_data->adm_name = $work_client->wor_service_adm_name;
            } else {
                $work_client = [];
            }

            if ($dis_data->dego_order_type == 3) {
                $wor_create_time = '';
            }
            
            $dis_data->wor_create_time = $wor_create_time;
            $data['dis_data'] = $dis_data;
            $data['work_client'] = $work_client;
            $data['dispatch_goods'] = $digo_data;
            $find_data = DB::table('dispatch_bill')
                ->where('dego_id', $request['dego_id'])
                ->select('dego_order_type', 'dego_original_number', 'dego_wor_id')
                ->first();
            $ord_id = '';
            if (!empty($find_data)) {
                if ($find_data->dego_order_type == 1) {//类型：1.订单发货 2.工单发货3售后单发货
                    $ord_id = $find_data->dego_wor_id;
                }
                if ($find_data->dego_order_type == 2) {//类型：1.订单发货 2.工单发货3售后单发货
                    $ord_id = DB::table('work_order')
                        ->where('wor_id', $find_data->dego_wor_id)
                        ->value('wor_order_id');
                }
                if ($find_data->dego_order_type == 3) {//类型：1.订单发货 2.工单发货3售后单发货
                    $after_data = DB::table('wash_after_sale_list as afsl')
                        ->where('afsl_id',$find_data->dego_wor_id)
                        ->first();
                    $ord_id = $after_data->afsl_ord_id;
                }
            }
            $order_client = DB::table('order as ord')
                ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                ->where('orcl_ord_id', $ord_id)
                ->select('orcl_ord_id', 'orcl_channel_unit', 'ord_type', 'orcl_standby_battery_type', 'orcl_client_id', 'ord_create_time', 'orcl_name', 'orcl_phone', 'ord_explain')
                ->first();
            $data['order_client'] = $order_client;
            $dis_data->ord_create_name = DB::table('order')
                ->leftjoin('admin', 'ord_create_id', '=', 'adm_id')
                ->where('ord_id', $ord_id)
                ->value('adm_name');
            $orcl_sales_adm_data = DB::table('order_client')
                ->leftjoin('admin', 'orcl_sales_adm_id', '=', 'adm_id')
                ->where('orcl_ord_id', $ord_id)
                ->select('adm_name', 'adm_phone')
                ->first();
            $dis_data->orcl_sales_adm_name = $orcl_sales_adm_data->adm_name;
            $dis_data->orcl_sales_adm_phone = $orcl_sales_adm_data->adm_phone;
            $find_admin = DB::table('admin_shop_role')
                ->leftjoin('role', 'role_id', '=', 'rol_id')
                ->where('adm_id', $user_info->adm_id)
                ->where('shop_id', $user_info->adm_shop_id)
                ->select('rol_privilege_multiple')
                ->first();
            $order_pic = '';
            if (!empty($find_admin)) {
                $role_data = json_decode($find_admin->rol_privilege_multiple, true);
                $rol_privilege_multiple = explode(',',$role_data['applet']);
                if (in_array(27,$rol_privilege_multiple)) {
                    $getorderpic = WashOrderService::getorderpic($user_info, $ord_id);
                    if (!empty($getorderpic['data'])) {
                        $order_pic = $getorderpic['data'];
                    }
                }
            }
            $data['order_pic'] = $order_pic;
            $data['delivedry'] = DeliveryService::deliveryList($user_info,$request)['data'];//快递信息
            return ['code'=>200, 'msg'=>'success', 'data'=>$data];
        }

                // dego_order_type类型：1.订单发货 2.工单发货3售后单发货
        if ($dis_data->dego_order_type == 2) {
            // 查询当前工单技师的服务状态
            $wor_service_state = DB::table('work_order')
                ->where('wor_id', $dis_data->dego_wor_id)
                ->value('wor_service_state');
            // 如果技师尚未接单，不允许发货
            // 服务状态：1待接单2已接单3预约4出发5抵达6完成待审核7完成已驳回8完成通过9终止10锁定11速电撤销回收
            if ($wor_service_state < 2) {
                return ['code'=>500, 'msg'=>'当前技师尚未接单！', 'data'=>'当前技师尚未接单！'];
            }

            $find_order_data = DB::table('work_order as wor')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->where('wor_id', $dis_data->dego_wor_id)
                ->select('wor_type', 'wocl_client_id', 'wor_order_id', 'wor_order_number', 'wor_create_time')
                ->first();
            $find_ord_id = $find_order_data->wor_order_id; //订单id
            $find_order_number = $find_order_data->wor_order_number; //订单编号
        } elseif ($dis_data->dego_order_type == 1) {
            $find_ord_id = $dis_data->dego_wor_id; //订单id
            $find_order_number = $dis_data->dego_original_number; //订单编号
        }  elseif ($dis_data->dego_order_type == 3) {//售后单
            $find_ord_id = $dis_data->dego_wor_id; //订单id
            $find_order_number = $dis_data->dego_original_number; //订单编号
        } else {
            return ['code'=>500, 'msg'=>'发货失败！', 'data'=>''];
        }

        $request_goods_data = json_decode($request['goodsDataList'], true); //前端提交的出库商品数据
        if (empty($request_goods_data)) {
            return ['code'=>500, 'msg'=>'请选择出库商品', 'data'=>'请选择出库商品'];
        }

        // 判断出库仓库类型，pc端不能发移动仓库的商品，只能发固定仓的，有权限的商品
        // ware_type类型：1固定仓2技师库3移动仓
        $dego_out_ware_type = DB::table('warehouse')
            ->where('ware_id', $dis_data->dego_out_ware_id)
            ->value('ware_type');
        if ($dego_out_ware_type != 1) {
            return ['code'=>500, 'msg'=>'当前供货仓库不是固定仓库，没有发货权限！', 'data'=>'当前供货仓库不是固定仓库，没有发货权限！'];
        }

        // 查询当前账号所拥有的仓库权限
        $find_admin_set = DB::table('admin_set')
            ->where('adms_adm_id', $user_info->adm_id)
            ->where('adms_shop_id', $user_info->adm_shop_id)
            // ->value('adms_ware_id');
            ->value('adms_myware_id');
        $find_admin_set = explode(',', trim($find_admin_set, ','));
        if (!in_array($dis_data->dego_out_ware_id, $find_admin_set)) {
            return ['code'=>500, 'msg'=>'没有当前仓库的发货权限！', 'data'=>'没有当前仓库的发货权限！'];
        }
        // 修改发货单表的状态
        $update_data['dego_type'] = 2; //类型：1未出库2已出库
        $update_data['dego_pic'] = !empty($new_upload_data) ? $new_upload_data : ''; //发货图片
        $update_data['dego_remark'] = !empty($request['dego_remark']) ? $request['dego_remark'] : ''; //发货备注
        $update_data['dego_update_time'] = date('Y-m-d H:i:s'); //更新时间
        $dispatch_res = DB::table('dispatch_bill')
            ->where('dego_id', $request['dego_id'])
            ->update($update_data);

        // 更改仓库、仓位发货数量
        $shipments_retrun = Dispatch::shipments(
            $user_info, //用户信息
            $request, //用户信息
            $request_goods_data, //提交的商品数据
            $dis_data, //查询的发货单信息
            $dego_out_ware_type, //发货仓库类型
            $find_ord_id, //订单id
            $find_order_number, //订单单号
        );
        if ($shipments_retrun['code'] == 500) {
            return $shipments_retrun;
        }
        // 发货单商品添加物料图片
        if (!empty($request['imgs64'])) {
            $upload_file = json_decode(json_encode($request['imgs64']), true);
            foreach ($upload_file as $key => $value) {
                if (!empty($value)) {
                    // 判断是否有新图片上传
                    if (strpos($value, 'data:image') === 0) {
                        // 调用全局函数 上传图片
                        $image_path = uploadBase64ImgFolder($user_info->adm_shop_id, $value, 2);
                    } else {
                        $image_path = $value;
                    }
                }
                $new_data[] = $image_path;
                unset($image_path);
            }
            $new_upload_data = json_encode($new_data);
        } else {
            $new_upload_data = '';
        }
        
        DeliveryService::addDelivery($user_info,$request);//添加快递信息
        if ($dispatch_res) {
            return ['code'=>200, 'msg'=>'发货成功', 'data'=>'发货成功'];
        } else {
            return ['code'=>500, 'msg'=>'发货失败', 'data'=>'发货失败'];
        }
    }

    // 获取字段数据
    public static function getFieldsById($id, $fields = '*', $shopID = 0)
    {
        $entity = WashOrder::where('ord_id', $id)
            ->where('ord_shop_id', $shopID)
            ->select($fields)
            ->first();

        return $entity;
    }

    /**
     * 获取仓库
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-11-08
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public static function getWareHouses($user_info, $request)
    {
        $list_data = DB::table('warehouse_goods')
            ->leftjoin('warehouse', 'ware_id', '=', 'wago_ware_id')
            ->where('wago_goo_id', $request['goo_id'])
            ->where('ware_state', 1) //  状态1启用2停用3撤仓
            ->where('wago_stock_number', '>', 0) //库存
            ->where(function ($query) use ($request) { //类型：1未出库2已出库
                if (isset($request['ware_id']) && !empty($request['ware_id'])) {
                    $query->where('ware_id', '<>', $request['ware_id']);
                }
            })
            ->select('wago_id', 'wago_goo_id', 'ware_id', 'ware_name', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity')
            ->orderBy('wago_stock_number', 'desc')
            ->get()->toArray();
        return ['code'=>200, 'msg'=>'success', 'data'=>$list_data];
    }

    /**
     * 更换仓库
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-11-08
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public static function changeWare($user_info, $request)
    {
        $find_dis = DB::table('dispatch_bill')
            ->where('dego_id', $request['dego_id'])
            ->first();
        if ($find_dis->dego_type != 1) {
            return ['code'=>500, 'msg'=>'不是未发货状态', 'data'=>''];
        }
        $find_disgoods = DB::table('dispatch_goods')
            ->where('digo_dego_id', $request['dego_id'])
            ->count();
        if ($find_disgoods > 1) {
            return ['code'=>500, 'msg'=>'多商品暂不支持更换仓库！', 'data'=>''];
        }
        if ($find_dis->dego_order_type == 1) {
            $ord_id = $find_dis->dego_wor_id;
        } else {
            $ord_id = DB::table('work_order')
                ->where('wor_id', $find_dis->dego_wor_id)
                ->value('wor_order_id');
        }
        $update_data['ord_ware_id'] = $request['ware_id'];
        $update_data['ord_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('order')
            ->where('ord_id', $ord_id)
            ->update($update_data);
        $update_orgo['orgo_ware_id'] = $request['ware_id'];
        $update_orgo['orgo_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('order_goods')
            ->where('orgo_ord_id', $ord_id)
            ->where('orgo_goo_type', 1)
            ->update($update_orgo);
        $dis_data['dego_out_ware_id'] = $request['ware_id'];
        $dis_data['dego_update_time'] = date('Y-m-d H:i:s');
        $dis_res = DB::table('dispatch_bill')
            ->where('dego_id', $request['dego_id'])
            ->update($dis_data);
        $find_wago = DB::table('warehouse_goods')
            ->where('wago_ware_id', $request['ware_id'])
            ->where('wago_goo_id', $request['goo_id'])
            ->first();
        $dis_goods['digo_wago_id'] = $find_wago->wago_id;
        $digo_res = DB::table('dispatch_goods')
            ->where('digo_dego_id', $request['dego_id'])
            ->where('digo_goo_id', $request['goo_id'])
            ->update($dis_goods);
        return ['code'=>200, 'msg'=>'更换仓库成功', 'data'=>''];
    }
}
