<?php

namespace App\Services\Business;

use App\Models\Business\WashAfterSales;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\Business\WashAfterSalesValidator;
use BlueCity\Core\Inc\ErrorInc;
use App\Http\Models\Api\DispatchBill;
use App\Services\Business\WashOrderBasicService;
use App\Http\Controllers\Common\CommonController;

// 售后列表
class WashAfterSalesService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new WashAfterSales();
        $this->mainValidator = new WashAfterSalesValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param object $user_info 用户信息
     * @param array $search_data 内容
     * @param int $show_count 页容量
     * @return mixed
     */
    public function searchPage($user_info, $search_data, $show_count = 10)
    {
        if(isset($search_data['is_excel']) && $search_data['is_excel']==2){
            DB::connection()->enableQueryLog();#开启执行日志
        }
        $list_data = DB::table('wash_after_sale_list as a')
            ->leftJoin('wash_after_sale_client as b', 'a.afsl_id', '=', 'b.afsc_afsl_id')
            ->where('afsl_cid', $user_info->adm_cid)
            ->where('afsl_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($search_data) { //业务员搜索
                if (!empty($search_data['chun_adm_id'])) {
                    $query->where('chun_adm_id', $search_data['chun_adm_id'])
                        ->where('afsl_type', 2);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['afsl_after_number'])) {
                    $query->where('afsl_after_number', 'like', '%' . $search_data['afsl_after_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['afsl_order_number'])) {
                    $query->where('afsl_order_number', 'like', '%' . $search_data['afsl_order_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['afsc_name'])) {
                    $query->where('afsc_name', 'like', '%' . $search_data['afsc_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['afsc_phone'])) {
                    $query->where('afsc_phone', 'like', '%' . $search_data['afsc_phone'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['afsc_carowner_name'])) {
                    $query->where('afsc_carowner_name', 'like', '%' . $search_data['afsc_carowner_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['afsc_carowner_phone'])) {
                    $query->where('afsc_carowner_phone', 'like', '%' . $search_data['afsc_carowner_phone'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['afsc_car_num'])) {
                    $query->where('afsc_car_num', 'like', '%' . $search_data['afsc_car_num'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //车型
                if (!empty($search_data['afsc_car_vehicle_type'])) {
                    $query->where('afsc_car_vehicle_type', 'like', '%' . $search_data['afsc_car_vehicle_type'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //车型
                if (!empty($search_data['orcl_car_vin'])) {
                    $query->where('afsc_car_vin', 'like', '%' . $search_data['orcl_car_vin'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //买家类型：1会员零售2合作商
                if (!empty($search_data['afsl_client_type'])) {
                    $query->where('afsl_client_type', $search_data['afsl_client_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建人id
                if (!empty($search_data['afsl_create_id'])) {
                    $query->where('afsl_create_id', $search_data['afsl_create_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['afsl_state'])) {
                    $query->where('afsl_state', $search_data['afsl_state']);
                }
            })
            ->where(function ($query) use ($search_data) { //备注
                if (!empty($search_data['afsl_remark'])) {
                    $query->where('afsl_remark', 'like', '%' . $search_data['afsl_remark'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('afsl_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('afsl_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('afsl_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['afsl_client_id'])) {
                    $query->where('afsl_client_id', $search_data['afsl_client_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['afsl_address_type']) && !empty($search_data['afsl_address_id'])) {
                    $query->where('afsl_address_type', $search_data['afsl_address_type'])
                        ->where('afsl_address_id', $search_data['afsl_address_id']);
                }
            })
            ->select('afsl_id', 'afsl_after_number', 'afsl_create_id', 'afsl_order_number', 'afsl_actual_price', 'afsl_client_type', 'afsl_state', 'afsl_remark', 'afsl_order_price', 'afsl_client_id', 'afsl_reservation_time', 'afsl_create_time', 'afsc_channel_unit', 'afsc_name', 'afsc_phone', 'afsc_car_num', 'afsc_province', 'afsc_city', 'afsc_county', 'afsc_address', 'afsc_car_vehicle_type', 'afsc_car_vin', 'afsc_car_brand_series', 'afsc_carowner_name', 'afsc_carowner_phone', 'afsl_business_id', 'afsl_business_name', 'afsl_address_type', 'afsl_lab_name', 'afsl_lab_id', 'afsl_pic', 'afsl_parts')
            ->orderBy('afsl_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if(isset($search_data['is_excel']) && $search_data['is_excel']==2){
            if (!empty($list_items)) {
                $data['sqls'] = DB::getQueryLog()[1];
                $sqls = $data['sqls'];
                $excel = new CommonController();
                $amp_id = $search_data['amp_id']??0;
                return $excel->getExcelOut($amp_id,$user_info,$search_data['pri_id'], $sqls, $search_data['api_token'],200,'WashAfterSales','售后列表');
            } else {
                return response()->json(['code'=>500,'msg'=>'暂无数据']);
            }
        }

        if ($list_items) {
            $afsl_id = array_column($list_items, 'afsl_id'); //id

            // 查询商品、项目信息
            $order_goods = DB::table('wash_after_sale_items as w')
                ->leftJoin('goods as g', 'g.goo_id', '=', 'w.afsi_goo_id')
                ->whereIn('afsi_afsl_id', $afsl_id)
                ->select('afsi_id', 'afsi_afsl_id', 'afsi_sepr_id', 'afsi_goo_name', 'afsi_goo_goods_encode', 'afsi_sepr_id', 'afsi_sepr_name', 'afsi_goo_warranty_time', 'afsi_part_state', 'afsi_goo_quantity', 'afsi_goo_price', 'afsi_service_price', 'afsi_goo_unit', 'afsi_goo_unta_id', 'goo_unit_conversion')
                ->get()->toArray();

            // 账号id
            $adm_id = array_column($list_items, 'afsl_create_id'); //id
            $adm_id = array_filter(array_unique($adm_id));
            // 查询账号id对应姓名
            $adm_name = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->pluck('adm_name', 'adm_id')
                ->toArray();
            foreach ($list_items as $key => $value) {
                // 创建人
                if ($value->afsl_create_id) {
                    $list_items[$key]->create_name = isset($adm_name[$value->afsl_create_id]) ? $adm_name[$value->afsl_create_id] : '';
                } else {
                    $list_items[$key]->create_name = '';
                }
                $order_goods = DB::table('wash_after_sale_items as w')
                    ->leftJoin('goods as g', 'g.goo_id', '=', 'w.afsi_goo_id')
                    ->where('afsi_afsl_id', $value->afsl_id)
                    ->where('afsi_type', 1)
                    ->select('afsi_id', 'afsi_afsl_id', 'afsi_sepr_id', 'afsi_goo_name', 'afsi_goo_goods_encode', 'afsi_sepr_id', 'afsi_sepr_name', 'afsi_goo_warranty_time', 'afsi_part_state', 'afsi_goo_quantity', 'afsi_goo_price', 'afsi_service_price', 'afsi_goo_unit', 'afsi_goo_unta_id', 'goo_unit_conversion')
                    ->get()->toArray();
                $afsl_goods = DB::table('wash_after_sale_items as w')
                    ->leftJoin('goods as g', 'g.goo_id', '=', 'w.afsi_goo_id')
                    ->where('afsi_afsl_id', $value->afsl_id)
                    ->where('afsi_type', 2)
                    ->select('afsi_id', 'afsi_afsl_id', 'afsi_sepr_id', 'afsi_goo_name', 'afsi_goo_goods_encode', 'afsi_sepr_id', 'afsi_sepr_name', 'afsi_goo_warranty_time', 'afsi_part_state', 'afsi_goo_quantity', 'afsi_goo_price', 'afsi_service_price', 'afsi_goo_unit', 'afsi_goo_unta_id', 'goo_unit_conversion')
                    ->get()->toArray();
                $list_items[$key]->order_goods = $order_goods;
                $list_items[$key]->afsl_goods = $afsl_goods;
            }
            foreach ($order_goods as $key_goo => $value_goo) {
                $order_goods[$key_goo]->afsi_goo_quantity = $value_goo->afsi_goo_quantity.$value_goo->afsi_goo_unit;
            }

            // 查询备注信息
            $order_reamrks = DB::table('order_remarks')
                ->whereIn('orre_primary_id', $afsl_id)
                ->where('orre_primary_type', 2)
                ->select('orre_create_adm_name', 'orre_content', 'orre_time', 'orre_primary_id', 'orre_module')
                ->orderby('orre_id', 'desc')
                ->get();

            // 查找操作记录
            $order_log = DB::table('order_log')
                ->whereIn('orlo_primary_id', $afsl_id)
                ->where('orlo_primary_type', 2)
                ->orderBy('orlo_id', 'desc')
                ->select('orlo_primary_id', 'orlo_time', 'orlo_create_adm_name', 'orlo_content')
                ->get();
        } else {
            $order_goods = [];
            $order_log = [];
            $order_reamrks = [];
        }
        // 查询预约单状态对应的预约单数量
        $state_count = DB::table('wash_after_sale_list')
            ->where('afsl_cid', $user_info->adm_cid)
            ->where('afsl_shop_id', $user_info->adm_shop_id)
            ->select(DB::raw('count(*) as count, afsl_state'))
            ->groupBy('afsl_state')
            ->get();
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['order_goods'] = $order_goods;                //预约单商品数据
        $data['state_count'] = $state_count;
        $data['order_log'] = $order_log;                    //操作记录
        $data['order_reamrks'] = $order_reamrks;           //预约单备注
        $data['now_time'] = date('Y-m-d H:i:s');           //当前时间
        return $data;
    }

    // 详情
    public static function info($user_info, $request)
    {
        $info = DB::table('wash_after_sale_list as a')
            ->leftJoin('wash_after_sale_client as b', 'a.afsl_id', '=', 'b.afsc_afsl_id')
            ->where('afsl_id', $request['afsl_id'])
            ->where('afsl_shop_id', $user_info->adm_shop_id)
            ->select('afsl_id', 'afsl_after_number', 'afsl_create_id', 'afsl_order_number', 'afsl_actual_price', 'afsl_client_type', 'afsl_state', 'afsl_remark', 'afsl_order_price', 'afsl_client_id', 'afsl_reservation_time', 'afsl_create_time', 'afsc_channel_unit', 'afsc_name', 'afsc_phone', 'afsc_car_num', 'afsc_province', 'afsc_city', 'afsc_county', 'afsc_address', 'afsc_car_vehicle_type', 'afsc_car_vin', 'afsc_car_brand_series', 'afsc_carowner_name', 'afsc_carowner_phone','afsl_lab_id', 'afsl_lab_name', 'afsl_pic', 'afsl_parts', 'afsl_ware_id')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前售后单不存在', 'data'=>''];
        }

        // 查询商品、项目信息
        $goods_data = DB::table('wash_after_sale_items')
            ->where('afsi_afsl_id', $request['afsl_id'])
            ->where('afsi_type',2)
            ->select('afsi_id', 'afsi_afsl_id', 'afsi_sepr_id', 'afsi_goo_name', 'afsi_goo_goods_encode', 'afsi_sepr_id', 'afsi_sepr_name', 'afsi_goo_warranty_time', 'afsi_part_state', 'afsi_goo_unit', 'afsi_goo_unta_id','afsi_goo_id', 'afsi_goo_type', 'afsi_goo_quantity')
            ->get()->toArray();
        // 账号id
        $adm_id[] = $info->afsl_create_id;
        $adm_id = array_filter(array_unique($adm_id));
        // 查询账号id对应姓名
        $adm_name = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->pluck('adm_name', 'adm_id')
            ->toArray();
        $info->create_name = '';
        if ($info->afsl_create_id != '0') {
            $info->create_name = $adm_name[$info->afsl_create_id]; //创建人
        }
        if (!empty($info->afsl_ware_id)) {
            $info->afsl_ware_name = DB::table('warehouse')
                ->where('ware_id', $info->afsl_ware_id)
                ->value('ware_name');
        } else {
            $info->afsl_ware_name = '';
        }

        $data['work_data'] = $info;
        $data['goods_data'] = $goods_data;
        $adm_data = DB::table('wash_work_technician_part')
            ->leftJoin('work_order', 'wor_id', '=', 'wotp_wor_id')
            ->leftJoin('order', 'ord_id', '=', 'wor_order_id')
            ->where('ord_order_number', $info->afsl_order_number)
            ->select('wotp_service_adm_name', 'wotp_service_adm_phone', 'wotp_service_adm_id')
            ->get()->toArray();
        $data['adm_data'] = $adm_data;
        $after_work_log = DB::table('after_work_log')
            ->leftJoin('admin', 'adm_id', '=', 'awlo_adm_id')
            ->where('awlo_afsl_id', $request['afsl_id'])
            ->where('awlo_adm_del', 2)
            ->orderBy('awlo_create_time', 'desc')
            // ->where('awlo_state', '!=', 1)
            ->get()->toArray();
        $typeName = self::getStateName(true);//获取支付方式名称
        $i = 0;
        $work_adm_data = [];
        $return_adm_data = [];
        $return_work_log = [];
        foreach ($after_work_log as $key => $value) {
            if (!in_array($value->awlo_adm_id, $work_adm_data) && $value->awlo_adm_type == 2 && $value->awlo_adm_del == 2) {//awlo_adm_type:1后台人员2指派技师
                $work_adm_data[] = $value->awlo_adm_id;
                $return_adm_data[$i]['adm_id'] = $value->awlo_adm_id;
                $return_adm_data[$i]['adm_name'] = $value->adm_name;
                if ($value->awlo_state == 4) {
                    $return_adm_data[$i]['can_del'] = 1;
                } else {
                    $return_adm_data[$i]['can_del'] = 2;
                }
                $i++;
            }
            if (!empty($value->awlo_state)) {
                $value->awlo_state_name = self::getTypeData($value->awlo_state, $typeName);
            } else {
                $value->awlo_state_name = '';
            }
            $return_work_log[] = $value;
        }
        $data['after_work_log'] = $return_work_log;
        $data['return_adm_data'] = $return_adm_data;

        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 确认处理
    public static function dealWith($user_info, $request)
    {
        // 查询信息
        $find_data = DB::table('wash_after_sale_list')
            ->where('afsl_id', $request['afsl_id'])
            ->where('afsl_shop_id', $user_info->adm_shop_id)
            ->first();

        if (empty($find_data)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前售后单不存在！', 'data'=>''];
        }
        if (!in_array($find_data->afsl_state, [1,2])) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前售后单不是未处理状态！', 'data'=>''];
        }
        $find_goods_data = DB::table('wash_after_sale_items')
            ->where('afsi_afsl_id', $request['afsl_id'])
            ->where('afsi_type', 2)
            ->exists();
        if (empty($find_goods_data)) {
            // 处理售后 添加售后商品 及服务 只有商品就生成发货单 有服务的需要派技师
            $goods_data = $request['goods_data'];
            $is_goods = false;//是否有产品
            $only_goods = false;//是否只有产品
            $have_ser = false;//是否包含服务
            if (!empty($goods_data)) {
                $goo_type = array_column($goods_data, 'goo_type');
                if (in_array(1, $goo_type)) {
                    $is_goods = true;
                }
                if (!in_array(2, $goo_type)) {
                    $only_goods = true;
                }
                if (in_array(2, $goo_type)) {
                    $have_ser = true;
                }
                foreach ($goods_data as $key => $value) {
                    $goods_data[$key]['goo_state'] = 1;
                    if ($value['goo_type'] == 1 && $request['ware_id']) {
                        $goods_data[$key]['goo_goods_encode'] = DB::table('goods')
                            ->where('goo_id', $value['goo_id'])
                            ->value('goo_goods_encode');
                        $goods_data[$key]['wago_id'] = DB::table('warehouse_goods')
                            ->where('wago_ware_id', $request['ware_id'])
                            ->where('wago_goo_id', $value['goo_id'])
                            ->value('wago_id');
                    }
                }
                $new_goo_all_quantity = 0;
                foreach ($goods_data as $key => $value) {
                    $add_data[$key]['afsi_shop_id'] = $user_info->adm_shop_id;
                    $add_data[$key]['afsi_afsl_id'] = $request['afsl_id'];
                    $add_data[$key]['afsi_goo_id'] = $value['goo_id'];
                    $add_data[$key]['afsi_goo_name'] = $value['goo_name'];
                    $add_data[$key]['afsi_goo_quantity'] = $value['goo_quantity'];
                    $add_data[$key]['afsi_goo_goods_encode'] = isset($value['goo_goods_encode']) ? $value['goo_goods_encode'] :'';
                    $add_data[$key]['afsi_goo_type'] = $value['goo_type'];
                    $add_data[$key]['afsi_goo_unit'] = $value['goo_unit'];
                    $add_data[$key]['afsi_goo_unta_id'] = $value['goo_unta_id'];
                    $add_data[$key]['afsi_type'] = 2;
                    if ($value['goo_type'] == 1) {//实物类
                        $value['orgo_id'] = 0;
                        $new_goods_data[] = $value;
                        $new_goo_all_quantity += $value['goo_quantity'];
                    }
                }
                $add_data_res = DB::table('wash_after_sale_items')->insert($add_data);
                if ($is_goods) {
                    if ($request['ware_id']) {
                        $request['service_shop_id'] = $user_info->adm_shop_id;
                        $dibi_data = DispatchBill::create(
                            $user_info,   //用户信息
                            $request,  //订单提交数据
                            $new_goods_data,  //提交的商品数据
                            3,  //类型：1.订单发货 2.工单发货 3.售后单发货
                            $request['ware_id'],  //出库仓库id
                            $find_data->afsl_after_number,  //原始单号，订单号/工单号
                            $find_data->afsl_id,  //发货单关联的工单/订单id
                            $find_data->afsl_shop_id,  //所属总店id
                            $find_data->afsl_client_type,  //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                            $find_data->afsl_client_id,  //选择的客户id,会员id/单位id
                            $new_goo_all_quantity  //发货总数量
                        );
                        if ($dibi_data['code'] == 500) {
                            return $dibi_data;
                        }
                    }
                }
            }
            
            $afsl_data['afsl_ware_id'] = $request['ware_id']; //仓库id
        }
        $afsl_data['afsl_state'] = 2; //状态：1未处理2处理中3审核中4已完成5已撤销
        if ($request['awlo_finished'] == 1) {
            $afsl_data['afsl_state'] = 3;
        }
        if (!empty($request['remark'])) {
            $afsl_data['afsl_remark'] = $request['remark'];
        }
        $afsl_data['afsl_lab_id'] = $request['afsl_lab_id'];
        $afsl_data['afsl_lab_name'] = $request['afsl_lab_name'];
        $afsl_data['afsl_parts'] = json_encode($request['afsl_parts'],true);
        $afsl_data['afsl_update_time'] = date('Y-m-d H:i:s');
        $afsl_res = DB::table('wash_after_sale_list')
            ->where('afsl_id', $request['afsl_id'])
            ->update($afsl_data);
        // 提交处理记录
        $new_work_data['awlo_shop_id'] = $user_info->adm_shop_id;
        $new_work_data['awlo_afsl_id'] = $request['afsl_id'];
        $new_work_data['awlo_text'] = $request['awlo_text'];
        $new_work_data['awlo_pic_data'] = json_encode($request['awlo_pic_data'], true);
        $new_work_data['awlo_adm_id'] = $user_info->adm_id;
        $new_work_data['awlo_state'] = 0;//1未处理2处理中3审核中4已完成
        $new_work_data['awlo_adm_type'] = 1;//1后台人员2指派技师
        $new_work_data['awlo_type'] = 1;//1日常反馈2提交
        $new_work_data['awlo_create_id'] = $user_info->adm_id;
        $new_work_data['awlo_create_name'] = $user_info->adm_name;
        $new_work_data['awlo_create_time'] = date('Y-m-d H:i:s');
        $add_work_data_res = DB::table('after_work_log')->insert($new_work_data);
        if ($request['ware_id'] && $is_goods) {
            $post_data['ware_id'] = $request['ware_id'];
            $post_data['new_goods_data'] = $new_goods_data;
            $res = WashOrderBasicService::addGoodPlan($user_info, $post_data);
        }
        if ($afsl_res) {
            $data['afsl_after_number'] = $find_data->afsl_after_number;
            $data['afsl_order_number'] = $find_data->afsl_order_number;
            return ['code'=>200, 'msg'=>'处理成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'处理失败', 'data'=>''];
        }
    }

    // 撤销售后
    public static function cancel($user_info, $request)
    {
        // 查询信息
        $find_data = DB::table('wash_after_sale_list')
            ->where('afsl_id', $request['afsl_id'])
            ->where('afsl_shop_id', $user_info->adm_shop_id)
            ->select('afsl_after_number', 'afsl_order_number', 'afsl_state')
            ->first();

        if (empty($find_data)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前售后单不存在！', 'data'=>''];
        }
        if ($find_data->afsl_state == 3) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前售后单状态为审核中，无法撤销！', 'data'=>''];
        }
        if ($find_data->afsl_state == 4) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前售后单状态为已完成，无法撤销！', 'data'=>''];
        }
        if ($find_data->afsl_state == 5) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前售后单状态为已撤销，无法撤销！', 'data'=>''];
        }
        $dego_type = DB::table('dispatch_bill')
            ->where('dego_wor_id', $request['afsl_id'])
            ->where('dego_order_type', 3)
            ->value('dego_type');
        if ($dego_type == 2) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前售后单已发货，无法撤销！', 'data'=>''];
        }
        $afsl_data['afsl_state'] = 5; //状态：1未处理2处理中3审核中4已完成5已撤销
        if (!empty($request['remark'])) {
            $afsl_data['afsl_remark'] = $request['remark'];
        }
        $afsl_data['afsl_update_time'] = date('Y-m-d H:i:s');
        $afsl_res = DB::table('wash_after_sale_list')
            ->where('afsl_id', $request['afsl_id'])
            ->update($afsl_data);
        $update_awlo_res = DB::table('after_work_log')
            ->where('awlo_afsl_id', $request['afsl_id'])
            ->update(['awlo_state'=>5]);
        if ($afsl_res) {
            $data['afsl_after_number'] = $find_data->afsl_after_number;
            $data['afsl_order_number'] = $find_data->afsl_order_number;
            return ['code'=>200, 'msg'=>'撤销售后成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'撤销售后失败', 'data'=>''];
        }
    }

    // 申请完成
    public static function applyComplete($user_info, $request)
    {
        // 查询信息
        $find_data = DB::table('wash_after_sale_list')
            ->where('afsl_id', $request['afsl_id'])
            ->where('afsl_shop_id', $user_info->adm_shop_id)
            ->select('afsl_after_number', 'afsl_order_number', 'afsl_state')
            ->first();

        if (empty($find_data)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前售后单不存在！', 'data'=>''];
        }
        if ($find_data->afsl_state != 2) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前售后单状态不是处理中，无法申请完成！', 'data'=>''];
        }

        $afsl_data['afsl_state'] = 3; //状态：1未处理2处理中3审核中4已完成5已撤销
        if (!empty($request['remark'])) {
            $afsl_data['afsl_remark'] = $request['remark'];
        }
        $afsl_data['afsl_update_time'] = date('Y-m-d H:i:s');
        $afsl_res = DB::table('wash_after_sale_list')
            ->where('afsl_id', $request['afsl_id'])
            ->update($afsl_data);

        if ($afsl_res) {
            $data['afsl_after_number'] = $find_data->afsl_after_number;
            $data['afsl_order_number'] = $find_data->afsl_order_number;
            return ['code'=>200, 'msg'=>'申请完成成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'申请完成失败', 'data'=>''];
        }
    }

    /**
     * 驳回技师售后
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-11
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function auditReject($user_info, $request){
        $find_data = DB::table('after_work_log')
            ->where('awlo_id', $request['awlo_id'])
            ->first();
        if ($find_data->awlo_state != 2) {
            return ['code'=>500, 'msg'=>'当前状态不是审核中，无法审核！', 'data'=>''];
        }
        $update_data['awlo_state'] = 3;//3驳回
        $update_data['awlo_reject_reason'] = $request['remark'];
        $update_data['awlo_update_id'] = $user_info->adm_id;
        $update_data['awlo_update_name'] = $user_info->adm_name;
        $update_data['awlo_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('after_work_log')
            ->where('awlo_id', $request['awlo_id'])
            ->update($update_data);
        //驳回后新增一条记录 技师处理
        $add_data['awlo_shop_id'] = $find_data->awlo_shop_id;
        $add_data['awlo_afsl_id'] = $find_data->awlo_afsl_id;
        $add_data['awlo_adm_id'] = $find_data->awlo_adm_id;
        $add_data['awlo_adm_name'] = $find_data->awlo_adm_name;
        $add_data['awlo_state'] = 1;
        $add_data['awlo_adm_type'] = 2;
        $add_data['awlo_adm_del'] = 2;
        $add_data['awlo_type'] = 2;
        $add_data['awlo_create_id'] = $user_info->adm_id;
        $add_data['awlo_create_name'] = $user_info->adm_name;
        $add_data['awlo_create_time'] = date('Y-m-d H:i:s');
        $add_res = DB::table('after_work_log')->insertGetId($add_data);
        if ($update_res && $add_res) {
            return ['code'=>200, 'msg'=>'驳回成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'驳回失败', 'data'=>''];
        }
    }

    // 审核通过
    public static function auditPass($user_info, $request)
    {
        // 查询信息
        $find_data = DB::table('wash_after_sale_list')
            ->where('afsl_id', $request['afsl_id'])
            ->where('afsl_shop_id', $user_info->adm_shop_id)
            ->select('afsl_after_number', 'afsl_order_number', 'afsl_state', 'afsl_id', 'afsl_shop_id')
            ->first();

        if (empty($find_data)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前售后单不存在！', 'data'=>''];
        }
        if ($find_data->afsl_state != 3) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前售后单状态不是审核中，无法审核通过！', 'data'=>''];
        }

        $afsl_data['afsl_state'] = 4; //状态：1未处理2处理中3审核中4已完成5已撤销
        // if (!empty($request['remark'])) {
        //     $afsl_data['afsl_remark'] = $request['remark'];
        // }
        $afsl_data['afsl_update_time'] = date('Y-m-d H:i:s');
        $afsl_res = DB::table('wash_after_sale_list')
            ->where('afsl_id', $request['afsl_id'])
            ->update($afsl_data);
        $punish_remark = '';
        if (!empty($request['adm_data'])) {
            $data['viti_cid'] = $user_info->adm_cid;
            $data['viti_shop_id'] = $user_info->adm_shop_id;
            $data['viti_order_number'] = $find_data->afsl_order_number; //订单号
            $data['viti_reason'] = $request['remark']; //处罚原因
            $data['viti_create_id'] = $user_info->adm_id; //创建人
            $data['viti_create_name'] = $user_info->adm_name; //创建人
            $data['viti_create_time'] = date('Y-m-d H:i:s');
            $data['viti_state'] = 1;
            $data['viti_after_number'] = $find_data->afsl_after_number;
            $viti_id = DB::table('violation_ticket')->insertGetId($data);
            $adm_data = $request['adm_data'];
            foreach ($adm_data as $key => $value) {
                $add_adm_data['vtde_shop_id'] = $user_info->adm_shop_id;
                $add_adm_data['vtde_viti_id'] = $viti_id;
                $add_adm_data['vtde_adm_id'] = $value['wotp_service_adm_id'];
                $add_adm_data['vtde_adm_name'] = $value['wotp_service_adm_name'];
                $add_adm_data['vtde_punish_money'] = $value['wotp_punish']*100;
                if ($value['wotp_punish'] > 0) {
                    $add_adm_res = DB::table('violation_ticket_detail')->insert($add_adm_data);
                    $punish_remark = $punish_remark.'处罚'.$value['wotp_service_adm_name'].$value['wotp_punish'].'元 ';
                }
            }
            // foreach ($adm_data as $key => $value) {
            //     $wotp_punish = $value['wotp_punish']*100;
            //     if ($wotp_punish > 0) {
            //         $punish_remark = $punish_remark.'处罚'.$value['wotp_service_adm_name'].$value['wotp_punish'].'元 ';
            //         // $adm_data = DB::table('wash_work_technician_part')
            //         //     ->leftJoin('work_order', 'wor_id', '=', 'wotp_wor_id')
            //         //     ->leftJoin('order', 'ord_id', '=', 'wor_order_id')
            //         //     ->where('ord_order_number', $find_data->afsl_order_number)
            //         //     ->where('wotp_service_adm_id', $value['wotp_service_adm_id'])
            //         //     ->update(['wotp_punish'=>$wotp_punish]);
            //         $add_punish['viti_cid'] = $user_info->adm_cid;
            //         $add_punish['viti_shop_id'] = $user_info->adm_shop_id;
            //         $add_punish['viti_order_number'] = $find_data->afsl_order_number;
            //         $add_punish['viti_reason'] = $request['remark'];
            //         $add_punish['viti_money'] = $wotp_punish;
            //         $add_punish['viti_punish_adm_id'] = $value['wotp_service_adm_id'];
            //         $add_punish['viti_punish_adm_name'] = $value['wotp_service_adm_name'];
            //         $add_punish['viti_create_id'] = $user_info->adm_id;
            //         $add_punish['viti_create_name'] = $user_info->adm_name;
            //         $add_punish['viti_create_time'] = date('Y-m-d H:i:s');
            //         $add_punish['viti_wor_number'] = date('Y-m-d H:i:s');
            //         $add_punish['viti_after_number'] = $find_data->afsl_after_number;
            //         $add_punish_res = DB::table('violation_ticket')->insertGetid($add_punish);
            //     }
            // }
        }
        $add_data['awlo_shop_id'] = $find_data->afsl_shop_id;
        $add_data['awlo_afsl_id'] = $find_data->afsl_id;
        $add_data['awlo_adm_id'] = $user_info->adm_id;
        $add_data['awlo_adm_name'] = $user_info->adm_name;
        $add_data['awlo_text'] = $request['remark'].$punish_remark;
        $add_data['awlo_state'] = 4;
        $add_data['awlo_adm_type'] = 1;
        $add_data['awlo_adm_del'] = 2;
        $add_data['awlo_create_id'] = $user_info->adm_id;
        $add_data['awlo_create_name'] = $user_info->adm_name;
        $add_data['awlo_create_time'] = date('Y-m-d H:i:s');
        $add_res = DB::table('after_work_log')->insertGetId($add_data);
        $update_awlo_res = DB::table('after_work_log')
            ->where('awlo_afsl_id', $find_data->afsl_id)
            ->whereIn('awlo_state', [1,2])
            ->update(['awlo_state'=>4]);
        if ($afsl_res) {
            $data['afsl_after_number'] = $find_data->afsl_after_number;
            $data['afsl_order_number'] = $find_data->afsl_order_number;
            return ['code'=>200, 'msg'=>'审核成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'审核失败', 'data'=>''];
        }
    }

    // 审核驳回
    // public static function auditReject($user_info, $request)
    // {
    //     // 查询信息
    //     $find_data = DB::table('wash_after_sale_list')
    //         ->where('afsl_id', $request['afsl_id'])
    //         ->where('afsl_shop_id', $user_info->adm_shop_id)
    //         ->select('afsl_after_number', 'afsl_order_number', 'afsl_state')
    //         ->first();

    //     if (empty($find_data)) {
    //         return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前售后单不存在！', 'data'=>''];
    //     }
    //     if ($find_data->afsl_state != 3) {
    //         return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前售后单状态不是审核中，无法驳回！', 'data'=>''];
    //     }

    //     $afsl_data['afsl_state'] = 2; //状态：1未处理2处理中3审核中4已完成5已撤销
    //     if (!empty($request['remark'])) {
    //         $afsl_data['afsl_remark'] = $request['remark'];
    //     }
    //     $afsl_data['afsl_update_time'] = date('Y-m-d H:i:s');
    //     $afsl_res = DB::table('wash_after_sale_list')
    //         ->where('afsl_id', $request['afsl_id'])
    //         ->update($afsl_data);

    //     if ($afsl_res) {
    //         $data['afsl_after_number'] = $find_data->afsl_after_number;
    //         $data['afsl_order_number'] = $find_data->afsl_order_number;
    //         return ['code'=>200, 'msg'=>'驳回成功', 'data'=>$data];
    //     } else {
    //         return ['code'=>500, 'msg'=>'驳回失败', 'data'=>''];
    //     }
    // }

    // 备注查询数据
    public static function remarkSearch($user_info, $request)
    {
        $find_data = DB::table('wash_after_sale_list')
            ->where('afsl_id', $request['afsl_id'])
            ->first(['afsl_after_number', 'afsl_order_number']);
        $data['afsl_after_number'] = $find_data->afsl_after_number;
        $data['afsl_order_number'] = $find_data->afsl_order_number;
        return $data;
    }

    // 获取字段数据
    public static function getFieldsById($id, $fields = '*', $shopID = 0)
    {
        $entity = WashAfterSales::where('afsl_id', $id)
            ->where('afsl_shop_id', $shopID)
            ->select($fields)
            ->first();

        return $entity;
    }

    /**
     * 指派技师
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-10
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function assignTechnician($user_info, $request) {
        $find_data = DB::table('after_work_log')
            ->where('awlo_afsl_id', $request['afsl_id'])
            ->where('awlo_adm_type', 2)
            ->where('awlo_adm_del', 2)
            ->get()->toArray();
        if ($request['adm_data']) {
            $adm_data = $request['adm_data'];
        } else {
            return ['code'=>500,'msg'=>'请选择技师','data'=>''];
        }
        $old_adm_id = array_column($find_data,'awlo_adm_id');
        $new_adm_id = array_column($adm_data, 'adm_id');
        $i = 0;
        $add_work_data = [];
        foreach ($adm_data as $key => $value) {
            if (!in_array($value['adm_id'],$old_adm_id)) {
                $add_work_data[$i]['awlo_shop_id'] = $user_info->adm_shop_id;
                $add_work_data[$i]['awlo_afsl_id'] = $request['afsl_id'];
                $add_work_data[$i]['awlo_adm_id'] = $value['adm_id'];
                $add_work_data[$i]['awlo_adm_name'] = $value['adm_name'];
                $add_work_data[$i]['awlo_state'] = 1;
                $add_work_data[$i]['awlo_adm_type'] = 2;
                $add_work_data[$i]['awlo_type'] = 2;
                $add_work_data[$i]['awlo_create_id'] = $user_info->adm_id;
                $add_work_data[$i]['awlo_create_name'] = $user_info->adm_name;
                $add_work_data[$i]['awlo_create_time'] = date('Y-m-d H:i:s');
                $i++;
            }
        }
        if (!empty($add_work_data)) {
            $add_work_data_res = DB::table('after_work_log')->insert($add_work_data);
        } else {
            $add_work_data_res = true;
        }
        foreach ($find_data as $key => $value) {
            if (!in_array($value->awlo_adm_id,$new_adm_id)) {
                $update['awlo_adm_del'] = 1;
                $update['awlo_update_id'] = $user_info->adm_id;
                $update['awlo_update_name'] = $user_info->adm_name;
                $update['awlo_update_time'] = date('Y-m-d H:i:s');
                $update_res = DB::table('after_work_log')
                    ->where('awlo_id', $value->awlo_id)
                    ->update($update);
            }
        }
        if ($add_work_data_res) {
            return ['code'=>200,'msg'=>'指派技师成功','data'=>''];
        } else {
            return ['code'=>500,'msg'=>'指派技师失败','data'=>''];
        }
    }
    /**
     * 获取售后进度状态
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-10
     * @param  boolean          $type [description]
     * @return [type]                 [description]
     */
    public static function getStateName($type=false){
        $data = [['type'=>0,'name'=>'日常反馈'],['type'=>1,'name'=>'处理中'],['type'=>2,'name'=>'待审核'],['type'=>3,'name'=>'已驳回'],['type'=>4,'name'=>'已完成'],['type'=>5,'name'=>'已撤销']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }

    /**|---------------------------------------------------------------------------------
     * @name 列表页
     * @param string $type 服务类型数据
     * @param string $typeName 服务类型数据
     * @retrun /multitype:array
     * @author dou 2023-05-31 031 上午 11:47:59
     * |---------------------------------------------------------------------------------
     */
    public static function getTypeData ( $type , $typeName ){
        $typeData = trim($type);
        $typeData = explode(',', $typeData);
        $return = [];

        foreach($typeData as $k => $v){
            $return[] = $typeName[$v]??'未定义';
        }
        $return = implode(',', $return);
        return $return;
    }
}
