<?php

namespace App\Services\Business;

use App\Models\Business\Reservation;
use BlueCity\Core\Service\Service;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\Business\ReservationValidator;
use BlueCity\Core\Inc\ErrorInc;

// 预约单
class ReservationService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new Reservation();
        $this->mainValidator = new ReservationValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function searchPage($user_info, $search_data, $show_count = 10)
    {
        $list_data = DB::table('wash_reservation_list as a')
            ->leftJoin('wash_reservation_client as b', 'a.reli_id', '=', 'b.recl_reli_id')
            ->leftJoin('shop as s', 's.shop_id', '=', 'a.reli_shop_id')
            ->where('reli_cid', $user_info->adm_cid)
            ->where('reli_shop_id', $user_info->adm_shop_id)
            // ->where('reli_state', '<>', 2) //预约单状态：1待结单2已接单3取消订单4已撤回
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['reli_number'])) {
                    $query->where('reli_number', 'like', '%' . $search_data['reli_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['recl_name'])) {
                    $query->where('recl_name', 'like', '%' . $search_data['recl_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['recl_phone'])) {
                    $query->where('recl_phone', 'like', '%' . $search_data['recl_phone'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['recl_ower_name'])) {
                    $query->where('recl_ower_name', 'like', '%' . $search_data['recl_ower_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['recl_ower_phone'])) {
                    $query->where('recl_ower_phone', 'like', '%' . $search_data['recl_ower_phone'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['recl_car_num'])) {
                    $query->where('recl_car_num', 'like', '%' . $search_data['recl_car_num'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //车型
                if (!empty($search_data['recl_car_vehicle_type'])) {
                    $query->where('recl_car_vehicle_type', 'like', '%' . $search_data['recl_car_vehicle_type'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {//买家类型：1会员零售2客户单位3速电派单4第三方派单5运营中心给门店派单
                if (!empty($search_data['reli_type'])) {
                    $query->where('reli_type', $search_data['reli_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['reli_service_type'])) {
                    $query->where('reli_service_type', $search_data['reli_service_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['reli_create_id'])) {
                    $query->where('reli_create_id', $search_data['reli_create_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['reli_state'])) {
                    $query->where('reli_state', $search_data['reli_state']);
                }
            })
            ->where(function ($query) use ($search_data) { //备注
                if (!empty($search_data['reli_remark'])) {
                    $query->where('reli_remark', 'like', '%' . $search_data['reli_remark'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('reli_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('reli_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('reli_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['reli_client_id'])) {
                    $query->where('reli_client_id', $search_data['reli_client_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['reli_client_type'])) {
                    $query->where('reli_client_type', $search_data['reli_client_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['reli_address_type']) && !empty($search_data['reli_address_id'])) {
                    $query->where('reli_address_type', $search_data['reli_address_type'])
                        ->where('reli_address_id', $search_data['reli_address_id']);
                }
            })
            ->select('reli_id', 'reli_create_id', 'reli_order_number', 'reli_number', 'reli_client_type', 'reli_state', 'reli_appoint_time', 'reli_appoint_time_slot', 'reli_appoint_remark', 'reli_remark', 'reli_client_id','recl_channel_unit', 'recl_name', 'recl_phone', 'recl_car_num', 'recl_province', 'recl_city', 'recl_county', 'recl_address', 'recl_car_vehicle_type', 'recl_car_vin', 'recl_car_brand_series', 'reli_shop_id', 'shop_store_name', 'reli_create_time', 'recl_ower_name', 'recl_ower_phone', 'reli_bus_name', 'reli_explain', 'reli_address', 'reli_address_id', 'reli_address_type')
            ->orderBy('reli_id', 'asc')
            ->paginate($show_count);
        $list_items = $list_data->items();

        if ($list_items) {
            $reli_id = array_column($list_items, 'reli_id'); //预约单id

            // 查询商品、项目信息
            $reit_items = DB::table('wash_reservation_items as reit')
                ->leftJoin('service_project as sepr', 'sepr.sepr_id', '=', 'reit.reit_sepr_id')
                ->whereIn('reit_reli_id', $reli_id)
                ->select('reit_id', 'reit_reli_id', 'reit_sepr_id', 'reit_goo_name', 'reit_goo_goods_encode', 'reit_sepr_name', 'reit_part_state', 'sepr_work_type')
                ->get()->toArray();

            // 账号id
            $adm_id = array_column($list_items, 'reli_create_id'); //id
            $adm_id = array_filter(array_unique($adm_id));
            // 查询账号id对应姓名
            
            // $adm_name = DB::table('admin')
            //     ->whereIn('adm_id', $adm_id)
            //     ->pluck('adm_name', 'adm_id')
            //     ->toArray();
            $adm_name = DB::table('weixin_user')
                ->whereIn('weus_id', $adm_id)
                ->pluck('weus_nickmame', 'weus_id')
                ->toArray();
            foreach ($list_items as $key => $value) {
                // 创建人
                if ($value->reli_create_id && isset($adm_name[$value->reli_create_id])) {
                    $list_items[$key]->create_name = $adm_name[$value->reli_create_id];
                } else {
                    $list_items[$key]->create_name = '';
                }
            }

            // 查询备注信息
            $order_reamrks = DB::table('order_remarks')
                ->whereIn('orre_primary_id', $reli_id)
                ->where('orre_primary_type', 1)
                ->select('orre_create_adm_name', 'orre_content', 'orre_time', 'orre_primary_id', 'orre_module')
                ->orderby('orre_id', 'desc')
                ->get();
        } else {
            $reit_items = [];
            $order_reamrks = [];
        }
        // 查询预约单状态对应的预约单数量
        $state_count = DB::table('wash_reservation_list')
            ->where('reli_cid', $user_info->adm_cid)
            ->where('reli_shop_id', $user_info->adm_shop_id)
            ->select(DB::raw('count(*) as count, reli_state'))
            ->groupBy('reli_state')
            ->get();
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['reit_items'] = $reit_items;                //预约单商品数据
        $data['state_count'] = $state_count;
        $data['order_reamrks'] = $order_reamrks;           //预约单备注
        $data['now_time'] = date('Y-m-d H:i:s');           //当前时间
        return $data;
    }

    // 详情
    public static function info($user_info, $request)
    {
        $info = DB::table('wash_reservation_list as a')
            ->leftJoin('wash_reservation_client as b', 'a.reli_id', '=', 'b.recl_reli_id')
            ->leftJoin('shop as s', 's.shop_id', '=', 'a.reli_shop_id')
            ->where('reli_id', $request['reli_id'])
            ->where('reli_shop_id', $user_info->adm_shop_id)
            ->select('reli_id', 'reli_create_id', 'reli_order_number', 'reli_number', 'reli_client_type', 'reli_state', 'reli_appoint_time', 'reli_appoint_time_slot', 'reli_appoint_remark', 'reli_remark', 'reli_client_id','recl_channel_unit', 'recl_name', 'recl_phone', 'recl_car_num', 'recl_province', 'recl_city', 'recl_county', 'recl_address', 'recl_car_vehicle_type', 'recl_car_vin', 'recl_car_brand_series', 'reli_shop_id', 'shop_store_name', 'recl_ower_phone', 'recl_ower_name', 'reli_bus_name', 'reli_explain', 'reli_address', 'reli_address_id', 'reli_address_type')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前售后单不存在', 'data'=>''];
        }

        // 查询商品、项目信息
        $reit_items = DB::table('wash_reservation_items as w')
            ->leftJoin('service_project as s', 's.sepr_id', '=', 'w.reit_sepr_id')
            ->where('reit_reli_id', $request['reli_id'])
            ->select('reit_id', 'reit_reli_id', 'reit_goo_name', 'reit_goo_goods_encode', 'reit_sepr_id', 'reit_sepr_name', 'reit_part_state', 'reit_goo_id', 'sepr_order_money as reit_sepr_price')
            ->get()->toArray();
        // 账号id
        $adm_id[] = $info->reli_create_id;
        $adm_id = array_filter(array_unique($adm_id));
        if ($info->reli_client_type == 1) {
            // 查询账号id对应姓名
            $adm_name = DB::table('weixin_user')
                    ->whereIn('weus_id', $adm_id)
                    ->pluck('weus_nickmame', 'weus_id')
                    ->toArray();
        } else {
            $adm_name = DB::table('business_account')
                    ->whereIn('buac_id', $adm_id)
                    ->pluck('buac_name', 'buac_id')
                    ->toArray();
        }
        $info->create_name = '';
        if ($info->reli_create_id != '0') {
            if (isset($adm_name[$info->reli_create_id])) {
                $info->create_name = $adm_name[$info->reli_create_id]; //创建人
            } else {
                $info->create_name = '';
            }
        }

        $data['data'] = $info;
        $data['reit_items'] = $reit_items;

        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // // 预约下单新增
    // public static function oldadd($request)
    // {
    //     // 查询门店信息
    //     $find_shop = DB::table('shop')
    //         ->where('shop_id', $request['shop_id'])
    //         ->select('shop_cid', 'shop_id', 'shop_superior_id')
    //         ->first();
    //     $reli_data['reli_cid'] = $find_shop->shop_cid;
    //     $reli_data['reli_superior_shop_id'] = $find_shop->shop_superior_id;
    //     $reli_data['reli_shop_id'] = $find_shop->shop_id;

    //     // 获取预约单编号
    //     $user_info['adm_cid'] = $find_shop->shop_cid;
    //     $user_info['adm_shop_id'] = $find_shop->shop_id;
    //     $user_info['shop_superior_id'] = $find_shop->shop_superior_id;
    //     $reli_number = Common::numberRule((object)$user_info, 5);
    //     $reli_data['reli_number'] = $reli_number;//预约单号

    //     // 查询微信用户绑定的会员、客户信息
    //     $find_weixin_user = DB::table('user_shop as ussh')
    //         ->leftJoin('member as m', 'm.mem_id', '=', 'ussh.ussh_user_id')
    //         ->where('ussh_weus_id', $request['weus_id'])
    //         ->where('ussh_shop_id', $request['shop_id'])
    //         ->select('ussh_user_id', 'ussh_user_type', 'mem_name', 'mem_phone')
    //         ->first();
    //     if (empty($find_weixin_user)) {
    //         return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前用户未绑定', 'data'=>''];
    //     }
    //     $reli_data['reli_client_type'] = $find_weixin_user->ussh_user_type;//类型：1会员2客户单位
    //     $reli_data['reli_client_id'] = $find_weixin_user->ussh_user_id;//客户单位id，会员id
    //     $reli_data['reli_appoint_time'] = $request['appoint_time'];
    //     $reli_data['reli_appoint_time_slot'] = $request['appoint_time'];//预约时间段
    //     if (!empty($request['appoint_remark'])) {
    //         $reli_data['reli_appoint_remark'] = $request['appoint_remark'];//预约备注
    //     }
    //     $reli_data['reli_create_id'] = $request['weus_id'];//微信用户id
    //     $reli_id = DB::table('wash_reservation_list')->insertGetId($reli_data);

    //     // 预约单客户信息
    //     $recl_data['recl_shop_id'] = $request['shop_id'];
    //     $recl_data['recl_reli_id'] = $reli_id;
    //     $recl_data['recl_client_id'] = $find_weixin_user->ussh_user_id;
    //     $recl_data['recl_name'] = $find_weixin_user->mem_name;//会员姓名
    //     $recl_data['recl_ower_name'] = $request['name'];//车主姓名
    //     $isMatched = preg_match('#^13[\d]{9}$|^14[5,7]{1}\d{8}$|^15[^4]{1}\d{8}$|^16[\d]{1}\d{8}$|^17[0,6,7,8]{1}\d{8}$|^18[\d]{9}$|^19[\d]{9}$#', $request['phone']);
    //     if (!$isMatched) {
    //         return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'手机号格式不正确', 'data'=>''];
    //     }
    //     $recl_data['recl_phone'] = $find_weixin_user->mem_phone;//会员联系电话
    //     $recl_data['recl_ower_phone'] = $request['phone'];//联系电话
    //     if (!empty($request['car_num'])) {
    //         $isCarLicense = isCarLicense($request['car_num']);// 正则判断车牌号格式
    //         if (!$isCarLicense) {
    //             return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'车牌照格式不正确', 'data'=>''];
    //         }
    //         $recl_data['recl_car_num'] = $request['car_num'];//车牌号
    //     }
    //     if (!empty($request['car_vehicle_type'])) {//车型
    //         $recl_data['recl_car_vehicle_type'] = $request['car_vehicle_type'];
    //     }
    //     if (!empty($request['car_vin'])) {
    //         $recl_data['recl_car_vin'] = $request['car_vin'];//车架号车辆识别码
    //     } else {
    //         $recl_data['recl_car_vin'] = '';
    //     }
    //     $recl_data['recl_car_brand_series'] = $request['car_brand_series'];//品牌车系
    //     if (!empty($request['province'])) {//省
    //         $recl_data['recl_province'] = $request['province'];
    //     }
    //     if (!empty($request['city'])) {//市
    //         $recl_data['recl_city'] = $request['city'];
    //     }
    //     if (!empty($request['county'])) {//县
    //         $recl_data['recl_county'] = $request['county'];
    //     }
    //     if (!empty($request['address'])) {//地址
    //         $recl_data['recl_address'] = $request['address'];
    //     }
    //     $recl_id = DB::table('wash_reservation_client')->insertGetId($recl_data);

    //     // 预约单项目商品信息
    //     $reit_data['reit_shop_id'] = $request['shop_id'];
    //     $reit_data['reit_reli_id'] = $reli_id;//预约单id
    //     // 查询选择项目信息
    //     $find_sepr = DB::table('service_project')
    //         ->where('sepr_id', $request['sepr_id'])
    //         ->select('sepr_id', 'sepr_name', 'sepr_order_money')
    //         ->first();
    //     $reit_data['reit_sepr_id'] = $request['sepr_id'];
    //     // $reit_data['reit_sepr_price'] = $find_sepr->sepr_order_money;
    //     $reit_data['reit_sepr_name'] = $find_sepr->sepr_name;
    //     if (!empty($request['part_state'])) {//部位：1全车2部分
    //         $reit_data['reit_part_state'] = $request['part_state'];
    //     }
    //     $reit_res = DB::table('wash_reservation_items')->insert($reit_data);

    //     if ($reli_id && $recl_id && $reit_res) {
    //         $data['reli_number'] = $reli_number;
    //         // 添加客户消息
    //         // $add_data['weus_id'] = $request['weus_id'];
    //         // $add_data['shop_id'] = $request['shop_id'];
    //         // $add_data['primary_id'] = $reli_id; //单据的主键id
    //         // $add_data['primary_type'] = 3; //单据类型：1订单2工单3预约单4售后单
    //         // $add_data['read_state'] = 1; //阅读状态：1未读2已读
    //         // $add_data['title'] = '预约成功通知'; //阅读状态：1未读2已读
    //         // $add_data['content'] = '您申请的'.$find_sepr->sepr_name.'服务已预约成功，我们会尽快处理，请耐心等待'; //操作内容
    //         // $add_data['create_adm_name'] = $find_weixin_user->mem_name; //操作人姓名
    //         // $add_data['create_adm_id'] = $find_weixin_user->ussh_user_id; //操作人id
    //         // $addUserMessage_res = addUserMessage($add_data);
    //         // unset($add_data);
    //         // // 2.给相应的客户发送短信
    //         // $phone = $find_weixin_user->mem_phone;
    //         // $message = '【半径美装】尊敬的客户您好，您申请的'.$find_sepr->sepr_name.'服务已预约成功，请登录【半径美装】小程序查看';
    //         // if (preg_match("/^1[3456789]\d{9}$/", $phone)) {
    //         //     $send_res = sendSmsCode($phone, $message);
    //         //     if ($send_res > 0) {
    //         //         $send_state = 1;
    //         //     } else {
    //         //         $send_state = 2;
    //         //     }
    //         //     // 短信模块日志
    //         //     $seme_data['seme_cid'] = $find_shop->shop_cid; //公司id
    //         //     $seme_data['seme_shop_id'] =$find_shop->shop_id; //门店id
    //         //     $seme_data['seme_wor_id'] = $reli_id; //预约单id
    //         //     $seme_data['seme_name'] = '预约成功通知'; //模板名称
    //         //     $seme_data['seme_phone'] = $phone; //手机号
    //         //     $seme_data['seme_content'] = $message; //内容
    //         //     $seme_data['seme_row'] = 1; //条数
    //         //     $seme_data['seme_status_code'] = $send_res; //短信状态码
    //         //     $seme_data['seme_state'] = $send_state; //状态：1成功2失败
    //         //     $seme_data['seme_ip'] = $request['ip']; //ip地址
    //         //     $seme_data['seme_adm_id'] = $find_weixin_user->ussh_user_id; //创建人id
    //         //     $seme_id = DB::table('send_message')->insert($seme_data);
    //         // }
    //         // 添加新增预约单信息的提示
    //         // $inhi_data['inhi_original_adm_id'] = $find_weixin_user->ussh_user_id;//原始单号创建人
    //         // $inhi_data['inhi_original_id'] = $recl_id;//原始单id
    //         // $inhi_data['inhi_original_number'] = $reli_number;//原始单号
    //         // $inhi_data['inhi_original_state'] = 1;//原始单状态
    //         // $inhi_data['inhi_original_operation'] = '新增预约单';//操作
    //         // $inhi_data['inhi_operation_state'] = 24;//操作状态：24新增预约单
    //         // addInformationHint($user_info, $inhi_data, 4);
    //         return ['code'=>200, 'msg'=>'预约下单成功', 'data'=>$data];
    //     } else {
    //         return ['code'=>500, 'msg'=>'预约下单失败', 'data'=>''];
    //     }
    // }

    // 预约下单新增
    public static function add($request)
    {
        // 查询门店信息
        $find_shop = DB::table('shop')
            ->where('shop_id', $request['shop_id'])
            ->select('shop_cid', 'shop_id', 'shop_superior_id')
            ->first();
        $add_order_data['reli_cid'] = $find_shop->shop_cid;
        $add_order_data['reli_superior_shop_id'] = $find_shop->shop_superior_id;
        $add_order_data['reli_shop_id'] = $find_shop->shop_id;

        // 获取预约单编号
        $user_info['adm_cid'] = $find_shop->shop_cid;
        $user_info['adm_shop_id'] = $find_shop->shop_id;
        $user_info['shop_superior_id'] = $find_shop->shop_superior_id;
        $reli_number = Common::numberRule((object)$user_info, 5);
        $add_order_data['reli_number'] = $reli_number;//预约单号

        // 查询微信用户绑定的会员、客户信息
        $find_weixin_user = DB::table('user_shop as ussh')
            ->leftJoin('member as m', 'm.mem_id', '=', 'ussh.ussh_user_id')
            ->where('ussh_weus_id', $request['weus_id'])
            ->where('ussh_shop_id', $request['shop_id'])
            ->select('ussh_user_id', 'ussh_user_type', 'mem_name', 'mem_phone')
            ->first();
        if (empty($find_weixin_user)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前用户未绑定', 'data'=>''];
        }
        $add_order_data['reli_client_type'] = $find_weixin_user->ussh_user_type;//类型：1会员2客户单位
        $add_order_data['reli_client_id'] = $find_weixin_user->ussh_user_id;//客户单位id，会员id
        $add_order_data['reli_appoint_time'] = $request['appoint_time'];
        $add_order_data['reli_appoint_time_slot'] = $request['appoint_time'];//预约时间段
        if (!empty($request['appoint_remark'])) {
            $add_order_data['reli_appoint_remark'] = $request['appoint_remark'];//预约备注
        }
        $add_order_data['reli_create_id'] = $request['weus_id'];//微信用户id
        $reli_id = DB::table('wash_reservation_list')->insertGetId($add_order_data);

        // 预约单客户信息
        $recl_data['recl_shop_id'] = $request['shop_id'];
        $recl_data['recl_reli_id'] = $reli_id;
        $recl_data['recl_client_id'] = $find_weixin_user->ussh_user_id;
        $recl_data['recl_name'] = $find_weixin_user->mem_name;//会员姓名
        $recl_data['recl_ower_name'] = $request['name'];//车主姓名
        $isMatched = preg_match('#^13[\d]{9}$|^14[5,7]{1}\d{8}$|^15[^4]{1}\d{8}$|^16[\d]{1}\d{8}$|^17[0,6,7,8]{1}\d{8}$|^18[\d]{9}$|^19[\d]{9}$#', $request['phone']);
        if (!$isMatched) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'手机号格式不正确', 'data'=>''];
        }
        $recl_data['recl_phone'] = $find_weixin_user->mem_phone;//会员联系电话
        $recl_data['recl_ower_phone'] = $request['phone'];//联系电话
        if (!empty($request['car_num'])) {
            $isCarLicense = isCarLicense($request['car_num']);// 正则判断车牌号格式
            if (!$isCarLicense) {
                return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'车牌照格式不正确', 'data'=>''];
            }
            $recl_data['recl_car_num'] = $request['car_num'];//车牌号
        }
        if (!empty($request['car_vehicle_type'])) {//车型
            $recl_data['recl_car_vehicle_type'] = $request['car_vehicle_type'];
        }
        if (!empty($request['car_vin'])) {
            $recl_data['recl_car_vin'] = $request['car_vin'];//车架号车辆识别码
        } else {
            $recl_data['recl_car_vin'] = '';
        }
        $recl_data['recl_car_brand_series'] = $request['car_brand_series'];//品牌车系
        if (!empty($request['province'])) {//省
            $recl_data['recl_province'] = $request['province'];
        }
        if (!empty($request['city'])) {//市
            $recl_data['recl_city'] = $request['city'];
        }
        if (!empty($request['county'])) {//县
            $recl_data['recl_county'] = $request['county'];
        }
        if (!empty($request['address'])) {//地址
            $recl_data['recl_address'] = $request['address'];
        }
        $recl_id = DB::table('wash_reservation_client')->insertGetId($recl_data);

        // 预约单项目商品信息
        $reit_data['reit_shop_id'] = $request['shop_id'];
        $reit_data['reit_reli_id'] = $reli_id;//预约单id
        // 查询选择项目信息
        $find_sepr = DB::table('service_project')
            ->where('sepr_id', $request['sepr_id'])
            ->select('sepr_id', 'sepr_name', 'sepr_order_money')
            ->first();
        $reit_data['reit_sepr_id'] = $request['sepr_id'];
        // $reit_data['reit_sepr_price'] = $find_sepr->sepr_order_money;
        $reit_data['reit_sepr_name'] = $find_sepr->sepr_name;
        if (!empty($request['part_state'])) {//部位：1全车2部分
            $reit_data['reit_part_state'] = $request['part_state'];
        }
        $reit_res = DB::table('wash_reservation_items')->insert($reit_data);

        if ($reli_id && $recl_id && $reit_res) {
            $data['reli_number'] = $reli_number;
            // 添加客户消息
            // $add_data['weus_id'] = $request['weus_id'];
            // $add_data['shop_id'] = $request['shop_id'];
            // $add_data['primary_id'] = $reli_id; //单据的主键id
            // $add_data['primary_type'] = 3; //单据类型：1订单2工单3预约单4售后单
            // $add_data['read_state'] = 1; //阅读状态：1未读2已读
            // $add_data['title'] = '预约成功通知'; //阅读状态：1未读2已读
            // $add_data['content'] = '您申请的'.$find_sepr->sepr_name.'服务已预约成功，我们会尽快处理，请耐心等待'; //操作内容
            // $add_data['create_adm_name'] = $find_weixin_user->mem_name; //操作人姓名
            // $add_data['create_adm_id'] = $find_weixin_user->ussh_user_id; //操作人id
            // $addUserMessage_res = addUserMessage($add_data);
            // unset($add_data);
            // // 2.给相应的客户发送短信
            // $phone = $find_weixin_user->mem_phone;
            // $message = '【半径美装】尊敬的客户您好，您申请的'.$find_sepr->sepr_name.'服务已预约成功，请登录【半径美装】小程序查看';
            // if (preg_match("/^1[3456789]\d{9}$/", $phone)) {
            //     $send_res = sendSmsCode($phone, $message);
            //     if ($send_res > 0) {
            //         $send_state = 1;
            //     } else {
            //         $send_state = 2;
            //     }
            //     // 短信模块日志
            //     $seme_data['seme_cid'] = $find_shop->shop_cid; //公司id
            //     $seme_data['seme_shop_id'] =$find_shop->shop_id; //门店id
            //     $seme_data['seme_wor_id'] = $reli_id; //预约单id
            //     $seme_data['seme_name'] = '预约成功通知'; //模板名称
            //     $seme_data['seme_phone'] = $phone; //手机号
            //     $seme_data['seme_content'] = $message; //内容
            //     $seme_data['seme_row'] = 1; //条数
            //     $seme_data['seme_status_code'] = $send_res; //短信状态码
            //     $seme_data['seme_state'] = $send_state; //状态：1成功2失败
            //     $seme_data['seme_ip'] = $request['ip']; //ip地址
            //     $seme_data['seme_adm_id'] = $find_weixin_user->ussh_user_id; //创建人id
            //     $seme_id = DB::table('send_message')->insert($seme_data);
            // }
            // 添加新增预约单信息的提示
            // $inhi_data['inhi_original_adm_id'] = $find_weixin_user->ussh_user_id;//原始单号创建人
            // $inhi_data['inhi_original_id'] = $recl_id;//原始单id
            // $inhi_data['inhi_original_number'] = $reli_number;//原始单号
            // $inhi_data['inhi_original_state'] = 1;//原始单状态
            // $inhi_data['inhi_original_operation'] = '新增预约单';//操作
            // $inhi_data['inhi_operation_state'] = 24;//操作状态：24新增预约单
            // addInformationHint($user_info, $inhi_data, 4);
            return ['code'=>200, 'msg'=>'预约下单成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'预约下单失败', 'data'=>''];
        }
    }

    /**
     * [cancel 取消撤回预约单]
     * @param  [type] $user_info [用户信息]
     * @param  [type] $request   [提交数据]
     * @param  [type] $state     [状态：3取消订单4已撤回]
     * @return [type]            [description]
     */
    public static function cancel($user_info, $request, $state)
    {
        $find_order = DB::table('wash_reservation_list')
            ->where('reli_id', $request['reli_id'])
            ->where('reli_shop_id', $user_info->adm_shop_id)
            ->select('reli_number', 'reli_state')
            ->first();
        if (empty($find_order)) {
            return ['code'=>ErrorInc::BUSINESS_FORBID, 'msg'=>'当前预约单不存在！', 'data'=>''];
        }
        if ($find_order->reli_state == 2) {
            return ['code'=>ErrorInc::BUSINESS_FORBID, 'msg'=>'当前预约单已接单，无法取消！', 'data'=>''];
        }
        if ($find_order->reli_state == 3) {
            return ['code'=>ErrorInc::BUSINESS_FORBID, 'msg'=>'当前预约单已经取消！', 'data'=>''];
        }
        if ($find_order->reli_state == 4) {
            return ['code'=>ErrorInc::BUSINESS_FORBID, 'msg'=>'当前预约单已撤回，无法取消！', 'data'=>''];
        }

        $reli_data['reli_state'] = $state; //预约单状态：1待结单2已接单3取消订单4已撤回
        if (!empty($request['remark'])) {
            $reli_data['reli_remark'] = $request['remark']; //撤回备注
        }
        $reli_data['reli_update_time'] = date('Y-m-d H:i:s');
        $reli_res = DB::table('wash_reservation_list')->where('reli_id', $request['reli_id'])->update($reli_data);

        if ($reli_res) {
            $data['reli_number'] = $find_order->reli_number;
            return ['code'=>200, 'msg'=>'取消成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'取消失败', 'data'=>''];
        }
    }

    /**
     * [cancel 客户小程序撤回预约单]
     * @param  [type] $user_info [用户信息]
     * @param  [type] $request   [提交数据]
     * @param  [type] $state     [状态：3取消订单4已撤回]
     * @return [type]            [description]
     */
    public static function withdraw($request, $state)
    {
        $find_order = DB::table('wash_reservation_list')
            ->where('reli_id', $request['reli_id'])
            ->where('reli_shop_id', $request['shop_id'])
            ->select('reli_number', 'reli_state')
            ->first();
        if (empty($find_order)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前预约单不存在！', 'data'=>''];
        }
        if ($find_order->reli_state == 2) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前预约单已接单，无法取消！', 'data'=>''];
        }
        if ($find_order->reli_state == 3) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前预约单已经取消！', 'data'=>''];
        }
        if ($find_order->reli_state == 4) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前预约单已撤回，无法取消！', 'data'=>''];
        }

        $reli_data['reli_state'] = $state; //预约单状态：1待结单2已接单3取消订单4已撤回
        if (!empty($request['remark'])) {
            $reli_data['reli_remark'] = $request['remark']; //撤回备注
        }
        $reli_data['reli_update_time'] = date('Y-m-d H:i:s');
        $reli_res = DB::table('wash_reservation_list')->where('reli_id', $request['reli_id'])->update($reli_data);

        if ($reli_res) {
            $data['reli_number'] = $find_order->reli_number;
            return ['code'=>200, 'msg'=>'取消预约成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'取消预约失败', 'data'=>''];
        }
    }

    // 备注查询数据
    public static function remarkSearch($user_info, $request)
    {
        $find_data = DB::table('wash_reservation_list')
            ->where('reli_id', $request['reli_id'])
            ->where('reli_shop_id', $user_info->adm_shop_id)
            ->select('reli_number', 'reli_id', 'reli_state')
            ->first();
        $data['reli_number'] = $find_data->reli_number;
        $data['reli_id'] = $find_data->reli_id;
        return $data;
    }

    // 预约设置
    public function appointmentSet($user_info, $request)
    {
        $find_order = DB::table('wash_reservation_list')
            ->where('reli_id', $request['reli_id'])
            ->where('reli_shop_id', $user_info->adm_shop_id)
            ->select('reli_number', 'reli_state')
            ->first();
        if (empty($find_order)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前预约单不存在！', 'data'=>''];
        }
        if ($find_order->reli_state == 2) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前预约单已接单！', 'data'=>''];
        }
        if ($find_order->reli_state == 3) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前预约单已经取消！', 'data'=>''];
        }
        if ($find_order->reli_state == 4) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前预约单已撤回！', 'data'=>''];
        }

        // 预约单客户表更改预约时间、预约备注
        $edit_data['reli_appoint_time'] = $request['appoint_time'];
        $edit_data['reli_appoint_time_slot'] = $request['appoint_time'];//预约时间段
        if (!empty($request['appoint_remark'])) {
            $edit_data['reli_appoint_remark'] = $request['appoint_remark'];
        } else {
            $edit_data['reli_appoint_remark'] = '';
        }
        $edit_data['reli_update_time'] = date('Y-m-d H:i:s');
        $edit_res = DB::table('wash_reservation_list')
            ->where('reli_id', $request['reli_id'])
            ->update($edit_data);

        if ($edit_res) {
            $data['reli_number'] = $find_order->reli_number;
            return ['code'=>200, 'msg'=>'预约设置成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'预约设置失败', 'data'=>''];
        }
    }

    // 获取字段数据
    public static function getFieldsById($id, $fields = '*', $shopID = 0){
    	$entity = Reservation::where('reli_id', $id)
            ->where('reli_shop_id', $shopID)
            ->select($fields)
            ->first();

    	return $entity;
    }
}