<?php
namespace App\Services\Business;


use App\Services\CommonService;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\DB;

class RecLogService extends Service
{
    /**|---------------------------------------------------------------------------------
     * @name 计算充值归还路径
     * @param int $relo_ord_id 订单id
     * @param int $return_num 归还金额
     * @retrun /multitype:array
     * @author dou 2023/10/25 17:30
     * |---------------------------------------------------------------------------------
     */
    public static function getReturnMoenyRout ($relo_ord_id, $return_num){
        $relo_rec_num = 0;//充值金额
        $relo_gift_num = 0;//赠送金额
        $relo_mem_id = 0;//会员id 为0时使用订单会员id
        $return_num = $return_num;

        $all_num = DB::table('rec_log')
            ->where('relo_create_id',$relo_ord_id)
            ->select('relo_rec_num','relo_gift_num','relo_type','relo_mem_id')->get();
        if(!empty($all_num)){
            $all_num = CommonService::dataToArray($all_num);
            foreach($all_num as $k => $v){
                $relo_mem_id = $v['relo_mem_id'];
                if($v['relo_type'] == '2' || $v['relo_type'] == '3'){
                    $relo_gift_num += $v['relo_gift_num'];
                }else{
                    $relo_gift_num -= $v['relo_gift_num'];
                }
            }
            if($relo_gift_num > 0) {
                if ($relo_gift_num >= $return_num) {
                    $relo_gift_num = $return_num;
                } else {
                    $relo_rec_num = $return_num - $relo_gift_num;
                }
            }else{
                $relo_rec_num = $return_num;
                $relo_gift_num = 0;
            }
        }else{
            $relo_rec_num = $return_num;
        }
        $data['relo_rec_num'] = $relo_rec_num;
        $data['relo_gift_num'] = $relo_gift_num;
        $data['relo_mem_id'] = $relo_mem_id;
        return $data;
    }
}
