<?php

namespace App\Services\Business;

use App\Http\Controllers\Api\Verify\MemberManage\VerifyMemberLevelController;
use App\Http\Controllers\Api\Verify\MemberManage\VerifyMemberListController;
use App\Services\CommonService;
use App\Services\LoginUserService;
use App\Services\Point\PointService;
use App\Services\Shop\ShopService;
use BlueCity\Core\Service\Service;
use App\Http\Models\Api\Common;
use Illuminate\Support\Facades\DB;
use App\Models\Common as Comm;

// 会员等级
class MemberLevelService extends Service
{

    // 列表
    public static function index($request)
    {
        // 验证数据
        $verify_data = new VerifyMemberLevelController;
        $error_message = $verify_data->indexValidator($request);
        if ($error_message) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $count = DB::table('member_level')
            ->where('meml_cid', $user_info->adm_cid)
            ->where('meml_superior_shop_id', $shop_id)
            ->count();
        if($count > 0){
            $data = self::list($user_info,$request);
        }else{
            self::add($user_info);
            $data = self::list($user_info,$request);
        }

        return $data;
    }

    //获取列表信息
    public static function list($user_info,$search_data)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $page_size = $search_data['show_count'] ? $search_data['show_count'] : 10;
        $list_data = DB::table('member_level')
            ->where('meml_cid', $user_info->adm_cid)
            ->where('meml_superior_shop_id', $shop_id)
            ->where(function ($query) use ($search_data) { //是否显示是否显示：1否2是
                if (!empty($search_data['meml_show'])) {
                    $query->where('meml_show', $search_data['meml_show']);
                }
            })
            ->where(function ($query) use ($search_data) { //会员名称
                if (!empty($search_data['meml_name'])) {
                    $query->where('meml_name', $search_data['meml_name']);
                }
            })
            ->orderBy('meml_id', 'asc')
            ->paginate($page_size);
        $list_items = $list_data->items();
        // 获取当前列表下的按钮
        $list_button = getListButton($search_data['api_token'], $search_data['pri_id']);
        if ($list_items) {
            foreach ($list_items as $key => $value) {
                if($value->meml_level == '5'){
                    $list_items[$key]->meml_level_name = '付费会员';//会员等级
                }else{
                    $list_items[$key]->meml_level_name = $value->meml_level;//会员等级
                }
                $list_items[$key]->meml_total_amount = $value->meml_total_amount / 100;//会员消费金额
                if($value->meml_discount){
                    $list_items[$key]->meml_discount_name = $value->meml_discount.'折';
                }else{
                    $list_items[$key]->meml_discount_name = '不打折';
                }
                /*if($value->meml_is_discount == '2'){//是否享受折扣：1否2是
                    $list_items[$key]->meml_discount_name = $value->meml_discount.'折';
                }else{
                    $list_items[$key]->meml_discount_name = '不打折';
                }*/
                if($value->meml_points_multiple > 0){
                    $list_items[$key]->meml_points_multiple_name = $value->meml_points_multiple.'倍';//积分倍数
                }else{
                    $list_items[$key]->meml_points_multiple_name = '';//积分倍数
                }
                if($value->meml_type == 2){
                    $list_items[$key]->meml_type_name = '付费';
                }else{
                    $list_items[$key]->meml_type_name = '免费';
                }
                //按钮
                $buttonData[] = 'edit';//编辑
                $buttonData[] = 'info';//详情
                $button = CommonService::getListButton($buttonData,$list_button);
                $list_items[$key]->button_one = $button['button_one']??[];
                $list_items[$key]->button_two = $button['button_two']??[];
                $list_items[$key]->button_three = $button['button_three']??[];
                unset($buttonData);
            }
        }
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $page_size;       //一页显示多少个
        $data_info['data'] = $list_items;                //返回数据
        if ($list_data) {
            return ['code' => 200, 'msg' => '成功', 'data' => $data_info];
        } else {
            return ['code' => 500, 'msg' => '暂无数据', 'data' => '暂无数据'];
        }
    }

    //添加
    public static function add($user_info)
    {
        // 验证数据
//        $verify_data = new VerifyMemberLevelController;
//        $error_message = $verify_data->addValidator($request->all());
//        if ($error_message) {
//            return response()->json(['code' => 500, 'msg' => $error_message, 'data' => '参数错误', 'error_message' => $error_message]);
//        }
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $level_arr = [1=>'白银会员',2=>'黄金会员',3=>'铂金会员',4=>'钻石会员',5=>'黑钻会员'];
        //$level_arr = ['白银会员'=>1,'黄金会员'=>1,'铂金会员'=>1,'钻石会员'=>1,'黑钻会员'=>2];
        foreach ($level_arr as $key => $value){
            $add_data['meml_cid'] = $user_info->adm_cid;
            $add_data['meml_shop_id'] = $user_info->adm_shop_id;
            $add_data['meml_superior_shop_id'] = $shop_id;
            $add_data['meml_name'] = $value;//等级名称
            $add_data['meml_level'] = $key;//会员等级
            $add_data['meml_total_amount'] = 0;//会员消费金额
            $add_data['meml_discount'] = '';//折扣
            $add_data['meml_points_multiple'] = 1;//积分倍数
            $add_data['meml_type'] = 1;//会员类型：1免费2付费
            if($key == 5){
                $add_data['meml_type'] = 2;//会员类型：1免费2付费
            }
            $add_data['meml_forever'] = 1;//有效时间：1永久有效2月
            $add_data['meml_create_time'] = date('Y-m-d H:i:s');//添加时间
            $add_data['meml_create_name'] = $user_info->adm_name;//创建人
            $add_data['meml_create_id'] = $user_info->adm_id;//创建人id
            $ret_id =  DB::table('member_level')->insertGetId($add_data);
        }
        if ($ret_id) {
            return ['code' => 200, 'msg' => '新增成功', 'data' =>''];
        } else {
            return ['code' => 500, 'msg' => '新增失败', 'data' => '新增失败'];
        }
    }

    // 编辑
    public static function edit($request)
    {
        // 验证数据
        $verify_data = new VerifyMemberLevelController;
        $error_message = $verify_data->editValidator($request); //验证编辑id是否存在
        if ($error_message) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $data = DB::table('member_level')
            ->where('meml_cid', $user_info->adm_cid)
            ->where('meml_shop_id', $shop_id)
            ->where('meml_id', $request['meml_id'])
            ->first();
        $goods_data = DB::table('member_level_goods')
            ->where('memlg_cid', $user_info->adm_cid)
            ->where('memlg_shop_id', $shop_id)
            ->where('memlg_meml_id', $data->meml_level)
            ->get()->toArray();
        if($request['type'] == 1){//获取内容
            $data->meml_total_amount = $data->meml_total_amount / 100;//会员消费金额
            $data->meml_price = $data->meml_price / 100;//付费用户的购买金额
            // 获取当前列表下的按钮
            $list_button = getListButton($request['api_token'], $request['pri_id']);
            //按钮
            $buttonData[] = 'add';//添加
            $button = CommonService::getListButton($buttonData,$list_button);
            $data->button_one = $button['button_one']??[];
            $data->button_two = $button['button_two']??[];
            $data->button_three = $button['button_three']??[];
            unset($buttonData);
            //获取赠礼的按钮
            if(!empty($goods_data)){
                foreach ($goods_data as $g_key => $g_value){
                    //按钮
                    $buttonData[] = 'save';//编辑
                    $buttonData[] = 'delete';//删除
                    $button = CommonService::getListButton($buttonData,$list_button);
                    $g_value->button_one = $button['button_one']??[];
                    $g_value->button_two = $button['button_two']??[];
                    $g_value->button_three = $button['button_three']??[];
                    unset($buttonData);
                }
            }
            $data->goods = $goods_data;
            if ($data) {
                return ['code' => 200, 'msg' => '获取成功', 'data' => $data];
            } else {
                return ['code' => 500, 'msg' => '获取失败', 'data' => '获取失败'];
            }
        }else if ($request['type'] == 2){//修改内容
            $error_message = $verify_data->editContentValidator($request); //验证编辑meml_show是否存在
            if ($error_message) {
                return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
            }
            $edit_data['meml_total_amount'] = $request['meml_total_amount'] * 100;//会员消费金额
            //$edit_data['meml_is_discount'] = $request['meml_is_discount'];//是否享受折扣：1否2是
            if($request['meml_discount'] == ''){
                $edit_data['meml_discount'] = '';//折扣
            }else if(isset($request['meml_discount'])){
                if($request['meml_discount'] >= 10 ||  $request['meml_discount'] <= 0){
                    return ['code' => 500, 'msg' => '折扣必须小于10，大于0', 'data' => ''];
                }
                $edit_data['meml_discount'] = $request['meml_discount'];//折扣
            }else{
                return ['code' => 500, 'msg' => '折扣必须小于10，大于0', 'data' => ''];
            }
            if($request['meml_points_multiple'] < 1){
                return ['code' => 500, 'msg' => '积分倍数最小为1', 'data' => ''];
            }
            $edit_data['meml_points_multiple'] = $request['meml_points_multiple'];//积分倍数
            if($data->meml_level == 5){
                $edit_data['meml_price'] = $request['meml_price'] * 100;//购买会员金额
            }
            $edit_data['meml_forever'] = $request['meml_forever'];//有效时间：1永久有效2月
            $edit_data['meml_effect_length'] = $request['meml_effect_length'];//有效时长
            $edit_data['meml_update_time'] = date('Y-m-d H:i:s');//添加时间
            $edit_data['meml_update_id'] = $user_info->adm_id;
            if($data->meml_show == 2){//开启状态
                if($data->meml_level == 5){
                    if($request['meml_price'] <= 0){//购买价格必填
                        return ['code' => 500, 'msg' => '购买会员价格必填', 'data' => ''];
                    }
                    if($request['meml_forever'] == 2 && $request['meml_effect_length'] == 0){
                        return ['code' => 500, 'msg' => '会员有效期必填', 'data' => ''];
                    }
                }else{
                    $old_level = DB::table('member_level')
                        ->where('meml_cid', $user_info->adm_cid)
                        ->where('meml_shop_id', $shop_id)
                        ->where('meml_show', 2)
                        ->where('meml_level', '!=',5)
                        ->where('meml_id', '<',$request['meml_id'])
                        ->orderBy('meml_id','desc')
                        ->first();
                    if(!empty($old_level)){
                        if($edit_data['meml_total_amount'] <= $old_level->meml_total_amount){
                            return ['code' => 500, 'msg' => '交易额需大于'.$old_level->meml_name.'的交易额：'.($old_level->meml_total_amount / 100).'元', 'data' => ''];
                        }
                    }
                    $old_level = DB::table('member_level')
                        ->where('meml_cid', $user_info->adm_cid)
                        ->where('meml_shop_id', $shop_id)
                        ->where('meml_show', 2)
                        ->where('meml_level', '!=',5)
                        ->where('meml_id', '>',$request['meml_id'])
                        ->orderBy('meml_id','asc')
                        ->first();
                    if(!empty($old_level)){
                        if($edit_data['meml_total_amount'] >= $old_level->meml_total_amount){
                            return ['code' => 500, 'msg' => '交易额需小于'.$old_level->meml_name.'的交易额：'.($old_level->meml_total_amount / 100).'元', 'data' => ''];
                        }
                    }
                }
            }
            $notice = '编辑';
            //$request['goods_data'][] = ['memlg_goo_id'=>89,'memlg_goo_name'=>'第十四张卡','memlg_goo_type'=>3,'memlg_goo_type_name'=>'会员卡','edit_show'=>'false'];
            if(isset($request['goods_data']) && !empty($request['goods_data'])){
                foreach ($request['goods_data'] as $e_key => $e_value){ //return ['code' => 500, 'msg' => '参数错误', 'data' => $e_value];
                    $img = self::getGoodPic($e_value['memlg_goo_type'],$e_value['memlg_goo_id']);
                    if(!empty($e_value['memlg_goo_type_name']) && !empty($e_value['memlg_goo_id'])){
                        $edit_goods_data[$e_key]['memlg_superior_shop_id'] = $shop_id;
                        $edit_goods_data[$e_key]['memlg_shop_id'] = $shop_id;
                        $edit_goods_data[$e_key]['memlg_pic'] = $img;//商品封面图
                        $edit_goods_data[$e_key]['memlg_goo_type'] = $e_value['memlg_goo_type'];//类型：1服务2商品3会员卡
                        $edit_goods_data[$e_key]['memlg_goo_type_name'] = $e_value['memlg_goo_type_name'];//类型名称
                        $edit_goods_data[$e_key]['memlg_goo_id'] = $e_value['memlg_goo_id'];//商品id
                        $edit_goods_data[$e_key]['memlg_goo_name'] = $e_value['memlg_goo_name'];//名称
                        //$edit_goods_data[$e_key]['memlg_goo_price'] = $e_value['memlg_goo_price'];//商品价格
                        $edit_goods_data[$e_key]['memlg_meml_id'] = $data->meml_level;//会员等级id
                        $edit_goods_data[$e_key]['memlg_update_time'] = date('Y-m-d H:i:s');//修改时间
                        $edit_goods_data[$e_key]['memlg_update_id'] = $user_info->adm_id;
                    }
                }
            }
        }else if($request['type'] == 3){//修改是否显示
            $error_message = $verify_data->editShowValidator($request); //验证编辑meml_show是否存在
            if ($error_message) {
                return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
            }
            if($request['meml_show'] == 2){//如果开启，需要验证以下内容
                if($data->meml_points_multiple < 1){//积分倍数不能小于1
                    return ['code' => 500, 'msg' => '积分倍数必须大于等于1', 'data' => ''];
                }
                if($data->meml_level == 5){//如果等于5，就是付费用户，

                    if($data->meml_price <= 0){//购买价格必填
                        return ['code' => 500, 'msg' => '购买会员价格必填', 'data' => ''];
                    }
                    if($data->meml_forever <= 0){
                        return ['code' => 500, 'msg' => '有效期必填', 'data' => ''];
                    }
                    if($data->meml_forever == 2 && $data->meml_effect_length < 1){//有效时间：1永久有效2月
                        return ['code' => 500, 'msg' => '有效期必填', 'data' => ''];
                    }
                }else{
                    $old_level = DB::table('member_level')
                        ->where('meml_cid', $user_info->adm_cid)
                        ->where('meml_shop_id', $shop_id)
                        ->where('meml_show', 2)
                        ->where('meml_level', '!=',5)
                        ->where('meml_id', '<',$request['meml_id'])
                        ->orderBy('meml_id','desc')
                        ->first();
                    if(!empty($old_level)){
                        if($data->meml_total_amount <= $old_level->meml_total_amount){
                            return ['code' => 500, 'msg' => '交易额需大于'.$old_level->meml_name.'的交易额：'.($old_level->meml_total_amount / 100).'元', 'data' => ''];
                        }
                    }
                    $old_level = DB::table('member_level')
                        ->where('meml_cid', $user_info->adm_cid)
                        ->where('meml_shop_id', $shop_id)
                        ->where('meml_show', 2)
                        ->where('meml_level', '!=',5)
                        ->where('meml_id', '>',$request['meml_id'])
                        ->orderBy('meml_id','asc')
                        ->first();
                    if(!empty($old_level)){
                        if($data->meml_total_amount >= $old_level->meml_total_amount){
                            return ['code' => 500, 'msg' => '交易额需小于'.$old_level->meml_name.'的交易额：'.($old_level->meml_total_amount / 100).'元', 'data' => ''];
                        }
                    }
                }
            }
            $edit_data['meml_show'] = $request['meml_show'];//是否显示：1否2是
            $notice = '编辑';
        }
        DB::beginTransaction();
        $member_res = DB::table('member_level')
            ->where('meml_cid', $user_info->adm_cid)
            ->where('meml_shop_id', $shop_id)
            ->where('meml_id', $request['meml_id'])
            ->update($edit_data);
        if(isset($edit_goods_data) && !empty($edit_goods_data)){
            $del_mem = DB::table('member_level_goods')
                ->where('memlg_cid', $user_info->adm_cid)
                ->where('memlg_shop_id', $shop_id)
                ->where('memlg_meml_id', $data->meml_level)
                ->delete();
           foreach ($edit_goods_data as $edit_key => $edit_value){
               /*if($edit_value['memlg_id']){
                   $goods_ret = DB::table('member_level_goods')
                       ->where('memlg_id', $edit_value['memlg_id'])
                       ->update($edit_value);
               }else{
                   $goods_ret = DB::table('member_level_goods')->insertGetId($edit_value);
               }*/
               $goods_ret = DB::table('member_level_goods')->insertGetId($edit_value);
           }
        }
        if ($member_res) {
            DB::commit();
            return ['code' => 200, 'msg' => $notice.'成功', 'data' => ''];
        } else {
            DB::rollback();
            return ['code' => 500, 'msg' => $notice.'失败', 'data' => ''];
        }
    }

    //获取商品图片
    public static function getGoodPic($type,$id){
        $img = '';
        if ($type == 2) {//商品
            $img = DB::table('goods')
                ->where('goo_id', $id)
                ->value('goo_pic');
            if(empty($img)){
                $img = config('apisystem.server_name_https').'/storage/image/default_goo_img.png';
            }
        }
        if ($type == 1) {//服务
            $img = DB::table('service_project')
                ->where('sepr_id', $id)
                ->value('sepr_img');
            if(empty($img)){
                $img = config('apisystem.server_name_https').'/storage/image/default_goo_img.png';
            }
        }
        if ($type == 3) {//会员卡
            $img = config('apisystem.server_name_https').'/image/customerImg/order_vip.png';
        }
        return $img;
    }

    //商品列表
    public static function getGoods($request){
        // 验证参数
        $verify_data = new VerifyMemberLevelController;
        $error_message = $verify_data->getGoodsValidator($request);
        if (!empty($error_message)) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
        }
        $user_info = LoginUserService::getUser();
        if (empty($request['show_count'])) {
            $request['show_count'] = 30;
        }
        $service = new PointService();
        $res = $service::getGoods($user_info, $request, $request['show_count']);
        if ($res) {
            return ['code'=>200, 'msg'=>'成功','data'=>$res];
        } else {
            return ['code'=>200, 'msg'=>'暂无数据','data'=>$res];
        }
    }

    //商品会员赠礼商品
    public static function editGoods($request){
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        //查找该店铺的赠礼是否有提交数据的类型的商品
        $pogg_id = DB::table('member_level_goods')
            ->where('meml_cid', $user_info->adm_cid)
            ->where('meml_shop_id', $shop_id)
            //->where('memlg_id', '<>', $request['memlg_id'])
            ->where('memlg_goo_type', $request['memlg_goo_type'])
            ->where('memlg_goo_id', $request['memlg_goo_id'])
            ->where('memlg_meml_id', $request['memlg_meml_id'])
            ->where(function ($query) use ($request) {
                if (!empty($data['memlg_goo_id'])) {
                    $query->where('memlg_goo_id', $request['memlg_goo_id']);
                } else {
                    $query->where('memlg_goo_name', $request['memlg_goo_name']);
                }
            })
            ->value('memlg_id');
        if ($pogg_id) {
            return ['code'=>500, 'msg'=>'此积分商品已存在', 'data'=>''];
        }
        $add_data['memlg_cid'] = $user_info->adm_cid;
        $add_data['memlg_superior_shop_id'] = $shop_id;
        $add_data['memlg_shop_id'] = $shop_id;
        $add_data['memlg_pic'] = $request['memlg_pic'];//封面图
        $add_data['memlg_goo_type'] = $request['memlg_goo_type'];//类型：1服务2商品3会员卡
        $add_data['memlg_goo_type_name'] = $request['memlg_goo_type_name'];//类型：1服务2商品3会员卡
        $add_data['memlg_goo_id'] = $request['memlg_goo_id'];//商品id
        $add_data['memlg_goo_name'] = $request['memlg_goo_name'];//商品名称
        //$add_data['memlg_goo_price'] = $request['memlg_goo_price'];//商品价格
        $add_data['memlg_meml_id'] = $request['memlg_meml_id'];//会员等级id
        $add_data['meml_create_time'] = date('Y-m-d H:i:s');//添加时间
        $add_data['meml_create_name'] = $user_info->adm_name;
        $add_data['meml_create_id'] = $user_info->adm_id;
        if($request['type'] == 1){//添加
            $res = DB::table('member_level_goods')->insertGetId($add_data);;
        }else if($request['type'] == 2){//修改
            // 验证数据
            $verify_data = new VerifyMemberLevelController;
            $error_message = $verify_data->editGoodsValidator($request); //验证编辑id是否存在
            if ($error_message) {
                return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
            }
            $update_res = DB::table('member_level_goods')->where('pogg_id', $request['memlg_id'])->update($add_data);
        }
        if ($res) {
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>''];
        }
    }

    //商品会员赠礼商品
    public static function upgrade($request){
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $level = DB::table('member_level')
            ->where('meml_cid', $user_info->adm_cid)
            ->where('meml_shop_id', $user_info->adm_shop_id)
            ->where('meml_show', 2)
            ->where('meml_level', 5)
            ->first();
        $level = CommonService::dataToArray($level);
        /*$mem = DB::table('member')
            ->where('mem_cid', $user_info->adm_cid)
            ->where('mem_shop_id', $user_info->adm_shop_id)
            ->where('mem_id', $request['mem_id'])
            ->first();
        $mem = CommonService::dataToArray($mem);*/
        $find_mem = DB::table('member')->where('mem_id', $request['mem_id'])->first();
        $level['orcl_name'] = $find_mem->mem_name;
        $level['orcl_phone'] = $find_mem->mem_phone;
        $level['ord_client_id'] = $request['mem_id'];
        $request = array_merge($level);
        $res = self::addOrder($user_info,$request,1);
        if ($res) {
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>''];
        }
    }

    // 新增-添加会员升级订单
    public static function addOrder($user_info, $request, $type = 1)
    {
        if ($type == 1) {
            // 获取唯一字符串标识
            $ord_unique_string = md5(md5($user_info->adm_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
        } else {
            // 获取唯一字符串标识
            $ord_unique_string = md5(md5($user_info->ussh_user_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
        }
        $ord_order_number = Comm::numberRule($user_info, 1);
        $data['ord_is_split'] = 1;
        $data['ord_cid'] = $user_info->adm_cid;
        $data['ord_superior_shop_id'] = $user_info->adm_shop_id;
        $data['ord_shop_id'] = $user_info->adm_shop_id;
        if ($type == 1) {
            $data['ord_create_id'] = $user_info->adm_id;
            $data['ord_client_id'] = $request['ord_client_id'];
        } else {
            $data['ord_create_id'] = 0;
            $data['ord_client_id'] = $user_info->ussh_user_id;
        }
        if($type == 1){//pc
            $data['ord_payment_way'] = 1; //结算方式1账期2现结
            $data['ord_wor_state'] = 20; //4已完成
            $data['ord_state'] = 2; //结算状态1未结算2已结算
            $data['ord_pay_state'] = 1; //是否支付1是2否
            $data['ord_actual_price'] = $request['meml_price']*100; //结算金额
            $data['ord_settlement_time'] = date('Y-m-d H:i:s'); //结算时间
        }else{//小程序
            $data['ord_payment_way'] = 0;//未支付
            $data['ord_wor_state'] = 2;
            $data['ord_state'] = 1; //结算状态1未结算2已结算
            $data['ord_pay_state'] = 2; //是否支付1是2否
            $data['ord_actual_price'] = 0; //结算金额
        }
        $data['ord_address'] = Db::table('shop')->where('shop_id', $user_info->adm_shop_id)->value('shop_store_name');
        $data['ord_address_id'] = $user_info->adm_shop_id;
        $data['ord_address_type'] = 1;
        $data['ord_order_number'] = $ord_order_number;
        $data['ord_type'] = 1;//买家类型：1门店零售2企业客户
        $data['ord_service_type'] = 7; //订单类型：1服务单 2洗车单3商品单4会员卡5会员升级 7 黑钻会员升级
        $data['ord_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['ord_source'] = $type;//下单来源1pc2车主小程序
        $data['ord_order_price'] = $request['meml_price']*100; //订单金额（前端传过来的金额单位是分，这里不*100）
        $data['ord_update_time'] = date('Y-m-d H:i:s');
        $data['ord_unique_string'] = $ord_unique_string;
        $data['ord_source'] = $type;  // 来源  1 pc  2 车主小程序   3 技师
        if(isset($request['rt'])){
            if($request['rt']=='wechat'){
                $data['ord_source'] = 3;
            }elseif($request['rt']=='wechatWash'){
                $data['ord_source'] = 2;
            }
        }
        $ord_id = NewOrderService::newOrder($data);
        //计算会员消费总金额
        if(isset($request['ord_client_id']) && !empty($request['ord_client_id'])){
            WashOrderService::consume_money($request['ord_client_id']);
        }

        // 查询手机号是否存在
        $find_weixin_data = DB::table('weixin_user')
            ->where('weus_phone', $request['orcl_phone'])
            ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
            ->first();
        // 选择的客户id，对应的订单数量增加
        if ($request['ord_client_id']) {
            $client_res = DB::table('member')
                ->where('mem_id', $request['ord_client_id'])
                ->increment('mem_order_all');
        }

        // 添加订单客户表数据
        $orcl_data = [
            'orcl_ord_id' => $ord_id,
            'orcl_client_id' => isset($request['ord_client_id']) ? $request['ord_client_id'] : 0, //选择客户id
            'orcl_name' => $request['orcl_name'],
            'orcl_phone' => $request['orcl_phone'],
            'orcl_car_num' => isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '',
            'orcl_province' => isset($request['orcl_province']) ? $request['orcl_province'] : '',
            'orcl_city' => isset($request['orcl_city']) ? $request['orcl_city'] : '',
            'orcl_county' => isset($request['orcl_county']) ? $request['orcl_county'] : '',
            'orcl_address' => isset($request['orcl_address']) ? $request['orcl_address'] : '',
            'orcl_shipment_party' => isset($request['orcl_shipment_party']) ? $request['orcl_shipment_party'] : 1, //出货方1自营仓库2直营店3加盟店4虚拟加盟店5我的门店(运营中心派单给门店)
            'orcl_update_time' => date('Y-m-d H:i:s'),
        ];

        $orcl_id = DB::table('order_client')->insertGetId($orcl_data);

        //订单商品
        $orgo_data['orgo_ord_id'] = $ord_id;
        $orgo_data['orgo_order_number'] = $ord_order_number;
        $orgo_data['orgo_goo_id'] = '';
        $orgo_data['orgo_goo_name'] = '升级黑钻会员';
        $orgo_data['orgo_goo_type'] = 5;
        $orgo_data['orgo_goo_price'] = $request['meml_price']*100;
        $orgo_data['orgo_state'] = 1;
        $orgo_data['orgo_goo_quantity'] = 1;
        $orgo_data['orgo_goo_unit'] = '次';
        $orgo_data['orgo_goo_unta_id'] = 0;
        $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
        $orgo_id = DB::table('order_goods')->insertGetId($orgo_data);



        $ord_edit_data['ord_orcl_id'] = $orcl_id;
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = DB::table('order')->where('ord_id', $ord_id)->update($ord_edit_data);
        $ord_data = DB::table('order')
            ->where('ord_id', $ord_id)
            ->select('ord_state', 'ord_wor_state', 'ord_type', 'ord_client_id')
            ->first();
        if ($ord_data->ord_state == 2 && ($ord_data->ord_wor_state == 4 || $ord_data->ord_wor_state == 20) && $ord_data->ord_type == 1) {//已结算 待评价或已完成 个人会员 添加积分
            $add_point = WashOrderBasicService::addPoint($user_info,$ord_data->ord_client_id,$ord_id);
        }
        if ($ord_id && $orcl_id && $ord_edit_res) {
            $return_data['ord_id'] = $ord_id; //订单id
            $return_data['ord_order_price'] = $data['ord_order_price']; //订单金额
            $return_data['ord_order_number'] = $ord_order_number; //订单单号
            //$return_data['goods_data'] = json_encode($goods_data); //商品信息
            $return_data['ord_type'] = 1; //买家类型1.会员零售2.企业客户
            $return_data['ord_client_id'] = isset($request['ord_client_id']) ? $request['ord_client_id'] : 0; //选择的客户id,会员id/单位id
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'新增失败'];
        }
    }

}